/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.critereon.CriterionTriggerRecipeUnlocked;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.IMaterial;

public class ShapelessRecipeBuilder
extends CraftingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory b;
    private final Item c;
    private final int d;
    private final List<RecipeItemStack> e = Lists.newArrayList();
    private final Advancement.SerializedAdvancement f = Advancement.SerializedAdvancement.b();
    @Nullable
    private String g;

    public ShapelessRecipeBuilder(RecipeCategory category, IMaterial output, int count) {
        this.b = category;
        this.c = output.k();
        this.d = count;
    }

    public static ShapelessRecipeBuilder a(RecipeCategory category, IMaterial output) {
        return new ShapelessRecipeBuilder(category, output, 1);
    }

    public static ShapelessRecipeBuilder a(RecipeCategory category, IMaterial output, int count) {
        return new ShapelessRecipeBuilder(category, output, count);
    }

    public ShapelessRecipeBuilder a(TagKey<Item> tag) {
        return this.a(RecipeItemStack.a(tag));
    }

    public ShapelessRecipeBuilder b(IMaterial itemProvider) {
        return this.a(itemProvider, 1);
    }

    public ShapelessRecipeBuilder a(IMaterial itemProvider, int size) {
        for (int i2 = 0; i2 < size; ++i2) {
            this.a(RecipeItemStack.a(itemProvider));
        }
        return this;
    }

    public ShapelessRecipeBuilder a(RecipeItemStack ingredient) {
        return this.a(ingredient, 1);
    }

    public ShapelessRecipeBuilder a(RecipeItemStack ingredient, int size) {
        for (int i2 = 0; i2 < size; ++i2) {
            this.e.add(ingredient);
        }
        return this;
    }

    @Override
    public ShapelessRecipeBuilder b(String string, CriterionInstance criterionTriggerInstance) {
        this.f.a(string, criterionTriggerInstance);
        return this;
    }

    @Override
    public ShapelessRecipeBuilder b(@Nullable String string) {
        this.g = string;
        return this;
    }

    @Override
    @Override
    public Item a() {
        return this.c;
    }

    @Override
    @Override
    public void a(Consumer<FinishedRecipe> exporter, MinecraftKey recipeId) {
        this.a(recipeId);
        this.f.a(a).a("has_the_recipe", CriterionTriggerRecipeUnlocked.a(recipeId)).a(AdvancementRewards.a.c(recipeId)).a(AdvancementRequirements.b);
        exporter.accept(new a(recipeId, this.c, this.d, this.g == null ? "" : this.g, ShapelessRecipeBuilder.a(this.b), this.e, this.f, recipeId.d("recipes/" + this.b.a() + "/")));
    }

    private void a(MinecraftKey recipeId) {
        if (this.f.d().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + recipeId);
        }
    }

    @Override
    public /* synthetic */ RecipeBuilder a(@Nullable String group) {
        return this.b(group);
    }

    @Override
    public /* synthetic */ RecipeBuilder a(String name, CriterionInstance conditions) {
        return this.b(name, conditions);
    }

    public static class a
    extends CraftingRecipeBuilder.a {
        private final MinecraftKey a;
        private final Item b;
        private final int c;
        private final String d;
        private final List<RecipeItemStack> e;
        private final Advancement.SerializedAdvancement f;
        private final MinecraftKey g;

        public a(MinecraftKey recipeId, Item output, int outputCount, String group, CraftingBookCategory craftingCategory, List<RecipeItemStack> inputs, Advancement.SerializedAdvancement advancementBuilder, MinecraftKey advancementId) {
            super(craftingCategory);
            this.a = recipeId;
            this.b = output;
            this.c = outputCount;
            this.d = group;
            this.e = inputs;
            this.f = advancementBuilder;
            this.g = advancementId;
        }

        @Override
        @Override
        public void a(JsonObject json) {
            super.a(json);
            if (!this.d.isEmpty()) {
                json.addProperty("group", this.d);
            }
            JsonArray jsonArray = new JsonArray();
            for (RecipeItemStack ingredient : this.e) {
                jsonArray.add(ingredient.c());
            }
            json.add("ingredients", (JsonElement)jsonArray);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", BuiltInRegistries.i.b(this.b).toString());
            if (this.c > 1) {
                jsonObject.addProperty("count", (Number)this.c);
            }
            json.add("result", (JsonElement)jsonObject);
        }

        @Override
        @Override
        public RecipeSerializer<?> c() {
            return RecipeSerializer.b;
        }

        @Override
        @Override
        public MinecraftKey b() {
            return this.a;
        }

        @Override
        @Nullable
        @Override
        public JsonObject d() {
            return this.f.c();
        }

        @Override
        @Nullable
        @Override
        public MinecraftKey e() {
            return this.g;
        }
    }
}

