/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.tags;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagRegistry;
import org.slf4j.Logger;

public abstract class TagsProvider<T>
implements DebugReportProvider {
    private static final Logger d = LogUtils.getLogger();
    protected final PackOutput.a e;
    private final CompletableFuture<HolderLookup.b> g;
    private final CompletableFuture<Void> h = new CompletableFuture();
    private final CompletableFuture<c<T>> i;
    protected final ResourceKey<? extends IRegistry<T>> f;
    private final Map<MinecraftKey, TagBuilder> j = Maps.newLinkedHashMap();

    protected TagsProvider(PackOutput output, ResourceKey<? extends IRegistry<T>> registryRef, CompletableFuture<HolderLookup.b> registryLookupFuture) {
        this(output, registryRef, registryLookupFuture, CompletableFuture.completedFuture(c.empty()));
    }

    protected TagsProvider(PackOutput output, ResourceKey<? extends IRegistry<T>> registryRef, CompletableFuture<HolderLookup.b> registryLookupFuture, CompletableFuture<c<T>> parentTagLookupFuture) {
        this.e = output.a(PackOutput.b.a, TagRegistry.a(registryRef));
        this.f = registryRef;
        this.i = parentTagLookupFuture;
        this.g = registryLookupFuture;
    }

    @Override
    @Override
    public final String a() {
        return "Tags for " + this.f.a();
    }

    protected abstract void a(HolderLookup.b var1);

    @Override
    @Override
    public CompletableFuture<?> a(CachedOutput writer) {
        record A<T>(HolderLookup.b a, c<T> b) {
            @Override
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{A.class, "contents;parent", "a", "b"}, this);
            }

            @Override
            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{A.class, "contents;parent", "a", "b"}, this);
            }

            @Override
            @Override
            public final boolean equals(Object object) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{A.class, "contents;parent", "a", "b"}, this, object);
            }
        }
        return ((CompletableFuture)((CompletableFuture)this.b().thenApply(registryLookupFuture -> {
            this.h.complete(null);
            return registryLookupFuture;
        })).thenCombineAsync(this.i, (lookup, parent) -> new A((HolderLookup.b)lookup, parent))).thenCompose(info -> {
            HolderLookup.c registryLookup = info.a.b(this.f);
            Predicate<MinecraftKey> predicate = id -> registryLookup.a(ResourceKey.a(this.f, id)).isPresent();
            Predicate<MinecraftKey> predicate2 = id -> this.j.containsKey(id) || arg.b.contains(TagKey.a(this.f, id));
            return CompletableFuture.allOf((CompletableFuture[])this.j.entrySet().stream().map(entry -> {
                MinecraftKey resourceLocation = (MinecraftKey)entry.getKey();
                TagBuilder tagBuilder = (TagBuilder)entry.getValue();
                List<TagEntry> list = tagBuilder.b();
                List<TagEntry> list2 = list.stream().filter(tagEntry -> !tagEntry.a(predicate, predicate2)).toList();
                if (!list2.isEmpty()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Couldn't define tag %s as it is missing following references: %s", resourceLocation, list2.stream().map(Objects::toString).collect(Collectors.joining(","))));
                }
                JsonElement jsonElement = (JsonElement)TagFile.a.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new TagFile(list, false)).getOrThrow(false, arg_0 -> ((Logger)d).error(arg_0));
                Path path = this.e.a(resourceLocation);
                return DebugReportProvider.a(writer, jsonElement, path);
            }).toArray(CompletableFuture[]::new));
        });
    }

    protected b<T> b(TagKey<T> tag) {
        TagBuilder tagBuilder = this.c(tag);
        return new b(tagBuilder);
    }

    protected TagBuilder c(TagKey<T> tag) {
        return this.j.computeIfAbsent(tag.b(), id -> TagBuilder.a());
    }

    public CompletableFuture<c<T>> c() {
        return this.h.thenApply(void_ -> tag -> Optional.ofNullable(this.j.get(tag.b())));
    }

    protected CompletableFuture<HolderLookup.b> b() {
        return this.g.thenApply(lookup -> {
            this.j.clear();
            this.a((HolderLookup.b)lookup);
            return lookup;
        });
    }

    @FunctionalInterface
    public static interface c<T>
    extends Function<TagKey<T>, Optional<TagBuilder>> {
        public static <T> c<T> empty() {
            return tag -> Optional.empty();
        }

        default public boolean contains(TagKey<T> tag) {
            return ((Optional)this.apply(tag)).isPresent();
        }
    }

    protected static class b<T> {
        private final TagBuilder a;

        protected b(TagBuilder builder) {
            this.a = builder;
        }

        public final b<T> a(ResourceKey<T> key) {
            this.a.a(key.a());
            return this;
        }

        @SafeVarargs
        public final b<T> a(ResourceKey<T> ... keys) {
            for (ResourceKey<T> resourceKey : keys) {
                this.a.a(resourceKey.a());
            }
            return this;
        }

        public b<T> a(MinecraftKey id) {
            this.a.b(id);
            return this;
        }

        public b<T> b(TagKey<T> identifiedTag) {
            this.a.c(identifiedTag.b());
            return this;
        }

        public b<T> b(MinecraftKey id) {
            this.a.d(id);
            return this;
        }
    }
}

