/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.gametest.framework.AfterBatch;
import net.minecraft.gametest.framework.BeforeBatch;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestGenerator;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.block.EnumBlockRotation;

public class GameTestHarnessRegistry {
    private static final Collection<GameTestHarnessTestFunction> a = Lists.newArrayList();
    private static final Set<String> b = Sets.newHashSet();
    private static final Map<String, Consumer<WorldServer>> c = Maps.newHashMap();
    private static final Map<String, Consumer<WorldServer>> d = Maps.newHashMap();
    private static final Collection<GameTestHarnessTestFunction> e = Sets.newHashSet();

    public static void a(Class<?> testClass) {
        Arrays.stream(testClass.getDeclaredMethods()).forEach(GameTestHarnessRegistry::a);
    }

    public static void a(Method method) {
        GameTestGenerator gameTestGenerator;
        String string = method.getDeclaringClass().getSimpleName();
        GameTest gameTest = method.getAnnotation(GameTest.class);
        if (gameTest != null) {
            a.add(GameTestHarnessRegistry.c(method));
            b.add(string);
        }
        if ((gameTestGenerator = method.getAnnotation(GameTestGenerator.class)) != null) {
            a.addAll(GameTestHarnessRegistry.b(method));
            b.add(string);
        }
        GameTestHarnessRegistry.a(method, BeforeBatch.class, BeforeBatch::a, c);
        GameTestHarnessRegistry.a(method, AfterBatch.class, AfterBatch::a, d);
    }

    private static <T extends Annotation> void a(Method method, Class<T> clazz, Function<T, String> batchIdFunction, Map<String, Consumer<WorldServer>> batchConsumerMap) {
        String string;
        Consumer<?> consumer;
        T annotation = method.getAnnotation(clazz);
        if (annotation != null && (consumer = batchConsumerMap.putIfAbsent(string = batchIdFunction.apply(annotation), GameTestHarnessRegistry.d(method))) != null) {
            throw new RuntimeException("Hey, there should only be one " + clazz + " method per batch. Batch '" + string + "' has more than one!");
        }
    }

    public static Collection<GameTestHarnessTestFunction> a(String testClass) {
        return a.stream().filter(testFunction -> GameTestHarnessRegistry.a(testFunction, testClass)).collect(Collectors.toList());
    }

    public static Collection<GameTestHarnessTestFunction> a() {
        return a;
    }

    public static Collection<String> b() {
        return b;
    }

    public static boolean b(String testClass) {
        return b.contains(testClass);
    }

    @Nullable
    public static Consumer<WorldServer> c(String batchId) {
        return c.get(batchId);
    }

    @Nullable
    public static Consumer<WorldServer> d(String batchId) {
        return d.get(batchId);
    }

    public static Optional<GameTestHarnessTestFunction> e(String structurePath) {
        return GameTestHarnessRegistry.a().stream().filter(testFunction -> testFunction.a().equalsIgnoreCase(structurePath)).findFirst();
    }

    public static GameTestHarnessTestFunction f(String structurePath) {
        Optional<GameTestHarnessTestFunction> optional = GameTestHarnessRegistry.e(structurePath);
        if (!optional.isPresent()) {
            throw new IllegalArgumentException("Can't find the test function for " + structurePath);
        }
        return optional.get();
    }

    private static Collection<GameTestHarnessTestFunction> b(Method method) {
        try {
            Object object = method.getDeclaringClass().newInstance();
            return (Collection)method.invoke(object, new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    private static GameTestHarnessTestFunction c(Method method) {
        GameTest gameTest = method.getAnnotation(GameTest.class);
        String string = method.getDeclaringClass().getSimpleName();
        String string2 = string.toLowerCase();
        String string3 = string2 + "." + method.getName().toLowerCase();
        String string4 = gameTest.e().isEmpty() ? string3 : string2 + "." + gameTest.e();
        String string5 = gameTest.b();
        EnumBlockRotation rotation = GameTestHarnessStructures.a(gameTest.c());
        return new GameTestHarnessTestFunction(string5, string3, string4, rotation, gameTest.a(), gameTest.f(), gameTest.d(), gameTest.h(), gameTest.g(), GameTestHarnessRegistry.d(method));
    }

    private static Consumer<?> d(Method method) {
        return args -> {
            try {
                Object object = method.getDeclaringClass().newInstance();
                method.invoke(object, args);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)invocationTargetException.getCause();
                }
                throw new RuntimeException(invocationTargetException.getCause());
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new RuntimeException(reflectiveOperationException);
            }
        };
    }

    private static boolean a(GameTestHarnessTestFunction testFunction, String testClass) {
        return testFunction.a().toLowerCase().startsWith(testClass.toLowerCase() + ".");
    }

    public static Collection<GameTestHarnessTestFunction> c() {
        return e;
    }

    public static void a(GameTestHarnessTestFunction testFunction) {
        e.add(testFunction);
    }

    public static void d() {
        e.clear();
    }
}

