/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public class NBTTagByteArray
extends NBTList<NBTTagByte> {
    private static final int b = 24;
    public static final NBTTagType<NBTTagByteArray> a = new NBTTagType.b<NBTTagByteArray>(){

        public NBTTagByteArray a(DataInput input, int depth, NBTReadLimiter tracker) throws IOException {
            tracker.a(24L);
            int j2 = input.readInt();
            Preconditions.checkArgument((j2 < 0x1000000 ? 1 : 0) != 0);
            tracker.a(1L * (long)j2);
            byte[] abyte = new byte[j2];
            input.readFully(abyte);
            return new NBTTagByteArray(abyte);
        }

        @Override
        public StreamTagVisitor.b a(DataInput input, StreamTagVisitor visitor) throws IOException {
            int i2 = input.readInt();
            byte[] abyte = new byte[i2];
            input.readFully(abyte);
            return visitor.a(abyte);
        }

        @Override
        public void a(DataInput input) throws IOException {
            input.skipBytes(input.readInt() * 1);
        }

        @Override
        public String a() {
            return "BYTE[]";
        }

        @Override
        public String b() {
            return "TAG_Byte_Array";
        }
    };
    private byte[] c;

    public NBTTagByteArray(byte[] value) {
        this.c = value;
    }

    public NBTTagByteArray(List<Byte> value) {
        this(NBTTagByteArray.a(value));
    }

    private static byte[] a(List<Byte> list) {
        byte[] abyte = new byte[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Byte obyte = list.get(i2);
            abyte[i2] = obyte == null ? (byte)0 : obyte;
        }
        return abyte;
    }

    @Override
    public void a(DataOutput output) throws IOException {
        output.writeInt(this.c.length);
        output.write(this.c);
    }

    @Override
    public int a() {
        return 24 + 1 * this.c.length;
    }

    @Override
    public byte b() {
        return 7;
    }

    public NBTTagType<NBTTagByteArray> c() {
        return a;
    }

    @Override
    public String toString() {
        return this.m_();
    }

    @Override
    public NBTBase d() {
        byte[] abyte = new byte[this.c.length];
        System.arraycopy(this.c, 0, abyte, 0, this.c.length);
        return new NBTTagByteArray(abyte);
    }

    @Override
    public boolean equals(Object object) {
        return this == object ? true : object instanceof NBTTagByteArray && Arrays.equals(this.c, ((NBTTagByteArray)object).c);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.c);
    }

    @Override
    public void a(TagVisitor visitor) {
        visitor.a(this);
    }

    public byte[] e() {
        return this.c;
    }

    @Override
    public int size() {
        return this.c.length;
    }

    public NBTTagByte a(int i2) {
        return NBTTagByte.a(this.c[i2]);
    }

    public NBTTagByte a(int i2, NBTTagByte nbttagbyte) {
        byte b0 = this.c[i2];
        this.c[i2] = nbttagbyte.i();
        return NBTTagByte.a(b0);
    }

    public void b(int i2, NBTTagByte nbttagbyte) {
        this.c = ArrayUtils.add((byte[])this.c, (int)i2, (byte)nbttagbyte.i());
    }

    @Override
    public boolean a(int index, NBTBase element) {
        if (element instanceof NBTNumber) {
            this.c[index] = ((NBTNumber)element).i();
            return true;
        }
        return false;
    }

    @Override
    public boolean b(int index, NBTBase element) {
        if (element instanceof NBTNumber) {
            this.c = ArrayUtils.add((byte[])this.c, (int)index, (byte)((NBTNumber)element).i());
            return true;
        }
        return false;
    }

    public NBTTagByte b(int i2) {
        byte b0 = this.c[i2];
        this.c = ArrayUtils.remove((byte[])this.c, (int)i2);
        return NBTTagByte.a(b0);
    }

    @Override
    public byte f() {
        return 1;
    }

    @Override
    public void clear() {
        this.c = new byte[0];
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor visitor) {
        return visitor.a(this.c);
    }
}

