/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.velocitypowered.natives.Native;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.util.MoreByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import java.util.List;
import java.util.zip.Inflater;
import net.minecraft.network.PacketDataSerializer;

public class PacketDecompressor
extends ByteToMessageDecoder {
    public static final int a = 0x200000;
    public static final int b = 0x800000;
    private final Inflater c;
    private final VelocityCompressor compressor;
    private int d;
    private boolean e;

    public PacketDecompressor(int compressionThreshold, boolean rejectsBadPackets) {
        this(null, compressionThreshold, rejectsBadPackets);
    }

    public PacketDecompressor(VelocityCompressor compressor, int compressionThreshold, boolean rejectsBadPackets) {
        this.d = compressionThreshold;
        this.e = rejectsBadPackets;
        this.c = compressor == null ? new Inflater() : null;
        this.compressor = compressor;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        if (byteBuf.readableBytes() != 0) {
            PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(byteBuf);
            int i2 = friendlyByteBuf.m();
            if (i2 == 0) {
                list.add(friendlyByteBuf.readBytes(friendlyByteBuf.readableBytes()));
            } else {
                if (this.e) {
                    if (i2 < this.d) {
                        throw new DecoderException("Badly compressed packet - size of " + i2 + " is below server threshold of " + this.d);
                    }
                    if (i2 > 0x800000) {
                        throw new DecoderException("Badly compressed packet - size of " + i2 + " is larger than protocol maximum of 8388608");
                    }
                }
                if (this.c != null) {
                    byte[] bs = new byte[friendlyByteBuf.readableBytes()];
                    friendlyByteBuf.readBytes(bs);
                    this.c.setInput(bs);
                    byte[] cs = new byte[i2];
                    this.c.inflate(cs);
                    list.add(Unpooled.wrappedBuffer((byte[])cs));
                    this.c.reset();
                    return;
                }
                int claimedUncompressedSize = i2;
                ByteBuf compatibleIn = MoreByteBufUtils.ensureCompatible((ByteBufAllocator)channelHandlerContext.alloc(), (Native)this.compressor, (ByteBuf)byteBuf);
                ByteBuf uncompressed = MoreByteBufUtils.preferredBuffer((ByteBufAllocator)channelHandlerContext.alloc(), (Native)this.compressor, (int)claimedUncompressedSize);
                try {
                    this.compressor.inflate(compatibleIn, uncompressed, claimedUncompressedSize);
                    list.add(uncompressed);
                    byteBuf.clear();
                }
                catch (Exception e2) {
                    uncompressed.release();
                    throw e2;
                }
                finally {
                    compatibleIn.release();
                }
            }
        }
    }

    public void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        if (this.compressor != null) {
            this.compressor.close();
        }
    }

    public void a(int compressionThreshold, boolean rejectsBadPackets) {
        this.d = compressionThreshold;
        this.e = rejectsBadPackets;
    }
}

