/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixUtils;
import io.papermc.paper.adventure.AdventureComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.locale.LocaleLanguage;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.Entity;

public class ChatComponentUtils {
    public static final String a = ", ";
    public static final IChatBaseComponent b = IChatBaseComponent.b(", ").a(EnumChatFormat.h);
    public static final IChatBaseComponent c = IChatBaseComponent.b(", ");

    public static IChatMutableComponent a(IChatMutableComponent text, ChatModifier style) {
        if (style.g()) {
            return text;
        }
        ChatModifier style2 = text.a();
        if (style2.g()) {
            return text.b(style);
        }
        return style2.equals(style) ? text : text.b(style2.a(style));
    }

    public static Optional<IChatMutableComponent> a(@Nullable CommandListenerWrapper source, Optional<IChatBaseComponent> text, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        return text.isPresent() ? Optional.of(ChatComponentUtils.a(source, text.get(), sender, depth)) : Optional.empty();
    }

    public static IChatMutableComponent a(@Nullable CommandListenerWrapper source, IChatBaseComponent text, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        if (depth > 100) {
            return text.e();
        }
        if (text instanceof AdventureComponent) {
            AdventureComponent adventureComponent = (AdventureComponent)text;
            text = adventureComponent.deepConverted();
        }
        IChatMutableComponent mutableComponent = text.b().a(source, sender, depth + 1);
        for (IChatBaseComponent component : text.c()) {
            mutableComponent.b(ChatComponentUtils.a(source, component, sender, depth + 1));
        }
        return mutableComponent.c(ChatComponentUtils.a(source, text.a(), sender, depth));
    }

    private static ChatModifier a(@Nullable CommandListenerWrapper source, ChatModifier style, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        IChatBaseComponent component;
        ChatHoverable hoverEvent = style.i();
        if (hoverEvent != null && (component = hoverEvent.a(ChatHoverable.EnumHoverAction.a)) != null) {
            ChatHoverable hoverEvent2 = new ChatHoverable(ChatHoverable.EnumHoverAction.a, ChatComponentUtils.a(source, component, sender, depth + 1));
            return style.a(hoverEvent2);
        }
        return style;
    }

    public static IChatBaseComponent a(GameProfile profile) {
        if (profile.getName() != null) {
            return IChatBaseComponent.b(profile.getName());
        }
        return profile.getId() != null ? IChatBaseComponent.b(profile.getId().toString()) : IChatBaseComponent.b("(unknown)");
    }

    public static IChatBaseComponent a(Collection<String> strings) {
        return ChatComponentUtils.a(strings, (T string) -> IChatBaseComponent.b(string).a(EnumChatFormat.k));
    }

    public static <T extends Comparable<T>> IChatBaseComponent a(Collection<T> elements, Function<T, IChatBaseComponent> transformer) {
        if (elements.isEmpty()) {
            return CommonComponents.a;
        }
        if (elements.size() == 1) {
            return transformer.apply((Comparable)elements.iterator().next());
        }
        ArrayList list = Lists.newArrayList(elements);
        list.sort(Comparable::compareTo);
        return ChatComponentUtils.b(list, transformer);
    }

    public static <T> IChatBaseComponent b(Collection<? extends T> elements, Function<T, IChatBaseComponent> transformer) {
        return ChatComponentUtils.a(elements, b, transformer);
    }

    public static <T> IChatMutableComponent a(Collection<? extends T> elements, Optional<? extends IChatBaseComponent> separator, Function<T, IChatBaseComponent> transformer) {
        return ChatComponentUtils.a(elements, (IChatBaseComponent)DataFixUtils.orElse(separator, (Object)b), transformer);
    }

    public static IChatBaseComponent a(Collection<? extends IChatBaseComponent> texts, IChatBaseComponent separator) {
        return ChatComponentUtils.a(texts, separator, Function.identity());
    }

    public static <T> IChatMutableComponent a(Collection<? extends T> elements, IChatBaseComponent separator, Function<T, IChatBaseComponent> transformer) {
        if (elements.isEmpty()) {
            return IChatBaseComponent.h();
        }
        if (elements.size() == 1) {
            return transformer.apply(elements.iterator().next()).e();
        }
        IChatMutableComponent mutableComponent = IChatBaseComponent.h();
        boolean bl = true;
        for (T object : elements) {
            if (!bl) {
                mutableComponent.b(separator);
            }
            mutableComponent.b(transformer.apply(object));
            bl = false;
        }
        return mutableComponent;
    }

    public static IChatMutableComponent a(IChatBaseComponent text) {
        return IChatBaseComponent.a("chat.square_brackets", text);
    }

    public static IChatBaseComponent a(Message message) {
        return message instanceof IChatBaseComponent ? (IChatBaseComponent)message : IChatBaseComponent.b(message.getString());
    }

    public static boolean b(@Nullable IChatBaseComponent text) {
        ComponentContents string;
        if (text != null && (string = text.b()) instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)string;
            String string2 = translatableContents.b();
            return string2 != null || LocaleLanguage.a().b(translatableContents.a());
        }
        return true;
    }

    public static IChatMutableComponent a(String string) {
        return ChatComponentUtils.a(IChatBaseComponent.b(string).a(style -> style.a(EnumChatFormat.k).a(new ChatClickable(ChatClickable.EnumClickAction.f, string)).a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, IChatBaseComponent.c("chat.copy.click"))).a(string)));
    }
}

