/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;

public final class ChatHexColor {
    private static final String b = "#";
    public static final Codec<ChatHexColor> a = Codec.STRING.comapFlatMap(s2 -> {
        ChatHexColor chathexcolor = ChatHexColor.a(s2);
        return chathexcolor != null ? DataResult.success((Object)chathexcolor) : DataResult.error(() -> "String is not a valid color name or hex color code");
    }, ChatHexColor::b);
    private static final Map<EnumChatFormat, ChatHexColor> c = (Map)Stream.of(EnumChatFormat.values()).filter(EnumChatFormat::e).collect(ImmutableMap.toImmutableMap(Function.identity(), enumchatformat -> new ChatHexColor(enumchatformat.f(), enumchatformat.g(), (EnumChatFormat)enumchatformat)));
    private static final Map<String, ChatHexColor> d = (Map)c.values().stream().collect(ImmutableMap.toImmutableMap(chathexcolor -> chathexcolor.f, Function.identity()));
    private final int e;
    @Nullable
    public final String f;
    @Nullable
    public final EnumChatFormat format;

    private ChatHexColor(int i2, String s2, EnumChatFormat format) {
        this.e = i2;
        this.f = s2;
        this.format = format;
    }

    private ChatHexColor(int rgb) {
        this.e = rgb;
        this.f = null;
        this.format = null;
    }

    public int a() {
        return this.e;
    }

    public String b() {
        return this.f != null ? this.f : this.c();
    }

    private String c() {
        return String.format(Locale.ROOT, "#%06X", this.e);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            ChatHexColor chathexcolor = (ChatHexColor)object;
            return this.e == chathexcolor.e;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.e, this.f);
    }

    public String toString() {
        return this.f != null ? this.f : this.c();
    }

    @Nullable
    public static ChatHexColor a(EnumChatFormat formatting) {
        return c.get(formatting);
    }

    public static ChatHexColor a(int rgb) {
        return new ChatHexColor(rgb);
    }

    @Nullable
    public static ChatHexColor a(String name) {
        if (name.startsWith(b)) {
            try {
                int i2 = Integer.parseInt(name.substring(1), 16);
                return ChatHexColor.a(i2);
            }
            catch (NumberFormatException numberformatexception) {
                return null;
            }
        }
        return d.get(name);
    }
}

