/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import javax.annotation.Nullable;
import net.kyori.adventure.chat.SignedMessage;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SignatureUpdater;
import net.minecraft.util.SignatureValidator;

public final class MessageSignature
extends Record {
    private final byte[] c;
    public static final Codec<MessageSignature> a = ExtraCodecs.n.xmap(MessageSignature::new, MessageSignature::b);
    public static final int b = 256;

    public MessageSignature(byte[] bytes) {
        Preconditions.checkState((bytes.length == 256 ? 1 : 0) != 0, (Object)"Invalid message signature size");
        this.c = bytes;
    }

    public SignedMessage.Signature adventure() {
        return () -> this.c;
    }

    public static MessageSignature a(PacketDataSerializer buf) {
        byte[] bs = new byte[256];
        buf.readBytes(bs);
        return new MessageSignature(bs);
    }

    public static void a(PacketDataSerializer buf, MessageSignature signature) {
        buf.writeBytes(signature.c);
    }

    public boolean a(SignatureValidator verifier, SignatureUpdater updatable) {
        return verifier.validate(updatable, this.c);
    }

    public ByteBuffer a() {
        return ByteBuffer.wrap(this.c);
    }

    @Override
    public boolean equals(Object object) {
        if (this != object) {
            if (object instanceof MessageSignature) {
                MessageSignature messageSignature = (MessageSignature)object;
                if (Arrays.equals(this.c, messageSignature.c)) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.c);
    }

    @Override
    public String toString() {
        return Base64.getEncoder().encodeToString(this.c);
    }

    public a a(MessageSignatureCache storage) {
        int i2 = storage.a(this);
        return i2 != -1 ? new a(i2) : new a(this);
    }

    public byte[] b() {
        return this.c;
    }

    public static final class a
    extends Record {
        private final int b;
        @Nullable
        private final MessageSignature c;
        public static final int a = -1;

        public a(MessageSignature signature) {
            this(-1, signature);
        }

        public a(int id) {
            this(id, null);
        }

        public a(int id, @Nullable MessageSignature fullSignature) {
            this.b = id;
            this.c = fullSignature;
        }

        public static a a(PacketDataSerializer buf) {
            int i2 = buf.m() - 1;
            return i2 == -1 ? new a(MessageSignature.a(buf)) : new a(i2);
        }

        public static void a(PacketDataSerializer buf, a indexed) {
            buf.d(indexed.a() + 1);
            if (indexed.b() != null) {
                MessageSignature.a(buf, indexed.b());
            }
        }

        public Optional<MessageSignature> a(MessageSignatureCache storage) {
            return this.c != null ? Optional.of(this.c) : Optional.ofNullable(storage.a(this.b));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "id;fullSignature", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "id;fullSignature", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "id;fullSignature", "b", "c"}, this, o2);
        }

        public int a() {
            return this.b;
        }

        @Nullable
        public MessageSignature b() {
            return this.c;
        }
    }
}

