/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.primitives.Ints;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.adventure.AdventureComponent;
import io.papermc.paper.adventure.PaperAdventure;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.security.SignatureException;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.minecraft.SystemUtils;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageLink;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SignatureUpdater;
import net.minecraft.util.SignatureValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PlayerChatMessage(SignedMessageLink d, @javax.annotation.Nullable MessageSignature e, SignedMessageBody f, @javax.annotation.Nullable IChatBaseComponent g, FilterMask h, @javax.annotation.Nullable ChatDecorator.Result result) {
    private final SignedMessageLink d;
    @javax.annotation.Nullable
    private final MessageSignature e;
    private final SignedMessageBody f;
    @javax.annotation.Nullable
    private final IChatBaseComponent g;
    private final FilterMask h;
    public static final MapCodec<PlayerChatMessage> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SignedMessageLink.a.fieldOf("link").forGetter(PlayerChatMessage::j), (App)MessageSignature.a.optionalFieldOf("signature").forGetter(message -> Optional.ofNullable(message.e)), (App)SignedMessageBody.a.forGetter(PlayerChatMessage::l), (App)ExtraCodecs.b.optionalFieldOf("unsigned_content").forGetter(message -> Optional.ofNullable(message.g)), (App)FilterMask.a.optionalFieldOf("filter_mask", (Object)FilterMask.c).forGetter(PlayerChatMessage::n)).apply((Applicative)instance, (link, signature, signedBody, unsignedContent, filterMask) -> new PlayerChatMessage((SignedMessageLink)link, signature.orElse(null), (SignedMessageBody)signedBody, unsignedContent.orElse(null), (FilterMask)filterMask)));
    private static final UUID i = SystemUtils.c;
    public static final Duration b = Duration.ofMinutes(5L);
    public static final Duration c = b.plus(Duration.ofMinutes(2L));

    public PlayerChatMessage(SignedMessageLink link, @javax.annotation.Nullable MessageSignature signature, SignedMessageBody signedBody, @javax.annotation.Nullable IChatBaseComponent unsignedContent, FilterMask filterMask) {
        this(link, signature, signedBody, unsignedContent, filterMask, null);
    }

    public PlayerChatMessage withResult(ChatDecorator.Result result) {
        PlayerChatMessage msg = this.a(result.component());
        return new PlayerChatMessage(msg.d, msg.e, msg.f, msg.g, msg.h, result);
    }

    public ChatDecorator.Result requireResult() {
        return Objects.requireNonNull(this.result, "Requires a decoration result to be set here");
    }

    public AdventureView adventureView() {
        return new AdventureView();
    }

    public static PlayerChatMessage a(String content) {
        return PlayerChatMessage.a(i, content);
    }

    public static PlayerChatMessage a(UUID sender, String content) {
        SignedMessageBody signedMessageBody = SignedMessageBody.a(content);
        SignedMessageLink signedMessageLink = SignedMessageLink.a(sender);
        return new PlayerChatMessage(signedMessageLink, null, signedMessageBody, null, FilterMask.c);
    }

    public PlayerChatMessage a(IChatBaseComponent unsignedContent) {
        IChatBaseComponent iChatBaseComponent;
        if (unsignedContent instanceof AdventureComponent) {
            AdventureComponent advComponent = (AdventureComponent)unsignedContent;
            iChatBaseComponent = advComponent.deepConverted();
        } else {
            iChatBaseComponent = unsignedContent;
        }
        IChatBaseComponent component = !iChatBaseComponent.equals(IChatBaseComponent.b(this.b())) ? unsignedContent : null;
        return new PlayerChatMessage(this.d, this.e, this.f, component, this.h);
    }

    public PlayerChatMessage a() {
        return this.g != null ? new PlayerChatMessage(this.d, this.e, this.f, null, this.h) : this;
    }

    public PlayerChatMessage a(FilterMask filterMask) {
        return this.h.equals(filterMask) ? this : new PlayerChatMessage(this.d, this.e, this.f, this.g, filterMask);
    }

    public PlayerChatMessage a(boolean enabled) {
        return this.a(enabled ? this.h : FilterMask.c);
    }

    public static void a(SignatureUpdater.a updater, SignedMessageLink link, SignedMessageBody body) throws SignatureException {
        updater.update(Ints.toByteArray((int)1));
        link.a(updater);
        body.a(updater);
    }

    public boolean a(SignatureValidator verifier) {
        return this.e != null && this.e.a(verifier, updater -> PlayerChatMessage.a(updater, this.d, this.f));
    }

    public String b() {
        return this.f.a();
    }

    public IChatBaseComponent c() {
        return Objects.requireNonNullElseGet(this.g, () -> IChatBaseComponent.b(this.b()));
    }

    public Instant d() {
        return this.f.b();
    }

    public long e() {
        return this.f.c();
    }

    public boolean a(Instant currentTime) {
        return currentTime.isAfter(this.d().plus(b));
    }

    public boolean b(Instant currentTime) {
        return currentTime.isAfter(this.d().plus(c));
    }

    public UUID f() {
        return this.d.c();
    }

    public boolean g() {
        return this.f().equals(i);
    }

    public boolean h() {
        return this.e != null;
    }

    public boolean a(UUID sender) {
        return this.h() && this.d.c().equals(sender);
    }

    public boolean i() {
        return this.h.b();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{PlayerChatMessage.class, "link;signature;signedBody;unsignedContent;filterMask;result", "d", "e", "f", "g", "h", "result"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PlayerChatMessage.class, "link;signature;signedBody;unsignedContent;filterMask;result", "d", "e", "f", "g", "h", "result"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PlayerChatMessage.class, "link;signature;signedBody;unsignedContent;filterMask;result", "d", "e", "f", "g", "h", "result"}, this, o2);
    }

    public SignedMessageLink j() {
        return this.d;
    }

    @javax.annotation.Nullable
    public MessageSignature k() {
        return this.e;
    }

    public SignedMessageBody l() {
        return this.f;
    }

    @javax.annotation.Nullable
    public IChatBaseComponent m() {
        return this.g;
    }

    public FilterMask n() {
        return this.h;
    }

    public final class AdventureView
    implements SignedMessage {
        private AdventureView() {
        }

        @NotNull
        public Instant timestamp() {
            return PlayerChatMessage.this.d();
        }

        public long salt() {
            return PlayerChatMessage.this.e();
        }

        @Nullable
        public SignedMessage.Signature signature() {
            return PlayerChatMessage.this.e == null ? null : PlayerChatMessage.this.e.adventure();
        }

        public @Nullable Component unsignedContent() {
            return PlayerChatMessage.this.m() == null ? null : PaperAdventure.asAdventure(PlayerChatMessage.this.m());
        }

        @NotNull
        public String message() {
            return PlayerChatMessage.this.b();
        }

        @NotNull
        public Identity identity() {
            return Identity.identity((UUID)PlayerChatMessage.this.f());
        }

        public PlayerChatMessage playerChatMessage() {
            return PlayerChatMessage.this;
        }
    }
}

