/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.util.FormattedString;
import net.minecraft.util.StringDecomposer;

public class SubStringSource {
    private final String a;
    private final List<ChatModifier> b;
    private final Int2IntFunction c;

    private SubStringSource(String string, List<ChatModifier> styles, Int2IntFunction reverser) {
        this.a = string;
        this.b = ImmutableList.copyOf(styles);
        this.c = reverser;
    }

    public String a() {
        return this.a;
    }

    public List<FormattedString> a(int start, int length, boolean reverse) {
        if (length == 0) {
            return ImmutableList.of();
        }
        ArrayList list = Lists.newArrayList();
        ChatModifier style = this.b.get(start);
        int i2 = start;
        for (int j2 = 1; j2 < length; ++j2) {
            int k2 = start + j2;
            ChatModifier style2 = this.b.get(k2);
            if (style2.equals(style)) continue;
            String string = this.a.substring(i2, k2);
            list.add(reverse ? FormattedString.backward(string, style, this.c) : FormattedString.forward(string, style));
            style = style2;
            i2 = k2;
        }
        if (i2 < start + length) {
            String string2 = this.a.substring(i2, start + length);
            list.add(reverse ? FormattedString.backward(string2, style, this.c) : FormattedString.forward(string2, style));
        }
        return reverse ? Lists.reverse((List)list) : list;
    }

    public static SubStringSource a(IChatFormatted visitable) {
        return SubStringSource.a(visitable, codePoint -> codePoint, string -> string);
    }

    public static SubStringSource a(IChatFormatted visitable, Int2IntFunction reverser, UnaryOperator<String> shaper) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList list = Lists.newArrayList();
        visitable.a((style2, text) -> {
            StringDecomposer.c(text, style2, (charIndex, style, codePoint) -> {
                stringBuilder.appendCodePoint(codePoint);
                int i2 = Character.charCount(codePoint);
                for (int j2 = 0; j2 < i2; ++j2) {
                    list.add(style);
                }
                return true;
            });
            return Optional.empty();
        }, ChatModifier.a);
        return new SubStringSource((String)shaper.apply(stringBuilder.toString()), list, reverser);
    }
}

