/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.world.entity.Entity;

public record EntityDataSource(String a, @Nullable EntitySelector b) implements DataSource
{
    public EntityDataSource(String rawPath) {
        this(rawPath, EntityDataSource.a(rawPath));
    }

    @Nullable
    private static EntitySelector a(String rawSelector) {
        try {
            ArgumentParserSelector entitySelectorParser = new ArgumentParserSelector(new StringReader(rawSelector));
            return entitySelectorParser.t();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return null;
        }
    }

    @Override
    @Override
    public Stream<NBTTagCompound> getData(CommandListenerWrapper source) throws CommandSyntaxException {
        if (this.b != null) {
            List<? extends Entity> list = this.b.b(source);
            return list.stream().map(CriterionConditionNBT::b);
        }
        return Stream.empty();
    }

    @Override
    @Override
    public String toString() {
        return "entity=" + this.a;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EntityDataSource)) return false;
        EntityDataSource entityDataSource = (EntityDataSource)object;
        if (!this.a.equals(entityDataSource.a)) return false;
        return true;
    }

    @Override
    @Override
    public int hashCode() {
        return this.a.hashCode();
    }
}

