/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.locale.LocaleLanguage;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.TranslatableFormatException;
import net.minecraft.world.entity.Entity;

public class TranslatableContents
implements ComponentContents {
    public static final Object[] b = new Object[0];
    private static final IChatFormatted c = IChatFormatted.e("%");
    private static final IChatFormatted d = IChatFormatted.e("null");
    private final String e;
    @Nullable
    private final String f;
    private final Object[] g;
    @Nullable
    private LocaleLanguage h;
    private List<IChatFormatted> i = ImmutableList.of();
    private static final Pattern j = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public TranslatableContents(String key, @Nullable String fallback, Object[] args) {
        this.e = key;
        this.f = fallback;
        this.g = args;
    }

    private void d() {
        LocaleLanguage language = LocaleLanguage.a();
        if (language == this.h) {
            return;
        }
        this.h = language;
        String string = this.f != null ? language.a(this.e, this.f) : language.a(this.e);
        try {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.a(string, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            this.i = builder.build();
        }
        catch (TranslatableFormatException translatableFormatException) {
            this.i = ImmutableList.of((Object)IChatFormatted.e(string));
        }
    }

    private void a(String translation, Consumer<IChatFormatted> partsConsumer) {
        Matcher matcher = j.matcher(translation);
        try {
            int i2 = 0;
            int j2 = 0;
            while (matcher.find(j2)) {
                int k2 = matcher.start();
                int l2 = matcher.end();
                if (k2 > j2) {
                    String string = translation.substring(j2, k2);
                    if (string.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    partsConsumer.accept(IChatFormatted.e(string));
                }
                String string2 = matcher.group(2);
                String string3 = translation.substring(k2, l2);
                if ("%".equals(string2) && "%%".equals(string3)) {
                    partsConsumer.accept(c);
                } else if ("s".equals(string2)) {
                    String string4 = matcher.group(1);
                    int m2 = string4 != null ? Integer.parseInt(string4) - 1 : i2++;
                    partsConsumer.accept(this.a(m2));
                } else {
                    throw new TranslatableFormatException(this, "Unsupported format: '" + string3 + "'");
                }
                j2 = l2;
            }
            if (j2 < translation.length()) {
                String string5 = translation.substring(j2);
                if (string5.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                partsConsumer.accept(IChatFormatted.e(string5));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TranslatableFormatException(this, (Throwable)illegalArgumentException);
        }
    }

    private IChatFormatted a(int index) {
        if (index < 0 || index >= this.g.length) {
            throw new TranslatableFormatException(this, index);
        }
        Object object = this.g[index];
        if (object instanceof IChatBaseComponent) {
            return (IChatBaseComponent)object;
        }
        return object == null ? d : IChatFormatted.e(object.toString());
    }

    @Override
    @Override
    public <T> Optional<T> a(IChatFormatted.b<T> visitor, ChatModifier style) {
        this.d();
        for (IChatFormatted formattedText : this.i) {
            Optional<T> optional = formattedText.a(visitor, style);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    @Override
    public <T> Optional<T> a(IChatFormatted.a<T> visitor) {
        this.d();
        for (IChatFormatted formattedText : this.i) {
            Optional<T> optional = formattedText.a(visitor);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    @Override
    public IChatMutableComponent a(@Nullable CommandListenerWrapper source, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        Object[] objects = new Object[this.g.length];
        for (int i2 = 0; i2 < objects.length; ++i2) {
            Object object = this.g[i2];
            objects[i2] = object instanceof IChatBaseComponent ? ChatComponentUtils.a(source, (IChatBaseComponent)object, sender, depth) : object;
        }
        return IChatMutableComponent.a(new TranslatableContents(this.e, this.f, objects));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TranslatableContents)) return false;
        TranslatableContents translatableContents = (TranslatableContents)object;
        if (!Objects.equals(this.e, translatableContents.e)) return false;
        if (!Objects.equals(this.f, translatableContents.f)) return false;
        if (!Arrays.equals(this.g, translatableContents.g)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int i2 = Objects.hashCode(this.e);
        i2 = 31 * i2 + Objects.hashCode(this.f);
        i2 = 31 * i2 + Arrays.hashCode(this.g);
        return i2;
    }

    @Override
    public String toString() {
        return "translation{key='" + this.e + "'" + (String)(this.f != null ? ", fallback='" + this.f + "'" : "") + ", args=" + Arrays.toString(this.g) + "}";
    }

    public String a() {
        return this.e;
    }

    @Nullable
    public String b() {
        return this.f;
    }

    public Object[] c() {
        return this.g;
    }
}

