/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.game.DebugEntityNameGenerator;
import net.minecraft.network.protocol.game.PacketPlayOutCustomPayload;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.UtilColor;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import net.minecraft.world.entity.ai.gossip.ReputationType;
import net.minecraft.world.entity.ai.memory.ExpirableMemory;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class PacketDebug {
    private static final Logger a = LogUtils.getLogger();

    public static void a(WorldServer world, BlockPosition pos, String message, int color, int duration) {
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.buffer());
        friendlyByteBuf.a(pos);
        friendlyByteBuf.writeInt(color);
        friendlyByteBuf.a(message);
        friendlyByteBuf.writeInt(duration);
        PacketDebug.a(world, friendlyByteBuf, PacketPlayOutCustomPayload.n);
    }

    public static void a(WorldServer world) {
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.buffer());
        PacketDebug.a(world, friendlyByteBuf, PacketPlayOutCustomPayload.o);
    }

    public static void a(WorldServer world, ChunkCoordIntPair pos) {
    }

    public static void a(WorldServer world, BlockPosition pos) {
        PacketDebug.d(world, pos);
    }

    public static void b(WorldServer world, BlockPosition pos) {
        PacketDebug.d(world, pos);
    }

    public static void c(WorldServer world, BlockPosition pos) {
        PacketDebug.d(world, pos);
    }

    private static void d(WorldServer world, BlockPosition pos) {
    }

    public static void a(World world, EntityInsentient mob, @Nullable PathEntity path, float nodeReachProximity) {
    }

    public static void a(World world, BlockPosition pos) {
    }

    public static void a(GeneratorAccessSeed world, StructureStart structureStart) {
    }

    public static void a(World world, EntityInsentient mob, PathfinderGoalSelector goalSelector) {
        if (!(world instanceof WorldServer)) {
            return;
        }
    }

    public static void a(WorldServer server, Collection<Raid> raids) {
    }

    public static void a(EntityLiving living) {
    }

    public static void a(EntityBee bee) {
    }

    public static void a(World world, GameEvent event, Vec3D pos) {
    }

    public static void a(World world, GameEventListener eventListener) {
    }

    public static void a(World world, BlockPosition pos, IBlockData state, TileEntityBeehive blockEntity) {
    }

    private static void a(EntityLiving entity, PacketDataSerializer buf) {
        BehaviorController<PathEntity> brain = entity.dK();
        long l2 = entity.dI().V();
        if (entity instanceof InventoryCarrier) {
            InventorySubcontainer container = ((InventoryCarrier)((Object)entity)).w();
            buf.a(container.ab_() ? "" : ((Object)container).toString());
        } else {
            buf.a("");
        }
        buf.a(brain.a(MemoryModuleType.t) ? brain.c(MemoryModuleType.t) : Optional.empty(), (buf2, path) -> path.a((PacketDataSerializer)((Object)buf2)));
        if (entity instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)entity;
            boolean bl = villager.a(l2);
            buf.writeBoolean(bl);
        } else {
            buf.writeBoolean(false);
        }
        if (entity.ae() == EntityTypes.bi) {
            Warden warden = (Warden)entity;
            buf.writeInt(warden.r());
        } else {
            buf.writeInt(-1);
        }
        buf.a(brain.d(), (buf2, activity) -> buf2.a(activity.a()));
        Set set = brain.e().stream().map(BehaviorControl::b).collect(Collectors.toSet());
        buf.a(set, PacketDataSerializer::a);
        buf.a(PacketDebug.a(entity, l2), (buf2, memory) -> {
            String string = UtilColor.a(memory, 255, true);
            buf2.a(string);
        });
        if (entity instanceof EntityVillager) {
            Set set2 = Stream.of(MemoryModuleType.c, MemoryModuleType.b, MemoryModuleType.e).map(brain::c).flatMap(Optional::stream).map(GlobalPos::b).collect(Collectors.toSet());
            buf.a(set2, PacketDataSerializer::a);
        } else {
            buf.d(0);
        }
        if (entity instanceof EntityVillager) {
            Set set3 = Stream.of(MemoryModuleType.d).map(brain::c).flatMap(Optional::stream).map(GlobalPos::b).collect(Collectors.toSet());
            buf.a(set3, PacketDataSerializer::a);
        } else {
            buf.d(0);
        }
        if (entity instanceof EntityVillager) {
            Map<UUID, Object2IntMap<ReputationType>> map = ((EntityVillager)entity).gt().a();
            ArrayList list = Lists.newArrayList();
            map.forEach((uuid, gossips) -> {
                String string = DebugEntityNameGenerator.a(uuid);
                gossips.forEach((type, value) -> list.add(string + ": " + type + ": " + value));
            });
            buf.a(list, PacketDataSerializer::a);
        } else {
            buf.d(0);
        }
    }

    private static List<String> a(EntityLiving entity, long currentTime) {
        Map<MemoryModuleType<?>, Optional<ExpirableMemory<?>>> map = entity.dK().b();
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<MemoryModuleType<?>, Optional<ExpirableMemory<?>>> entry : map.entrySet()) {
            String string4;
            MemoryModuleType<?> memoryModuleType = entry.getKey();
            Optional<ExpirableMemory<?>> optional = entry.getValue();
            if (optional.isPresent()) {
                ExpirableMemory<?> expirableValue = optional.get();
                Object object = expirableValue.c();
                if (memoryModuleType == MemoryModuleType.D) {
                    long l2 = currentTime - (Long)object;
                    String string = l2 + " ticks ago";
                } else if (expirableValue.e()) {
                    String string2 = PacketDebug.a((WorldServer)entity.dI(), object) + " (ttl: " + expirableValue.b() + ")";
                } else {
                    String string3 = PacketDebug.a((WorldServer)entity.dI(), object);
                }
            } else {
                string4 = "-";
            }
            list.add(BuiltInRegistries.C.b(memoryModuleType).a() + ": " + string4);
        }
        list.sort(String::compareTo);
        return list;
    }

    private static String a(WorldServer world, @Nullable Object object) {
        if (object == null) {
            return "-";
        }
        if (object instanceof UUID) {
            return PacketDebug.a(world, world.a((UUID)object));
        }
        if (object instanceof EntityLiving) {
            Entity entity = (Entity)object;
            return DebugEntityNameGenerator.a(entity);
        }
        if (object instanceof INamableTileEntity) {
            return ((INamableTileEntity)object).Z().getString();
        }
        if (object instanceof MemoryTarget) {
            return PacketDebug.a(world, ((MemoryTarget)object).a());
        }
        if (object instanceof BehaviorPositionEntity) {
            return PacketDebug.a(world, ((BehaviorPositionEntity)object).c());
        }
        if (object instanceof GlobalPos) {
            return PacketDebug.a(world, (Object)((GlobalPos)object).b());
        }
        if (object instanceof BehaviorTarget) {
            return PacketDebug.a(world, (Object)((BehaviorTarget)object).b());
        }
        if (object instanceof DamageSource) {
            Entity entity2 = ((DamageSource)object).d();
            return entity2 == null ? object.toString() : PacketDebug.a(world, entity2);
        }
        if (object instanceof Collection) {
            ArrayList list = Lists.newArrayList();
            for (Object object2 : (Iterable)object) {
                list.add(PacketDebug.a(world, object2));
            }
            return ((Object)list).toString();
        }
        return object.toString();
    }

    private static void a(WorldServer world, PacketDataSerializer buf, MinecraftKey channel) {
        PacketPlayOutCustomPayload packet = new PacketPlayOutCustomPayload(channel, buf);
        for (EntityPlayer serverPlayer : world.v()) {
            serverPlayer.c.a(packet);
        }
    }

    private static /* synthetic */ void b(PacketDataSerializer friendlyByteBuf, PathEntity path) {
        path.a(friendlyByteBuf);
    }

    private static /* synthetic */ void a(PacketDataSerializer buf, Raid raid) {
        buf.a(raid.t());
    }

    private static /* synthetic */ void a(PacketDataSerializer buf, PathfinderGoalWrapped goal) {
        buf.writeInt(goal.i());
        buf.writeBoolean(goal.h());
        buf.a(goal.k().getClass().getSimpleName());
    }

    private static /* synthetic */ String a(ResourceKey resourceKey) {
        return resourceKey.a().toString();
    }

    private static /* synthetic */ void a(WorldServer world, VillagePlaceRecord poi) {
        PacketDebug.a(world, poi.f());
    }

    private static /* synthetic */ boolean a(Holder holder) {
        return true;
    }
}

