/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.phys.Vec3D;

public class PacketPlayOutSpawnEntity
implements Packet<PacketListenerPlayOut> {
    private static final double a = 8000.0;
    private static final double b = 3.9;
    private final int c;
    private final UUID d;
    private final EntityTypes<?> e;
    private final double f;
    private final double g;
    private final double h;
    private final int i;
    private final int j;
    private final int k;
    private final byte l;
    private final byte m;
    private final byte n;
    private final int o;

    public PacketPlayOutSpawnEntity(Entity entity) {
        this(entity, 0);
    }

    public PacketPlayOutSpawnEntity(Entity entity, int entityData) {
        this(entity.af(), entity.ct(), entity.dn(), entity.dp(), entity.dt(), entity.dA(), entity.dy(), entity.ae(), entityData, entity.dl(), entity.cm());
    }

    public PacketPlayOutSpawnEntity(Entity entity, int entityData, BlockPosition pos) {
        this(entity.af(), entity.ct(), pos.u(), pos.v(), pos.w(), entity.dA(), entity.dy(), entity.ae(), entityData, entity.dl(), entity.cm());
    }

    public PacketPlayOutSpawnEntity(int id, UUID uuid, double x2, double y2, double z2, float pitch, float yaw, EntityTypes<?> entityType, int entityData, Vec3D velocity, double headYaw) {
        this.c = id;
        this.d = uuid;
        this.f = x2;
        this.g = y2;
        this.h = z2;
        this.l = (byte)MathHelper.d(pitch * 256.0f / 360.0f);
        this.m = (byte)MathHelper.d(yaw * 256.0f / 360.0f);
        this.n = (byte)MathHelper.a(headYaw * 256.0 / 360.0);
        this.e = entityType;
        this.o = entityData;
        this.i = (int)(MathHelper.a(velocity.c, -3.9, 3.9) * 8000.0);
        this.j = (int)(MathHelper.a(velocity.d, -3.9, 3.9) * 8000.0);
        this.k = (int)(MathHelper.a(velocity.e, -3.9, 3.9) * 8000.0);
    }

    public PacketPlayOutSpawnEntity(PacketDataSerializer buf) {
        this.c = buf.m();
        this.d = buf.o();
        this.e = buf.a(BuiltInRegistries.h);
        this.f = buf.readDouble();
        this.g = buf.readDouble();
        this.h = buf.readDouble();
        this.l = buf.readByte();
        this.m = buf.readByte();
        this.n = buf.readByte();
        this.o = buf.m();
        this.i = buf.readShort();
        this.j = buf.readShort();
        this.k = buf.readShort();
    }

    @Override
    @Override
    public void a(PacketDataSerializer buf) {
        buf.d(this.c);
        buf.a(this.d);
        buf.a(BuiltInRegistries.h, this.e);
        buf.writeDouble(this.f);
        buf.writeDouble(this.g);
        buf.writeDouble(this.h);
        buf.writeByte(this.l);
        buf.writeByte(this.m);
        buf.writeByte(this.n);
        buf.d(this.o);
        buf.writeShort(this.i);
        buf.writeShort(this.j);
        buf.writeShort(this.k);
    }

    @Override
    @Override
    public void a(PacketListenerPlayOut listener) {
        listener.a(this);
    }

    public int a() {
        return this.c;
    }

    public UUID c() {
        return this.d;
    }

    public EntityTypes<?> d() {
        return this.e;
    }

    public double e() {
        return this.f;
    }

    public double f() {
        return this.g;
    }

    public double g() {
        return this.h;
    }

    public double h() {
        return (double)this.i / 8000.0;
    }

    public double i() {
        return (double)this.j / 8000.0;
    }

    public double j() {
        return (double)this.k / 8000.0;
    }

    public float k() {
        return (float)(this.l * 360) / 256.0f;
    }

    public float l() {
        return (float)(this.m * 360) / 256.0f;
    }

    public float m() {
        return (float)(this.n * 360) / 256.0f;
    }

    public int n() {
        return this.o;
    }
}

