/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import co.aikar.timings.MinecraftTimings;
import co.aikar.timings.Timing;
import co.aikar.timings.TimingsManager;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.destroystokyo.paper.event.server.ServerTickStartEvent;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import io.papermc.paper.adventure.ChatDecorationProcessor;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.adventure.providers.ClickCallbackProviderImpl;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.chunk.SingleThreadChunkRegionManager;
import io.papermc.paper.chunk.system.io.RegionFileIOThread;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.server.ServerResourcesReloadedEvent;
import io.papermc.paper.log.CustomLogManager;
import io.papermc.paper.threadedregions.scheduler.FoliaGlobalRegionScheduler;
import io.papermc.paper.util.CachedLists;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.TraceUtil;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.runtime.ObjectMethods;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.Proxy;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import joptsimple.OptionSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.DataPackResources;
import net.minecraft.server.Main;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.Services;
import net.minecraft.server.TickTask;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.bossevents.BossBattleCustomData;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.DemoPlayerInteractManager;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldProviderNormal;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.level.progress.WorldLoadListenerFactory;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerConnection;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.players.WhiteList;
import net.minecraft.util.CircularTimer;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.ModCheck;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.GameProfilerTick;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.MethodProfilerResultsEmpty;
import net.minecraft.util.profiling.MethodProfilerResultsField;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.util.profiling.metrics.profiling.ActiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.InactiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.ServerMetricsSamplersProvider;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import net.minecraft.util.thread.IAsyncTaskHandlerReentrant;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.MobSpawnerCat;
import net.minecraft.world.entity.npc.MobSpawnerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.ForcedChunk;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.MobSpawnerPatrol;
import net.minecraft.world.level.levelgen.MobSpawnerPhantom;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.PersistentCommandStorage;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.PersistentScoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecrell.terminalconsole.TerminalConsoleAppender;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_20_R1.util.ServerShutdownThread;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.PluginLoadOrder;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public abstract class MinecraftServer
extends IAsyncTaskHandlerReentrant<TickTask>
implements ICommandListener,
AutoCloseable {
    private static MinecraftServer SERVER;
    public static final Logger n;
    public static final ComponentLogger COMPONENT_LOGGER;
    public static final String b = "vanilla";
    private static final float o = 0.8f;
    private static final int p = 100;
    public static final int c = 50;
    private static final int q = 2000;
    private static final int r = 15000;
    private static final long s = 5000000000L;
    private static final int t = 12;
    public static final int d = 11;
    private static final int u = 441;
    private static final int v = 6000;
    private static final int w = 3;
    public static final int e = 29999984;
    public static final WorldSettings f;
    private static final long x = 50L;
    public static final GameProfile g;
    public Convertable.ConversionSession h;
    public final WorldNBTStorage i;
    private final List<Runnable> y = Lists.newArrayList();
    private MetricsRecorder z;
    private GameProfilerFiller A;
    private Consumer<MethodProfilerResults> B;
    private Consumer<Path> C;
    private boolean D;
    @Nullable
    private TimeProfiler E;
    private boolean F;
    private ServerConnection G;
    public final WorldLoadListenerFactory H;
    @Nullable
    private ServerPing I;
    @Nullable
    private ServerPing.a J;
    private final RandomSource K;
    public final DataFixer L;
    private String M;
    private int N;
    private final LayeredRegistryAccess<RegistryLayer> O;
    private Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> P;
    private PlayerList Q;
    private volatile boolean R;
    private volatile boolean isRestarting = false;
    private boolean S;
    private int T;
    protected final Proxy j;
    private boolean U;
    private boolean V;
    private boolean W;
    private boolean X;
    private Component motd;
    private int Z;
    public final long[] k;
    public final TickTimes tickTimes5s = new TickTimes(100);
    public final TickTimes tickTimes10s = new TickTimes(200);
    public final TickTimes tickTimes60s = new TickTimes(1200);
    @Nullable
    private KeyPair aa;
    @Nullable
    private GameProfile ab;
    private boolean ac;
    private volatile boolean ad;
    private long ae;
    protected final Services l;
    private long af;
    public final Thread ag;
    private long ah;
    private long ai;
    private boolean aj;
    private final ResourcePackRepository ak;
    private final ScoreboardServer al;
    @Nullable
    private PersistentCommandStorage am;
    private final BossBattleCustomData an;
    private final CustomFunctionData ao;
    private final CircularTimer ap;
    private boolean aq;
    private float ar;
    public final Executor as;
    @Nullable
    private String at;
    public ReloadableResources au;
    private final StructureTemplateManager av;
    protected SaveData m;
    private volatile boolean aw;
    public final WorldLoader.a worldLoader;
    public CraftServer server;
    public OptionSet options;
    public ConsoleCommandSender console;
    public static int currentTick;
    public Queue<Runnable> processQueue = new ConcurrentLinkedQueue<Runnable>();
    public int autosavePeriod;
    public CommandDispatcher vanillaCommandDispatcher;
    public boolean forceTicks;
    public static final int TPS = 20;
    public static final int TICK_TIME = 50000000;
    private static final int SAMPLE_INTERVAL = 20;
    public final double[] recentTps = new double[3];
    public final PaperConfigurations paperConfigurations;
    public static long currentTickLong;
    public volatile Thread shutdownThread;
    public volatile boolean abnormalExit = false;
    public boolean isIteratingOverLevels = false;
    private boolean hasStopped = false;
    public volatile boolean hasFullyShutdown = false;
    private boolean hasLoggedStop = false;
    private final Object stopLock = new Object();
    private static final long SEC_IN_NANO = 1000000000L;
    private static final long MAX_CATCHUP_BUFFER = 60000000000L;
    private long lastTick = 0L;
    private long catchupTime = 0L;
    public final RollingAverage tps1 = new RollingAverage(60);
    public final RollingAverage tps5 = new RollingAverage(300);
    public final RollingAverage tps15 = new RollingAverage(900);
    private static final BigDecimal TPS_BASE;
    public static volatile RuntimeException chunkSystemCrash;
    boolean isOversleep = false;
    public final ExecutorService chatExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Chat Thread - #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(n)).build());
    static final long CHUNK_TASK_QUEUE_BACKOFF_MIN_TIME = 25000L;
    static final long MAX_CHUNK_EXEC_TIME = 1000L;
    static final long TASK_EXECUTION_FAILURE_BACKOFF = 5000L;
    private static long lastMidTickExecute;
    private static long lastMidTickExecuteFailure;

    public static <S extends MinecraftServer> S a(Function<Thread, S> serverFactory) {
        AtomicReference<MinecraftServer> atomicreference = new AtomicReference<MinecraftServer>();
        TickThread thread = new TickThread(() -> ((MinecraftServer)atomicreference.get()).w(), "Server thread");
        thread.setUncaughtExceptionHandler((thread1, throwable) -> n.error("Uncaught exception in server thread", throwable));
        thread.setPriority(7);
        if (Runtime.getRuntime().availableProcessors() > 4) {
            thread.setPriority(8);
        }
        MinecraftServer s0 = (MinecraftServer)serverFactory.apply(thread);
        atomicreference.set(s0);
        thread.start();
        return (S)s0;
    }

    public MinecraftServer(OptionSet options, WorldLoader.a worldLoader, Thread thread, Convertable.ConversionSession convertable_conversionsession, ResourcePackRepository resourcepackrepository, WorldStem worldstem, Proxy proxy, DataFixer datafixer, Services services, WorldLoadListenerFactory worldloadlistenerfactory) {
        super("Server");
        SERVER = this;
        this.z = InactiveMetricsRecorder.a;
        this.A = this.z.f();
        this.B = methodprofilerresults -> this.aP();
        this.C = path -> {};
        this.K = RandomSource.a();
        this.N = -1;
        this.P = Maps.newLinkedHashMap();
        this.R = true;
        this.k = new long[100];
        this.ah = SystemUtils.b();
        this.al = new ScoreboardServer(this);
        this.an = new BossBattleCustomData();
        this.ap = new CircularTimer();
        this.O = worldstem.c();
        this.m = worldstem.d();
        this.j = proxy;
        this.ak = resourcepackrepository;
        this.au = new ReloadableResources(worldstem.a(), worldstem.b());
        this.l = services;
        if (services.e() != null) {
            services.e().a(this);
        }
        this.H = worldloadlistenerfactory;
        this.h = convertable_conversionsession;
        this.i = convertable_conversionsession.b();
        this.L = datafixer;
        this.ao = new CustomFunctionData(this, this.au.b.a());
        HolderLookup<Block> holdergetter = this.O.a().d(Registries.e).p().a(this.m.M());
        this.av = new StructureTemplateManager(worldstem.a(), convertable_conversionsession, datafixer, holdergetter);
        this.ag = thread;
        this.as = SystemUtils.f();
        this.options = options;
        this.worldLoader = worldLoader;
        this.vanillaCommandDispatcher = worldstem.b().d;
        Runtime.getRuntime().addShutdownHook(new ServerShutdownThread(this));
        this.paperConfigurations = services.paperConfigurations();
    }

    @Override
    private void a(WorldPersistentData persistentStateManager) {
        ScoreboardServer scoreboardserver = this.aF();
        Objects.requireNonNull(scoreboardserver);
        Function<NBTTagCompound, PersistentScoreboard> function = scoreboardserver::a;
        ScoreboardServer scoreboardserver1 = this.aF();
        Objects.requireNonNull(scoreboardserver1);
        persistentStateManager.a(function, scoreboardserver1::b, "scoreboard");
    }

    protected abstract boolean e() throws IOException;

    protected void loadLevel(String s2) {
        if (!JvmProfiler.e.c()) {
            // empty if block
        }
        boolean flag = false;
        ProfiledDuration profiledduration = JvmProfiler.e.e();
        this.loadWorld0(s2);
        if (profiledduration != null) {
            profiledduration.finish();
        }
        if (flag) {
            try {
                JvmProfiler.e.b();
            }
            catch (Throwable throwable) {
                n.warn("Failed to stop JFR profiling", throwable);
            }
        }
    }

    private void loadWorld0(String s2) {
        Convertable.ConversionSession worldSession = this.h;
        IRegistry<WorldDimension> dimensions = this.O.a().d(Registries.aI);
        for (WorldDimension worldDimension : dimensions) {
            WorldServer world;
            WorldDataServer worlddata;
            String name;
            ResourceKey<WorldDimension> dimensionKey = dimensions.c(worldDimension).get();
            int dimension = 0;
            if (dimensionKey == WorldDimension.c) {
                if (!this.B()) continue;
                dimension = -1;
            } else if (dimensionKey == WorldDimension.d) {
                if (!this.server.getAllowEnd()) continue;
                dimension = 1;
            } else if (dimensionKey != WorldDimension.b) {
                dimension = -999;
            }
            String worldType = dimension == -999 ? dimensionKey.a().b() + "_" + dimensionKey.a().a() : World.Environment.getEnvironment((int)dimension).toString().toLowerCase();
            String string = name = dimensionKey == WorldDimension.b ? s2 : s2 + "_" + worldType;
            if (dimension != 0) {
                File newWorld = Convertable.getStorageFolder(new File(name).toPath(), dimensionKey).toFile();
                File oldWorld = Convertable.getStorageFolder(new File(s2).toPath(), dimensionKey).toFile();
                File oldLevelDat = new File(new File(s2), "level.dat");
                if (!newWorld.isDirectory() && oldWorld.isDirectory() && oldLevelDat.isFile()) {
                    n.info("---- Migration of old " + worldType + " folder required ----");
                    n.info("Unfortunately due to the way that Minecraft implemented multiworld support in 1.6, Bukkit requires that you move your " + worldType + " folder to a new location in order to operate correctly.");
                    n.info("We will move this folder for you, but it will mean that you need to move it back should you wish to stop using Bukkit in the future.");
                    n.info("Attempting to move " + oldWorld + " to " + newWorld + "...");
                    if (newWorld.exists()) {
                        n.warn("A file or folder already exists at " + newWorld + "!");
                        n.info("---- Migration of old " + worldType + " folder failed ----");
                    } else if (newWorld.getParentFile().mkdirs()) {
                        if (oldWorld.renameTo(newWorld)) {
                            n.info("Success! To restore " + worldType + " in the future, simply move " + newWorld + " to " + oldWorld);
                            try {
                                Files.copy((File)oldLevelDat, (File)new File(new File(name), "level.dat"));
                                FileUtils.copyDirectory((File)new File(new File(s2), "data"), (File)new File(new File(name), "data"));
                            }
                            catch (IOException exception) {
                                n.warn("Unable to migrate world data.");
                            }
                            n.info("---- Migration of old " + worldType + " folder complete ----");
                        } else {
                            n.warn("Could not move folder " + oldWorld + " to " + newWorld + "!");
                            n.info("---- Migration of old " + worldType + " folder failed ----");
                        }
                    } else {
                        n.warn("Could not create path for " + newWorld + "!");
                        n.info("---- Migration of old " + worldType + " folder failed ----");
                    }
                }
                try {
                    worldSession = Convertable.b(this.server.getWorldContainer().toPath()).validateAndCreateAccess(name, dimensionKey);
                }
                catch (IOException | ContentValidationException ex) {
                    throw new RuntimeException(ex);
                }
            }
            ChunkGenerator gen = this.server.getGenerator(name);
            BiomeProvider biomeProvider = this.server.getBiomeProvider(name);
            WorldLoader.a worldloader_a = this.worldLoader;
            IRegistry<WorldDimension> iregistry = worldloader_a.d().d(Registries.aI);
            RegistryOps<NBTBase> dynamicops = RegistryOps.a(DynamicOpsNBT.a, worldloader_a.c());
            Pair<SaveData, WorldDimensions.b> pair = worldSession.a(dynamicops, worldloader_a.b(), iregistry, worldloader_a.c().d());
            if (pair != null) {
                worlddata = (WorldDataServer)pair.getFirst();
            } else {
                WorldDimensions worlddimensions;
                WorldOptions worldoptions;
                WorldSettings worldsettings;
                if (this.R()) {
                    worldsettings = f;
                    worldoptions = WorldOptions.b;
                    worlddimensions = WorldPresets.a(worldloader_a.c());
                } else {
                    DedicatedServerProperties dedicatedserverproperties = ((DedicatedServer)this).a();
                    worldsettings = new WorldSettings(dedicatedserverproperties.m, dedicatedserverproperties.l, dedicatedserverproperties.u, dedicatedserverproperties.k, false, new GameRules(), worldloader_a.b());
                    worldoptions = this.options.has("bonusChest") ? dedicatedserverproperties.X.a(true) : dedicatedserverproperties.X;
                    worlddimensions = dedicatedserverproperties.a(worldloader_a.c());
                }
                WorldDimensions.b worlddimensions_b = worlddimensions.a(iregistry);
                Lifecycle lifecycle = worlddimensions_b.a().add(worldloader_a.c().d());
                worlddata = new WorldDataServer(worldsettings, worldoptions, worlddimensions_b.d(), lifecycle);
            }
            worlddata.checkName(name);
            WorldDataServer iworlddataserver = worlddata;
            boolean flag = worlddata.C();
            WorldOptions worldoptions = worlddata.A();
            long i2 = worldoptions.b();
            long j2 = BiomeManager.a(i2);
            ImmutableList list = ImmutableList.of((Object)new MobSpawnerPhantom(), (Object)new MobSpawnerPatrol(), (Object)new MobSpawnerCat(), (Object)new VillageSiege(), (Object)new MobSpawnerTrader(iworlddataserver));
            WorldDimension worlddimension = dimensions.a(dimensionKey);
            CraftWorldInfo worldInfo = new CraftWorldInfo(iworlddataserver, worldSession, World.Environment.getEnvironment((int)dimension), worlddimension.a().a(), worlddimension.b(), this.aV());
            if (biomeProvider == null && gen != null) {
                biomeProvider = gen.getDefaultBiomeProvider((WorldInfo)worldInfo);
            }
            if (this.options.has("forceUpgrade")) {
                Main.convertWorldButItWorks(dimensionKey, worldSession, DataConverterRegistry.a(), worlddimension.b().b(), this.options.has("eraseCache"));
            }
            ResourceKey<net.minecraft.world.level.World> worldKey = ResourceKey.a(Registries.aH, dimensionKey.a());
            if (dimensionKey == WorldDimension.b) {
                this.m = worlddata;
                this.m.a(((DedicatedServer)this).a().l);
                worldloadlistener = this.H.create(11);
                world = new WorldServer(this, this.as, worldSession, iworlddataserver, worldKey, worlddimension, worldloadlistener, flag, j2, (List<MobSpawner>)list, true, null, World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
                WorldPersistentData worldpersistentdata = world.s();
                this.a(worldpersistentdata);
                this.server.scoreboardManager = new CraftScoreboardManager(this, world.f());
                this.am = new PersistentCommandStorage(worldpersistentdata);
            } else {
                worldloadlistener = this.H.create(11);
                ImmutableList spawners = GlobalConfiguration.get().misc.useDimensionTypeForCustomSpawners && this.aV().d(Registries.au).c(worlddimension.a().a()).orElseThrow() == BuiltinDimensionTypes.a ? list : Collections.emptyList();
                world = new WorldServer(this, this.as, worldSession, iworlddataserver, worldKey, worlddimension, worldloadlistener, flag, j2, (List<MobSpawner>)spawners, true, this.D().H(), World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
            }
            worlddata.a(this.getServerModName(), this.K().a());
            this.addLevel(world);
            this.initWorld(world, worlddata, this.m, worldoptions);
            this.ac().a(world);
            if (worlddata.G() == null) continue;
            this.aJ().a(worlddata.G());
        }
        this.r();
        for (WorldServer worldserver : this.F()) {
            this.prepareLevels(worldserver.k().a.D, worldserver);
            this.server.getPluginManager().callEvent((Event)new WorldLoadEvent((World)worldserver.getWorld()));
        }
        ScoreboardServer scoreboard = this.aF();
        Collection toRemove = scoreboard.g().stream().filter(team -> team.b().startsWith("collideRule_")).map(ScoreboardTeam::b).collect(Collectors.toList());
        for (String teamName : toRemove) {
            scoreboard.d(scoreboard.f(teamName));
        }
        if (!GlobalConfiguration.get().collisions.enablePlayerCollisions) {
            this.ac().collideRuleTeamName = StringUtils.left((String)("collideRule_" + ThreadLocalRandom.current().nextInt()), (int)16);
            ScoreboardTeam collideTeam = scoreboard.g(this.ac().collideRuleTeamName);
            collideTeam.b(false);
        }
        this.server.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.server.getPluginManager().callEvent((Event)new ServerLoadEvent(ServerLoadEvent.LoadType.STARTUP));
        this.G.acceptConnections();
    }

    protected void r() {
    }

    public void initWorld(WorldServer worldserver, IWorldDataServer iworlddataserver, SaveData saveData, WorldOptions worldoptions) {
        boolean flag = saveData.C();
        if (worldserver.generator != null) {
            worldserver.getWorld().getPopulators().addAll(worldserver.generator.getDefaultPopulators((World)worldserver.getWorld()));
        }
        WorldBorder worldborder = worldserver.w_();
        worldborder.a(iworlddataserver.r());
        this.server.getPluginManager().callEvent((Event)new WorldInitEvent((World)worldserver.getWorld()));
        if (!iworlddataserver.p()) {
            try {
                MinecraftServer.a(worldserver, iworlddataserver, worldoptions.d(), flag);
                iworlddataserver.c(true);
                if (flag) {
                    this.a(this.m);
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.a(throwable, "Exception initializing level");
                try {
                    worldserver.a(crashreport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashreport);
            }
            iworlddataserver.c(true);
        }
    }

    private static void a(WorldServer world, IWorldDataServer worldProperties, boolean bonusChest, boolean debugWorld) {
        if (debugWorld) {
            worldProperties.a(BlockPosition.b.b(80), 0.0f);
        } else {
            int i2;
            ChunkProviderServer chunkproviderserver = world.k();
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(chunkproviderserver.i().b().a());
            if (world.generator != null) {
                Random rand = new Random(world.A());
                Location spawn = world.generator.getFixedSpawnLocation((World)world.getWorld(), rand);
                if (spawn != null) {
                    if (spawn.getWorld() != world.getWorld()) {
                        throw new IllegalStateException("Cannot set spawn point for " + worldProperties.g() + " to be in another world (" + spawn.getWorld().getName() + ")");
                    }
                    worldProperties.a(new BlockPosition(spawn.getBlockX(), spawn.getBlockY(), spawn.getBlockZ()), spawn.getYaw());
                    return;
                }
            }
            if ((i2 = chunkproviderserver.g().a(world)) < world.C_()) {
                BlockPosition blockposition = chunkcoordintpair.l();
                i2 = world.a(HeightMap.Type.b, blockposition.u() + 8, blockposition.w() + 8);
            }
            worldProperties.a(chunkcoordintpair.l().b(8, i2, 8), 0.0f);
            int j2 = 0;
            int k2 = 0;
            int l2 = 0;
            int i1 = -1;
            boolean flag2 = true;
            for (int j1 = 0; j1 < MathHelper.h(11); ++j1) {
                BlockPosition blockposition1;
                if (j2 >= -5 && j2 <= 5 && k2 >= -5 && k2 <= 5 && (blockposition1 = WorldProviderNormal.a(world, new ChunkCoordIntPair(chunkcoordintpair.e + j2, chunkcoordintpair.f + k2))) != null) {
                    worldProperties.a(blockposition1, 0.0f);
                    break;
                }
                if (j2 == k2 || j2 < 0 && j2 == -k2 || j2 > 0 && j2 == 1 - k2) {
                    int k1 = l2;
                    l2 = -i1;
                    i1 = k1;
                }
                j2 += l2;
                k2 += i1;
            }
            if (bonusChest) {
                world.B_().c(Registries.as).flatMap(iregistry -> iregistry.b(MiscOverworldFeatures.m)).ifPresent(holder_c -> ((WorldGenFeatureConfigured)holder_c.a()).a(world, chunkproviderserver.g(), world.z, new BlockPosition(worldProperties.a(), worldProperties.b(), worldProperties.c())));
            }
        }
    }

    @Override
    private void a(SaveData properties) {
        properties.a(EnumDifficulty.a);
        properties.d(true);
        IWorldDataServer iworlddataserver = properties.K();
        iworlddataserver.b(false);
        iworlddataserver.a(false);
        iworlddataserver.a(1000000000);
        iworlddataserver.b(6000L);
        iworlddataserver.a(EnumGamemode.d);
    }

    public void prepareLevels(WorldLoadListener worldloadlistener, WorldServer worldserver) {
        WorldServer worldserver1;
        ForcedChunk forcedchunk;
        ChunkProviderServer chunkproviderserver = worldserver.k();
        this.forceTicks = true;
        if (worldserver.getWorld().getKeepSpawnInMemory()) {
            n.info("Preparing start region for dimension {}", (Object)worldserver.ac().a());
            BlockPosition blockposition = worldserver.R();
            worldloadlistener.a(new ChunkCoordIntPair(blockposition));
            this.ah = SystemUtils.b();
            int radiusBlocks = worldserver.paperConfig().spawn.keepSpawnLoadedRange * 16;
            int radiusChunks = radiusBlocks / 16 + ((radiusBlocks & 0xF) != 0 ? 1 : 0);
            int totalChunks = radiusChunks * 2 + 1;
            totalChunks *= totalChunks;
            worldloadlistener.setChunkRadius(radiusBlocks / 16);
            worldserver.addTicketsForSpawn(radiusBlocks, blockposition);
            this.executeModerately();
        }
        if ((forcedchunk = (worldserver1 = worldserver).s().a(ForcedChunk::b, "chunks")) != null) {
            LongIterator longiterator = forcedchunk.a().iterator();
            while (longiterator.hasNext()) {
                long i2 = longiterator.nextLong();
                ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2);
                worldserver1.k().a(chunkcoordintpair, true);
            }
        }
        this.executeModerately();
        if (worldserver.getWorld().getKeepSpawnInMemory()) {
            worldloadlistener.b();
        }
        worldserver.b(worldserver.K.s() != EnumDifficulty.a && ((DedicatedServer)this).u.a().w, this.W());
        this.forceTicks = false;
    }

    public EnumGamemode o_() {
        return this.m.m();
    }

    public boolean h() {
        return this.m.n();
    }

    public abstract int i();

    public abstract int j();

    public abstract boolean k();

    public boolean a(boolean suppressLogs, boolean flush, boolean force) {
        return this.saveAllChunks(suppressLogs, flush, force, false);
    }

    public boolean saveAllChunks(boolean suppressLogs, boolean flush, boolean force, boolean close) {
        boolean flag3 = false;
        for (WorldServer worldserver : this.F()) {
            if (!suppressLogs) {
                n.info("Saving chunks for level '{}'/{}", (Object)worldserver, (Object)worldserver.ac().a());
            }
            worldserver.save(null, flush, worldserver.e && !force, close);
            if (flush) {
                n.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)worldserver.k().a.n());
            }
            flag3 = true;
        }
        if (flush) {
            for (WorldServer worldServer : this.F()) {
            }
            n.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return flag3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean b(boolean suppressLogs, boolean flush, boolean force) {
        boolean flag3;
        try {
            this.aw = true;
            this.ac().h();
            flag3 = this.a(suppressLogs, flush, force);
        }
        finally {
            this.aw = false;
        }
        return flag3;
    }

    @Override
    public void close() {
        this.t();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasStopped() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.hasStopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void t() {
        Object object = this.stopLock;
        synchronized (object) {
            if (this.hasStopped) {
                return;
            }
            this.hasStopped = true;
        }
        if (!this.hasLoggedStop && this.isDebugging()) {
            TraceUtil.dumpTraceForThread("Server stopped");
        }
        this.shutdownThread = Thread.currentThread();
        WatchdogThread.doStop();
        if (!this.bl()) {
            n.info("Stopping main thread (Ignore any thread death message you see! - DO NOT REPORT THREAD DEATH TO PAPER)");
            while (this.au().isAlive()) {
                this.au().stop();
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.z.e()) {
            this.aR();
        }
        n.info("Stopping server");
        CommandDispatcher.COMMAND_SENDING_POOL.shutdownNow();
        MinecraftTimings.stopServer();
        if (this.server != null) {
            this.server.disablePlugins();
            this.server.waitForAsyncTasksShutdown();
        }
        if (this.ad() != null) {
            this.ad().b();
        }
        this.aw = true;
        if (this.Q != null) {
            n.info("Saving players");
            this.Q.h();
            this.Q.removeAll(this.isRestarting);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        n.info("Saving worlds");
        for (WorldServer worldserver : this.F()) {
            if (worldserver == null) continue;
            worldserver.e = false;
        }
        this.saveAllChunks(false, true, false, true);
        this.aw = false;
        this.au.close();
        try {
            this.h.close();
        }
        catch (IOException ioexception1) {
            n.error("Failed to unlock level {}", (Object)this.h.a(), (Object)ioexception1);
        }
        MCUtil.asyncExecutor.shutdown();
        try {
            MCUtil.asyncExecutor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (SpigotConfig.saveUserCacheOnStopOnly) {
            n.info("Saving usercache.json");
            this.ap().save(false);
        }
        n.info("Flushing Chunk IO");
        RegionFileIOThread.close(true);
        n.info("Closing Thread Pool");
        SystemUtils.h();
        n.info("Closing Server");
        try {
            TerminalConsoleAppender.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CustomLogManager.forceReset();
        this.g();
    }

    public String u() {
        return this.M;
    }

    public void a_(String serverIp) {
        this.M = serverIp;
    }

    public boolean v() {
        return this.R;
    }

    @Override
    public void a(boolean waitForShutdown) {
        this.safeShutdown(waitForShutdown, false);
    }

    public void safeShutdown(boolean waitForShutdown, boolean isRestarting) {
        this.isRestarting = isRestarting;
        this.hasLoggedStop = true;
        if (this.isDebugging()) {
            TraceUtil.dumpTraceForThread("Server stopped");
        }
        this.R = false;
        if (waitForShutdown) {
            try {
                this.ag.join();
            }
            catch (InterruptedException interruptedexception) {
                n.error("Error while shutting down", (Throwable)interruptedexception);
            }
        }
    }

    private static double calcTps(double avg, double exp, double tps) {
        return avg * exp + tps * (1.0 - exp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void w() {
        try {
            long start;
            long serverStartTime = SystemUtils.c();
            if (!this.e()) {
                throw new IllegalStateException("Failed to initialize server");
            }
            this.ah = SystemUtils.b();
            this.J = this.bh().orElse(null);
            this.I = this.bi();
            n.info("Running delayed init tasks");
            this.server.getScheduler().mainThreadHeartbeat(this.T);
            String doneTime = String.format(Locale.ROOT, "%.3fs", (double)(SystemUtils.c() - serverStartTime) / 1.0E9);
            n.info("Done ({})! For help, type \"help\"", (Object)doneTime);
            WatchdogThread.tick();
            WatchdogThread.hasStarted = true;
            Arrays.fill(this.recentTps, 20.0);
            long tickSection = start = System.nanoTime();
            this.lastTick = start - 50000000L;
            while (this.R) {
                if (chunkSystemCrash != null) {
                    throw chunkSystemCrash;
                }
                long curTime = System.nanoTime();
                long i2 = curTime / 1000000L - this.ah;
                if (i2 > 5000L && this.ah - this.ae >= 30000L) {
                    long j2 = i2 / 50L;
                    if (this.server.getWarnOnOverload()) {
                        n.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)i2, (Object)j2);
                    }
                    this.ah += j2 * 50L;
                    this.ae = this.ah;
                }
                ++currentTickLong;
                if (++currentTick % 20 == 0) {
                    long diff = curTime - tickSection;
                    BigDecimal currentTps = TPS_BASE.divide(new BigDecimal(diff), 30, RoundingMode.HALF_UP);
                    this.tps1.add(currentTps, diff);
                    this.tps5.add(currentTps, diff);
                    this.tps15.add(currentTps, diff);
                    this.recentTps[0] = this.tps1.getAverage();
                    this.recentTps[1] = this.tps5.getAverage();
                    this.recentTps[2] = this.tps15.getAverage();
                    tickSection = curTime;
                }
                if (this.F) {
                    this.F = false;
                    this.E = new TimeProfiler(SystemUtils.c(), this.T);
                }
                this.lastTick = curTime;
                this.ah += 50L;
                this.bt();
                this.A.a("tick");
                this.a(this::bf);
                this.A.b("nextTickWait");
                this.aj = true;
                this.ai = Math.max(SystemUtils.b() + 50L, this.ah);
                this.p_();
                this.A.c();
                this.bu();
                this.ad = true;
                JvmProfiler.e.a(this.ar);
            }
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                n.error("Main thread terminated by WatchDog due to hard crash", throwable);
                return;
            }
            n.error("Encountered an unexpected exception", throwable);
            if (throwable.getCause() != null) {
                n.error("\tCause of unexpected exception was", throwable.getCause());
            }
            CrashReport crashreport = MinecraftServer.a(throwable);
            this.b(crashreport.g());
            File file = new File(new File(this.z(), "crash-reports"), "crash-" + SystemUtils.e() + "-server.txt");
            if (crashreport.a(file)) {
                n.error("This crash report has been saved to: {}", (Object)file.getAbsolutePath());
            } else {
                n.error("We were unable to save this crash report to disk.");
            }
            this.a(crashreport);
            return;
        }
        finally {
            try {
                this.S = true;
                this.t();
            }
            catch (Throwable throwable1) {
                n.error("Exception stopping the server", throwable1);
            }
            finally {
                if (this.l.e() != null) {
                    this.l.e().a();
                }
            }
        }
    }

    private static CrashReport a(Throwable throwable) {
        CrashReport crashreport;
        ReportedException reportedexception = null;
        for (Throwable throwable1 = throwable; throwable1 != null; throwable1 = throwable1.getCause()) {
            ReportedException reportedexception1;
            if (!(throwable1 instanceof ReportedException)) continue;
            reportedexception = reportedexception1 = (ReportedException)throwable1;
        }
        if (reportedexception != null) {
            crashreport = reportedexception.a();
            if (reportedexception != throwable) {
                crashreport.a("Wrapped in").a("Wrapping exception", throwable);
            }
        } else {
            crashreport = new CrashReport("Exception in server tick loop", throwable);
        }
        return crashreport;
    }

    private boolean bf() {
        if (this.forceTicks) {
            return true;
        }
        if (this.isOversleep) {
            return this.canOversleep();
        }
        return this.forceTicks || this.br() || SystemUtils.b() < (this.aj ? this.ai : this.ah);
    }

    private boolean canOversleep() {
        return this.aj && SystemUtils.b() < this.ai;
    }

    private boolean canSleepForTickNoOversleep() {
        return this.forceTicks || this.br() || SystemUtils.b() < this.ah;
    }

    private void executeModerately() {
        this.bp();
        LockSupport.parkNanos("executing tasks", 1000L);
    }

    protected void p_() {
        this.c(() -> !this.canSleepForTickNoOversleep());
    }

    public TickTask a(Runnable runnable) {
        if (this.hasStopped && Thread.currentThread().equals(this.shutdownThread)) {
            runnable.run();
            runnable = () -> {};
        }
        return new TickTask(this.T, runnable);
    }

    protected boolean a(TickTask ticktask) {
        return ticktask.a() + 3 < this.T || this.bf();
    }

    @Override
    public boolean x() {
        boolean flag;
        this.aj = flag = this.bg();
        return flag;
    }

    private boolean bg() {
        if (super.x()) {
            this.executeMidTickTasks();
            return true;
        }
        boolean ret = false;
        if (this.bf()) {
            for (WorldServer worldserver : this.F()) {
                if (!worldserver.k().d()) continue;
                ret = true;
            }
        }
        return ret;
    }

    public void b(TickTask ticktask) {
        this.aN().d("runTask");
        super.d(ticktask);
    }

    private Optional<ServerPing.a> bh() {
        Optional<Path> optional = Optional.of(this.c("server-icon.png").toPath()).filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])).or(() -> this.h.e().filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])));
        return optional.flatMap(path -> {
            try {
                BufferedImage bufferedimage = ImageIO.read(path.toFile());
                Preconditions.checkState((bufferedimage.getWidth() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels wide");
                Preconditions.checkState((bufferedimage.getHeight() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels high");
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedimage, "PNG", bytearrayoutputstream);
                return Optional.of(new ServerPing.a(bytearrayoutputstream.toByteArray()));
            }
            catch (Exception exception) {
                n.error("Couldn't load server icon", (Throwable)exception);
                return Optional.empty();
            }
        });
    }

    public Optional<Path> y() {
        return this.h.e();
    }

    public File z() {
        return new File(".");
    }

    @Override
    public void a(CrashReport report) {
    }

    public void g() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(BooleanSupplier shouldKeepTicking) {
        int playerSaveInterval;
        TimingsManager.FULL_SERVER_TICK.startTiming();
        long i2 = SystemUtils.c();
        this.isOversleep = true;
        MinecraftTimings.serverOversleep.startTiming();
        this.c(() -> !this.canOversleep());
        this.isOversleep = false;
        MinecraftTimings.serverOversleep.stopTiming();
        new ServerTickStartEvent(this.T + 1).callEvent();
        ++this.T;
        this.b(shouldKeepTicking);
        if (i2 - this.af >= 5000000000L) {
            this.af = i2;
            this.I = this.bi();
        }
        if ((playerSaveInterval = GlobalConfiguration.get().playerAutoSave.rate) < 0) {
            playerSaveInterval = this.autosavePeriod;
        }
        this.A.a("save");
        boolean fullSave = this.autosavePeriod > 0 && this.T % this.autosavePeriod == 0;
        try {
            this.aw = true;
            if (playerSaveInterval > 0) {
                this.Q.saveAll(playerSaveInterval);
            }
            for (WorldServer level : this.F()) {
                if (level.paperConfig().chunks.autoSaveInterval.value() <= 0) continue;
                level.saveIncrementally(fullSave);
            }
        }
        finally {
            this.aw = false;
        }
        this.A.c();
        CachedLists.reset();
        try (Timing ignored = MinecraftTimings.processTasksTimer.startTiming();){
            this.bp();
        }
        long endTime = System.nanoTime();
        long remaining = 50000000L - (endTime - this.lastTick) - this.catchupTime;
        new ServerTickEndEvent(this.T, (double)(endTime - this.lastTick) / 1000000.0, remaining).callEvent();
        this.A.a("tallying");
        long l2 = SystemUtils.c() - i2;
        this.k[this.T % 100] = l2;
        long j2 = l2;
        this.ar = this.ar * 0.8f + (float)j2 / 1000000.0f * 0.19999999f;
        long k2 = SystemUtils.c();
        this.tickTimes5s.add(this.T, j2);
        this.tickTimes10s.add(this.T, j2);
        this.tickTimes60s.add(this.T, j2);
        this.ap.a(k2 - i2);
        this.A.c();
        WatchdogThread.tick();
        TimingsManager.FULL_SERVER_TICK.stopTiming();
    }

    private ServerPing bi() {
        ServerPing.ServerPingPlayerSample serverping_serverpingplayersample = this.bj();
        return new ServerPing(PaperAdventure.asVanilla(this.motd), Optional.of(serverping_serverpingplayersample), Optional.of(ServerPing.ServerData.a()), Optional.ofNullable(this.J), this.aw());
    }

    private ServerPing.ServerPingPlayerSample bj() {
        List<EntityPlayer> list = this.Q.t();
        int i2 = this.I();
        if (this.aj()) {
            return new ServerPing.ServerPingPlayerSample(i2, list.size(), List.of());
        }
        int j2 = Math.min(list.size(), SpigotConfig.playerSample);
        ObjectArrayList objectarraylist = new ObjectArrayList(j2);
        int k2 = MathHelper.a(this.K, 0, list.size() - j2);
        for (int l2 = 0; l2 < j2; ++l2) {
            EntityPlayer entityplayer = list.get(k2 + l2);
            objectarraylist.add((Object)(entityplayer.V() ? entityplayer.fM() : g));
        }
        SystemUtils.b(objectarraylist, this.K);
        return new ServerPing.ServerPingPlayerSample(i2, list.size(), (List<GameProfile>)objectarraylist);
    }

    public void b(BooleanSupplier shouldKeepTicking) {
        MinecraftTimings.bukkitSchedulerTimer.startTiming();
        this.server.getScheduler().mainThreadHeartbeat(this.T);
        MinecraftTimings.bukkitSchedulerTimer.stopTiming();
        ((FoliaGlobalRegionScheduler)Bukkit.getGlobalRegionScheduler()).tick();
        this.F().forEach(level -> {
            for (Entity entity : level.getEntityLookup().getAllCopy()) {
                CraftEntity bukkit;
                if (entity.dD() || (bukkit = entity.getBukkitEntityRaw()) == null) continue;
                bukkit.taskScheduler.executeTick();
            }
        });
        ClickCallbackProviderImpl.CALLBACK_MANAGER.handleQueue(this.T);
        this.A.a("commandFunctions");
        MinecraftTimings.commandFunctionsTimer.startTiming();
        this.aA().c();
        MinecraftTimings.commandFunctionsTimer.stopTiming();
        this.A.b("levels");
        MinecraftTimings.processQueueTimer.startTiming();
        while (!this.processQueue.isEmpty()) {
            this.processQueue.remove().run();
        }
        MinecraftTimings.processQueueTimer.stopTiming();
        MinecraftTimings.timeUpdateTimer.startTiming();
        for (WorldServer level2 : this.F()) {
            boolean doDaylight = level2.X().b(GameRules.k);
            long dayTime = level2.W();
            long worldTime = level2.V();
            PacketPlayOutUpdateTime worldPacket = new PacketPlayOutUpdateTime(worldTime, dayTime, doDaylight);
            for (EntityHuman entityHuman : level2.v()) {
                if (!(entityHuman instanceof EntityPlayer) || (this.T + entityHuman.af()) % 20 != 0) continue;
                EntityPlayer entityplayer = (EntityPlayer)entityHuman;
                long playerTime = entityplayer.getPlayerTime();
                PacketPlayOutUpdateTime packet = playerTime == dayTime ? worldPacket : new PacketPlayOutUpdateTime(worldTime, playerTime, doDaylight);
                entityplayer.c.a(packet);
            }
        }
        MinecraftTimings.timeUpdateTimer.stopTiming();
        this.isIteratingOverLevels = true;
        for (WorldServer worldserver : this.F()) {
            worldserver.hasPhysicsEvent = BlockPhysicsEvent.getHandlerList().getRegisteredListeners().length > 0;
            TileEntityHopper.skipHopperEvents = worldserver.paperConfig().hopper.disableMoveEvent || InventoryMoveItemEvent.getHandlerList().getRegisteredListeners().length == 0;
            worldserver.hasEntityMoveEvent = EntityMoveEvent.getHandlerList().getRegisteredListeners().length > 0;
            this.A.a(() -> worldserver + " " + worldserver.ac().a());
            this.A.a("tick");
            try {
                worldserver.timings.doTick.startTiming();
                worldserver.a(shouldKeepTicking);
                for (SingleThreadChunkRegionManager regionManager : worldserver.k().a.regionManagers) {
                    regionManager.recalculateRegions();
                }
                worldserver.timings.doTick.stopTiming();
            }
            catch (Throwable throwable) {
                CrashReport crashreport;
                try {
                    crashreport = CrashReport.a(throwable, "Exception ticking world");
                }
                catch (Throwable t2) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    throw new RuntimeException("Error generating crash report", t2);
                }
                worldserver.a(crashreport);
                throw new ReportedException(crashreport);
            }
            this.A.c();
            this.A.c();
            worldserver.explosionDensityCache.clear();
        }
        this.isIteratingOverLevels = false;
        this.A.b("connection");
        MinecraftTimings.connectionTimer.startTiming();
        this.ad().c();
        MinecraftTimings.connectionTimer.stopTiming();
        this.A.b("players");
        MinecraftTimings.playerListTimer.startTiming();
        this.Q.d();
        MinecraftTimings.playerListTimer.stopTiming();
        if (SharedConstants.aS) {
            GameTestHarnessTicker.a.b();
        }
        this.A.b("server gui refresh");
        MinecraftTimings.tickablesTimer.startTiming();
        for (int i2 = 0; i2 < this.y.size(); ++i2) {
            this.y.get(i2).run();
        }
        MinecraftTimings.tickablesTimer.stopTiming();
        this.A.c();
    }

    private void b(WorldServer world) {
        this.Q.a(new PacketPlayOutUpdateTime(world.V(), world.W(), world.X().b(GameRules.k)), world.ac());
    }

    public void A() {
        this.A.a("timeSync");
        for (WorldServer worldserver : this.F()) {
            this.b(worldserver);
        }
        this.A.c();
    }

    public boolean B() {
        return true;
    }

    public void b(Runnable tickable) {
        this.y.add(tickable);
    }

    protected void b(String serverId) {
        this.at = serverId;
    }

    public boolean C() {
        return !this.ag.isAlive();
    }

    public File c(String path) {
        return new File(this.z(), path);
    }

    public final WorldServer D() {
        return this.P.get(net.minecraft.world.level.World.h);
    }

    @Nullable
    public WorldServer a(ResourceKey<net.minecraft.world.level.World> key) {
        return this.P.get(key);
    }

    public void addLevel(WorldServer level) {
        Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> oldLevels = this.P;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.put(level.ac(), level);
        this.P = Collections.unmodifiableMap(newLevels);
    }

    public void removeLevel(WorldServer level) {
        Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> oldLevels = this.P;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.remove(level.ac());
        this.P = Collections.unmodifiableMap(newLevels);
    }

    public Set<ResourceKey<net.minecraft.world.level.World>> E() {
        return this.P.keySet();
    }

    public Iterable<WorldServer> F() {
        return this.P.values();
    }

    public String G() {
        return SharedConstants.b().c();
    }

    public int H() {
        return this.Q.m();
    }

    public int I() {
        return this.Q.n();
    }

    public String[] J() {
        return this.Q.e();
    }

    @DontObfuscate
    public String getServerModName() {
        return "Paper";
    }

    public SystemReport b(SystemReport details) {
        details.a("Server Running", () -> Boolean.toString(this.R));
        if (this.Q != null) {
            details.a("Player Count", () -> {
                int i2 = this.Q.m();
                return i2 + " / " + this.Q.n() + "; " + this.Q.t();
            });
        }
        details.a("Data Packs", () -> this.ak.f().stream().map(resourcepackloader -> {
            String s2 = resourcepackloader.f();
            return s2 + (resourcepackloader.c().a() ? "" : " (incompatible)");
        }).collect(Collectors.joining(", ")));
        details.a("Enabled Feature Flags", () -> FeatureFlags.c.b(this.m.M()).stream().map(MinecraftKey::toString).collect(Collectors.joining(", ")));
        details.a("World Generation", () -> this.m.D().toString());
        if (this.at != null) {
            details.a("Server Id", () -> this.at);
        }
        return this.a(details);
    }

    public abstract SystemReport a(SystemReport var1);

    public ModCheck K() {
        return ModCheck.a(b, this::getServerModName, "Server", MinecraftServer.class);
    }

    @Override
    public void a(IChatBaseComponent message) {
        n.info((String)PaperAdventure.ANSI_SERIALIZER.serialize(PaperAdventure.asAdventure(message)));
    }

    public KeyPair L() {
        return this.aa;
    }

    public int M() {
        return this.N;
    }

    @Override
    public void a(int serverPort) {
        this.N = serverPort;
    }

    @Nullable
    public GameProfile N() {
        return this.ab;
    }

    public void b(@Nullable GameProfile hostProfile) {
        this.ab = hostProfile;
    }

    public boolean O() {
        return this.ab != null;
    }

    protected void P() {
        n.info("Generating keypair");
        try {
            this.aa = MinecraftEncryption.b();
        }
        catch (CryptographyException cryptographyexception) {
            throw new IllegalStateException("Failed to generate key pair", cryptographyexception);
        }
    }

    public void setDifficulty(WorldServer level, EnumDifficulty difficulty, boolean forceUpdate) {
        WorldDataServer worldData = level.K;
        if (forceUpdate || !worldData.t()) {
            worldData.a(worldData.n() ? EnumDifficulty.d : difficulty);
            level.b(worldData.s() != EnumDifficulty.a && ((DedicatedServer)this).u.a().w, this.W());
        }
    }

    public int b(int initialDistance) {
        return initialDistance;
    }

    private void bs() {
        for (WorldServer worldserver : this.F()) {
            worldserver.b(worldserver.K.s() != EnumDifficulty.a && ((DedicatedServer)this).u.a().w, this.W());
        }
    }

    public void b(boolean locked) {
        this.m.d(locked);
        this.ac().t().forEach(this::c);
    }

    private void c(EntityPlayer player) {
        WorldData worlddata = player.dI().u_();
        player.c.a(new PacketPlayOutServerDifficulty(worlddata.s(), worlddata.t()));
    }

    public boolean Q() {
        return this.m.s() != EnumDifficulty.a;
    }

    public boolean R() {
        return this.ac;
    }

    public void c(boolean demo) {
        this.ac = demo;
    }

    public Optional<ServerResourcePackInfo> S() {
        return Optional.empty();
    }

    public boolean T() {
        return this.S().filter(ServerResourcePackInfo::c).isPresent();
    }

    public abstract boolean l();

    public abstract int m();

    public boolean U() {
        return this.U;
    }

    @Override
    public void d(boolean onlineMode) {
        this.U = onlineMode;
    }

    public boolean V() {
        return this.V;
    }

    public void e(boolean preventProxyConnections) {
        this.V = preventProxyConnections;
    }

    public boolean W() {
        return true;
    }

    public boolean X() {
        return true;
    }

    public abstract boolean n();

    public boolean Y() {
        return this.W;
    }

    public void f(boolean pvpEnabled) {
        this.W = pvpEnabled;
    }

    public boolean Z() {
        return this.X;
    }

    public void g(boolean flightEnabled) {
        this.X = flightEnabled;
    }

    public abstract boolean o();

    public String aa() {
        return LegacyComponentSerializer.legacySection().serialize(this.motd);
    }

    @Override
    public void d(String motd) {
        this.motd = LegacyComponentSerializer.legacySection().deserializeOr((Object)motd, (Component)Component.empty());
    }

    public Component motd() {
        return this.motd;
    }

    public void motd(Component motd) {
        this.motd = motd;
    }

    public boolean ab() {
        return this.S;
    }

    public PlayerList ac() {
        return this.Q;
    }

    @Override
    public void a(PlayerList playerManager) {
        this.Q = playerManager;
    }

    public abstract boolean p();

    @Override
    public void a(EnumGamemode gameMode) {
        this.m.a(gameMode);
    }

    @Nullable
    public ServerConnection ad() {
        return this.G == null ? (this.G = new ServerConnection(this)) : this.G;
    }

    public boolean ae() {
        return this.ad;
    }

    public boolean af() {
        return false;
    }

    public boolean a(@Nullable EnumGamemode gameMode, boolean cheatsAllowed, int port) {
        return false;
    }

    public int ag() {
        return this.T;
    }

    public int ah() {
        return 16;
    }

    public boolean a(WorldServer world, BlockPosition pos, EntityHuman player) {
        return false;
    }

    public boolean ai() {
        return true;
    }

    public boolean aj() {
        return false;
    }

    public Proxy ak() {
        return this.j;
    }

    public int al() {
        return this.Z;
    }

    public void c(int playerIdleTimeout) {
        this.Z = playerIdleTimeout;
    }

    public MinecraftSessionService am() {
        return this.l.b();
    }

    @Nullable
    public SignatureValidator an() {
        return this.l.a();
    }

    public GameProfileRepository ao() {
        return this.l.d();
    }

    @Nullable
    public UserCache ap() {
        return this.l.e();
    }

    @Nullable
    public ServerPing aq() {
        return this.I;
    }

    public void ar() {
        this.af = 0L;
    }

    public int as() {
        return 29999984;
    }

    @Override
    public boolean at() {
        return super.at() && !this.ab();
    }

    @Override
    public void c(Runnable runnable) {
        if (this.ab()) {
            throw new RejectedExecutionException("Server already shutting down");
        }
        super.c(runnable);
    }

    @Override
    public Thread au() {
        return this.ag;
    }

    public int av() {
        return 256;
    }

    public boolean aw() {
        return false;
    }

    public long ax() {
        return this.ah;
    }

    public DataFixer ay() {
        return this.L;
    }

    public int a(@Nullable WorldServer world) {
        return world != null ? world.X().c(GameRules.r) : 10;
    }

    public AdvancementDataWorld az() {
        return this.au.b.e();
    }

    public CustomFunctionData aA() {
        return this.ao;
    }

    @Override
    @Deprecated
    @DoNotUse
    public CompletableFuture<Void> a(Collection<String> dataPacks) {
        return this.reloadResources(dataPacks, ServerResourcesReloadedEvent.Cause.PLUGIN);
    }

    public CompletableFuture<Void> reloadResources(Collection<String> dataPacks, ServerResourcesReloadedEvent.Cause cause) {
        IRegistryCustom.Dimension iregistrycustom_dimension = this.O.b(RegistryLayer.d);
        CompletionStage completablefuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            Stream stream = dataPacks.stream();
            ResourcePackRepository resourcepackrepository = this.ak;
            Objects.requireNonNull(this.ak);
            return (ImmutableList)stream.map(resourcepackrepository::c).filter(Objects::nonNull).map(ResourcePackLoader::e).collect(ImmutableList.toImmutableList());
        }, this).thenCompose(immutablelist -> {
            ResourceManager resourcemanager = new ResourceManager(EnumResourcePackType.b, (List<IResourcePack>)immutablelist);
            return ((CompletableFuture)DataPackResources.a(resourcemanager, iregistrycustom_dimension, this.m.M(), this.l() ? CommandDispatcher.ServerType.b : CommandDispatcher.ServerType.c, this.j(), this.as, this).whenComplete((datapackresources, throwable) -> {
                if (throwable != null) {
                    resourcemanager.close();
                }
            })).thenApply(datapackresources -> new ReloadableResources(resourcemanager, (DataPackResources)datapackresources));
        })).thenAcceptAsync(minecraftserver_reloadableresources -> {
            this.au.close();
            this.au = minecraftserver_reloadableresources;
            this.server.syncCommands();
            this.ak.a(dataPacks);
            WorldDataConfiguration worlddataconfiguration = new WorldDataConfiguration(MinecraftServer.a(this.ak), this.m.M());
            this.m.a(worlddataconfiguration);
            this.au.b.a(this.aV());
            PotionBrewer.reload();
            if (Thread.currentThread() != this.ag) {
                return;
            }
            for (EntityPlayer player : this.ac().t()) {
                player.M().b();
            }
            this.ac().u();
            this.ao.a(this.au.b.a());
            this.av.a(this.au.a);
            CraftBlockData.reloadCache();
            new ServerResourcesReloadedEvent(cause).callEvent();
        }, (Executor)this);
        if (this.bl()) {
            Objects.requireNonNull(completablefuture);
            this.c(((CompletableFuture)completablefuture)::isDone);
        }
        return completablefuture;
    }

    public static WorldDataConfiguration a(ResourcePackRepository resourcePackManager, DataPackConfiguration dataPackSettings, boolean safeMode, FeatureFlagSet enabledFeatures) {
        resourcePackManager.a();
        if (safeMode) {
            resourcePackManager.a(Collections.singleton(b));
            return WorldDataConfiguration.c;
        }
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (String s2 : dataPackSettings.a()) {
            if (resourcePackManager.d(s2)) {
                set.add(s2);
                continue;
            }
            n.warn("Missing data pack {}", (Object)s2);
        }
        for (ResourcePackLoader resourcepackloader : resourcePackManager.c()) {
            String s1 = resourcepackloader.f();
            if (dataPackSettings.b().contains(s1)) continue;
            FeatureFlagSet featureflagset1 = resourcepackloader.d();
            boolean flag1 = set.contains(s1);
            if (!flag1 && resourcepackloader.j().a()) {
                if (featureflagset1.a(enabledFeatures)) {
                    n.info("Found new data pack {}, loading it automatically", (Object)s1);
                    set.add(s1);
                } else {
                    n.info("Found new data pack {}, but can't load it due to missing features {}", (Object)s1, (Object)FeatureFlags.a(enabledFeatures, featureflagset1));
                }
            }
            if (!flag1 || featureflagset1.a(enabledFeatures)) continue;
            n.warn("Pack {} requires features {} that are not enabled for this world, disabling pack.", (Object)s1, (Object)FeatureFlags.a(enabledFeatures, featureflagset1));
            set.remove(s1);
        }
        if (set.isEmpty()) {
            n.info("No datapacks selected, forcing vanilla");
            set.add(b);
        }
        resourcePackManager.a(set);
        DataPackConfiguration datapackconfiguration1 = MinecraftServer.a(resourcePackManager);
        FeatureFlagSet featureflagset2 = resourcePackManager.e();
        return new WorldDataConfiguration(datapackconfiguration1, featureflagset2);
    }

    private static DataPackConfiguration a(ResourcePackRepository dataPackManager) {
        Collection<String> collection = dataPackManager.d();
        ImmutableList list = ImmutableList.copyOf(collection);
        List list1 = (List)dataPackManager.b().stream().filter(s2 -> !collection.contains(s2)).collect(ImmutableList.toImmutableList());
        return new DataPackConfiguration((List<String>)list, list1);
    }

    @Override
    public void a(CommandListenerWrapper source) {
        if (this.aK()) {
            PlayerList playerlist = source.l().ac();
            WhiteList whitelist = playerlist.i();
            if (!((DedicatedServer)MinecraftServer.getServer()).a().V.get().booleanValue()) {
                return;
            }
            ArrayList list = Lists.newArrayList(playerlist.t());
            for (EntityPlayer entityplayer : list) {
                if (whitelist.a(entityplayer.fM()) || this.ac().f(entityplayer.fM())) continue;
                entityplayer.c.disconnect(SpigotConfig.whitelistMessage, PlayerKickEvent.Cause.WHITELIST);
            }
        }
    }

    public ResourcePackRepository aB() {
        return this.ak;
    }

    public CommandDispatcher aC() {
        return this.au.b.d();
    }

    public CommandListenerWrapper aD() {
        WorldServer worldserver = this.D();
        return new CommandListenerWrapper(this, worldserver == null ? Vec3D.b : Vec3D.a(worldserver.R()), Vec2F.a, worldserver, 4, "Server", IChatBaseComponent.b("Server"), this, null);
    }

    @Override
    public boolean e_() {
        return true;
    }

    @Override
    public boolean q_() {
        return true;
    }

    @Override
    public abstract boolean N_();

    public CraftingManager aE() {
        return this.au.b.c();
    }

    public ScoreboardServer aF() {
        return this.al;
    }

    public PersistentCommandStorage aG() {
        if (this.am == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.am;
    }

    public LootDataManager aH() {
        return this.au.b.b();
    }

    public GameRules aI() {
        return this.D().X();
    }

    public BossBattleCustomData aJ() {
        return this.an;
    }

    public boolean aK() {
        return this.aq;
    }

    public void h(boolean enforceWhitelist) {
        this.aq = enforceWhitelist;
    }

    public float aL() {
        return this.ar;
    }

    public int c(GameProfile profile) {
        if (this.ac().f(profile)) {
            OpListEntry oplistentry = (OpListEntry)this.ac().k().b(profile);
            return oplistentry != null ? oplistentry.a() : (this.a(profile) ? 4 : (this.O() ? (this.ac().v() ? 4 : 0) : this.i()));
        }
        return 0;
    }

    public CircularTimer aM() {
        return this.ap;
    }

    public GameProfilerFiller aN() {
        return this.A;
    }

    public abstract boolean a(GameProfile var1);

    @Override
    public void a(Path file) throws IOException {
    }

    private void b(Path path) {
        Path path1 = path.resolve("levels");
        try {
            for (Map.Entry<ResourceKey<net.minecraft.world.level.World>, WorldServer> entry : this.P.entrySet()) {
                MinecraftKey minecraftkey = entry.getKey().a();
                Path path2 = path1.resolve(minecraftkey.b()).resolve(minecraftkey.a());
                java.nio.file.Files.createDirectories(path2, new FileAttribute[0]);
                entry.getValue().a(path2);
            }
            this.d(path.resolve("gamerules.txt"));
            this.e(path.resolve("classpath.txt"));
            this.c(path.resolve("stats.txt"));
            this.f(path.resolve("threads.txt"));
            this.a(path.resolve("server.properties.txt"));
            this.g(path.resolve("modules.txt"));
        }
        catch (IOException ioexception) {
            n.warn("Failed to save debug report", (Throwable)ioexception);
        }
    }

    private void c(Path path) throws IOException {
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedwriter.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.bm()));
            bufferedwriter.write(String.format(Locale.ROOT, "average_tick_time: %f\n", Float.valueOf(this.aL())));
            bufferedwriter.write(String.format(Locale.ROOT, "tick_times: %s\n", Arrays.toString(this.k)));
            bufferedwriter.write(String.format(Locale.ROOT, "queue: %s\n", SystemUtils.f()));
        }
    }

    @Override
    private void d(Path path) throws IOException {
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList list = Lists.newArrayList();
            final GameRules gamerules = this.aI();
            GameRules.a(new GameRules.GameRuleVisitor(){

                @Override
                public <T extends GameRules.GameRuleValue<T>> void a(GameRules.GameRuleKey<T> key, GameRules.GameRuleDefinition<T> type) {
                    list.add(String.format(Locale.ROOT, "%s=%s\n", key.a(), gamerules.a(key)));
                }
            });
            for (String s2 : list) {
                bufferedwriter.write(s2);
            }
        }
    }

    private void e(Path path) throws IOException {
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            String s2 = System.getProperty("java.class.path");
            String s1 = System.getProperty("path.separator");
            for (String s22 : Splitter.on((String)s1).split((CharSequence)s2)) {
                bufferedwriter.write(s22);
                bufferedwriter.write("\n");
            }
        }
    }

    private void f(Path path) throws IOException {
        ThreadMXBean threadmxbean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] athreadinfo = threadmxbean.dumpAllThreads(true, true);
        Arrays.sort(athreadinfo, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            ThreadInfo[] athreadinfo1 = athreadinfo;
            int i2 = athreadinfo.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                ThreadInfo threadinfo = athreadinfo1[j2];
                bufferedwriter.write(threadinfo.toString());
                bufferedwriter.write(10);
            }
        }
    }

    private void g(Path path) throws IOException {
        block11: {
            block10: {
                try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
                    ArrayList arraylist;
                    try {
                        arraylist = Lists.newArrayList(NativeModuleLister.a());
                    }
                    catch (Throwable throwable) {
                        n.warn("Failed to list native modules", throwable);
                        break block10;
                    }
                    arraylist.sort(Comparator.comparing(nativemodulelister_a -> nativemodulelister_a.a));
                    Iterator iterator = arraylist.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            break block11;
                        }
                        NativeModuleLister.a nativemodulelister_a2 = (NativeModuleLister.a)iterator.next();
                        bufferedwriter.write(nativemodulelister_a2.toString());
                        bufferedwriter.write(10);
                    }
                }
            }
            return;
        }
    }

    @Override
    public boolean bl() {
        return TickThread.isTickThread();
    }

    public boolean isDebugging() {
        return false;
    }

    public static MinecraftServer getServer() {
        return SERVER;
    }

    private void bt() {
        if (this.D) {
            this.z = ActiveMetricsRecorder.a(new ServerMetricsSamplersProvider(SystemUtils.a, this.l()), SystemUtils.a, SystemUtils.g(), new MetricsPersister("server"), this.B, path -> {
                this.h(() -> this.b(path.resolve("server")));
                this.C.accept((Path)path);
            });
            this.D = false;
        }
        this.A = GameProfilerTick.a(this.z.f(), GameProfilerTick.a("Server"));
        this.z.c();
        this.A.a();
    }

    private void bu() {
        this.A.b();
        this.z.d();
    }

    public boolean aO() {
        return this.z.e();
    }

    public void a(Consumer<MethodProfilerResults> resultConsumer, Consumer<Path> dumpConsumer) {
        this.B = methodprofilerresults -> {
            this.aP();
            resultConsumer.accept((MethodProfilerResults)methodprofilerresults);
        };
        this.C = dumpConsumer;
        this.D = true;
    }

    public void aP() {
        this.z = InactiveMetricsRecorder.a;
    }

    public void aQ() {
        this.z.a();
    }

    public void aR() {
        this.z.b();
        this.A = this.z.f();
    }

    public Path a(SavedFile worldSavePath) {
        return this.h.a(worldSavePath);
    }

    public boolean aS() {
        return true;
    }

    public StructureTemplateManager aT() {
        return this.av;
    }

    public SaveData aU() {
        return this.m;
    }

    public IRegistryCustom.Dimension aV() {
        return this.O.a();
    }

    public LayeredRegistryAccess<RegistryLayer> aW() {
        return this.O;
    }

    public ITextFilter a(EntityPlayer player) {
        return ITextFilter.a;
    }

    public PlayerInteractManager b(EntityPlayer player) {
        return this.R() ? new DemoPlayerInteractManager(player) : new PlayerInteractManager(player);
    }

    @Nullable
    public EnumGamemode aX() {
        return null;
    }

    public IResourceManager aY() {
        return this.au.a;
    }

    public boolean aZ() {
        return this.aw;
    }

    public boolean ba() {
        return this.F || this.E != null;
    }

    public void bb() {
        this.F = true;
    }

    public MethodProfilerResults bc() {
        if (this.E == null) {
            return MethodProfilerResultsEmpty.a;
        }
        MethodProfilerResults methodprofilerresults = this.E.a(SystemUtils.c(), this.T);
        this.E = null;
        return methodprofilerresults;
    }

    public int bd() {
        return 1000000;
    }

    public void a(IChatBaseComponent message, ChatMessageType.a params, @Nullable String prefix) {
        Component s1 = PaperAdventure.asAdventure(params.a(message));
        if (prefix != null) {
            COMPONENT_LOGGER.info("[{}] {}", (Object)prefix, (Object)s1);
        } else {
            COMPONENT_LOGGER.info("{}", (Object)s1);
        }
    }

    public ChatDecorator be() {
        return ChatDecorator.create((sender, commandSourceStack, message) -> {
            ChatDecorationProcessor processor = new ChatDecorationProcessor(this, sender, commandSourceStack, message);
            return processor.process();
        });
    }

    private boolean tickMidTickTasks() {
        boolean executed = false;
        for (WorldServer world : this.F()) {
            long currTime = System.nanoTime();
            if (currTime - world.lastMidTickExecuteFailure <= 5000L) continue;
            if (!world.k().d()) {
                world.lastMidTickExecuteFailure = currTime;
                continue;
            }
            executed = true;
        }
        return executed;
    }

    public final void executeMidTickTasks() {
        AsyncCatcher.catchOp("mid tick chunk task execution");
        long startTime = System.nanoTime();
        if (startTime - lastMidTickExecute <= 25000L || startTime - lastMidTickExecuteFailure <= 5000L) {
            return;
        }
        MinecraftTimings.midTickChunkTasks.startTiming();
        try {
            while (true) {
                long overuse;
                boolean moreTasks = this.tickMidTickTasks();
                long currTime = System.nanoTime();
                long diff = currTime - startTime;
                if (moreTasks && diff < 1000L) continue;
                if (!moreTasks) {
                    lastMidTickExecuteFailure = currTime;
                }
                if ((overuse = diff - 1000L) >= 10000000L) {
                    overuse = 10000000L;
                }
                double overuseCount = (double)overuse / 1000.0;
                long extraSleep = Math.round(overuseCount * 25000.0);
                lastMidTickExecute = currTime + extraSleep;
                return;
            }
        }
        finally {
            MinecraftTimings.midTickChunkTasks.stopTiming();
        }
    }

    static {
        n = LogUtils.getLogger();
        COMPONENT_LOGGER = ComponentLogger.logger((String)n.getName());
        f = new WorldSettings("Demo World", EnumGamemode.a, false, EnumDifficulty.c, false, new GameRules(), WorldDataConfiguration.c);
        g = new GameProfile(SystemUtils.c, "Anonymous Player");
        currentTick = 0;
        currentTickLong = 0L;
        TPS_BASE = new BigDecimal(1.0E9).multiply(new BigDecimal(20));
    }

    public static class TickTimes {
        private final long[] times;

        public TickTimes(int length) {
            this.times = new long[length];
        }

        void add(int index, long time) {
            this.times[index % this.times.length] = time;
        }

        public long[] getTimes() {
            return (long[])this.times.clone();
        }

        public double getAverage() {
            long total = 0L;
            for (long value : this.times) {
                total += value;
            }
            return (double)total / (double)this.times.length * 1.0E-6;
        }
    }

    public static class RollingAverage {
        private final int size;
        private long time;
        private BigDecimal total;
        private int index = 0;
        private final BigDecimal[] samples;
        private final long[] times;

        RollingAverage(int size) {
            this.size = size;
            this.time = (long)size * 1000000000L;
            this.total = RollingAverage.dec(20L).multiply(RollingAverage.dec(1000000000L)).multiply(RollingAverage.dec(size));
            this.samples = new BigDecimal[size];
            this.times = new long[size];
            for (int i2 = 0; i2 < size; ++i2) {
                this.samples[i2] = RollingAverage.dec(20L);
                this.times[i2] = 1000000000L;
            }
        }

        private static BigDecimal dec(long t2) {
            return new BigDecimal(t2);
        }

        public void add(BigDecimal x2, long t2) {
            this.time -= this.times[this.index];
            this.total = this.total.subtract(this.samples[this.index].multiply(RollingAverage.dec(this.times[this.index])));
            this.samples[this.index] = x2;
            this.times[this.index] = t2;
            this.time += t2;
            this.total = this.total.add(x2.multiply(RollingAverage.dec(t2)));
            if (++this.index == this.size) {
                this.index = 0;
            }
        }

        public double getAverage() {
            return this.total.divide(RollingAverage.dec(this.time), 30, RoundingMode.HALF_UP).doubleValue();
        }
    }

    public record ReloadableResources(IReloadableResourceManager a, DataPackResources b) implements AutoCloseable
    {
        @Override
        public void close() {
            this.a.close();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this, o2);
        }
    }

    private static class TimeProfiler {
        final long a;
        final int b;

        TimeProfiler(long time, int tick) {
            this.a = time;
            this.b = tick;
        }

        MethodProfilerResults a(final long endTime, final int endTick) {
            return new MethodProfilerResults(){

                @Override
                public List<MethodProfilerResultsField> a(String parentPath) {
                    return Collections.emptyList();
                }

                @Override
                public boolean a(Path path) {
                    return false;
                }

                @Override
                public long a() {
                    return a;
                }

                @Override
                public int b() {
                    return b;
                }

                @Override
                public long c() {
                    return endTime;
                }

                @Override
                public int d() {
                    return endTick;
                }

                @Override
                public String e() {
                    return "";
                }
            };
        }
    }

    public record ServerResourcePackInfo(String a, String b, boolean c, @Nullable IChatBaseComponent d) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ServerResourcePackInfo.class, "url;hash;isRequired;prompt", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ServerResourcePackInfo.class, "url;hash;isRequired;prompt", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ServerResourcePackInfo.class, "url;hash;isRequired;prompt", "a", "b", "c", "d"}, this, o2);
        }
    }
}

