/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.CommandReload;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;

public class CommandDatapack {
    private static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(name -> IChatBaseComponent.a("commands.datapack.unknown", name));
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(name -> IChatBaseComponent.a("commands.datapack.enable.failed", name));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(name -> IChatBaseComponent.a("commands.datapack.disable.failed", name));
    private static final Dynamic2CommandExceptionType d = new Dynamic2CommandExceptionType((name, flags) -> IChatBaseComponent.a("commands.datapack.enable.failed.no_flags", name, flags));
    private static final SuggestionProvider<CommandListenerWrapper> e = (context, builder) -> ICompletionProvider.b(((CommandListenerWrapper)context.getSource()).l().aB().d().stream().map(StringArgumentType::escapeIfRequired), builder);
    private static final SuggestionProvider<CommandListenerWrapper> f = (context, builder) -> {
        ResourcePackRepository packRepository = ((CommandListenerWrapper)context.getSource()).l().aB();
        Collection<String> collection = packRepository.d();
        FeatureFlagSet featureFlagSet = ((CommandListenerWrapper)context.getSource()).w();
        return ICompletionProvider.b(packRepository.c().stream().filter(profile -> profile.d().a(featureFlagSet)).map(ResourcePackLoader::f).filter(name -> !collection.contains(name)).map(StringArgumentType::escapeIfRequired), builder);
    };

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("datapack").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("enable").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("name", StringArgumentType.string()).suggests(f).executes(context -> CommandDatapack.a((CommandListenerWrapper)context.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)context, "name", true), (List<ResourcePackLoader> profiles, ResourcePackLoader profile2) -> profile2.i().a(profiles, profile2, profile -> profile, false)))).then(net.minecraft.commands.CommandDispatcher.a("after").then(net.minecraft.commands.CommandDispatcher.a("existing", StringArgumentType.string()).suggests(e).executes(context -> CommandDatapack.a((CommandListenerWrapper)context.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)context, "name", true), (List<ResourcePackLoader> profiles, ResourcePackLoader profile) -> profiles.add(profiles.indexOf(CommandDatapack.a((CommandContext<CommandListenerWrapper>)context, "existing", false)) + 1, profile)))))).then(net.minecraft.commands.CommandDispatcher.a("before").then(net.minecraft.commands.CommandDispatcher.a("existing", StringArgumentType.string()).suggests(e).executes(context -> CommandDatapack.a((CommandListenerWrapper)context.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)context, "name", true), (List<ResourcePackLoader> profiles, ResourcePackLoader profile) -> profiles.add(profiles.indexOf(CommandDatapack.a((CommandContext<CommandListenerWrapper>)context, "existing", false)), profile)))))).then(net.minecraft.commands.CommandDispatcher.a("last").executes(context -> CommandDatapack.a((CommandListenerWrapper)context.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)context, "name", true), List::add)))).then(net.minecraft.commands.CommandDispatcher.a("first").executes(context -> CommandDatapack.a((CommandListenerWrapper)context.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)context, "name", true), (List<ResourcePackLoader> profiles, ResourcePackLoader profile) -> profiles.add(0, profile))))))).then(net.minecraft.commands.CommandDispatcher.a("disable").then(net.minecraft.commands.CommandDispatcher.a("name", StringArgumentType.string()).suggests(e).executes(context -> CommandDatapack.a((CommandListenerWrapper)context.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)context, "name", false)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("list").executes(context -> CommandDatapack.a((CommandListenerWrapper)context.getSource()))).then(net.minecraft.commands.CommandDispatcher.a("available").executes(context -> CommandDatapack.b((CommandListenerWrapper)context.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("enabled").executes(context -> CommandDatapack.c((CommandListenerWrapper)context.getSource()))))));
    }

    private static int a(CommandListenerWrapper source, ResourcePackLoader container, a packAdder) throws CommandSyntaxException {
        ResourcePackRepository packRepository = source.l().aB();
        ArrayList list = Lists.newArrayList(packRepository.f());
        packAdder.apply(list, container);
        source.a(() -> IChatBaseComponent.a("commands.datapack.modify.enable", container.a(true)), true);
        CommandReload.a(list.stream().map(ResourcePackLoader::f).collect(Collectors.toList()), source);
        return list.size();
    }

    private static int a(CommandListenerWrapper source, ResourcePackLoader container) {
        ResourcePackRepository packRepository = source.l().aB();
        ArrayList list = Lists.newArrayList(packRepository.f());
        list.remove(container);
        source.a(() -> IChatBaseComponent.a("commands.datapack.modify.disable", container.a(true)), true);
        CommandReload.a(list.stream().map(ResourcePackLoader::f).collect(Collectors.toList()), source);
        return list.size();
    }

    private static int a(CommandListenerWrapper source) {
        return CommandDatapack.c(source) + CommandDatapack.b(source);
    }

    private static int b(CommandListenerWrapper source) {
        ResourcePackRepository packRepository = source.l().aB();
        packRepository.a();
        Collection<ResourcePackLoader> collection = packRepository.f();
        Collection<ResourcePackLoader> collection2 = packRepository.c();
        FeatureFlagSet featureFlagSet = source.w();
        List<ResourcePackLoader> list = collection2.stream().filter(profile -> !collection.contains(profile) && profile.d().a(featureFlagSet)).toList();
        if (list.isEmpty()) {
            source.a(() -> IChatBaseComponent.c("commands.datapack.list.available.none"), false);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.datapack.list.available.success", list.size(), ChatComponentUtils.b(list, (T profile) -> profile.a(false))), false);
        }
        return list.size();
    }

    private static int c(CommandListenerWrapper source) {
        ResourcePackRepository packRepository = source.l().aB();
        packRepository.a();
        Collection<ResourcePackLoader> collection = packRepository.f();
        if (collection.isEmpty()) {
            source.a(() -> IChatBaseComponent.c("commands.datapack.list.enabled.none"), false);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.datapack.list.enabled.success", collection.size(), ChatComponentUtils.b(collection, (T profile) -> profile.a(true))), false);
        }
        return collection.size();
    }

    private static ResourcePackLoader a(CommandContext<CommandListenerWrapper> context, String name, boolean enable) throws CommandSyntaxException {
        String string = StringArgumentType.getString(context, (String)name);
        ResourcePackRepository packRepository = ((CommandListenerWrapper)context.getSource()).l().aB();
        ResourcePackLoader pack = packRepository.c(string);
        if (pack == null) {
            throw a.create((Object)string);
        }
        boolean bl = packRepository.f().contains(pack);
        if (enable && bl) {
            throw b.create((Object)string);
        }
        if (!enable && !bl) {
            throw c.create((Object)string);
        }
        FeatureFlagSet featureFlagSet = ((CommandListenerWrapper)context.getSource()).w();
        FeatureFlagSet featureFlagSet2 = pack.d();
        if (!featureFlagSet2.a(featureFlagSet)) {
            throw d.create((Object)string, (Object)FeatureFlags.a(featureFlagSet, featureFlagSet2));
        }
        return pack;
    }

    static interface a {
        public void apply(List<ResourcePackLoader> var1, ResourcePackLoader var2) throws CommandSyntaxException;
    }
}

