/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.ResultConsumer;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.commands.arguments.HeightmapTypeArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentRotationAxis;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.bossevents.BossBattleCustom;
import net.minecraft.server.commands.CommandBossBar;
import net.minecraft.server.commands.CommandSummon;
import net.minecraft.server.commands.data.CommandData;
import net.minecraft.server.commands.data.CommandDataAccessor;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;

public class CommandExecute {
    private static final int a = 32768;
    private static final Dynamic2CommandExceptionType b = new Dynamic2CommandExceptionType((maxCount, count) -> IChatBaseComponent.a("commands.execute.blocks.toobig", maxCount, count));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.execute.conditional.fail"));
    private static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(count -> IChatBaseComponent.a("commands.execute.conditional.fail_count", count));
    private static final BinaryOperator<ResultConsumer<CommandListenerWrapper>> e = (consumer, consumer2) -> (context, success, result) -> {
        consumer.onCommandComplete(context, success, result);
        consumer2.onCommandComplete(context, success, result);
    };
    private static final SuggestionProvider<CommandListenerWrapper> f = (context, builder) -> {
        LootDataManager lootDataManager = ((CommandListenerWrapper)context.getSource()).l().aH();
        return ICompletionProvider.a(lootDataManager.a(LootDataType.a), builder);
    };

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext commandRegistryAccess) {
        LiteralCommandNode<CommandListenerWrapper> literalCommandNode = dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("execute").requires(source -> source.c(2))));
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("execute").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("run").redirect(dispatcher.getRoot()))).then(CommandExecute.a(literalCommandNode, net.minecraft.commands.CommandDispatcher.a("if"), true, commandRegistryAccess))).then(CommandExecute.a(literalCommandNode, net.minecraft.commands.CommandDispatcher.a("unless"), false, commandRegistryAccess))).then(net.minecraft.commands.CommandDispatcher.a("as").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context, "targets")) {
                list.add(((CommandListenerWrapper)context.getSource()).a(entity));
            }
            return list;
        })))).then(net.minecraft.commands.CommandDispatcher.a("at").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context, "targets")) {
                list.add(((CommandListenerWrapper)context.getSource()).a((WorldServer)entity.dI()).a(entity.dg()).a(entity.bE()));
            }
            return list;
        })))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("store").then(CommandExecute.a(literalCommandNode, net.minecraft.commands.CommandDispatcher.a("result"), true))).then(CommandExecute.a(literalCommandNode, net.minecraft.commands.CommandDispatcher.a("success"), false)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("positioned").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentVec3.a()).redirect(literalCommandNode, context -> ((CommandListenerWrapper)context.getSource()).a(ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context, "pos")).a(ArgumentAnchor.Anchor.a)))).then(net.minecraft.commands.CommandDispatcher.a("as").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context, "targets")) {
                list.add(((CommandListenerWrapper)context.getSource()).a(entity.dg()));
            }
            return list;
        })))).then(net.minecraft.commands.CommandDispatcher.a("over").then(net.minecraft.commands.CommandDispatcher.a("heightmap", HeightmapTypeArgument.a()).redirect(literalCommandNode, context -> {
            Vec3D vec3 = ((CommandListenerWrapper)context.getSource()).d();
            WorldServer serverLevel = ((CommandListenerWrapper)context.getSource()).e();
            double d2 = vec3.a();
            double e2 = vec3.c();
            if (!serverLevel.b(SectionPosition.b(d2), SectionPosition.b(e2))) {
                throw ArgumentPosition.a.create();
            }
            int i2 = serverLevel.a(HeightmapTypeArgument.a((CommandContext<CommandListenerWrapper>)context, "heightmap"), MathHelper.a(d2), MathHelper.a(e2));
            return ((CommandListenerWrapper)context.getSource()).a(new Vec3D(d2, i2, e2));
        }))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("rotated").then(net.minecraft.commands.CommandDispatcher.a("rot", ArgumentRotation.a()).redirect(literalCommandNode, context -> ((CommandListenerWrapper)context.getSource()).a(ArgumentRotation.a((CommandContext<CommandListenerWrapper>)context, "rot").b((CommandListenerWrapper)context.getSource()))))).then(net.minecraft.commands.CommandDispatcher.a("as").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context, "targets")) {
                list.add(((CommandListenerWrapper)context.getSource()).a(entity.bE()));
            }
            return list;
        }))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("facing").then(net.minecraft.commands.CommandDispatcher.a("entity").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(net.minecraft.commands.CommandDispatcher.a("anchor", ArgumentAnchor.a()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            ArgumentAnchor.Anchor anchor = ArgumentAnchor.a((CommandContext<CommandListenerWrapper>)context, "anchor");
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context, "targets")) {
                list.add(((CommandListenerWrapper)context.getSource()).a(entity, anchor));
            }
            return list;
        }))))).then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentVec3.a()).redirect(literalCommandNode, context -> ((CommandListenerWrapper)context.getSource()).b(ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context, "pos")))))).then(net.minecraft.commands.CommandDispatcher.a("align").then(net.minecraft.commands.CommandDispatcher.a("axes", ArgumentRotationAxis.a()).redirect(literalCommandNode, context -> ((CommandListenerWrapper)context.getSource()).a(((CommandListenerWrapper)context.getSource()).d().a(ArgumentRotationAxis.a((CommandContext<CommandListenerWrapper>)context, "axes"))))))).then(net.minecraft.commands.CommandDispatcher.a("anchored").then(net.minecraft.commands.CommandDispatcher.a("anchor", ArgumentAnchor.a()).redirect(literalCommandNode, context -> ((CommandListenerWrapper)context.getSource()).a(ArgumentAnchor.a((CommandContext<CommandListenerWrapper>)context, "anchor")))))).then(net.minecraft.commands.CommandDispatcher.a("in").then(net.minecraft.commands.CommandDispatcher.a("dimension", ArgumentDimension.a()).redirect(literalCommandNode, context -> ((CommandListenerWrapper)context.getSource()).a(ArgumentDimension.a((CommandContext<CommandListenerWrapper>)context, "dimension")))))).then(net.minecraft.commands.CommandDispatcher.a("summon").then(net.minecraft.commands.CommandDispatcher.a("entity", ResourceArgument.a(commandRegistryAccess, Registries.s)).suggests(CompletionProviders.d).redirect(literalCommandNode, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), ResourceArgument.e((CommandContext<CommandListenerWrapper>)context, "entity")))))).then(CommandExecute.a(literalCommandNode, net.minecraft.commands.CommandDispatcher.a("on")))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(LiteralCommandNode<CommandListenerWrapper> node, LiteralArgumentBuilder<CommandListenerWrapper> builder2, boolean requestResult) {
        builder2.then(net.minecraft.commands.CommandDispatcher.a("score").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentScoreholder.b()).suggests(ArgumentScoreholder.a).then(net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).redirect(node, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context, "objective"), requestResult)))));
        builder2.then(net.minecraft.commands.CommandDispatcher.a("bossbar").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("id", ArgumentMinecraftKeyRegistered.a()).suggests(CommandBossBar.a).then(net.minecraft.commands.CommandDispatcher.a("value").redirect(node, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), true, requestResult)))).then(net.minecraft.commands.CommandDispatcher.a("max").redirect(node, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), false, requestResult)))));
        for (CommandData.c dataProvider : CommandData.b) {
            dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)builder2, builder -> builder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("path", ArgumentNBTKey.a()).then(net.minecraft.commands.CommandDispatcher.a("int").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)node, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"), (int result) -> NBTTagInt.a((int)((double)result * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), requestResult))))).then(net.minecraft.commands.CommandDispatcher.a("float").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)node, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"), (int result) -> NBTTagFloat.a((float)((double)result * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), requestResult))))).then(net.minecraft.commands.CommandDispatcher.a("short").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)node, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"), (int result) -> NBTTagShort.a((short)((double)result * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), requestResult))))).then(net.minecraft.commands.CommandDispatcher.a("long").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)node, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"), (int result) -> NBTTagLong.a((long)((double)result * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), requestResult))))).then(net.minecraft.commands.CommandDispatcher.a("double").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)node, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"), (int result) -> NBTTagDouble.a((double)result * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale")), requestResult))))).then(net.minecraft.commands.CommandDispatcher.a("byte").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)node, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"), (int result) -> NBTTagByte.a((byte)((double)result * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), requestResult))))));
        }
        return builder2;
    }

    private static CommandListenerWrapper a(CommandListenerWrapper source, Collection<String> targets, ScoreboardObjective objective, boolean requestResult) {
        ScoreboardServer scoreboard = source.l().aF();
        return source.a((ResultConsumer<CommandListenerWrapper>)((ResultConsumer)(context, success, result) -> {
            for (String string : targets) {
                ScoreboardScore score = scoreboard.c(string, objective);
                int i2 = requestResult ? result : (success ? 1 : 0);
                score.b(i2);
            }
        }), e);
    }

    private static CommandListenerWrapper a(CommandListenerWrapper source, BossBattleCustom bossBar, boolean storeInValue, boolean requestResult) {
        return source.a((ResultConsumer<CommandListenerWrapper>)((ResultConsumer)(context, success, result) -> {
            int i2;
            int n2 = requestResult ? result : (i2 = success ? 1 : 0);
            if (storeInValue) {
                bossBar.a(i2);
            } else {
                bossBar.b(i2);
            }
        }), e);
    }

    private static CommandListenerWrapper a(CommandListenerWrapper source, CommandDataAccessor object, ArgumentNBTKey.g path, IntFunction<NBTBase> nbtSetter, boolean requestResult) {
        return source.a((ResultConsumer<CommandListenerWrapper>)((ResultConsumer)(context, success, result) -> {
            try {
                NBTTagCompound compoundTag = object.a();
                int i2 = requestResult ? result : (success ? 1 : 0);
                path.a((NBTBase)compoundTag, (NBTBase)nbtSetter.apply(i2));
                object.a(compoundTag);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }), e);
    }

    private static boolean a(WorldServer world, BlockPosition pos) {
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(pos);
        Chunk levelChunk = world.k().a(chunkPos.e, chunkPos.f);
        if (levelChunk != null) {
            return levelChunk.D() == FullChunkStatus.d && world.c(chunkPos.a());
        }
        return false;
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandNode<CommandListenerWrapper> root, LiteralArgumentBuilder<CommandListenerWrapper> argumentBuilder, boolean positive, CommandBuildContext commandRegistryAccess) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)argumentBuilder.then(net.minecraft.commands.CommandDispatcher.a("block").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("block", ArgumentBlockPredicate.a(commandRegistryAccess)), positive, (CommandContext<CommandListenerWrapper> context) -> ArgumentBlockPredicate.a((CommandContext<CommandListenerWrapper>)context, "block").test(new ShapeDetectorBlock(((CommandListenerWrapper)context.getSource()).e(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), true))))))).then(net.minecraft.commands.CommandDispatcher.a("biome").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("biome", ResourceOrTagArgument.a(commandRegistryAccess, Registries.ap)), positive, (CommandContext<CommandListenerWrapper> context) -> ResourceOrTagArgument.a((CommandContext<CommandListenerWrapper>)context, "biome", Registries.ap).test(((CommandListenerWrapper)context.getSource()).e().s(ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos")))))))).then(net.minecraft.commands.CommandDispatcher.a("loaded").then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()), positive, (CommandContext<CommandListenerWrapper> commandContext) -> CommandExecute.a(((CommandListenerWrapper)commandContext.getSource()).e(), ArgumentPosition.b((CommandContext<CommandListenerWrapper>)commandContext, "pos")))))).then(net.minecraft.commands.CommandDispatcher.a("dimension").then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("dimension", ArgumentDimension.a()), positive, (CommandContext<CommandListenerWrapper> context) -> ArgumentDimension.a((CommandContext<CommandListenerWrapper>)context, "dimension") == ((CommandListenerWrapper)context.getSource()).e())))).then(net.minecraft.commands.CommandDispatcher.a("score").then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targetObjective", ArgumentScoreboardObjective.a()).then(net.minecraft.commands.CommandDispatcher.a("=").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), positive, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, Integer::equals)))))).then(net.minecraft.commands.CommandDispatcher.a("<").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), positive, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, (Integer a2, Integer b2) -> a2 < b2)))))).then(net.minecraft.commands.CommandDispatcher.a("<=").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), positive, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, (Integer a2, Integer b2) -> a2 <= b2)))))).then(net.minecraft.commands.CommandDispatcher.a(">").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), positive, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, (Integer a2, Integer b2) -> a2 > b2)))))).then(net.minecraft.commands.CommandDispatcher.a(">=").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), positive, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, (Integer a2, Integer b2) -> a2 >= b2)))))).then(net.minecraft.commands.CommandDispatcher.a("matches").then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("range", ArgumentCriterionValue.a()), positive, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, ArgumentCriterionValue.b.a((CommandContext<CommandListenerWrapper>)context, "range"))))))))).then(net.minecraft.commands.CommandDispatcher.a("blocks").then(net.minecraft.commands.CommandDispatcher.a("start", ArgumentPosition.a()).then(net.minecraft.commands.CommandDispatcher.a("end", ArgumentPosition.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("destination", ArgumentPosition.a()).then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("all"), positive, false))).then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("masked"), positive, true))))))).then(net.minecraft.commands.CommandDispatcher.a("entity").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("entities", ArgumentEntity.b()).fork(root, context -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, positive, !ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context, "entities").isEmpty()))).executes(CommandExecute.a(positive, (CommandContext<CommandListenerWrapper> context) -> ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context, "entities").size()))))).then(net.minecraft.commands.CommandDispatcher.a("predicate").then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("predicate", ArgumentMinecraftKeyRegistered.a()).suggests(f), positive, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.c((CommandContext<CommandListenerWrapper>)context, "predicate")))));
        for (CommandData.c dataProvider : CommandData.c) {
            argumentBuilder.then(dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("data"), builder -> builder.then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("path", ArgumentNBTKey.a()).fork(root, context -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, positive, CommandExecute.a(dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path")) > 0))).executes(CommandExecute.a(positive, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a(dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path")))))));
        }
        return argumentBuilder;
    }

    private static Command<CommandListenerWrapper> a(boolean positive, a condition) {
        if (positive) {
            return context -> {
                int i2 = condition.test((CommandContext<CommandListenerWrapper>)context);
                if (i2 > 0) {
                    ((CommandListenerWrapper)context.getSource()).a(() -> IChatBaseComponent.a("commands.execute.conditional.pass_count", i2), false);
                    return i2;
                }
                throw c.create();
            };
        }
        return context -> {
            int i2 = condition.test((CommandContext<CommandListenerWrapper>)context);
            if (i2 == 0) {
                ((CommandListenerWrapper)context.getSource()).a(() -> IChatBaseComponent.c("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw d.create((Object)i2);
        };
    }

    private static int a(CommandDataAccessor object, ArgumentNBTKey.g path) throws CommandSyntaxException {
        return path.b(object.a());
    }

    private static boolean a(CommandContext<CommandListenerWrapper> context, BiPredicate<Integer, Integer> condition) throws CommandSyntaxException {
        String string = ArgumentScoreholder.a(context, "target");
        ScoreboardObjective objective = ArgumentScoreboardObjective.a(context, "targetObjective");
        String string2 = ArgumentScoreholder.a(context, "source");
        ScoreboardObjective objective2 = ArgumentScoreboardObjective.a(context, "sourceObjective");
        ScoreboardServer scoreboard = ((CommandListenerWrapper)context.getSource()).l().aF();
        if (!scoreboard.b(string, objective) || !scoreboard.b(string2, objective2)) {
            return false;
        }
        ScoreboardScore score = scoreboard.c(string, objective);
        ScoreboardScore score2 = scoreboard.c(string2, objective2);
        return condition.test(score.b(), score2.b());
    }

    private static boolean a(CommandContext<CommandListenerWrapper> context, CriterionConditionValue.IntegerRange range) throws CommandSyntaxException {
        String string = ArgumentScoreholder.a(context, "target");
        ScoreboardObjective objective = ArgumentScoreboardObjective.a(context, "targetObjective");
        ScoreboardServer scoreboard = ((CommandListenerWrapper)context.getSource()).l().aF();
        if (!scoreboard.b(string, objective)) {
            return false;
        }
        return range.d(scoreboard.c(string, objective).b());
    }

    private static boolean a(CommandListenerWrapper source, LootItemCondition condition) {
        WorldServer serverLevel = source.e();
        LootParams lootParams = new LootParams.a(serverLevel).a(LootContextParameters.f, source.d()).b(LootContextParameters.a, source.f()).a(LootContextParameterSets.c);
        LootTableInfo lootContext = new LootTableInfo.Builder(lootParams).a(null);
        lootContext.b(LootTableInfo.a(condition));
        return condition.test(lootContext);
    }

    private static Collection<CommandListenerWrapper> a(CommandContext<CommandListenerWrapper> context, boolean positive, boolean value) {
        if (value == positive) {
            return Collections.singleton((CommandListenerWrapper)context.getSource());
        }
        return Collections.emptyList();
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandNode<CommandListenerWrapper> root, ArgumentBuilder<CommandListenerWrapper, ?> builder, boolean positive, b condition) {
        return ((ArgumentBuilder)builder.fork(root, (RedirectModifier<CommandListenerWrapper>)((RedirectModifier)context -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, positive, condition.test((CommandContext<CommandListenerWrapper>)context))))).executes(context -> {
            if (positive == condition.test((CommandContext<CommandListenerWrapper>)context)) {
                ((CommandListenerWrapper)context.getSource()).a(() -> IChatBaseComponent.c("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw c.create();
        });
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandNode<CommandListenerWrapper> root, ArgumentBuilder<CommandListenerWrapper, ?> builder, boolean positive, boolean masked) {
        return ((ArgumentBuilder)builder.fork(root, (RedirectModifier<CommandListenerWrapper>)((RedirectModifier)context -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, positive, CommandExecute.c((CommandContext<CommandListenerWrapper>)context, masked).isPresent())))).executes(positive ? context -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, masked) : context -> CommandExecute.b((CommandContext<CommandListenerWrapper>)context, masked));
    }

    private static int a(CommandContext<CommandListenerWrapper> context, boolean masked) throws CommandSyntaxException {
        OptionalInt optionalInt = CommandExecute.c(context, masked);
        if (optionalInt.isPresent()) {
            ((CommandListenerWrapper)context.getSource()).a(() -> IChatBaseComponent.a("commands.execute.conditional.pass_count", optionalInt.getAsInt()), false);
            return optionalInt.getAsInt();
        }
        throw c.create();
    }

    private static int b(CommandContext<CommandListenerWrapper> context, boolean masked) throws CommandSyntaxException {
        OptionalInt optionalInt = CommandExecute.c(context, masked);
        if (optionalInt.isPresent()) {
            throw d.create((Object)optionalInt.getAsInt());
        }
        ((CommandListenerWrapper)context.getSource()).a(() -> IChatBaseComponent.c("commands.execute.conditional.pass"), false);
        return 1;
    }

    private static OptionalInt c(CommandContext<CommandListenerWrapper> context, boolean masked) throws CommandSyntaxException {
        return CommandExecute.a(((CommandListenerWrapper)context.getSource()).e(), ArgumentPosition.a(context, "start"), ArgumentPosition.a(context, "end"), ArgumentPosition.a(context, "destination"), masked);
    }

    private static OptionalInt a(WorldServer world, BlockPosition start, BlockPosition end, BlockPosition destination, boolean masked) throws CommandSyntaxException {
        StructureBoundingBox boundingBox = StructureBoundingBox.a(start, end);
        StructureBoundingBox boundingBox2 = StructureBoundingBox.a(destination, destination.a(boundingBox.b()));
        BlockPosition blockPos = new BlockPosition(boundingBox2.g() - boundingBox.g(), boundingBox2.h() - boundingBox.h(), boundingBox2.i() - boundingBox.i());
        int i2 = boundingBox.c() * boundingBox.d() * boundingBox.e();
        if (i2 > 32768) {
            throw b.create((Object)32768, (Object)i2);
        }
        int j2 = 0;
        for (int k2 = boundingBox.i(); k2 <= boundingBox.l(); ++k2) {
            for (int l2 = boundingBox.h(); l2 <= boundingBox.k(); ++l2) {
                for (int m2 = boundingBox.g(); m2 <= boundingBox.j(); ++m2) {
                    BlockPosition blockPos2 = new BlockPosition(m2, l2, k2);
                    BlockPosition blockPos3 = blockPos2.a(blockPos);
                    IBlockData blockState = world.a_(blockPos2);
                    if (masked && blockState.a(Blocks.a)) continue;
                    if (blockState != world.a_(blockPos3)) {
                        return OptionalInt.empty();
                    }
                    TileEntity blockEntity = world.c_(blockPos2);
                    TileEntity blockEntity2 = world.c_(blockPos3);
                    if (blockEntity != null) {
                        NBTTagCompound compoundTag2;
                        if (blockEntity2 == null) {
                            return OptionalInt.empty();
                        }
                        if (blockEntity2.u() != blockEntity.u()) {
                            return OptionalInt.empty();
                        }
                        NBTTagCompound compoundTag = blockEntity.o();
                        if (!compoundTag.equals(compoundTag2 = blockEntity2.o())) {
                            return OptionalInt.empty();
                        }
                    }
                    ++j2;
                }
            }
        }
        return OptionalInt.of(j2);
    }

    private static RedirectModifier<CommandListenerWrapper> a(Function<Entity, Optional<Entity>> function) {
        return context -> {
            CommandListenerWrapper commandSourceStack = (CommandListenerWrapper)context.getSource();
            Entity entity2 = commandSourceStack.f();
            if (entity2 == null) {
                return List.of();
            }
            return ((Optional)function.apply(entity2)).filter(entity -> !entity.dD()).map(entity -> List.of(commandSourceStack.a((Entity)entity))).orElse(List.of());
        };
    }

    private static RedirectModifier<CommandListenerWrapper> b(Function<Entity, Stream<Entity>> function) {
        return context -> {
            CommandListenerWrapper commandSourceStack = (CommandListenerWrapper)context.getSource();
            Entity entity2 = commandSourceStack.f();
            if (entity2 == null) {
                return List.of();
            }
            return ((Stream)function.apply(entity2)).filter(entity -> !entity.dD()).map(commandSourceStack::a).toList();
        };
    }

    private static LiteralArgumentBuilder<CommandListenerWrapper> a(CommandNode<CommandListenerWrapper> node, LiteralArgumentBuilder<CommandListenerWrapper> builder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(net.minecraft.commands.CommandDispatcher.a("owner").fork(node, CommandExecute.a((Entity entity) -> {
            Optional<Object> optional;
            if (entity instanceof OwnableEntity) {
                OwnableEntity ownableEntity = (OwnableEntity)((Object)entity);
                optional = Optional.ofNullable(ownableEntity.I_());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.a("leasher").fork(node, CommandExecute.a((Entity entity) -> {
            Optional<Object> optional;
            if (entity instanceof EntityInsentient) {
                EntityInsentient mob = (EntityInsentient)entity;
                optional = Optional.ofNullable(mob.fP());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.a("target").fork(node, CommandExecute.a((Entity entity) -> {
            Optional<Object> optional;
            if (entity instanceof Targeting) {
                Targeting targeting = (Targeting)((Object)entity);
                optional = Optional.ofNullable(targeting.j());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.a("attacker").fork(node, CommandExecute.a((Entity entity) -> {
            Optional<Object> optional;
            if (entity instanceof Attackable) {
                Attackable attackable = (Attackable)((Object)entity);
                optional = Optional.ofNullable(attackable.M_());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.a("vehicle").fork(node, CommandExecute.a((Entity entity) -> Optional.ofNullable(entity.cW()))))).then(net.minecraft.commands.CommandDispatcher.a("controller").fork(node, CommandExecute.a((Entity entity) -> Optional.ofNullable(entity.cL()))))).then(net.minecraft.commands.CommandDispatcher.a("origin").fork(node, CommandExecute.a((Entity entity) -> {
            Optional<Object> optional;
            if (entity instanceof TraceableEntity) {
                TraceableEntity traceableEntity = (TraceableEntity)((Object)entity);
                optional = Optional.ofNullable(traceableEntity.v());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.a("passengers").fork(node, CommandExecute.b((Entity entity) -> entity.cN().stream())));
    }

    private static CommandListenerWrapper a(CommandListenerWrapper source, Holder.c<EntityTypes<?>> entityType) throws CommandSyntaxException {
        Entity entity = CommandSummon.a(source, entityType, source.d(), new NBTTagCompound(), true);
        return source.a(entity);
    }

    @FunctionalInterface
    static interface b {
        public boolean test(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface a {
        public int test(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;
    }
}

