/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Locale;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.Vec2F;

public class CommandWorldBorder {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.worldborder.center.failed"));
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.worldborder.set.failed.nochange"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.worldborder.set.failed.small"));
    private static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)IChatBaseComponent.a("commands.worldborder.set.failed.big", 5.9999968E7));
    private static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)IChatBaseComponent.a("commands.worldborder.set.failed.far", 2.9999984E7));
    private static final SimpleCommandExceptionType f = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.worldborder.warning.time.failed"));
    private static final SimpleCommandExceptionType g = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.worldborder.warning.distance.failed"));
    private static final SimpleCommandExceptionType h = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.worldborder.damage.buffer.failed"));
    private static final SimpleCommandExceptionType i = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.worldborder.damage.amount.failed"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("worldborder").requires(commandlistenerwrapper -> commandlistenerwrapper.c(2))).then(net.minecraft.commands.CommandDispatcher.a("add").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("distance", DoubleArgumentType.doubleArg((double)-5.9999968E7, (double)5.9999968E7)).executes(commandcontext -> CommandWorldBorder.a((CommandListenerWrapper)commandcontext.getSource(), ((CommandListenerWrapper)commandcontext.getSource()).e().w_().i() + DoubleArgumentType.getDouble((CommandContext)commandcontext, (String)"distance"), 0L))).then(net.minecraft.commands.CommandDispatcher.a("time", IntegerArgumentType.integer((int)0)).executes(commandcontext -> CommandWorldBorder.a((CommandListenerWrapper)commandcontext.getSource(), ((CommandListenerWrapper)commandcontext.getSource()).e().w_().i() + DoubleArgumentType.getDouble((CommandContext)commandcontext, (String)"distance"), ((CommandListenerWrapper)commandcontext.getSource()).e().w_().j() + (long)IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time") * 1000L)))))).then(net.minecraft.commands.CommandDispatcher.a("set").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("distance", DoubleArgumentType.doubleArg((double)-5.9999968E7, (double)5.9999968E7)).executes(commandcontext -> CommandWorldBorder.a((CommandListenerWrapper)commandcontext.getSource(), DoubleArgumentType.getDouble((CommandContext)commandcontext, (String)"distance"), 0L))).then(net.minecraft.commands.CommandDispatcher.a("time", IntegerArgumentType.integer((int)0)).executes(commandcontext -> CommandWorldBorder.a((CommandListenerWrapper)commandcontext.getSource(), DoubleArgumentType.getDouble((CommandContext)commandcontext, (String)"distance"), (long)IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time") * 1000L)))))).then(net.minecraft.commands.CommandDispatcher.a("center").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentVec2.a()).executes(commandcontext -> CommandWorldBorder.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentVec2.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("damage").then(net.minecraft.commands.CommandDispatcher.a("amount").then(net.minecraft.commands.CommandDispatcher.a("damagePerBlock", FloatArgumentType.floatArg((float)0.0f)).executes(commandcontext -> CommandWorldBorder.b((CommandListenerWrapper)commandcontext.getSource(), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"damagePerBlock")))))).then(net.minecraft.commands.CommandDispatcher.a("buffer").then(net.minecraft.commands.CommandDispatcher.a("distance", FloatArgumentType.floatArg((float)0.0f)).executes(commandcontext -> CommandWorldBorder.a((CommandListenerWrapper)commandcontext.getSource(), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"distance"))))))).then(net.minecraft.commands.CommandDispatcher.a("get").executes(commandcontext -> CommandWorldBorder.a((CommandListenerWrapper)commandcontext.getSource())))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("warning").then(net.minecraft.commands.CommandDispatcher.a("distance").then(net.minecraft.commands.CommandDispatcher.a("distance", IntegerArgumentType.integer((int)0)).executes(commandcontext -> CommandWorldBorder.b((CommandListenerWrapper)commandcontext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"distance")))))).then(net.minecraft.commands.CommandDispatcher.a("time").then(net.minecraft.commands.CommandDispatcher.a("time", IntegerArgumentType.integer((int)0)).executes(commandcontext -> CommandWorldBorder.a((CommandListenerWrapper)commandcontext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time"))))))));
    }

    private static int a(CommandListenerWrapper source, float distance) throws CommandSyntaxException {
        WorldBorder worldborder = source.e().w_();
        if (worldborder.n() == (double)distance) {
            throw h.create();
        }
        worldborder.b(distance);
        source.a(() -> IChatBaseComponent.a("commands.worldborder.damage.buffer.success", new Object[]{String.format(Locale.ROOT, "%.2f", Float.valueOf(distance))}), true);
        return (int)distance;
    }

    private static int b(CommandListenerWrapper source, float damagePerBlock) throws CommandSyntaxException {
        WorldBorder worldborder = source.e().w_();
        if (worldborder.o() == (double)damagePerBlock) {
            throw i.create();
        }
        worldborder.c(damagePerBlock);
        source.a(() -> IChatBaseComponent.a("commands.worldborder.damage.amount.success", new Object[]{String.format(Locale.ROOT, "%.2f", Float.valueOf(damagePerBlock))}), true);
        return (int)damagePerBlock;
    }

    private static int a(CommandListenerWrapper source, int time) throws CommandSyntaxException {
        WorldBorder worldborder = source.e().w_();
        if (worldborder.q() == time) {
            throw f.create();
        }
        worldborder.b(time);
        source.a(() -> IChatBaseComponent.a("commands.worldborder.warning.time.success", time), true);
        return time;
    }

    private static int b(CommandListenerWrapper source, int distance) throws CommandSyntaxException {
        WorldBorder worldborder = source.e().w_();
        if (worldborder.r() == distance) {
            throw g.create();
        }
        worldborder.c(distance);
        source.a(() -> IChatBaseComponent.a("commands.worldborder.warning.distance.success", distance), true);
        return distance;
    }

    private static int a(CommandListenerWrapper source) {
        double d0 = source.e().w_().i();
        source.a(() -> IChatBaseComponent.a("commands.worldborder.get", new Object[]{String.format(Locale.ROOT, "%.0f", d0)}), false);
        return MathHelper.a(d0 + 0.5);
    }

    private static int a(CommandListenerWrapper source, Vec2F pos) throws CommandSyntaxException {
        WorldBorder worldborder = source.e().w_();
        if (worldborder.a() == (double)pos.i && worldborder.b() == (double)pos.j) {
            throw a.create();
        }
        if ((double)Math.abs(pos.i) <= 2.9999984E7 && (double)Math.abs(pos.j) <= 2.9999984E7) {
            worldborder.c(pos.i, pos.j);
            source.a(() -> IChatBaseComponent.a("commands.worldborder.center.success", new Object[]{String.format(Locale.ROOT, "%.2f", Float.valueOf(pos.i)), String.format(Locale.ROOT, "%.2f", Float.valueOf(pos.j))}), true);
            return 0;
        }
        throw e.create();
    }

    private static int a(CommandListenerWrapper source, double distance, long time) throws CommandSyntaxException {
        WorldBorder worldborder = source.e().w_();
        double d1 = worldborder.i();
        if (d1 == distance) {
            throw b.create();
        }
        if (distance < 1.0) {
            throw c.create();
        }
        if (distance > 5.9999968E7) {
            throw d.create();
        }
        if (time > 0L) {
            worldborder.a(d1, distance, time);
            if (distance > d1) {
                source.a(() -> IChatBaseComponent.a("commands.worldborder.set.grow", new Object[]{String.format(Locale.ROOT, "%.1f", distance), Long.toString(time / 1000L)}), true);
            } else {
                source.a(() -> IChatBaseComponent.a("commands.worldborder.set.shrink", new Object[]{String.format(Locale.ROOT, "%.1f", distance), Long.toString(time / 1000L)}), true);
            }
        } else {
            worldborder.a(distance);
            source.a(() -> IChatBaseComponent.a("commands.worldborder.set.immediate", new Object[]{String.format(Locale.ROOT, "%.1f", distance)}), true);
        }
        return (int)(distance - d1);
    }
}

