/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.collect.Streams;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.SystemUtils;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.world.level.GameRules;
import org.slf4j.Logger;

public class ThreadWatchdog
implements Runnable {
    private static final Logger a = LogUtils.getLogger();
    private static final long b = 10000L;
    private static final int c = 1;
    private final DedicatedServer d;
    private final long e;

    public ThreadWatchdog(DedicatedServer server) {
        this.d = server;
        this.e = server.bj();
    }

    @Override
    @Override
    public void run() {
        while (this.d.v()) {
            long l2 = this.d.ax();
            long m2 = SystemUtils.b();
            long n2 = m2 - l2;
            if (n2 > this.e) {
                a.error(LogUtils.FATAL_MARKER, "A single server tick took {} seconds (should be max {})", (Object)String.format(Locale.ROOT, "%.2f", Float.valueOf((float)n2 / 1000.0f)), (Object)String.format(Locale.ROOT, "%.2f", Float.valueOf(0.05f)));
                a.error(LogUtils.FATAL_MARKER, "Considering it to be crashed, server will forcibly shutdown.");
                ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                ThreadInfo[] threadInfos = threadMXBean.dumpAllThreads(true, true);
                StringBuilder stringBuilder = new StringBuilder();
                Error error = new Error("Watchdog");
                for (ThreadInfo threadInfo : threadInfos) {
                    if (threadInfo.getThreadId() == this.d.au().getId()) {
                        error.setStackTrace(threadInfo.getStackTrace());
                    }
                    stringBuilder.append(threadInfo);
                    stringBuilder.append("\n");
                }
                CrashReport crashReport = new CrashReport("Watching Server", error);
                this.d.b(crashReport.g());
                CrashReportSystemDetails crashReportCategory = crashReport.a("Thread Dump");
                crashReportCategory.a("Threads", stringBuilder);
                CrashReportSystemDetails crashReportCategory2 = crashReport.a("Performance stats");
                crashReportCategory2.a("Random tick rate", () -> this.d.aU().q().a(GameRules.n).toString());
                crashReportCategory2.a("Level stats", () -> Streams.stream(this.d.F()).map(world -> world.ac() + ": " + world.D()).collect(Collectors.joining(",\n")));
                DispenserRegistry.a("Crash report:\n" + crashReport.e());
                File file = new File(new File(this.d.z(), "crash-reports"), "crash-" + SystemUtils.e() + "-server.txt");
                if (crashReport.a(file)) {
                    a.error("This crash report has been saved to: {}", (Object)file.getAbsolutePath());
                } else {
                    a.error("We were unable to save this crash report to disk.");
                }
                this.a();
            }
            try {
                Thread.sleep(l2 + this.e - m2);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void a() {
        try {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                @Override
                public void run() {
                    Runtime.getRuntime().halt(1);
                }
            }, 10000L);
            System.exit(1);
        }
        catch (Throwable throwable) {
            Runtime.getRuntime().halt(1);
        }
    }
}

