/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.system.scheduling.ChunkHolderManager;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public abstract class ChunkMapDistance {
    static final Logger a = LogUtils.getLogger();
    static final int b = ChunkLevel.a(FullChunkStatus.d);
    private static final int c = 4;
    final Long2ObjectMap<ObjectSet<EntityPlayer>> d = new Long2ObjectOpenHashMap();
    public static final int MOB_SPAWN_RANGE = 8;
    private final PlayerChunkMap chunkMap;

    public ChunkHolderManager getChunkHolderManager() {
        return this.chunkMap.q.chunkTaskScheduler.chunkHolderManager;
    }

    protected ChunkMapDistance(Executor workerExecutor, Executor mainThreadExecutor, PlayerChunkMap chunkMap) {
        this.chunkMap = chunkMap;
    }

    protected void a() {
        this.getChunkHolderManager().tick();
    }

    private static int a(ArraySetSorted<Ticket<?>> tickets) {
        return !tickets.isEmpty() ? tickets.b().b() : ChunkLevel.a + 1;
    }

    protected abstract boolean a(long var1);

    @Nullable
    protected abstract PlayerChunk b(long var1);

    @Nullable
    protected abstract PlayerChunk a(long var1, int var3, @Nullable PlayerChunk var4, int var5);

    public boolean a(PlayerChunkMap chunkStorage) {
        return this.getChunkHolderManager().processTicketUpdates();
    }

    boolean addTicket(long i2, Ticket<?> ticket) {
        AsyncCatcher.catchOp("ChunkMapDistance::addTicket");
        return this.getChunkHolderManager().addTicketAtLevel(ticket.a(), i2, ticket.b(), ticket.c);
    }

    boolean removeTicket(long i2, Ticket<?> ticket) {
        AsyncCatcher.catchOp("ChunkMapDistance::removeTicket");
        return this.getChunkHolderManager().removeTicketAtLevel(ticket.a(), i2, ticket.b(), ticket.c);
    }

    public <T> void a(TicketType<T> type, ChunkCoordIntPair pos, int level, T argument) {
        this.getChunkHolderManager().addTicketAtLevel(type, pos, level, argument);
    }

    public <T> void b(TicketType<T> type, ChunkCoordIntPair pos, int level, T argument) {
        this.getChunkHolderManager().removeTicketAtLevel(type, pos, level, argument);
    }

    public <T> void c(TicketType<T> type, ChunkCoordIntPair pos, int radius, T argument) {
        this.addRegionTicketAtDistance(type, pos, radius, argument);
    }

    public <T> boolean addRegionTicketAtDistance(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        return this.getChunkHolderManager().addTicketAtLevel(tickettype, chunkcoordintpair, ChunkLevel.a(FullChunkStatus.b) - i2, t0);
    }

    public <T> void d(TicketType<T> type, ChunkCoordIntPair pos, int radius, T argument) {
        this.removeRegionTicketAtDistance(type, pos, radius, argument);
    }

    public <T> boolean removeRegionTicketAtDistance(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        return this.getChunkHolderManager().removeTicketAtLevel(tickettype, chunkcoordintpair, ChunkLevel.a(FullChunkStatus.b) - i2, t0);
    }

    protected void a(ChunkCoordIntPair pos, boolean forced) {
        Ticket<ChunkCoordIntPair> ticket = new Ticket<ChunkCoordIntPair>(TicketType.d, PlayerChunkMap.b, pos, 0L);
        long i2 = pos.a();
        if (forced) {
            this.addTicket(i2, ticket);
        } else {
            this.removeTicket(i2, ticket);
        }
    }

    public void a(SectionPosition pos, EntityPlayer player) {
        ChunkCoordIntPair chunkcoordintpair = pos.r();
        long i2 = chunkcoordintpair.a();
    }

    public void b(SectionPosition pos, EntityPlayer player) {
        ChunkCoordIntPair chunkcoordintpair = pos.r();
        long i2 = chunkcoordintpair.a();
        ObjectSet objectset = (ObjectSet)this.d.get(i2);
        if (objectset == null) {
            return;
        }
        if (objectset != null) {
            objectset.remove((Object)player);
        }
        if (objectset == null || objectset.isEmpty()) {
            this.d.remove(i2);
        }
    }

    public boolean c(long chunkPos) {
        PlayerChunk holder = this.chunkMap.b(chunkPos);
        return holder != null && holder.isEntityTickingReady();
    }

    public boolean d(long chunkPos) {
        PlayerChunk holder = this.chunkMap.b(chunkPos);
        return holder != null && holder.isTickingReady();
    }

    protected String e(long pos) {
        return this.getChunkHolderManager().getTicketDebugString(pos);
    }

    protected void a(int viewDistance) {
        this.chunkMap.a(viewDistance);
    }

    public int getSimulationDistance() {
        return this.chunkMap.q.playerChunkLoader.getAPITickDistance();
    }

    public void b(int simulationDistance) {
        this.chunkMap.q.playerChunkLoader.setTickDistance(simulationDistance);
    }

    public int b() {
        return this.chunkMap.playerChunkTickRangeMap.size();
    }

    public boolean f(long chunkPos) {
        return this.chunkMap.playerChunkTickRangeMap.getObjectsInRange(chunkPos) != null;
    }

    public String c() {
        return "No DistanceManager stats available";
    }

    public void e() {
    }

    public boolean f() {
        throw new UnsupportedOperationException();
    }

    public <T> void removeAllTicketsFor(TicketType<T> ticketType, int ticketLevel, T ticketIdentifier) {
        this.getChunkHolderManager().removeAllTicketsFor(ticketType, ticketLevel, ticketIdentifier);
    }

    private class b
    extends ChunkMap {
        protected final Long2ByteMap a;
        protected final int b;

        protected b(int i2) {
            super(i2 + 2, 16, 256);
            this.a = new Long2ByteOpenHashMap();
            this.b = i2;
            this.a.defaultReturnValue((byte)(i2 + 2));
        }

        @Override
        protected int c(long id) {
            return this.a.get(id);
        }

        @Override
        protected void a(long id, int level) {
            byte b0 = level > this.b ? this.a.remove(id) : this.a.put(id, (byte)level);
            this.a(id, (int)b0, level);
        }

        protected void a(long pos, int oldDistance, int distance) {
        }

        @Override
        protected int b(long id) {
            return this.d(id) ? 0 : Integer.MAX_VALUE;
        }

        private boolean d(long chunkPos) {
            ObjectSet objectset = (ObjectSet)ChunkMapDistance.this.d.get(chunkPos);
            return objectset != null && !objectset.isEmpty();
        }

        public void a() {
            this.b(Integer.MAX_VALUE);
        }

        private void a(String path) {
            try (FileOutputStream fileoutputstream = new FileOutputStream(new File(path));){
                for (Long2ByteMap.Entry it_unimi_dsi_fastutil_longs_long2bytemap_entry : this.a.long2ByteEntrySet()) {
                    ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(it_unimi_dsi_fastutil_longs_long2bytemap_entry.getLongKey());
                    String s1 = Byte.toString(it_unimi_dsi_fastutil_longs_long2bytemap_entry.getByteValue());
                    fileoutputstream.write((chunkcoordintpair.e + "\t" + chunkcoordintpair.f + "\t" + s1 + "\n").getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException ioexception) {
                a.error("Failed to dump chunks to {}", (Object)path, (Object)ioexception);
            }
        }
    }
}

