/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.event.player.PlayerClientOptionsChangeEvent;
import com.destroystokyo.paper.event.player.PlayerLocaleChangeEvent;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.event.player.PlayerStartSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerStopSpectatingEntityEvent;
import com.destroystokyo.paper.util.PooledHashSets;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.google.common.collect.Lists;
import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.chunk.system.RegionizedPlayerChunkLoader;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.packet.PlayerChunkLoadEvent;
import io.papermc.paper.event.packet.PlayerChunkUnloadEvent;
import io.papermc.paper.event.player.PlayerInventorySlotChangeEvent;
import io.papermc.paper.util.MCUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.translation.Translator;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayInSettings;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowHorse;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutResourcePackSend;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUnloadChunk;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutWindowData;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldProviderNormal;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHorse;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemCooldownPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMapBase;
import net.minecraft.world.item.ItemWrittenBook;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.ShapeDetectorShape;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.util.BlockStateListPopulator;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftDimensionUtil;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.inventory.MainHand;
import org.slf4j.Logger;

public class EntityPlayer
extends EntityHuman {
    private static final Logger b = LogUtils.getLogger();
    public long lastSave = MinecraftServer.currentTick;
    private static final int cl = 32;
    private static final int cm = 10;
    public PlayerConnection c;
    public final MinecraftServer d;
    public final PlayerInteractManager e;
    private final AdvancementDataPlayer cn;
    private final ServerStatisticManager co;
    private float cp = Float.MIN_VALUE;
    private int cq = Integer.MIN_VALUE;
    private int cr = Integer.MIN_VALUE;
    private int cs = Integer.MIN_VALUE;
    private int ct = Integer.MIN_VALUE;
    private int cu = Integer.MIN_VALUE;
    private float cv = -1.0E8f;
    private int cw = -99999999;
    private boolean cx = true;
    public int cy = -99999999;
    public int cz = 60;
    private EnumChatVisibility cA;
    private boolean cB = true;
    private long cC;
    @Nullable
    private net.minecraft.world.entity.Entity cD;
    public boolean cE;
    public boolean cF;
    private final RecipeBookServer cG;
    @Nullable
    private Vec3D cH;
    private int cI;
    private boolean cJ;
    @Nullable
    private Vec3D cK;
    @Nullable
    private Vec3D cL;
    @Nullable
    private Vec3D cM;
    private SectionPosition cN;
    private ResourceKey<net.minecraft.world.level.World> cO;
    @Nullable
    private BlockPosition cP;
    private boolean cQ;
    private float cR;
    private final ITextFilter cS;
    private boolean cT;
    private boolean cU;
    public WardenSpawnTracker cV;
    public final ContainerSynchronizer cW;
    private final ICrafting cX;
    @Nullable
    private RemoteChatSession cY;
    private int cZ;
    public int f;
    public boolean g;
    private int containerUpdateDelay;
    public long loginTime;
    public int patrolSpawnDelay;
    public boolean queueHealthUpdatePacket = false;
    public PacketPlayOutUpdateHealth queuedHealthUpdatePacket;
    public static final int MOBCATEGORY_TOTAL_ENUMS = EnumCreatureType.values().length;
    public final int[] mobCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public final int[] mobBackoffCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public final PooledHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> cachedSingleMobDistanceMap;
    public String displayName;
    public Component adventure$displayName;
    public IChatBaseComponent listName;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public boolean supressTrackerForLogin = false;
    public Integer clientViewDistance;
    public boolean isRealPlayer;
    public double lastEntitySpawnRadiusSquared;
    public final PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> cachedSingleHashSet;
    public PlayerNaturallySpawnCreaturesEvent playerNaturallySpawnedEvent;
    public PlayerQuitEvent.QuitReason quitReason = null;
    private final AtomicReference<RegionizedPlayerChunkLoader.ViewDistances> viewDistances = new AtomicReference<RegionizedPlayerChunkLoader.ViewDistances>(new RegionizedPlayerChunkLoader.ViewDistances(-1, -1, -1));
    public RegionizedPlayerChunkLoader.PlayerChunkLoaderData chunkLoader;
    public String locale = null;
    public Locale adventure$locale = Locale.US;
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    public WeatherType weather = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;

    public RegionizedPlayerChunkLoader.ViewDistances getViewDistances() {
        return this.viewDistances.get();
    }

    private void updateViewDistance(Function<RegionizedPlayerChunkLoader.ViewDistances, RegionizedPlayerChunkLoader.ViewDistances> update) {
        RegionizedPlayerChunkLoader.ViewDistances curr = this.viewDistances.get();
        while (!this.viewDistances.compareAndSet(curr, update.apply(curr))) {
        }
    }

    public void setTickViewDistance(int distance) {
        if (distance < 2 || distance > 32) {
            throw new IllegalArgumentException("Tick view distance must be a number between 2 and 32, got: " + distance);
        }
        this.updateViewDistance(input -> input.setTickViewDistance(distance));
    }

    public void setLoadViewDistance(int distance) {
        if (distance != -1 && (distance < 2 || distance > 33)) {
            throw new IllegalArgumentException("Load view distance must be a number between 2 and 33 or -1, got: " + distance);
        }
        this.updateViewDistance(input -> input.setLoadViewDistance(distance));
    }

    public void setSendViewDistance(int distance) {
        if (distance != -1 && (distance < 2 || distance > 33)) {
            throw new IllegalArgumentException("Send view distance must be a number between 2 and 33 or -1, got: " + distance);
        }
        this.updateViewDistance(input -> input.setSendViewDistance(distance));
    }

    public EntityPlayer(MinecraftServer server, WorldServer world, GameProfile profile) {
        super(world, world.R(), world.S(), profile);
        this.cA = EnumChatVisibility.a;
        this.cC = SystemUtils.b();
        this.cG = new RecipeBookServer();
        this.cN = SectionPosition.a(0, 0, 0);
        this.cO = net.minecraft.world.level.World.h;
        this.cV = new WardenSpawnTracker(0, 0, 0);
        this.cW = new ContainerSynchronizer(){

            @Override
            public void a(Container handler, NonNullList<ItemStack> stacks, ItemStack cursorStack, int[] properties) {
                EntityPlayer.this.c.a(new PacketPlayOutWindowItems(handler.j, handler.k(), stacks, cursorStack));
                for (int i2 = 0; i2 < properties.length; ++i2) {
                    this.b(handler, i2, properties[i2]);
                }
            }

            @Override
            public void sendOffHandSlotChange() {
                EntityPlayer.this.c.a(new PacketPlayOutSetSlot(EntityPlayer.this.bQ.j, EntityPlayer.this.bQ.k(), 45, EntityPlayer.this.bQ.b(45).e().p()));
            }

            @Override
            public void a(Container handler, int slot, ItemStack stack) {
                EntityPlayer.this.c.a(new PacketPlayOutSetSlot(handler.j, handler.k(), slot, stack));
            }

            @Override
            public void a(Container handler, ItemStack stack) {
                EntityPlayer.this.c.a(new PacketPlayOutSetSlot(-1, handler.k(), -1, stack));
            }

            @Override
            public void a(Container handler, int property, int value) {
                this.b(handler, property, value);
            }

            private void b(Container handler, int property, int value) {
                EntityPlayer.this.c.a(new PacketPlayOutWindowData(handler.j, property, value));
            }
        };
        this.cX = new ICrafting(){

            @Override
            public void a(Container handler, int slotId, ItemStack stack) {
                Slot slot = handler.b(slotId);
                if (!(slot instanceof SlotResult) && slot.d == EntityPlayer.this.fN()) {
                    CriterionTriggers.e.a(EntityPlayer.this, EntityPlayer.this.fN(), stack);
                }
            }

            @Override
            public void slotChanged(Container handler, int slotId, ItemStack oldStack, ItemStack stack) {
                Slot slot = handler.b(slotId);
                if (!(slot instanceof SlotResult) && slot.d == EntityPlayer.this.fN()) {
                    if (PlayerInventorySlotChangeEvent.getHandlerList().getRegisteredListeners().length == 0) {
                        CriterionTriggers.e.a(EntityPlayer.this, EntityPlayer.this.fN(), stack);
                        return;
                    }
                    PlayerInventorySlotChangeEvent event = new PlayerInventorySlotChangeEvent((Player)EntityPlayer.this.getBukkitEntity(), slotId, CraftItemStack.asBukkitCopy(oldStack), CraftItemStack.asBukkitCopy(stack));
                    event.callEvent();
                    if (event.shouldTriggerAdvancements()) {
                        CriterionTriggers.e.a(EntityPlayer.this, EntityPlayer.this.fN(), stack);
                    }
                }
            }

            @Override
            public void a(Container handler, int property, int value) {
            }
        };
        this.cS = server.a(this);
        this.e = server.b(this);
        this.d = server;
        this.co = server.ac().getPlayerStats(this);
        this.cn = server.ac().f(this);
        this.r(1.0f);
        this.cachedSingleHashSet = new PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer>(this);
        this.displayName = this.cv();
        this.adventure$displayName = Component.text((String)this.cv());
        this.bukkitPickUpLoot = true;
        this.maxHealthCache = this.eI();
        this.cachedSingleMobDistanceMap = new PooledHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer>(this);
    }

    public final BlockPosition getSpawnPoint(WorldServer worldserver) {
        BlockPosition blockposition = worldserver.R();
        if (worldserver.x_().g() && worldserver.K.m() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.d.a(worldserver));
            int j2 = MathHelper.a(worldserver.w_().b(blockposition.u(), blockposition.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.u(i1);
            int k1 = RandomSource.a().a(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                BlockPosition blockposition1 = WorldProviderNormal.a(worldserver, blockposition.u() + j22 - i2, blockposition.w() + k22 - i2);
                if (blockposition1 == null) continue;
                return blockposition1;
            }
        }
        return blockposition;
    }

    public void d(WorldServer world) {
        BlockPosition blockposition = world.R();
        if (world.x_().g() && world.K.m() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.d.a(world));
            int j2 = MathHelper.a(world.w_().b(blockposition.u(), blockposition.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.u(i1);
            int k1 = RandomSource.a().a(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                BlockPosition blockposition1 = WorldProviderNormal.a(world, blockposition.u() + j22 - i2, blockposition.w() + k22 - i2);
                if (blockposition1 == null) continue;
                this.a(blockposition1, 0.0f, 0.0f);
                if (!world.noCollision(this, this.cE(), true)) {
                    continue;
                }
                break;
            }
        } else {
            this.a(blockposition, 0.0f, 0.0f);
            while (!world.noCollision(this, this.cE(), true) && this.dp() < (double)(world.aj() - 1)) {
                this.e(this.dn(), this.dp() + 1.0, this.dt());
            }
        }
    }

    private int u(int horizontalSpawnArea) {
        return horizontalSpawnArea <= 16 ? horizontalSpawnArea - 1 : 17;
    }

    @Override
    public void a(NBTTagCompound nbt) {
        String spawnWorld;
        CraftWorld oldWorld;
        super.a(nbt);
        if (nbt.b("warden_spawn_tracker", 10)) {
            DataResult dataresult = WardenSpawnTracker.a.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("warden_spawn_tracker")));
            Logger logger = b;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(wardenspawntracker -> {
                this.cV = wardenspawntracker;
            });
        }
        if (nbt.b("enteredNetherPosition", 10)) {
            NBTTagCompound nbttagcompound1 = nbt.p("enteredNetherPosition");
            this.cL = new Vec3D(nbttagcompound1.k("x"), nbttagcompound1.k("y"), nbttagcompound1.k("z"));
        }
        this.cF = nbt.q("seenCredits");
        if (nbt.b("recipeBook", 10)) {
            this.cG.a(nbt.p("recipeBook"), this.d.aE());
        }
        this.getBukkitEntity().readExtraData(nbt);
        if (this.fy()) {
            this.fz();
        }
        if ((oldWorld = (CraftWorld)Bukkit.getWorld((String)(spawnWorld = nbt.l("SpawnWorld")))) != null) {
            this.cO = oldWorld.getHandle().ac();
        }
        if (nbt.b("SpawnX", 99) && nbt.b("SpawnY", 99) && nbt.b("SpawnZ", 99)) {
            this.cP = new BlockPosition(nbt.h("SpawnX"), nbt.h("SpawnY"), nbt.h("SpawnZ"));
            this.cQ = nbt.q("SpawnForced");
            this.cR = nbt.j("SpawnAngle");
            if (nbt.e("SpawnDimension")) {
                DataResult dataresult1 = net.minecraft.world.level.World.g.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c("SpawnDimension"));
                Logger logger1 = b;
                Objects.requireNonNull(logger1);
                this.cO = dataresult1.resultOrPartial(arg_0 -> ((Logger)logger1).error(arg_0)).orElse(net.minecraft.world.level.World.h);
            }
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        DataResult dataresult = WardenSpawnTracker.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cV);
        Logger logger = b;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("warden_spawn_tracker", (NBTBase)nbtbase));
        this.k(nbt);
        nbt.a("seenCredits", this.cF);
        if (this.cL != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.a("x", this.cL.c);
            nbttagcompound1.a("y", this.cL.d);
            nbttagcompound1.a("z", this.cL.e);
            nbt.a("enteredNetherPosition", nbttagcompound1);
        }
        net.minecraft.world.entity.Entity entity = this.cT();
        net.minecraft.world.entity.Entity entity1 = this.cW();
        boolean persistVehicle = true;
        if (entity1 != null) {
            for (net.minecraft.world.entity.Entity vehicle = entity1; vehicle != null; vehicle = vehicle.cW()) {
                if (vehicle.persist) continue;
                persistVehicle = false;
                break;
            }
        }
        if (persistVehicle && entity1 != null && entity != this && entity.cS() && !entity.dD()) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            NBTTagCompound nbttagcompound3 = new NBTTagCompound();
            entity.e(nbttagcompound3);
            nbttagcompound2.a("Attach", entity1.ct());
            nbttagcompound2.a("Entity", nbttagcompound3);
            nbt.a("RootVehicle", nbttagcompound2);
        }
        nbt.a("recipeBook", this.cG.b());
        nbt.a("Dimension", this.dI().ac().a().toString());
        if (this.cP != null) {
            nbt.a("SpawnX", this.cP.u());
            nbt.a("SpawnY", this.cP.v());
            nbt.a("SpawnZ", this.cP.w());
            nbt.a("SpawnForced", this.cQ);
            nbt.a("SpawnAngle", this.cR);
            dataresult = MinecraftKey.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cO.a());
            logger = b;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("SpawnDimension", (NBTBase)nbtbase));
        }
        this.getBukkitEntity().setExtraData(nbt);
    }

    public void spawnIn(net.minecraft.world.level.World world) {
        this.a(world);
        if (world == null) {
            this.dF();
            Vec3D position = null;
            if (this.cO != null && (world = this.d.a(this.cO)) != null && this.N() != null) {
                position = EntityHuman.a((WorldServer)world, this.N(), this.O(), false, false).orElse(null);
            }
            if (world == null || position == null) {
                world = ((CraftWorld)Bukkit.getServer().getWorlds().get(0)).getHandle();
                position = Vec3D.b(world.R());
            }
            this.a(world);
            this.p(position.a(), position.b(), position.c());
        }
        this.e.a((WorldServer)world);
    }

    public void a(int points) {
        float f2 = this.fW();
        float f1 = (f2 - 1.0f) / f2;
        this.cg = MathHelper.a((float)points / f2, 0.0f, f1);
        this.cy = -1;
    }

    public void b(int level) {
        this.ce = level;
        this.cy = -1;
    }

    @Override
    public void c(int levels) {
        super.c(levels);
        this.cy = -1;
    }

    @Override
    public void a(ItemStack enchantedItem, int experienceLevels) {
        super.a(enchantedItem, experienceLevels);
        this.cy = -1;
    }

    public void a(Container screenHandler) {
        screenHandler.a(this.cX);
        screenHandler.a(this.cW);
    }

    public void h() {
        this.a(this.bQ);
    }

    @Override
    public void Q_() {
        super.Q_();
        this.c.a(new ClientboundPlayerCombatEnterPacket());
    }

    @Override
    public void F_() {
        super.F_();
        this.c.a(new ClientboundPlayerCombatEndPacket(this.eG()));
    }

    @Override
    protected void a(IBlockData state) {
        CriterionTriggers.d.a(this, state);
    }

    @Override
    protected ItemCooldown k() {
        return new ItemCooldownPlayer(this);
    }

    @Override
    public void l() {
        net.minecraft.world.entity.Entity entity;
        if (this.joining) {
            this.joining = false;
        }
        this.e.a();
        this.cV.a();
        --this.cz;
        if (this.ak > 0) {
            --this.ak;
        }
        if (--this.containerUpdateDelay <= 0) {
            this.bR.d();
            this.containerUpdateDelay = this.dI().paperConfig().tickRates.containerUpdate;
        }
        if (!(this.dI().B || this.bR == this.bQ || !this.eT() && this.bR.a(this))) {
            this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
            this.bR = this.bQ;
        }
        if ((entity = this.G()) != this) {
            if (entity.bs()) {
                this.a(entity.dn(), entity.dp(), entity.dt(), entity.dy(), entity.dA());
                this.x().k().a(this);
                if (this.fE()) {
                    this.c((net.minecraft.world.entity.Entity)this);
                }
            } else {
                this.c((net.minecraft.world.entity.Entity)this);
            }
        }
        CriterionTriggers.w.a(this);
        if (this.cH != null) {
            CriterionTriggers.u.a(this, this.cH, this.ag - this.cI);
        }
        this.o();
        this.p();
        this.cn.b(this);
    }

    public void m() {
        try {
            if (this.valid && !this.G_() || !this.db()) {
                super.l();
            }
            for (int i2 = 0; i2 < this.fN().b(); ++i2) {
                Packet<?> packet;
                ItemStack itemstack = this.fN().a(i2);
                if (!itemstack.d().ad_() || (packet = ((ItemWorldMapBase)itemstack.d()).a(itemstack, this.dI(), this)) == null) continue;
                this.c.a(packet);
            }
            if (this.er() != this.cv || this.cw != this.bS.a() || this.bS.e() == 0.0f != this.cx) {
                this.c.a(new PacketPlayOutUpdateHealth(this.getBukkitEntity().getScaledHealth(), this.bS.a(), this.bS.e()));
                this.cv = this.er();
                this.cw = this.bS.a();
                boolean bl = this.cx = this.bS.e() == 0.0f;
            }
            if (this.er() + this.ff() != this.cp) {
                this.cp = this.er() + this.ff();
                this.a(IScoreboardCriteria.f, MathHelper.f(this.cp));
            }
            if (this.bS.a() != this.cq) {
                this.cq = this.bS.a();
                this.a(IScoreboardCriteria.g, MathHelper.f((float)this.cq));
            }
            if (this.cf() != this.cr) {
                this.cr = this.cf();
                this.a(IScoreboardCriteria.h, MathHelper.f((float)this.cr));
            }
            if (this.eF() != this.cs) {
                this.cs = this.eF();
                this.a(IScoreboardCriteria.i, MathHelper.f((float)this.cs));
            }
            if (this.cf != this.cu) {
                this.cu = this.cf;
                this.a(IScoreboardCriteria.j, MathHelper.f((float)this.cu));
            }
            if (this.maxHealthCache != (double)this.eI()) {
                this.getBukkitEntity().updateScaledHealth();
            }
            if (this.ce != this.ct) {
                this.ct = this.ce;
                this.a(IScoreboardCriteria.k, MathHelper.f((float)this.ct));
            }
            if (this.cf != this.cy) {
                this.cy = this.cf;
                this.c.a(new PacketPlayOutExperience(this.cg, this.cf, this.ce));
            }
            if (this.ag % 20 == 0) {
                CriterionTriggers.p.a(this);
            }
            if (this.oldLevel == -1) {
                this.oldLevel = this.ce;
            }
            if (this.oldLevel != this.ce) {
                CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.ce);
                this.oldLevel = this.ce;
            }
            if (this.getBukkitEntity().hasClientWorldBorder()) {
                ((CraftWorldBorder)this.getBukkitEntity().getWorldBorder()).getHandle().s();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Ticking player");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Player being ticked");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public void n() {
        if (this.er() > 0.0f && this.cK != null) {
            CriterionTriggers.U.a(this, this.cK);
        }
        this.cK = null;
        super.n();
    }

    public void o() {
        if (this.aa > 0.0f && this.cK == null) {
            this.cK = this.dg();
        }
    }

    public void p() {
        if (this.cW() != null && this.cW().bi()) {
            if (this.cM == null) {
                this.cM = this.dg();
            } else {
                CriterionTriggers.V.a(this, this.cM);
            }
        }
        if (!(this.cM == null || this.cW() != null && this.cW().bi())) {
            this.cM = null;
        }
    }

    private void a(IScoreboardCriteria criterion, int score) {
        this.dI().getCraftServer().getScoreboardManager().getScoreboardScores(criterion, this.cv(), scoreboardscore -> scoreboardscore.b(score));
    }

    private static void processKeep(PlayerDeathEvent event, NonNullList<ItemStack> inv) {
        List itemsToKeep = event.getItemsToKeep();
        if (inv == null) {
            if (!itemsToKeep.isEmpty()) {
                for (org.bukkit.inventory.ItemStack itemStack : itemsToKeep) {
                    event.getEntity().getInventory().addItem(new org.bukkit.inventory.ItemStack[]{itemStack});
                }
            }
            return;
        }
        for (int i2 = 0; i2 < inv.size(); ++i2) {
            ItemStack item = inv.get(i2);
            if (EnchantmentManager.e(item) || itemsToKeep.isEmpty() || item.b()) {
                inv.set(i2, ItemStack.b);
                continue;
            }
            org.bukkit.inventory.ItemStack bukkitStack = item.getBukkitStack();
            boolean keep = false;
            Iterator iterator = itemsToKeep.iterator();
            while (iterator.hasNext()) {
                org.bukkit.inventory.ItemStack itemStack = (org.bukkit.inventory.ItemStack)iterator.next();
                if (!bukkitStack.equals((Object)itemStack)) continue;
                iterator.remove();
                keep = true;
                break;
            }
            if (keep) continue;
            inv.set(i2, ItemStack.b);
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        TextComponent deathMessage;
        boolean keepInventory;
        this.a(GameEvent.p);
        boolean flag = this.dI().X().b(GameRules.m);
        if (this.dD()) {
            return;
        }
        ArrayList<org.bukkit.inventory.ItemStack> loot = new ArrayList<org.bukkit.inventory.ItemStack>(this.fN().b());
        boolean bl = keepInventory = this.dI().X().b(GameRules.d) || this.G_();
        if (!keepInventory) {
            for (ItemStack itemStack : this.fN().getContents()) {
                if (itemStack.b() || EnchantmentManager.e(itemStack)) continue;
                loot.add(CraftItemStack.asCraftMirror(itemStack));
            }
        }
        if (this.dZ() && this.dI().X().b(GameRules.f)) {
            this.a(damageSource, this.ba > 0);
            for (org.bukkit.inventory.ItemStack itemStack : this.drops) {
                loot.add(itemStack);
            }
            this.drops.clear();
        }
        IChatBaseComponent defaultMessage = this.eG().a();
        String string = defaultMessage.getString();
        this.keepLevel = keepInventory;
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent(this, loot, PaperAdventure.asAdventure(defaultMessage), defaultMessage.getString(), keepInventory);
        if (event.isCancelled()) {
            if (this.er() <= 0.0f) {
                this.t((float)event.getReviveHealth());
            }
            return;
        }
        if (this.bR != this.bQ) {
            this.closeContainer(InventoryCloseEvent.Reason.DEATH);
        }
        Object object = deathMessage = event.deathMessage() != null ? event.deathMessage() : Component.empty();
        if (deathMessage != null && deathMessage != Component.empty() && flag) {
            IChatBaseComponent ichatbasecomponent = PaperAdventure.asVanilla((Component)deathMessage);
            this.c.a(new ClientboundPlayerCombatKillPacket(this.af(), ichatbasecomponent), PacketSendListener.a(() -> {
                boolean flag1 = true;
                String s2 = ichatbasecomponent.a(256);
                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("death.attack.message_too_long", IChatBaseComponent.b(s2).a(EnumChatFormat.o));
                IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.a("death.attack.even_more_magic", this.H_()).a(chatmodifier -> chatmodifier.a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, ichatmutablecomponent)));
                return new ClientboundPlayerCombatKillPacket(this.af(), ichatmutablecomponent1);
            }));
            ScoreboardTeamBase scoreboardTeamBase = this.cd();
            if (scoreboardTeamBase != null && scoreboardTeamBase.k() != ScoreboardTeamBase.EnumNameTagVisibility.a) {
                if (scoreboardTeamBase.k() == ScoreboardTeamBase.EnumNameTagVisibility.c) {
                    this.d.ac().a((EntityHuman)this, ichatbasecomponent);
                } else if (scoreboardTeamBase.k() == ScoreboardTeamBase.EnumNameTagVisibility.d) {
                    this.d.ac().b(this, ichatbasecomponent);
                }
            } else {
                this.d.ac().a(ichatbasecomponent, false);
            }
        } else {
            this.c.a(new ClientboundPlayerCombatKillPacket(this.af(), CommonComponents.a));
        }
        this.gb();
        if (this.dI().X().b(GameRules.J)) {
            this.gn();
        }
        if (event.shouldDropExperience()) {
            this.ev();
        }
        if (!event.getKeepInventory()) {
            for (NonNullList nonNullList : this.fN().o) {
                EntityPlayer.processKeep(event, nonNullList);
            }
            EntityPlayer.processKeep(event, null);
        }
        this.c((net.minecraft.world.entity.Entity)this);
        this.dI().getCraftServer().getScoreboardManager().getScoreboardScores(IScoreboardCriteria.c, this.cv(), ScoreboardScore::a);
        EntityLiving entityliving = this.eH();
        if (entityliving != null) {
            this.b(StatisticList.h.b(entityliving.ae()));
            entityliving.a((net.minecraft.world.entity.Entity)this, this.bi, damageSource);
            this.f(entityliving);
        }
        this.dI().a((net.minecraft.world.entity.Entity)this, (byte)3);
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aw();
        this.k(0);
        this.a_(false);
        this.eG().c();
        ((EntityHuman)this).a(Optional.of(GlobalPos.a(this.dI().ac(), this.di())));
    }

    private void gn() {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.di()).c(32.0, 10.0, 32.0);
        this.dI().a(EntityInsentient.class, axisalignedbb, IEntitySelector.f).stream().filter(entityinsentient -> entityinsentient instanceof IEntityAngerable).forEach(entityinsentient -> ((IEntityAngerable)((Object)entityinsentient)).a_(this));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entityKilled, int score, DamageSource damageSource) {
        if (entityKilled != this) {
            super.a(entityKilled, score, damageSource);
            this.s(score);
            String s2 = this.cv();
            String s1 = entityKilled.cv();
            this.dI().getCraftServer().getScoreboardManager().getScoreboardScores(IScoreboardCriteria.e, s2, ScoreboardScore::a);
            if (entityKilled instanceof EntityHuman) {
                this.a(StatisticList.Q);
                this.dI().getCraftServer().getScoreboardManager().getScoreboardScores(IScoreboardCriteria.d, s2, ScoreboardScore::a);
            } else {
                this.a(StatisticList.O);
            }
            this.a(s2, s1, IScoreboardCriteria.l);
            this.a(s1, s2, IScoreboardCriteria.m);
            CriterionTriggers.b.a(this, entityKilled, damageSource);
        }
    }

    private void a(String playerName, String team, IScoreboardCriteria[] criterions) {
        int i2;
        ScoreboardTeam scoreboardteam = this.gc().i(team);
        if (scoreboardteam != null && (i2 = scoreboardteam.n().b()) >= 0 && i2 < criterions.length) {
            this.dI().getCraftServer().getScoreboardManager().getScoreboardScores(criterions[i2], playerName, ScoreboardScore::a);
        }
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        EntityHuman entityhuman1;
        EntityArrow entityarrow;
        net.minecraft.world.entity.Entity entity1;
        EntityHuman entityhuman;
        boolean flag;
        if (this.b(source)) {
            return false;
        }
        boolean bl = flag = this.d.l() && this.go() && source.a(DamageTypeTags.m);
        if (!flag && this.cz > 0 && !source.a(DamageTypeTags.d)) {
            return false;
        }
        net.minecraft.world.entity.Entity entity = source.d();
        if (entity instanceof EntityHuman && !this.a(entityhuman = (EntityHuman)entity)) {
            return false;
        }
        if (entity instanceof EntityArrow && (entity1 = (entityarrow = (EntityArrow)entity).v()) instanceof EntityHuman && !this.a(entityhuman1 = (EntityHuman)entity1)) {
            return false;
        }
        this.queueHealthUpdatePacket = true;
        boolean damaged = super.a(source, amount);
        this.queueHealthUpdatePacket = false;
        if (this.queuedHealthUpdatePacket != null) {
            this.c.a(this.queuedHealthUpdatePacket);
            this.queuedHealthUpdatePacket = null;
        }
        return damaged;
    }

    @Override
    public boolean a(EntityHuman player) {
        return !this.go() ? false : super.a(player);
    }

    private boolean go() {
        return this.dI().pvpMode;
    }

    @Override
    @Nullable
    protected ShapeDetectorShape a(WorldServer destination) {
        ShapeDetectorShape shapedetectorshape = super.a(destination);
        WorldServer worldServer = destination = shapedetectorshape == null ? destination : shapedetectorshape.world;
        if (shapedetectorshape != null && this.dI().getTypeKey() == WorldDimension.b && destination != null && destination.getTypeKey() == WorldDimension.d) {
            Vec3D vec3d = shapedetectorshape.a.b(0.0, -1.0, 0.0);
            return new ShapeDetectorShape(vec3d, Vec3D.b, 90.0f, 0.0f, destination, shapedetectorshape.portalEventInfo);
        }
        return shapedetectorshape;
    }

    @Override
    @Nullable
    public net.minecraft.world.entity.Entity b(WorldServer destination) {
        return this.changeDimension(destination, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    @Nullable
    public net.minecraft.world.entity.Entity changeDimension(WorldServer worldserver, PlayerTeleportEvent.TeleportCause cause) {
        if (this.fy()) {
            return this;
        }
        WorldServer worldserver1 = this.x();
        ResourceKey<WorldDimension> resourcekey = worldserver1.getTypeKey();
        if (resourcekey == WorldDimension.d && worldserver != null && worldserver.getTypeKey() == WorldDimension.b) {
            this.cE = true;
            this.ac();
            this.x().a(this, Entity.RemovalReason.e);
            if (!this.g) {
                if (this.dI().paperConfig().misc.disableEndCredits) {
                    this.cF = true;
                }
                this.g = true;
                this.c.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.e, this.cF ? 0.0f : 1.0f));
                this.cF = true;
            }
            return this;
        }
        ShapeDetectorShape shapedetectorshape = this.a(worldserver);
        if (shapedetectorshape != null) {
            worldserver1.ad().a("moving");
            worldserver = shapedetectorshape.world;
            if (worldserver != null) {
                if (resourcekey == WorldDimension.b && worldserver.getTypeKey() == WorldDimension.c) {
                    this.cL = this.dg();
                } else if (worldserver.getTypeKey() == WorldDimension.d && shapedetectorshape.portalEventInfo != null && shapedetectorshape.portalEventInfo.getCanCreatePortal()) {
                    this.a(worldserver, BlockPosition.a(shapedetectorshape.a));
                }
            }
        } else {
            return null;
        }
        Location enter = this.getBukkitEntity().getLocation();
        Location exit = worldserver == null ? null : CraftLocation.toBukkit(shapedetectorshape.a, (World)worldserver.getWorld(), shapedetectorshape.c, shapedetectorshape.d);
        PlayerTeleportEvent tpEvent = new PlayerTeleportEvent((Player)this.getBukkitEntity(), enter, exit, cause);
        Bukkit.getServer().getPluginManager().callEvent((Event)tpEvent);
        if (tpEvent.isCancelled() || tpEvent.getTo() == null) {
            return null;
        }
        exit = tpEvent.getTo();
        worldserver = ((CraftWorld)exit.getWorld()).getHandle();
        worldserver1.ad().c();
        worldserver1.ad().a("placing");
        this.cE = true;
        this.c.a(new PacketPlayOutRespawn(worldserver.aa(), worldserver.ac(), BiomeManager.a(worldserver.A()), this.e.b(), this.e.c(), worldserver.af(), worldserver.z(), 3, this.gm(), this.ar()));
        this.c.a(new PacketPlayOutServerDifficulty(worldserver.ai(), this.dI().u_().t()));
        PlayerList playerlist = this.d.ac();
        playerlist.d(this);
        worldserver1.a(this, Entity.RemovalReason.e);
        this.dF();
        this.c(worldserver);
        this.c.teleport(exit);
        this.c.d();
        worldserver.b(this);
        worldserver1.ad().c();
        this.e(worldserver1);
        this.c.a(new PacketPlayOutAbilities(this.fO()));
        playerlist.a(this, worldserver);
        playerlist.e(this);
        for (MobEffect mobeffect : this.eo()) {
            this.c.a(new PacketPlayOutEntityEffect(this.af(), mobeffect));
        }
        this.c.a(new PacketPlayOutWorldEvent(1032, BlockPosition.b, 0, false));
        this.cy = -1;
        this.cv = -1.0f;
        this.cw = -1;
        PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((Player)this.getBukkitEntity(), (World)worldserver1.getWorld());
        this.dI().getCraftServer().getPluginManager().callEvent((Event)changeEvent);
        if (this.fp()) {
            this.fo();
        }
        return this;
    }

    @Override
    protected CraftPortalEvent callPortalEvent(net.minecraft.world.entity.Entity entity, WorldServer exitWorldServer, Position exitPosition, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        Location enter = this.getBukkitEntity().getLocation();
        Location exit = CraftLocation.toBukkit(exitPosition, (World)exitWorldServer.getWorld(), this.dy(), this.dA());
        PlayerPortalEvent event = new PlayerPortalEvent((Player)this.getBukkitEntity(), enter, exit, cause, searchRadius, true, creationRadius);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    private void a(WorldServer world, BlockPosition centerPos) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = centerPos.j();
        BlockStateListPopulator blockList = new BlockStateListPopulator(world);
        for (int i2 = -2; i2 <= 2; ++i2) {
            for (int j2 = -2; j2 <= 2; ++j2) {
                for (int k2 = -1; k2 < 3; ++k2) {
                    IBlockData iblockdata = k2 == -1 ? Blocks.co.n() : Blocks.a.n();
                    blockList.a((BlockPosition)blockposition_mutableblockposition.g(centerPos).e(j2, k2, i2), iblockdata, 3);
                }
            }
        }
        PortalCreateEvent portalEvent = new PortalCreateEvent(blockList.getList(), (World)world.getWorld(), (Entity)this.getBukkitEntity(), PortalCreateEvent.CreateReason.END_PLATFORM);
        world.getCraftServer().getPluginManager().callEvent((Event)portalEvent);
        if (!portalEvent.isCancelled()) {
            blockList.updateList();
        }
    }

    @Override
    protected Optional<BlockUtil.Rectangle> getExitPortal(WorldServer worldserver, BlockPosition blockposition, boolean flag, WorldBorder worldborder, int searchRadius, boolean canCreatePortal, int createRadius) {
        Optional<BlockUtil.Rectangle> optional = super.getExitPortal(worldserver, blockposition, flag, worldborder, searchRadius, canCreatePortal, createRadius);
        if (optional.isPresent() || !canCreatePortal) {
            return optional;
        }
        EnumDirection.EnumAxis enumdirection_enumaxis = this.dI().a_(this.aw).d(BlockPortal.a).orElse(EnumDirection.EnumAxis.a);
        Optional<BlockUtil.Rectangle> optional1 = worldserver.o().createPortal(blockposition, enumdirection_enumaxis, this, createRadius);
        if (!optional1.isPresent()) {
            // empty if block
        }
        return optional1;
    }

    public void e(WorldServer origin) {
        ResourceKey<net.minecraft.world.level.World> resourcekey = origin.ac();
        ResourceKey<net.minecraft.world.level.World> resourcekey1 = this.dI().ac();
        ResourceKey<net.minecraft.world.level.World> maindimensionkey = CraftDimensionUtil.getMainDimensionKey(origin);
        ResourceKey<net.minecraft.world.level.World> maindimensionkey1 = CraftDimensionUtil.getMainDimensionKey(this.dI());
        if (GlobalConfiguration.get().misc.strictAdvancementDimensionCheck) {
            maindimensionkey = resourcekey;
            maindimensionkey1 = resourcekey1;
        }
        CriterionTriggers.v.a(this, maindimensionkey, maindimensionkey1);
        if (maindimensionkey != resourcekey || maindimensionkey1 != resourcekey1) {
            CriterionTriggers.v.a(this, resourcekey, resourcekey1);
        }
        if (maindimensionkey == net.minecraft.world.level.World.i && maindimensionkey1 == net.minecraft.world.level.World.h && this.cL != null) {
            CriterionTriggers.C.a(this, this.cL);
        }
        if (maindimensionkey1 != net.minecraft.world.level.World.i) {
            this.cL = null;
        }
    }

    @Override
    public boolean a(EntityPlayer spectator) {
        return spectator.G_() ? this.G() == this : (this.G_() ? false : super.a(spectator));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity item, int count) {
        super.a(item, count);
        this.bR.d();
    }

    private Either<EntityHuman.EnumBedResult, Unit> getBedResult(BlockPosition blockposition, EnumDirection enumdirection) {
        if (!this.fy() && this.bs()) {
            if (!this.dI().x_().j() || !this.dI().x_().l()) {
                return Either.left(EntityHuman.EnumBedResult.a);
            }
            if (!this.a(blockposition, enumdirection)) {
                return Either.left(EntityHuman.EnumBedResult.c);
            }
            if (this.b(blockposition, enumdirection)) {
                return Either.left(EntityHuman.EnumBedResult.d);
            }
            this.setRespawnPosition(this.dI().ac(), blockposition, this.dy(), false, true, PlayerSetSpawnEvent.Cause.BED);
            if (this.dI().N()) {
                return Either.left(EntityHuman.EnumBedResult.b);
            }
            if (!this.f()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vec3D vec3d = Vec3D.c(blockposition);
                List<EntityMonster> list = this.dI().a(EntityMonster.class, new AxisAlignedBB(vec3d.a() - 8.0, vec3d.b() - 5.0, vec3d.c() - 8.0, vec3d.a() + 8.0, vec3d.b() + 5.0, vec3d.c() + 8.0), (? super T entitymonster) -> entitymonster.f(this));
                if (!list.isEmpty()) {
                    return Either.left(EntityHuman.EnumBedResult.f);
                }
            }
            return Either.right(Unit.a);
        }
        return Either.left(EntityHuman.EnumBedResult.e);
    }

    @Override
    public Either<EntityHuman.EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        EnumDirection enumdirection = this.dI().a_(blockposition).c(BlockFacingHorizontal.aC);
        Either<EntityHuman.EnumBedResult, Unit> bedResult = this.getBedResult(blockposition, enumdirection);
        if (bedResult.left().orElse(null) == EntityHuman.EnumBedResult.e) {
            return bedResult;
        }
        if (force) {
            bedResult = Either.right(Unit.a);
        }
        if ((bedResult = CraftEventFactory.callPlayerBedEnterEvent(this, blockposition, bedResult)).left().isPresent()) {
            return bedResult;
        }
        Either<EntityHuman.EnumBedResult, Unit> either = super.startSleepInBed(blockposition, force).ifRight(unit -> {
            this.a(StatisticList.ap);
            CriterionTriggers.q.a(this);
        });
        if (!this.x().d()) {
            this.a(IChatBaseComponent.c("sleep.not_possible"), true);
        }
        ((WorldServer)this.dI()).e();
        return either;
    }

    @Override
    public void b(BlockPosition pos) {
        this.a(StatisticList.i.b(StatisticList.n));
        super.b(pos);
    }

    private boolean a(BlockPosition pos, EnumDirection direction) {
        return this.i(pos) || this.i(pos.a(direction.g()));
    }

    private boolean i(BlockPosition pos) {
        Vec3D vec3d = Vec3D.c(pos);
        return Math.abs(this.dn() - vec3d.a()) <= 3.0 && Math.abs(this.dp() - vec3d.b()) <= 2.0 && Math.abs(this.dt() - vec3d.c()) <= 3.0;
    }

    private boolean b(BlockPosition pos, EnumDirection direction) {
        BlockPosition blockposition1 = pos.c();
        return !this.h(blockposition1) || !this.h(blockposition1.a(direction.g()));
    }

    @Override
    public void a(boolean skipSleepTimer, boolean updateSleepingPlayers) {
        if (!this.fy()) {
            return;
        }
        CraftPlayer player = this.getBukkitEntity();
        BlockPosition bedPosition = this.fw().orElse(null);
        Block bed = bedPosition != null ? this.dI().getWorld().getBlockAt(bedPosition.u(), bedPosition.v(), bedPosition.w()) : this.dI().getWorld().getBlockAt(player.getLocation());
        PlayerBedLeaveEvent event = new PlayerBedLeaveEvent((Player)player, bed, true);
        this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.fy()) {
            this.x().k().a(this, new PacketPlayOutAnimation(this, 2));
        }
        super.a(skipSleepTimer, updateSleepingPlayers);
        if (this.c != null) {
            this.c.teleport(this.dn(), this.dp(), this.dt(), this.dy(), this.dA(), PlayerTeleportEvent.TeleportCause.EXIT_BED);
        }
    }

    @Override
    public void a(double destX, double destY, double destZ) {
        this.bA();
        this.e(destX, destY, destZ);
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return super.b(damageSource) || this.K() || !this.dI().paperConfig().collisions.allowPlayerCrammingDamage && damageSource == this.dJ().g();
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
    }

    @Override
    protected void c(BlockPosition pos) {
        if (!this.G_()) {
            super.c(pos);
        }
    }

    public void a(double xDifference, double yDifference, double zDifference, boolean onGround) {
        if (!this.db()) {
            this.b(onGround, new Vec3D(xDifference, yDifference, zDifference));
            BlockPosition blockposition = this.aD();
            super.a(yDifference, onGround, this.dI().a_(blockposition), blockposition);
        }
    }

    @Override
    public void a(TileEntitySign sign, boolean front) {
        this.c.a(new PacketPlayOutBlockChange(this.dI(), sign.p()));
        this.c.a(new PacketPlayOutOpenSignEditor(sign.p(), front));
    }

    public int nextContainerCounter() {
        this.cZ = this.cZ % 100 + 1;
        return this.cZ;
    }

    @Override
    public OptionalInt a(@Nullable ITileInventory factory) {
        if (factory == null) {
            return OptionalInt.empty();
        }
        this.nextContainerCounter();
        Container container = factory.createMenu(this.cZ, this.fN(), this);
        IChatBaseComponent title = null;
        if (container != null) {
            container.setTitle(factory.H_());
            boolean cancelled = false;
            Pair<Component, Container> result = CraftEventFactory.callInventoryOpenEventWithTitle(this, container, cancelled);
            container = (Container)result.getSecond();
            title = PaperAdventure.asVanilla((Component)result.getFirst());
            if (container == null && !cancelled) {
                if (factory instanceof IInventory) {
                    ((IInventory)((Object)factory)).c(this);
                } else if (factory instanceof BlockChest.DoubleInventory) {
                    ((BlockChest.DoubleInventory)factory).inventorylargechest.c(this);
                }
                return OptionalInt.empty();
            }
        }
        if (container == null) {
            if (this.G_()) {
                this.a(IChatBaseComponent.c("container.spectatorCantOpen").a(EnumChatFormat.m), true);
            }
            return OptionalInt.empty();
        }
        this.bR = container;
        if (!this.eT()) {
            this.c.a(new PacketPlayOutOpenWindow(container.j, container.a(), Objects.requireNonNullElseGet(title, container::getTitle)));
        }
        this.a(container);
        return OptionalInt.of(this.cZ);
    }

    @Override
    public void a(int syncId, MerchantRecipeList offers, int levelProgress, int experience, boolean leveled, boolean refreshable) {
        this.c.a(new PacketPlayOutOpenWindowMerchant(syncId, offers, levelProgress, experience, leveled, refreshable));
    }

    @Override
    public void a(EntityHorseAbstract horse, IInventory inventory) {
        this.nextContainerCounter();
        Container container = new ContainerHorse(this.cZ, this.fN(), inventory, horse);
        container.setTitle(horse.H_());
        container = CraftEventFactory.callInventoryOpenEvent(this, container);
        if (container == null) {
            inventory.c(this);
            return;
        }
        if (this.bR != this.bQ) {
            this.closeContainer(InventoryCloseEvent.Reason.OPEN_NEW);
        }
        this.c.a(new PacketPlayOutOpenWindowHorse(this.cZ, inventory.b(), horse.af()));
        this.bR = container;
        this.a(this.bR);
    }

    @Override
    public void a(ItemStack book, EnumHand hand) {
        if (book.a(Items.th)) {
            if (ItemWrittenBook.a(book, this.da(), this)) {
                this.bR.d();
            }
            this.c.a(new PacketPlayOutOpenBook(hand));
        }
    }

    @Override
    public void a(TileEntityCommand commandBlock) {
        this.c.a(PacketPlayOutTileEntityData.a(commandBlock, TileEntity::o));
    }

    @Override
    public void q() {
        this.closeContainer(InventoryCloseEvent.Reason.UNKNOWN);
    }

    @Override
    public void closeContainer(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.c.a(new PacketPlayOutCloseWindow(this.bR.j));
        this.r();
    }

    @Override
    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.c.a(new PacketPlayOutCloseWindow(this.bR.j));
        this.bR = this.bQ;
    }

    @Override
    public void r() {
        this.bR.b(this);
        this.bQ.a(this.bR);
        this.bR = this.bQ;
    }

    public void a(float sidewaysSpeed, float forwardSpeed, boolean jumping, boolean sneaking) {
        if (this.bM()) {
            if (sidewaysSpeed >= -1.0f && sidewaysSpeed <= 1.0f) {
                this.bl = sidewaysSpeed;
            }
            if (forwardSpeed >= -1.0f && forwardSpeed <= 1.0f) {
                this.bn = forwardSpeed;
            }
            this.bk = jumping;
            if (sneaking != this.bP()) {
                PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this.getBukkitEntity(), sneaking);
                this.d.server.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            this.f(sneaking);
        }
    }

    @Override
    public void a(Statistic<?> stat, int amount) {
        this.co.b(this, stat, amount);
        this.dI().getCraftServer().getScoreboardManager().getScoreboardScores(stat, this.cv(), scoreboardscore -> scoreboardscore.a(amount));
    }

    @Override
    public void a(Statistic<?> stat) {
        this.co.a(this, stat, 0);
        this.dI().getCraftServer().getScoreboardManager().getScoreboardScores(stat, this.cv(), ScoreboardScore::c);
    }

    @Override
    public int a(Collection<IRecipe<?>> recipes) {
        return this.cG.a(recipes, this);
    }

    @Override
    public void a(IRecipe<?> recipe, List<ItemStack> ingredients) {
        CriterionTriggers.Z.a(this, recipe.e(), ingredients);
    }

    @Override
    public void a(MinecraftKey[] ids) {
        ArrayList list = Lists.newArrayList();
        MinecraftKey[] aminecraftkey1 = ids;
        int i2 = ids.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            MinecraftKey minecraftkey = aminecraftkey1[j2];
            Optional<IRecipe<?>> optional = this.d.aE().a(minecraftkey);
            Objects.requireNonNull(list);
            optional.ifPresent(list::add);
        }
        this.a(list);
    }

    @Override
    public int b(Collection<IRecipe<?>> recipes) {
        return this.cG.b(recipes, this);
    }

    @Override
    public void d(int experience) {
        super.d(experience);
        this.cy = -1;
    }

    public void s() {
        this.cJ = true;
        this.bz();
        if (this.bM() && this.cW() instanceof EntityPlayer) {
            this.Y();
        }
        if (this.fy()) {
            this.a(true, false);
        }
    }

    public boolean t() {
        return this.cJ;
    }

    public void u() {
        this.cv = -1.0E8f;
        this.cy = -1;
    }

    @Override
    public void a(IChatBaseComponent message, boolean overlay) {
        this.b(message, overlay);
    }

    @Override
    protected void Z_() {
        if (!this.bw.b() && this.fi()) {
            this.c.a(new PacketPlayOutEntityStatus(this, 9));
            super.Z_();
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor anchorPoint, Vec3D target) {
        super.a(anchorPoint, target);
        this.c.a(new PacketPlayOutLookAt(anchorPoint, target.c, target.d, target.e));
    }

    public void a(ArgumentAnchor.Anchor anchorPoint, net.minecraft.world.entity.Entity targetEntity, ArgumentAnchor.Anchor targetAnchor) {
        Vec3D vec3d = targetAnchor.a(targetEntity);
        super.a(anchorPoint, vec3d);
        this.c.a(new PacketPlayOutLookAt(anchorPoint, targetEntity, targetAnchor));
    }

    public void a(EntityPlayer oldPlayer, boolean alive) {
        this.cV = oldPlayer.cV;
        this.cT = oldPlayer.cT;
        this.cY = oldPlayer.cY;
        this.e.a(oldPlayer.e.b(), oldPlayer.e.c());
        this.w();
        if (alive) {
            this.fN().a(oldPlayer.fN());
            this.t(oldPlayer.er());
            this.bS = oldPlayer.bS;
            this.ce = oldPlayer.ce;
            this.cf = oldPlayer.cf;
            this.cg = oldPlayer.cg;
            this.r(oldPlayer.fI());
            this.aw = oldPlayer.aw;
        } else if (this.dI().X().b(GameRules.d) || oldPlayer.G_()) {
            this.fN().a(oldPlayer.fN());
            this.ce = oldPlayer.ce;
            this.cf = oldPlayer.cf;
            this.cg = oldPlayer.cg;
            this.r(oldPlayer.fI());
        }
        this.ch = oldPlayer.ch;
        this.bP = oldPlayer.bP;
        this.aj().b(EntityHuman.bL, oldPlayer.aj().b(EntityHuman.bL));
        this.cy = -1;
        this.cv = -1.0f;
        this.cw = -1;
        this.cF = oldPlayer.cF;
        this.cL = oldPlayer.cL;
        this.i(oldPlayer.ge());
        this.j(oldPlayer.gf());
        ((EntityHuman)this).a(oldPlayer.gm());
    }

    @Override
    protected void a(MobEffect effect, @Nullable net.minecraft.world.entity.Entity source) {
        super.a(effect, source);
        this.c.a(new PacketPlayOutEntityEffect(this.af(), effect));
        if (effect.c() == MobEffects.y) {
            this.cI = this.ag;
            this.cH = this.dg();
        }
        CriterionTriggers.A.a(this, source);
    }

    @Override
    protected void a(MobEffect effect, boolean reapplyEffect, @Nullable net.minecraft.world.entity.Entity source) {
        super.a(effect, reapplyEffect, source);
        this.c.a(new PacketPlayOutEntityEffect(this.af(), effect));
        CriterionTriggers.A.a(this, source);
    }

    @Override
    protected void a(MobEffect effect) {
        super.a(effect);
        this.c.a(new PacketPlayOutRemoveEntityEffect(this.af(), effect.c()));
        if (effect.c() == MobEffects.y) {
            this.cH = null;
        }
        CriterionTriggers.A.a(this, (net.minecraft.world.entity.Entity)null);
    }

    @Override
    public void b(double destX, double destY, double destZ) {
        this.c.a(destX, destY, destZ, this.dy(), this.dA(), RelativeMovement.g);
    }

    @Override
    public void c(double offsetX, double offsetY, double offsetZ) {
        this.c.a(this.dn() + offsetX, this.dp() + offsetY, this.dt() + offsetZ, this.dy(), this.dA(), RelativeMovement.f);
    }

    @Override
    public boolean a(WorldServer world, double destX, double destY, double destZ, Set<RelativeMovement> flags, float yaw, float pitch) {
        return this.teleportTo(world, destX, destY, destZ, flags, yaw, pitch, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    @Override
    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<RelativeMovement> set, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(BlockPosition.a(d0, d1, d2));
        worldserver.k().a(TicketType.g, chunkcoordintpair, 1, this.af());
        this.Y();
        if (this.fy()) {
            this.a(true, true);
        }
        if (worldserver == this.dI()) {
            this.c.teleport(d0, d1, d2, f2, f1, set, cause);
        } else {
            this.teleportTo(worldserver, d0, d1, d2, f2, f1, cause);
        }
        this.n(f2);
        return true;
    }

    @Override
    public void d(double x2, double y2, double z2) {
        super.d(x2, y2, z2);
        this.c.d();
    }

    @Override
    public void a(net.minecraft.world.entity.Entity target) {
        this.x().k().a(this, new PacketPlayOutAnimation(target, 4));
    }

    @Override
    public void b(net.minecraft.world.entity.Entity target) {
        this.x().k().a(this, new PacketPlayOutAnimation(target, 5));
    }

    @Override
    public void w() {
        if (this.c != null) {
            this.c.a(new PacketPlayOutAbilities(this.fO()));
            this.F();
        }
    }

    public WorldServer x() {
        return (WorldServer)this.dI();
    }

    public boolean a(EnumGamemode gameMode) {
        PlayerGameModeChangeEvent event = this.setGameMode(gameMode, PlayerGameModeChangeEvent.Cause.UNKNOWN, null);
        return event == null ? false : event.isCancelled();
    }

    @Nullable
    public PlayerGameModeChangeEvent setGameMode(EnumGamemode gameMode, PlayerGameModeChangeEvent.Cause cause, @Nullable Component message) {
        PlayerGameModeChangeEvent event = this.e.changeGameModeForPlayer(gameMode, cause, message);
        if (event == null || event.isCancelled()) {
            return null;
        }
        this.c.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.d, gameMode.a()));
        if (gameMode == EnumGamemode.d) {
            this.gb();
            this.Y();
        } else {
            this.c((net.minecraft.world.entity.Entity)this);
        }
        this.w();
        this.fg();
        return event;
    }

    @Override
    public boolean G_() {
        return this.e.b() == EnumGamemode.d;
    }

    @Override
    public boolean f() {
        return this.e.b() == EnumGamemode.b;
    }

    @Override
    public void a(IChatBaseComponent message) {
        this.b(message, false);
    }

    public void b(IChatBaseComponent message, boolean overlay) {
        if (this.v(overlay)) {
            this.c.a(new ClientboundSystemChatPacket(PaperAdventure.asAdventure(message), overlay), PacketSendListener.a(() -> {
                if (this.v(false)) {
                    boolean flag1 = true;
                    String s2 = message.a(256);
                    IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.b(s2).a(EnumChatFormat.o);
                    return new ClientboundSystemChatPacket(PaperAdventure.asAdventure(IChatBaseComponent.a("multiplayer.message_not_delivered", ichatmutablecomponent).a(EnumChatFormat.m)), false);
                }
                return null;
            }));
        }
    }

    public void a(OutgoingChatMessage message, boolean filterMaskEnabled, ChatMessageType.a params) {
        this.sendChatMessage(message, filterMaskEnabled, params, null);
    }

    public void sendChatMessage(OutgoingChatMessage message, boolean filterMaskEnabled, ChatMessageType.a params, @Nullable IChatBaseComponent unsigned) {
        if (this.gq()) {
            message.sendToPlayer(this, filterMaskEnabled, params, unsigned);
        }
    }

    public String y() {
        SocketAddress socketaddress = this.c.e();
        if (socketaddress instanceof InetSocketAddress) {
            InetSocketAddress inetsocketaddress = (InetSocketAddress)socketaddress;
            return InetAddresses.toAddrString((InetAddress)inetsocketaddress.getAddress());
        }
        return "<unknown>";
    }

    private Map<ClientOption<?>, ?> getClientOptionMap(String locale, int viewDistance, ClientOption.ChatVisibility chatVisibility, boolean chatColors, PaperSkinParts skinParts, MainHand mainHand, boolean allowsServerListing, boolean textFilteringEnabled) {
        HashMap<ClientOption, Object> map = new HashMap<ClientOption, Object>();
        map.put(ClientOption.LOCALE, locale);
        map.put(ClientOption.VIEW_DISTANCE, viewDistance);
        map.put(ClientOption.CHAT_VISIBILITY, chatVisibility);
        map.put(ClientOption.CHAT_COLORS_ENABLED, chatColors);
        map.put(ClientOption.SKIN_PARTS, skinParts);
        map.put(ClientOption.MAIN_HAND, mainHand);
        map.put(ClientOption.ALLOW_SERVER_LISTINGS, allowsServerListing);
        map.put(ClientOption.TEXT_FILTERING_ENABLED, textFilteringEnabled);
        return map;
    }

    public void a(PacketPlayInSettings packet) {
        PlayerChangedMainHandEvent event;
        new PlayerClientOptionsChangeEvent((Player)this.getBukkitEntity(), this.getClientOptionMap(packet.b, packet.c, ClientOption.ChatVisibility.valueOf((String)packet.d().name()), packet.e(), new PaperSkinParts(packet.f()), packet.g() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT, packet.i(), packet.h())).callEvent();
        if (this.fh() != packet.g()) {
            event = new PlayerChangedMainHandEvent((Player)this.getBukkitEntity(), this.fh() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            this.d.server.getPluginManager().callEvent((Event)event);
        }
        if (this.locale == null || !this.locale.equals(packet.b)) {
            event = new org.bukkit.event.player.PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), packet.b);
            this.d.server.getPluginManager().callEvent((Event)event);
            this.d.server.getPluginManager().callEvent((Event)new PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), this.locale, packet.b));
        }
        this.locale = packet.b;
        this.adventure$locale = Translator.parseLocale((String)this.locale);
        this.c.h.m.attr(PaperAdventure.LOCALE_ATTRIBUTE).set((Object)this.adventure$locale);
        this.clientViewDistance = packet.c;
        this.cA = packet.d();
        this.cB = packet.e();
        this.cT = packet.h();
        this.cU = packet.i();
        this.aj().b(EntityHuman.bL, (byte)packet.f());
        this.aj().b(EntityHuman.bM, (byte)(packet.g() != EnumMainHand.a ? 1 : 0));
    }

    public boolean z() {
        return this.cB;
    }

    public EnumChatVisibility A() {
        return this.cA;
    }

    private boolean v(boolean overlay) {
        return this.cA == EnumChatVisibility.c ? overlay : true;
    }

    private boolean gq() {
        return this.cA == EnumChatVisibility.a;
    }

    public void a(String url, String hash, boolean required, @Nullable IChatBaseComponent resourcePackPrompt) {
        this.c.a(new PacketPlayOutResourcePackSend(url, hash, required, resourcePackPrompt));
    }

    public void a(ServerPing metadata) {
        this.c.a(new ClientboundServerDataPacket(metadata.a(), metadata.d().map(ServerPing.a::a), metadata.e()));
    }

    @Override
    protected int B() {
        return this.d.c(this.fM());
    }

    public void C() {
        this.cC = SystemUtils.b();
    }

    public ServerStatisticManager D() {
        return this.co;
    }

    public RecipeBookServer E() {
        return this.cG;
    }

    @Override
    protected void F() {
        if (this.G_()) {
            this.em();
            this.j(true);
        } else {
            super.F();
        }
    }

    public net.minecraft.world.entity.Entity G() {
        return this.cD == null ? this : this.cD;
    }

    public void c(@Nullable net.minecraft.world.entity.Entity entity) {
        net.minecraft.world.entity.Entity entity1 = this.G();
        net.minecraft.world.entity.Entity entity2 = this.cD = entity == null ? this : entity;
        if (entity1 != this.cD) {
            PlayerStartSpectatingEntityEvent playerStartSpectatingEntityEvent;
            PlayerStopSpectatingEntityEvent playerStopSpectatingEntityEvent;
            if (this.cD == this ? !(playerStopSpectatingEntityEvent = new PlayerStopSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)entity1.getBukkitEntity())).callEvent() : !(playerStartSpectatingEntityEvent = new PlayerStartSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)entity1.getBukkitEntity(), (Entity)entity.getBukkitEntity())).callEvent()) {
                return;
            }
            net.minecraft.world.level.World world = this.cD.dI();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                this.teleportTo(worldserver, this.cD.dn(), this.cD.dp(), this.cD.dt(), Set.of(), this.dy(), this.dA(), PlayerTeleportEvent.TeleportCause.SPECTATE);
            }
            if (entity != null) {
                this.x().k().a(this);
            }
            this.c.a(new PacketPlayOutCamera(this.cD));
            this.c.d();
        }
    }

    @Override
    protected void H() {
        if (!this.cE) {
            super.H();
        }
    }

    @Override
    public void d(net.minecraft.world.entity.Entity target) {
        if (this.e.b() == EnumGamemode.d) {
            this.c(target);
        } else {
            super.d(target);
        }
    }

    public long I() {
        return this.cC;
    }

    @Nullable
    public IChatBaseComponent J() {
        return this.listName;
    }

    @Override
    public void a(EnumHand hand) {
        super.a(hand);
        this.gh();
    }

    public boolean K() {
        return this.cE;
    }

    public void L() {
        this.cE = false;
    }

    public AdvancementDataPlayer M() {
        return this.cn;
    }

    public void a(WorldServer targetWorld, double x2, double y2, double z2, float yaw, float pitch) {
        this.teleportTo(targetWorld, x2, y2, z2, yaw, pitch, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public void teleportTo(WorldServer worldserver, double d0, double d1, double d2, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        this.c((net.minecraft.world.entity.Entity)this);
        this.Y();
        this.getBukkitEntity().teleport(new Location((World)worldserver.getWorld(), d0, d1, d2, f2, f1), cause);
    }

    @Nullable
    public BlockPosition N() {
        return this.cP;
    }

    public float O() {
        return this.cR;
    }

    public ResourceKey<net.minecraft.world.level.World> P() {
        return this.cO;
    }

    public boolean Q() {
        return this.cQ;
    }

    @Deprecated
    public void a(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition pos, float angle, boolean forced, boolean sendMessage) {
        this.setRespawnPosition(dimension, pos, angle, forced, sendMessage, PlayerSetSpawnEvent.Cause.UNKNOWN);
    }

    @Deprecated
    public boolean setRespawnPosition(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition pos, float angle, boolean forced, boolean sendMessage, PlayerSpawnChangeEvent.Cause cause) {
        return this.setRespawnPosition(dimension, pos, angle, forced, sendMessage, cause == PlayerSpawnChangeEvent.Cause.RESET ? PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN : PlayerSetSpawnEvent.Cause.valueOf((String)cause.name()));
    }

    public boolean setRespawnPosition(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition pos, float angle, boolean forced, boolean sendMessage, PlayerSetSpawnEvent.Cause cause) {
        Location spawnLoc = null;
        boolean willNotify = false;
        if (pos != null) {
            boolean flag2 = pos.equals(this.cP) && dimension.equals(this.cO);
            spawnLoc = MCUtil.toLocation(this.cI().a(dimension), pos);
            spawnLoc.setYaw(angle);
            willNotify = sendMessage && !flag2;
        }
        PlayerSpawnChangeEvent dumbEvent = new PlayerSpawnChangeEvent((Player)this.getBukkitEntity(), spawnLoc, forced, cause == PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN ? PlayerSpawnChangeEvent.Cause.RESET : PlayerSpawnChangeEvent.Cause.valueOf((String)cause.name()));
        dumbEvent.callEvent();
        PlayerSetSpawnEvent event = new PlayerSetSpawnEvent((Player)this.getBukkitEntity(), cause, dumbEvent.getNewSpawn(), dumbEvent.isForced(), willNotify, (Component)(willNotify ? Component.translatable((String)"block.minecraft.set_spawn") : null));
        event.setCancelled(dumbEvent.isCancelled());
        if (!event.callEvent()) {
            return false;
        }
        if (event.getLocation() != null) {
            dimension = event.getLocation().getWorld() != null ? ((CraftWorld)event.getLocation().getWorld()).getHandle().ac() : dimension;
            pos = MCUtil.toBlockPosition(event.getLocation());
            angle = event.getLocation().getYaw();
            forced = event.isForced();
            if (event.willNotifyPlayer() && event.getNotification() != null) {
                this.a(PaperAdventure.asVanilla(event.getNotification()));
            }
            this.cP = pos;
            this.cO = dimension;
            this.cR = angle;
            this.cQ = forced;
        } else {
            this.cP = null;
            this.cO = net.minecraft.world.level.World.h;
            this.cR = 0.0f;
            this.cQ = false;
        }
        return true;
    }

    public void a(ChunkCoordIntPair chunkPos, Packet<?> chunkDataPacket) {
        this.c.a(chunkDataPacket);
        if (PlayerChunkLoadEvent.getHandlerList().getRegisteredListeners().length > 0) {
            new PlayerChunkLoadEvent(this.getBukkitEntity().getWorld().getChunkAt(chunkPos.longKey), (Player)this.getBukkitEntity()).callEvent();
        }
    }

    public void a(ChunkCoordIntPair chunkPos) {
        if (this.bs()) {
            this.c.a(new PacketPlayOutUnloadChunk(chunkPos.e, chunkPos.f));
            if (PlayerChunkUnloadEvent.getHandlerList().getRegisteredListeners().length > 0) {
                new PlayerChunkUnloadEvent(this.getBukkitEntity().getWorld().getChunkAt(chunkPos.longKey), (Player)this.getBukkitEntity()).callEvent();
            }
        }
    }

    public SectionPosition R() {
        return this.cN;
    }

    public void a(SectionPosition section) {
        this.cN = section;
    }

    @Override
    public void a(SoundEffect event, SoundCategory category, float volume, float pitch) {
        this.c.a(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.c.d(event), category, this.dn(), this.dp(), this.dt(), volume, pitch, this.af.g()));
    }

    @Override
    public Packet<PacketListenerPlayOut> S() {
        return new PacketPlayOutNamedEntitySpawn(this);
    }

    @Override
    public EntityItem a(ItemStack stack, boolean throwRandomly, boolean retainOwnership) {
        EntityItem entityitem = super.a(stack, throwRandomly, retainOwnership);
        if (entityitem == null) {
            return null;
        }
        this.dI().b(entityitem);
        ItemStack itemstack1 = entityitem.j();
        if (retainOwnership) {
            if (!itemstack1.b()) {
                this.a(StatisticList.f.b(itemstack1.d()), itemstack1.L());
            }
            this.a(StatisticList.F);
        }
        return entityitem;
    }

    public ITextFilter T() {
        return this.cS;
    }

    public void c(WorldServer world) {
        this.a((net.minecraft.world.level.World)world);
        this.e.a(world);
    }

    @Nullable
    private static EnumGamemode a(@Nullable NBTTagCompound nbt, String key) {
        return nbt != null && nbt.b(key, 99) ? EnumGamemode.a(nbt.h(key)) : null;
    }

    private EnumGamemode b(@Nullable EnumGamemode backupGameMode) {
        EnumGamemode enumgamemode1 = this.d.aX();
        return enumgamemode1 != null ? enumgamemode1 : (backupGameMode != null ? backupGameMode : this.d.o_());
    }

    public void c(@Nullable NBTTagCompound nbt) {
        if (this.d.aX() != null && this.d.aX() != EntityPlayer.a(nbt, "playerGameType")) {
            if (new PlayerGameModeChangeEvent((Player)this.getBukkitEntity(), GameMode.getByValue((int)this.d.o_().a()), PlayerGameModeChangeEvent.Cause.DEFAULT_GAMEMODE, null).callEvent()) {
                this.e.a(this.d.aX(), EnumGamemode.e);
            } else {
                this.e.a(EntityPlayer.a(nbt, "playerGameType"), EntityPlayer.a(nbt, "previousPlayerGameType"));
            }
            return;
        }
        this.e.a(this.b(EntityPlayer.a(nbt, "playerGameType")), EntityPlayer.a(nbt, "previousPlayerGameType"));
    }

    private void k(NBTTagCompound nbt) {
        nbt.a("playerGameType", this.e.b().a());
        EnumGamemode enumgamemode = this.e.c();
        if (enumgamemode != null) {
            nbt.a("previousPlayerGameType", enumgamemode.a());
        }
    }

    @Override
    public boolean U() {
        return this.cT;
    }

    public boolean b(EntityPlayer player) {
        return player == this ? false : this.cT || player.cT;
    }

    @Override
    public boolean a(net.minecraft.world.level.World world, BlockPosition pos) {
        return super.a(world, pos) && world.a(this, pos);
    }

    @Override
    protected void a(ItemStack stack) {
        CriterionTriggers.T.a(this, stack);
        super.a(stack);
    }

    public boolean a(boolean entireStack) {
        PlayerInventory playerinventory = this.fN();
        ItemStack itemstack = playerinventory.a(entireStack);
        this.bR.b(playerinventory, playerinventory.l).ifPresent(i2 -> this.bR.a(i2, playerinventory.f()));
        return this.a(itemstack, false, true) != null;
    }

    public boolean V() {
        return this.cU;
    }

    @Override
    public Optional<WardenSpawnTracker> W() {
        return Optional.of(this.cV);
    }

    @Override
    public void a(EntityItem item) {
        super.a(item);
        net.minecraft.world.entity.Entity entity = item.v();
        if (entity != null) {
            CriterionTriggers.P.a(this, item.j(), entity);
        }
    }

    public void a(RemoteChatSession session) {
        this.cY = session;
    }

    @Nullable
    public RemoteChatSession X() {
        return this.cY != null && this.cY.c() ? null : this.cY;
    }

    @Override
    public void a(double deltaX, double deltaZ) {
        this.ck = (float)(MathHelper.d(deltaZ, deltaX) * 57.2957763671875 - (double)this.dy());
        this.c.a(new ClientboundHurtAnimationPacket(this));
    }

    @Override
    public boolean a(net.minecraft.world.entity.Entity entity, boolean force) {
        if (!super.a(entity, force)) {
            return false;
        }
        entity.i(this);
        this.c.a(this.dn(), this.dp(), this.dt(), this.dy(), this.dA());
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            for (MobEffect mobeffect : entityliving.eo()) {
                this.c.a(new PacketPlayOutEntityEffect(entity.af(), mobeffect));
            }
        }
        return true;
    }

    @Override
    public void Y() {
        net.minecraft.world.entity.Entity entity = this.cW();
        super.Y();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            for (MobEffect mobeffect : entityliving.eo()) {
                this.c.a(new PacketPlayOutRemoveEntityEffect(entity.af(), mobeffect.c()));
            }
        }
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.dI().W() + this.timeOffset;
        }
        return this.dI().W() - this.dI().W() % 24000L + this.timeOffset;
    }

    public WeatherType getPlayerWeather() {
        return this.weather;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weather != null) {
            return;
        }
        if (plugin) {
            this.weather = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.c.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.c, 0.0f));
        } else {
            this.c.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weather == null) {
            if (oldRain != newRain) {
                this.c.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.c.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weather == WeatherType.DOWNFALL || this.weather == null) {
                this.c.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, newThunder));
            } else {
                this.c.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weather == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weather == WeatherType.DOWNFALL ? (float)((double)this.pluginRainPosition + 0.01) : (float)((double)this.pluginRainPosition - 0.01);
        this.pluginRainPosition = MathHelper.a(this.pluginRainPosition, 0.0f, 1.0f);
    }

    public void resetPlayerWeather() {
        this.weather = null;
        this.setPlayerWeather(this.dI().u_().k() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.cv() + " at " + this.dn() + "," + this.dp() + "," + this.dt() + ")";
    }

    public void forceSetPositionRotation(double x2, double y2, double z2, float yaw, float pitch) {
        this.b(x2, y2, z2, yaw, pitch);
        this.c.d();
    }

    @Override
    public boolean eT() {
        return super.eT() || this.c != null && this.c.isDisconnected();
    }

    @Override
    public Scoreboard gc() {
        return this.getBukkitEntity().getScoreboard().getHandle();
    }

    public void reset() {
        float exp = 0.0f;
        boolean keepInventory = this.dI().X().b(GameRules.d);
        if (this.keepLevel) {
            exp = this.cg;
            this.newTotalExp = this.cf;
            this.newLevel = this.ce;
        }
        this.t(this.eI());
        this.fo();
        this.j(this.ce());
        this.h(0);
        this.aa = 0.0f;
        this.bS = new FoodMetaData(this);
        this.ce = this.newLevel;
        this.cf = this.newTotalExp;
        this.cg = 0.0f;
        this.aN = 0;
        this.setArrowCount(0, true);
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        ((EntityLiving)this).bV = true;
        this.bR = this.bQ;
        this.aZ = null;
        ((EntityLiving)this).bW = null;
        ((EntityLiving)this).bQ = new CombatTracker(this);
        this.cy = -1;
        if (this.keepLevel) {
            this.cg = exp;
        } else {
            this.d(this.newExp);
        }
        this.keepLevel = false;
        this.o(0.0, 0.0, 0.0);
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)super.getBukkitEntity();
    }
}

