/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.starlight.common.light.StarLightInterface;
import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.system.light.LightQueue;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.game.PacketPlayOutLightUpdate;
import net.minecraft.server.level.ChunkTaskQueueSorter;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.lighting.LightEngineLayerEventListener;
import org.bukkit.Bukkit;
import org.slf4j.Logger;

public class LightEngineThreaded
extends LevelLightEngine
implements AutoCloseable {
    public static final int a = 1000;
    private static final Logger d = LogUtils.getLogger();
    private final PlayerChunkMap g;
    public final StarLightInterface theLightEngine;
    public final boolean hasBlockLight;
    public final boolean hasSkyLight;
    protected long relightCounter;
    private final Long2IntOpenHashMap chunksBeingWorkedOn = new Long2IntOpenHashMap();

    public LightEngineThreaded(ILightAccess chunkProvider, PlayerChunkMap chunkStorage, boolean hasBlockLight, ThreadedMailbox<Runnable> processor, Mailbox<ChunkTaskQueueSorter.a<Runnable>> executor) {
        super(chunkProvider, false, false);
        this.g = chunkStorage;
        this.hasBlockLight = true;
        this.hasSkyLight = hasBlockLight;
        this.theLightEngine = new StarLightInterface(chunkProvider, this.hasSkyLight, this.hasBlockLight, this);
    }

    protected final IChunkAccess getChunk(int chunkX, int chunkZ) {
        return ((WorldServer)this.theLightEngine.getWorld()).k().getChunkAtImmediately(chunkX, chunkZ);
    }

    public int relight(Set<ChunkCoordIntPair> chunks_param, Consumer<ChunkCoordIntPair> chunkLightCallback, IntConsumer onComplete) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Must only be called on the main thread");
        }
        LinkedHashSet<ChunkCoordIntPair> chunks = new LinkedHashSet<ChunkCoordIntPair>(chunks_param);
        HashMap<ChunkCoordIntPair, Long> ticketIds = new HashMap<ChunkCoordIntPair, Long>();
        int totalChunks = 0;
        Iterator iterator = chunks.iterator();
        while (iterator.hasNext()) {
            ChunkCoordIntPair chunkPos = (ChunkCoordIntPair)iterator.next();
            IChunkAccess chunk = (IChunkAccess)((WorldServer)this.theLightEngine.getWorld()).k().c(chunkPos.e, chunkPos.f);
            if (chunk == null || !chunk.v() || !chunk.j().b(ChunkStatus.l)) {
                iterator.remove();
                continue;
            }
            Long id = this.relightCounter++;
            ((WorldServer)this.theLightEngine.getWorld()).k().addTicketAtLevel(TicketType.CHUNK_RELIGHT, chunkPos, MCUtil.getTicketLevelFor(ChunkStatus.l), id);
            ticketIds.put(chunkPos, id);
            ++totalChunks;
        }
        this.g.q.chunkTaskScheduler.radiusAwareScheduler.queueInfiniteRadiusTask(() -> this.theLightEngine.relightChunks(chunks, chunkPos -> {
            chunkLightCallback.accept((ChunkCoordIntPair)chunkPos);
            ((WorldServer)this.theLightEngine.getWorld()).k().g.execute(() -> {
                ((WorldServer)this.theLightEngine.getWorld()).k().a.a(chunkPos.a()).broadcast(new PacketPlayOutLightUpdate((ChunkCoordIntPair)chunkPos, this, null, null), false);
                ((WorldServer)this.theLightEngine.getWorld()).k().removeTicketAtLevel(TicketType.CHUNK_RELIGHT, (ChunkCoordIntPair)chunkPos, MCUtil.getTicketLevelFor(ChunkStatus.l), (Long)ticketIds.get(chunkPos));
            });
        }, onComplete));
        this.b();
        return totalChunks;
    }

    private void queueTaskForSection(int chunkX, int chunkY, int chunkZ, Supplier<LightQueue.ChunkTasks> runnable) {
        WorldServer world = (WorldServer)this.theLightEngine.getWorld();
        IChunkAccess center = this.theLightEngine.getAnyChunkNow(chunkX, chunkZ);
        if (center == null || !center.j().b(ChunkStatus.l)) {
            return;
        }
        if (center.j() != ChunkStatus.n) {
            runnable.get();
            return;
        }
        if (!world.k().a.s.bl()) {
            world.k().a.s.execute(() -> this.queueTaskForSection(chunkX, chunkY, chunkZ, runnable));
            return;
        }
        long key = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        LightQueue.ChunkTasks updateFuture = runnable.get();
        if (updateFuture == null) {
            return;
        }
        if (updateFuture.isTicketAdded) {
            return;
        }
        updateFuture.isTicketAdded = true;
        int references = this.chunksBeingWorkedOn.addTo(key, 1);
        if (references == 0) {
            ChunkCoordIntPair pos = new ChunkCoordIntPair(chunkX, chunkZ);
            world.k().a(StarLightInterface.CHUNK_WORK_TICKET, pos, 0, pos);
        }
        ((CompletableFuture)updateFuture.onComplete.thenAcceptAsync(ignore -> {
            int newReferences = this.chunksBeingWorkedOn.get(key);
            if (newReferences == 1) {
                this.chunksBeingWorkedOn.remove(key);
                ChunkCoordIntPair pos = new ChunkCoordIntPair(chunkX, chunkZ);
                world.k().b(StarLightInterface.CHUNK_WORK_TICKET, pos, 0, pos);
            } else {
                this.chunksBeingWorkedOn.put(key, newReferences - 1);
            }
        }, (Executor)world.k().a.s)).whenComplete((ignore, thr) -> {
            if (thr != null) {
                d.error("Failed to remove ticket level for post chunk task " + new ChunkCoordIntPair(chunkX, chunkZ), thr);
            }
        });
    }

    @Override
    public boolean E_() {
        return this.theLightEngine.hasUpdates();
    }

    @Override
    public LightEngineLayerEventListener a(EnumSkyBlock lightType) {
        return lightType == EnumSkyBlock.b ? this.theLightEngine.getBlockReader() : this.theLightEngine.getSkyReader();
    }

    @Override
    public int a(BlockPosition pos, int ambientDarkness) {
        int sky = this.theLightEngine.getSkyReader().b(pos) - ambientDarkness;
        if (sky == 15) {
            return 15;
        }
        int block = this.theLightEngine.getBlockReader().b(pos);
        return Math.max(sky, block);
    }

    @Override
    public void close() {
    }

    @Override
    public int a() {
        throw SystemUtils.b(new UnsupportedOperationException("Ran automatically on a different thread!"));
    }

    @Override
    public void a(BlockPosition pos) {
        BlockPosition posCopy = pos.i();
        this.queueTaskForSection(posCopy.u() >> 4, posCopy.v() >> 4, posCopy.w() >> 4, () -> this.theLightEngine.blockChange(posCopy));
    }

    protected void a(ChunkCoordIntPair pos) {
    }

    @Override
    public void a(SectionPosition pos, boolean notReady) {
        this.queueTaskForSection(pos.u(), pos.v(), pos.w(), () -> this.theLightEngine.sectionChange(pos, notReady));
    }

    @Override
    public void b(ChunkCoordIntPair chunkPos) {
    }

    @Override
    public void a(ChunkCoordIntPair pos, boolean retainData) {
    }

    @Override
    public void a(EnumSkyBlock lightType, SectionPosition pos, @Nullable NibbleArray nibbles) {
    }

    private void a(int x2, int z2, Update stage, Runnable task) {
        throw new UnsupportedOperationException();
    }

    private void a(int x2, int z2, IntSupplier completedLevelSupplier, Update stage, Runnable task) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void b(ChunkCoordIntPair pos, boolean retainData) {
    }

    public CompletableFuture<IChunkAccess> a(IChunkAccess chunk, boolean bl) {
        return CompletableFuture.completedFuture(chunk);
    }

    public CompletableFuture<IChunkAccess> b(IChunkAccess chunk, boolean excludeBlocks) {
        throw new UnsupportedOperationException();
    }

    public void b() {
    }

    private void f() {
        throw new UnsupportedOperationException();
    }

    private /* synthetic */ void lambda$initializeLight$24(ChunkCoordIntPair chunkPos, Runnable task) {
        this.a(chunkPos.e, chunkPos.f, Update.b, task);
    }

    private /* synthetic */ IChunkAccess lambda$initializeLight$23(ChunkCoordIntPair chunkPos, boolean bl, IChunkAccess chunk) {
        super.a(chunkPos, bl);
        super.b(chunkPos, false);
        return chunk;
    }

    private static /* synthetic */ String lambda$initializeLight$22(ChunkCoordIntPair chunkPos) {
        return "initializeLight: " + chunkPos;
    }

    private /* synthetic */ void lambda$initializeLight$21(IChunkAccess chunk, ChunkCoordIntPair chunkPos) {
        ChunkSection[] levelChunkSections = chunk.d();
        for (int i2 = 0; i2 < chunk.ak(); ++i2) {
            ChunkSection levelChunkSection = levelChunkSections[i2];
            if (levelChunkSection.c()) continue;
            int j2 = this.c.g(i2);
            super.a(SectionPosition.a(chunkPos, j2), false);
        }
    }

    private static /* synthetic */ String lambda$retainData$20(ChunkCoordIntPair pos) {
        return "retainData " + pos;
    }

    private /* synthetic */ void lambda$retainData$19(ChunkCoordIntPair pos, boolean retainData) {
        super.b(pos, retainData);
    }

    private static /* synthetic */ int lambda$retainData$18() {
        return 0;
    }

    private static /* synthetic */ String lambda$queueSectionData$17(SectionPosition pos) {
        return "queueData " + pos;
    }

    private /* synthetic */ void lambda$queueSectionData$16(EnumSkyBlock lightType, SectionPosition pos, NibbleArray nibbles) {
        super.a(lightType, pos, nibbles);
    }

    private static /* synthetic */ int lambda$queueSectionData$15() {
        return 0;
    }

    private static /* synthetic */ String lambda$setLightEnabled$14(ChunkCoordIntPair pos, boolean retainData) {
        return "enableLight " + pos + " " + retainData;
    }

    private /* synthetic */ void lambda$setLightEnabled$13(ChunkCoordIntPair pos, boolean retainData) {
        super.a(pos, retainData);
    }

    private static /* synthetic */ String lambda$propagateLightSources$12(ChunkCoordIntPair chunkPos) {
        return "propagateLight " + chunkPos;
    }

    private /* synthetic */ void lambda$propagateLightSources$11(ChunkCoordIntPair chunkPos) {
        super.b(chunkPos);
    }

    private static /* synthetic */ String lambda$updateChunkStatus$9(ChunkCoordIntPair pos) {
        return "updateChunkStatus " + pos + " true";
    }

    private /* synthetic */ void lambda$updateChunkStatus$8(ChunkCoordIntPair pos) {
        super.b(pos, false);
        super.a(pos, false);
        for (int i2 = this.d(); i2 < this.e(); ++i2) {
            super.a(EnumSkyBlock.b, SectionPosition.a(pos, i2), null);
            super.a(EnumSkyBlock.a, SectionPosition.a(pos, i2), null);
        }
        for (int j2 = this.c.al(); j2 < this.c.am(); ++j2) {
            super.a(SectionPosition.a(pos, j2), true);
        }
    }

    private static /* synthetic */ int lambda$updateChunkStatus$7() {
        return 0;
    }

    static final class Update
    extends Enum<Update> {
        public static final /* enum */ Update a = new Update();
        public static final /* enum */ Update b = new Update();
        private static final /* synthetic */ Update[] c;

        public static Update[] values() {
            return (Update[])c.clone();
        }

        public static Update valueOf(String name) {
            return Enum.valueOf(Update.class, name);
        }

        private static /* synthetic */ Update[] a() {
            return new Update[]{a, b};
        }

        static {
            c = Update.a();
        }
    }
}

