/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.destroystokyo.paper.util.maplist.ReferenceList;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.chunk.system.scheduling.NewChunkHolder;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutLightUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutMultiBlockChange;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.util.DebugBuffer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.spigotmc.AsyncCatcher;

public class PlayerChunk {
    public static final Either<IChunkAccess, Failure> a = Either.right(Failure.b);
    public static final CompletableFuture<Either<IChunkAccess, Failure>> b = CompletableFuture.completedFuture(a);
    public static final Either<Chunk, Failure> c = Either.right(Failure.b);
    private static final Either<IChunkAccess, Failure> d = Either.right(Failure.b);
    private static final CompletableFuture<Either<Chunk, Failure>> e = CompletableFuture.completedFuture(c);
    private static final List<ChunkStatus> f = ChunkStatus.a();
    private final LevelHeightAccessor h;
    @Nullable
    private final DebugBuffer<b> m;
    public final ChunkCoordIntPair q;
    private boolean r;
    private final ShortSet[] s;
    private final BitSet t;
    private final BitSet u;
    private final LevelLightEngine v;
    private final c w;
    public final d x;
    private final PlayerChunkMap chunkMap;
    public final NewChunkHolder newChunkHolder;
    PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> playersInMobSpawnRange;
    PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> playersInChunkTickRange;
    private final ReferenceList<EntityPlayer> playersSentChunkTo = new ReferenceList();

    public final Chunk getSendingChunk() {
        Chunk ret = this.chunkMap.q.k().getChunkAtIfLoadedImmediately(this.q.e, this.q.f);
        if (ret != null && ret.areNeighboursLoaded(1)) {
            return ret;
        }
        return null;
    }

    public void onChunkAdd() {
        Chunk chunk;
        long key = MCUtil.getCoordinateKey(this.q);
        this.playersInMobSpawnRange = this.chunkMap.playerMobSpawnMap.getObjectsInRange(key);
        this.playersInChunkTickRange = this.chunkMap.playerChunkTickRangeMap.getObjectsInRange(key);
        if (this.needsBroadcastChanges()) {
            this.chunkMap.needsChangeBroadcasting.add((Object)this);
        }
        if ((chunk = this.getFullChunkNowUnchecked()) != null) {
            chunk.updateGeneralAreaCache();
        }
    }

    public void onChunkRemove() {
        Chunk chunk;
        this.playersInMobSpawnRange = null;
        this.playersInChunkTickRange = null;
        if (this.needsBroadcastChanges()) {
            this.chunkMap.needsChangeBroadcasting.remove((Object)this);
        }
        if ((chunk = this.getFullChunkNowUnchecked()) != null) {
            chunk.removeGeneralAreaCache();
        }
    }

    public void addPlayer(EntityPlayer player) {
        if (!this.playersSentChunkTo.add(player)) {
            throw new IllegalStateException("Already sent chunk " + this.q + " in world '" + this.chunkMap.q.getWorld().getName() + "' to player " + player);
        }
    }

    public void removePlayer(EntityPlayer player) {
        if (!this.playersSentChunkTo.remove(player)) {
            throw new IllegalStateException("Have not sent chunk " + this.q + " in world '" + this.chunkMap.q.getWorld().getName() + "' to player " + player);
        }
    }

    public boolean hasChunkBeenSent() {
        return this.playersSentChunkTo.size() != 0;
    }

    public PlayerChunk(ChunkCoordIntPair pos, LevelHeightAccessor world, LevelLightEngine lightingProvider, d playersWatchingChunkProvider, NewChunkHolder newChunkHolder) {
        this.newChunkHolder = newChunkHolder;
        this.m = null;
        this.t = new BitSet();
        this.u = new BitSet();
        this.q = pos;
        this.h = world;
        this.v = lightingProvider;
        this.w = null;
        this.x = playersWatchingChunkProvider;
        this.s = new ShortSet[world.ak()];
        this.chunkMap = (PlayerChunkMap)playersWatchingChunkProvider;
    }

    @Nullable
    public IChunkAccess getAvailableChunkNow() {
        return this.newChunkHolder.getCurrentChunk();
    }

    public Chunk getFullChunkNow() {
        IChunkAccess chunk = this.getAvailableChunkNow();
        if (!this.isFullChunkReady() || !(chunk instanceof Chunk)) {
            return null;
        }
        return (Chunk)chunk;
    }

    public Chunk getFullChunkNowUnchecked() {
        IChunkAccess chunk = this.getAvailableChunkNow();
        return chunk instanceof Chunk ? (Chunk)chunk : null;
    }

    public CompletableFuture<Either<IChunkAccess, Failure>> a(ChunkStatus leastStatus) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Either<IChunkAccess, Failure>> b(ChunkStatus leastStatus) {
        throw new UnsupportedOperationException();
    }

    public final CompletableFuture<Either<Chunk, Failure>> a() {
        throw new UnsupportedOperationException();
    }

    public final CompletableFuture<Either<Chunk, Failure>> b() {
        throw new UnsupportedOperationException();
    }

    public final CompletableFuture<Either<Chunk, Failure>> c() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public final Chunk d() {
        if (!this.isTickingReady()) {
            return null;
        }
        return (Chunk)this.getAvailableChunkNow();
    }

    @Nullable
    public final Chunk e() {
        if (!this.isFullChunkReady()) {
            return null;
        }
        return (Chunk)this.getAvailableChunkNow();
    }

    @Nullable
    public ChunkStatus f() {
        return this.newChunkHolder.getCurrentGenStatus();
    }

    public ChunkStatus getChunkHolderStatus() {
        return this.newChunkHolder.getCurrentGenStatus();
    }

    @Nullable
    public IChunkAccess g() {
        return this.newChunkHolder.getCurrentChunk();
    }

    public void a(BlockPosition pos) {
        if (this.playersSentChunkTo.size() == 0) {
            return;
        }
        Chunk chunk = this.getSendingChunk();
        if (chunk != null) {
            int i2 = this.h.e(pos.v());
            if (i2 < 0 || i2 >= this.s.length) {
                return;
            }
            if (this.s[i2] == null) {
                this.r = true;
                this.addToBroadcastMap();
                this.s[i2] = new ShortOpenHashSet();
            }
            this.s[i2].add(SectionPosition.b(pos));
        }
    }

    public void a(EnumSkyBlock lightType, int y2) {
        IChunkAccess ichunkaccess = this.getAvailableChunkNow();
        if (ichunkaccess != null) {
            ichunkaccess.a(true);
            Chunk chunk = this.getSendingChunk();
            if (this.playersSentChunkTo.size() != 0 && chunk != null) {
                int j2 = this.v.d();
                int k2 = this.v.e();
                if (y2 >= j2 && y2 <= k2) {
                    this.addToBroadcastMap();
                    int l2 = y2 - j2;
                    if (lightType == EnumSkyBlock.a) {
                        this.u.set(l2);
                    } else {
                        this.t.set(l2);
                    }
                }
            }
        }
    }

    public final boolean needsBroadcastChanges() {
        return this.r || !this.u.isEmpty() || !this.t.isEmpty();
    }

    private void addToBroadcastMap() {
        AsyncCatcher.catchOp("ChunkHolder update");
        this.chunkMap.needsChangeBroadcasting.add((Object)this);
    }

    public void a(Chunk chunk) {
        if (this.needsBroadcastChanges()) {
            List<EntityPlayer> list;
            World world = chunk.F();
            if (!this.u.isEmpty() || !this.t.isEmpty()) {
                list = this.getPlayers(true);
                if (!list.isEmpty()) {
                    PacketPlayOutLightUpdate packetplayoutlightupdate = new PacketPlayOutLightUpdate(chunk.f(), this.v, this.u, this.t);
                    this.a(list, packetplayoutlightupdate);
                }
                this.u.clear();
                this.t.clear();
            }
            if (this.r) {
                list = this.getPlayers(false);
                for (int i2 = 0; i2 < this.s.length; ++i2) {
                    ShortSet shortset = this.s[i2];
                    if (shortset == null) continue;
                    this.s[i2] = null;
                    if (list.isEmpty()) continue;
                    int j2 = this.h.g(i2);
                    SectionPosition sectionposition = SectionPosition.a(chunk.f(), j2);
                    if (shortset.size() == 1) {
                        BlockPosition blockposition = sectionposition.g(shortset.iterator().nextShort());
                        IBlockData iblockdata = world.a_(blockposition);
                        this.a(list, new PacketPlayOutBlockChange(blockposition, iblockdata));
                        this.a(list, world, blockposition, iblockdata);
                        continue;
                    }
                    ChunkSection chunksection = chunk.b(i2);
                    PacketPlayOutMultiBlockChange packetplayoutmultiblockchange = new PacketPlayOutMultiBlockChange(sectionposition, shortset, chunksection);
                    this.a(list, packetplayoutmultiblockchange);
                    List<EntityPlayer> finalList = list;
                    packetplayoutmultiblockchange.a((BlockPosition blockposition1, IBlockData iblockdata1) -> this.a(finalList, world, (BlockPosition)blockposition1, (IBlockData)iblockdata1));
                }
                this.r = false;
            }
        }
    }

    private void a(List<EntityPlayer> players, World world, BlockPosition pos, IBlockData state) {
        if (state.t()) {
            this.a(players, world, pos);
        }
    }

    private void a(List<EntityPlayer> players, World world, BlockPosition pos) {
        Packet<PacketListenerPlayOut> packet;
        TileEntity tileentity = world.c_(pos);
        if (tileentity != null && (packet = tileentity.h()) != null) {
            this.a(players, packet);
        }
    }

    public List<EntityPlayer> getPlayers(boolean onlyOnWatchDistanceEdge) {
        ArrayList<EntityPlayer> ret = new ArrayList<EntityPlayer>();
        int len = this.playersSentChunkTo.size();
        for (int i2 = 0; i2 < len; ++i2) {
            EntityPlayer player = this.playersSentChunkTo.getUnchecked(i2);
            if (onlyOnWatchDistanceEdge && !this.chunkMap.q.playerChunkLoader.isChunkSent(player, this.q.e, this.q.f, onlyOnWatchDistanceEdge)) continue;
            ret.add(player);
        }
        return ret;
    }

    public void broadcast(Packet<?> packet, boolean onlyOnWatchDistanceEdge) {
        this.a(this.getPlayers(onlyOnWatchDistanceEdge), packet);
    }

    private void a(List<EntityPlayer> players, Packet<?> packet) {
        players.forEach(entityplayer -> entityplayer.c.a(packet));
    }

    public FullChunkStatus i() {
        return this.newChunkHolder.getChunkStatus();
    }

    public final ChunkCoordIntPair j() {
        return this.q;
    }

    public final int k() {
        return this.newChunkHolder.getTicketLevel();
    }

    public void a(ProtoChunkExtension chunk) {
        throw new UnsupportedOperationException();
    }

    public List<Pair<ChunkStatus, CompletableFuture<Either<IChunkAccess, Failure>>>> o() {
        throw new UnsupportedOperationException();
    }

    public final boolean isEntityTickingReady() {
        return this.newChunkHolder.isEntityTickingReady();
    }

    public final boolean isTickingReady() {
        return this.newChunkHolder.isTickingReady();
    }

    public final boolean isFullChunkReady() {
        return this.newChunkHolder.isFullChunkReady();
    }

    @FunctionalInterface
    public static interface c {
        public void onLevelChange(ChunkCoordIntPair var1, IntSupplier var2, int var3, IntConsumer var4);
    }

    public static interface d {
        public List<EntityPlayer> a(ChunkCoordIntPair var1, boolean var2);
    }

    public static interface Failure {
        public static final Failure b = new Failure(){

            public String toString() {
                return "UNLOADED";
            }
        };
    }

    private static final class b {
        private final Thread a;
        private final CompletableFuture<?> b;
        private final String c;

        b(Thread thread, CompletableFuture<?> action, String actionDesc) {
            this.a = thread;
            this.b = action;
            this.c = actionDesc;
        }
    }
}

