/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import co.aikar.timings.Timing;
import com.destroystokyo.paper.util.misc.PlayerAreaMap;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Queues;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.papermc.paper.chunk.SingleThreadChunkRegionManager;
import io.papermc.paper.chunk.system.ChunkSystem;
import io.papermc.paper.chunk.system.io.RegionFileIOThread;
import io.papermc.paper.chunk.system.scheduling.NewChunkHolder;
import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.event.player.PlayerTrackEntityEvent;
import io.papermc.paper.event.player.PlayerUntrackEntityEvent;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.TickThread;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.mutable.MutableObject;
import org.bukkit.craftbukkit.v1_20_R1.generator.CustomChunkGenerator;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotWorldConfig;
import org.spigotmc.TrackingRange;

public class PlayerChunkMap
extends IChunkLoader
implements PlayerChunk.d {
    private static final byte e = -1;
    private static final byte f = 0;
    private static final byte g = 1;
    private static final Logger h = LogUtils.getLogger();
    private static final int i = 200;
    private static final int j = 20;
    private static final int k = 10000;
    private static final int l = 2;
    public static final int a = 32;
    public static final int b = ChunkLevel.a(FullChunkStatus.d);
    public final WorldServer q;
    private final LightEngineThreaded r;
    public final IAsyncTaskHandler<Runnable> s;
    public ChunkGenerator t;
    private final RandomState u;
    private final ChunkGeneratorStructureState v;
    public final Supplier<WorldPersistentData> w;
    private final VillagePlace x;
    private boolean z;
    public final WorldLoadListener D;
    private final ChunkStatusUpdateListener E;
    public final ChunkDistanceManager F;
    private final AtomicInteger G;
    public final StructureTemplateManager H;
    private final String I;
    private final PlayerMap J;
    public final Int2ObjectMap<EntityTracker> K;
    private final Long2ByteMap L;
    private final Long2LongMap M;
    private final Queue<Runnable> N;
    int O;
    public final PlayerAreaMap playerMobDistanceMap;
    public final ReferenceOpenHashSet<PlayerChunk> needsChangeBroadcasting = new ReferenceOpenHashSet();
    public static final int GENERAL_AREA_MAP_SQUARE_RADIUS = 40;
    public static final double GENERAL_AREA_MAP_ACCEPTABLE_SEARCH_RANGE = 624.0;
    public static final double GENERAL_AREA_MAP_ACCEPTABLE_SEARCH_RANGE_SQUARED = 389376.0;
    public final PlayerAreaMap playerGeneralAreaMap;
    private final PooledLinkedHashSets<EntityPlayer> pooledLinkedPlayerHashSets = new PooledLinkedHashSets();
    static final TrackingRange.TrackingRangeType[] TRACKING_RANGE_TYPES = TrackingRange.TrackingRangeType.values();
    public final PlayerAreaMap[] playerEntityTrackerTrackMaps;
    final int[] entityTrackerTrackRanges;
    public final PlayerAreaMap playerMobSpawnMap;
    public final PlayerAreaMap playerChunkTickRangeMap;
    public final List<SingleThreadChunkRegionManager> regionManagers = new ArrayList<SingleThreadChunkRegionManager>();
    public final SingleThreadChunkRegionManager dataRegionManager;

    public static boolean isLegacyTrackingEntity(net.minecraft.world.entity.Entity entity) {
        return entity.isLegacyTrackingEntity;
    }

    public final int getEntityTrackerRange(int ordinal) {
        return this.entityTrackerTrackRanges[ordinal];
    }

    private int convertSpigotRangeToVanilla(int vanilla) {
        return MinecraftServer.getServer().b(vanilla);
    }

    void addPlayerToDistanceMaps(EntityPlayer player) {
        this.q.playerChunkLoader.addPlayer(player);
        int chunkX = MCUtil.getChunkCoordinate(player.dn());
        int chunkZ = MCUtil.getChunkCoordinate(player.dt());
        this.playerChunkTickRangeMap.add(player, chunkX, chunkZ, 8);
        if (this.playerMobDistanceMap != null) {
            this.playerMobDistanceMap.add(player, chunkX, chunkZ, ChunkSystem.getTickViewDistance(player));
        }
        int len = TRACKING_RANGE_TYPES.length;
        for (int i2 = 0; i2 < len; ++i2) {
            PlayerAreaMap trackMap = this.playerEntityTrackerTrackMaps[i2];
            int trackRange = this.entityTrackerTrackRanges[i2];
            trackMap.add(player, chunkX, chunkZ, Math.min(trackRange, ChunkSystem.getSendViewDistance(player)));
        }
        this.playerGeneralAreaMap.add(player, chunkX, chunkZ, 40);
    }

    void removePlayerFromDistanceMaps(EntityPlayer player) {
        this.q.playerChunkLoader.removePlayer(player);
        this.playerMobSpawnMap.remove(player);
        this.playerChunkTickRangeMap.remove(player);
        this.playerGeneralAreaMap.remove(player);
        if (this.playerMobDistanceMap != null) {
            this.playerMobDistanceMap.remove(player);
        }
        int len = TRACKING_RANGE_TYPES.length;
        for (int i2 = 0; i2 < len; ++i2) {
            this.playerEntityTrackerTrackMaps[i2].remove(player);
        }
    }

    void updateMaps(EntityPlayer player) {
        int chunkX = MCUtil.getChunkCoordinate(player.dn());
        int chunkZ = MCUtil.getChunkCoordinate(player.dt());
        this.q.playerChunkLoader.updatePlayer(player);
        this.playerChunkTickRangeMap.update(player, chunkX, chunkZ, 8);
        if (this.playerMobDistanceMap != null) {
            this.playerMobDistanceMap.update(player, chunkX, chunkZ, ChunkSystem.getTickViewDistance(player));
        }
        int len = TRACKING_RANGE_TYPES.length;
        for (int i2 = 0; i2 < len; ++i2) {
            PlayerAreaMap trackMap = this.playerEntityTrackerTrackMaps[i2];
            int trackRange = this.entityTrackerTrackRanges[i2];
            trackMap.update(player, chunkX, chunkZ, Math.min(trackRange, ChunkSystem.getSendViewDistance(player)));
        }
        this.playerGeneralAreaMap.update(player, chunkX, chunkZ, 40);
    }

    public final PlayerChunk getUnloadingChunkHolder(int chunkX, int chunkZ) {
        return null;
    }

    public PlayerChunkMap(WorldServer world, Convertable.ConversionSession session, DataFixer dataFixer, StructureTemplateManager structureTemplateManager, Executor executor, IAsyncTaskHandler<Runnable> mainThreadExecutor, ILightAccess chunkProvider, ChunkGenerator chunkGenerator, WorldLoadListener worldGenerationProgressListener, ChunkStatusUpdateListener chunkStatusChangeListener, Supplier<WorldPersistentData> persistentStateManagerFactory, int viewDistance, boolean dsync) {
        super(session.a(world.ac()).resolve("region"), dataFixer, dsync);
        this.G = new AtomicInteger();
        this.J = new PlayerMap();
        this.K = new Int2ObjectOpenHashMap();
        this.L = new Long2ByteOpenHashMap();
        this.M = new Long2LongOpenHashMap();
        this.N = Queues.newConcurrentLinkedQueue();
        this.H = structureTemplateManager;
        Path path = session.a(world.ac());
        this.I = path.getFileName().toString();
        this.q = world;
        this.t = chunkGenerator;
        if (chunkGenerator instanceof CustomChunkGenerator) {
            chunkGenerator = ((CustomChunkGenerator)chunkGenerator).getDelegate();
        }
        IRegistryCustom iregistrycustom = world.B_();
        long j2 = world.A();
        if (chunkGenerator instanceof ChunkGeneratorAbstract) {
            ChunkGeneratorAbstract chunkgeneratorabstract = (ChunkGeneratorAbstract)chunkGenerator;
            this.u = RandomState.a(chunkgeneratorabstract.g().a(), iregistrycustom.b(Registries.ax), j2);
        } else {
            this.u = RandomState.a(GeneratorSettingBase.e(), iregistrycustom.b(Registries.ax), j2);
        }
        this.v = chunkGenerator.createState(iregistrycustom.b(Registries.aB), this.u, j2, world.spigotConfig);
        this.s = mainThreadExecutor;
        Objects.requireNonNull(mainThreadExecutor);
        this.D = worldGenerationProgressListener;
        this.E = chunkStatusChangeListener;
        this.r = new LightEngineThreaded(chunkProvider, this, this.q.x_().g(), null, null);
        this.F = new ChunkDistanceManager(executor, mainThreadExecutor);
        this.w = persistentStateManagerFactory;
        this.x = new VillagePlace(path.resolve("poi"), dataFixer, dsync, iregistrycustom, world);
        this.a(viewDistance);
        this.dataRegionManager = new SingleThreadChunkRegionManager(this.q, 2, 0.3333333333333333, 1, 6, "Data", DataRegionData::new, DataRegionSectionData::new);
        this.regionManagers.add(this.dataRegionManager);
        this.playerMobDistanceMap = this.q.paperConfig().entities.spawning.perPlayerMobSpawns ? new PlayerAreaMap(this.pooledLinkedPlayerHashSets) : null;
        this.playerEntityTrackerTrackMaps = new PlayerAreaMap[TRACKING_RANGE_TYPES.length];
        this.entityTrackerTrackRanges = new int[TRACKING_RANGE_TYPES.length];
        SpigotWorldConfig spigotWorldConfig = this.q.spigotConfig;
        for (TrackingRange.TrackingRangeType trackingRangeType : TRACKING_RANGE_TYPES) {
            int trackRange;
            int configuredSpigotValue = switch (trackingRangeType) {
                case TrackingRange.TrackingRangeType.PLAYER -> spigotWorldConfig.playerTrackingRange;
                case TrackingRange.TrackingRangeType.ANIMAL -> spigotWorldConfig.animalTrackingRange;
                case TrackingRange.TrackingRangeType.MONSTER -> spigotWorldConfig.monsterTrackingRange;
                case TrackingRange.TrackingRangeType.MISC -> spigotWorldConfig.miscTrackingRange;
                case TrackingRange.TrackingRangeType.OTHER -> spigotWorldConfig.otherTrackingRange;
                case TrackingRange.TrackingRangeType.ENDERDRAGON -> EntityTypes.C.o() * 16;
                case TrackingRange.TrackingRangeType.DISPLAY -> spigotWorldConfig.displayTrackingRange;
                default -> throw new IllegalStateException("Missing case for enum " + trackingRangeType);
            };
            configuredSpigotValue = this.convertSpigotRangeToVanilla(configuredSpigotValue);
            this.entityTrackerTrackRanges[ordinal] = trackRange = (configuredSpigotValue >>> 4) + ((configuredSpigotValue & 0xF) != 0 ? 1 : 0);
            this.playerEntityTrackerTrackMaps[ordinal] = new PlayerAreaMap(this.pooledLinkedPlayerHashSets);
        }
        this.playerChunkTickRangeMap = new PlayerAreaMap(this.pooledLinkedPlayerHashSets, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            PlayerChunk playerChunk = this.a(MCUtil.getCoordinateKey(rangeX, rangeZ));
            if (playerChunk != null) {
                playerChunk.playersInChunkTickRange = newState;
            }
        }, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            PlayerChunk playerChunk = this.a(MCUtil.getCoordinateKey(rangeX, rangeZ));
            if (playerChunk != null) {
                playerChunk.playersInChunkTickRange = newState;
            }
        });
        this.playerMobSpawnMap = new PlayerAreaMap(this.pooledLinkedPlayerHashSets, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            PlayerChunk playerChunk = this.a(MCUtil.getCoordinateKey(rangeX, rangeZ));
            if (playerChunk != null) {
                playerChunk.playersInMobSpawnRange = newState;
            }
        }, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            PlayerChunk playerChunk = this.a(MCUtil.getCoordinateKey(rangeX, rangeZ));
            if (playerChunk != null) {
                playerChunk.playersInMobSpawnRange = newState;
            }
        });
        this.playerGeneralAreaMap = new PlayerAreaMap(this.pooledLinkedPlayerHashSets, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            Chunk chunk = this.q.k().getChunkAtIfCachedImmediately(rangeX, rangeZ);
            if (chunk != null) {
                chunk.updateGeneralAreaCache(newState);
            }
        }, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            Chunk chunk = this.q.k().getChunkAtIfCachedImmediately(rangeX, rangeZ);
            if (chunk != null) {
                chunk.updateGeneralAreaCache(newState);
            }
        });
    }

    protected ChunkGenerator a() {
        return this.t;
    }

    protected ChunkGeneratorStructureState b() {
        return this.v;
    }

    protected RandomState c() {
        return this.u;
    }

    public void d() {
        DataResult dataresult = ChunkGenerator.a.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.t);
        DataResult dataresult1 = dataresult.flatMap(jsonelement -> ChunkGenerator.a.parse((DynamicOps)JsonOps.INSTANCE, jsonelement));
        dataresult1.result().ifPresent(chunkgenerator -> {
            this.t = chunkgenerator;
        });
    }

    public void updatePlayerMobTypeMap(net.minecraft.world.entity.Entity entity) {
        if (!this.q.paperConfig().entities.spawning.perPlayerMobSpawns) {
            return;
        }
        int index = entity.ae().f().ordinal();
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet inRange = this.playerMobDistanceMap.getObjectsInRange(entity.dk());
        if (inRange == null) {
            return;
        }
        E[] backingSet = inRange.getBackingSet();
        for (int i2 = 0; i2 < backingSet.length; ++i2) {
            Object e2 = backingSet[i2];
            if (!(e2 instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)e2;
            int n2 = index;
            player.mobCounts[n2] = player.mobCounts[n2] + 1;
        }
    }

    public void updateFailurePlayerMobTypeMap(int chunkX, int chunkZ, EnumCreatureType mobCategory) {
        if (!this.q.paperConfig().entities.spawning.perPlayerMobSpawns) {
            return;
        }
        int idx = mobCategory.ordinal();
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet inRange = this.playerMobDistanceMap.getObjectsInRange(chunkX, chunkZ);
        if (inRange != null) {
            E[] set = inRange.getBackingSet();
            for (int i2 = 0; i2 < set.length; ++i2) {
                Object e2 = set[i2];
                if (!(e2 instanceof EntityPlayer)) continue;
                EntityPlayer serverPlayer = (EntityPlayer)e2;
                int n2 = idx;
                serverPlayer.mobBackoffCounts[n2] = serverPlayer.mobBackoffCounts[n2] + 1;
            }
        }
    }

    public int getMobCountNear(EntityPlayer entityPlayer, EnumCreatureType mobCategory) {
        return entityPlayer.mobCounts[mobCategory.ordinal()] + entityPlayer.mobBackoffCounts[mobCategory.ordinal()];
    }

    private static double a(ChunkCoordIntPair pos, net.minecraft.world.entity.Entity entity) {
        double d0 = SectionPosition.a(pos.e, 8);
        double d1 = SectionPosition.a(pos.f, 8);
        double d2 = d0 - entity.dn();
        double d3 = d1 - entity.dt();
        return d2 * d2 + d3 * d3;
    }

    public static boolean a(int x1, int z1, int x2, int z2, int distance) {
        int k2;
        int j1 = Math.max(0, Math.abs(x1 - x2) - 1);
        int k1 = Math.max(0, Math.abs(z1 - z2) - 1);
        long l1 = Math.max(0, Math.max(j1, k1) - 1);
        long i2 = Math.min(j1, k1);
        long j2 = i2 * i2 + l1 * l1;
        return j2 < (long)(k2 = distance * distance);
    }

    private static boolean b(int x1, int z1, int x2, int z2, int distance) {
        return !PlayerChunkMap.a(x1, z1, x2, z2, distance) ? false : !PlayerChunkMap.a(x1 + 1, z1 + 1, x2, z2, distance) || !PlayerChunkMap.a(x1 - 1, z1 + 1, x2, z2, distance) || !PlayerChunkMap.a(x1 + 1, z1 - 1, x2, z2, distance) || !PlayerChunkMap.a(x1 - 1, z1 - 1, x2, z2, distance);
    }

    protected LightEngineThreaded e() {
        return this.r;
    }

    @Nullable
    protected PlayerChunk a(long pos) {
        NewChunkHolder holder = this.q.chunkTaskScheduler.chunkHolderManager.getChunkHolder(pos);
        return holder == null ? null : holder.vanillaChunkHolder;
    }

    @Nullable
    public PlayerChunk b(long pos) {
        NewChunkHolder holder = this.q.chunkTaskScheduler.chunkHolderManager.getChunkHolder(pos);
        return holder == null ? null : holder.vanillaChunkHolder;
    }

    protected IntSupplier c(long pos) {
        throw new UnsupportedOperationException();
    }

    public String a(ChunkCoordIntPair chunkPos) {
        PlayerChunk playerchunk = this.b(chunkPos.a());
        if (playerchunk == null) {
            return "null";
        }
        String s2 = playerchunk.k() + "\n";
        ChunkStatus chunkstatus = playerchunk.f();
        IChunkAccess ichunkaccess = playerchunk.g();
        if (chunkstatus != null) {
            s2 = s2 + "St: \u00a7" + chunkstatus.c() + chunkstatus + "\u00a7r\n";
        }
        if (ichunkaccess != null) {
            s2 = s2 + "Ch: \u00a7" + ichunkaccess.j().c() + ichunkaccess.j() + "\u00a7r\n";
        }
        FullChunkStatus fullchunkstatus = playerchunk.i();
        s2 = s2 + "\u00a7" + fullchunkstatus.ordinal() + fullchunkstatus;
        return s2 + "\u00a7r";
    }

    public final int getEffectiveViewDistance() {
        return this.O;
    }

    private CompletableFuture<Either<List<IChunkAccess>, PlayerChunk.Failure>> a(PlayerChunk centerChunk, int margin, IntFunction<ChunkStatus> distanceToStatus) {
        throw new UnsupportedOperationException();
    }

    public ReportedException a(IllegalStateException exception, String details) {
        StringBuilder stringbuilder = new StringBuilder();
        Consumer<PlayerChunk> consumer = playerchunk -> playerchunk.o().forEach(pair -> {
            ChunkStatus chunkstatus = (ChunkStatus)pair.getFirst();
            CompletableFuture completablefuture = (CompletableFuture)pair.getSecond();
            if (completablefuture != null && completablefuture.isDone() && completablefuture.join() == null) {
                stringbuilder.append(playerchunk.j()).append(" - status: ").append(chunkstatus).append(" future: ").append(completablefuture).append(System.lineSeparator());
            }
        });
        stringbuilder.append("Updating:").append(System.lineSeparator());
        ChunkSystem.getUpdatingChunkHolders(this.q).forEach(consumer);
        stringbuilder.append("Visible:").append(System.lineSeparator());
        ChunkSystem.getVisibleChunkHolders(this.q).forEach(consumer);
        CrashReport crashreport = CrashReport.a(exception, "Chunk loading");
        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk loading");
        crashreportsystemdetails.a("Details", details);
        crashreportsystemdetails.a("Futures", stringbuilder);
        return new ReportedException(crashreport);
    }

    public CompletableFuture<Either<Chunk, PlayerChunk.Failure>> a(PlayerChunk chunk) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    PlayerChunk a(long pos, int level, @Nullable PlayerChunk holder, int k2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("Use ServerChunkCache#close");
    }

    protected void saveIncrementally() {
        this.q.chunkTaskScheduler.chunkHolderManager.autoSave();
    }

    protected void a(boolean flush) {
        this.q.chunkTaskScheduler.chunkHolderManager.saveAllChunks(flush, false, false);
    }

    protected void a(BooleanSupplier shouldKeepTicking) {
        GameProfilerFiller gameprofilerfiller = this.q.ad();
        try (Timing ignored = this.q.timings.poiUnload.startTiming();){
            gameprofilerfiller.a("poi");
            this.x.a(shouldKeepTicking);
        }
        gameprofilerfiller.b("chunk_unload");
        if (!this.q.r()) {
            ignored = this.q.timings.chunkUnload.startTiming();
            try {
                this.b(shouldKeepTicking);
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
        gameprofilerfiller.c();
    }

    public boolean f() {
        throw new UnsupportedOperationException();
    }

    private void b(BooleanSupplier shouldKeepTicking) {
        this.q.chunkTaskScheduler.chunkHolderManager.processUnloads();
    }

    private void a(long pos, PlayerChunk holder) {
        throw new UnsupportedOperationException();
    }

    protected boolean g() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> a(PlayerChunk holder, ChunkStatus requiredStatus) {
        throw new UnsupportedOperationException();
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> f(ChunkCoordIntPair pos) {
        throw new UnsupportedOperationException();
    }

    public static boolean b(NBTTagCompound nbt) {
        return nbt.b("Status", 8);
    }

    private Either<IChunkAccess, PlayerChunk.Failure> a(Throwable throwable, ChunkCoordIntPair chunkPos) {
        if (throwable instanceof ReportedException) {
            ReportedException reportedexception = (ReportedException)throwable;
            Throwable throwable1 = reportedexception.getCause();
            if (!(throwable1 instanceof IOException)) {
                this.h(chunkPos);
                throw reportedexception;
            }
            h.error("Couldn't load chunk {}", (Object)chunkPos, (Object)throwable1);
        } else if (throwable instanceof IOException) {
            h.error("Couldn't load chunk {}", (Object)chunkPos, (Object)throwable);
        }
        return Either.left(this.g(chunkPos));
    }

    private IChunkAccess g(ChunkCoordIntPair chunkPos) {
        this.h(chunkPos);
        return new ProtoChunk(chunkPos, ChunkConverter.a, this.q, this.q.B_().d(Registries.ap), null);
    }

    private void h(ChunkCoordIntPair pos) {
        this.L.put(pos.a(), (byte)-1);
    }

    private byte a(ChunkCoordIntPair pos, ChunkStatus.Type type) {
        return this.L.put(pos.a(), (byte)(type == ChunkStatus.Type.a ? -1 : 1));
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> b(PlayerChunk holder, ChunkStatus requiredStatus) {
        throw new UnsupportedOperationException();
    }

    protected void b(ChunkCoordIntPair pos) {
        this.s.i(SystemUtils.a(() -> this.F.b(TicketType.e, pos, ChunkLevel.a(ChunkStatus.l), pos), () -> "release light ticket " + pos));
    }

    public static ChunkStatus a(ChunkStatus centerChunkTargetStatus, int distance) {
        ChunkStatus chunkstatus1 = distance == 0 ? centerChunkTargetStatus.d() : ChunkStatus.a(ChunkStatus.a(centerChunkTargetStatus) + distance);
        return chunkstatus1;
    }

    public static void a(WorldServer world, List<NBTTagCompound> nbt) {
        if (!nbt.isEmpty()) {
            world.b(EntityTypes.a(nbt, (World)world).filter(entity -> {
                boolean needsRemoval = false;
                DedicatedServer server = world.getCraftServer().getServer();
                if (!server.X() && entity instanceof NPC) {
                    entity.ai();
                    needsRemoval = true;
                }
                if (!server.W() && (entity instanceof EntityAnimal || entity instanceof EntityWaterAnimal)) {
                    entity.ai();
                    needsRemoval = true;
                }
                PlayerChunkMap.checkDupeUUID(world, entity);
                return !needsRemoval;
            }));
        }
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> d(PlayerChunk chunkHolder) {
        throw new UnsupportedOperationException();
    }

    public static boolean checkDupeUUID(WorldServer level, net.minecraft.world.entity.Entity entity) {
        WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode mode = level.paperConfig().entities.spawning.duplicateUuid.mode;
        if (mode != WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.WARN && mode != WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.DELETE && mode != WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.SAFE_REGEN) {
            return false;
        }
        net.minecraft.world.entity.Entity other = level.a(entity.ct());
        if (other == null || other == entity) {
            return false;
        }
        if (mode == WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.SAFE_REGEN && other != null && !other.dD() && Objects.equals(other.br(), entity.br()) && entity.getBukkitEntity().getLocation().distance(other.getBukkitEntity().getLocation()) < (double)level.paperConfig().entities.spawning.duplicateUuid.safeRegenDeleteRange) {
            if (World.DEBUG_ENTITIES) {
                h.warn("[DUPE-UUID] Duplicate UUID found used by " + other + ", deleted entity " + entity + " because it was near the duplicate and likely an actual duplicate. See https://github.com/PaperMC/Paper/issues/1223 for discussion on what this is about.");
            }
            entity.ai();
            return true;
        }
        if (other != null && !other.dD()) {
            switch (mode) {
                case SAFE_REGEN: {
                    entity.a_(UUID.randomUUID());
                    if (!World.DEBUG_ENTITIES) break;
                    h.warn("[DUPE-UUID] Duplicate UUID found used by " + other + ", regenerated UUID for " + entity + ". See https://github.com/PaperMC/Paper/issues/1223 for discussion on what this is about.");
                    break;
                }
                case DELETE: {
                    if (World.DEBUG_ENTITIES) {
                        h.warn("[DUPE-UUID] Duplicate UUID found used by " + other + ", deleted entity " + entity + ". See https://github.com/PaperMC/Paper/issues/1223 for discussion on what this is about.");
                    }
                    entity.ai();
                    return true;
                }
                default: {
                    if (!World.DEBUG_ENTITIES) break;
                    h.warn("[DUPE-UUID] Duplicate UUID found used by " + other + ", doing nothing to " + entity + ". See https://github.com/PaperMC/Paper/issues/1223 for discussion on what this is about.");
                }
            }
        }
        return false;
    }

    public CompletableFuture<Either<Chunk, PlayerChunk.Failure>> b(PlayerChunk holder) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Either<Chunk, PlayerChunk.Failure>> c(PlayerChunk holder) {
        throw new UnsupportedOperationException();
    }

    public int h() {
        return this.G.get();
    }

    private boolean e(PlayerChunk chunkHolder) {
        throw new UnsupportedOperationException();
    }

    public boolean a(IChunkAccess chunk) {
        throw new UnsupportedOperationException();
    }

    private boolean i(ChunkCoordIntPair pos) {
        throw new UnsupportedOperationException();
    }

    public void setTickViewDistance(int distance) {
        this.q.playerChunkLoader.setTickDistance(distance);
    }

    public void setSendViewDistance(int distance) {
        this.q.playerChunkLoader.setSendDistance(distance);
    }

    public void a(int watchDistance) {
        int j2 = MathHelper.a(watchDistance, 2, 32);
        if (j2 != this.O) {
            int k2 = this.O;
            this.O = j2;
            this.q.playerChunkLoader.setLoadDistance(this.O + 1);
        }
    }

    public void a(EntityPlayer player, ChunkCoordIntPair pos, MutableObject<Map<Object, ClientboundLevelChunkWithLightPacket>> packet, boolean oldWithinViewDistance, boolean newWithinViewDistance) {
        TickThread.ensureTickThread(this.q, pos, "May not update chunk tracking for chunk async");
        TickThread.ensureTickThread(player, "May not update chunk tracking for player async");
        if (player.dI() == this.q) {
            PlayerChunk playerchunk = this.b(pos.a());
            if (newWithinViewDistance && !oldWithinViewDistance && playerchunk != null) {
                Chunk chunk = playerchunk.getSendingChunk();
                if (chunk != null) {
                    playerchunk.addPlayer(player);
                    this.a(player, packet, chunk);
                }
                PacketDebug.a(this.q, pos);
            }
            if (!newWithinViewDistance && oldWithinViewDistance) {
                if (playerchunk != null) {
                    playerchunk.removePlayer(player);
                } else {
                    h.warn("ChunkHolder at " + pos + " in world '" + this.q.getWorld().getName() + "' does not exist to untrack chunk for " + player, new Throwable());
                }
                player.a(pos);
            }
        } else {
            h.warn("Mismatch in world for chunk " + pos + " in world '" + this.q.getWorld().getName() + "' for player " + player, new Throwable());
        }
    }

    public int i() {
        return ChunkSystem.getVisibleChunkHolderCount(this.q);
    }

    public ChunkMapDistance j() {
        return this.F;
    }

    protected Iterable<PlayerChunk> k() {
        return Iterables.unmodifiableIterable(ChunkSystem.getVisibleChunkHolders(this.q));
    }

    void a(Writer writer) throws IOException {
        throw new UnsupportedOperationException();
    }

    private static String a(CompletableFuture<Either<Chunk, PlayerChunk.Failure>> future) {
        try {
            Either either = future.getNow(null);
            return either != null ? either.map(chunk -> "done", playerchunk_failure -> "unloaded") : "not completed";
        }
        catch (CompletionException completionexception) {
            return "failed " + completionexception.getCause().getMessage();
        }
        catch (CancellationException cancellationexception) {
            return "cancelled";
        }
    }

    @Override
    @Nullable
    public NBTTagCompound readSync(ChunkCoordIntPair chunkcoordintpair) throws IOException {
        if (!RegionFileIOThread.isRegionFileThread()) {
            return RegionFileIOThread.loadData(this.q, chunkcoordintpair.e, chunkcoordintpair.f, RegionFileIOThread.RegionFileType.CHUNK_DATA, RegionFileIOThread.getIOBlockingPriorityForCurrentThread());
        }
        return super.readSync(chunkcoordintpair);
    }

    @Override
    public void a(ChunkCoordIntPair chunkcoordintpair, NBTTagCompound nbttagcompound) throws IOException {
        if (!RegionFileIOThread.isRegionFileThread()) {
            RegionFileIOThread.scheduleSave(this.q, chunkcoordintpair.e, chunkcoordintpair.f, nbttagcompound, RegionFileIOThread.RegionFileType.CHUNK_DATA);
            return;
        }
        super.a(chunkcoordintpair, nbttagcompound);
    }

    private CompletableFuture<Optional<NBTTagCompound>> j(ChunkCoordIntPair chunkPos) {
        try {
            return CompletableFuture.completedFuture(Optional.ofNullable(this.readConvertChunkSync(chunkPos)));
        }
        catch (Throwable thr) {
            return CompletableFuture.failedFuture(thr);
        }
    }

    private NBTTagCompound upgradeChunkTag(NBTTagCompound nbttagcompound, ChunkCoordIntPair chunkcoordintpair) {
        return this.upgradeChunkTag(this.q.getTypeKey(), this.w, nbttagcompound, this.t.b(), chunkcoordintpair, this.q);
    }

    @Nullable
    public NBTTagCompound readConvertChunkSync(ChunkCoordIntPair pos) throws IOException {
        NBTTagCompound nbttagcompound = this.readSync(pos);
        if (nbttagcompound == null) {
            return null;
        }
        if ((nbttagcompound = this.upgradeChunkTag(nbttagcompound, pos)) == null) {
            return null;
        }
        this.updateChunkStatusOnDisk(pos, nbttagcompound);
        return nbttagcompound;
    }

    public ChunkStatus getChunkStatusOnDiskIfCached(ChunkCoordIntPair chunkPos) {
        RegionFile regionFile = this.regionFileCache.getRegionFileIfLoaded(chunkPos);
        return regionFile == null ? null : regionFile.getStatusIfCached(chunkPos.e, chunkPos.f);
    }

    public ChunkStatus getChunkStatusOnDisk(ChunkCoordIntPair chunkPos) throws IOException {
        RegionFile regionFile = this.regionFileCache.getRegionFile(chunkPos, true);
        if (regionFile == null || !this.regionFileCache.chunkExists(chunkPos)) {
            return null;
        }
        ChunkStatus status = regionFile.getStatusIfCached(chunkPos.e, chunkPos.f);
        if (status != null) {
            return status;
        }
        this.j(chunkPos);
        return regionFile.getStatusIfCached(chunkPos.e, chunkPos.f);
    }

    public void updateChunkStatusOnDisk(ChunkCoordIntPair chunkPos, @Nullable NBTTagCompound compound) throws IOException {
        RegionFile regionFile = this.regionFileCache.getRegionFile(chunkPos, false);
        regionFile.setStatus(chunkPos.e, chunkPos.f, ChunkRegionLoader.getStatus(compound));
    }

    public IChunkAccess getUnloadingChunk(int chunkX, int chunkZ) {
        PlayerChunk chunkHolder = ChunkSystem.getUnloadingChunkHolder(this.q, chunkX, chunkZ);
        return chunkHolder == null ? null : chunkHolder.getAvailableChunkNow();
    }

    public boolean c(ChunkCoordIntPair pos) {
        return this.anyPlayerCloseEnoughForSpawning(pos, false);
    }

    final boolean anyPlayerCloseEnoughForSpawning(ChunkCoordIntPair chunkcoordintpair, boolean reducedRange) {
        return this.anyPlayerCloseEnoughForSpawning(this.a(chunkcoordintpair.a()), chunkcoordintpair, reducedRange);
    }

    final boolean anyPlayerCloseEnoughForSpawning(PlayerChunk playerchunk, ChunkCoordIntPair chunkcoordintpair, boolean reducedRange) {
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> playersInRange;
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> pooledObjectLinkedOpenHashSet = playersInRange = reducedRange ? playerchunk.playersInMobSpawnRange : playerchunk.playersInChunkTickRange;
        if (playersInRange == null) {
            return false;
        }
        EntityPlayer[] backingSet = playersInRange.getBackingSet();
        if (reducedRange) {
            for (EntityPlayer raw : backingSet) {
                EntityPlayer player;
                if (!(raw instanceof EntityPlayer) || !(PlayerChunkMap.a(chunkcoordintpair, player = raw) < player.lastEntitySpawnRadiusSquared)) continue;
                return true;
            }
        } else {
            double range = 16384.0;
            for (EntityPlayer raw : backingSet) {
                EntityPlayer player;
                if (!(raw instanceof EntityPlayer) || !(PlayerChunkMap.a(chunkcoordintpair, player = raw) < 16384.0)) continue;
                return true;
            }
        }
        return false;
    }

    public List<EntityPlayer> d(ChunkCoordIntPair pos) {
        long i2 = pos.a();
        if (!this.F.f(i2)) {
            return List.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EntityPlayer entityplayer : this.J.a(i2)) {
            if (!this.playerIsCloseEnoughForSpawning(entityplayer, pos, 16384.0)) continue;
            builder.add((Object)entityplayer);
        }
        return builder.build();
    }

    private boolean playerIsCloseEnoughForSpawning(EntityPlayer entityplayer, ChunkCoordIntPair chunkcoordintpair, double range) {
        if (entityplayer.G_()) {
            return false;
        }
        double d0 = PlayerChunkMap.a(chunkcoordintpair, entityplayer);
        return d0 < range;
    }

    private boolean b(EntityPlayer player) {
        return player.G_() && !this.q.X().b(GameRules.q);
    }

    void a(EntityPlayer player, boolean added) {
        boolean flag1 = this.b(player);
        boolean flag2 = this.J.c(player);
        int i2 = SectionPosition.a(player.dm());
        int j2 = SectionPosition.a(player.ds());
        if (added) {
            this.J.a(ChunkCoordIntPair.c(i2, j2), player, flag1);
            this.c(player);
            if (!flag1) {
                this.F.a(SectionPosition.a(player), player);
            }
            this.addPlayerToDistanceMaps(player);
        } else {
            SectionPosition sectionposition = player.R();
            this.J.a(sectionposition.r().a(), player);
            if (!flag2) {
                this.F.b(sectionposition, player);
            }
            this.removePlayerFromDistanceMaps(player);
        }
    }

    private SectionPosition c(EntityPlayer player) {
        SectionPosition sectionposition = SectionPosition.a(player);
        player.a(sectionposition);
        return sectionposition;
    }

    public void a(EntityPlayer player) {
        boolean flag2;
        int i2 = SectionPosition.a(player.dm());
        int j2 = SectionPosition.a(player.ds());
        SectionPosition sectionposition = player.R();
        SectionPosition sectionposition1 = SectionPosition.a(player);
        long k2 = sectionposition.r().a();
        long l2 = sectionposition1.r().a();
        boolean flag = this.J.d(player);
        boolean flag1 = this.b(player);
        boolean bl = flag2 = sectionposition.s() != sectionposition1.s();
        if (flag2 || flag != flag1) {
            this.c(player);
            if (!flag) {
                this.F.b(sectionposition, player);
            }
            if (!flag1) {
                this.F.a(sectionposition1, player);
            }
            if (!flag && flag1) {
                this.J.a(player);
            }
            if (flag && !flag1) {
                this.J.b(player);
            }
            if (k2 != l2) {
                this.J.a(k2, l2, player);
            }
        }
        int i1 = sectionposition.a();
        int j1 = sectionposition.c();
        int k1 = this.O + 1;
        this.updateMaps(player);
    }

    @Override
    public List<EntityPlayer> a(ChunkCoordIntPair chunkPos, boolean onlyOnWatchDistanceEdge) {
        PlayerChunk holder = this.b(chunkPos.a());
        if (holder == null) {
            return new ArrayList<EntityPlayer>();
        }
        return holder.getPlayers(onlyOnWatchDistanceEdge);
    }

    public void a(net.minecraft.world.entity.Entity entity) {
        AsyncCatcher.catchOp("entity track");
        if (!entity.valid || entity.dI() != this.q || this.K.containsKey(entity.af())) {
            h.error("Illegal ChunkMap::addEntity for world " + this.q.getWorld().getName() + ": " + entity + (this.K.containsKey(entity.af()) ? " ALREADY CONTAINED (This would have crashed your server)" : ""), new Throwable());
            return;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).supressTrackerForLogin) {
            return;
        }
        if (!(entity instanceof EntityComplexPart)) {
            EntityTypes<?> entitytypes = entity.ae();
            int i2 = entitytypes.o() * 16;
            if ((i2 = TrackingRange.getEntityTrackingRange(entity, i2)) != 0) {
                EntityTracker playerchunkmap_entitytracker;
                int j2 = entitytypes.p();
                if (this.K.containsKey(entity.af())) {
                    throw SystemUtils.b(new IllegalStateException("Entity is already tracked!"));
                }
                entity.tracker = playerchunkmap_entitytracker = new EntityTracker(entity, i2, j2, entitytypes.q());
                this.K.put(entity.af(), (Object)playerchunkmap_entitytracker);
                playerchunkmap_entitytracker.updatePlayers(entity.getPlayersInTrackRange());
                if (entity instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entity;
                    this.a(entityplayer, true);
                    for (EntityTracker playerchunkmap_entitytracker1 : this.K.values()) {
                        if (playerchunkmap_entitytracker1.c == entityplayer) continue;
                        playerchunkmap_entitytracker1.b(entityplayer);
                    }
                }
            }
        }
    }

    protected void b(net.minecraft.world.entity.Entity entity) {
        EntityTracker playerchunkmap_entitytracker1;
        AsyncCatcher.catchOp("entity untrack");
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            this.a(entityplayer, false);
            for (EntityTracker playerchunkmap_entitytracker : this.K.values()) {
                playerchunkmap_entitytracker.a(entityplayer);
            }
        }
        if ((playerchunkmap_entitytracker1 = (EntityTracker)this.K.remove(entity.af())) != null) {
            playerchunkmap_entitytracker1.a();
        }
        entity.tracker = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processTrackQueue() {
        this.q.timings.tracker1.startTiming();
        try {
            for (EntityTracker tracker : this.K.values()) {
                tracker.updatePlayers(tracker.c.getPlayersInTrackRange());
            }
        }
        finally {
            this.q.timings.tracker1.stopTiming();
        }
        this.q.timings.tracker2.startTiming();
        try {
            for (EntityTracker tracker : this.K.values()) {
                tracker.b.a();
            }
        }
        finally {
            this.q.timings.tracker2.stopTiming();
        }
    }

    protected void l() {
        this.processTrackQueue();
    }

    public void a(net.minecraft.world.entity.Entity entity, Packet<?> packet) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.K.get(entity.af());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.a(packet);
        }
    }

    protected void b(net.minecraft.world.entity.Entity entity, Packet<?> packet) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.K.get(entity.af());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.b(packet);
        }
    }

    public void a(List<IChunkAccess> chunks) {
        HashMap<EntityPlayer, List> map = new HashMap<EntityPlayer, List>();
        for (IChunkAccess ichunkaccess : chunks) {
            Chunk chunk1;
            ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
            Chunk chunk = ichunkaccess instanceof Chunk ? (chunk1 = (Chunk)ichunkaccess) : this.q.d(chunkcoordintpair.e, chunkcoordintpair.f);
            for (EntityPlayer entityplayer : this.a(chunkcoordintpair, false)) {
                map.computeIfAbsent(entityplayer, entityplayer1 -> new ArrayList()).add(chunk);
            }
        }
        map.forEach((entityplayer1, list1) -> entityplayer1.c.a(ClientboundChunksBiomesPacket.a(list1)));
    }

    private void a(EntityPlayer player, MutableObject<Map<Object, ClientboundLevelChunkWithLightPacket>> cachedDataPackets, Chunk chunk) {
        if (cachedDataPackets.getValue() == null) {
            cachedDataPackets.setValue(new HashMap());
        }
        Boolean shouldModify = chunk.F().chunkPacketBlockController.shouldModify(player, chunk);
        player.a(chunk.f(), ((Map)cachedDataPackets.getValue()).computeIfAbsent(shouldModify, s2 -> new ClientboundLevelChunkWithLightPacket(chunk, this.r, null, null, (Boolean)s2)));
        PacketDebug.a(this.q, chunk.f());
    }

    public VillagePlace m() {
        return this.x;
    }

    public String n() {
        return this.I;
    }

    void a(ChunkCoordIntPair chunkPos, FullChunkStatus levelType) {
        this.E.onChunkStatusChange(chunkPos, levelType);
    }

    private class ChunkDistanceManager
    extends ChunkMapDistance {
        protected ChunkDistanceManager(Executor workerExecutor, Executor mainThreadExecutor) {
            super(workerExecutor, mainThreadExecutor, PlayerChunkMap.this);
        }

        @Override
        protected boolean a(long pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        protected PlayerChunk b(long pos) {
            return PlayerChunkMap.this.a(pos);
        }

        @Override
        @Nullable
        protected PlayerChunk a(long pos, int level, @Nullable PlayerChunk holder, int k2) {
            return PlayerChunkMap.this.a(pos, level, holder, k2);
        }
    }

    public class EntityTracker {
        public final EntityTrackerEntry b;
        final net.minecraft.world.entity.Entity c;
        private final int d;
        SectionPosition e;
        public final Set<ServerPlayerConnection> f = new ReferenceOpenHashSet();
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> lastTrackerCandidates;

        public EntityTracker(net.minecraft.world.entity.Entity entity, int i2, int j2, boolean flag) {
            this.b = new EntityTrackerEntry(PlayerChunkMap.this.q, entity, j2, flag, this::a, this.f);
            this.c = entity;
            this.d = i2;
            this.e = SectionPosition.a(entity);
        }

        final void updatePlayers(PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> newTrackerCandidates) {
            PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> oldTrackerCandidates = this.lastTrackerCandidates;
            this.lastTrackerCandidates = newTrackerCandidates;
            if (newTrackerCandidates != null) {
                for (EntityPlayer raw : newTrackerCandidates.getBackingSet()) {
                    if (!(raw instanceof EntityPlayer)) continue;
                    EntityPlayer player = raw;
                    this.b(player);
                }
            }
            if (oldTrackerCandidates == newTrackerCandidates) {
                return;
            }
            for (ServerPlayerConnection conn : this.f.toArray(new ServerPlayerConnection[0])) {
                if (newTrackerCandidates != null && newTrackerCandidates.contains(conn.f())) continue;
                this.b(conn.f());
            }
        }

        public boolean equals(Object object) {
            return object instanceof EntityTracker ? ((EntityTracker)object).c.af() == this.c.af() : false;
        }

        public int hashCode() {
            return this.c.af();
        }

        public void a(Packet<?> packet) {
            for (ServerPlayerConnection serverplayerconnection : this.f) {
                serverplayerconnection.a(packet);
            }
        }

        public void b(Packet<?> packet) {
            this.a(packet);
            if (this.c instanceof EntityPlayer) {
                ((EntityPlayer)this.c).c.a(packet);
            }
        }

        public void a() {
            for (ServerPlayerConnection serverplayerconnection : this.f) {
                this.b.a(serverplayerconnection.f());
            }
        }

        public void a(EntityPlayer player) {
            AsyncCatcher.catchOp("player tracker clear");
            if (this.f.remove(player.c)) {
                this.b.a(player);
            }
        }

        public void b(EntityPlayer player) {
            AsyncCatcher.catchOp("player tracker update");
            if (player != this.c) {
                double rangeY;
                boolean flag;
                double vec3d_dx = player.dn() - this.c.dn();
                double vec3d_dz = player.dt() - this.c.dt();
                Vec3D vec3d = player.dg().d(this.c.dg());
                double d1 = vec3d_dx * vec3d_dx + vec3d_dz * vec3d_dz;
                double d0 = Math.min(this.b(), ChunkSystem.getSendViewDistance(player) * 16);
                double d2 = d0 * d0;
                boolean bl = flag = d1 <= d2 && this.c.a(player);
                if (flag && PlayerChunkMap.this.q.paperConfig().entities.trackingRangeY.enabled && (rangeY = (double)PlayerChunkMap.this.q.paperConfig().entities.trackingRangeY.get(this.c, -1)) != -1.0) {
                    double vec3d_dy = player.dp() - this.c.dp();
                    boolean bl2 = flag = vec3d_dy * vec3d_dy <= rangeY * rangeY;
                }
                if (!player.getBukkitEntity().canSee(this.c.getBukkitEntity())) {
                    flag = false;
                }
                if (flag) {
                    if (this.f.add(player.c) && (PlayerTrackEntityEvent.getHandlerList().getRegisteredListeners().length == 0 || new PlayerTrackEntityEvent((Player)player.getBukkitEntity(), (Entity)this.c.getBukkitEntity()).callEvent())) {
                        this.b.b(player);
                    }
                } else if (this.f.remove(player.c)) {
                    if (PlayerUntrackEntityEvent.getHandlerList().getRegisteredListeners().length > 0) {
                        new PlayerUntrackEntityEvent((Player)player.getBukkitEntity(), (Entity)this.c.getBukkitEntity()).callEvent();
                    }
                    this.b.a(player);
                }
            }
        }

        private int a(int initialDistance) {
            return PlayerChunkMap.this.q.n().b(initialDistance);
        }

        private int b() {
            int i2 = this.d;
            for (net.minecraft.world.entity.Entity entity : this.c.cR()) {
                int j2 = entity.ae().o() * 16;
                if ((j2 = TrackingRange.getEntityTrackingRange(entity, j2)) <= i2) continue;
                i2 = j2;
            }
            return this.a(i2);
        }

        public void a(List<EntityPlayer> players) {
            for (EntityPlayer entityplayer : players) {
                this.b(entityplayer);
            }
        }
    }

    public static final class DataRegionSectionData
    implements SingleThreadChunkRegionManager.RegionSectionData {
        @Override
        public void removeFromRegion(SingleThreadChunkRegionManager.RegionSection section, SingleThreadChunkRegionManager.Region from) {
            DataRegionSectionData sectionData = (DataRegionSectionData)section.sectionData;
            DataRegionData fromData = (DataRegionData)from.regionData;
        }

        @Override
        public void addToRegion(SingleThreadChunkRegionManager.RegionSection section, SingleThreadChunkRegionManager.Region oldRegion, SingleThreadChunkRegionManager.Region newRegion) {
            DataRegionSectionData sectionData = (DataRegionSectionData)section.sectionData;
            DataRegionData oldRegionData = oldRegion == null ? null : (DataRegionData)oldRegion.regionData;
            DataRegionData newRegionData = (DataRegionData)newRegion.regionData;
        }
    }

    public static final class DataRegionData
    implements SingleThreadChunkRegionManager.RegionData {
    }
}

