/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import alternate.current.wire.WireHandler;
import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import co.aikar.timings.Timing;
import co.aikar.timings.TimingHistory;
import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import com.destroystokyo.paper.util.maplist.IBlockDataList;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.system.ChunkSystem;
import io.papermc.paper.chunk.system.RegionizedPlayerChunkLoader;
import io.papermc.paper.chunk.system.entity.EntityLookup;
import io.papermc.paper.chunk.system.io.RegionFileIOThread;
import io.papermc.paper.chunk.system.scheduling.ChunkTaskScheduler;
import io.papermc.paper.chunk.system.scheduling.NewChunkHolder;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.StacktraceDeobfuscator;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.TraceUtil;
import io.papermc.paper.util.WorldUtil;
import io.papermc.paper.util.math.ThreadUnsafeRandom;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketPlayOutBlockAction;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExplosion;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.IInventory;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.BlockActionData;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ForcedChunk;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSnow;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.PortalTravelAgent;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.maps.PersistentIdCounts;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.ticks.TickListServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_20_R1.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.v1_20_R1.util.BlockStateListPopulator;
import org.bukkit.craftbukkit.v1_20_R1.util.WorldUUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.Merchant;
import org.bukkit.map.MapView;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;
import org.spigotmc.AsyncCatcher;

public class WorldServer
extends net.minecraft.world.level.World
implements GeneratorAccessSeed {
    public static final BlockPosition a = new BlockPosition(100, 50, 0);
    public static final IntProvider b = UniformInt.a(12000, 180000);
    public static final IntProvider c = UniformInt.a(12000, 24000);
    private static final IntProvider D = UniformInt.a(12000, 180000);
    public static final IntProvider d = UniformInt.a(3600, 15600);
    private static final Logger E = LogUtils.getLogger();
    private static final int F = 300;
    private static final int G = 65536;
    final List<EntityPlayer> H;
    public final ChunkProviderServer I;
    private final MinecraftServer J;
    public final WorldDataServer K;
    final EntityTickList L;
    private final GameEventDispatcher N;
    public boolean e;
    private final SleepStatus O;
    private int P;
    private final PortalTravelAgent Q;
    private final TickListServer<Block> R;
    private final TickListServer<FluidType> S;
    final Set<EntityInsentient> T;
    volatile boolean U;
    protected final PersistentRaid f;
    private final ObjectLinkedOpenHashSet<BlockActionData> V;
    private final List<BlockActionData> W;
    private boolean X;
    private final List<MobSpawner> Y;
    @Nullable
    private EnderDragonBattle Z;
    final Int2ObjectMap<EntityComplexPart> aa;
    private final StructureManager ab;
    private final StructureCheck ac;
    private final boolean ad;
    private final RandomSequences ae;
    public long lastMidTickExecuteFailure;
    public final Convertable.ConversionSession convertable;
    public final UUID uuid;
    public boolean hasPhysicsEvent = true;
    public boolean hasEntityMoveEvent = false;
    private final WireHandler wireHandler = new WireHandler(this);
    public final ChunkTaskScheduler chunkTaskScheduler;
    public final RegionFileIOThread.ChunkDataController chunkDataControllerNew = new RegionFileIOThread.ChunkDataController(RegionFileIOThread.RegionFileType.CHUNK_DATA){

        @Override
        public RegionFileCache getCache() {
            return WorldServer.this.k().a.regionFileCache;
        }

        @Override
        public void writeData(int chunkX, int chunkZ, NBTTagCompound compound) throws IOException {
            WorldServer.this.k().a.a(new ChunkCoordIntPair(chunkX, chunkZ), compound);
        }

        @Override
        public NBTTagCompound readData(int chunkX, int chunkZ) throws IOException {
            return WorldServer.this.k().a.readSync(new ChunkCoordIntPair(chunkX, chunkZ));
        }
    };
    public final RegionFileIOThread.ChunkDataController poiDataControllerNew = new RegionFileIOThread.ChunkDataController(RegionFileIOThread.RegionFileType.POI_DATA){

        @Override
        public RegionFileCache getCache() {
            return WorldServer.this.k().a.m();
        }

        @Override
        public void writeData(int chunkX, int chunkZ, NBTTagCompound compound) throws IOException {
            WorldServer.this.k().a.m().a(new ChunkCoordIntPair(chunkX, chunkZ), compound);
        }

        @Override
        public NBTTagCompound readData(int chunkX, int chunkZ) throws IOException {
            return WorldServer.this.k().a.m().a(new ChunkCoordIntPair(chunkX, chunkZ));
        }
    };
    public final RegionFileIOThread.ChunkDataController entityDataControllerNew = new RegionFileIOThread.ChunkDataController(RegionFileIOThread.RegionFileType.ENTITY_DATA){

        @Override
        public RegionFileCache getCache() {
            return WorldServer.this.entityStorage;
        }

        @Override
        public void writeData(int chunkX, int chunkZ, NBTTagCompound compound) throws IOException {
            WorldServer.this.writeEntityChunk(chunkX, chunkZ, compound);
        }

        @Override
        public NBTTagCompound readData(int chunkX, int chunkZ) throws IOException {
            return WorldServer.this.readEntityChunk(chunkX, chunkZ);
        }
    };
    private final EntityRegionFileStorage entityStorage;
    private final EntityLookup entityLookup;
    private final AtomicLong nonFullSyncLoadIdGenerator = new AtomicLong();
    public final RegionizedPlayerChunkLoader playerChunkLoader = new RegionizedPlayerChunkLoader(this);
    private final AtomicReference<RegionizedPlayerChunkLoader.ViewDistances> viewDistances = new AtomicReference<RegionizedPlayerChunkLoader.ViewDistances>(new RegionizedPlayerChunkLoader.ViewDistances(-1, -1, -1));
    public final List<EntityPlayer> playersAffectingSpawning = new ArrayList<EntityPlayer>();
    private final BlockPosition.MutableBlockPosition chunkTickMutablePosition = new BlockPosition.MutableBlockPosition();
    private final ThreadUnsafeRandom randomTickRandom = new ThreadUnsafeRandom(this.z.g());
    static final AtomicReference<net.minecraft.world.entity.Entity> currentlyTickingEntity = new AtomicReference();

    public static Throwable getAddToWorldStackTrace(net.minecraft.world.entity.Entity entity) {
        Throwable thr = new Throwable(entity + " Added to world at " + new Date());
        StacktraceDeobfuscator.INSTANCE.deobfuscateThrowable(thr);
        return thr;
    }

    @Override
    public Chunk getChunkIfLoaded(int x2, int z2) {
        return this.I.getChunkAtIfLoadedImmediately(x2, z2);
    }

    @Override
    public ResourceKey<WorldDimension> getTypeKey() {
        return this.convertable.dimensionType;
    }

    public final boolean areChunksLoadedForMove(AxisAlignedBB axisalignedbb) {
        int minBlockX = MathHelper.a(axisalignedbb.a - 1.0E-7) - 3;
        int maxBlockX = MathHelper.a(axisalignedbb.d + 1.0E-7) + 3;
        int minBlockZ = MathHelper.a(axisalignedbb.c - 1.0E-7) - 3;
        int maxBlockZ = MathHelper.a(axisalignedbb.f + 1.0E-7) + 3;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        ChunkProviderServer chunkProvider = this.k();
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                if (chunkProvider.getChunkAtIfLoadedImmediately(cx, cz) != null) continue;
                return false;
            }
        }
        return true;
    }

    public final void loadChunksAsync(BlockPosition pos, int radiusBlocks, PrioritisedExecutor.Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.loadChunksAsync(pos.u() - radiusBlocks >> 4, pos.u() + radiusBlocks >> 4, pos.w() - radiusBlocks >> 4, pos.w() + radiusBlocks >> 4, priority, onLoad);
    }

    public final void loadChunksAsync(BlockPosition pos, int radiusBlocks, ChunkStatus chunkStatus, PrioritisedExecutor.Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.loadChunksAsync(pos.u() - radiusBlocks >> 4, pos.u() + radiusBlocks >> 4, pos.w() - radiusBlocks >> 4, pos.w() + radiusBlocks >> 4, chunkStatus, priority, onLoad);
    }

    public final void loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, PrioritisedExecutor.Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, ChunkStatus.n, priority, onLoad);
    }

    public final void loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, ChunkStatus chunkStatus, PrioritisedExecutor.Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        ArrayList ret = new ArrayList();
        ChunkProviderServer chunkProvider = this.k();
        int requiredChunks = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
        AtomicInteger loadedChunks = new AtomicInteger();
        Long holderIdentifier = chunkProvider.chunkFutureAwaitCounter.getAndIncrement();
        int ticketLevel = 33 + ChunkStatus.a(chunkStatus);
        Consumer<IChunkAccess> consumer = chunk -> {
            if (chunk != null) {
                ret.add(chunk);
                chunkProvider.addTicketAtLevel(TicketType.FUTURE_AWAIT, chunk.f(), ticketLevel, holderIdentifier);
            }
            if (loadedChunks.incrementAndGet() == requiredChunks) {
                try {
                    onLoad.accept(Collections.unmodifiableList(ret));
                }
                finally {
                    int len = ret.size();
                    for (int i2 = 0; i2 < len; ++i2) {
                        ChunkCoordIntPair chunkPos = ((IChunkAccess)ret.get(i2)).f();
                        chunkProvider.addTicketAtLevel(TicketType.h, chunkPos, ticketLevel, chunkPos);
                        chunkProvider.removeTicketAtLevel(TicketType.FUTURE_AWAIT, chunkPos, ticketLevel, holderIdentifier);
                    }
                }
            }
        };
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                ChunkSystem.scheduleChunkLoad(this, cx, cz, chunkStatus, true, priority, consumer);
            }
        }
    }

    public final void loadChunksForMoveAsync(AxisAlignedBB axisalignedbb, PrioritisedExecutor.Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        int minBlockX = MathHelper.a(axisalignedbb.a - 1.0E-7) - 3;
        int maxBlockX = MathHelper.a(axisalignedbb.d + 1.0E-7) + 3;
        int minBlockZ = MathHelper.a(axisalignedbb.c - 1.0E-7) - 3;
        int maxBlockZ = MathHelper.a(axisalignedbb.f + 1.0E-7) + 3;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        this.loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, priority, onLoad);
    }

    private void writeEntityChunk(int chunkX, int chunkZ, NBTTagCompound compound) throws IOException {
        if (!RegionFileIOThread.isRegionFileThread()) {
            RegionFileIOThread.scheduleSave(this, chunkX, chunkZ, compound, RegionFileIOThread.RegionFileType.ENTITY_DATA);
            return;
        }
        this.entityStorage.a(new ChunkCoordIntPair(chunkX, chunkZ), compound);
    }

    private NBTTagCompound readEntityChunk(int chunkX, int chunkZ) throws IOException {
        if (!RegionFileIOThread.isRegionFileThread()) {
            return RegionFileIOThread.loadData(this, chunkX, chunkZ, RegionFileIOThread.RegionFileType.ENTITY_DATA, RegionFileIOThread.getIOBlockingPriorityForCurrentThread());
        }
        return this.entityStorage.a(new ChunkCoordIntPair(chunkX, chunkZ));
    }

    public final EntityLookup getEntityLookup() {
        return this.entityLookup;
    }

    private IChunkAccess getIfAboveStatus(int chunkX, int chunkZ, ChunkStatus status) {
        NewChunkHolder.ChunkCompletion loadedCompletion;
        NewChunkHolder loaded = this.chunkTaskScheduler.chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (loaded != null && (loadedCompletion = loaded.getLastChunkCompletion()) != null && loadedCompletion.genStatus().b(status)) {
            return loadedCompletion.chunk();
        }
        return null;
    }

    @Override
    public IChunkAccess syncLoadNonFull(int chunkX, int chunkZ, ChunkStatus status) {
        if (status == null || status.b(ChunkStatus.n)) {
            throw new IllegalArgumentException("Status: " + status.toString());
        }
        IChunkAccess loaded = this.getIfAboveStatus(chunkX, chunkZ, status);
        if (loaded != null) {
            return loaded;
        }
        Long ticketId = this.nonFullSyncLoadIdGenerator.getAndIncrement();
        int ticketLevel = 33 + ChunkStatus.a(status);
        this.chunkTaskScheduler.chunkHolderManager.addTicketAtLevel(TicketType.NON_FULL_SYNC_LOAD, chunkX, chunkZ, ticketLevel, ticketId);
        this.chunkTaskScheduler.chunkHolderManager.processTicketUpdates();
        this.chunkTaskScheduler.beginChunkLoadForNonFullSync(chunkX, chunkZ, status, PrioritisedExecutor.Priority.BLOCKING);
        this.I.g.c(() -> this.getIfAboveStatus(chunkX, chunkZ, status) != null);
        loaded = this.getIfAboveStatus(chunkX, chunkZ, status);
        if (loaded == null) {
            throw new IllegalStateException("Expected chunk to be loaded for status " + status);
        }
        this.chunkTaskScheduler.chunkHolderManager.removeTicketAtLevel(TicketType.NON_FULL_SYNC_LOAD, chunkX, chunkZ, ticketLevel, ticketId);
        return loaded;
    }

    public RegionizedPlayerChunkLoader.ViewDistances getViewDistances() {
        return this.viewDistances.get();
    }

    private void updateViewDistance(Function<RegionizedPlayerChunkLoader.ViewDistances, RegionizedPlayerChunkLoader.ViewDistances> update) {
        RegionizedPlayerChunkLoader.ViewDistances curr = this.viewDistances.get();
        while (!this.viewDistances.compareAndSet(curr, update.apply(curr))) {
        }
    }

    public void setTickViewDistance(int distance) {
        if (distance < 2 || distance > 32) {
            throw new IllegalArgumentException("Tick view distance must be a number between 2 and 32, got: " + distance);
        }
        this.updateViewDistance(input -> input.setTickViewDistance(distance));
    }

    public void setLoadViewDistance(int distance) {
        if (distance != -1 && (distance < 2 || distance > 33)) {
            throw new IllegalArgumentException("Load view distance must be a number between 2 and 33 or -1, got: " + distance);
        }
        this.updateViewDistance(input -> input.setLoadViewDistance(distance));
    }

    public void setSendViewDistance(int distance) {
        if (distance != -1 && (distance < 2 || distance > 33)) {
            throw new IllegalArgumentException("Send view distance must be a number between 2 and 33 or -1, got: " + distance);
        }
        this.updateViewDistance(input -> input.setSendViewDistance(distance));
    }

    @Override
    @Nullable
    public EntityHuman b(UUID uuid) {
        EntityPlayer player = this.n().ac().a(uuid);
        return player != null && player.dI() == this ? player : null;
    }

    public final EntityPlayer getNearestPlayer(PathfinderTargetCondition condition, @Nullable EntityLiving source, double centerX, double centerY, double centerZ) {
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet nearby = this.k().a.playerGeneralAreaMap.getObjectsInRange(MathHelper.a(centerX) >> 4, MathHelper.a(centerZ) >> 4);
        if (nearby == null) {
            return null;
        }
        E[] backingSet = nearby.getBackingSet();
        double closestDistanceSquared = Double.MAX_VALUE;
        EntityPlayer closest = null;
        for (Object _player : backingSet) {
            EntityPlayer player;
            double distanceSquared;
            if (!(_player instanceof EntityPlayer) || !((distanceSquared = (player = (EntityPlayer)_player).i(centerX, centerY, centerZ)) < closestDistanceSquared) || !condition.a(source, player)) continue;
            closest = player;
            closestDistanceSquared = distanceSquared;
        }
        return closest;
    }

    @Override
    public EntityHuman a(PathfinderTargetCondition pathfindertargetcondition, EntityLiving entityliving) {
        return this.getNearestPlayer(pathfindertargetcondition, entityliving, entityliving.dn(), entityliving.dp(), entityliving.dt());
    }

    @Override
    public EntityHuman a(PathfinderTargetCondition pathfindertargetcondition, double d0, double d1, double d2) {
        return this.getNearestPlayer(pathfindertargetcondition, null, d0, d1, d2);
    }

    @Override
    public List<EntityHuman> a(PathfinderTargetCondition condition, EntityLiving source, AxisAlignedBB axisalignedbb) {
        double centerX = (axisalignedbb.d + axisalignedbb.a) * 0.5;
        double centerZ = (axisalignedbb.f + axisalignedbb.c) * 0.5;
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet nearby = this.k().a.playerGeneralAreaMap.getObjectsInRange(MathHelper.a(centerX) >> 4, MathHelper.a(centerZ) >> 4);
        ArrayList<EntityHuman> ret = new ArrayList<EntityHuman>();
        if (nearby == null) {
            return ret;
        }
        for (Object _player : nearby.getBackingSet()) {
            EntityPlayer player;
            if (!(_player instanceof EntityPlayer) || !axisalignedbb.e((player = (EntityPlayer)_player).dn(), player.dp(), player.dt()) || !condition.a(source, player)) continue;
            ret.add(player);
        }
        return ret;
    }

    public WorldServer(MinecraftServer minecraftserver, Executor executor, Convertable.ConversionSession convertable_conversionsession, WorldDataServer iworlddataserver, ResourceKey<net.minecraft.world.level.World> resourcekey, WorldDimension worlddimension, WorldLoadListener worldloadlistener, boolean flag, long i2, List<MobSpawner> list, boolean flag1, @Nullable RandomSequences randomsequences, World.Environment env, org.bukkit.generator.ChunkGenerator gen, BiomeProvider biomeProvider) {
        super(iworlddataserver, resourcekey, minecraftserver.aV(), worlddimension.a(), minecraftserver::aN, false, flag, i2, minecraftserver.bd(), gen, biomeProvider, env, spigotConfig -> minecraftserver.paperConfigurations.createWorldConfig(PaperConfigurations.createWorldContextMap(convertable_conversionsession.c.f(), iworlddataserver.g(), resourcekey.a(), spigotConfig)), executor);
        this.pvpMode = minecraftserver.Y();
        this.convertable = convertable_conversionsession;
        this.uuid = WorldUUID.getUUID(convertable_conversionsession.c.f().toFile());
        this.H = Lists.newArrayList();
        this.L = new EntityTickList();
        this.R = new TickListServer(this::d, this.ae());
        this.S = new TickListServer(this::d, this.ae());
        this.T = new ObjectOpenHashSet();
        this.V = new ObjectLinkedOpenHashSet();
        this.W = new ArrayList<BlockActionData>(64);
        this.aa = new Int2ObjectOpenHashMap();
        this.ad = flag1;
        this.J = minecraftserver;
        this.Y = list;
        this.K = iworlddataserver;
        ChunkGenerator chunkgenerator = worlddimension.b();
        this.K.setWorld(this);
        if (biomeProvider != null) {
            CustomWorldChunkManager worldChunkManager = new CustomWorldChunkManager((WorldInfo)this.getWorld(), biomeProvider, this.J.aV().d(Registries.ap));
            if (chunkgenerator instanceof ChunkGeneratorAbstract) {
                ChunkGeneratorAbstract cga = (ChunkGeneratorAbstract)chunkgenerator;
                chunkgenerator = new ChunkGeneratorAbstract((WorldChunkManager)worldChunkManager, cga.e);
            } else if (chunkgenerator instanceof ChunkProviderFlat) {
                ChunkProviderFlat cpf = (ChunkProviderFlat)chunkgenerator;
                chunkgenerator = new ChunkProviderFlat(cpf.g(), worldChunkManager);
            }
        }
        if (gen != null) {
            chunkgenerator = new CustomChunkGenerator(this, chunkgenerator, gen);
        }
        boolean flag2 = minecraftserver.aS();
        DataFixer datafixer = minecraftserver.ay();
        this.entityStorage = new EntityRegionFileStorage(convertable_conversionsession.a(resourcekey).resolve("entities"), flag2);
        StructureTemplateManager structuretemplatemanager = minecraftserver.aT();
        int j2 = this.spigotConfig.viewDistance;
        int k2 = this.spigotConfig.simulationDistance;
        this.I = new ChunkProviderServer(this, convertable_conversionsession, datafixer, structuretemplatemanager, executor, chunkgenerator, j2, k2, flag2, worldloadlistener, null, () -> minecraftserver.D().s());
        this.I.h().b();
        this.Q = new PortalTravelAgent(this);
        this.Q();
        this.T();
        this.w_().a(minecraftserver.as());
        this.f = this.s().a((NBTTagCompound nbttagcompound) -> PersistentRaid.a(this, nbttagcompound), () -> new PersistentRaid(this), PersistentRaid.a(this.ab()));
        if (!minecraftserver.O()) {
            iworlddataserver.a(minecraftserver.o_());
        }
        long l2 = minecraftserver.aU().A().b();
        this.ac = new StructureCheck(this.I.m(), this.B_(), minecraftserver.aT(), this.getTypeKey(), chunkgenerator, this.I.i(), this, chunkgenerator.c(), l2, datafixer);
        this.ab = new StructureManager(this, this.K.A(), this.ac);
        this.Z = this.ac() == net.minecraft.world.level.World.j && this.ab().a(BuiltinDimensionTypes.c) || env == World.Environment.THE_END ? new EnderDragonBattle(this, this.K.A().b(), this.K.E()) : null;
        this.O = new SleepStatus();
        this.N = new GameEventDispatcher(this);
        this.ae = Objects.requireNonNullElseGet(randomsequences, () -> this.s().a((NBTTagCompound nbttagcompound) -> RandomSequences.a(l2, nbttagcompound), () -> new RandomSequences(l2), "random_sequences"));
        this.getCraftServer().addWorld(this.getWorld());
        this.chunkTaskScheduler = new ChunkTaskScheduler(this, ChunkTaskScheduler.workerThreads);
        this.entityLookup = new EntityLookup(this, new a());
    }

    @Override
    public boolean b(int chunkX, int chunkZ) {
        return this.k().getChunkAtIfLoadedImmediately(chunkX, chunkZ) != null;
    }

    @Deprecated
    @VisibleForTesting
    public void a(@Nullable EnderDragonBattle enderDragonFight) {
        this.Z = enderDragonFight;
    }

    public void a(int clearDuration, int rainDuration, boolean raining, boolean thundering) {
        this.K.a(clearDuration);
        this.K.f(rainDuration);
        this.K.e(rainDuration);
        this.K.setRaining(raining, WeatherChangeEvent.Cause.COMMAND);
        this.K.setThundering(thundering, ThunderChangeEvent.Cause.COMMAND);
    }

    @Override
    public Holder<BiomeBase> a(int biomeX, int biomeY, int biomeZ) {
        return this.k().g().c().getNoiseBiome(biomeX, biomeY, biomeZ, this.k().i().b());
    }

    public StructureManager a() {
        return this.ab;
    }

    public void a(BooleanSupplier shouldKeepTicking) {
        long j2;
        this.playersAffectingSpawning.clear();
        for (EntityPlayer player : this.H) {
            if (!IEntitySelector.PLAYER_AFFECTS_SPAWNING.test(player)) continue;
            this.playersAffectingSpawning.add(player);
        }
        GameProfilerFiller gameprofilerfiller = this.ad();
        this.X = true;
        gameprofilerfiller.a("world border");
        this.w_().s();
        gameprofilerfiller.b("weather");
        this.ar();
        int i2 = this.X().c(GameRules.L);
        if (this.O.a(i2) && this.O.a(i2, this.H)) {
            j2 = this.A.f() + 24000L;
            TimeSkipEvent event = new TimeSkipEvent((World)this.getWorld(), TimeSkipEvent.SkipReason.NIGHT_SKIP, j2 - j2 % 24000L - this.W());
            if (this.X().b(GameRules.k)) {
                this.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.b(this.W() + event.getSkipAmount());
                }
            }
            if (!event.isCancelled()) {
                this.ap();
            }
            if (this.X().b(GameRules.u) && this.Z()) {
                this.as();
            }
        }
        this.Q();
        this.b();
        gameprofilerfiller.b("tickPending");
        this.timings.scheduledBlocks.startTiming();
        if (!this.af()) {
            j2 = this.V();
            gameprofilerfiller.a("blockTicks");
            this.R.a(j2, 65536, this::d);
            gameprofilerfiller.b("fluidTicks");
            this.S.a(j2, 65536, this::a);
            gameprofilerfiller.c();
        }
        this.timings.scheduledBlocks.stopTiming();
        gameprofilerfiller.b("raid");
        this.timings.raids.startTiming();
        this.f.a();
        this.timings.raids.stopTiming();
        gameprofilerfiller.b("chunkSource");
        this.timings.chunkProviderTick.startTiming();
        this.k().a(shouldKeepTicking, true);
        this.timings.chunkProviderTick.stopTiming();
        gameprofilerfiller.b("blockEvents");
        this.timings.doSounds.startTiming();
        this.au();
        this.timings.doSounds.stopTiming();
        this.X = false;
        gameprofilerfiller.c();
        boolean flag = true;
        if (flag) {
            this.g();
        }
        if (flag || this.P++ < 300) {
            gameprofilerfiller.a("entities");
            this.timings.tickEntities.startTiming();
            if (this.Z != null) {
                gameprofilerfiller.a("dragonFight");
                this.Z.c();
                gameprofilerfiller.c();
            }
            ActivationRange.activateEntities(this);
            this.timings.entityTick.startTiming();
            this.L.a((net.minecraft.world.entity.Entity entity) -> {
                if (!entity.dD()) {
                    gameprofilerfiller.a("checkDespawn");
                    entity.du();
                    gameprofilerfiller.c();
                    net.minecraft.world.entity.Entity entity1 = entity.cW();
                    if (entity1 != null) {
                        if (!entity1.dD() && entity1.u((net.minecraft.world.entity.Entity)entity)) {
                            return;
                        }
                        entity.Y();
                    }
                    gameprofilerfiller.a("tick");
                    this.a(this::a, entity);
                    gameprofilerfiller.c();
                }
            });
            this.timings.entityTick.stopTiming();
            this.timings.tickEntities.stopTiming();
            gameprofilerfiller.c();
            this.P();
        }
        gameprofilerfiller.a("entityManagement");
        gameprofilerfiller.c();
    }

    @Override
    public boolean a(long chunkPos) {
        PlayerChunk holder = this.I.a.b(chunkPos);
        return holder != null && holder.isTickingReady();
    }

    protected void b() {
        if (this.ad) {
            long i2 = this.A.e() + 1L;
            this.K.a(i2);
            this.K.u().a(this.J, i2);
            if (this.A.q().b(GameRules.k)) {
                this.b(this.A.f() + 1L);
            }
        }
    }

    public void b(long timeOfDay) {
        this.K.b(timeOfDay);
    }

    public void a(boolean spawnMonsters, boolean spawnAnimals) {
        for (MobSpawner mobspawner : this.Y) {
            mobspawner.a(this, spawnMonsters, spawnAnimals);
        }
    }

    private boolean i(net.minecraft.world.entity.Entity entity) {
        return !this.J.W() && (entity instanceof EntityAnimal || entity instanceof EntityWaterAnimal) ? true : !this.J.X() && entity instanceof NPC;
    }

    private void ap() {
        this.O.a();
        this.H.stream().filter(EntityLiving::fy).collect(Collectors.toList()).forEach(entityplayer -> entityplayer.a(false, false));
    }

    public void a(Chunk chunk, int randomTickSpeed) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        boolean flag = this.Z();
        int j2 = chunkcoordintpair.d();
        int k2 = chunkcoordintpair.e();
        GameProfilerFiller gameprofilerfiller = this.ad();
        gameprofilerfiller.a("thunder");
        BlockPosition.MutableBlockPosition blockposition = this.chunkTickMutablePosition;
        if (!this.paperConfig().environment.disableThunder && flag && this.Y() && this.spigotConfig.thunderChance > 0 && this.z.a(this.spigotConfig.thunderChance) == 0) {
            blockposition.g(this.a(this.a(j2, 0, k2, 15)));
            if (this.q(blockposition)) {
                EntityLightning entitylightning;
                EntityHorseSkeleton entityhorseskeleton;
                boolean flag1;
                DifficultyDamageScaler difficultydamagescaler = this.d_(blockposition);
                boolean bl = flag1 = this.X().b(GameRules.e) && this.z.j() < (double)difficultydamagescaler.b() * this.paperConfig().entities.spawning.skeletonHorseThunderSpawnChance.or(0.01) && !this.a_(blockposition.d()).a(Blocks.rr);
                if (flag1 && (entityhorseskeleton = EntityTypes.aK.a(this)) != null) {
                    entityhorseskeleton.w(true);
                    entityhorseskeleton.c_(0);
                    entityhorseskeleton.e(blockposition.u(), blockposition.v(), blockposition.w());
                    this.addFreshEntity(entityhorseskeleton, CreatureSpawnEvent.SpawnReason.LIGHTNING);
                }
                if ((entitylightning = EntityTypes.ai.a(this)) != null) {
                    entitylightning.d(Vec3D.c(blockposition));
                    entitylightning.a(flag1);
                    this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.WEATHER);
                }
            }
        }
        gameprofilerfiller.b("iceandsnow");
        if (!this.paperConfig().environment.disableIceAndSnow && this.z.a(16) == 0) {
            this.getRandomBlockPosition(j2, 0, k2, 15, blockposition);
            int normalY = chunk.a(HeightMap.Type.e, blockposition.u() & 0xF, blockposition.w() & 0xF) + 1;
            int downY = normalY - 1;
            blockposition.q(normalY);
            BiomeBase biomebase = this.s(blockposition).a();
            blockposition.q(downY);
            if (biomebase.a(this, blockposition)) {
                CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, (BlockPosition)blockposition, Blocks.dO.n(), null);
            }
            if (flag) {
                int l2 = this.X().c(GameRules.P);
                blockposition.q(normalY);
                if (l2 > 0 && biomebase.b(this, blockposition)) {
                    IBlockData iblockdata = this.a_(blockposition);
                    if (iblockdata.a(Blocks.dN)) {
                        int i1 = iblockdata.c(BlockSnow.b);
                        if (i1 < Math.min(l2, 8)) {
                            IBlockData iblockdata1 = (IBlockData)iblockdata.a(BlockSnow.b, i1 + 1);
                            Block.a(iblockdata, iblockdata1, this, blockposition);
                            CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, (BlockPosition)blockposition, iblockdata1, null);
                        }
                    } else {
                        CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, (BlockPosition)blockposition, Blocks.dN.n(), null);
                    }
                }
                blockposition.q(downY);
                BiomeBase.Precipitation biomebase_precipitation = biomebase.a(blockposition);
                if (biomebase_precipitation != BiomeBase.Precipitation.a) {
                    IBlockData iblockdata2 = this.a_(blockposition);
                    iblockdata2.b().a(iblockdata2, (net.minecraft.world.level.World)this, (BlockPosition)blockposition, biomebase_precipitation);
                }
            }
        }
        gameprofilerfiller.b("randomTick");
        this.timings.chunkTicksBlocks.startTiming();
        if (randomTickSpeed > 0) {
            ChunkSection[] sections = chunk.d();
            int minSection = WorldUtil.getMinSection(this);
            for (int sectionIndex = 0; sectionIndex < sections.length; ++sectionIndex) {
                ChunkSection section = sections[sectionIndex];
                if (section == null || section.tickingList.size() == 0) continue;
                int yPos = sectionIndex + minSection << 4;
                for (int a2 = 0; a2 < randomTickSpeed; ++a2) {
                    int tickingBlocks = section.tickingList.size();
                    int index = this.randomTickRandom.a(4096);
                    if (index >= tickingBlocks) continue;
                    long raw = section.tickingList.getRaw(index);
                    int location = IBlockDataList.getLocationFromRaw(raw);
                    int randomX = location & 0xF;
                    int randomY = location >>> 8 & 0xFF | yPos;
                    int randomZ = location >>> 4 & 0xF;
                    BlockPosition.MutableBlockPosition blockposition2 = blockposition.d(j2 + randomX, randomY, k2 + randomZ);
                    IBlockData iblockdata = IBlockDataList.getBlockDataFromRaw(raw);
                    iblockdata.b(this, (BlockPosition)blockposition2, this.randomTickRandom);
                }
            }
        }
        this.timings.chunkTicksBlocks.stopTiming();
        gameprofilerfiller.c();
    }

    public Optional<BlockPosition> D(BlockPosition pos) {
        Optional<BlockPosition> optional = this.w().e(holder -> holder.a(PoiTypes.t), blockposition1 -> blockposition1.v() == this.a(HeightMap.Type.b, blockposition1.u(), blockposition1.w()) - 1, pos, 128, VillagePlace.Occupancy.c);
        return optional.map(blockposition1 -> blockposition1.b(1));
    }

    protected BlockPosition a(BlockPosition pos) {
        return this.findLightningTargetAround(pos, false);
    }

    public BlockPosition findLightningTargetAround(BlockPosition pos, boolean returnNullWhenNoTarget) {
        BlockPosition blockposition1 = this.a(HeightMap.Type.e, pos);
        Optional<BlockPosition> optional = this.D(blockposition1);
        if (optional.isPresent()) {
            return optional.get();
        }
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(blockposition1, new BlockPosition(blockposition1.u(), this.aj(), blockposition1.w())).g(3.0);
        List<EntityLiving> list = this.a(EntityLiving.class, axisalignedbb, (? super T entityliving) -> entityliving != null && entityliving.bs() && this.g(entityliving.di()) && !entityliving.G_());
        if (!list.isEmpty()) {
            return list.get(this.z.a(list.size())).di();
        }
        if (returnNullWhenNoTarget) {
            return null;
        }
        if (blockposition1.v() == this.C_() - 1) {
            blockposition1 = blockposition1.b(2);
        }
        return blockposition1;
    }

    public boolean c() {
        return this.X;
    }

    public boolean d() {
        return this.X().c(GameRules.L) <= 100;
    }

    private void aq() {
        if (this.d() && (!this.n().O() || this.n().p())) {
            int i2 = this.X().c(GameRules.L);
            IChatMutableComponent ichatmutablecomponent = this.O.a(i2) ? IChatBaseComponent.c("sleep.skipping_night") : IChatBaseComponent.a("sleep.players_sleeping", this.O.b(), this.O.b(i2));
            for (EntityPlayer entityplayer : this.H) {
                entityplayer.a(ichatmutablecomponent, true);
            }
        }
    }

    public void e() {
        if (!this.H.isEmpty() && this.O.a(this.H)) {
            this.aq();
        }
    }

    public ScoreboardServer f() {
        return this.J.aF();
    }

    private void ar() {
        int idx;
        boolean flag = this.Z();
        if (this.x_().g()) {
            if (this.X().b(GameRules.u)) {
                int i2 = this.K.h();
                int j2 = this.K.j();
                int k2 = this.K.l();
                boolean flag1 = this.A.i();
                boolean flag2 = this.A.k();
                if (i2 > 0) {
                    --i2;
                    j2 = flag1 ? 0 : 1;
                    k2 = flag2 ? 0 : 1;
                    flag1 = false;
                    flag2 = false;
                } else {
                    if (j2 > 0) {
                        if (--j2 == 0) {
                            flag1 = !flag1;
                        }
                    } else {
                        j2 = flag1 ? d.a(this.z) : D.a(this.z);
                    }
                    if (k2 > 0) {
                        if (--k2 == 0) {
                            flag2 = !flag2;
                        }
                    } else {
                        k2 = flag2 ? c.a(this.z) : b.a(this.z);
                    }
                }
                this.K.e(j2);
                this.K.f(k2);
                this.K.a(i2);
                this.K.setThundering(flag1, ThunderChangeEvent.Cause.NATURAL);
                this.K.setRaining(flag2, WeatherChangeEvent.Cause.NATURAL);
            }
            this.x = this.y;
            this.y = this.A.i() ? (this.y += 0.01f) : (this.y -= 0.01f);
            this.y = MathHelper.a(this.y, 0.0f, 1.0f);
            this.v = this.w;
            this.w = this.A.k() ? (this.w += 0.01f) : (this.w -= 0.01f);
            this.w = MathHelper.a(this.w, 0.0f, 1.0f);
        }
        for (idx = 0; idx < this.H.size(); ++idx) {
            if (this.H.get(idx).dI() != this) continue;
            this.H.get(idx).tickWeather();
        }
        if (flag != this.Z()) {
            for (idx = 0; idx < this.H.size(); ++idx) {
                if (this.H.get(idx).dI() != this) continue;
                this.H.get(idx).setPlayerWeather(!flag ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
            }
        }
        for (idx = 0; idx < this.H.size(); ++idx) {
            if (this.H.get(idx).dI() != this) continue;
            this.H.get(idx).updateWeather(this.v, this.w, this.x, this.y);
        }
    }

    private void as() {
        this.K.setRaining(false, WeatherChangeEvent.Cause.SLEEP);
        if (!this.K.k()) {
            this.K.f(0);
        }
        this.K.setThundering(false, ThunderChangeEvent.Cause.SLEEP);
        if (!this.K.i()) {
            this.K.e(0);
        }
    }

    public void g() {
        this.P = 0;
    }

    private void a(BlockPosition pos, FluidType fluid) {
        Fluid fluid1 = this.b_(pos);
        if (fluid1.b(fluid)) {
            fluid1.a(this, pos);
        }
        MinecraftServer.getServer().executeMidTickTasks();
    }

    private void d(BlockPosition pos, Block block) {
        IBlockData iblockdata = this.a_(pos);
        if (iblockdata.a(block)) {
            iblockdata.a(this, pos, this.z);
        }
        MinecraftServer.getServer().executeMidTickTasks();
    }

    public static List<net.minecraft.world.entity.Entity> getCurrentlyTickingEntities() {
        net.minecraft.world.entity.Entity[] entityArray;
        net.minecraft.world.entity.Entity ticking = currentlyTickingEntity.get();
        if (ticking == null) {
            entityArray = new net.minecraft.world.entity.Entity[]{};
        } else {
            net.minecraft.world.entity.Entity[] entityArray2 = new net.minecraft.world.entity.Entity[1];
            entityArray = entityArray2;
            entityArray2[0] = ticking;
        }
        List<net.minecraft.world.entity.Entity> ret = Arrays.asList(entityArray);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(net.minecraft.world.entity.Entity entity) {
        TickThread.ensureTickThread("Cannot tick an entity off-main");
        try {
            if (currentlyTickingEntity.get() == null) {
                currentlyTickingEntity.lazySet(entity);
            }
            ++TimingHistory.entityTicks;
            boolean isActive = ActivationRange.checkIfActive(entity);
            Timing timer = isActive ? entity.ae().tickTimer.startTiming() : entity.ae().inactiveTickTimer.startTiming();
            try {
                entity.bk();
                GameProfilerFiller gameprofilerfiller = this.ad();
                ++entity.ag;
                this.ad().a(() -> BuiltInRegistries.h.b(entity.ae()).toString());
                gameprofilerfiller.d("tickNonPassenger");
                if (isActive) {
                    ++TimingHistory.activatedEntityTicks;
                    entity.l();
                    entity.postTick();
                } else {
                    entity.inactiveTick();
                }
                this.ad().c();
            }
            finally {
                timer.stopTiming();
            }
            for (net.minecraft.world.entity.Entity entity1 : entity.cN()) {
                this.a(entity, entity1);
            }
        }
        finally {
            if (currentlyTickingEntity.get() == entity) {
                currentlyTickingEntity.lazySet(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(net.minecraft.world.entity.Entity vehicle, net.minecraft.world.entity.Entity passenger) {
        if (!passenger.dD() && passenger.cW() == vehicle) {
            if (passenger instanceof EntityHuman || this.L.c(passenger)) {
                boolean isActive = ActivationRange.checkIfActive(passenger);
                Timing timer = isActive ? passenger.ae().passengerTickTimer.startTiming() : passenger.ae().passengerInactiveTickTimer.startTiming();
                try {
                    passenger.bk();
                    ++passenger.ag;
                    GameProfilerFiller gameprofilerfiller = this.ad();
                    gameprofilerfiller.a(() -> BuiltInRegistries.h.b(passenger.ae()).toString());
                    gameprofilerfiller.d("tickPassenger");
                    if (isActive) {
                        passenger.bv();
                        passenger.postTick();
                    } else {
                        passenger.f(Vec3D.b);
                        passenger.inactiveTick();
                        vehicle.i(passenger);
                    }
                    gameprofilerfiller.c();
                    for (net.minecraft.world.entity.Entity entity2 : passenger.cN()) {
                        this.a(passenger, entity2);
                    }
                }
                finally {
                    timer.stopTiming();
                }
            }
        } else {
            passenger.Y();
        }
    }

    @Override
    public boolean a(EntityHuman player, BlockPosition pos) {
        return !this.J.a(this, pos, player) && this.w_().a(pos);
    }

    public void saveIncrementally(boolean doFull) {
        ChunkProviderServer chunkproviderserver = this.k();
        if (doFull) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
        }
        try (Timing ignored = this.timings.worldSave.startTiming();){
            if (doFull) {
                this.at();
            }
            this.timings.worldSaveChunks.startTiming();
            if (!this.r()) {
                chunkproviderserver.saveIncrementally();
            }
            this.timings.worldSaveChunks.stopTiming();
            if (doFull) {
                WorldServer worldserver1 = this;
                this.K.a(worldserver1.w_().t());
                this.K.a(this.J.aJ().c());
                this.convertable.a(this.J.aV(), this.K, this.J.ac().r());
            }
        }
    }

    public void a(@Nullable IProgressUpdate progressListener, boolean flush, boolean savingDisabled) {
        this.save(progressListener, flush, savingDisabled, false);
    }

    public void save(@Nullable IProgressUpdate progressListener, boolean flush, boolean savingDisabled, boolean close) {
        ChunkProviderServer chunkproviderserver = this.k();
        if (!savingDisabled) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
            try (Timing ignored = this.timings.worldSave.startTiming();){
                if (progressListener != null) {
                    progressListener.a(IChatBaseComponent.c("menu.savingLevel"));
                }
                this.at();
                if (progressListener != null) {
                    progressListener.c(IChatBaseComponent.c("menu.savingChunks"));
                }
                this.timings.worldSaveChunks.startTiming();
                if (!close) {
                    chunkproviderserver.a(flush);
                }
                if (close) {
                    chunkproviderserver.close(true);
                }
                this.timings.worldSaveChunks.stopTiming();
            }
        } else if (close) {
            chunkproviderserver.close(false);
        }
        WorldServer worldserver1 = this;
        this.K.a(worldserver1.w_().t());
        this.K.a(this.J.aJ().c());
        this.convertable.a(this.J.aV(), this.K, this.J.ac().r());
    }

    private void at() {
        if (this.Z != null) {
            this.K.a(this.Z.b());
        }
        this.k().k().a();
    }

    public <T extends net.minecraft.world.entity.Entity> List<? extends T> a(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.a(filter, predicate, list);
        return list;
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, Predicate<? super T> predicate, List<? super T> result) {
        this.a(filter, predicate, result, Integer.MAX_VALUE);
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, Predicate<? super T> predicate, List<? super T> result, int limit) {
        this.E().a(filter, (U entity) -> {
            if (predicate.test(entity)) {
                result.add((Object)entity);
                if (result.size() >= limit) {
                    return AbortableIterationConsumer.a.b;
                }
            }
            return AbortableIterationConsumer.a.a;
        });
    }

    public List<? extends EntityEnderDragon> h() {
        return this.a(EntityTypes.C, EntityLiving::bs);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate) {
        return this.a(predicate, Integer.MAX_VALUE);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate, int limit) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer entityplayer : this.H) {
            if (!predicate.test(entityplayer)) continue;
            list.add(entityplayer);
            if (list.size() < limit) continue;
            return list;
        }
        return list;
    }

    @Nullable
    public EntityPlayer i() {
        List<EntityPlayer> list = this.a(EntityLiving::bs);
        return list.isEmpty() ? null : list.get(this.z.a(list.size()));
    }

    @Override
    public boolean b(net.minecraft.world.entity.Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public boolean c(net.minecraft.world.entity.Entity entity) {
        return this.addWithUUID(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean addWithUUID(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public void d(net.minecraft.world.entity.Entity entity) {
        this.addDuringTeleport(entity, null);
    }

    public void addDuringTeleport(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        this.addEntity(entity, reason);
    }

    public void a(EntityPlayer player) {
        this.e(player);
    }

    public void b(EntityPlayer player) {
        this.e(player);
    }

    public void c(EntityPlayer player) {
        this.e(player);
    }

    public void d(EntityPlayer player) {
        this.e(player);
    }

    private void e(EntityPlayer player) {
        net.minecraft.world.entity.Entity entity = this.E().a(player.ct());
        if (entity != null) {
            E.warn("Force-added player with duplicate UUID {}", (Object)player.ct().toString());
            entity.ac();
            this.a((EntityPlayer)entity, Entity.RemovalReason.b);
        }
        this.entityLookup.addNewEntity(player);
    }

    private boolean addEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityItem itemEntity;
        AsyncCatcher.catchOp("entity add");
        if (entity.valid) {
            MinecraftServer.n.error("Attempted Double World add on " + entity, new Throwable());
            if (net.minecraft.world.level.World.DEBUG_ENTITIES) {
                Throwable thr = entity.addedToWorldStack;
                if (thr == null) {
                    MinecraftServer.n.error("Double add entity has no add stacktrace");
                } else {
                    MinecraftServer.n.error("Double add stacktrace: ", thr);
                }
            }
            return true;
        }
        if (entity.spawnReason == null) {
            entity.spawnReason = spawnReason;
        }
        if (entity.dD()) {
            if (net.minecraft.world.level.World.DEBUG_ENTITIES) {
                TraceUtil.dumpTraceForThread("Tried to add entity " + entity + " but it was marked as removed already");
                WorldServer.getAddToWorldStackTrace(entity).printStackTrace();
            }
            return false;
        }
        if (entity instanceof EntityItem && (itemEntity = (EntityItem)entity).j().b()) {
            return false;
        }
        if (this.captureDrops != null && entity instanceof EntityItem) {
            this.captureDrops.add((EntityItem)entity);
            return true;
        }
        if (spawnReason != null && !CraftEventFactory.doEntityAddEventCalling(this, entity, spawnReason)) {
            return false;
        }
        return this.entityLookup.addNewEntity(entity);
    }

    public boolean e(net.minecraft.world.entity.Entity entity) {
        return this.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean tryAddFreshEntityWithPassengers(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        Stream<UUID> stream = entity.cP().map(net.minecraft.world.entity.Entity::ct);
        if (stream.anyMatch(this.entityLookup::hasEntity)) {
            return false;
        }
        this.addFreshEntityWithPassengers(entity, reason);
        return true;
    }

    public void a(Chunk chunk) {
        for (TileEntity tileentity : chunk.G().values()) {
            if (!(tileentity instanceof IInventory)) continue;
            for (HumanEntity h2 : Lists.newArrayList(((IInventory)((Object)tileentity)).getViewers())) {
                ((CraftHumanEntity)h2).getHandle().closeUnloadedInventory(InventoryCloseEvent.Reason.UNLOADED);
            }
        }
        chunk.I();
        chunk.b(this);
    }

    public void a(EntityPlayer player, Entity.RemovalReason reason) {
        player.a(reason);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning) {
        return this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.UNKNOWN);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent lightning = CraftEventFactory.callLightningStrikeEvent((LightningStrike)entitylightning.getBukkitEntity(), cause);
        if (lightning.isCancelled()) {
            return false;
        }
        return this.b(entitylightning);
    }

    @Override
    public void a(int entityId, BlockPosition pos, int progress) {
        Iterator<EntityPlayer> iterator = this.J.ac().t().iterator();
        EntityHuman entityhuman = null;
        net.minecraft.world.entity.Entity entity = this.a(entityId);
        if (entity instanceof EntityHuman) {
            entityhuman = (EntityHuman)entity;
        }
        while (iterator.hasNext()) {
            EntityPlayer entityplayer = iterator.next();
            if (entityplayer == null || entityplayer.dI() != this || entityplayer.af() == entityId) continue;
            double d0 = (double)pos.u() - entityplayer.dn();
            double d1 = (double)pos.v() - entityplayer.dp();
            double d2 = (double)pos.w() - entityplayer.dt();
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity()) || !(d0 * d0 + d1 * d1 + d2 * d2 < 1024.0)) continue;
            entityplayer.c.a(new PacketPlayOutBlockBreakAnimation(entityId, pos, progress));
        }
    }

    @Override
    public void a(@Nullable EntityHuman except, double x2, double y2, double z2, Holder<SoundEffect> sound, SoundCategory category, float volume, float pitch, long seed) {
        this.J.ac().a(except, x2, y2, z2, sound.a().a(volume), this.ac(), new PacketPlayOutNamedSoundEffect(sound, category, x2, y2, z2, volume, pitch, seed));
    }

    @Override
    public void a(@Nullable EntityHuman except, net.minecraft.world.entity.Entity entity, Holder<SoundEffect> sound, SoundCategory category, float volume, float pitch, long seed) {
        this.J.ac().a(except, entity.dn(), entity.dp(), entity.dt(), sound.a().a(volume), this.ac(), new PacketPlayOutEntitySound(sound, category, entity, volume, pitch, seed));
    }

    @Override
    public void b(int eventId, BlockPosition pos, int data) {
        if (this.X().b(GameRules.S)) {
            this.J.ac().a(new PacketPlayOutWorldEvent(eventId, pos, data, true));
        } else {
            this.a((EntityHuman)null, eventId, pos, data);
        }
    }

    @Override
    public void a(@Nullable EntityHuman player, int eventId, BlockPosition pos, int data) {
        this.J.ac().a(player, pos.u(), pos.v(), pos.w(), 64.0, this.ac(), new PacketPlayOutWorldEvent(eventId, pos, data, false));
    }

    public int j() {
        return this.x_().p();
    }

    @Override
    public void a(GameEvent event, Vec3D emitterPos, GameEvent.a emitter) {
        if (this.getChunkIfLoadedImmediately(MathHelper.a(emitterPos.c) >> 4, MathHelper.a(emitterPos.e) >> 4) == null) {
            return;
        }
        this.N.a(event, emitterPos, emitter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(BlockPosition pos, IBlockData oldState, IBlockData newState, int flags) {
        VoxelShape voxelshape1;
        VoxelShape voxelshape;
        if (this.U) {
            String s2 = "recursive call to sendBlockUpdated";
            SystemUtils.a("recursive call to sendBlockUpdated", (Throwable)new IllegalStateException("recursive call to sendBlockUpdated"));
        }
        this.k().a(pos);
        if (this.paperConfig().misc.updatePathfindingOnBlockUpdate && VoxelShapes.c(voxelshape = oldState.k(this, pos), voxelshape1 = newState.k(this, pos), OperatorBoolean.g)) {
            ObjectArrayList list = new ObjectArrayList();
            Iterator<EntityInsentient> iterator = this.T.iterator();
            while (iterator.hasNext()) {
                EntityInsentient entityinsentient;
                try {
                    entityinsentient = iterator.next();
                }
                catch (ConcurrentModificationException ex) {
                    this.a(pos, oldState, newState, flags);
                    return;
                }
                NavigationAbstract navigationabstract = entityinsentient.J();
                if (!navigationabstract.b(pos)) continue;
                list.add(navigationabstract);
            }
            try {
                this.U = true;
                for (NavigationAbstract navigationabstract1 : list) {
                    navigationabstract1.i();
                }
            }
            finally {
                this.U = false;
            }
        }
    }

    @Override
    public void a(BlockPosition pos, Block sourceBlock) {
        if (this.captureBlockStates) {
            return;
        }
        this.s.a(pos, sourceBlock, (EnumDirection)null);
    }

    @Override
    public void a(BlockPosition pos, Block sourceBlock, EnumDirection direction) {
        this.s.a(pos, sourceBlock, direction);
    }

    @Override
    public void a(BlockPosition pos, Block sourceBlock, BlockPosition sourcePos) {
        this.s.a(pos, sourceBlock, sourcePos);
    }

    @Override
    public void a(IBlockData state, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
        this.s.a(state, pos, sourceBlock, sourcePos, notify);
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, byte status) {
        this.k().a(entity, new PacketPlayOutEntityStatus(entity, status));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, DamageSource damageSource) {
        this.k().a(entity, new ClientboundDamageEventPacket(entity, damageSource));
    }

    public ChunkProviderServer k() {
        return this.I;
    }

    @Override
    public Explosion a(@Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, double x2, double y2, double z2, float power, boolean createFire, World.a explosionSourceType) {
        Explosion explosion = this.a(entity, damageSource, behavior, x2, y2, z2, power, createFire, explosionSourceType, false);
        if (explosion.wasCanceled) {
            return explosion;
        }
        if (!explosion.b()) {
            explosion.g();
        }
        for (EntityPlayer entityplayer : this.H) {
            if (!(entityplayer.i(x2, y2, z2) < 4096.0)) continue;
            entityplayer.c.a(new PacketPlayOutExplosion(x2, y2, z2, power, explosion.h(), explosion.d().get(entityplayer)));
        }
        return explosion;
    }

    @Override
    public void a(BlockPosition pos, Block block, int type, int data) {
        this.V.add((Object)new BlockActionData(pos, block, type, data));
    }

    private void au() {
        this.W.clear();
        while (!this.V.isEmpty()) {
            BlockActionData blockactiondata = (BlockActionData)this.V.removeFirst();
            if (this.m(blockactiondata.a())) {
                if (!this.a(blockactiondata)) continue;
                this.J.ac().a(null, blockactiondata.a().u(), blockactiondata.a().v(), blockactiondata.a().w(), 64.0, this.ac(), new PacketPlayOutBlockAction(blockactiondata.a(), blockactiondata.b(), blockactiondata.c(), blockactiondata.d()));
                continue;
            }
            this.W.add(blockactiondata);
        }
        this.V.addAll(this.W);
    }

    private boolean a(BlockActionData event) {
        IBlockData iblockdata = this.a_(event.a());
        return iblockdata.a(event.b()) ? iblockdata.a((net.minecraft.world.level.World)this, event.a(), event.c(), event.d()) : false;
    }

    public TickListServer<Block> l() {
        return this.R;
    }

    public TickListServer<FluidType> m() {
        return this.S;
    }

    @Override
    @Nonnull
    public MinecraftServer n() {
        return this.J;
    }

    public PortalTravelAgent o() {
        return this.Q;
    }

    public StructureTemplateManager p() {
        return this.J.aT();
    }

    public <T extends ParticleParam> int a(T particle, double x2, double y2, double z2, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        return this.sendParticles(null, particle, x2, y2, z2, count, deltaX, deltaY, deltaZ, speed, false);
    }

    public <T extends ParticleParam> int sendParticles(EntityPlayer sender, T t0, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6, boolean force) {
        return this.sendParticles(this.H, sender, t0, d0, d1, d2, i2, d3, d4, d5, d6, force);
    }

    public <T extends ParticleParam> int sendParticles(List<EntityPlayer> receivers, EntityPlayer sender, T t0, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6, boolean force) {
        PacketPlayOutWorldParticles packetplayoutworldparticles = new PacketPlayOutWorldParticles(t0, force, d0, d1, d2, (float)d3, (float)d4, (float)d5, (float)d6, i2);
        int j2 = 0;
        for (EntityHuman entityHuman : receivers) {
            EntityPlayer entityplayer = (EntityPlayer)entityHuman;
            if (sender != null && !entityplayer.getBukkitEntity().canSee(sender.getBukkitEntity()) || !this.a(entityplayer, force, d0, d1, d2, packetplayoutworldparticles)) continue;
            ++j2;
        }
        return j2;
    }

    public <T extends ParticleParam> boolean a(EntityPlayer viewer, T particle, boolean force, double x2, double y2, double z2, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        PacketPlayOutWorldParticles packet = new PacketPlayOutWorldParticles(particle, force, x2, y2, z2, (float)deltaX, (float)deltaY, (float)deltaZ, (float)speed, count);
        return this.a(viewer, force, x2, y2, z2, packet);
    }

    private boolean a(EntityPlayer player, boolean force, double x2, double y2, double z2, Packet<?> packet) {
        if (player.dI() != this) {
            return false;
        }
        BlockPosition blockposition = player.di();
        if (blockposition.a(new Vec3D(x2, y2, z2), force ? 512.0 : 32.0)) {
            player.c.a(packet);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public net.minecraft.world.entity.Entity a(int id) {
        return this.E().a(id);
    }

    @Deprecated
    @Nullable
    public net.minecraft.world.entity.Entity b(int id) {
        net.minecraft.world.entity.Entity entity = this.E().a(id);
        return entity != null ? entity : (net.minecraft.world.entity.Entity)this.aa.get(id);
    }

    @Nullable
    public net.minecraft.world.entity.Entity a(UUID uuid) {
        return this.E().a(uuid);
    }

    @Nullable
    public BlockPosition a(TagKey<Structure> structureTag, BlockPosition pos, int radius, boolean skipReferencedStructures) {
        if (!this.K.A().c()) {
            return null;
        }
        Optional<HolderSet.Named<Structure>> optional = this.B_().d(Registries.az).b(structureTag);
        if (optional.isEmpty()) {
            return null;
        }
        Pair<BlockPosition, Holder<Structure>> pair = this.k().g().a(this, (HolderSet<Structure>)optional.get(), pos, radius, skipReferencedStructures);
        return pair != null ? (BlockPosition)pair.getFirst() : null;
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> a(Predicate<Holder<BiomeBase>> predicate, BlockPosition pos, int radius, int horizontalBlockCheckInterval, int verticalBlockCheckInterval) {
        return this.k().g().c().a(pos, radius, horizontalBlockCheckInterval, verticalBlockCheckInterval, predicate, this.k().i().b(), this);
    }

    @Override
    public CraftingManager q() {
        return this.J.aE();
    }

    @Override
    public boolean r() {
        return this.e;
    }

    public WorldPersistentData s() {
        return this.k().k();
    }

    @Override
    @Nullable
    public WorldMap a(String id) {
        return this.n().D().s().a((NBTTagCompound nbttagcompound) -> {
            WorldMap newMap = WorldMap.b(nbttagcompound);
            newMap.id = id;
            MapInitializeEvent event = new MapInitializeEvent((MapView)newMap.mapView);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            return newMap;
        }, id);
    }

    @Override
    public void a(String id, WorldMap state) {
        state.id = id;
        this.n().D().s().a(id, state);
    }

    @Override
    public int t() {
        return this.n().D().s().a(PersistentIdCounts::b, PersistentIdCounts::new, "idcounts").a();
    }

    public void addTicketsForSpawn(int radiusInBlocks, BlockPosition spawn) {
        int x2;
        ChunkProviderServer chunkproviderserver = this.k();
        int tickRadius = radiusInBlocks - 16;
        for (x2 = -tickRadius; x2 <= tickRadius; x2 += 16) {
            for (int z2 = -tickRadius; z2 <= tickRadius; z2 += 16) {
                chunkproviderserver.a(TicketType.a, new ChunkCoordIntPair(spawn.b(x2, 0, z2)), 2, Unit.a);
            }
        }
        for (x2 = -radiusInBlocks; x2 <= radiusInBlocks; x2 += 16) {
            chunkproviderserver.a(TicketType.a, new ChunkCoordIntPair(spawn.b(x2, 0, radiusInBlocks)), 1, Unit.a);
            chunkproviderserver.a(TicketType.a, new ChunkCoordIntPair(spawn.b(x2, 0, -radiusInBlocks)), 1, Unit.a);
        }
        for (int z3 = -radiusInBlocks + 16; z3 < radiusInBlocks; z3 += 16) {
            chunkproviderserver.a(TicketType.a, new ChunkCoordIntPair(spawn.b(radiusInBlocks, 0, z3)), 1, Unit.a);
            chunkproviderserver.a(TicketType.a, new ChunkCoordIntPair(spawn.b(-radiusInBlocks, 0, z3)), 1, Unit.a);
        }
    }

    public void removeTicketsForSpawn(int radiusInBlocks, BlockPosition spawn) {
        int x2;
        ChunkProviderServer chunkproviderserver = this.k();
        int tickRadius = radiusInBlocks - 16;
        for (x2 = -tickRadius; x2 <= tickRadius; x2 += 16) {
            for (int z2 = -tickRadius; z2 <= tickRadius; z2 += 16) {
                chunkproviderserver.b(TicketType.a, new ChunkCoordIntPair(spawn.b(x2, 0, z2)), 2, Unit.a);
            }
        }
        for (x2 = -radiusInBlocks; x2 <= radiusInBlocks; x2 += 16) {
            chunkproviderserver.b(TicketType.a, new ChunkCoordIntPair(spawn.b(x2, 0, radiusInBlocks)), 1, Unit.a);
            chunkproviderserver.b(TicketType.a, new ChunkCoordIntPair(spawn.b(x2, 0, -radiusInBlocks)), 1, Unit.a);
        }
        for (int z3 = -radiusInBlocks + 16; z3 < radiusInBlocks; z3 += 16) {
            chunkproviderserver.b(TicketType.a, new ChunkCoordIntPair(spawn.b(radiusInBlocks, 0, z3)), 1, Unit.a);
            chunkproviderserver.b(TicketType.a, new ChunkCoordIntPair(spawn.b(-radiusInBlocks, 0, z3)), 1, Unit.a);
        }
    }

    public void a(BlockPosition pos, float angle) {
        BlockPosition prevSpawn = this.R();
        Location prevSpawnLoc = this.getWorld().getSpawnLocation();
        this.A.a(pos, angle);
        new SpawnChangeEvent((World)this.getWorld(), prevSpawnLoc).callEvent();
        if (this.keepSpawnInMemory) {
            this.removeTicketsForSpawn(this.paperConfig().spawn.keepSpawnLoadedRange * 16, prevSpawn);
            this.addTicketsForSpawn(this.paperConfig().spawn.keepSpawnLoadedRange * 16, pos);
        }
        this.n().ac().a(new PacketPlayOutSpawnPosition(pos, angle));
    }

    public LongSet u() {
        ForcedChunk forcedchunk = this.s().a(ForcedChunk::b, "chunks");
        return forcedchunk != null ? LongSets.unmodifiable((LongSet)forcedchunk.a()) : LongSets.EMPTY_SET;
    }

    public boolean a(int x2, int z2, boolean forced) {
        boolean flag1;
        ForcedChunk forcedchunk = this.s().a(ForcedChunk::b, ForcedChunk::new, "chunks");
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(x2, z2);
        long k2 = chunkcoordintpair.a();
        if (forced) {
            flag1 = forcedchunk.a().add(k2);
            if (flag1) {
                this.d(x2, z2);
            }
        } else {
            flag1 = forcedchunk.a().remove(k2);
        }
        forcedchunk.a(flag1);
        if (flag1) {
            this.k().a(chunkcoordintpair, forced);
        }
        return flag1;
    }

    public List<EntityPlayer> v() {
        return this.H;
    }

    @Override
    public void a(BlockPosition pos, IBlockData oldBlock, IBlockData newBlock) {
        Optional<Holder<VillagePlaceType>> optional1;
        Optional<Holder<VillagePlaceType>> optional = PoiTypes.a(oldBlock);
        if (!Objects.equals(optional, optional1 = PoiTypes.a(newBlock))) {
            BlockPosition blockposition1 = pos.i();
            optional.ifPresent(holder -> this.n().execute(() -> {
                this.w().a(blockposition1);
                PacketDebug.b(this, blockposition1);
            }));
            optional1.ifPresent(holder -> this.n().execute(() -> {
                if (optional.isEmpty() && this.w().a(blockposition1, (Holder<VillagePlaceType> poiType) -> true)) {
                    this.w().a(blockposition1);
                }
                this.w().a(blockposition1, (Holder<VillagePlaceType>)holder);
                PacketDebug.a(this, blockposition1);
            }));
        }
    }

    public VillagePlace w() {
        return this.k().l();
    }

    public boolean b(BlockPosition pos) {
        return this.a(pos, 1);
    }

    public boolean a(SectionPosition sectionPos) {
        return this.b(sectionPos.q());
    }

    public boolean a(BlockPosition pos, int maxDistance) {
        return maxDistance > 6 ? false : this.b(SectionPosition.a(pos)) <= maxDistance;
    }

    public int b(SectionPosition pos) {
        return this.w().a(pos);
    }

    public PersistentRaid x() {
        return this.f;
    }

    @Nullable
    public Raid c(BlockPosition pos) {
        return this.f.a(pos, 9216);
    }

    public boolean d(BlockPosition pos) {
        return this.c(pos) != null;
    }

    public void a(ReputationEvent interaction, net.minecraft.world.entity.Entity entity, ReputationHandler observer) {
        observer.a(interaction, entity);
    }

    public void a(Path path) throws IOException {
        Path path2;
        BufferedWriter bufferedwriter3;
        PlayerChunkMap playerchunkmap = this.k().a;
        try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path.resolve("stats.txt"), new OpenOption[0]);){
            bufferedwriter.write(String.format(Locale.ROOT, "spawning_chunks: %d\n", playerchunkmap.j().b()));
            SpawnerCreature.d spawnercreature_d = this.k().n();
            if (spawnercreature_d != null) {
                for (Object2IntMap.Entry entry : spawnercreature_d.b().object2IntEntrySet()) {
                    bufferedwriter.write(String.format(Locale.ROOT, "spawn_count.%s: %d\n", ((EnumCreatureType)entry.getKey()).a(), entry.getIntValue()));
                }
            }
            bufferedwriter.write(String.format(Locale.ROOT, "entities: %s\n", this.entityLookup.getDebugInfo()));
            bufferedwriter.write(String.format(Locale.ROOT, "block_entity_tickers: %d\n", this.r.size()));
            bufferedwriter.write(String.format(Locale.ROOT, "block_ticks: %d\n", this.l().a()));
            bufferedwriter.write(String.format(Locale.ROOT, "fluid_ticks: %d\n", this.m().a()));
            bufferedwriter.write("distance_manager: " + playerchunkmap.j().c() + "\n");
            bufferedwriter.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.k().f()));
        }
        CrashReport crashreport = new CrashReport("Level dump", new Exception("dummy"));
        this.a(crashreport);
        try (BufferedWriter bufferedwriter1 = Files.newBufferedWriter(path.resolve("example_crash.txt"), new OpenOption[0]);){
            bufferedwriter1.write(crashreport.e());
        }
        Path path1 = path.resolve("chunks.csv");
        BufferedWriter bufferedwriter2 = Files.newBufferedWriter(path1, new OpenOption[0]);
        if (bufferedwriter2 != null) {
            bufferedwriter2.close();
        }
        if ((bufferedwriter3 = Files.newBufferedWriter(path2 = path.resolve("entity_chunks.csv"), new OpenOption[0])) != null) {
            bufferedwriter3.close();
        }
        Path path3 = path.resolve("entities.csv");
        try (BufferedWriter bufferedwriter4 = Files.newBufferedWriter(path3, new OpenOption[0]);){
            WorldServer.a(bufferedwriter4, this.E().a());
        }
        Path path4 = path.resolve("block_entities.csv");
        try (BufferedWriter bufferedwriter5 = Files.newBufferedWriter(path4, new OpenOption[0]);){
            this.a(bufferedwriter5);
        }
    }

    private static void a(Writer writer, Iterable<net.minecraft.world.entity.Entity> entities) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("y").a("z").a("uuid").a("type").a("alive").a("display_name").a("custom_name").a(writer);
        for (net.minecraft.world.entity.Entity entity : entities) {
            IChatBaseComponent ichatbasecomponent = entity.ab();
            IChatBaseComponent ichatbasecomponent1 = entity.H_();
            csvwriter.a(entity.dn(), entity.dp(), entity.dt(), entity.ct(), BuiltInRegistries.h.b(entity.ae()), entity.bs(), ichatbasecomponent1.getString(), ichatbasecomponent != null ? ichatbasecomponent.getString() : null);
        }
    }

    private void a(Writer writer) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("y").a("z").a("type").a(writer);
        for (TickingBlockEntity tickingblockentity : this.r) {
            BlockPosition blockposition = tickingblockentity.c();
            csvwriter.a(blockposition.u(), blockposition.v(), blockposition.w(), tickingblockentity.d());
        }
    }

    @VisibleForTesting
    public void a(StructureBoundingBox box) {
        this.V.removeIf(blockactiondata -> box.b(blockactiondata.a()));
    }

    @Override
    public void b(BlockPosition pos, Block block) {
        if (!this.af()) {
            if (this.populating) {
                return;
            }
            this.a(pos, block);
        }
    }

    @Override
    public float a(EnumDirection direction, boolean shaded) {
        return 1.0f;
    }

    public Iterable<net.minecraft.world.entity.Entity> y() {
        return this.E().a();
    }

    public String toString() {
        return "ServerLevel[" + this.K.g() + "]";
    }

    public boolean z() {
        return this.K.B();
    }

    @Override
    public long A() {
        return this.K.A().b();
    }

    @Nullable
    public EnderDragonBattle B() {
        return this.Z;
    }

    @Override
    public WorldServer C() {
        return this;
    }

    @VisibleForTesting
    public String D() {
        return String.format(Locale.ROOT, "players: %s, entities: %s [%s], block_entities: %d [%s], block_ticks: %d, fluid_ticks: %d, chunk_source: %s", this.H.size(), this.entityLookup.getDebugInfo(), WorldServer.a(this.entityLookup.a(), (T entity) -> BuiltInRegistries.h.b(entity.ae()).toString()), this.r.size(), WorldServer.a(this.r, TickingBlockEntity::d), this.l().a(), this.m().a(), this.F());
    }

    private static <T> String a(Iterable<T> items, Function<T, String> classifier) {
        try {
            Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
            for (T t0 : items) {
                String s2 = classifier.apply(t0);
                object2intopenhashmap.addTo((Object)s2, 1);
            }
            return object2intopenhashmap.object2IntEntrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue).reversed()).limit(5L).map(entry -> {
                String s1 = (String)entry.getKey();
                return s1 + ":" + entry.getIntValue();
            }).collect(Collectors.joining(","));
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void a(WorldServer world) {
        WorldServer.makeObsidianPlatform(world, null);
    }

    public static void makeObsidianPlatform(WorldServer worldserver, net.minecraft.world.entity.Entity entity) {
        BlockPosition blockposition = a;
        int i2 = blockposition.u();
        int j2 = blockposition.v() - 2;
        int k2 = blockposition.w();
        BlockStateListPopulator blockList = new BlockStateListPopulator(worldserver);
        BlockPosition.b(i2 - 2, j2 + 1, k2 - 2, i2 + 2, j2 + 3, k2 + 2).forEach(blockposition1 -> blockList.a((BlockPosition)blockposition1, Blocks.a.n(), 3));
        BlockPosition.b(i2 - 2, j2, k2 - 2, i2 + 2, j2, k2 + 2).forEach(blockposition1 -> blockList.a((BlockPosition)blockposition1, Blocks.co.n(), 3));
        CraftWorld bworld = worldserver.getWorld();
        PortalCreateEvent portalEvent = new PortalCreateEvent(blockList.getList(), (World)bworld, (Entity)(entity == null ? null : entity.getBukkitEntity()), PortalCreateEvent.CreateReason.END_PLATFORM);
        worldserver.getCraftServer().getPluginManager().callEvent((Event)portalEvent);
        if (!portalEvent.isCancelled()) {
            blockList.updateList();
        }
    }

    @Override
    public LevelEntityGetter<net.minecraft.world.entity.Entity> E() {
        AsyncCatcher.catchOp("Chunk getEntities call");
        return this.entityLookup;
    }

    public void a(Stream<net.minecraft.world.entity.Entity> entities) {
        this.entityLookup.addLegacyChunkEntities(entities.toList());
    }

    public void b(Stream<net.minecraft.world.entity.Entity> entities) {
        this.entityLookup.addWorldGenChunkEntities(entities.toList());
    }

    public void b(Chunk chunk) {
        chunk.c(this.u_().e());
    }

    public void a(IChunkAccess chunk) {
        this.J.execute(() -> this.ac.a(chunk.f(), chunk.g()));
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public String F() {
        String s2 = this.I.e();
        return "Chunks[S] W: " + s2 + " E: " + this.entityLookup.getDebugInfo();
    }

    public boolean c(long chunkPos) {
        return this.getChunkIfLoadedImmediately(ChunkCoordIntPair.a(chunkPos), ChunkCoordIntPair.b(chunkPos)) != null;
    }

    private boolean d(long chunkPos) {
        NewChunkHolder chunkHolder = this.chunkTaskScheduler.chunkHolderManager.getChunkHolder(chunkPos);
        return chunkHolder != null && chunkHolder.isTickingReady();
    }

    public boolean e(BlockPosition pos) {
        NewChunkHolder chunkHolder = this.chunkTaskScheduler.chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean f(BlockPosition pos) {
        NewChunkHolder chunkHolder = this.chunkTaskScheduler.chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean a(ChunkCoordIntPair pos) {
        NewChunkHolder chunkHolder = this.chunkTaskScheduler.chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    @Override
    public FeatureFlagSet G() {
        return this.J.aU().M();
    }

    public RandomSource a(MinecraftKey id) {
        return this.ae.a(id);
    }

    public RandomSequences H() {
        return this.ae;
    }

    @Override
    public WireHandler getWireHandler() {
        return this.wireHandler;
    }

    @Override
    @Nullable
    public EntityHuman getGlobalPlayerByUUID(UUID uuid) {
        return this.J.ac().a(uuid);
    }

    private static final class EntityRegionFileStorage
    extends RegionFileCache {
        public EntityRegionFileStorage(Path directory, boolean dsync) {
            super(directory, dsync);
        }

        @Override
        protected void a(ChunkCoordIntPair pos, NBTTagCompound nbt) throws IOException {
            ChunkCoordIntPair nbtPos;
            ChunkCoordIntPair chunkCoordIntPair = nbtPos = nbt == null ? null : EntityStorage.a(nbt);
            if (nbtPos != null && !pos.equals(nbtPos)) {
                throw new IllegalArgumentException("Entity chunk coordinate and serialized data do not have matching coordinates, trying to serialize coordinate " + pos.toString() + " but compound says coordinate is " + nbtPos + " for world: " + this);
            }
            super.a(pos, nbt);
        }
    }

    private final class a
    implements LevelCallback<net.minecraft.world.entity.Entity> {
        a() {
        }

        @Override
        public void a(net.minecraft.world.entity.Entity entity) {
        }

        @Override
        public void b(net.minecraft.world.entity.Entity entity) {
            WorldServer.this.f().a(entity);
        }

        @Override
        public void c(net.minecraft.world.entity.Entity entity) {
            if (entity instanceof Marker && !WorldServer.this.paperConfig().entities.markers.tick) {
                return;
            }
            WorldServer.this.L.a(entity);
        }

        @Override
        public void d(net.minecraft.world.entity.Entity entity) {
            WorldServer.this.L.b(entity);
            if (WorldServer.this.paperConfig().fixes.disableUnloadedChunkEnderpearlExploit && entity instanceof EntityEnderPearl) {
                EntityEnderPearl pearl = (EntityEnderPearl)entity;
                pearl.c = null;
                ((IProjectile)pearl).b = null;
            }
        }

        @Override
        public void e(net.minecraft.world.entity.Entity entity) {
            AsyncCatcher.catchOp("entity register");
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                WorldServer.this.H.add(entityplayer);
                WorldServer.this.e();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                WorldServer.this.T.add(entityinsentient);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.fV()) {
                    WorldServer.this.aa.put(entitycomplexpart.af(), (Object)entitycomplexpart);
                }
            }
            entity.a(DynamicGameEventListener::a);
            entity.valid = true;
            WorldServer.this.k().b(entity);
            if (entity.getOriginVector() == null) {
                entity.setOrigin(entity.getBukkitEntity().getLocation());
            }
            if (entity.getOriginWorld() == null) {
                entity.setOrigin(entity.getOriginVector().toLocation((World)WorldServer.this.getWorld()));
            }
            new EntityAddToWorldEvent((Entity)entity.getBukkitEntity()).callEvent();
        }

        @Override
        public void f(net.minecraft.world.entity.Entity entity) {
            AsyncCatcher.catchOp("entity unregister");
            if (entity instanceof EntityHuman) {
                Streams.stream(WorldServer.this.n().F()).map(WorldServer::s).forEach(worldData -> {
                    for (PersistentBase o2 : worldData.b.values()) {
                        if (!(o2 instanceof WorldMap)) continue;
                        WorldMap map = (WorldMap)o2;
                        map.o.remove((EntityHuman)entity);
                        Iterator<WorldMap.WorldMapHumanTracker> iter = map.n.iterator();
                        while (iter.hasNext()) {
                            if (iter.next().a != entity) continue;
                            map.q.remove(entity.Z().getString());
                            iter.remove();
                        }
                    }
                });
            }
            if (entity.getBukkitEntity() instanceof InventoryHolder && (!(entity instanceof EntityPlayer) || entity.dE() != Entity.RemovalReason.a)) {
                Object merchant;
                CraftEntity craftEntity = entity.getBukkitEntity();
                if (craftEntity instanceof Merchant && (merchant = (Merchant)craftEntity).getTrader() != null) {
                    merchant.getTrader().closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                }
                for (HumanEntity h2 : Lists.newArrayList((Iterable)((InventoryHolder)entity.getBukkitEntity()).getInventory().getViewers())) {
                    h2.closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                }
            }
            WorldServer.this.k().a(entity);
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                WorldServer.this.H.remove(entityplayer);
                WorldServer.this.e();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                WorldServer.this.T.remove(entityinsentient);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.fV()) {
                    WorldServer.this.aa.remove(entitycomplexpart.af());
                }
            }
            entity.a(DynamicGameEventListener::b);
            entity.valid = false;
            if (!(entity instanceof EntityPlayer)) {
                for (EntityPlayer player : WorldServer.this.H) {
                    player.getBukkitEntity().onEntityRemove(entity);
                }
            }
            new EntityRemoveFromWorldEvent((Entity)entity.getBukkitEntity()).callEvent();
        }

        @Override
        public void g(net.minecraft.world.entity.Entity entity) {
            entity.a(DynamicGameEventListener::c);
        }
    }
}

