/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import co.aikar.timings.MinecraftTimings;
import com.destroystokyo.paper.event.brigadier.AsyncPlayerSendSuggestionsEvent;
import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import com.destroystokyo.paper.event.player.PlayerRecipeBookClickEvent;
import com.destroystokyo.paper.event.player.PlayerUseUnknownEntityEvent;
import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import io.papermc.paper.adventure.ChatProcessor;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.entity.TeleportFlag;
import io.papermc.paper.event.player.PlayerArmSwingEvent;
import io.papermc.paper.event.player.PlayerFailMoveEvent;
import io.papermc.paper.event.player.PlayerPickItemEvent;
import io.papermc.paper.util.CachedLists;
import io.papermc.paper.util.CollisionUtil;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.TraceUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenMessagesValidator;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.network.protocol.game.PacketPlayInAbilities;
import net.minecraft.network.protocol.game.PacketPlayInAdvancements;
import net.minecraft.network.protocol.game.PacketPlayInArmAnimation;
import net.minecraft.network.protocol.game.PacketPlayInAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayInBEdit;
import net.minecraft.network.protocol.game.PacketPlayInBeacon;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayInBlockPlace;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.protocol.game.PacketPlayInChat;
import net.minecraft.network.protocol.game.PacketPlayInClientCommand;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayInCustomPayload;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyChange;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyLock;
import net.minecraft.network.protocol.game.PacketPlayInEnchantItem;
import net.minecraft.network.protocol.game.PacketPlayInEntityAction;
import net.minecraft.network.protocol.game.PacketPlayInEntityNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInFlying;
import net.minecraft.network.protocol.game.PacketPlayInHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayInItemName;
import net.minecraft.network.protocol.game.PacketPlayInJigsawGenerate;
import net.minecraft.network.protocol.game.PacketPlayInKeepAlive;
import net.minecraft.network.protocol.game.PacketPlayInPickItem;
import net.minecraft.network.protocol.game.PacketPlayInRecipeDisplayed;
import net.minecraft.network.protocol.game.PacketPlayInRecipeSettings;
import net.minecraft.network.protocol.game.PacketPlayInResourcePackStatus;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandBlock;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandMinecart;
import net.minecraft.network.protocol.game.PacketPlayInSetCreativeSlot;
import net.minecraft.network.protocol.game.PacketPlayInSetJigsaw;
import net.minecraft.network.protocol.game.PacketPlayInSettings;
import net.minecraft.network.protocol.game.PacketPlayInSpectate;
import net.minecraft.network.protocol.game.PacketPlayInSteerVehicle;
import net.minecraft.network.protocol.game.PacketPlayInStruct;
import net.minecraft.network.protocol.game.PacketPlayInTabComplete;
import net.minecraft.network.protocol.game.PacketPlayInTeleportAccept;
import net.minecraft.network.protocol.game.PacketPlayInTileNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInTrSel;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayInUseItem;
import net.minecraft.network.protocol.game.PacketPlayInVehicleMove;
import net.minecraft.network.protocol.game.PacketPlayInWindowClick;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutKeepAlive;
import net.minecraft.network.protocol.game.PacketPlayOutKickDisconnect;
import net.minecraft.network.protocol.game.PacketPlayOutNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutVehicleMove;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundPongPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.util.FutureChain;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_20_R1.util.LazyPlayerSet;
import org.bukkit.craftbukkit.v1_20_R1.util.UnsafeList;
import org.bukkit.craftbukkit.v1_20_R1.util.Waitable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotConfig;

public class PlayerConnection
implements ServerPlayerConnection,
TickablePacketListener,
PacketListenerPlayIn {
    static final Logger c = LogUtils.getLogger();
    private static final int d = 15000;
    public static final double a = MathHelper.k(6.0);
    private static final int e = -1;
    private static final int f = 4096;
    private static final IChatBaseComponent g = IChatBaseComponent.c("multiplayer.disconnect.chat_validation_failed");
    public final NetworkManager h;
    private final MinecraftServer i;
    public EntityPlayer b;
    private int j;
    private int k = -1;
    private long l = SystemUtils.b();
    private boolean m;
    private long n;
    private final AtomicInteger chatSpamTickCount = new AtomicInteger();
    private final AtomicInteger tabSpamLimiter = new AtomicInteger();
    private final AtomicInteger recipeSpamPackets = new AtomicInteger();
    private int p;
    private double q;
    private double r;
    private double s;
    private double t;
    private double u;
    private double v;
    @Nullable
    private net.minecraft.world.entity.Entity w;
    private double x;
    private double y;
    private double z;
    private double A;
    private double B;
    private double C;
    @Nullable
    private Vec3D D;
    private int E;
    private int F;
    private boolean G;
    private int H;
    private boolean I;
    private int J;
    private int K;
    private int L;
    private final AtomicReference<Instant> M;
    @Nullable
    private RemoteChatSession N;
    private boolean hasLoggedExpiry = false;
    private SignedMessageChain.b O;
    private final LastSeenMessagesValidator P;
    private final MessageSignatureCache Q;
    private final FutureChain R;
    private static final long KEEPALIVE_LIMIT = Long.getLong("paper.playerconnection.keepalive", 30L) * 1000L;
    private static final int MAX_SIGN_LINE_LENGTH = Integer.getInteger("Paper.maxSignLength", 80);
    private String clientBrandName = null;
    private final CraftServer cserver;
    public boolean processedDisconnect;
    private int lastTick = MinecraftServer.currentTick;
    private int allowedPlayerTicks = 1;
    private int lastDropTick = MinecraftServer.currentTick;
    private int lastBookTick = MinecraftServer.currentTick;
    private int dropCount = 0;
    private double lastPosX = Double.MAX_VALUE;
    private double lastPosY = Double.MAX_VALUE;
    private double lastPosZ = Double.MAX_VALUE;
    private float lastPitch = Float.MAX_VALUE;
    private float lastYaw = Float.MAX_VALUE;
    private boolean justTeleported = false;
    private boolean hasMoved;
    private static final ExecutorService TAB_COMPLETE_EXECUTOR = Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Tab Complete Thread - #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(MinecraftServer.n)).build());
    private int limitedPackets;
    private long lastLimitedPacket = -1L;
    private static final MinecraftKey CUSTOM_REGISTER = new MinecraftKey("register");
    private static final MinecraftKey CUSTOM_UNREGISTER = new MinecraftKey("unregister");
    private static final MinecraftKey MINECRAFT_BRAND = new MinecraftKey("brand");

    public PlayerConnection(MinecraftServer server, NetworkManager connection, EntityPlayer player) {
        this.M = new AtomicReference<Instant>(Instant.EPOCH);
        this.P = new LastSeenMessagesValidator(20);
        this.Q = MessageSignatureCache.a();
        this.i = server;
        this.h = connection;
        connection.a(this);
        this.b = player;
        player.c = this;
        this.l = SystemUtils.b();
        player.T().a();
        this.O = server.aw() ? SignedMessageChain.b.a : SignedMessageChain.b.unsigned(player.ct());
        this.R = new FutureChain(server.chatExecutor);
        this.cserver = server.server;
    }

    public CraftPlayer getCraftPlayer() {
        return this.b == null ? null : this.b.getBukkitEntity();
    }

    @Override
    public void c() {
        int spam;
        if (this.k > -1) {
            this.a(new ClientboundBlockChangedAckPacket(this.k));
            this.k = -1;
        }
        this.d();
        this.b.J = this.b.dn();
        this.b.K = this.b.dp();
        this.b.L = this.b.dt();
        this.b.m();
        this.b.a(this.q, this.r, this.s, this.b.dy(), this.b.dA());
        ++this.j;
        this.L = this.K;
        if (this.G && !this.b.fy() && !this.b.bM() && !this.b.es()) {
            if (++this.H > 80) {
                c.warn("{} was kicked for floating too long!", (Object)this.b.Z().getString());
                this.disconnect(GlobalConfiguration.get().messages.kick.flyingPlayer, PlayerKickEvent.Cause.FLYING_PLAYER);
                return;
            }
        } else {
            this.G = false;
            this.H = 0;
        }
        this.w = this.b.cT();
        if (this.w != this.b && this.w.cL() == this.b) {
            this.x = this.w.dn();
            this.y = this.w.dp();
            this.z = this.w.dt();
            this.A = this.w.dn();
            this.B = this.w.dp();
            this.C = this.w.dt();
            if (this.I && this.b.cT().cL() == this.b) {
                if (++this.J > 80) {
                    c.warn("{} was kicked for floating a vehicle too long!", (Object)this.b.Z().getString());
                    this.disconnect(GlobalConfiguration.get().messages.kick.flyingVehicle, PlayerKickEvent.Cause.FLYING_VEHICLE);
                    return;
                }
            } else {
                this.I = false;
                this.J = 0;
            }
        } else {
            this.w = null;
            this.I = false;
            this.J = 0;
        }
        this.i.aN().a("keepAlive");
        long currentTime = SystemUtils.b();
        long elapsedTime = currentTime - this.l;
        if (this.m) {
            if (!this.processedDisconnect && elapsedTime >= KEEPALIVE_LIMIT) {
                c.warn("{} was kicked due to keepalive timeout!", (Object)this.b.cv());
                this.disconnect(IChatBaseComponent.a("disconnect.timeout", new Object[0]), PlayerKickEvent.Cause.TIMEOUT);
            }
        } else if (elapsedTime >= 15000L) {
            this.m = true;
            this.l = currentTime;
            this.n = currentTime;
            this.a(new PacketPlayOutKeepAlive(this.n));
        }
        this.i.aN().c();
        while ((spam = this.chatSpamTickCount.get()) > 0 && !this.chatSpamTickCount.compareAndSet(spam, spam - 1)) {
        }
        if (this.tabSpamLimiter.get() > 0) {
            this.tabSpamLimiter.getAndDecrement();
        }
        if (this.recipeSpamPackets.get() > 0) {
            this.recipeSpamPackets.getAndDecrement();
        }
        if (this.p > 0) {
            --this.p;
        }
        if (this.b.I() > 0L && this.i.al() > 0 && SystemUtils.b() - this.b.I() > (long)this.i.al() * 1000L * 60L && !this.b.g) {
            this.b.C();
            this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.idling"), PlayerKickEvent.Cause.IDLING);
        }
        if (!this.hasLoggedExpiry && this.N != null && this.N.e().b().a()) {
            c.info("Player profile key for {} has expired!", (Object)this.b.Z().getString());
            this.hasLoggedExpiry = true;
        }
    }

    public void d() {
        this.q = this.b.dn();
        this.r = this.b.dp();
        this.s = this.b.dt();
        this.t = this.b.dn();
        this.u = this.b.dp();
        this.v = this.b.dt();
    }

    @Override
    public boolean a() {
        return this.h.h();
    }

    private boolean g() {
        return this.i.a(this.b.fM());
    }

    @DoNotUse
    public void disconnect(String s2) {
        this.disconnect((Component)LegacyComponentSerializer.legacySection().deserialize(s2), PlayerKickEvent.Cause.UNKNOWN);
    }

    public void disconnect(String s2, PlayerKickEvent.Cause cause) {
        this.disconnect((Component)LegacyComponentSerializer.legacySection().deserialize(s2), cause);
    }

    @DoNotUse
    public void b(IChatBaseComponent reason) {
        this.disconnect(PaperAdventure.asAdventure(reason), PlayerKickEvent.Cause.UNKNOWN);
    }

    public void disconnect(IChatBaseComponent reason, PlayerKickEvent.Cause cause) {
        this.disconnect(PaperAdventure.asAdventure(reason), cause);
    }

    public void disconnect(final Component reason, final PlayerKickEvent.Cause cause) {
        if (this.processedDisconnect) {
            return;
        }
        if (!this.cserver.isPrimaryThread()) {
            Waitable waitable = new Waitable(){

                protected Object evaluate() {
                    PlayerConnection.this.disconnect(reason, cause);
                    return null;
                }
            };
            this.i.processQueue.add(waitable);
            try {
                waitable.get();
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e3) {
                throw new RuntimeException(e3);
            }
            return;
        }
        TranslatableComponent leaveMessage = Component.translatable((String)"multiplayer.player.left", (TextColor)NamedTextColor.YELLOW, (ComponentLike[])new ComponentLike[]{GlobalConfiguration.get().messages.useDisplayNameInQuitMessage ? this.b.getBukkitEntity().displayName() : Component.text((String)this.b.cv())});
        PlayerKickEvent event = new PlayerKickEvent((Player)this.b.getBukkitEntity(), reason, (Component)leaveMessage, cause);
        if (this.cserver.getServer().v()) {
            this.cserver.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return;
        }
        IChatBaseComponent ichatbasecomponent = PaperAdventure.asVanilla(event.reason());
        this.b.quitReason = PlayerQuitEvent.QuitReason.KICKED;
        this.h.a(new PacketPlayOutKickDisconnect(ichatbasecomponent), PacketSendListener.a(() -> this.h.a(ichatbasecomponent)));
        this.onDisconnect(ichatbasecomponent, event.leaveMessage());
        this.h.l();
        MinecraftServer minecraftserver = this.i;
        NetworkManager networkmanager = this.h;
        Objects.requireNonNull(this.h);
        minecraftserver.scheduleOnMain(networkmanager::m);
    }

    private <T, R> CompletableFuture<R> a(T text, BiFunction<ITextFilter, T, CompletableFuture<R>> filterer) {
        return filterer.apply(this.b.T(), (ITextFilter)text).thenApply(object -> {
            if (!this.a()) {
                c.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return object;
        });
    }

    private CompletableFuture<FilteredText> a(String text) {
        return this.a(text, ITextFilter::a);
    }

    private CompletableFuture<List<FilteredText>> a(List<String> texts) {
        return this.a(texts, ITextFilter::a);
    }

    @Override
    public void a(PacketPlayInSteerVehicle packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        this.b.a(packet.a(), packet.c(), packet.d(), packet.e());
    }

    private static boolean b(double x2, double y2, double z2, float yaw, float pitch) {
        return Double.isNaN(x2) || Double.isNaN(y2) || Double.isNaN(z2) || !Floats.isFinite((float)pitch) || !Floats.isFinite((float)yaw);
    }

    private static double a(double d2) {
        return MathHelper.a(d2, -3.0E7, 3.0E7);
    }

    private static double b(double d2) {
        return MathHelper.a(d2, -2.0E7, 2.0E7);
    }

    @Override
    public void a(PacketPlayInVehicleMove packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (PlayerConnection.b(packet.a(), packet.c(), packet.d(), packet.e(), packet.f())) {
            this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.invalid_vehicle_movement"), PlayerKickEvent.Cause.INVALID_VEHICLE_MOVEMENT);
        } else {
            net.minecraft.world.entity.Entity entity = this.b.cT();
            if (this.D != null || this.b.eT() || entity.dD()) {
                return;
            }
            if (entity != this.b && entity.cL() == this.b && entity == this.w) {
                EntityLiving entityliving;
                double d5;
                double d4;
                double d3;
                double d2;
                double d1;
                double d0;
                WorldServer worldserver = this.b.x();
                double fromX = d0 = entity.dn();
                double fromY = d1 = entity.dp();
                double fromZ = d2 = entity.dt();
                double toX = d3 = PlayerConnection.a(packet.a());
                double toY = d4 = PlayerConnection.b(packet.c());
                double toZ = d5 = PlayerConnection.a(packet.d());
                float f2 = MathHelper.g(packet.e());
                float f1 = MathHelper.g(packet.f());
                double d6 = d3 - this.x;
                double d7 = d4 - this.y;
                double d8 = d5 - this.z;
                double d9 = entity.dl().g();
                double currDeltaX = toX - fromX;
                double currDeltaY = toY - fromY;
                double currDeltaZ = toZ - fromZ;
                double d10 = Math.max(d6 * d6 + d7 * d7 + d8 * d8, currDeltaX * currDeltaX + currDeltaY * currDeltaY + currDeltaZ * currDeltaZ - 1.0);
                double otherFieldX = d3 - this.A;
                double otherFieldY = d4 - this.B - 1.0E-6;
                double otherFieldZ = d5 - this.C;
                d10 = Math.max(d10, otherFieldX * otherFieldX + otherFieldY * otherFieldY + otherFieldZ * otherFieldZ - 1.0);
                this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                this.lastTick = (int)(System.currentTimeMillis() / 50L);
                ++this.K;
                int i2 = this.K - this.L;
                if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                    c.debug(this.b.cv() + " is sending move packets too frequently (" + i2 + " packets since last tick)");
                    i2 = 1;
                }
                this.allowedPlayerTicks = d10 > 0.0 ? --this.allowedPlayerTicks : 20;
                double speed = this.b.fO().b ? (double)(this.b.fO().f * 20.0f) : (double)(this.b.fO().g * 10.0f);
                speed *= 2.0;
                if (!(!this.b.dI().paperConfig().chunks.preventMovingIntoUnloadedChunks || worldserver.areChunksLoadedForMove(this.b.cE().b(new Vec3D(toX, toY, toZ).d(this.b.dg()))) && worldserver.areChunksLoadedForMove(entity.cE().b(new Vec3D(toX, toY, toZ).d(entity.dg()))))) {
                    this.h.a(new PacketPlayOutVehicleMove(entity));
                    return;
                }
                if (d10 - d9 > Math.max(100.0, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed, 2.0)) && !this.g()) {
                    c.warn("{} (vehicle of {}) moved too quickly! {},{},{}", new Object[]{entity.Z().getString(), this.b.Z().getString(), d6, d7, d8});
                    this.h.a(new PacketPlayOutVehicleMove(entity));
                    return;
                }
                AxisAlignedBB oldBox = entity.cE();
                d6 = d3 - this.A;
                d7 = d4 - this.B - 1.0E-6;
                d8 = d5 - this.C;
                boolean flag1 = entity.Q;
                if (entity instanceof EntityLiving && (entityliving = (EntityLiving)entity).i_()) {
                    entityliving.n();
                }
                entity.a(EnumMoveType.b, new Vec3D(d6, d7, d8));
                boolean didCollide = toX != entity.dn() || toY != entity.dp() || toZ != entity.dt();
                double d11 = d7;
                d6 = d3 - entity.dn();
                d7 = d4 - entity.dp();
                if (d7 > -0.5 || d7 < 0.5) {
                    d7 = 0.0;
                }
                d8 = d5 - entity.dt();
                d10 = d6 * d6 + d7 * d7 + d8 * d8;
                boolean flag2 = false;
                if (d10 > SpigotConfig.movedWronglyThreshold) {
                    flag2 = true;
                    c.warn("{} (vehicle of {}) moved wrongly! {}", new Object[]{entity.Z().getString(), this.b.Z().getString(), Math.sqrt(d10)});
                }
                Location curPos = this.getCraftPlayer().getLocation();
                entity.a(d3, d4, d5, f2, f1);
                this.b.a(d3, d4, d5, this.b.dy(), this.b.dA());
                boolean teleportBack = flag2;
                if (!teleportBack) {
                    AxisAlignedBB newBox = entity.cE();
                    if (didCollide || !oldBox.equals(newBox)) {
                        teleportBack = this.hasNewCollision(worldserver, entity, oldBox, newBox);
                    }
                }
                if (teleportBack) {
                    entity.a(d0, d1, d2, f2, f1);
                    this.b.a(d0, d1, d2, this.b.dy(), this.b.dA());
                    this.h.a(new PacketPlayOutVehicleMove(entity));
                    return;
                }
                CraftPlayer player = this.getCraftPlayer();
                if (!this.hasMoved) {
                    this.lastPosX = curPos.getX();
                    this.lastPosY = curPos.getY();
                    this.lastPosZ = curPos.getZ();
                    this.lastYaw = curPos.getYaw();
                    this.lastPitch = curPos.getPitch();
                    this.hasMoved = true;
                }
                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                Location to = player.getLocation().clone();
                to.setX(packet.a());
                to.setY(packet.c());
                to.setZ(packet.d());
                to.setYaw(packet.e());
                to.setPitch(packet.f());
                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.b.eT()) {
                    this.lastPosX = to.getX();
                    this.lastPosY = to.getY();
                    this.lastPosZ = to.getZ();
                    this.lastYaw = to.getYaw();
                    this.lastPitch = to.getPitch();
                    Location oldTo = to.clone();
                    PlayerMoveEvent event = new PlayerMoveEvent((Player)player, from, to);
                    this.cserver.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        this.teleport(from);
                        return;
                    }
                    if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                        this.b.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                        return;
                    }
                    if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                        this.justTeleported = false;
                        return;
                    }
                }
                this.b.x().k().a(this.b);
                this.b.r(this.b.dn() - d0, this.b.dp() - d1, this.b.dt() - d2);
                this.I = d11 >= -0.03125 && !flag1 && !this.i.Z() && !entity.aR() && this.a(entity);
                this.A = entity.dn();
                this.B = entity.dp();
                this.C = entity.dt();
            }
        }
    }

    private boolean a(net.minecraft.world.entity.Entity entity) {
        AxisAlignedBB box = entity.cE().g(0.0625).b(0.0, -0.55, 0.0);
        int minX = MathHelper.a(box.a);
        int minY = MathHelper.a(box.b);
        int minZ = MathHelper.a(box.c);
        int maxX = MathHelper.a(box.d);
        int maxY = MathHelper.a(box.e);
        int maxZ = MathHelper.a(box.f);
        net.minecraft.world.level.World world = entity.dI();
        BlockPosition.MutableBlockPosition pos = new BlockPosition.MutableBlockPosition();
        for (int y2 = minY; y2 <= maxY; ++y2) {
            for (int z2 = minZ; z2 <= maxZ; ++z2) {
                for (int x2 = minX; x2 <= maxX; ++x2) {
                    pos.d(x2, y2, z2);
                    IBlockData type = world.getBlockStateIfLoaded(pos);
                    if (type == null || type.i()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void a(PacketPlayInTeleportAccept packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (packet.a() == this.E) {
            if (this.D == null) {
                this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.invalid_player_movement"), PlayerKickEvent.Cause.INVALID_PLAYER_MOVEMENT);
                return;
            }
            this.b.b(this.D.c, this.D.d, this.D.e, this.b.dy(), this.b.dA());
            this.t = this.D.c;
            this.u = this.D.d;
            this.v = this.D.e;
            if (this.b.K()) {
                this.b.L();
            }
            this.D = null;
            this.b.x().k().a(this.b);
        }
    }

    @Override
    public void a(PacketPlayInRecipeDisplayed packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        Optional<IRecipe<?>> optional = this.i.aE().a(packet.a());
        RecipeBookServer recipebookserver = this.b.E();
        Objects.requireNonNull(recipebookserver);
        optional.ifPresent(recipebookserver::e);
    }

    @Override
    public void a(PacketPlayInRecipeSettings packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        this.b.E().a(packet.a(), packet.c(), packet.d());
    }

    @Override
    public void a(PacketPlayInAdvancements packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (packet.c() == PacketPlayInAdvancements.Status.a) {
            MinecraftKey minecraftkey = packet.d();
            Advancement advancement = this.i.az().a(minecraftkey);
            if (advancement != null) {
                this.b.M().a(advancement);
            }
        }
    }

    @Override
    public void a(PacketPlayInTabComplete packet) {
        if (this.chatSpamTickCount.addAndGet(GlobalConfiguration.get().spamLimiter.tabSpamIncrement) > GlobalConfiguration.get().spamLimiter.tabSpamLimit && !this.i.ac().f(this.b.fM())) {
            this.i.scheduleOnMain(() -> this.disconnect(IChatBaseComponent.a("disconnect.spam", new Object[0]), PlayerKickEvent.Cause.SPAM));
            return;
        }
        String str = packet.c();
        int index = -1;
        if (str.length() > 64 && ((index = str.indexOf(32)) == -1 || index >= 64)) {
            this.i.scheduleOnMain(() -> this.disconnect(IChatBaseComponent.a("disconnect.spam", new Object[0]), PlayerKickEvent.Cause.SPAM));
            return;
        }
        if (SpigotConfig.tabComplete < 0) {
            return;
        }
        TAB_COMPLETE_EXECUTOR.execute(() -> {
            Object completions;
            StringReader stringreader = new StringReader(packet.c());
            if (stringreader.canRead() && stringreader.peek() == '/') {
                stringreader.skip();
            }
            String command = packet.c();
            AsyncTabCompleteEvent event = new AsyncTabCompleteEvent((CommandSender)this.getCraftPlayer(), command, true, null);
            event.callEvent();
            Object object = completions = event.isCancelled() ? ImmutableList.of() : event.completions();
            if (!event.isHandled()) {
                if (!event.isCancelled()) {
                    this.i.scheduleOnMain(() -> {
                        ParseResults<CommandListenerWrapper> parseresults = this.i.aC().a().parse(stringreader, this.b.da());
                        this.i.aC().a().getCompletionSuggestions(parseresults).thenAccept(suggestions -> {
                            if (!SpigotConfig.sendNamespaced && suggestions.getRange().getStart() <= 1) {
                                suggestions.getList().removeIf(suggestion -> suggestion.getText().contains(":"));
                            }
                            AsyncPlayerSendSuggestionsEvent suggestEvent = new AsyncPlayerSendSuggestionsEvent((Player)this.getCraftPlayer(), suggestions, command);
                            suggestEvent.setCancelled(suggestions.isEmpty());
                            if (!suggestEvent.callEvent()) {
                                return;
                            }
                            this.h.a(new PacketPlayOutTabComplete(packet.a(), suggestEvent.getSuggestions()));
                        });
                    });
                }
            } else if (!completions.isEmpty()) {
                SuggestionsBuilder builder0 = new SuggestionsBuilder(command, stringreader.getTotalLength());
                SuggestionsBuilder builder = builder0.createOffset(builder0.getInput().lastIndexOf(32) + 1);
                completions.forEach(completion -> {
                    Integer intSuggestion = Ints.tryParse((String)completion.suggestion());
                    if (intSuggestion != null) {
                        builder.suggest(intSuggestion.intValue(), (Message)PaperAdventure.asVanilla(completion.tooltip()));
                    } else {
                        builder.suggest(completion.suggestion(), (Message)PaperAdventure.asVanilla(completion.tooltip()));
                    }
                });
                Suggestions suggestions = (Suggestions)builder.buildFuture().join();
                AsyncPlayerSendSuggestionsEvent suggestEvent = new AsyncPlayerSendSuggestionsEvent((Player)this.getCraftPlayer(), suggestions, command);
                suggestEvent.setCancelled(suggestions.isEmpty());
                if (!suggestEvent.callEvent()) {
                    return;
                }
                this.h.a(new PacketPlayOutTabComplete(packet.a(), suggestEvent.getSuggestions()));
            }
        });
    }

    @Override
    public void a(PacketPlayInSetCommandBlock packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (!this.i.o()) {
            this.b.a(IChatBaseComponent.c("advMode.notEnabled"));
        } else if (!(this.b.gk() || this.b.f() && this.b.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.b.a(IChatBaseComponent.c("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract commandblocklistenerabstract = null;
            TileEntityCommand tileentitycommand = null;
            BlockPosition blockposition = packet.a();
            TileEntity tileentity = this.b.dI().c_(blockposition);
            if (tileentity instanceof TileEntityCommand) {
                tileentitycommand = (TileEntityCommand)tileentity;
                commandblocklistenerabstract = tileentitycommand.c();
            }
            String s2 = packet.c();
            boolean flag = packet.d();
            if (commandblocklistenerabstract != null) {
                TileEntityCommand.Type tileentitycommand_type = tileentitycommand.v();
                IBlockData iblockdata = this.b.dI().a_(blockposition);
                EnumDirection enumdirection = iblockdata.c(BlockCommand.a);
                IBlockData iblockdata2 = (IBlockData)((IBlockData)(switch (packet.g()) {
                    case TileEntityCommand.Type.a -> Blocks.kH.n();
                    case TileEntityCommand.Type.b -> Blocks.kG.n();
                    default -> Blocks.fN.n();
                }).a(BlockCommand.a, enumdirection)).a(BlockCommand.b, packet.e());
                if (iblockdata2 != iblockdata) {
                    this.b.dI().a(blockposition, iblockdata2, 2);
                    tileentity.b(iblockdata2);
                    this.b.dI().l(blockposition).a(tileentity);
                }
                commandblocklistenerabstract.a(s2);
                commandblocklistenerabstract.a(flag);
                if (!flag) {
                    commandblocklistenerabstract.c(null);
                }
                tileentitycommand.b(packet.f());
                if (tileentitycommand_type != packet.g()) {
                    tileentitycommand.g();
                }
                commandblocklistenerabstract.f();
                if (!UtilColor.b(s2)) {
                    this.b.a(IChatBaseComponent.a("advMode.setCommand.success", new Object[]{s2}));
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSetCommandMinecart packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (!this.i.o()) {
            this.b.a(IChatBaseComponent.c("advMode.notEnabled"));
        } else if (!(this.b.gk() || this.b.f() && this.b.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.b.a(IChatBaseComponent.c("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract commandblocklistenerabstract = packet.a(this.b.dI());
            if (commandblocklistenerabstract != null) {
                commandblocklistenerabstract.a(packet.a());
                commandblocklistenerabstract.a(packet.c());
                if (!packet.c()) {
                    commandblocklistenerabstract.c(null);
                }
                commandblocklistenerabstract.f();
                this.b.a(IChatBaseComponent.a("advMode.setCommand.success", new Object[]{packet.a()}));
            }
        }
    }

    @Override
    public void a(PacketPlayInPickItem packet) {
        int sourceSlot;
        int targetSlot;
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (packet.a() < 0 || packet.a() >= this.b.fN().i.size()) {
            c.warn("{} tried to set an invalid carried item", (Object)this.b.Z().getString());
            this.disconnect("Invalid hotbar selection (Hacking?)", PlayerKickEvent.Cause.ILLEGAL_ACTION);
            return;
        }
        CraftPlayer bukkitPlayer = this.b.getBukkitEntity();
        PlayerPickItemEvent event = new PlayerPickItemEvent((Player)bukkitPlayer, targetSlot = this.b.fN().i(), sourceSlot = packet.a());
        if (!event.callEvent()) {
            return;
        }
        this.b.fN().pickSlot(event.getSourceSlot(), event.getTargetSlot());
        this.b.c.a(new PacketPlayOutSetSlot(-2, 0, this.b.fN().l, this.b.fN().a(this.b.fN().l)));
        this.b.c.a(new PacketPlayOutSetSlot(-2, 0, packet.a(), this.b.fN().a(packet.a())));
        this.b.c.a(new PacketPlayOutHeldItemSlot(this.b.fN().l));
    }

    @Override
    public void a(PacketPlayInItemName packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        Container container = this.b.bR;
        if (container instanceof ContainerAnvil) {
            ContainerAnvil containeranvil = (ContainerAnvil)container;
            if (!containeranvil.a(this.b)) {
                c.debug("Player {} interacted with invalid menu {}", (Object)this.b, (Object)containeranvil);
                return;
            }
            containeranvil.a(packet.a());
        }
    }

    @Override
    public void a(PacketPlayInBeacon packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        Container container = this.b.bR;
        if (container instanceof ContainerBeacon) {
            ContainerBeacon containerbeacon = (ContainerBeacon)container;
            if (!this.b.bR.a(this.b)) {
                c.debug("Player {} interacted with invalid menu {}", (Object)this.b, (Object)this.b.bR);
                return;
            }
            containerbeacon.a(packet.a(), packet.c());
        }
    }

    @Override
    public void a(PacketPlayInStruct packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.gk()) {
            BlockPosition blockposition = packet.a();
            IBlockData iblockdata = this.b.dI().a_(blockposition);
            TileEntity tileentity = this.b.dI().c_(blockposition);
            if (tileentity instanceof TileEntityStructure) {
                TileEntityStructure tileentitystructure = (TileEntityStructure)tileentity;
                tileentitystructure.a(packet.d());
                tileentitystructure.a(packet.e());
                tileentitystructure.a(packet.f());
                tileentitystructure.a(packet.g());
                tileentitystructure.a(packet.h());
                tileentitystructure.a(packet.i());
                tileentitystructure.b(packet.j());
                tileentitystructure.a(packet.k());
                tileentitystructure.d(packet.l());
                tileentitystructure.e(packet.m());
                tileentitystructure.a(packet.n());
                tileentitystructure.a(packet.o());
                if (tileentitystructure.g()) {
                    String s2 = tileentitystructure.d();
                    if (packet.c() == TileEntityStructure.UpdateType.b) {
                        if (tileentitystructure.D()) {
                            this.b.a(IChatBaseComponent.a("structure_block.save_success", new Object[]{s2}), false);
                        } else {
                            this.b.a(IChatBaseComponent.a("structure_block.save_failure", new Object[]{s2}), false);
                        }
                    } else if (packet.c() == TileEntityStructure.UpdateType.c) {
                        if (!tileentitystructure.F()) {
                            this.b.a(IChatBaseComponent.a("structure_block.load_not_found", new Object[]{s2}), false);
                        } else if (tileentitystructure.a(this.b.x())) {
                            this.b.a(IChatBaseComponent.a("structure_block.load_success", new Object[]{s2}), false);
                        } else {
                            this.b.a(IChatBaseComponent.a("structure_block.load_prepare", new Object[]{s2}), false);
                        }
                    } else if (packet.c() == TileEntityStructure.UpdateType.d) {
                        if (tileentitystructure.C()) {
                            this.b.a(IChatBaseComponent.a("structure_block.size_success", new Object[]{s2}), false);
                        } else {
                            this.b.a(IChatBaseComponent.c("structure_block.size_failure"), false);
                        }
                    }
                } else {
                    this.b.a(IChatBaseComponent.a("structure_block.invalid_structure_name", new Object[]{packet.e()}), false);
                }
                tileentitystructure.e();
                this.b.dI().a(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void a(PacketPlayInSetJigsaw packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.gk()) {
            BlockPosition blockposition = packet.a();
            IBlockData iblockdata = this.b.dI().a_(blockposition);
            TileEntity tileentity = this.b.dI().c_(blockposition);
            if (tileentity instanceof TileEntityJigsaw) {
                TileEntityJigsaw tileentityjigsaw = (TileEntityJigsaw)tileentity;
                tileentityjigsaw.a(packet.c());
                tileentityjigsaw.b(packet.d());
                tileentityjigsaw.a(ResourceKey.a(Registries.aC, packet.e()));
                tileentityjigsaw.a(packet.f());
                tileentityjigsaw.a(packet.g());
                tileentityjigsaw.e();
                this.b.dI().a(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void a(PacketPlayInJigsawGenerate packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.gk()) {
            BlockPosition blockposition = packet.a();
            TileEntity tileentity = this.b.dI().c_(blockposition);
            if (tileentity instanceof TileEntityJigsaw) {
                TileEntityJigsaw tileentityjigsaw = (TileEntityJigsaw)tileentity;
                tileentityjigsaw.a(this.b.x(), packet.c(), packet.d());
            }
        }
    }

    @Override
    public void a(PacketPlayInTrSel packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        int i2 = packet.a();
        Container container = this.b.bR;
        if (container instanceof ContainerMerchant) {
            ContainerMerchant containermerchant = (ContainerMerchant)container;
            TradeSelectEvent tradeSelectEvent = CraftEventFactory.callTradeSelectEvent(this.b, i2, containermerchant);
            if (tradeSelectEvent.isCancelled()) {
                this.b.getBukkitEntity().updateInventory();
                return;
            }
            if (!containermerchant.a(this.b)) {
                c.debug("Player {} interacted with invalid menu {}", (Object)this.b, (Object)containermerchant);
                return;
            }
            containermerchant.e(i2);
            containermerchant.h(i2);
        }
    }

    @Override
    public void a(PacketPlayInBEdit packet) {
        if (!this.cserver.isPrimaryThread()) {
            List<String> pageList = packet.a();
            long byteTotal = 0L;
            int maxBookPageSize = GlobalConfiguration.get().itemValidation.bookSize.pageMax;
            double multiplier = Math.max(0.3, Math.min(1.0, GlobalConfiguration.get().itemValidation.bookSize.totalMultiplier));
            long byteAllowed = maxBookPageSize;
            for (String testString : pageList) {
                int byteLength = testString.getBytes(StandardCharsets.UTF_8).length;
                if (byteLength > 1024) {
                    c.warn(this.b.cv() + " tried to send a book with with a page too large!");
                    this.i.scheduleOnMain(() -> this.disconnect("Book too large!", PlayerKickEvent.Cause.ILLEGAL_ACTION));
                    return;
                }
                byteTotal += (long)byteLength;
                int length = testString.length();
                int multibytes = 0;
                if (byteLength != length) {
                    for (char c2 : testString.toCharArray()) {
                        if (c2 <= '\u007f') continue;
                        ++multibytes;
                    }
                }
                byteAllowed = (long)((double)byteAllowed + (double)maxBookPageSize * Math.min(1.0, Math.max(0.1, (double)length / 255.0)) * multiplier);
                if (multibytes <= 1) continue;
                byteAllowed -= (long)multibytes;
            }
            if (byteTotal > byteAllowed) {
                c.warn(this.b.cv() + " tried to send too large of a book. Book Size: " + byteTotal + " - Allowed:  " + byteAllowed + " - Pages: " + pageList.size());
                this.i.scheduleOnMain(() -> this.disconnect("Book too large!", PlayerKickEvent.Cause.ILLEGAL_ACTION));
                return;
            }
        }
        if (this.lastBookTick + 20 > MinecraftServer.currentTick) {
            this.i.scheduleOnMain(() -> this.disconnect("Book edited too quickly!", PlayerKickEvent.Cause.ILLEGAL_ACTION));
            return;
        }
        this.lastBookTick = MinecraftServer.currentTick;
        int i2 = packet.d();
        if (PlayerInventory.d(i2) || i2 == 40) {
            ArrayList list = Lists.newArrayList();
            Optional<String> optional = packet.c();
            Objects.requireNonNull(list);
            optional.ifPresent(list::add);
            Stream stream = packet.a().stream().limit(100L);
            Objects.requireNonNull(list);
            stream.forEach(list::add);
            Consumer<List> consumer = optional.isPresent() ? list1 -> this.a((FilteredText)list1.get(0), list1.subList(1, list1.size()), i2) : list1 -> this.a((List<FilteredText>)list1, i2);
            this.a(list).thenAcceptAsync(consumer, (Executor)this.i);
        }
    }

    private void a(List<FilteredText> pages, int slotId) {
        ItemStack itemstack = this.b.fN().a(slotId);
        if (itemstack.a(Items.tg)) {
            this.updateBookPages(pages, UnaryOperator.identity(), itemstack.p(), slotId, itemstack);
        }
    }

    private void a(FilteredText title, List<FilteredText> pages, int slotId) {
        ItemStack itemstack = this.b.fN().a(slotId);
        if (itemstack.a(Items.tg)) {
            ItemStack itemstack1 = new ItemStack(Items.th);
            NBTTagCompound nbttagcompound = itemstack.v();
            if (nbttagcompound != null) {
                itemstack1.c(nbttagcompound.h());
            }
            itemstack1.a("author", NBTTagString.a(this.b.Z().getString()));
            if (this.b.U()) {
                itemstack1.a("title", NBTTagString.a(title.b()));
            } else {
                itemstack1.a("filtered_title", NBTTagString.a(title.b()));
                itemstack1.a("title", NBTTagString.a(title.d()));
            }
            this.updateBookPages(pages, s2 -> IChatBaseComponent.ChatSerializer.a(IChatBaseComponent.b(s2)), itemstack1, slotId, itemstack);
            this.b.fN().a(slotId, itemstack);
        }
    }

    private void updateBookPages(List<FilteredText> list, UnaryOperator<String> unaryoperator, ItemStack itemstack, int slot, ItemStack handItem) {
        NBTTagList nbttaglist = new NBTTagList();
        if (this.b.U()) {
            Stream<NBTTagString> stream = list.stream().map(filteredtext -> NBTTagString.a((String)unaryoperator.apply(filteredtext.b())));
            Objects.requireNonNull(nbttaglist);
            stream.forEach(nbttaglist::add);
        } else {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            int j2 = list.size();
            for (int i2 = 0; i2 < j2; ++i2) {
                FilteredText filteredtext2 = list.get(i2);
                String s2 = filteredtext2.d();
                nbttaglist.add(NBTTagString.a((String)unaryoperator.apply(s2)));
                if (!filteredtext2.c()) continue;
                nbttagcompound.a(String.valueOf(i2), (String)unaryoperator.apply(filteredtext2.b()));
            }
            if (!nbttagcompound.g()) {
                itemstack.a("filtered_pages", nbttagcompound);
            }
        }
        itemstack.a("pages", nbttaglist);
        this.b.fN().a(slot, CraftEventFactory.handleEditBookEvent(this.b, slot, handItem, itemstack));
    }

    @Override
    public void a(PacketPlayInEntityNBTQuery packet) {
        net.minecraft.world.entity.Entity entity;
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.l(2) && (entity = this.b.dI().a(packet.c())) != null) {
            NBTTagCompound nbttagcompound = entity.f(new NBTTagCompound());
            this.b.c.a(new PacketPlayOutNBTQuery(packet.a(), nbttagcompound));
        }
    }

    @Override
    public void a(PacketPlayInTileNBTQuery packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.l(2)) {
            TileEntity tileentity = this.b.dI().c_(packet.c());
            NBTTagCompound nbttagcompound = tileentity != null ? tileentity.o() : null;
            this.b.c.a(new PacketPlayOutNBTQuery(packet.a(), nbttagcompound));
        }
    }

    @Override
    public void a(PacketPlayInFlying packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (PlayerConnection.b(packet.a(0.0), packet.b(0.0), packet.c(0.0), packet.a(0.0f), packet.b(0.0f))) {
            this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.invalid_player_movement"), PlayerKickEvent.Cause.INVALID_PLAYER_MOVEMENT);
        } else {
            WorldServer worldserver = this.b.x();
            if (!this.b.g && !this.b.eT()) {
                if (this.j == 0) {
                    this.d();
                }
                if (this.D != null) {
                    this.allowedPlayerTicks = 20;
                } else {
                    float f1;
                    float f2;
                    double d2;
                    double d1;
                    double d0;
                    this.F = this.j;
                    double toX = d0 = PlayerConnection.a(packet.a(this.b.dn()));
                    double toY = d1 = PlayerConnection.b(packet.b(this.b.dp()));
                    double toZ = d2 = PlayerConnection.a(packet.c(this.b.dt()));
                    float toYaw = f2 = MathHelper.g(packet.a(this.b.dy()));
                    float toPitch = f1 = MathHelper.g(packet.b(this.b.dA()));
                    if (this.b.bM()) {
                        this.b.a(this.b.dn(), this.b.dp(), this.b.dt(), f2, f1);
                        this.b.x().k().a(this.b);
                        this.allowedPlayerTicks = 20;
                    } else {
                        double prevX = this.b.dn();
                        double prevY = this.b.dp();
                        double prevZ = this.b.dt();
                        float prevYaw = this.b.dy();
                        float prevPitch = this.b.dA();
                        double d3 = this.b.dn();
                        double d4 = this.b.dp();
                        double d5 = this.b.dt();
                        double d6 = d0 - this.q;
                        double d7 = d1 - this.r;
                        double d8 = d2 - this.s;
                        double d9 = this.b.dl().g();
                        double currDeltaX = toX - prevX;
                        double currDeltaY = toY - prevY;
                        double currDeltaZ = toZ - prevZ;
                        double d10 = Math.max(d6 * d6 + d7 * d7 + d8 * d8, currDeltaX * currDeltaX + currDeltaY * currDeltaY + currDeltaZ * currDeltaZ - 1.0);
                        double otherFieldX = d0 - this.t;
                        double otherFieldY = d1 - this.u;
                        double otherFieldZ = d2 - this.v;
                        d10 = Math.max(d10, otherFieldX * otherFieldX + otherFieldY * otherFieldY + otherFieldZ * otherFieldZ - 1.0);
                        if (this.b.fy()) {
                            if (d10 > 1.0) {
                                this.a(this.b.dn(), this.b.dp(), this.b.dt(), f2, f1);
                            }
                        } else {
                            PlayerFailMoveEvent event;
                            boolean didCollide;
                            boolean flag;
                            PlayerFailMoveEvent event2;
                            ++this.K;
                            int i2 = this.K - this.L;
                            this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                            this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                            this.lastTick = (int)(System.currentTimeMillis() / 50L);
                            if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                                c.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.b.Z().getString(), (Object)i2);
                                i2 = 1;
                            }
                            this.allowedPlayerTicks = packet.h || d10 > 0.0 ? --this.allowedPlayerTicks : 20;
                            double speed = this.b.fO().b ? (double)(this.b.fO().f * 20.0f) : (double)(this.b.fO().g * 10.0f);
                            if (!(!this.b.dI().paperConfig().chunks.preventMovingIntoUnloadedChunks || this.b.dn() == toX && this.b.dt() == toZ || worldserver.areChunksLoadedForMove(this.b.cE().b(new Vec3D(toX, toY, toZ).d(this.b.dg()))) || (event2 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_INTO_UNLOADED_CHUNK, toX, toY, toZ, toYaw, toPitch, false)).isAllowed())) {
                                this.internalTeleport(this.b.dn(), this.b.dp(), this.b.dt(), this.b.dy(), this.b.dA(), Collections.emptySet());
                                return;
                            }
                            if (!(this.b.K() || this.b.dI().X().b(GameRules.s) && this.b.fr())) {
                                PlayerFailMoveEvent event3;
                                float f22;
                                float f3 = f22 = this.b.fr() ? 300.0f : 100.0f;
                                if (d10 - d9 > Math.max((double)f22, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed, 2.0)) && !this.g() && !(event3 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_TOO_QUICKLY, toX, toY, toZ, toYaw, toPitch, true)).isAllowed()) {
                                    if (event3.getLogWarning()) {
                                        c.warn("{} moved too quickly! {},{},{}", new Object[]{this.b.Z().getString(), d6, d7, d8});
                                    }
                                    this.a(this.b.dn(), this.b.dp(), this.b.dt(), this.b.dy(), this.b.dA());
                                    return;
                                }
                            }
                            AxisAlignedBB axisalignedbb = this.b.cE();
                            d6 = d0 - this.t;
                            d7 = d1 - this.u;
                            d8 = d2 - this.v;
                            boolean bl = flag = d7 > 0.0;
                            if (this.b.ay() && !packet.a() && flag) {
                                PlayerJumpEvent event4;
                                CraftPlayer player = this.getCraftPlayer();
                                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                Location to = player.getLocation().clone();
                                if (packet.g) {
                                    to.setX(packet.a);
                                    to.setY(packet.b);
                                    to.setZ(packet.c);
                                }
                                if (packet.h) {
                                    to.setYaw(packet.d);
                                    to.setPitch(packet.e);
                                }
                                if ((event4 = new PlayerJumpEvent((Player)player, from, to)).callEvent()) {
                                    this.b.eW();
                                } else {
                                    from = event4.getFrom();
                                    this.internalTeleport(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch(), Collections.emptySet());
                                    return;
                                }
                            }
                            boolean flag1 = this.b.Q;
                            this.b.a(EnumMoveType.b, new Vec3D(d6, d7, d8));
                            ((net.minecraft.world.entity.Entity)this.b).aJ = packet.a();
                            boolean bl2 = didCollide = toX != this.b.dn() || toY != this.b.dp() || toZ != this.b.dt();
                            if (this.D != null) {
                                return;
                            }
                            double d11 = d7;
                            d6 = d0 - this.b.dn();
                            d7 = d1 - this.b.dp();
                            if (d7 > -0.5 || d7 < 0.5) {
                                d7 = 0.0;
                            }
                            d8 = d2 - this.b.dt();
                            d10 = d6 * d6 + d7 * d7 + d8 * d8;
                            boolean flag2 = false;
                            if (!(this.b.K() || !(d10 > SpigotConfig.movedWronglyThreshold) || this.b.fy() || this.b.e.e() || this.b.e.b() == EnumGamemode.d || (event = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_WRONGLY, toX, toY, toZ, toYaw, toPitch, true)).isAllowed())) {
                                flag2 = true;
                                if (event.getLogWarning()) {
                                    c.warn("{} moved wrongly!", (Object)this.b.Z().getString());
                                }
                            }
                            this.b.a(d0, d1, d2, f2, f1);
                            boolean teleportBack = flag2;
                            if (!(this.b.ae || this.b.fy() || teleportBack)) {
                                PlayerFailMoveEvent event5;
                                AxisAlignedBB newBox = this.b.cE();
                                if ((didCollide || !axisalignedbb.equals(newBox)) && (teleportBack = this.hasNewCollision(worldserver, this.b, axisalignedbb, newBox)) && (event5 = this.fireFailMove(PlayerFailMoveEvent.FailReason.CLIPPED_INTO_BLOCK, toX, toY, toZ, toYaw, toPitch, false)).isAllowed()) {
                                    teleportBack = false;
                                }
                            }
                            if (!this.b.ae && !this.b.fy() && teleportBack) {
                                this.internalTeleport(d3, d4, d5, f2, f1, Collections.emptySet());
                                this.b.a(this.b.dn() - d3, this.b.dp() - d4, this.b.dt() - d5, packet.a());
                            } else {
                                this.b.a(prevX, prevY, prevZ, prevYaw, prevPitch);
                                CraftPlayer player = this.getCraftPlayer();
                                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                Location to = player.getLocation().clone();
                                if (packet.g) {
                                    to.setX(packet.a);
                                    to.setY(packet.b);
                                    to.setZ(packet.c);
                                }
                                if (packet.h) {
                                    to.setYaw(packet.d);
                                    to.setPitch(packet.e);
                                }
                                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.b.eT()) {
                                    this.lastPosX = to.getX();
                                    this.lastPosY = to.getY();
                                    this.lastPosZ = to.getZ();
                                    this.lastYaw = to.getYaw();
                                    this.lastPitch = to.getPitch();
                                    if (from.getX() != Double.MAX_VALUE) {
                                        Location oldTo = to.clone();
                                        PlayerMoveEvent event6 = new PlayerMoveEvent((Player)player, from, to);
                                        this.cserver.getPluginManager().callEvent((Event)event6);
                                        if (event6.isCancelled()) {
                                            this.teleport(from);
                                            return;
                                        }
                                        if (!oldTo.equals((Object)event6.getTo()) && !event6.isCancelled()) {
                                            this.b.getBukkitEntity().teleport(event6.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                                            return;
                                        }
                                        if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                                            this.justTeleported = false;
                                            return;
                                        }
                                    }
                                }
                                this.b.a(d0, d1, d2, f2, f1);
                                this.G = d11 >= -0.03125 && !flag1 && this.b.e.b() != EnumGamemode.d && !this.i.Z() && !this.b.fO().c && !this.b.a(MobEffects.y) && !this.b.fr() && !this.b.fe() && this.a(this.b);
                                this.b.x().k().a(this.b);
                                this.b.a(this.b.dn() - d3, this.b.dp() - d4, this.b.dt() - d5, packet.a());
                                this.b.a(packet.a(), new Vec3D(this.b.dn() - d3, this.b.dp() - d4, this.b.dt() - d5));
                                if (flag) {
                                    this.b.n();
                                }
                                this.b.r(this.b.dn() - d3, this.b.dp() - d4, this.b.dt() - d5);
                                this.t = this.b.dn();
                                this.u = this.b.dp();
                                this.v = this.b.dt();
                            }
                        }
                    }
                }
            }
        }
    }

    private PlayerFailMoveEvent fireFailMove(PlayerFailMoveEvent.FailReason failReason, double toX, double toY, double toZ, float toYaw, float toPitch, boolean logWarning) {
        CraftPlayer player = this.getCraftPlayer();
        Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
        Location to = new Location(player.getWorld(), toX, toY, toZ, toYaw, toPitch);
        PlayerFailMoveEvent event = new PlayerFailMoveEvent((Player)player, failReason, false, logWarning, from, to);
        event.callEvent();
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasNewCollision(WorldServer world, net.minecraft.world.entity.Entity entity, AxisAlignedBB oldBox, AxisAlignedBB newBox) {
        UnsafeList<AxisAlignedBB> collisions = CachedLists.getTempCollisionList();
        try {
            CollisionUtil.getCollisions(world, entity, newBox, collisions, false, true, true, false, null, null);
            int len = collisions.size();
            for (int i2 = 0; i2 < len; ++i2) {
                AxisAlignedBB box = (AxisAlignedBB)collisions.get(i2);
                if (CollisionUtil.voxelShapeIntersect(box, oldBox)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            CachedLists.returnTempCollisionList(collisions);
        }
    }

    private boolean a(IWorldReader world, AxisAlignedBB box, double newX, double newY, double newZ) {
        VoxelShape voxelshape1;
        AxisAlignedBB axisalignedbb1 = this.b.cE().d(newX - this.b.dn(), newY - this.b.dp(), newZ - this.b.dt());
        Iterable<VoxelShape> iterable = world.c(this.b, axisalignedbb1.h(1.0E-5f));
        VoxelShape voxelshape = VoxelShapes.a(box.h(1.0E-5f));
        Iterator<VoxelShape> iterator = iterable.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (VoxelShapes.c(voxelshape1 = iterator.next(), voxelshape, OperatorBoolean.i));
        return true;
    }

    public void a(double x2, double y2, double z2, float yaw, float pitch) {
        this.teleport(x2, y2, z2, yaw, pitch, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public void teleport(double d0, double d1, double d2, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        this.teleport(d0, d1, d2, f2, f1, Collections.emptySet(), cause);
    }

    public void a(double x2, double y2, double z2, float yaw, float pitch, Set<RelativeMovement> flags) {
        this.teleport(x2, y2, z2, yaw, pitch, flags, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(double d0, double d1, double d2, float f2, float f1, Set<RelativeMovement> set, PlayerTeleportEvent.TeleportCause cause) {
        CraftPlayer player = this.getCraftPlayer();
        Location from = player.getLocation();
        double x2 = d0;
        double y2 = d1;
        double z2 = d2;
        float yaw = f2;
        float pitch = f1;
        Location to = new Location(this.getCraftPlayer().getWorld(), x2, y2, z2, yaw, pitch);
        if (from.equals((Object)to)) {
            this.internalTeleport(d0, d1, d2, f2, f1, set);
            return false;
        }
        EnumSet<TeleportFlag.Relative> relativeFlags = EnumSet.noneOf(TeleportFlag.Relative.class);
        for (RelativeMovement relativeArgument : set) {
            relativeFlags.add(CraftPlayer.toApiRelativeFlag(relativeArgument));
        }
        PlayerTeleportEvent event = new PlayerTeleportEvent((Player)player, from.clone(), to.clone(), cause, Set.copyOf(relativeFlags));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || !to.equals((Object)event.getTo())) {
            to = event.isCancelled() ? event.getFrom() : event.getTo();
            d0 = to.getX();
            d1 = to.getY();
            d2 = to.getZ();
            f2 = to.getYaw();
            f1 = to.getPitch();
        }
        this.internalTeleport(d0, d1, d2, f2, f1, set);
        return event.isCancelled();
    }

    public void teleport(Location dest) {
        this.internalTeleport(dest.getX(), dest.getY(), dest.getZ(), dest.getYaw(), dest.getPitch(), Collections.emptySet());
    }

    public void internalTeleport(double d0, double d1, double d2, float f2, float f1, Set<RelativeMovement> set) {
        AsyncCatcher.catchOp("teleport");
        if (this.b.dD()) {
            c.info("Attempt to teleport removed player {} restricted", (Object)this.b.cv());
            if (this.i.isDebugging()) {
                TraceUtil.dumpTraceForThread("Attempt to teleport removed player");
            }
            return;
        }
        if (Float.isNaN(f2)) {
            f2 = 0.0f;
        }
        if (Float.isNaN(f1)) {
            f1 = 0.0f;
        }
        this.justTeleported = true;
        double d3 = set.contains((Object)RelativeMovement.a) ? this.b.dn() : 0.0;
        double d4 = set.contains((Object)RelativeMovement.b) ? this.b.dp() : 0.0;
        double d5 = set.contains((Object)RelativeMovement.c) ? this.b.dt() : 0.0;
        float f22 = set.contains((Object)RelativeMovement.d) ? this.b.dy() : 0.0f;
        float f3 = set.contains((Object)RelativeMovement.e) ? this.b.dA() : 0.0f;
        this.D = new Vec3D(d0, d1, d2);
        if (++this.E == Integer.MAX_VALUE) {
            this.E = 0;
        }
        this.lastPosX = this.D.c;
        this.lastPosY = this.D.d;
        this.lastPosZ = this.D.e;
        this.lastYaw = f2;
        this.lastPitch = f1;
        this.F = this.j;
        this.b.b(d0, d1, d2, f2, f1);
        this.b.c.a(new PacketPlayOutPosition(d0 - d3, d1 - d4, d2 - d5, f2 - f22, f1 - f3, set, this.E));
    }

    @Override
    public void a(PacketPlayInBlockDig packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.eT()) {
            return;
        }
        BlockPosition blockposition = packet.a();
        this.b.C();
        PacketPlayInBlockDig.EnumPlayerDigType packetplayinblockdig_enumplayerdigtype = packet.d();
        switch (packetplayinblockdig_enumplayerdigtype) {
            case g: {
                if (!this.b.G_()) {
                    ItemStack itemstack = this.b.b(EnumHand.b);
                    CraftItemStack mainHand = CraftItemStack.asCraftMirror(itemstack);
                    CraftItemStack offHand = CraftItemStack.asCraftMirror(this.b.b(EnumHand.a));
                    PlayerSwapHandItemsEvent swapItemsEvent = new PlayerSwapHandItemsEvent((Player)this.getCraftPlayer(), (org.bukkit.inventory.ItemStack)mainHand.clone(), (org.bukkit.inventory.ItemStack)offHand.clone());
                    this.cserver.getPluginManager().callEvent((Event)swapItemsEvent);
                    if (swapItemsEvent.isCancelled()) {
                        return;
                    }
                    if (swapItemsEvent.getOffHandItem().equals((Object)offHand)) {
                        this.b.a(EnumHand.b, this.b.b(EnumHand.a));
                    } else {
                        this.b.a(EnumHand.b, CraftItemStack.asNMSCopy(swapItemsEvent.getOffHandItem()));
                    }
                    if (swapItemsEvent.getMainHandItem().equals((Object)mainHand)) {
                        this.b.a(EnumHand.a, itemstack);
                    } else {
                        this.b.a(EnumHand.a, CraftItemStack.asNMSCopy(swapItemsEvent.getMainHandItem()));
                    }
                    this.b.fo();
                }
                return;
            }
            case e: {
                if (!this.b.G_()) {
                    if (this.lastDropTick != MinecraftServer.currentTick) {
                        this.dropCount = 0;
                        this.lastDropTick = MinecraftServer.currentTick;
                    } else {
                        ++this.dropCount;
                        if (this.dropCount >= 20) {
                            c.warn(this.b.cv() + " dropped their items too quickly!");
                            this.disconnect("You dropped your items too quickly (Hacking?)", PlayerKickEvent.Cause.ILLEGAL_ACTION);
                            return;
                        }
                    }
                    this.b.a(false);
                }
                return;
            }
            case d: {
                if (!this.b.G_()) {
                    this.b.a(true);
                }
                return;
            }
            case f: {
                this.b.fn();
                return;
            }
            case a: 
            case b: 
            case c: {
                if (this.b.dI().getChunkIfLoadedImmediately(blockposition.u() >> 4, blockposition.w() >> 4) == null) {
                    this.b.c.a(packet.e());
                    return;
                }
                this.b.e.capturedBlockEntity = false;
                this.b.e.captureSentBlockEntities = true;
                this.b.e.a(blockposition, packetplayinblockdig_enumplayerdigtype, packet.c(), this.b.dI().aj(), packet.e());
                this.b.c.a(packet.e());
                this.b.e.captureSentBlockEntities = false;
                if (this.b.e.capturedBlockEntity) {
                    this.a(new ClientboundBlockChangedAckPacket(this.k));
                    this.b.c.k = -1;
                    this.b.e.capturedBlockEntity = false;
                    TileEntity tileentity = this.b.dI().c_(blockposition);
                    if (tileentity != null) {
                        this.b.c.a(tileentity.h());
                    }
                }
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    private static boolean a(EntityPlayer player, ItemStack stack) {
        if (stack.b()) {
            return false;
        }
        Item item = stack.d();
        return (item instanceof ItemBlock || item instanceof ItemBucket) && !player.gi().a(item);
    }

    private static int getSpamThreshold() {
        return GlobalConfiguration.get().spamLimiter.incomingPacketThreshold;
    }

    private boolean checkLimit(long timestamp) {
        if (this.lastLimitedPacket != -1L && timestamp - this.lastLimitedPacket < (long)PlayerConnection.getSpamThreshold() && this.limitedPackets++ >= 8) {
            return false;
        }
        if (this.lastLimitedPacket == -1L || timestamp - this.lastLimitedPacket >= (long)PlayerConnection.getSpamThreshold()) {
            this.lastLimitedPacket = timestamp;
            this.limitedPackets = 0;
            return true;
        }
        return true;
    }

    @Override
    public void a(PacketPlayInUseItem packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.eT()) {
            return;
        }
        if (!this.checkLimit(packet.timestamp)) {
            return;
        }
        this.b.c.a(packet.d());
        WorldServer worldserver = this.b.x();
        EnumHand enumhand = packet.a();
        ItemStack itemstack = this.b.b(enumhand);
        if (itemstack.a(worldserver.G())) {
            MovingObjectPositionBlock movingobjectpositionblock = packet.c();
            Vec3D vec3d = movingobjectpositionblock.e();
            if (!(Double.isFinite(vec3d.c) && Double.isFinite(vec3d.d) && Double.isFinite(vec3d.e))) {
                return;
            }
            BlockPosition blockposition = movingobjectpositionblock.a();
            Vec3D vec3d1 = Vec3D.b(blockposition);
            if (this.b.bm().g(vec3d1) <= a) {
                Vec3D vec3d2 = vec3d.d(vec3d1);
                double d0 = 1.0000001;
                if (Math.abs(vec3d2.a()) < 1.0000001 && Math.abs(vec3d2.b()) < 1.0000001 && Math.abs(vec3d2.c()) < 1.0000001) {
                    EnumDirection enumdirection = movingobjectpositionblock.b();
                    this.b.C();
                    int i2 = this.b.dI().aj();
                    if (blockposition.v() < i2) {
                        if (this.D == null && this.b.i((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5) < 64.0 && (worldserver.a((EntityHuman)this.b, blockposition) || worldserver.paperConfig().spawn.allowUsingSignsInsideSpawnProtection && worldserver.a_(blockposition).b() instanceof BlockSign)) {
                            this.b.fo();
                            EnumInteractionResult enuminteractionresult = this.b.e.a(this.b, worldserver, itemstack, enumhand, movingobjectpositionblock);
                            if (enumdirection == EnumDirection.b && !enuminteractionresult.a() && blockposition.v() >= i2 - 1 && PlayerConnection.a(this.b, itemstack)) {
                                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("build.tooHigh", i2 - 1).a(EnumChatFormat.m);
                                this.b.b(ichatmutablecomponent, true);
                            } else if (enuminteractionresult.b() && !this.b.e.interactResult) {
                                this.b.a(enumhand, true);
                            }
                        }
                    } else {
                        IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.a("build.tooHigh", i2 - 1).a(EnumChatFormat.m);
                        this.b.b(ichatmutablecomponent1, true);
                    }
                    this.b.c.a(new PacketPlayOutBlockChange(worldserver, blockposition));
                    this.b.c.a(new PacketPlayOutBlockChange(worldserver, blockposition.a(enumdirection)));
                } else {
                    c.warn("Rejecting UseItemOnPacket from {}: Location {} too far away from hit block {}.", new Object[]{this.b.fM().getName(), vec3d, blockposition});
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInBlockPlace packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.eT()) {
            return;
        }
        if (!this.checkLimit(packet.timestamp)) {
            return;
        }
        this.a(packet.c());
        WorldServer worldserver = this.b.x();
        EnumHand enumhand = packet.a();
        ItemStack itemstack = this.b.b(enumhand);
        this.b.C();
        if (!itemstack.b() && itemstack.a(worldserver.G())) {
            boolean cancelled;
            float f1 = this.b.dA();
            float f2 = this.b.dy();
            double d0 = this.b.dn();
            double d1 = this.b.dp() + (double)this.b.cF();
            double d2 = this.b.dt();
            Vec3D vec3d = new Vec3D(d0, d1, d2);
            float f3 = MathHelper.b(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
            float f4 = MathHelper.a(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
            float f5 = -MathHelper.b(-f1 * ((float)Math.PI / 180));
            float f6 = MathHelper.a(-f1 * ((float)Math.PI / 180));
            float f7 = f4 * f5;
            float f8 = f3 * f5;
            double d3 = this.b.e.b() == EnumGamemode.b ? 5.0 : 4.5;
            Vec3D vec3d1 = vec3d.b((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
            MovingObjectPositionBlock movingobjectposition = this.b.dI().a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.b));
            if (movingobjectposition == null || ((MovingObjectPosition)movingobjectposition).c() != MovingObjectPosition.EnumMovingObjectType.b) {
                PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.b, Action.RIGHT_CLICK_AIR, itemstack, enumhand);
                cancelled = event.useItemInHand() == Event.Result.DENY;
            } else {
                PlayerInteractEvent event;
                MovingObjectPositionBlock movingobjectpositionblock = movingobjectposition;
                cancelled = this.b.e.firedInteract && this.b.e.interactPosition.equals(movingobjectpositionblock.a()) && this.b.e.interactHand == enumhand && ItemStack.c(this.b.e.interactItemStack, itemstack) ? this.b.e.interactResult : (event = CraftEventFactory.callPlayerInteractEvent(this.b, Action.RIGHT_CLICK_BLOCK, movingobjectpositionblock.a(), movingobjectpositionblock.b(), itemstack, true, enumhand, movingobjectpositionblock.e())).useItemInHand() == Event.Result.DENY;
                this.b.e.firedInteract = false;
            }
            if (cancelled) {
                this.b.resyncUsingItem(this.b);
                this.b.getBukkitEntity().updateInventory();
                return;
            }
            itemstack = this.b.b(enumhand);
            if (itemstack.b()) {
                return;
            }
            EnumInteractionResult enuminteractionresult = this.b.e.a(this.b, worldserver, itemstack, enumhand);
            if (enuminteractionresult.b()) {
                this.b.a(enumhand, true);
            }
        }
    }

    @Override
    public void a(PacketPlayInSpectate packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.G_()) {
            for (WorldServer worldserver : this.i.F()) {
                net.minecraft.world.entity.Entity entity = packet.a(worldserver);
                if (entity == null) continue;
                this.b.teleportTo(worldserver, entity.dn(), entity.dp(), entity.dt(), entity.dy(), entity.dA(), PlayerTeleportEvent.TeleportCause.SPECTATE);
                return;
            }
        }
    }

    @Override
    public void a(PacketPlayInResourcePackStatus packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (packet.a() == PacketPlayInResourcePackStatus.EnumResourcePackStatus.b && this.i.T()) {
            c.info("Disconnecting {} due to resource pack rejection", (Object)this.b.fM().getName());
            this.disconnect(IChatBaseComponent.c("multiplayer.requiredTexturePrompt.disconnect"), PlayerKickEvent.Cause.RESOURCE_PACK_REJECTION);
        }
        PlayerResourcePackStatusEvent.Status packStatus = PlayerResourcePackStatusEvent.Status.values()[packet.a.ordinal()];
        this.b.getBukkitEntity().setResourcePackStatus(packStatus);
        this.cserver.getPluginManager().callEvent((Event)new PlayerResourcePackStatusEvent((Player)this.getCraftPlayer(), packStatus));
    }

    @Override
    public void a(PacketPlayInBoatMove packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        net.minecraft.world.entity.Entity entity = this.b.cX();
        if (entity instanceof EntityBoat) {
            EntityBoat entityboat = (EntityBoat)entity;
            entityboat.a(packet.a(), packet.c());
        }
    }

    @Override
    public void a(ServerboundPongPacket packet) {
    }

    @Override
    public void a(IChatBaseComponent reason) {
        this.onDisconnect(reason, null);
    }

    public void onDisconnect(IChatBaseComponent reason, @Nullable Component quitMessage) {
        if (this.processedDisconnect) {
            return;
        }
        this.processedDisconnect = true;
        this.R.close();
        c.info("{} lost connection: {}", (Object)this.b.Z().getString(), (Object)reason.getString());
        this.b.s();
        Component component = quitMessage = quitMessage == null ? this.i.ac().remove(this.b) : this.i.ac().remove(this.b, quitMessage);
        if (quitMessage != null && !quitMessage.equals(Component.empty())) {
            this.i.ac().a(PaperAdventure.asVanilla(quitMessage), false);
        }
        this.b.T().b();
        if (this.g()) {
            c.info("Stopping singleplayer server as player logged out");
            this.i.a(false);
        }
    }

    public void a(int sequence) {
        if (sequence < 0) {
            this.disconnect("Expected packet sequence nr >= 0", PlayerKickEvent.Cause.ILLEGAL_ACTION);
            throw new IllegalArgumentException("Expected packet sequence nr >= 0");
        }
        this.k = Math.max(sequence, this.k);
    }

    @Override
    public void a(Packet<?> packet) {
        this.a(packet, (PacketSendListener)null);
    }

    public void a(Packet<?> packet, @Nullable PacketSendListener callbacks) {
        if (packet == null || this.processedDisconnect) {
            return;
        }
        if (packet instanceof PacketPlayOutSpawnPosition) {
            PacketPlayOutSpawnPosition packet6 = (PacketPlayOutSpawnPosition)packet;
            this.b.compassTarget = CraftLocation.toBukkit(packet6.a, this.getCraftPlayer().getWorld());
        }
        try {
            this.h.a(packet, callbacks);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Sending packet");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Packet being sent");
            crashreportsystemdetails.a("Packet class", () -> packet.getClass().getCanonicalName());
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public void a(PacketPlayInHeldItemSlot packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.eT()) {
            return;
        }
        if (packet.a() >= 0 && packet.a() < PlayerInventory.g()) {
            if (packet.a() == this.b.fN().l) {
                return;
            }
            PlayerItemHeldEvent event = new PlayerItemHeldEvent((Player)this.getCraftPlayer(), this.b.fN().l, packet.a());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.a(new PacketPlayOutHeldItemSlot(this.b.fN().l));
                this.b.C();
                return;
            }
            if (this.b.fN().l != packet.a() && this.b.fj() == EnumHand.a) {
                this.b.fo();
            }
            this.b.fN().l = packet.a();
            this.b.C();
        } else {
            c.warn("{} tried to set an invalid carried item", (Object)this.b.Z().getString());
            this.disconnect("Invalid hotbar selection (Hacking?)", PlayerKickEvent.Cause.ILLEGAL_ACTION);
        }
    }

    @Override
    public void a(PacketPlayInChat packet) {
        if (this.i.ab()) {
            return;
        }
        if (PlayerConnection.c(packet.a())) {
            this.i.scheduleOnMain(() -> this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.illegal_characters"), PlayerKickEvent.Cause.ILLEGAL_CHARACTERS));
        } else {
            Optional<LastSeenMessages> optional = this.a(packet.a(), packet.c(), packet.f());
            if (optional.isPresent()) {
                PlayerChatMessage playerchatmessage;
                try {
                    playerchatmessage = this.a(packet, optional.get());
                }
                catch (SignedMessageChain.a signedmessagechain_a) {
                    this.a(signedmessagechain_a);
                    return;
                }
                CompletableFuture<FilteredText> completablefuture = this.a(playerchatmessage.b());
                CompletableFuture<ChatDecorator.Result> completablefuture1 = this.i.be().decorate(this.b, null, playerchatmessage.c());
                this.R.append(executor -> CompletableFuture.allOf(completablefuture, completablefuture1).thenAcceptAsync(ovoid -> {
                    PlayerChatMessage playerchatmessage1 = playerchatmessage.a(((FilteredText)completablefuture.join()).e()).withResult((ChatDecorator.Result)completablefuture1.join());
                    this.b(playerchatmessage1);
                }, (Executor)this.i.chatExecutor));
            }
        }
    }

    @Override
    public void a(ServerboundChatCommandPacket packet) {
        if (PlayerConnection.c(packet.a())) {
            this.i.scheduleOnMain(() -> this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.illegal_characters"), PlayerKickEvent.Cause.ILLEGAL_CHARACTERS));
        } else {
            Optional<LastSeenMessages> optional = this.a(packet.a(), packet.c(), packet.f());
            if (optional.isPresent()) {
                this.i.g(() -> {
                    if (this.b.t()) {
                        return;
                    }
                    this.a(packet, (LastSeenMessages)optional.get());
                    this.detectRateSpam("/" + packet.a());
                });
            }
        }
    }

    private void a(ServerboundChatCommandPacket packet, LastSeenMessages lastSeenMessages) {
        Map<String, PlayerChatMessage> map;
        Object command = "/" + packet.a();
        if (SpigotConfig.logCommands) {
            c.info(this.b.cv() + " issued server command: " + (String)command);
        }
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)this.getCraftPlayer(), (String)command, (Set)new LazyPlayerSet(this.i));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getMessage().substring(1);
        ParseResults<CommandListenerWrapper> parseresults = this.b((String)command);
        try {
            map = packet.a().equals(command) ? this.a(packet, SignableCommand.a(parseresults), lastSeenMessages) : Collections.emptyMap();
        }
        catch (SignedMessageChain.a signedmessagechain_a) {
            this.a(signedmessagechain_a);
            return;
        }
        CommandSigningContext.a commandsigningcontext_a = new CommandSigningContext.a(map);
        parseresults = net.minecraft.commands.CommandDispatcher.a(parseresults, commandlistenerwrapper -> commandlistenerwrapper.a(commandsigningcontext_a));
        this.i.aC().a(parseresults, (String)command);
    }

    private void a(SignedMessageChain.a exception) {
        if (exception.a()) {
            this.disconnect(exception.b(), exception.kickCause);
        } else {
            this.b.a(exception.b().e().a(EnumChatFormat.m));
        }
    }

    private Map<String, PlayerChatMessage> a(ServerboundChatCommandPacket packet, SignableCommand<?> arguments, LastSeenMessages lastSeenMessages) throws SignedMessageChain.a {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (SignableCommand.a<?> signablecommand_a : arguments.a()) {
            MessageSignature messagesignature = packet.e().a(signablecommand_a.a());
            SignedMessageBody signedmessagebody = new SignedMessageBody(signablecommand_a.c(), packet.c(), packet.d(), lastSeenMessages);
            map.put(signablecommand_a.a(), this.O.unpack(messagesignature, signedmessagebody));
        }
        return map;
    }

    private ParseResults<CommandListenerWrapper> b(String command) {
        CommandDispatcher<CommandListenerWrapper> com_mojang_brigadier_commanddispatcher = this.i.aC().a();
        return com_mojang_brigadier_commanddispatcher.parse(command, this.b.da());
    }

    private Optional<LastSeenMessages> a(String message, Instant timestamp, LastSeenMessages.b acknowledgment) {
        if (!this.a(timestamp)) {
            c.warn("{} sent out-of-order chat: '{}': {} > {}", new Object[]{this.b.Z().getString(), message, this.M.get().getEpochSecond(), timestamp.getEpochSecond()});
            this.i.scheduleOnMain(() -> this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.out_of_order_chat"), PlayerKickEvent.Cause.OUT_OF_ORDER_CHAT));
            return Optional.empty();
        }
        Optional<LastSeenMessages> optional = this.a(acknowledgment);
        if (this.b.dD() || this.b.A() == EnumChatVisibility.c) {
            this.a(new ClientboundSystemChatPacket(PaperAdventure.asAdventure(IChatBaseComponent.c("chat.disabled.options").a(EnumChatFormat.m)), false));
            return Optional.empty();
        }
        this.b.C();
        return optional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<LastSeenMessages> a(LastSeenMessages.b acknowledgment) {
        LastSeenMessagesValidator lastseenmessagesvalidator = this.P;
        LastSeenMessagesValidator lastSeenMessagesValidator = this.P;
        synchronized (lastSeenMessagesValidator) {
            Optional<LastSeenMessages> optional = this.P.a(acknowledgment);
            if (optional.isEmpty()) {
                c.warn("Failed to validate message acknowledgements from {}", (Object)this.b.Z().getString());
                this.disconnect(g, PlayerKickEvent.Cause.CHAT_VALIDATION_FAILED);
            }
            return optional;
        }
    }

    private boolean a(Instant timestamp) {
        Instant instant1;
        do {
            if (!timestamp.isBefore(instant1 = this.M.get())) continue;
            return false;
        } while (!this.M.compareAndSet(instant1, timestamp));
        return true;
    }

    public static boolean c(String message) {
        for (int i2 = 0; i2 < message.length(); ++i2) {
            if (SharedConstants.a(message.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public void chat(String s2, PlayerChatMessage original, boolean async) {
        if (s2.isEmpty() || this.b.A() == EnumChatVisibility.c) {
            return;
        }
        OutgoingChatMessage outgoing = OutgoingChatMessage.a(original);
        if (this.b.A() != EnumChatVisibility.b) {
            ChatProcessor cp = new ChatProcessor(this.i, this.b, original, async);
            cp.process();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCommand(String s2) {
        AsyncCatcher.catchOp("Command Dispatched Async: " + s2);
        MinecraftTimings.playerCommandTimer.startTiming();
        if (SpigotConfig.logCommands) {
            c.info(this.b.cv() + " issued server command: " + s2);
        }
        CraftPlayer player = this.getCraftPlayer();
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)player, s2, (Set)new LazyPlayerSet(this.i));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            MinecraftTimings.playerCommandTimer.stopTiming();
            return;
        }
        try {
            if (this.cserver.dispatchCommand((CommandSender)event.getPlayer(), event.getMessage().substring(1))) {
                return;
            }
        }
        catch (CommandException ex) {
            player.sendMessage(ChatColor.RED + "An internal error occurred while attempting to perform this command");
            java.util.logging.Logger.getLogger(PlayerConnection.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        finally {
            MinecraftTimings.playerCommandTimer.stopTiming();
        }
    }

    private PlayerChatMessage a(PacketPlayInChat packet, LastSeenMessages lastSeenMessages) throws SignedMessageChain.a {
        SignedMessageBody signedmessagebody = new SignedMessageBody(packet.a(), packet.c(), packet.d(), lastSeenMessages);
        return this.O.unpack(packet.e(), signedmessagebody);
    }

    private void b(PlayerChatMessage message) {
        String s2 = message.b();
        if (s2.isEmpty()) {
            c.warn(this.b.cv() + " tried to send an empty message");
        } else if (this.getCraftPlayer().isConversing()) {
            final String conversationInput = s2;
            this.i.processQueue.add(new Runnable(){

                @Override
                public void run() {
                    PlayerConnection.this.getCraftPlayer().acceptConversationInput(conversationInput);
                }
            });
        } else if (this.b.A() == EnumChatVisibility.b) {
            this.a(new ClientboundSystemChatPacket(PaperAdventure.asAdventure(IChatBaseComponent.c("chat.cannotSend").a(EnumChatFormat.m)), false));
        } else {
            this.chat(s2, message, true);
        }
        this.detectRateSpam(s2);
    }

    private void detectRateSpam(String s2) {
        boolean counted = true;
        for (String exclude : SpigotConfig.spamExclusions) {
            if (exclude == null || !s2.startsWith(exclude)) continue;
            counted = false;
            break;
        }
        if (counted && this.chatSpamTickCount.addAndGet(20) > 200 && !this.i.ac().f(this.b.fM())) {
            this.disconnect(IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(ServerboundChatAckPacket packet) {
        LastSeenMessagesValidator lastseenmessagesvalidator = this.P;
        LastSeenMessagesValidator lastSeenMessagesValidator = this.P;
        synchronized (lastSeenMessagesValidator) {
            if (!this.P.a(packet.a())) {
                c.warn("Failed to validate message acknowledgements from {}", (Object)this.b.Z().getString());
                this.disconnect(g, PlayerKickEvent.Cause.CHAT_VALIDATION_FAILED);
            }
        }
    }

    @Override
    public void a(PacketPlayInArmAnimation packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.eT()) {
            return;
        }
        this.b.C();
        float f1 = this.b.dA();
        float f2 = this.b.dy();
        double d0 = this.b.dn();
        double d1 = this.b.dp() + (double)this.b.cF();
        double d2 = this.b.dt();
        Location origin = new Location((World)this.b.dI().getWorld(), d0, d1, d2, f2, f1);
        double d3 = this.b.e.b() == EnumGamemode.b ? 5.0 : 4.5;
        RayTraceResult result = this.b.dI().getWorld().rayTrace(origin, origin.getDirection(), d3, FluidCollisionMode.NEVER, false, 0.0, entity -> {
            net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
            return entity != this.b.getBukkitEntity() && this.b.getBukkitEntity().canSee((Entity)entity) && !handle.G_() && handle.bo() && !handle.v(this.b);
        });
        if (result == null) {
            CraftEventFactory.callPlayerInteractEvent(this.b, Action.LEFT_CLICK_AIR, this.b.fN().f(), EnumHand.a);
        } else {
            EnumGamemode gameType = this.b.e.b();
            if (gameType == EnumGamemode.c && result.getHitBlock() != null) {
                CraftEventFactory.callPlayerInteractEvent(this.b, Action.LEFT_CLICK_BLOCK, MCUtil.toBlockPosition(result.getHitPosition()), CraftBlock.blockFaceToNotch(result.getHitBlockFace()), this.b.fN().f(), EnumHand.a);
            } else if (gameType != EnumGamemode.b && result.getHitEntity() != null && origin.toVector().distanceSquared(result.getHitPosition()) > 9.0) {
                CraftEventFactory.callPlayerInteractEvent(this.b, Action.LEFT_CLICK_AIR, this.b.fN().f(), EnumHand.a);
            }
        }
        PlayerArmSwingEvent event = new PlayerArmSwingEvent((Player)this.getCraftPlayer(), packet.a() == EnumHand.a ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND);
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.b.a(packet.a());
    }

    @Override
    public void a(PacketPlayInEntityAction packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.dD()) {
            return;
        }
        switch (packet.c()) {
            case a: 
            case b: {
                PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this.getCraftPlayer(), packet.c() == PacketPlayInEntityAction.EnumPlayerAction.a);
                this.cserver.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) break;
                return;
            }
            case d: 
            case e: {
                PlayerToggleSprintEvent e2 = new PlayerToggleSprintEvent((Player)this.getCraftPlayer(), packet.c() == PacketPlayInEntityAction.EnumPlayerAction.d);
                this.cserver.getPluginManager().callEvent((Event)e2);
                if (!e2.isCancelled()) break;
                return;
            }
        }
        this.b.C();
        switch (packet.c()) {
            case a: {
                this.b.f(true);
                if (!this.b.dI().paperConfig().entities.behavior.parrotsAreUnaffectedByPlayerMovement) break;
                this.b.gb();
                break;
            }
            case b: {
                this.b.f(false);
                break;
            }
            case d: {
                this.b.g(true);
                break;
            }
            case e: {
                this.b.g(false);
                break;
            }
            case c: {
                if (!this.b.fy()) break;
                this.b.a(false, true);
                this.D = this.b.dg();
                break;
            }
            case f: {
                net.minecraft.world.entity.Entity entity = this.b.cX();
                if (!(entity instanceof IJumpable)) break;
                IJumpable ijumpable = (IJumpable)((Object)entity);
                int i2 = packet.d();
                if (!ijumpable.a() || i2 <= 0) break;
                ijumpable.c(i2);
                break;
            }
            case g: {
                net.minecraft.world.entity.Entity entity = this.b.cX();
                if (!(entity instanceof IJumpable)) break;
                IJumpable ijumpable = (IJumpable)((Object)entity);
                ijumpable.b();
                break;
            }
            case h: {
                net.minecraft.world.entity.Entity entity = this.b.cW();
                if (!(entity instanceof HasCustomInventoryScreen)) break;
                HasCustomInventoryScreen hascustominventoryscreen = (HasCustomInventoryScreen)((Object)entity);
                hascustominventoryscreen.b(this.b);
                break;
            }
            case i: {
                if (this.b.fS()) break;
                this.b.fU();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid client command!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(PlayerChatMessage message) {
        MessageSignature messagesignature = message.k();
        if (messagesignature != null) {
            int i2;
            this.Q.a(message);
            LastSeenMessagesValidator lastseenmessagesvalidator = this.P;
            LastSeenMessagesValidator lastSeenMessagesValidator = this.P;
            synchronized (lastSeenMessagesValidator) {
                this.P.a(messagesignature);
                i2 = this.P.a();
            }
            if (i2 > 4096) {
                this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.too_many_pending_chats"), PlayerKickEvent.Cause.TOO_MANY_PENDING_CHATS);
            }
        }
    }

    public void a(PlayerChatMessage message, ChatMessageType.a params) {
        if (!this.getCraftPlayer().canSee(message.j().c())) {
            this.a(message.c(), params);
            return;
        }
        this.a(new ClientboundPlayerChatPacket(message.j().c(), message.j().b(), message.k(), message.l().a(this.Q), message.m(), message.n(), params.a(this.b.dI().B_())));
        this.a(message);
    }

    public void a(IChatBaseComponent message, ChatMessageType.a params) {
        this.a(new ClientboundDisguisedChatPacket(message, params.a(this.b.dI().B_())));
    }

    public SocketAddress e() {
        return this.h.c();
    }

    public SocketAddress getRawAddress() {
        if (this.h.m.remoteAddress() == null) {
            return new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
        }
        return this.h.m.remoteAddress();
    }

    @Override
    public void a(final PacketPlayInUseEntity packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.eT()) {
            return;
        }
        final WorldServer worldserver = this.b.x();
        final net.minecraft.world.entity.Entity entity = packet.a(worldserver);
        if (entity == this.b && !this.b.G_()) {
            this.disconnect("Cannot interact with self!", PlayerKickEvent.Cause.SELF_INTERACTION);
            return;
        }
        this.b.C();
        this.b.f(packet.a());
        if (entity != null) {
            if (!worldserver.w_().a(entity.di())) {
                return;
            }
            AxisAlignedBB axisalignedbb = entity.cE();
            if (axisalignedbb.e(this.b.bm()) < a) {
                packet.a(new PacketPlayInUseEntity.c(){

                    private void performInteraction(EnumHand enumhand, a playerconnection_a, PlayerInteractEntityEvent event) {
                        ItemStack itemstack = PlayerConnection.this.b.b(enumhand);
                        if (itemstack.a(worldserver.G())) {
                            ItemStack itemstack1 = itemstack.p();
                            ItemStack itemInHand = PlayerConnection.this.b.b(enumhand);
                            boolean triggerLeashUpdate = itemInHand != null && itemInHand.d() == Items.tQ && entity instanceof EntityInsentient;
                            Item origItem = PlayerConnection.this.b.fN().f() == null ? null : PlayerConnection.this.b.fN().f().d();
                            PlayerConnection.this.cserver.getPluginManager().callEvent((Event)event);
                            if (entity instanceof Bucketable && entity instanceof EntityLiving && origItem != null && origItem.k() == Items.pL && (event.isCancelled() || PlayerConnection.this.b.fN().f() == null || PlayerConnection.this.b.fN().f().d() != origItem)) {
                                entity.aj().resendPossiblyDesyncedEntity(PlayerConnection.this.b);
                                PlayerConnection.this.b.bR.b();
                            }
                            if (triggerLeashUpdate && (event.isCancelled() || PlayerConnection.this.b.fN().f() == null || PlayerConnection.this.b.fN().f().d() != origItem)) {
                                PlayerConnection.this.a(new PacketPlayOutAttachEntity(entity, ((EntityInsentient)entity).fP()));
                            }
                            if (event.isCancelled() || PlayerConnection.this.b.fN().f() == null || PlayerConnection.this.b.fN().f().d() != origItem) {
                                entity.aj().refresh(PlayerConnection.this.b);
                                if (entity instanceof Allay) {
                                    Allay allay = (Allay)entity;
                                    PlayerConnection.this.a(new PacketPlayOutEntityEquipment(entity.af(), Arrays.stream(EnumItemSlot.values()).map(slot -> Pair.of((Object)slot, (Object)allay.stripMeta(allay.c((EnumItemSlot)((Object)slot)), true))).collect(Collectors.toList())));
                                    PlayerConnection.this.b.bR.b();
                                }
                            }
                            if (event.isCancelled()) {
                                PlayerConnection.this.b.bR.b();
                                return;
                            }
                            EnumInteractionResult enuminteractionresult = playerconnection_a.run(PlayerConnection.this.b, entity, enumhand);
                            if (!itemInHand.b() && itemInHand.L() <= -1) {
                                PlayerConnection.this.b.bR.b();
                            }
                            if (enuminteractionresult.a()) {
                                CriterionTriggers.Q.a(PlayerConnection.this.b, itemstack1, entity);
                                if (enuminteractionresult.b()) {
                                    PlayerConnection.this.b.a(enumhand, true);
                                }
                            }
                        }
                    }

                    @Override
                    public void a(EnumHand hand) {
                        this.performInteraction(hand, EntityHuman::a, new PlayerInteractEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), hand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                    }

                    @Override
                    public void a(EnumHand hand, Vec3D pos) {
                        this.performInteraction(hand, (entityplayer, entity1, enumhand1) -> entity1.a(entityplayer, pos, enumhand1), (PlayerInteractEntityEvent)new PlayerInteractAtEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), new Vector(pos.c, pos.d, pos.e), hand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                    }

                    @Override
                    public void a() {
                        if (!(entity instanceof EntityItem || entity instanceof EntityExperienceOrb || entity instanceof EntityArrow || entity == PlayerConnection.this.b && !PlayerConnection.this.b.G_())) {
                            ItemStack itemstack = PlayerConnection.this.b.b(EnumHand.a);
                            if (itemstack.a(worldserver.G())) {
                                PlayerConnection.this.b.d(entity);
                                if (!itemstack.b() && itemstack.L() <= -1) {
                                    PlayerConnection.this.b.bR.b();
                                }
                            }
                        } else {
                            PlayerConnection.this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.invalid_entity_attacked"), PlayerKickEvent.Cause.INVALID_ENTITY_ATTACKED);
                            c.warn("Player {} tried to attack an invalid entity", (Object)PlayerConnection.this.b.Z().getString());
                        }
                    }
                });
            }
        } else {
            packet.a(new PacketPlayInUseEntity.c(){

                @Override
                public void a(EnumHand hand) {
                    PlayerConnection.this.callPlayerUseUnknownEntityEvent(packet, hand, null);
                }

                @Override
                public void a(EnumHand hand, Vec3D pos) {
                    PlayerConnection.this.callPlayerUseUnknownEntityEvent(packet, hand, pos);
                }

                @Override
                public void a() {
                    PlayerConnection.this.callPlayerUseUnknownEntityEvent(packet, EnumHand.a, null);
                }
            });
        }
    }

    private void callPlayerUseUnknownEntityEvent(PacketPlayInUseEntity packet, EnumHand hand, @Nullable Vec3D vector) {
        this.cserver.getPluginManager().callEvent((Event)new PlayerUseUnknownEntityEvent((Player)this.getCraftPlayer(), packet.getEntityId(), packet.isAttack(), hand == EnumHand.a ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND, vector != null ? new Vector(vector.c, vector.d, vector.e) : null));
    }

    @Override
    public void a(PacketPlayInClientCommand packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        this.b.C();
        PacketPlayInClientCommand.EnumClientCommand packetplayinclientcommand_enumclientcommand = packet.a();
        switch (packetplayinclientcommand_enumclientcommand) {
            case a: {
                if (this.b.g) {
                    this.b.g = false;
                    this.b = this.i.ac().respawn(this.b, this.i.a(this.b.P()), true, null, true, PlayerRespawnEvent.RespawnReason.END_PORTAL, PlayerRespawnEvent.RespawnFlag.END_PORTAL);
                    CriterionTriggers.v.a(this.b, net.minecraft.world.level.World.j, net.minecraft.world.level.World.h);
                    break;
                }
                if (this.b.er() > 0.0f) {
                    return;
                }
                this.b = this.i.ac().respawn(this.b, false, PlayerRespawnEvent.RespawnReason.DEATH);
                if (!this.i.h()) break;
                this.b.setGameMode(EnumGamemode.d, PlayerGameModeChangeEvent.Cause.HARDCORE_DEATH, null);
                this.b.dI().X().a(GameRules.q).set(false, this.b.x());
                break;
            }
            case b: {
                this.b.D().a(this.b);
            }
        }
    }

    @Override
    public void a(PacketPlayInCloseWindow packet) {
        this.handleContainerClose(packet, InventoryCloseEvent.Reason.PLAYER);
    }

    public void handleContainerClose(PacketPlayInCloseWindow packet, InventoryCloseEvent.Reason reason) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.eT()) {
            return;
        }
        CraftEventFactory.handleInventoryCloseEvent(this.b, reason);
        this.b.r();
    }

    @Override
    public void a(PacketPlayInWindowClick packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.eT()) {
            return;
        }
        this.b.C();
        if (this.b.bR.j == packet.a() && this.b.bR.a(this.b)) {
            boolean cancelled = this.b.G_();
            if (!this.b.bR.a(this.b)) {
                c.debug("Player {} interacted with invalid menu {}", (Object)this.b, (Object)this.b.bR);
            } else {
                int i2 = packet.c();
                if (!this.b.bR.a(i2)) {
                    c.debug("Player {} clicked invalid slot index: {}, available slots: {}", new Object[]{this.b.Z(), i2, this.b.bR.i.size()});
                } else {
                    boolean flag = packet.h() != this.b.bR.j();
                    this.b.bR.h();
                    if (packet.c() < -1 && packet.c() != -999) {
                        return;
                    }
                    InventoryView inventory = this.b.bR.getBukkitView();
                    InventoryType.SlotType type = inventory.getSlotType(packet.c());
                    ClickType click = ClickType.UNKNOWN;
                    InventoryAction action = InventoryAction.UNKNOWN;
                    ItemStack itemstack = ItemStack.b;
                    switch (packet.g()) {
                        case a: {
                            if (packet.d() == 0) {
                                click = ClickType.LEFT;
                            } else if (packet.d() == 1) {
                                click = ClickType.RIGHT;
                            }
                            if (packet.d() != 0 && packet.d() != 1) break;
                            action = InventoryAction.NOTHING;
                            if (packet.c() == -999) {
                                if (this.b.bR.g().b()) break;
                                action = packet.d() == 0 ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
                                break;
                            }
                            if (packet.c() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.b.bR.b(packet.c());
                            if (slot == null) break;
                            ItemStack clickedItem = slot.e();
                            ItemStack cursor = this.b.bR.g();
                            if (clickedItem.b()) {
                                if (cursor.b()) break;
                                action = packet.d() == 0 ? InventoryAction.PLACE_ALL : InventoryAction.PLACE_ONE;
                                break;
                            }
                            if (!slot.a(this.b)) break;
                            if (cursor.b()) {
                                action = packet.d() == 0 ? InventoryAction.PICKUP_ALL : InventoryAction.PICKUP_HALF;
                                break;
                            }
                            if (slot.a(cursor)) {
                                if (ItemStack.c(clickedItem, cursor)) {
                                    int toPlace = packet.d() == 0 ? cursor.L() : 1;
                                    toPlace = Math.min(toPlace, clickedItem.g() - clickedItem.L());
                                    if ((toPlace = Math.min(toPlace, slot.d.ac_() - clickedItem.L())) == 1) {
                                        action = InventoryAction.PLACE_ONE;
                                        break;
                                    }
                                    if (toPlace == cursor.L()) {
                                        action = InventoryAction.PLACE_ALL;
                                        break;
                                    }
                                    if (toPlace < 0) {
                                        action = toPlace != -1 ? InventoryAction.PICKUP_SOME : InventoryAction.PICKUP_ONE;
                                        break;
                                    }
                                    if (toPlace == 0) break;
                                    action = InventoryAction.PLACE_SOME;
                                    break;
                                }
                                if (cursor.L() > slot.a()) break;
                                action = InventoryAction.SWAP_WITH_CURSOR;
                                break;
                            }
                            if (!ItemStack.c(cursor, clickedItem) || clickedItem.L() < 0 || clickedItem.L() + cursor.L() > cursor.g()) break;
                            action = InventoryAction.PICKUP_ALL;
                            break;
                        }
                        case b: {
                            if (packet.d() == 0) {
                                click = ClickType.SHIFT_LEFT;
                            } else if (packet.d() == 1) {
                                click = ClickType.SHIFT_RIGHT;
                            }
                            if (packet.d() != 0 && packet.d() != 1) break;
                            if (packet.c() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.b.bR.b(packet.c());
                            if (slot != null && slot.a(this.b) && slot.f()) {
                                action = InventoryAction.MOVE_TO_OTHER_INVENTORY;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case c: {
                            if ((packet.d() < 0 || packet.d() >= 9) && packet.d() != 40) break;
                            click = packet.d() == 40 ? ClickType.SWAP_OFFHAND : ClickType.NUMBER_KEY;
                            Slot clickedSlot = this.b.bR.b(packet.c());
                            if (clickedSlot.a(this.b)) {
                                boolean canCleanSwap;
                                ItemStack hotbar = this.b.fN().a(packet.d());
                                boolean bl = canCleanSwap = hotbar.b() || clickedSlot.d == this.b.fN() && clickedSlot.a(hotbar);
                                if (clickedSlot.f()) {
                                    if (canCleanSwap) {
                                        action = InventoryAction.HOTBAR_SWAP;
                                        break;
                                    }
                                    action = InventoryAction.HOTBAR_MOVE_AND_READD;
                                    break;
                                }
                                if (!clickedSlot.f() && !hotbar.b() && clickedSlot.a(hotbar)) {
                                    action = InventoryAction.HOTBAR_SWAP;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case d: {
                            Slot slot;
                            if (packet.d() == 2) {
                                click = ClickType.MIDDLE;
                                if (packet.c() < 0) {
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                slot = this.b.bR.b(packet.c());
                                if (slot != null && slot.f() && this.b.fO().d && this.b.bR.g().b()) {
                                    action = InventoryAction.CLONE_STACK;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.UNKNOWN;
                            action = InventoryAction.UNKNOWN;
                            break;
                        }
                        case e: {
                            Slot slot;
                            if (packet.c() >= 0) {
                                if (packet.d() == 0) {
                                    click = ClickType.DROP;
                                    slot = this.b.bR.b(packet.c());
                                    if (slot != null && slot.f() && slot.a(this.b) && !slot.e().b() && slot.e().d() != Item.a(Blocks.a)) {
                                        action = InventoryAction.DROP_ONE_SLOT;
                                        break;
                                    }
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                if (packet.d() != 1) break;
                                click = ClickType.CONTROL_DROP;
                                slot = this.b.bR.b(packet.c());
                                if (slot != null && slot.f() && slot.a(this.b) && !slot.e().b() && slot.e().d() != Item.a(Blocks.a)) {
                                    action = InventoryAction.DROP_ALL_SLOT;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.LEFT;
                            if (packet.d() == 1) {
                                click = ClickType.RIGHT;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case f: {
                            this.b.bR.a(packet.c(), packet.d(), packet.g(), this.b);
                            break;
                        }
                        case g: {
                            click = ClickType.DOUBLE_CLICK;
                            action = InventoryAction.NOTHING;
                            if (packet.c() < 0 || this.b.bR.g().b()) break;
                            ItemStack cursor = this.b.bR.g();
                            action = InventoryAction.NOTHING;
                            if (!inventory.getTopInventory().contains(CraftMagicNumbers.getMaterial(cursor.d())) && !inventory.getBottomInventory().contains(CraftMagicNumbers.getMaterial(cursor.d()))) break;
                            action = InventoryAction.COLLECT_TO_CURSOR;
                            break;
                        }
                    }
                    if (packet.g() != InventoryClickType.f) {
                        org.bukkit.inventory.ItemStack result;
                        Recipe recipe;
                        InventoryClickEvent event = click == ClickType.NUMBER_KEY ? new InventoryClickEvent(inventory, type, packet.c(), click, action, packet.d()) : new InventoryClickEvent(inventory, type, packet.c(), click, action);
                        Inventory top = inventory.getTopInventory();
                        if (packet.c() == 0 && top instanceof CraftingInventory && (recipe = ((CraftingInventory)top).getRecipe()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new CraftItemEvent(recipe, inventory, type, packet.c(), click, action, packet.d()) : new CraftItemEvent(recipe, inventory, type, packet.c(), click, action);
                        }
                        if (packet.c() == 3 && top instanceof SmithingInventory && (result = ((SmithingInventory)top).getResult()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new SmithItemEvent(inventory, type, packet.c(), click, action, packet.d()) : new SmithItemEvent(inventory, type, packet.c(), click, action);
                        }
                        event.setCancelled(cancelled);
                        Container oldContainer = this.b.bR;
                        this.cserver.getPluginManager().callEvent((Event)event);
                        if (this.b.bR != oldContainer) {
                            return;
                        }
                        block9 : switch (event.getResult()) {
                            case ALLOW: 
                            case DEFAULT: {
                                this.b.bR.a(i2, packet.d(), packet.g(), this.b);
                                break;
                            }
                            case DENY: {
                                switch (action) {
                                    case PICKUP_ALL: 
                                    case MOVE_TO_OTHER_INVENTORY: 
                                    case HOTBAR_MOVE_AND_READD: 
                                    case HOTBAR_SWAP: 
                                    case COLLECT_TO_CURSOR: 
                                    case UNKNOWN: {
                                        this.b.bR.b();
                                        break block9;
                                    }
                                    case PICKUP_SOME: 
                                    case PICKUP_HALF: 
                                    case PICKUP_ONE: 
                                    case PLACE_ALL: 
                                    case PLACE_SOME: 
                                    case PLACE_ONE: 
                                    case SWAP_WITH_CURSOR: {
                                        this.b.c.a(new PacketPlayOutSetSlot(-1, -1, this.b.bQ.k(), this.b.bR.g()));
                                        this.b.c.a(new PacketPlayOutSetSlot(this.b.bR.j, this.b.bQ.k(), packet.c(), this.b.bR.b(packet.c()).e()));
                                        break block9;
                                    }
                                    case DROP_ALL_SLOT: 
                                    case DROP_ONE_SLOT: {
                                        this.b.c.a(new PacketPlayOutSetSlot(this.b.bR.j, this.b.bQ.k(), packet.c(), this.b.bR.b(packet.c()).e()));
                                        break block9;
                                    }
                                    case DROP_ALL_CURSOR: 
                                    case DROP_ONE_CURSOR: 
                                    case CLONE_STACK: {
                                        this.b.c.a(new PacketPlayOutSetSlot(-1, -1, this.b.bQ.k(), this.b.bR.g()));
                                        break block9;
                                    }
                                }
                            }
                        }
                        if (event instanceof CraftItemEvent || event instanceof SmithItemEvent) {
                            this.b.bR.b();
                        }
                    }
                    for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(packet.f())) {
                        this.b.bR.b(entry.getIntKey(), (ItemStack)entry.getValue());
                    }
                    this.b.bR.a(packet.e());
                    this.b.bR.i();
                    if (flag) {
                        this.b.bR.e();
                    } else {
                        this.b.bR.d();
                    }
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInAutoRecipe packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (!Bukkit.isPrimaryThread() && this.recipeSpamPackets.addAndGet(GlobalConfiguration.get().spamLimiter.recipeSpamIncrement) > GlobalConfiguration.get().spamLimiter.recipeSpamLimit) {
            this.i.scheduleOnMain(() -> this.disconnect(IChatBaseComponent.a("disconnect.spam", new Object[0]), PlayerKickEvent.Cause.SPAM));
            return;
        }
        PlayerConnectionUtils.a(packet, this, this.b.x());
        this.b.C();
        if (!this.b.G_() && this.b.bR.j == packet.a() && this.b.bR instanceof ContainerRecipeBook) {
            if (!this.b.bR.a(this.b)) {
                c.debug("Player {} interacted with invalid menu {}", (Object)this.b, (Object)this.b.bR);
            } else {
                MinecraftKey recipeName = packet.c();
                boolean makeAll = packet.d();
                PlayerRecipeBookClickEvent paperEvent = new PlayerRecipeBookClickEvent((Player)this.b.getBukkitEntity(), CraftNamespacedKey.fromMinecraft(recipeName), makeAll);
                if (!paperEvent.callEvent()) {
                    return;
                }
                recipeName = CraftNamespacedKey.toMinecraft(paperEvent.getRecipe());
                makeAll = paperEvent.isMakeAll();
                if (org.bukkit.event.player.PlayerRecipeBookClickEvent.getHandlerList().getRegisteredListeners().length > 0) {
                    Recipe recipe = this.cserver.getRecipe(CraftNamespacedKey.fromMinecraft(recipeName));
                    if (recipe == null) {
                        return;
                    }
                    org.bukkit.event.player.PlayerRecipeBookClickEvent event = CraftEventFactory.callRecipeBookClickEvent(this.b, recipe, makeAll);
                    recipeName = CraftNamespacedKey.toMinecraft(((Keyed)event.getRecipe()).getKey());
                    makeAll = event.isShiftClick();
                }
                if (!(this.b.bR instanceof ContainerRecipeBook)) {
                    return;
                }
                boolean finalMakeAll = makeAll;
                this.i.aE().a(recipeName).ifPresent(irecipe -> ((ContainerRecipeBook)this.b.bR).a(finalMakeAll, (IRecipe<?>)irecipe, this.b));
            }
        }
    }

    @Override
    public void a(PacketPlayInEnchantItem packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.eT()) {
            return;
        }
        this.b.C();
        if (this.b.bR.j == packet.a() && !this.b.G_()) {
            if (!this.b.bR.a(this.b)) {
                c.debug("Player {} interacted with invalid menu {}", (Object)this.b, (Object)this.b.bR);
            } else {
                boolean flag = this.b.bR.b(this.b, packet.c());
                if (flag) {
                    this.b.bR.d();
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSetCreativeSlot packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.e.e()) {
            boolean flag2;
            boolean flag = packet.a() < 0;
            ItemStack itemstack = packet.c();
            if (!itemstack.a(this.b.dI().G())) {
                return;
            }
            NBTTagCompound nbttagcompound = ItemBlock.a(itemstack);
            if (!itemstack.b() && nbttagcompound != null && nbttagcompound.e("x") && nbttagcompound.e("y") && nbttagcompound.e("z") && this.b.getBukkitEntity().hasPermission("minecraft.nbt.copy")) {
                BlockPosition blockposition = TileEntity.c(nbttagcompound);
                if (this.b.dI().o(blockposition)) {
                    TileEntity tileentity = null;
                    if (this.b.i(blockposition.u(), blockposition.v(), blockposition.w()) < 1024.0 && this.b.x().isLoadedAndInBounds(blockposition)) {
                        tileentity = this.b.dI().c_(blockposition);
                    }
                    if (tileentity != null) {
                        tileentity.e(itemstack);
                    }
                }
            }
            boolean flag1 = packet.a() >= 1 && packet.a() <= 45;
            boolean bl = flag2 = itemstack.b() || itemstack.k() >= 0 && itemstack.L() <= 64 && !itemstack.b();
            if (flag || flag1 && !ItemStack.a(this.b.bQ.b(packet.a()).e(), packet.c())) {
                CraftInventoryView inventory = this.b.bQ.getBukkitView();
                org.bukkit.inventory.ItemStack item = CraftItemStack.asBukkitCopy(packet.c());
                InventoryType.SlotType type = InventoryType.SlotType.QUICKBAR;
                if (flag) {
                    type = InventoryType.SlotType.OUTSIDE;
                } else if (packet.a() < 36) {
                    type = packet.a() >= 5 && packet.a() < 9 ? InventoryType.SlotType.ARMOR : InventoryType.SlotType.CONTAINER;
                }
                InventoryCreativeEvent event = new InventoryCreativeEvent((InventoryView)inventory, type, flag ? -999 : packet.a(), item);
                this.cserver.getPluginManager().callEvent((Event)event);
                itemstack = CraftItemStack.asNMSCopy(event.getCursor());
                switch (event.getResult()) {
                    case ALLOW: {
                        flag2 = true;
                        break;
                    }
                    case DEFAULT: {
                        break;
                    }
                    case DENY: {
                        if (packet.a() >= 0) {
                            this.b.c.a(new PacketPlayOutSetSlot(this.b.bQ.j, this.b.bQ.k(), packet.a(), this.b.bQ.b(packet.a()).e()));
                            this.b.c.a(new PacketPlayOutSetSlot(-1, this.b.bQ.k(), -1, ItemStack.b));
                        }
                        return;
                    }
                }
            }
            if (flag1 && flag2) {
                this.b.bQ.b(packet.a()).d(itemstack);
                this.b.bQ.d();
            } else if (flag && flag2 && this.p < 200) {
                this.p += 20;
                this.b.a(itemstack, true);
            }
        }
    }

    @Override
    public void a(PacketPlayInUpdateSign packet) {
        String[] lines = packet.d();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            int offset;
            if (MAX_SIGN_LINE_LENGTH <= 0 || lines[i2].length() <= MAX_SIGN_LINE_LENGTH || (offset = lines[i2].codePoints().limit(MAX_SIGN_LINE_LENGTH).map(Character::charCount).sum()) >= lines[i2].length()) continue;
            lines[i2] = lines[i2].substring(0, offset);
        }
        List<String> list = Stream.of(lines).map(EnumChatFormat::a).collect(Collectors.toList());
        this.a(list).thenAcceptAsync(list1 -> this.a(packet, (List<FilteredText>)list1), (Executor)this.i);
    }

    private void a(PacketPlayInUpdateSign packet, List<FilteredText> signText) {
        if (this.b.eT()) {
            return;
        }
        this.b.C();
        WorldServer worldserver = this.b.x();
        BlockPosition blockposition = packet.a();
        if (worldserver.A(blockposition)) {
            TileEntity tileentity = worldserver.c_(blockposition);
            if (!(tileentity instanceof TileEntitySign)) {
                return;
            }
            TileEntitySign tileentitysign = (TileEntitySign)tileentity;
            tileentitysign.a((EntityHuman)this.b, packet.c(), signText);
        }
    }

    @Override
    public void a(PacketPlayInKeepAlive packet) {
        if (this.m && packet.a() == this.n) {
            int i2 = (int)(SystemUtils.b() - this.l);
            this.b.f = (this.b.f * 3 + i2) / 4;
            this.m = false;
        } else if (!this.g()) {
            this.i.g(() -> this.disconnect(IChatBaseComponent.c("disconnect.timeout"), PlayerKickEvent.Cause.TIMEOUT));
        }
    }

    @Override
    public void a(PacketPlayInAbilities packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.fO().c && this.b.fO().b != packet.a()) {
            PlayerToggleFlightEvent event = new PlayerToggleFlightEvent((Player)this.b.getBukkitEntity(), packet.a());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.b.fO().b = packet.a();
            } else {
                this.b.w();
            }
        }
    }

    @Override
    public void a(PacketPlayInSettings packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (packet.c() < 0) {
            c.warn("Disconnecting " + this.b.cv() + " for invalid view distance: " + packet.c());
            this.disconnect("Invalid client settings", PlayerKickEvent.Cause.ILLEGAL_ACTION);
            return;
        }
        this.b.a(packet);
    }

    @Override
    public void a(PacketPlayInCustomPayload packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (packet.c.equals(CUSTOM_REGISTER)) {
            try {
                String channels = packet.d.toString(Charsets.UTF_8);
                for (String channel : channels.split("\u0000")) {
                    this.getCraftPlayer().addChannel(channel);
                }
            }
            catch (Exception ex) {
                c.error("Couldn't register custom payload", (Throwable)ex);
                this.disconnect("Invalid payload REGISTER!", PlayerKickEvent.Cause.INVALID_PAYLOAD);
            }
        } else if (packet.c.equals(CUSTOM_UNREGISTER)) {
            try {
                String channels = packet.d.toString(Charsets.UTF_8);
                for (String channel : channels.split("\u0000")) {
                    this.getCraftPlayer().removeChannel(channel);
                }
            }
            catch (Exception ex) {
                c.error("Couldn't unregister custom payload", (Throwable)ex);
                this.disconnect("Invalid payload UNREGISTER!", PlayerKickEvent.Cause.INVALID_PAYLOAD);
            }
        } else {
            try {
                byte[] data = new byte[packet.d.readableBytes()];
                packet.d.readBytes(data);
                if (packet.c.equals(MINECRAFT_BRAND)) {
                    try {
                        this.clientBrandName = new PacketDataSerializer(Unpooled.copiedBuffer((byte[])data)).e(256);
                    }
                    catch (StringIndexOutOfBoundsException ex) {
                        this.clientBrandName = "illegal";
                    }
                }
                this.cserver.getMessenger().dispatchIncomingMessage((Player)this.b.getBukkitEntity(), packet.c.toString(), data);
            }
            catch (Exception ex) {
                c.error("Couldn't dispatch custom payload", (Throwable)ex);
                this.disconnect("Invalid custom payload!", PlayerKickEvent.Cause.INVALID_PAYLOAD);
            }
        }
    }

    public String getClientBrandName() {
        return this.clientBrandName;
    }

    public final boolean isDisconnected() {
        return !this.b.joining && !this.h.h() || this.processedDisconnect;
    }

    @Override
    public void a(PacketPlayInDifficultyChange packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.l(2) || this.g()) {
            // empty if block
        }
    }

    @Override
    public void a(PacketPlayInDifficultyLock packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.l(2) || this.g()) {
            this.i.b(packet.a());
        }
    }

    @Override
    public void a(ServerboundChatSessionUpdatePacket packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        RemoteChatSession.a remotechatsession_a = packet.a();
        ProfilePublicKey.a profilepublickey_a = this.N != null ? this.N.e().b() : null;
        ProfilePublicKey.a profilepublickey_a1 = remotechatsession_a.b();
        if (!Objects.equals(profilepublickey_a, profilepublickey_a1)) {
            if (profilepublickey_a != null && profilepublickey_a1.b().isBefore(profilepublickey_a.b())) {
                this.disconnect(ProfilePublicKey.a, PlayerKickEvent.Cause.EXPIRED_PROFILE_PUBLIC_KEY);
            } else {
                try {
                    SignatureValidator signaturevalidator = this.i.an();
                    if (signaturevalidator == null) {
                        c.warn("Ignoring chat session from {} due to missing Services public key", (Object)this.b.fM().getName());
                        return;
                    }
                    this.a(remotechatsession_a.a(this.b.fM(), signaturevalidator, Duration.ZERO));
                }
                catch (ProfilePublicKey.b profilepublickey_b) {
                    this.disconnect(profilepublickey_b.b(), profilepublickey_b.kickCause);
                }
            }
        }
    }

    private void a(RemoteChatSession session) {
        this.N = session;
        this.hasLoggedExpiry = false;
        this.O = session.a(this.b.ct());
        this.R.append(executor -> {
            this.b.a(session);
            this.i.ac().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.b), (Collection<EntityPlayer>)List.of(this.b)), this.b);
            return CompletableFuture.completedFuture(null);
        });
    }

    @Override
    public EntityPlayer f() {
        return this.b;
    }

    @FunctionalInterface
    private static interface a {
        public EnumInteractionResult run(EntityPlayer var1, net.minecraft.world.entity.Entity var2, EnumHand var3);
    }
}

