/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.linkfs;

import com.google.common.base.Splitter;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.server.packs.linkfs.LinkFSFileStore;
import net.minecraft.server.packs.linkfs.LinkFSPath;
import net.minecraft.server.packs.linkfs.LinkFSProvider;
import net.minecraft.server.packs.linkfs.PathContents;

public class LinkFileSystem
extends FileSystem {
    private static final Set<String> b = Set.of("basic");
    public static final String a = "/";
    private static final Splitter c = Splitter.on((char)'/');
    private final FileStore d;
    private final FileSystemProvider e = new LinkFSProvider();
    private final LinkFSPath f;

    LinkFileSystem(String name, b root) {
        this.d = new LinkFSFileStore(name);
        this.f = LinkFileSystem.a(root, this, "", null);
    }

    private static LinkFSPath a(b root, LinkFileSystem fileSystem, String name, @Nullable LinkFSPath parent) {
        Object2ObjectOpenHashMap object2ObjectOpenHashMap = new Object2ObjectOpenHashMap();
        LinkFSPath linkFSPath = new LinkFSPath(fileSystem, name, parent, new PathContents.a((Map<String, LinkFSPath>)object2ObjectOpenHashMap));
        root.b.forEach((fileName, path) -> object2ObjectOpenHashMap.put(fileName, (Object)new LinkFSPath(fileSystem, (String)fileName, linkFSPath, new PathContents.b((Path)path))));
        root.a.forEach((directoryName, directory) -> object2ObjectOpenHashMap.put(directoryName, (Object)LinkFileSystem.a(directory, fileSystem, directoryName, linkFSPath)));
        object2ObjectOpenHashMap.trim();
        return linkFSPath;
    }

    @Override
    @Override
    public FileSystemProvider provider() {
        return this.e;
    }

    @Override
    @Override
    public void close() {
    }

    @Override
    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    @Override
    public String getSeparator() {
        return a;
    }

    @Override
    @Override
    public Iterable<Path> getRootDirectories() {
        return List.of(this.f);
    }

    @Override
    @Override
    public Iterable<FileStore> getFileStores() {
        return List.of(this.d);
    }

    @Override
    @Override
    public Set<String> supportedFileAttributeViews() {
        return b;
    }

    @Override
    @Override
    public Path getPath(String string, String ... strings) {
        String string2;
        Stream<String> stream = Stream.of(string);
        if (strings.length > 0) {
            stream = Stream.concat(stream, Stream.of(strings));
        }
        if ((string2 = stream.collect(Collectors.joining(a))).equals(a)) {
            return this.f;
        }
        if (string2.startsWith(a)) {
            LinkFSPath linkFSPath = this.f;
            for (String string3 : c.split((CharSequence)string2.substring(1))) {
                if (string3.isEmpty()) {
                    throw new IllegalArgumentException("Empty paths not allowed");
                }
                linkFSPath = linkFSPath.a(string3);
            }
            return linkFSPath;
        }
        LinkFSPath linkFSPath2 = null;
        for (String string4 : c.split((CharSequence)string2)) {
            if (string4.isEmpty()) {
                throw new IllegalArgumentException("Empty paths not allowed");
            }
            linkFSPath2 = new LinkFSPath(this, string4, linkFSPath2, PathContents.b);
        }
        if (linkFSPath2 == null) {
            throw new IllegalArgumentException("Empty paths not allowed");
        }
        return linkFSPath2;
    }

    @Override
    @Override
    public PathMatcher getPathMatcher(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException();
    }

    public FileStore a() {
        return this.d;
    }

    public LinkFSPath b() {
        return this.f;
    }

    public static a c() {
        return new a();
    }

    record b(Map<String, b> a, Map<String, Path> b) {
        public b() {
            this(new HashMap<String, b>(), new HashMap<String, Path>());
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "children;files", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "children;files", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "children;files", "a", "b"}, this, object);
        }
    }

    public static class a {
        private final b a = new b();

        public a a(List<String> directories, String name, Path path) {
            b directoryEntry = this.a;
            for (String string : directories) {
                directoryEntry = directoryEntry.a.computeIfAbsent(string, directory -> new b());
            }
            directoryEntry.b.put(name, path);
            return this;
        }

        public a a(List<String> directories, Path path) {
            if (directories.isEmpty()) {
                throw new IllegalArgumentException("Path can't be empty");
            }
            int i2 = directories.size() - 1;
            return this.a(directories.subList(0, i2), directories.get(i2), path);
        }

        public FileSystem a(String name) {
            return new LinkFileSystem(name, this.a);
        }
    }
}

