/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.ResourcePackVanilla;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackSource;
import net.minecraft.server.packs.repository.ResourcePackSourceFolder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public abstract class BuiltInPackSource
implements ResourcePackSource {
    private static final Logger b = LogUtils.getLogger();
    public static final String a = "vanilla";
    private final EnumResourcePackType c;
    private final ResourcePackVanilla d;
    private final MinecraftKey e;

    public BuiltInPackSource(EnumResourcePackType type, ResourcePackVanilla resourcePack, MinecraftKey id) {
        this.c = type;
        this.d = resourcePack;
        this.e = id;
    }

    @Override
    @Override
    public void a(Consumer<ResourcePackLoader> profileAdder) {
        ResourcePackLoader pack = this.a(this.d);
        if (pack != null) {
            profileAdder.accept(pack);
        }
        this.b(profileAdder);
    }

    @Nullable
    protected abstract ResourcePackLoader a(IResourcePack var1);

    protected abstract IChatBaseComponent a(String var1);

    public ResourcePackVanilla a() {
        return this.d;
    }

    private void b(Consumer<ResourcePackLoader> consumer) {
        HashMap<String, Function> map = new HashMap<String, Function>();
        this.a(map::put);
        map.forEach((fileName, packFactory) -> {
            ResourcePackLoader pack = (ResourcePackLoader)packFactory.apply(fileName);
            if (pack != null) {
                consumer.accept(pack);
            }
        });
    }

    protected void a(BiConsumer<String, Function<String, ResourcePackLoader>> consumer) {
        this.d.a(this.c, this.e, (Path namespacedPath) -> this.a((Path)namespacedPath, consumer));
    }

    protected void a(@Nullable Path namespacedPath, BiConsumer<String, Function<String, ResourcePackLoader>> consumer) {
        if (namespacedPath != null && Files.isDirectory(namespacedPath, new LinkOption[0])) {
            try {
                ResourcePackSourceFolder.a(namespacedPath, true, (Path profilePath, ResourcePackLoader.c factory) -> consumer.accept(BuiltInPackSource.a(profilePath), name -> this.a((String)name, (ResourcePackLoader.c)factory, this.a((String)name))));
            }
            catch (IOException iOException) {
                b.warn("Failed to discover packs in {}", (Object)namespacedPath, (Object)iOException);
            }
        }
    }

    private static String a(Path path) {
        return StringUtils.removeEnd((String)path.getFileName().toString(), (String)".zip");
    }

    @Nullable
    protected abstract ResourcePackLoader a(String var1, ResourcePackLoader.c var2, IChatBaseComponent var3);
}

