/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IReloadable;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;
import org.slf4j.Logger;

public class ReloadableResourceManager
implements IResourceManager,
AutoCloseable {
    private static final Logger a = LogUtils.getLogger();
    private IReloadableResourceManager b;
    private final List<IReloadListener> c = Lists.newArrayList();
    private final EnumResourcePackType d;

    public ReloadableResourceManager(EnumResourcePackType type) {
        this.d = type;
        this.b = new ResourceManager(type, List.of());
    }

    @Override
    @Override
    public void close() {
        this.b.close();
    }

    public void a(IReloadListener reloader) {
        this.c.add(reloader);
    }

    public IReloadable a(Executor prepareExecutor, Executor applyExecutor, CompletableFuture<Unit> initialStage, List<IResourcePack> packs) {
        a.info("Reloading ResourceManager: {}", LogUtils.defer(() -> packs.stream().map(IResourcePack::a).collect(Collectors.joining(", "))));
        this.b.close();
        this.b = new ResourceManager(this.d, packs);
        return Reloadable.a(this.b, this.c, prepareExecutor, applyExecutor, initialStage, a.isDebugEnabled());
    }

    @Override
    @Override
    public Optional<IResource> getResource(MinecraftKey id) {
        return this.b.getResource(id);
    }

    @Override
    @Override
    public Set<String> a() {
        return this.b.a();
    }

    @Override
    @Override
    public List<IResource> a(MinecraftKey id) {
        return this.b.a(id);
    }

    @Override
    @Override
    public Map<MinecraftKey, IResource> b(String startingPath, Predicate<MinecraftKey> allowedPathPredicate) {
        return this.b.b(startingPath, allowedPathPredicate);
    }

    @Override
    @Override
    public Map<MinecraftKey, List<IResource>> c(String startingPath, Predicate<MinecraftKey> allowedPathPredicate) {
        return this.b.c(startingPath, allowedPathPredicate);
    }

    @Override
    @Override
    public Stream<IResourcePack> b() {
        return this.b.b();
    }
}

