/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.players.JsonListEntry;

public abstract class ExpirableListEntry<T>
extends JsonListEntry<T> {
    public static final SimpleDateFormat a = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
    public static final String b = "forever";
    protected final Date c;
    protected final String d;
    @Nullable
    protected final Date e;
    protected final String f;

    public ExpirableListEntry(T key, @Nullable Date creationDate, @Nullable String source, @Nullable Date expiryDate, @Nullable String reason) {
        super(key);
        this.c = creationDate == null ? new Date() : creationDate;
        this.d = source == null ? "(Unknown)" : source;
        this.e = expiryDate;
        this.f = reason == null ? "Banned by an operator." : reason;
    }

    protected ExpirableListEntry(T key, JsonObject json) {
        super(ExpirableListEntry.checkExpiry(key, json));
        Date date1;
        Date date;
        try {
            date = json.has("created") ? a.parse(json.get("created").getAsString()) : new Date();
        }
        catch (ParseException parseexception) {
            date = new Date();
        }
        this.c = date;
        this.d = json.has("source") ? json.get("source").getAsString() : "(Unknown)";
        try {
            date1 = json.has("expires") ? a.parse(json.get("expires").getAsString()) : null;
        }
        catch (ParseException parseexception1) {
            date1 = null;
        }
        this.e = date1;
        this.f = json.has("reason") ? json.get("reason").getAsString() : "Banned by an operator.";
    }

    public Date a() {
        return this.c;
    }

    public String b() {
        return this.d;
    }

    @Nullable
    public Date c() {
        return this.e;
    }

    public String d() {
        return this.f;
    }

    public abstract IChatBaseComponent e();

    @Override
    boolean f() {
        return this.e == null ? false : this.e.before(new Date());
    }

    @Override
    protected void a(JsonObject json) {
        json.addProperty("created", a.format(this.c));
        json.addProperty("source", this.d);
        json.addProperty("expires", this.e == null ? b : a.format(this.e));
        json.addProperty("reason", this.f);
    }

    private static <T> T checkExpiry(T object, JsonObject jsonobject) {
        Date expires = null;
        try {
            expires = jsonobject.has("expires") ? a.parse(jsonobject.get("expires").getAsString()) : null;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (expires == null || expires.after(new Date())) {
            return object;
        }
        return null;
    }
}

