/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import co.aikar.timings.MinecraftTimings;
import com.destroystokyo.paper.console.TerminalConsoleCommandSender;
import com.destroystokyo.paper.event.player.PlayerInitialSpawnEvent;
import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.event.profile.ProfileWhitelistVerifyEvent;
import com.destroystokyo.paper.event.server.WhitelistToggleEvent;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import io.netty.buffer.Unpooled;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.MCUtil;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.EnumChatFormat;
import net.minecraft.FileUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.ClientboundUpdateEnabledFeaturesPacket;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutCustomPayload;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutLogin;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRecipeUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutTags;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.game.PacketPlayOutViewDistance;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.GameProfileBanList;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.OpList;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.players.WhiteList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkEmpty;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public abstract class PlayerList {
    public static final File b = new File("banned-players.json");
    public static final File c = new File("banned-ips.json");
    public static final File d = new File("ops.json");
    public static final File e = new File("whitelist.json");
    public static final IChatBaseComponent f = IChatBaseComponent.c("chat.filtered_full");
    private static final Logger a = LogUtils.getLogger();
    private static final int h = 600;
    private static final SimpleDateFormat i = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer j;
    public final List<EntityPlayer> k = new CopyOnWriteArrayList<EntityPlayer>();
    private final Map<UUID, EntityPlayer> l = Maps.newHashMap();
    private final GameProfileBanList m;
    private final IpBanList n;
    private final OpList o;
    private final WhiteList p;
    public final WorldNBTStorage s;
    private boolean t;
    private final LayeredRegistryAccess<RegistryLayer> u;
    private final IRegistryCustom.Dimension v;
    public int g;
    private int w;
    private int x;
    private boolean y;
    private static final boolean z = false;
    private int A;
    private CraftServer cserver;
    private final Map<String, EntityPlayer> playersByName = new HashMap<String, EntityPlayer>();
    @Nullable
    public String collideRuleTeamName;

    public PlayerList(MinecraftServer server, LayeredRegistryAccess<RegistryLayer> registryManager, WorldNBTStorage saveHandler, int maxPlayers) {
        this.cserver = server.server = new CraftServer((DedicatedServer)server, this);
        server.console = new TerminalConsoleCommandSender();
        this.m = new GameProfileBanList(b);
        this.n = new IpBanList(c);
        this.o = new OpList(d);
        this.p = new WhiteList(e);
        this.j = server;
        this.u = registryManager;
        this.v = new IRegistryCustom.c(RegistrySynchronization.a(registryManager)).c();
        this.g = maxPlayers;
        this.s = saveHandler;
    }

    public abstract void loadAndSaveFiles();

    public void a(NetworkManager connection, EntityPlayer player) {
        WorldServer worldserver1;
        ResourceKey<net.minecraft.world.level.World> resourcekey;
        String s2;
        player.isRealPlayer = true;
        player.loginTime = System.currentTimeMillis();
        GameProfile gameprofile = player.fM();
        UserCache usercache = this.j.ap();
        if (usercache != null) {
            Optional<GameProfile> optional = usercache.a(gameprofile.getId());
            s2 = optional.map(GameProfile::getName).orElse(gameprofile.getName());
            usercache.a(gameprofile);
        } else {
            s2 = gameprofile.getName();
        }
        NBTTagCompound nbttagcompound = this.a(player);
        if (nbttagcompound != null && nbttagcompound.e("bukkit")) {
            NBTTagCompound bukkit = nbttagcompound.p("bukkit");
            String string = s2 = bukkit.b("lastKnownName", 8) ? bukkit.l("lastKnownName") : s2;
        }
        if (nbttagcompound != null && nbttagcompound.e("WorldUUIDMost") && nbttagcompound.e("WorldUUIDLeast")) {
            UUID uid = new UUID(nbttagcompound.i("WorldUUIDMost"), nbttagcompound.i("WorldUUIDLeast"));
            World bWorld = Bukkit.getServer().getWorld(uid);
            resourcekey = bWorld != null ? ((CraftWorld)bWorld).getHandle().ac() : net.minecraft.world.level.World.h;
        } else if (nbttagcompound != null) {
            DataResult<ResourceKey<net.minecraft.world.level.World>> dataresult = DimensionManager.a(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbttagcompound.c("Dimension")));
            Logger logger = a;
            Objects.requireNonNull(logger);
            resourcekey = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(net.minecraft.world.level.World.h);
        } else {
            resourcekey = net.minecraft.world.level.World.h;
        }
        ResourceKey<net.minecraft.world.level.World> resourcekey1 = resourcekey;
        WorldServer worldserver = this.j.a(resourcekey1);
        if (worldserver == null) {
            a.warn("Unknown respawn dimension {}, defaulting to overworld", resourcekey1);
            worldserver1 = this.j.D();
        } else {
            worldserver1 = worldserver;
        }
        if (nbttagcompound == null) {
            player.spawnReason = CreatureSpawnEvent.SpawnReason.DEFAULT;
            player.d(worldserver1);
        }
        player.c(worldserver1);
        String s1 = "local";
        if (connection.c() != null) {
            s1 = GlobalConfiguration.get().logging.logPlayerIpAddresses ? connection.c().toString() : "<ip address withheld>";
        }
        CraftPlayer spawnPlayer = player.getBukkitEntity();
        PlayerInitialSpawnEvent ev = new PlayerInitialSpawnEvent((Player)spawnPlayer, spawnPlayer.getLocation());
        this.cserver.getPluginManager().callEvent((Event)ev);
        Location loc = ev.getSpawnLocation();
        worldserver1 = ((CraftWorld)loc.getWorld()).getHandle();
        player.spawnIn(worldserver1);
        player.e.a((WorldServer)player.dI());
        player.p(loc.getX(), loc.getY(), loc.getZ());
        player.a(loc.getYaw(), loc.getPitch());
        WorldData worlddata = worldserver1.u_();
        player.c(nbttagcompound);
        PlayerConnection playerconnection = new PlayerConnection(this.j, connection, player);
        GameRules gamerules = worldserver1.X();
        boolean flag = gamerules.b(GameRules.B);
        boolean flag1 = gamerules.b(GameRules.p);
        playerconnection.a(new PacketPlayOutLogin(player.af(), worlddata.n(), player.e.b(), player.e.c(), this.j.E(), this.v, worldserver1.aa(), worldserver1.ac(), BiomeManager.a(worldserver1.A()), this.n(), worldserver1.getWorld().getSendViewDistance(), worldserver1.getWorld().getSimulationDistance(), flag1, !flag, worldserver1.af(), worldserver1.z(), player.gm(), player.ar()));
        player.getBukkitEntity().sendSupportedChannels();
        playerconnection.a(new ClientboundUpdateEnabledFeaturesPacket(FeatureFlags.c.b(worldserver1.G())));
        playerconnection.a(new PacketPlayOutCustomPayload(PacketPlayOutCustomPayload.a, new PacketDataSerializer(Unpooled.buffer()).a(this.c().getServerModName())));
        playerconnection.a(new PacketPlayOutServerDifficulty(worlddata.s(), worlddata.t()));
        playerconnection.a(new PacketPlayOutAbilities(player.fO()));
        playerconnection.a(new PacketPlayOutHeldItemSlot(player.fN().l));
        playerconnection.a(new PacketPlayOutRecipeUpdate(this.j.aE().b()));
        playerconnection.a(new PacketPlayOutTags(TagNetworkSerialization.a(this.u)));
        this.d(player);
        player.D().c();
        player.E().a(player);
        this.a(worldserver1.f(), player);
        this.j.ar();
        IChatMutableComponent ichatmutablecomponent = player.fM().getName().equalsIgnoreCase(s2) ? IChatBaseComponent.a("multiplayer.player.joined", player.H_()) : IChatBaseComponent.a("multiplayer.player.joined.renamed", player.H_(), s2);
        ichatmutablecomponent.a(EnumChatFormat.o);
        IChatBaseComponent joinMessage = ichatmutablecomponent;
        playerconnection.a(player.dn(), player.dp(), player.dt(), player.dy(), player.dA());
        ServerPing serverping = this.j.aq();
        if (serverping != null) {
            player.a(serverping);
        }
        this.k.add(player);
        this.playersByName.put(player.cv().toLowerCase(Locale.ROOT), player);
        this.l.put(player.ct(), player);
        player.supressTrackerForLogin = true;
        worldserver1.c(player);
        this.j.aJ().a(player);
        this.mountSavedVehicle(player, worldserver1, nbttagcompound);
        CraftPlayer bukkitPlayer = player.getBukkitEntity();
        player.bR.transferTo(player.bR, bukkitPlayer);
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent((Player)bukkitPlayer, PaperAdventure.asAdventure(ichatmutablecomponent));
        this.cserver.getPluginManager().callEvent((Event)playerJoinEvent);
        if (!player.c.a()) {
            return;
        }
        Component jm = playerJoinEvent.joinMessage();
        if (jm != null && !jm.equals(Component.empty())) {
            joinMessage = PaperAdventure.asVanilla(jm);
            this.j.ac().a(joinMessage, false);
        }
        ClientboundPlayerInfoUpdatePacket packet = ClientboundPlayerInfoUpdatePacket.a(List.of(player));
        ArrayList onlinePlayers = Lists.newArrayListWithExpectedSize((int)(this.k.size() - 1));
        for (int i2 = 0; i2 < this.k.size(); ++i2) {
            EntityPlayer entityplayer1 = this.k.get(i2);
            if (entityplayer1.getBukkitEntity().canSee(bukkitPlayer)) {
                if (entityplayer1.getBukkitEntity().isListed(bukkitPlayer)) {
                    entityplayer1.c.a(packet);
                } else {
                    entityplayer1.c.a(ClientboundPlayerInfoUpdatePacket.createSinglePlayerInitializing(player, false));
                }
            }
            if (entityplayer1 == player || !bukkitPlayer.canSee(entityplayer1.getBukkitEntity())) continue;
            onlinePlayers.add(entityplayer1);
        }
        if (!onlinePlayers.isEmpty()) {
            player.c.a(ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(onlinePlayers, player));
        }
        player.sentListPacket = true;
        player.supressTrackerForLogin = false;
        ((WorldServer)player.dI()).k().a.a((Entity)player);
        this.a(player, worldserver1);
        if (player.dI() == worldserver1 && !worldserver1.v().contains(player)) {
            worldserver1.c(player);
            this.j.aJ().a(player);
        }
        worldserver1 = player.x();
        this.j.S().ifPresent(minecraftserver_serverresourcepackinfo -> player.a(minecraftserver_serverresourcepackinfo.a(), minecraftserver_serverresourcepackinfo.b(), minecraftserver_serverresourcepackinfo.c(), minecraftserver_serverresourcepackinfo.d()));
        for (MobEffect mobeffect : player.eo()) {
            playerconnection.a(new PacketPlayOutEntityEffect(player.af(), mobeffect));
        }
        this.onPlayerJoinFinish(player, worldserver1, s1);
        if (player.es()) {
            Holder.c<BiomeBase> plains = worldserver1.B_().d(Registries.ap).f(Biomes.b);
            player.c.a(new ClientboundLevelChunkWithLightPacket(new ChunkEmpty((net.minecraft.world.level.World)worldserver1, player.dk(), plains), worldserver1.s_(), null, null, false));
        }
    }

    private void mountSavedVehicle(EntityPlayer player, WorldServer worldserver1, NBTTagCompound nbttagcompound) {
        if (nbttagcompound != null && nbttagcompound.b("RootVehicle", 10)) {
            NBTTagCompound nbttagcompound1 = nbttagcompound.p("RootVehicle");
            WorldServer finalWorldServer = worldserver1;
            Entity entity = EntityTypes.a(nbttagcompound1.p("Entity"), finalWorldServer, entity1 -> !finalWorldServer.addWithUUID((Entity)entity1, CreatureSpawnEvent.SpawnReason.MOUNT) ? null : entity1);
            if (entity != null) {
                UUID uuid = nbttagcompound1.b("Attach") ? nbttagcompound1.a("Attach") : null;
                if (entity.ct().equals(uuid)) {
                    player.a(entity, true);
                } else {
                    for (Entity entity12 : entity.cR()) {
                        if (!entity12.ct().equals(uuid)) continue;
                        player.a(entity12, true);
                        break;
                    }
                }
                if (!player.bM()) {
                    a.warn("Couldn't reattach entity to player");
                    entity.ai();
                    for (Entity entity12 : entity.cR()) {
                        entity12.ai();
                    }
                }
            }
        }
    }

    public void onPlayerJoinFinish(EntityPlayer player, WorldServer worldserver1, String s1) {
        player.h();
        ScoreboardServer scoreboard = this.c().a(net.minecraft.world.level.World.h).f();
        ScoreboardTeam collideRuleTeam = scoreboard.f(this.collideRuleTeamName);
        if (this.collideRuleTeamName != null && collideRuleTeam != null && player.cd() == null) {
            ((Scoreboard)scoreboard).a(player.cv(), collideRuleTeam);
        }
        a.info("{}[{}] logged in with entity id {} at ([{}]{}, {}, {})", new Object[]{player.Z().getString(), s1, player.af(), worldserver1.K.g(), player.dn(), player.dp(), player.dt()});
    }

    public void a(ScoreboardServer scoreboard, EntityPlayer player) {
        HashSet set = Sets.newHashSet();
        for (ScoreboardTeam scoreboardteam : scoreboard.g()) {
            player.c.a(PacketPlayOutScoreboardTeam.a(scoreboardteam, true));
        }
        for (int i2 = 0; i2 < 19; ++i2) {
            ScoreboardObjective scoreboardobjective = scoreboard.a(i2);
            if (scoreboardobjective == null || set.contains(scoreboardobjective)) continue;
            List<Packet<?>> list = scoreboard.d(scoreboardobjective);
            for (Packet<?> packet : list) {
                player.c.a(packet);
            }
            set.add(scoreboardobjective);
        }
    }

    public void a(WorldServer world) {
        if (this.s != null) {
            return;
        }
        world.w_().a(new IWorldBorderListener(){

            @Override
            public void a(WorldBorder border, double size) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderSizePacket(border), border.world);
            }

            @Override
            public void a(WorldBorder border, double fromSize, double toSize, long time) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderLerpSizePacket(border), border.world);
            }

            @Override
            public void a(WorldBorder border, double centerX, double centerZ) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderCenterPacket(border), border.world);
            }

            @Override
            public void a(WorldBorder border, int warningTime) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderWarningDelayPacket(border), border.world);
            }

            @Override
            public void b(WorldBorder border, int warningBlockDistance) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderWarningDistancePacket(border), border.world);
            }

            @Override
            public void b(WorldBorder border, double damagePerBlock) {
            }

            @Override
            public void c(WorldBorder border, double safeZoneRadius) {
            }
        });
    }

    @Nullable
    public NBTTagCompound a(EntityPlayer player) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = this.j.aU().y();
        if (this.j.a(player.fM()) && nbttagcompound != null) {
            nbttagcompound1 = nbttagcompound;
            player.g(nbttagcompound);
            a.debug("loading single player");
        } else {
            nbttagcompound1 = this.s.b(player);
        }
        return nbttagcompound1;
    }

    protected void b(EntityPlayer player) {
        AdvancementDataPlayer advancementdataplayer;
        if (!player.getBukkitEntity().isPersistent()) {
            return;
        }
        player.lastSave = MinecraftServer.currentTick;
        this.s.a(player);
        ServerStatisticManager serverstatisticmanager = player.D();
        if (serverstatisticmanager != null) {
            serverstatisticmanager.a();
        }
        if ((advancementdataplayer = player.M()) != null) {
            advancementdataplayer.b();
        }
    }

    public Component remove(EntityPlayer entityplayer) {
        return this.remove(entityplayer, (Component)Component.translatable((String)"multiplayer.player.left", (TextColor)NamedTextColor.YELLOW, (ComponentLike[])new ComponentLike[]{GlobalConfiguration.get().messages.useDisplayNameInQuitMessage ? entityplayer.getBukkitEntity().displayName() : PaperAdventure.asAdventure(entityplayer.H_())}));
    }

    public Component remove(EntityPlayer entityplayer, Component leaveMessage) {
        Entity entity;
        WorldServer worldserver = entityplayer.x();
        entityplayer.a(StatisticList.j);
        if (entityplayer.bR != entityplayer.bQ) {
            entityplayer.closeContainer(InventoryCloseEvent.Reason.DISCONNECT);
        }
        PlayerQuitEvent playerQuitEvent = new PlayerQuitEvent((Player)entityplayer.getBukkitEntity(), leaveMessage, entityplayer.quitReason);
        this.cserver.getPluginManager().callEvent((Event)playerQuitEvent);
        entityplayer.getBukkitEntity().disconnect(playerQuitEvent.getQuitMessage());
        if (this.j.bl()) {
            entityplayer.m();
        }
        if (this.collideRuleTeamName != null) {
            ScoreboardServer scoreBoard = this.j.a(net.minecraft.world.level.World.h).f();
            ScoreboardTeam team = scoreBoard.i(this.collideRuleTeamName);
            if (entityplayer.cd() == team && team != null) {
                ((Scoreboard)scoreBoard).b(entityplayer.cv(), team);
            }
        }
        if (!entityplayer.bR.g().b()) {
            ItemStack carried = entityplayer.bR.g();
            entityplayer.bR.b(ItemStack.b);
            entityplayer.a(carried, false);
        }
        this.b(entityplayer);
        if (entityplayer.bM() && (entity = entityplayer.cT()).cS()) {
            a.debug("Removing player mount");
            entityplayer.Y();
            entity.cQ().forEach(entity1 -> {
                EntityVillagerAbstract villager;
                EntityHuman human;
                if (entity1 instanceof EntityVillagerAbstract && (human = (villager = (EntityVillagerAbstract)entity1).fY()) != null) {
                    villager.f((EntityHuman)null);
                }
                entity1.b(Entity.RemovalReason.d);
            });
        }
        entityplayer.ac();
        worldserver.a(entityplayer, Entity.RemovalReason.d);
        entityplayer.retireScheduler();
        entityplayer.M().a();
        this.k.remove(entityplayer);
        this.playersByName.remove(entityplayer.cv().toLowerCase(Locale.ROOT));
        this.j.aJ().b(entityplayer);
        UUID uuid = entityplayer.ct();
        EntityPlayer entityplayer1 = this.l.get(uuid);
        if (entityplayer1 == entityplayer) {
            this.l.remove(uuid);
        }
        ClientboundPlayerInfoRemovePacket packet = new ClientboundPlayerInfoRemovePacket(List.of(entityplayer.ct()));
        for (int i2 = 0; i2 < this.k.size(); ++i2) {
            EntityPlayer entityplayer2 = this.k.get(i2);
            if (entityplayer2.getBukkitEntity().canSee(entityplayer.getBukkitEntity())) {
                entityplayer2.c.a(packet);
                continue;
            }
            entityplayer2.getBukkitEntity().onEntityRemove(entityplayer);
        }
        this.cserver.getScoreboardManager().removePlayer(entityplayer.getBukkitEntity());
        return playerQuitEvent.quitMessage();
    }

    public EntityPlayer canPlayerLogin(LoginListener loginlistener, GameProfile gameprofile) {
        GameProfileBanEntry gameprofilebanentry;
        UUID uuid = UUIDUtil.a(gameprofile);
        ArrayList list = Lists.newArrayList();
        for (int i2 = 0; i2 < this.k.size(); ++i2) {
            EntityPlayer entityplayer = this.k.get(i2);
            if (!entityplayer.ct().equals(uuid) && (!GlobalConfiguration.get().proxies.isProxyOnlineMode() || !entityplayer.fM().getName().equalsIgnoreCase(gameprofile.getName()))) continue;
            list.add(entityplayer);
        }
        for (EntityPlayer entityplayer : list) {
            this.b(entityplayer);
            entityplayer.c.disconnect(IChatBaseComponent.a("multiplayer.disconnect.duplicate_login", new Object[0]), PlayerKickEvent.Cause.DUPLICATE_LOGIN);
        }
        SocketAddress socketaddress = loginlistener.g.c();
        EntityPlayer entity = new EntityPlayer(this.j, this.j.a(net.minecraft.world.level.World.h), gameprofile);
        CraftPlayer player = entity.getBukkitEntity();
        PlayerLoginEvent event = new PlayerLoginEvent((Player)player, loginlistener.g.hostname, ((InetSocketAddress)socketaddress).getAddress(), ((InetSocketAddress)loginlistener.g.m.remoteAddress()).getAddress());
        if (this.f().a(gameprofile) && (gameprofilebanentry = (GameProfileBanEntry)this.f().b(gameprofile)) != null) {
            IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("multiplayer.disconnect.banned.reason", new Object[]{gameprofilebanentry.d()});
            if (gameprofilebanentry.c() != null) {
                ichatmutablecomponent.b(IChatBaseComponent.a("multiplayer.disconnect.banned.expiration", new Object[]{i.format(gameprofilebanentry.c())}));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, PaperAdventure.asAdventure(ichatmutablecomponent));
        } else if (this.isWhiteListed(gameprofile, event)) {
            if (this.g().a(socketaddress) && this.g().b(socketaddress) != null && !this.g().b(socketaddress).f()) {
                IpBanEntry ipbanentry = this.n.b(socketaddress);
                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("multiplayer.disconnect.banned_ip.reason", new Object[]{ipbanentry.d()});
                if (ipbanentry.c() != null) {
                    ichatmutablecomponent.b(IChatBaseComponent.a("multiplayer.disconnect.banned_ip.expiration", new Object[]{i.format(ipbanentry.c())}));
                }
                event.disallow(PlayerLoginEvent.Result.KICK_BANNED, PaperAdventure.asAdventure(ichatmutablecomponent));
            } else if (this.k.size() >= this.g && !this.d(gameprofile)) {
                event.disallow(PlayerLoginEvent.Result.KICK_FULL, (Component)LegacyComponentSerializer.legacySection().deserialize(SpigotConfig.serverFullMessage));
            }
        }
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            loginlistener.b(PaperAdventure.asVanilla(event.kickMessage()));
            return null;
        }
        return entity;
    }

    public EntityPlayer getPlayerForLogin(GameProfile gameprofile, EntityPlayer player) {
        return player;
    }

    public EntityPlayer respawn(EntityPlayer entityplayer, boolean flag, PlayerRespawnEvent.RespawnReason reason) {
        return this.respawn(entityplayer, this.j.a(entityplayer.P()), flag, null, true, reason);
    }

    public EntityPlayer respawn(EntityPlayer entityplayer, WorldServer worldserver, boolean flag, Location location, boolean avoidSuffocation, PlayerRespawnEvent.RespawnReason reason) {
        return this.respawn(entityplayer, worldserver, flag, location, avoidSuffocation, reason, new PlayerRespawnEvent.RespawnFlag[0]);
    }

    public EntityPlayer respawn(EntityPlayer entityplayer, WorldServer worldserver, boolean flag, Location location, boolean avoidSuffocation, PlayerRespawnEvent.RespawnReason reason, PlayerRespawnEvent.RespawnFlag ... respawnFlags) {
        WorldServer worldserver1;
        entityplayer.Y();
        this.k.remove(entityplayer);
        this.playersByName.remove(entityplayer.cv().toLowerCase(Locale.ROOT));
        entityplayer.x().a(entityplayer, Entity.RemovalReason.b);
        BlockPosition blockposition = entityplayer.N();
        float f2 = entityplayer.O();
        boolean flag1 = entityplayer.Q();
        EntityPlayer entityplayer1 = entityplayer;
        World fromWorld = entityplayer.getBukkitEntity().getWorld();
        entityplayer.g = false;
        entityplayer1.c = entityplayer.c;
        entityplayer1.a(entityplayer, flag);
        entityplayer1.e(entityplayer.af());
        entityplayer1.a(entityplayer.fh());
        for (String s2 : entityplayer.ag()) {
            entityplayer1.a(s2);
        }
        boolean flag2 = false;
        boolean isBedSpawn = false;
        boolean isAnchorSpawn = false;
        boolean isRespawn = false;
        boolean isLocAltered = false;
        if (location == null) {
            worldserver1 = this.j.a(entityplayer.P());
            if (worldserver1 != null) {
                Optional<Object> optional = blockposition != null ? EntityHuman.a(worldserver1, blockposition, f2, flag1, true) : Optional.empty();
                if (optional.isPresent()) {
                    float f1;
                    boolean flag3;
                    IBlockData iblockdata = worldserver1.a_(blockposition);
                    isAnchorSpawn = flag3 = iblockdata.a(Blocks.pl);
                    Vec3D vec3d = (Vec3D)optional.get();
                    if (!iblockdata.a(TagsBlock.R) && !flag3) {
                        f1 = f2;
                    } else {
                        Vec3D vec3d1 = Vec3D.c(blockposition).d(vec3d).d();
                        f1 = (float)MathHelper.d(MathHelper.d(vec3d1.e, vec3d1.c) * 57.2957763671875 - 90.0);
                    }
                    flag2 = !flag && flag3;
                    isBedSpawn = true;
                    location = CraftLocation.toBukkit(vec3d, (World)worldserver1.getWorld(), f1, 0.0f);
                } else if (blockposition != null) {
                    entityplayer1.c.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.a, 0.0f));
                    entityplayer1.setRespawnPosition(null, null, 0.0f, false, false, PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN);
                }
            }
            if (location == null) {
                worldserver1 = this.j.a(net.minecraft.world.level.World.h);
                blockposition = entityplayer1.getSpawnPoint(worldserver1);
                location = CraftLocation.toBukkit(blockposition, (World)worldserver1.getWorld(), worldserver1.A.d(), 0.0f).add(0.5, (double)0.1f, 0.5);
            }
            CraftPlayer respawnPlayer = entityplayer1.getBukkitEntity();
            PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent((Player)respawnPlayer, location, isBedSpawn && !isAnchorSpawn, isAnchorSpawn, reason, ImmutableSet.builder().add((Object[])respawnFlags));
            this.cserver.getPluginManager().callEvent((Event)respawnEvent);
            if (entityplayer.c.isDisconnected()) {
                return entityplayer;
            }
            if (!location.equals((Object)respawnEvent.getRespawnLocation())) {
                location = respawnEvent.getRespawnLocation();
                isLocAltered = true;
            }
            if (!flag) {
                entityplayer.reset();
            }
            isRespawn = true;
        } else {
            location.setWorld((World)worldserver.getWorld());
        }
        worldserver1 = ((CraftWorld)location.getWorld()).getHandle();
        entityplayer1.forceSetPositionRotation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        worldserver1.k().a(TicketType.g, new ChunkCoordIntPair(location.getBlockX() >> 4, location.getBlockZ() >> 4), 1, entityplayer.af());
        while (avoidSuffocation && !worldserver1.noCollision(entityplayer1, entityplayer1.cE(), true) && entityplayer1.dp() < (double)worldserver1.aj()) {
            entityplayer1.e(entityplayer1.dn(), entityplayer1.dp() + 1.0, entityplayer1.dt());
        }
        boolean i2 = flag;
        WorldData worlddata = worldserver1.u_();
        entityplayer1.c.a(new PacketPlayOutRespawn(worldserver1.aa(), worldserver1.ac(), BiomeManager.a(worldserver1.A()), entityplayer1.e.b(), entityplayer1.e.c(), worldserver1.af(), worldserver1.z(), (byte)(i2 ? 1 : 0), entityplayer1.gm(), entityplayer1.ar()));
        entityplayer1.c.a(new PacketPlayOutViewDistance(worldserver1.getWorld().getSendViewDistance()));
        entityplayer1.c.a(new ClientboundSetSimulationDistancePacket(worldserver1.getWorld().getSimulationDistance()));
        entityplayer1.spawnIn(worldserver1);
        entityplayer1.dF();
        entityplayer1.c.teleport(CraftLocation.toBukkit(entityplayer1.dg(), (World)worldserver1.getWorld(), entityplayer1.dy(), entityplayer1.dA()));
        entityplayer1.f(false);
        entityplayer1.c.a(new PacketPlayOutSpawnPosition(worldserver1.R(), worldserver1.S()));
        entityplayer1.c.a(new PacketPlayOutServerDifficulty(worlddata.s(), worlddata.t()));
        entityplayer1.c.a(new PacketPlayOutExperience(entityplayer1.cg, entityplayer1.cf, entityplayer1.ce));
        this.a(entityplayer1, worldserver1);
        this.d(entityplayer1);
        if (!entityplayer.c.isDisconnected()) {
            worldserver1.d(entityplayer1);
            this.k.add(entityplayer1);
            this.playersByName.put(entityplayer1.cv().toLowerCase(Locale.ROOT), entityplayer1);
            this.l.put(entityplayer1.ct(), entityplayer1);
        }
        entityplayer1.t(entityplayer1.er());
        if (flag2 && !isLocAltered) {
            if (!flag1) {
                IBlockData data = worldserver1.a_(blockposition);
                worldserver1.a(blockposition, (IBlockData)data.a(BlockRespawnAnchor.c, data.c(BlockRespawnAnchor.c) - 1), 3);
            }
            entityplayer1.c.a(new PacketPlayOutNamedSoundEffect(SoundEffects.tL, SoundCategory.e, location.getX(), location.getY(), location.getZ(), 1.0f, 1.0f, worldserver1.y_().g()));
        }
        this.e(entityplayer);
        entityplayer.w();
        for (MobEffect mobEffect : entityplayer.eo()) {
            entityplayer.c.a(new PacketPlayOutEntityEffect(entityplayer.af(), mobEffect));
        }
        entityplayer.e(((CraftWorld)fromWorld).getHandle());
        if (fromWorld != location.getWorld()) {
            PlayerChangedWorldEvent event = new PlayerChangedWorldEvent((Player)entityplayer.getBukkitEntity(), fromWorld);
            this.j.server.getPluginManager().callEvent((Event)event);
        }
        if (entityplayer.c.isDisconnected()) {
            this.b(entityplayer);
        }
        if (isRespawn) {
            this.cserver.getPluginManager().callEvent((Event)new PlayerPostRespawnEvent((Player)entityplayer.getBukkitEntity(), location, isBedSpawn));
        }
        return entityplayer1;
    }

    public void d(EntityPlayer player) {
        GameProfile gameprofile = player.fM();
        int i2 = this.j.c(gameprofile);
        this.a(player, i2);
    }

    public void d() {
        if (++this.A > 600) {
            for (int i2 = 0; i2 < this.k.size(); ++i2) {
                final EntityPlayer target = this.k.get(i2);
                target.c.a(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.e), this.k.stream().filter(new Predicate<EntityPlayer>(){

                    @Override
                    public boolean test(EntityPlayer input) {
                        return target.getBukkitEntity().canSee(input.getBukkitEntity());
                    }
                }).collect(Collectors.toList())));
            }
            this.A = 0;
        }
    }

    public void a(Packet<?> packet) {
        for (EntityPlayer entityplayer : this.k) {
            entityplayer.c.a(packet);
        }
    }

    public void broadcastAll(Packet packet, EntityHuman entityhuman) {
        for (int i2 = 0; i2 < this.k.size(); ++i2) {
            EntityPlayer entityplayer = this.k.get(i2);
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity())) continue;
            this.k.get((int)i2).c.a(packet);
        }
    }

    public void broadcastAll(Packet packet, net.minecraft.world.level.World world) {
        for (int i2 = 0; i2 < world.v().size(); ++i2) {
            ((EntityPlayer)world.v().get((int)i2)).c.a(packet);
        }
    }

    public void a(Packet<?> packet, ResourceKey<net.minecraft.world.level.World> dimension) {
        for (EntityPlayer entityplayer : this.k) {
            if (entityplayer.dI().ac() != dimension) continue;
            entityplayer.c.a(packet);
        }
    }

    public void a(EntityHuman source, IChatBaseComponent message) {
        ScoreboardTeamBase scoreboardteambase = source.cd();
        if (scoreboardteambase != null) {
            Collection<String> collection = scoreboardteambase.g();
            for (String s2 : collection) {
                EntityPlayer entityplayer = this.a(s2);
                if (entityplayer == null || entityplayer == source) continue;
                entityplayer.a(message);
            }
        }
    }

    public void b(EntityHuman source, IChatBaseComponent message) {
        ScoreboardTeamBase scoreboardteambase = source.cd();
        if (scoreboardteambase == null) {
            this.a(message, false);
        } else {
            for (int i2 = 0; i2 < this.k.size(); ++i2) {
                EntityPlayer entityplayer = this.k.get(i2);
                if (entityplayer.cd() == scoreboardteambase) continue;
                entityplayer.a(message);
            }
        }
    }

    public String[] e() {
        String[] astring = new String[this.k.size()];
        for (int i2 = 0; i2 < this.k.size(); ++i2) {
            astring[i2] = this.k.get(i2).fM().getName();
        }
        return astring;
    }

    public GameProfileBanList f() {
        return this.m;
    }

    public IpBanList g() {
        return this.n;
    }

    public void a(GameProfile profile) {
        this.o.a(new OpListEntry(profile, this.j.i(), this.o.a(profile)));
        EntityPlayer entityplayer = this.a(profile.getId());
        if (entityplayer != null) {
            this.d(entityplayer);
        }
    }

    public void b(GameProfile profile) {
        this.o.c(profile);
        EntityPlayer entityplayer = this.a(profile.getId());
        if (entityplayer != null) {
            this.d(entityplayer);
        }
    }

    private void a(EntityPlayer player, int permissionLevel) {
        this.sendPlayerPermissionLevel(player, permissionLevel, true);
    }

    public void sendPlayerPermissionLevel(EntityPlayer player, int permissionLevel, boolean recalculatePermissions) {
        if (player.c != null) {
            byte b0 = permissionLevel <= 0 ? (byte)24 : (permissionLevel >= 4 ? (byte)28 : (byte)((byte)(24 + permissionLevel)));
            player.c.a(new PacketPlayOutEntityStatus(player, b0));
        }
        if (recalculatePermissions) {
            player.getBukkitEntity().recalculatePermissions();
            this.j.aC().a(player);
        }
    }

    public boolean c(GameProfile profile) {
        return this.isWhiteListed(profile, null);
    }

    public boolean isWhiteListed(GameProfile gameprofile, PlayerLoginEvent loginEvent) {
        boolean isOp = this.o.d(gameprofile);
        boolean isWhitelisted = !this.t || isOp || this.p.d(gameprofile);
        ProfileWhitelistVerifyEvent event = new ProfileWhitelistVerifyEvent(MCUtil.toBukkit(gameprofile), this.t, isWhitelisted, isOp, SpigotConfig.whitelistMessage);
        event.callEvent();
        if (!event.isWhitelisted()) {
            if (loginEvent != null) {
                loginEvent.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, (Component)LegacyComponentSerializer.legacySection().deserialize(event.getKickMessage() == null ? SpigotConfig.whitelistMessage : event.getKickMessage()));
            }
            return false;
        }
        return true;
    }

    public boolean f(GameProfile profile) {
        return this.o.d(profile) || this.j.a(profile) && this.j.aU().o() || this.y;
    }

    @Nullable
    public EntityPlayer a(String name) {
        return this.playersByName.get(name.toLowerCase(Locale.ROOT));
    }

    public void a(@Nullable EntityHuman player, double x2, double y2, double z2, double distance, ResourceKey<net.minecraft.world.level.World> worldKey, Packet<?> packet) {
        for (int i2 = 0; i2 < this.k.size(); ++i2) {
            double d6;
            double d5;
            double d4;
            EntityPlayer entityplayer = this.k.get(i2);
            if (player != null && !entityplayer.getBukkitEntity().canSee(player.getBukkitEntity()) || entityplayer == player || entityplayer.dI().ac() != worldKey || !((d4 = x2 - entityplayer.dn()) * d4 + (d5 = y2 - entityplayer.dp()) * d5 + (d6 = z2 - entityplayer.dt()) * d6 < distance * distance)) continue;
            entityplayer.c.a(packet);
        }
    }

    public void h() {
        this.saveAll(-1);
    }

    public void saveAll(int interval) {
        MCUtil.ensureMain("Save Players", () -> {
            MinecraftTimings.savePlayers.startTiming();
            int numSaved = 0;
            long now = MinecraftServer.currentTick;
            for (int i2 = 0; i2 < this.k.size(); ++i2) {
                EntityPlayer entityplayer = this.k.get(i2);
                if (interval != -1 && now - entityplayer.lastSave < (long)interval) continue;
                this.b(entityplayer);
                if (interval != -1 && ++numSaved >= GlobalConfiguration.get().playerAutoSave.maxPerTick()) break;
            }
            MinecraftTimings.savePlayers.stopTiming();
            return null;
        });
    }

    public WhiteList i() {
        return this.p;
    }

    public String[] j() {
        return this.p.a();
    }

    public OpList k() {
        return this.o;
    }

    public String[] l() {
        return this.o.a();
    }

    public void a() {
    }

    public void a(EntityPlayer player, WorldServer world) {
        WorldBorder worldborder = player.dI().w_();
        player.c.a(new ClientboundInitializeBorderPacket(worldborder));
        player.c.a(new PacketPlayOutUpdateTime(world.V(), world.W(), world.X().b(GameRules.k)));
        player.c.a(new PacketPlayOutSpawnPosition(world.R(), world.S()));
        if (world.Z()) {
            player.setPlayerWeather(WeatherType.DOWNFALL, false);
            player.updateWeather(-world.w, world.w, -world.y, world.y);
        }
    }

    public void e(EntityPlayer player) {
        player.bQ.b();
        player.getBukkitEntity().updateScaledHealth();
        player.aj().refresh(player);
        player.c.a(new PacketPlayOutHeldItemSlot(player.fN().l));
        int i2 = player.dI().X().b(GameRules.p) ? 22 : 23;
        player.c.a(new PacketPlayOutEntityStatus(player, (byte)i2));
        float immediateRespawn = player.dI().X().b(GameRules.B) ? 1.0f : 0.0f;
        player.c.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.l, immediateRespawn));
    }

    public int m() {
        return this.k.size();
    }

    public int n() {
        return this.g;
    }

    public boolean o() {
        return this.t;
    }

    public void a(boolean whitelistEnabled) {
        new WhitelistToggleEvent(whitelistEnabled).callEvent();
        this.t = whitelistEnabled;
    }

    public List<EntityPlayer> b(String ip) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer entityplayer : this.k) {
            if (!entityplayer.y().equals(ip)) continue;
            list.add(entityplayer);
        }
        return list;
    }

    public int p() {
        return this.w;
    }

    public int q() {
        return this.x;
    }

    public MinecraftServer c() {
        return this.j;
    }

    @Nullable
    public NBTTagCompound r() {
        return null;
    }

    public void b(boolean cheatsAllowed) {
        this.y = cheatsAllowed;
    }

    public void s() {
        this.removeAll(false);
    }

    public void removeAll(boolean isRestarting) {
        ScoreboardServer scoreboard;
        ScoreboardTeam team;
        for (EntityPlayer player : this.k) {
            if (isRestarting) {
                player.c.disconnect(SpigotConfig.restartMessage, PlayerKickEvent.Cause.UNKNOWN);
                continue;
            }
            player.c.disconnect(this.j.server.shutdownMessage(), PlayerKickEvent.Cause.UNKNOWN);
        }
        if (this.collideRuleTeamName != null && (team = (scoreboard = this.c().a(net.minecraft.world.level.World.h).f()).i(this.collideRuleTeamName)) != null) {
            scoreboard.d(team);
        }
    }

    public void broadcastMessage(IChatBaseComponent[] iChatBaseComponents) {
        for (IChatBaseComponent component : iChatBaseComponents) {
            this.a(component, false);
        }
    }

    public void a(IChatBaseComponent message, boolean overlay) {
        this.a(message, (EntityPlayer entityplayer) -> message, overlay);
    }

    public void a(IChatBaseComponent message, Function<EntityPlayer, IChatBaseComponent> playerMessageFactory, boolean overlay) {
        this.j.a(message);
        for (EntityPlayer entityplayer : this.k) {
            IChatBaseComponent ichatbasecomponent1 = playerMessageFactory.apply(entityplayer);
            if (ichatbasecomponent1 == null) continue;
            entityplayer.b(ichatbasecomponent1, overlay);
        }
    }

    public void a(PlayerChatMessage message, CommandListenerWrapper source, ChatMessageType.a params) {
        Objects.requireNonNull(source);
        this.a(message, source::a, source.i(), params);
    }

    public void a(PlayerChatMessage message, EntityPlayer sender, ChatMessageType.a params) {
        this.broadcastChatMessage(message, sender, params, null);
    }

    public void broadcastChatMessage(PlayerChatMessage message, EntityPlayer sender, ChatMessageType.a params, @Nullable Function<Audience, IChatBaseComponent> unsignedFunction) {
        Objects.requireNonNull(sender);
        this.broadcastChatMessage(message, sender::b, sender, params, unsignedFunction);
    }

    private void a(PlayerChatMessage message, Predicate<EntityPlayer> shouldSendFiltered, @Nullable EntityPlayer sender, ChatMessageType.a params) {
        this.broadcastChatMessage(message, shouldSendFiltered, sender, params, null);
    }

    public void broadcastChatMessage(PlayerChatMessage message, Predicate<EntityPlayer> shouldSendFiltered, @Nullable EntityPlayer sender, ChatMessageType.a params, @Nullable Function<Audience, IChatBaseComponent> unsignedFunction) {
        boolean flag = this.a(message);
        this.j.a(unsignedFunction == null ? message.c() : unsignedFunction.apply((Audience)this.j.console), params, flag ? null : "Not Secure");
        OutgoingChatMessage outgoingchatmessage = OutgoingChatMessage.a(message);
        boolean flag1 = false;
        ClientboundDisguisedChatPacket disguised = sender != null && unsignedFunction == null ? new ClientboundDisguisedChatPacket(outgoingchatmessage.a(), params.a(sender.dI().B_())) : null;
        for (EntityPlayer entityplayer1 : this.k) {
            boolean flag2 = shouldSendFiltered.test(entityplayer1);
            if (sender != null && !entityplayer1.getBukkitEntity().canSee(sender.getBukkitEntity())) {
                entityplayer1.c.a(unsignedFunction != null ? new ClientboundDisguisedChatPacket(unsignedFunction.apply((Audience)entityplayer1.getBukkitEntity()), params.a(sender.dI().B_())) : disguised);
            } else {
                entityplayer1.sendChatMessage(outgoingchatmessage, flag2, params, unsignedFunction == null ? null : unsignedFunction.apply((Audience)entityplayer1.getBukkitEntity()));
            }
            flag1 |= flag2 && message.i();
        }
        if (flag1 && sender != null) {
            sender.a(f);
        }
    }

    public boolean a(PlayerChatMessage message) {
        return message.h() && !message.a(Instant.now());
    }

    public ServerStatisticManager getPlayerStats(EntityPlayer entityhuman) {
        ServerStatisticManager serverstatisticmanager = entityhuman.D();
        return serverstatisticmanager == null ? this.getPlayerStats(entityhuman.ct(), entityhuman.fM().getName()) : serverstatisticmanager;
    }

    public ServerStatisticManager getPlayerStats(UUID uuid, String displayName) {
        ServerStatisticManager serverstatisticmanager;
        EntityPlayer entityhuman = this.a(uuid);
        ServerStatisticManager serverStatisticManager = serverstatisticmanager = entityhuman == null ? null : entityhuman.D();
        if (serverstatisticmanager == null) {
            File file2;
            Path path;
            File file = this.j.a(SavedFile.b).toFile();
            File file1 = new File(file, uuid + ".json");
            if (!file1.exists() && FileUtils.a(path = (file2 = new File(file, displayName + ".json")).toPath()) && FileUtils.b(path) && path.startsWith(file.getPath()) && file2.isFile()) {
                file2.renameTo(file1);
            }
            serverstatisticmanager = new ServerStatisticManager(this.j, file1);
        }
        return serverstatisticmanager;
    }

    public AdvancementDataPlayer f(EntityPlayer player) {
        UUID uuid = player.ct();
        AdvancementDataPlayer advancementdataplayer = player.M();
        if (advancementdataplayer == null) {
            Path path = this.j.a(SavedFile.a).resolve(uuid + ".json");
            advancementdataplayer = new AdvancementDataPlayer(this.j.ay(), this, this.j.az(), path, player);
        }
        advancementdataplayer.a(player);
        return advancementdataplayer;
    }

    public void a(int viewDistance) {
        this.w = viewDistance;
        for (WorldServer worldserver : this.j.F()) {
            if (worldserver == null) continue;
            worldserver.k().a(viewDistance);
        }
    }

    public void b(int simulationDistance) {
        this.x = simulationDistance;
        for (WorldServer worldserver : this.j.F()) {
            if (worldserver == null) continue;
            worldserver.k().b(simulationDistance);
        }
    }

    public List<EntityPlayer> t() {
        return this.k;
    }

    @Nullable
    public EntityPlayer a(UUID uuid) {
        return this.l.get(uuid);
    }

    public boolean d(GameProfile profile) {
        return false;
    }

    public void u() {
        this.reloadAdvancementData();
        this.reloadTagData();
        this.reloadRecipeData();
    }

    public void reloadAdvancementData() {
        for (EntityPlayer player : this.k) {
            player.M().a(this.j.az());
            player.M().b(player);
        }
    }

    public void reloadTagData() {
        this.a(new PacketPlayOutTags(TagNetworkSerialization.a(this.u)));
    }

    public void reloadRecipeData() {
        PacketPlayOutRecipeUpdate packetplayoutrecipeupdate = new PacketPlayOutRecipeUpdate(this.j.aE().b());
        for (EntityPlayer entityplayer : this.k) {
            entityplayer.c.a(packetplayoutrecipeupdate);
            entityplayer.E().a(entityplayer);
        }
    }

    public boolean v() {
        return this.y;
    }
}

