/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EntitySlice<T>
extends AbstractCollection<T> {
    private final Map<Class<?>, List<T>> a = Maps.newHashMap();
    private final Class<T> b;
    private final List<T> c = Lists.newArrayList();

    public EntitySlice(Class<T> elementType) {
        this.b = elementType;
        this.a.put(elementType, this.c);
    }

    @Override
    @Override
    public boolean add(T object) {
        boolean bl = false;
        for (Map.Entry<Class<?>, List<T>> entry : this.a.entrySet()) {
            if (!entry.getKey().isInstance(object)) continue;
            bl |= entry.getValue().add(object);
        }
        return bl;
    }

    @Override
    @Override
    public boolean remove(Object object) {
        boolean bl = false;
        for (Map.Entry<Class<?>, List<T>> entry : this.a.entrySet()) {
            if (!entry.getKey().isInstance(object)) continue;
            List<T> list = entry.getValue();
            bl |= list.remove(object);
        }
        return bl;
    }

    @Override
    @Override
    public boolean contains(Object object) {
        return this.a(object.getClass()).contains(object);
    }

    public <S> Collection<S> a(Class<S> type) {
        if (!this.b.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Don't know how to search for " + type);
        }
        List list = this.a.computeIfAbsent(type, typeClass -> this.c.stream().filter(typeClass::isInstance).collect(Collectors.toList()));
        return Collections.unmodifiableCollection(list);
    }

    @Override
    @Override
    public Iterator<T> iterator() {
        if (this.c.isEmpty()) {
            return Collections.emptyIterator();
        }
        return Iterators.unmodifiableIterator(this.c.iterator());
    }

    public List<T> a() {
        return ImmutableList.copyOf(this.c);
    }

    @Override
    @Override
    public int size() {
        return this.c.size();
    }
}

