/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Tlhelp32;
import com.sun.jna.platform.win32.Version;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.minecraft.CrashReportSystemDetails;
import org.slf4j.Logger;

public class NativeModuleLister {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 65535;
    private static final int c = 1033;
    private static final int d = -65536;
    private static final int e = 0x4B00000;

    public static List<a> a() {
        if (!Platform.isWindows()) {
            return ImmutableList.of();
        }
        int i2 = Kernel32.INSTANCE.GetCurrentProcessId();
        ImmutableList.Builder builder = ImmutableList.builder();
        List list = Kernel32Util.getModules((int)i2);
        for (Tlhelp32.MODULEENTRY32W mODULEENTRY32W : list) {
            String string = mODULEENTRY32W.szModule();
            Optional<b> optional = NativeModuleLister.a(mODULEENTRY32W.szExePath());
            builder.add((Object)new a(string, optional));
        }
        return builder.build();
    }

    private static Optional<b> a(String path) {
        try {
            IntByReference intByReference = new IntByReference();
            int i2 = Version.INSTANCE.GetFileVersionInfoSize(path, intByReference);
            if (i2 == 0) {
                int j2 = Native.getLastError();
                if (j2 == 1813 || j2 == 1812) {
                    return Optional.empty();
                }
                throw new Win32Exception(j2);
            }
            Memory pointer = new Memory((long)i2);
            if (!Version.INSTANCE.GetFileVersionInfo(path, 0, i2, (Pointer)pointer)) {
                throw new Win32Exception(Native.getLastError());
            }
            IntByReference intByReference2 = new IntByReference();
            Pointer pointer2 = NativeModuleLister.a((Pointer)pointer, "\\VarFileInfo\\Translation", intByReference2);
            int[] is = pointer2.getIntArray(0L, intByReference2.getValue() / 4);
            OptionalInt optionalInt = NativeModuleLister.a(is);
            if (!optionalInt.isPresent()) {
                return Optional.empty();
            }
            int k2 = optionalInt.getAsInt();
            int l2 = k2 & 0xFFFF;
            int m2 = (k2 & 0xFFFF0000) >> 16;
            String string = NativeModuleLister.b((Pointer)pointer, NativeModuleLister.a("FileDescription", l2, m2), intByReference2);
            String string2 = NativeModuleLister.b((Pointer)pointer, NativeModuleLister.a("CompanyName", l2, m2), intByReference2);
            String string3 = NativeModuleLister.b((Pointer)pointer, NativeModuleLister.a("FileVersion", l2, m2), intByReference2);
            return Optional.of(new b(string, string3, string2));
        }
        catch (Exception exception) {
            a.info("Failed to find module info for {}", (Object)path, (Object)exception);
            return Optional.empty();
        }
    }

    private static String a(String key, int languageId, int codePage) {
        return String.format(Locale.ROOT, "\\StringFileInfo\\%04x%04x\\%s", languageId, codePage, key);
    }

    private static OptionalInt a(int[] indices) {
        OptionalInt optionalInt = OptionalInt.empty();
        for (int i2 : indices) {
            if ((i2 & 0xFFFF0000) == 0x4B00000 && (i2 & 0xFFFF) == 1033) {
                return OptionalInt.of(i2);
            }
            optionalInt = OptionalInt.of(i2);
        }
        return optionalInt;
    }

    private static Pointer a(Pointer pointer, String path, IntByReference lengthPointer) {
        PointerByReference pointerByReference = new PointerByReference();
        if (!Version.INSTANCE.VerQueryValue(pointer, path, pointerByReference, lengthPointer)) {
            throw new UnsupportedOperationException("Can't get version value " + path);
        }
        return pointerByReference.getValue();
    }

    private static String b(Pointer pointer, String path, IntByReference lengthPointer) {
        try {
            Pointer pointer2 = NativeModuleLister.a(pointer, path, lengthPointer);
            byte[] bs = pointer2.getByteArray(0L, (lengthPointer.getValue() - 1) * 2);
            return new String(bs, StandardCharsets.UTF_16LE);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void a(CrashReportSystemDetails section) {
        section.a("Modules", () -> NativeModuleLister.a().stream().sorted(Comparator.comparing(module -> module.a)).map(moduleName -> "\n\t\t" + moduleName).collect(Collectors.joining()));
    }

    public static class a {
        public final String a;
        public final Optional<b> b;

        public a(String path, Optional<b> info) {
            this.a = path;
            this.b = info;
        }

        @Override
        public String toString() {
            return this.b.map(info -> this.a + ":" + info).orElse(this.a);
        }
    }

    public static class b {
        public final String a;
        public final String b;
        public final String c;

        public b(String fileDescription, String fileVersion, String companyName) {
            this.a = fileDescription;
            this.b = fileVersion;
            this.c = companyName;
        }

        @Override
        public String toString() {
            return this.a + ":" + this.b + ":" + this.c;
        }
    }
}

