/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.metrics.profiling;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.stream.IntStream;
import net.minecraft.util.profiling.GameProfilerFillerActive;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.util.profiling.metrics.MetricSampler;
import net.minecraft.util.profiling.metrics.MetricsRegistry;
import net.minecraft.util.profiling.metrics.MetricsSamplerProvider;
import net.minecraft.util.profiling.metrics.profiling.ProfilerSamplerAdapter;
import org.slf4j.Logger;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;

public class ServerMetricsSamplersProvider
implements MetricsSamplerProvider {
    private static final Logger a = LogUtils.getLogger();
    private final Set<MetricSampler> b = new ObjectOpenHashSet();
    private final ProfilerSamplerAdapter c = new ProfilerSamplerAdapter();

    public ServerMetricsSamplersProvider(LongSupplier nanoTimeSupplier, boolean includeSystem) {
        this.b.add(ServerMetricsSamplersProvider.a(nanoTimeSupplier));
        if (includeSystem) {
            this.b.addAll(ServerMetricsSamplersProvider.a());
        }
    }

    public static Set<MetricSampler> a() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        try {
            a cpuStats = new a();
            IntStream.range(0, cpuStats.a).mapToObj(index -> MetricSampler.a("cpu#" + index, MetricCategory.h, () -> cpuStats.a(index))).forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        }
        catch (Throwable throwable) {
            a.warn("Failed to query cpu, no cpu stats will be recorded", throwable);
        }
        builder.add((Object)MetricSampler.a("heap MiB", MetricCategory.e, () -> (float)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1048576.0f));
        builder.addAll(MetricsRegistry.a.a());
        return builder.build();
    }

    @Override
    @Override
    public Set<MetricSampler> a(Supplier<GameProfilerFillerActive> profilerSupplier) {
        this.b.addAll(this.c.a(profilerSupplier));
        return this.b;
    }

    public static MetricSampler a(final LongSupplier nanoTimeSupplier) {
        Stopwatch stopwatch = Stopwatch.createUnstarted((Ticker)new Ticker(){

            @Override
            public long read() {
                return nanoTimeSupplier.getAsLong();
            }
        });
        ToDoubleFunction<Stopwatch> toDoubleFunction = watch -> {
            if (watch.isRunning()) {
                watch.stop();
            }
            long l2 = watch.elapsed(TimeUnit.NANOSECONDS);
            watch.reset();
            return l2;
        };
        MetricSampler.d valueIncreasedByPercentage = new MetricSampler.d(2.0f);
        return MetricSampler.a("ticktime", MetricCategory.d, toDoubleFunction, stopwatch).a(Stopwatch::start).a(valueIncreasedByPercentage).a();
    }

    static class a {
        private final SystemInfo b = new SystemInfo();
        private final CentralProcessor c = this.b.getHardware().getProcessor();
        public final int a = this.c.getLogicalProcessorCount();
        private long[][] d = this.c.getProcessorCpuLoadTicks();
        private double[] e = this.c.getProcessorCpuLoadBetweenTicks(this.d);
        private long f;

        a() {
        }

        public double a(int index) {
            long l2 = System.currentTimeMillis();
            if (this.f == 0L || this.f + 501L < l2) {
                this.e = this.c.getProcessorCpuLoadBetweenTicks(this.d);
                this.d = this.c.getProcessorCpuLoadTicks();
                this.f = l2;
            }
            return this.e[index] * 100.0;
        }
    }
}

