/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.FloatProviderType;

public class TrapezoidFloat
extends FloatProvider {
    public static final Codec<TrapezoidFloat> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("min").forGetter(provider -> Float.valueOf(provider.b)), (App)Codec.FLOAT.fieldOf("max").forGetter(provider -> Float.valueOf(provider.d)), (App)Codec.FLOAT.fieldOf("plateau").forGetter(provider -> Float.valueOf(provider.e))).apply((Applicative)instance, TrapezoidFloat::new)).comapFlatMap(provider -> {
        if (provider.d < provider.b) {
            return DataResult.error(() -> "Max must be larger than min: [" + trapezoidFloat.b + ", " + trapezoidFloat.d + "]");
        }
        if (provider.e > provider.d - provider.b) {
            return DataResult.error(() -> "Plateau can at most be the full span: [" + trapezoidFloat.b + ", " + trapezoidFloat.d + "]");
        }
        return DataResult.success((Object)provider);
    }, Function.identity());
    private final float b;
    private final float d;
    private final float e;

    public static TrapezoidFloat a(float min, float max, float plateau) {
        return new TrapezoidFloat(min, max, plateau);
    }

    private TrapezoidFloat(float min, float max, float plateau) {
        this.b = min;
        this.d = max;
        this.e = plateau;
    }

    @Override
    @Override
    public float a(RandomSource random) {
        float f2 = this.d - this.b;
        float g2 = (f2 - this.e) / 2.0f;
        float h2 = f2 - g2;
        return this.b + random.i() * h2 + random.i() * g2;
    }

    @Override
    @Override
    public float a() {
        return this.b;
    }

    @Override
    @Override
    public float b() {
        return this.d;
    }

    @Override
    @Override
    public FloatProviderType<?> c() {
        return FloatProviderType.d;
    }

    @Override
    public String toString() {
        return "trapezoid(" + this.e + ") in [" + this.b + "-" + this.d + "]";
    }
}

