/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.saveddata.PersistentBase;
import org.slf4j.Logger;

public class RandomSequences
extends PersistentBase {
    private static final Logger a = LogUtils.getLogger();
    private final long b;
    private final Map<MinecraftKey, RandomSequence> c = new Object2ObjectOpenHashMap();

    public RandomSequences(long seed) {
        this.b = seed;
    }

    public RandomSource a(MinecraftKey id2) {
        final RandomSource randomSource = this.c.computeIfAbsent(id2, id -> new RandomSequence(this.b, (MinecraftKey)id)).a();
        return new RandomSource(){

            @Override
            @Override
            public RandomSource d() {
                RandomSequences.this.b();
                return randomSource.d();
            }

            @Override
            @Override
            public PositionalRandomFactory e() {
                RandomSequences.this.b();
                return randomSource.e();
            }

            @Override
            @Override
            public void b(long seed) {
                RandomSequences.this.b();
                randomSource.b(seed);
            }

            @Override
            @Override
            public int f() {
                RandomSequences.this.b();
                return randomSource.f();
            }

            @Override
            @Override
            public int a(int bound) {
                RandomSequences.this.b();
                return randomSource.a(bound);
            }

            @Override
            @Override
            public long g() {
                RandomSequences.this.b();
                return randomSource.g();
            }

            @Override
            @Override
            public boolean h() {
                RandomSequences.this.b();
                return randomSource.h();
            }

            @Override
            @Override
            public float i() {
                RandomSequences.this.b();
                return randomSource.i();
            }

            @Override
            @Override
            public double j() {
                RandomSequences.this.b();
                return randomSource.j();
            }

            @Override
            @Override
            public double k() {
                RandomSequences.this.b();
                return randomSource.k();
            }
        };
    }

    @Override
    @Override
    public NBTTagCompound a(NBTTagCompound nbt) {
        this.c.forEach((id, sequence) -> nbt.a(id.toString(), (NBTBase)RandomSequence.a.encodeStart((DynamicOps)DynamicOpsNBT.a, sequence).result().orElseThrow()));
        return nbt;
    }

    public static RandomSequences a(long seed, NBTTagCompound nbt) {
        RandomSequences randomSequences = new RandomSequences(seed);
        Set<String> set = nbt.e();
        for (String string : set) {
            try {
                RandomSequence randomSequence = (RandomSequence)((Pair)RandomSequence.a.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(string)).result().get()).getFirst();
                randomSequences.c.put(new MinecraftKey(string), randomSequence);
            }
            catch (Exception exception) {
                a.error("Failed to load random sequence {}", (Object)string, (Object)exception);
            }
        }
        return randomSequences;
    }
}

