/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.EntitySenses;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemAxe;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBow;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.ItemTool;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathType;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftMob;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;

public abstract class EntityInsentient
extends EntityLiving
implements Targeting {
    private static final DataWatcherObject<Byte> b = DataWatcher.a(EntityInsentient.class, DataWatcherRegistry.a);
    private static final int c = 1;
    private static final int d = 2;
    private static final int e = 4;
    protected static final int f = 1;
    private static final BaseBlockPosition bS = new BaseBlockPosition(1, 0, 1);
    public static final float g = 0.15f;
    public static final float bB = 0.55f;
    public static final float bC = 0.5f;
    public static final float bD = 0.25f;
    public static final String bE = "Leash";
    public static final float bF = 0.085f;
    public static final int bG = 2;
    public static final int bH = 2;
    public int bI;
    protected int bJ;
    protected ControllerLook bK;
    protected ControllerMove bL;
    protected ControllerJump bM;
    private final EntityAIBodyControl bT;
    protected NavigationAbstract bN;
    public PathfinderGoalSelector bO;
    @Nullable
    public PathfinderGoalFloat goalFloat;
    public PathfinderGoalSelector bP;
    @Nullable
    private EntityLiving bU;
    private final EntitySenses bV;
    private final NonNullList<ItemStack> bW = NonNullList.a(2, ItemStack.b);
    public final float[] bQ = new float[2];
    private final NonNullList<ItemStack> bX = NonNullList.a(4, ItemStack.b);
    public final float[] bR = new float[4];
    private boolean bY;
    private boolean bZ;
    private final Map<PathType, Float> ca = Maps.newEnumMap(PathType.class);
    @Nullable
    public MinecraftKey cb;
    public long cc;
    @Nullable
    private Entity cd;
    private int ce;
    @Nullable
    public NBTTagCompound cf;
    private BlockPosition cg = BlockPosition.b;
    private float ch = -1.0f;
    public boolean aware = true;

    protected EntityInsentient(EntityTypes<? extends EntityInsentient> type, World world) {
        super((EntityTypes<? extends EntityLiving>)type, world);
        this.bO = new PathfinderGoalSelector(world.ae());
        this.bP = new PathfinderGoalSelector(world.ae());
        this.bK = new ControllerLook(this);
        this.bL = new ControllerMove(this);
        this.bM = new ControllerJump(this);
        this.bT = this.D();
        this.bN = this.b(world);
        this.bV = new EntitySenses(this);
        Arrays.fill(this.bR, 0.085f);
        Arrays.fill(this.bQ, 0.085f);
        if (world != null && !world.B) {
            this.x();
        }
    }

    public void setPersistenceRequired(boolean persistenceRequired) {
        this.bZ = persistenceRequired;
    }

    protected void x() {
    }

    public static AttributeProvider.Builder y() {
        return EntityLiving.dM().a(GenericAttributes.b, 16.0).a(GenericAttributes.g);
    }

    protected NavigationAbstract b(World world) {
        return new Navigation(this, world);
    }

    protected boolean z() {
        return false;
    }

    public float a(PathType nodeType) {
        EntityInsentient entityinsentient1;
        Entity entity = this.cX();
        EntityInsentient entityinsentient = entity instanceof EntityInsentient && (entityinsentient1 = (EntityInsentient)entity).z() ? entityinsentient1 : this;
        Float ofloat = entityinsentient.ca.get((Object)nodeType);
        return ofloat == null ? nodeType.a() : ofloat.floatValue();
    }

    public void a(PathType nodeType, float penalty) {
        this.ca.put(nodeType, Float.valueOf(penalty));
    }

    public void A() {
    }

    public void C() {
    }

    protected EntityAIBodyControl D() {
        return new EntityAIBodyControl(this);
    }

    public ControllerLook E() {
        return this.bK;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.bO.inactiveTick()) {
            this.bO.a();
        }
        if (this.bP.inactiveTick()) {
            this.bP.a();
        }
    }

    public ControllerMove G() {
        Entity entity = this.cX();
        if (entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient.G();
        }
        return this.bL;
    }

    public ControllerJump I() {
        return this.bM;
    }

    public NavigationAbstract J() {
        Entity entity = this.cX();
        if (entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient.J();
        }
        return this.bN;
    }

    @Override
    @Nullable
    public EntityLiving cL() {
        Entity entity;
        if (!this.fQ() && (entity = this.cO()) instanceof EntityInsentient) {
            EntityInsentient entityinsentient1;
            EntityInsentient entityinsentient = entityinsentient1 = (EntityInsentient)entity;
            return entityinsentient;
        }
        EntityLiving entityinsentient = null;
        return entityinsentient;
    }

    public EntitySenses K() {
        return this.bV;
    }

    @Override
    @Nullable
    public EntityLiving j() {
        return this.bU;
    }

    public CraftMob getBukkitMob() {
        return (CraftMob)super.getBukkitEntity();
    }

    public void h(@Nullable EntityLiving target) {
        this.setTarget(target, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (this.j() == entityliving) {
            return false;
        }
        if (fireEvent) {
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN && this.j() != null && entityliving == null) {
                EntityTargetEvent.TargetReason targetReason = reason = this.j().bs() ? EntityTargetEvent.TargetReason.FORGOT_TARGET : EntityTargetEvent.TargetReason.TARGET_DIED;
            }
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN) {
                this.dI().getCraftServer().getLogger().log(Level.WARNING, "Unknown target reason, please report on the issue tracker", new Exception());
            }
            CraftLivingEntity ctarget = null;
            if (entityliving != null) {
                ctarget = (CraftLivingEntity)entityliving.getBukkitEntity();
            }
            EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (LivingEntity)ctarget, reason);
            this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            entityliving = event.getTarget() != null ? ((CraftLivingEntity)event.getTarget()).getHandle() : null;
        }
        this.bU = entityliving;
        return true;
    }

    @Override
    public boolean a(EntityTypes<?> type) {
        return type != EntityTypes.Q;
    }

    public boolean a(ItemProjectileWeapon weapon) {
        return false;
    }

    public void L() {
        this.a(GameEvent.m);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(b, (byte)0);
    }

    public int M() {
        return 80;
    }

    public void N() {
        SoundEffect soundeffect = this.s();
        if (soundeffect != null) {
            this.a(soundeffect, this.eR(), this.eS());
        }
    }

    @Override
    public void ao() {
        super.ao();
        this.dI().ad().a("mobBaseTick");
        if (this.bs() && this.af.a(1000) < this.bI++) {
            this.q();
            this.N();
        }
        this.dI().ad().c();
    }

    @Override
    protected void e(DamageSource source) {
        this.q();
        super.e(source);
    }

    private void q() {
        this.bI = -this.M();
    }

    @Override
    public int ea() {
        if (this.bJ > 0) {
            int j2;
            int i2 = this.bJ;
            for (j2 = 0; j2 < this.bX.size(); ++j2) {
                if (this.bX.get(j2).b() || !(this.bR[j2] <= 1.0f)) continue;
                i2 += 1 + this.af.a(3);
            }
            for (j2 = 0; j2 < this.bW.size(); ++j2) {
                if (this.bW.get(j2).b() || !(this.bQ[j2] <= 1.0f)) continue;
                i2 += 1 + this.af.a(3);
            }
            return i2;
        }
        return this.bJ;
    }

    public void O() {
        if (this.dI().B) {
            for (int i2 = 0; i2 < 20; ++i2) {
                double d0 = this.af.k() * 0.02;
                double d1 = this.af.k() * 0.02;
                double d2 = this.af.k() * 0.02;
                double d3 = 10.0;
                this.dI().a(Particles.W, this.c(1.0) - d0 * 10.0, this.dq() - d1 * 10.0, this.g(1.0) - d2 * 10.0, d0, d1, d2);
            }
        } else {
            this.dI().a((Entity)this, (byte)20);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 20) {
            this.O();
        } else {
            super.b(status);
        }
    }

    @Override
    public void l() {
        super.l();
        if (!this.dI().B) {
            this.fN();
            if (this.ag % 5 == 0) {
                this.P();
            }
        }
    }

    protected void P() {
        boolean flag = !(this.cL() instanceof EntityInsentient);
        boolean flag1 = !(this.cW() instanceof EntityBoat);
        this.bO.a(PathfinderGoal.Type.a, flag);
        this.bO.a(PathfinderGoal.Type.c, flag && flag1);
        this.bO.a(PathfinderGoal.Type.b, flag);
    }

    @Override
    protected float e(float bodyRotation, float headRotation) {
        this.bT.a();
        return headRotation;
    }

    @Nullable
    protected SoundEffect s() {
        return null;
    }

    public SoundEffect getAmbientSound0() {
        return this.s();
    }

    @Override
    public void b(NBTTagCompound nbt) {
        NBTTagCompound nbttagcompound2;
        super.b(nbt);
        nbt.a("CanPickUpLoot", this.fG());
        nbt.a("PersistenceRequired", this.bZ);
        NBTTagList nbttaglist = new NBTTagList();
        for (ItemStack itemstack : this.bX) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            if (!itemstack.b()) {
                itemstack.b(nbttagcompound1);
            }
            nbttaglist.add(nbttagcompound1);
        }
        nbt.a("ArmorItems", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (ItemStack itemstack1 : this.bW) {
            nbttagcompound2 = new NBTTagCompound();
            if (!itemstack1.b()) {
                itemstack1.b(nbttagcompound2);
            }
            nbttaglist1.add(nbttagcompound2);
        }
        nbt.a("HandItems", nbttaglist1);
        NBTTagList nbttaglist2 = new NBTTagList();
        for (float f2 : this.bR) {
            nbttaglist2.add(NBTTagFloat.a(f2));
        }
        nbt.a("ArmorDropChances", nbttaglist2);
        NBTTagList nbttaglist3 = new NBTTagList();
        for (float f1 : this.bQ) {
            nbttaglist3.add(NBTTagFloat.a(f1));
        }
        nbt.a("HandDropChances", nbttaglist3);
        if (this.cd != null) {
            nbttagcompound2 = new NBTTagCompound();
            if (this.cd instanceof EntityLiving) {
                UUID uuid = this.cd.ct();
                nbttagcompound2.a("UUID", uuid);
            } else if (this.cd instanceof EntityHanging) {
                BlockPosition blockposition = ((EntityHanging)this.cd).y();
                nbttagcompound2.a("X", blockposition.u());
                nbttagcompound2.a("Y", blockposition.v());
                nbttagcompound2.a("Z", blockposition.w());
            }
            nbt.a(bE, nbttagcompound2);
        } else if (this.cf != null) {
            nbt.a(bE, this.cf.h());
        }
        nbt.a("LeftHanded", this.fR());
        if (this.cb != null) {
            nbt.a("DeathLootTable", this.cb.toString());
            if (this.cc != 0L) {
                nbt.a("DeathLootTableSeed", this.cc);
            }
        }
        if (this.fQ()) {
            nbt.a("NoAI", this.fQ());
        }
        nbt.a("Bukkit.Aware", this.aware);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        int i2;
        NBTTagList nbttaglist;
        boolean data;
        super.a(nbt);
        if (nbt.b("CanPickUpLoot", 1)) {
            data = nbt.q("CanPickUpLoot");
            if (EntityInsentient.isLevelAtLeast(nbt, 1) || data) {
                this.s(data);
            }
        }
        data = nbt.q("PersistenceRequired");
        if (EntityInsentient.isLevelAtLeast(nbt, 1) || data) {
            this.bZ = data;
        }
        if (nbt.b("ArmorItems", 9)) {
            nbttaglist = nbt.c("ArmorItems", 10);
            for (i2 = 0; i2 < this.bX.size(); ++i2) {
                this.bX.set(i2, ItemStack.a(nbttaglist.a(i2)));
            }
        }
        if (nbt.b("HandItems", 9)) {
            nbttaglist = nbt.c("HandItems", 10);
            for (i2 = 0; i2 < this.bW.size(); ++i2) {
                this.bW.set(i2, ItemStack.a(nbttaglist.a(i2)));
            }
        }
        if (nbt.b("ArmorDropChances", 9)) {
            nbttaglist = nbt.c("ArmorDropChances", 5);
            for (i2 = 0; i2 < nbttaglist.size(); ++i2) {
                this.bR[i2] = nbttaglist.i(i2);
            }
        }
        if (nbt.b("HandDropChances", 9)) {
            nbttaglist = nbt.c("HandDropChances", 5);
            for (i2 = 0; i2 < nbttaglist.size(); ++i2) {
                this.bQ[i2] = nbttaglist.i(i2);
            }
        }
        if (nbt.b(bE, 10)) {
            this.cf = nbt.p(bE);
        }
        this.u(nbt.q("LeftHanded"));
        if (nbt.b("DeathLootTable", 8)) {
            this.cb = new MinecraftKey(nbt.l("DeathLootTable"));
            this.cc = nbt.i("DeathLootTableSeed");
        }
        this.t(nbt.q("NoAI"));
        if (nbt.e("Bukkit.Aware")) {
            this.aware = nbt.q("Bukkit.Aware");
        }
    }

    @Override
    protected void a(DamageSource damageSource, boolean causedByPlayer) {
        super.a(damageSource, causedByPlayer);
        this.cb = null;
    }

    @Override
    public final MinecraftKey ew() {
        return this.cb == null ? this.Q() : this.cb;
    }

    public MinecraftKey Q() {
        return super.ew();
    }

    @Override
    public long ex() {
        return this.cc;
    }

    public void z(float forwardSpeed) {
        this.bn = forwardSpeed;
    }

    public void A(float upwardSpeed) {
        this.bm = upwardSpeed;
    }

    public void B(float sidewaysSpeed) {
        this.bl = sidewaysSpeed;
    }

    @Override
    public void w(float movementSpeed) {
        super.w(movementSpeed);
        this.z(movementSpeed);
    }

    @Override
    public void b_() {
        super.b_();
        this.dI().ad().a("looting");
        if (!this.dI().B && this.fG() && this.bs() && !this.bb && this.dI().X().b(GameRules.c)) {
            BaseBlockPosition baseblockposition = this.R();
            List<EntityItem> list = this.dI().a(EntityItem.class, this.cE().c(baseblockposition.u(), baseblockposition.v(), baseblockposition.w()));
            for (EntityItem entityitem : list) {
                if (entityitem.dD() || entityitem.j().b() || entityitem.r() || !this.k(entityitem.j()) || !entityitem.canMobPickup) continue;
                this.b(entityitem);
            }
        }
        this.dI().ad().c();
    }

    protected BaseBlockPosition R() {
        return bS;
    }

    protected void b(EntityItem item) {
        ItemStack itemstack = item.j();
        ItemStack itemstack1 = this.equipItemIfPossible(itemstack.p(), item);
        if (!itemstack1.b()) {
            this.a(item);
            this.a((Entity)item, itemstack1.L());
            itemstack.h(itemstack1.L());
            if (itemstack.b()) {
                item.ai();
            }
        }
    }

    public ItemStack i(ItemStack stack) {
        return this.equipItemIfPossible(stack, null);
    }

    public ItemStack equipItemIfPossible(ItemStack itemstack, EntityItem entityitem) {
        boolean canPickup;
        EnumItemSlot enumitemslot = EntityInsentient.h(itemstack);
        ItemStack itemstack1 = this.c(enumitemslot);
        boolean flag = this.b(itemstack, itemstack1);
        if (enumitemslot.e() && !flag) {
            enumitemslot = EnumItemSlot.a;
            itemstack1 = this.c(enumitemslot);
            flag = itemstack1.b();
        }
        boolean bl = canPickup = flag && this.j(itemstack);
        if (entityitem != null) {
            boolean bl2 = canPickup = !CraftEventFactory.callEntityPickupItemEvent(this, entityitem, 0, !canPickup).isCancelled();
        }
        if (canPickup) {
            double d0 = this.f(enumitemslot);
            if (!itemstack1.b() && (double)Math.max(this.af.i() - 0.1f, 0.0f) < d0) {
                this.forceDrops = true;
                this.b(itemstack1);
                this.forceDrops = false;
            }
            if (enumitemslot.e() && itemstack.L() > 1) {
                ItemStack itemstack2 = itemstack.c(1);
                this.b(enumitemslot, itemstack2);
                return itemstack2;
            }
            this.b(enumitemslot, itemstack);
            return itemstack;
        }
        return ItemStack.b;
    }

    protected void b(EnumItemSlot slot, ItemStack stack) {
        this.a(slot, stack);
        this.e(slot);
        this.bZ = true;
    }

    public void e(EnumItemSlot slot) {
        switch (slot.a()) {
            case a: {
                this.bQ[slot.b()] = 2.0f;
                break;
            }
            case b: {
                this.bR[slot.b()] = 2.0f;
            }
        }
    }

    protected boolean b(ItemStack newStack, ItemStack oldStack) {
        if (oldStack.b()) {
            return true;
        }
        if (newStack.d() instanceof ItemSword) {
            if (!(oldStack.d() instanceof ItemSword)) {
                return true;
            }
            ItemSword itemsword = (ItemSword)newStack.d();
            ItemSword itemsword1 = (ItemSword)oldStack.d();
            return itemsword.h() != itemsword1.h() ? itemsword.h() > itemsword1.h() : this.c(newStack, oldStack);
        }
        if (newStack.d() instanceof ItemBow && oldStack.d() instanceof ItemBow) {
            return this.c(newStack, oldStack);
        }
        if (newStack.d() instanceof ItemCrossbow && oldStack.d() instanceof ItemCrossbow) {
            return this.c(newStack, oldStack);
        }
        if (newStack.d() instanceof ItemArmor) {
            if (EnchantmentManager.d(oldStack)) {
                return false;
            }
            if (!(oldStack.d() instanceof ItemArmor)) {
                return true;
            }
            ItemArmor itemarmor = (ItemArmor)newStack.d();
            ItemArmor itemarmor1 = (ItemArmor)oldStack.d();
            return itemarmor.e() != itemarmor1.e() ? itemarmor.e() > itemarmor1.e() : (itemarmor.f() != itemarmor1.f() ? itemarmor.f() > itemarmor1.f() : this.c(newStack, oldStack));
        }
        if (newStack.d() instanceof ItemTool) {
            if (oldStack.d() instanceof ItemBlock) {
                return true;
            }
            if (oldStack.d() instanceof ItemTool) {
                ItemTool itemtool = (ItemTool)newStack.d();
                ItemTool itemtool1 = (ItemTool)oldStack.d();
                if (itemtool.d() != itemtool1.d()) {
                    return itemtool.d() > itemtool1.d();
                }
                return this.c(newStack, oldStack);
            }
        }
        return false;
    }

    public boolean c(ItemStack newStack, ItemStack oldStack) {
        return newStack.k() >= oldStack.k() && (!newStack.u() || oldStack.u()) ? (newStack.u() && oldStack.u() ? newStack.v().e().stream().anyMatch(s2 -> !s2.equals("Damage")) && !oldStack.v().e().stream().anyMatch(s2 -> !s2.equals("Damage")) : false) : true;
    }

    public boolean j(ItemStack stack) {
        return true;
    }

    public boolean k(ItemStack stack) {
        return this.j(stack);
    }

    public boolean h(double distanceSquared) {
        return true;
    }

    public boolean T() {
        return this.bM();
    }

    protected boolean U() {
        return false;
    }

    @Override
    public void du() {
        if (this.dI().ai() == EnumDifficulty.a && this.U()) {
            this.ai();
        } else if (!this.fH() && !this.T()) {
            EntityHuman entityhuman = this.dI().findNearbyPlayer(this, this.dI().paperConfig().entities.spawning.despawnRanges.get(this.ae().f()).hard() + 1, IEntitySelector.PLAYER_AFFECTS_SPAWNING);
            if (entityhuman == null) {
                EntityHuman entityHuman = entityhuman = ((WorldServer)this.dI()).playersAffectingSpawning.isEmpty() ? null : (EntityHuman)((WorldServer)this.dI()).playersAffectingSpawning.get(0);
            }
            if (entityhuman != null) {
                int i2;
                int j2;
                double d0 = entityhuman.f((Entity)this);
                if (d0 > (double)(j2 = (i2 = this.dI().paperConfig().entities.spawning.despawnRanges.get(this.ae().f()).hard()) * i2) && this.h(d0)) {
                    this.ai();
                }
                int k2 = this.dI().paperConfig().entities.spawning.despawnRanges.get(this.ae().f()).soft();
                int l2 = k2 * k2;
                if (this.bc > 600 && this.af.a(800) == 0 && d0 > (double)l2 && this.h(d0)) {
                    this.ai();
                } else if (d0 < (double)l2) {
                    this.bc = 0;
                }
            }
        } else {
            this.bc = 0;
        }
    }

    @Override
    protected final void fc() {
        ++this.bc;
        if (!this.aware) {
            if (this.goalFloat != null) {
                if (this.goalFloat.a()) {
                    this.goalFloat.e();
                }
                this.I().b();
            }
            if (this.fb() && this.aX()) {
                this.a(this.dJ().h(), 1.0f);
            }
            return;
        }
        this.dI().ad().a("sensing");
        this.bV.a();
        this.dI().ad().c();
        int i2 = this.dI().n().ag() + this.af();
        if (i2 % 2 != 0 && this.ag > 1) {
            this.dI().ad().a("targetSelector");
            this.bP.a(false);
            this.dI().ad().c();
            this.dI().ad().a("goalSelector");
            this.bO.a(false);
            this.dI().ad().c();
        } else {
            this.dI().ad().a("targetSelector");
            this.bP.a();
            this.dI().ad().c();
            this.dI().ad().a("goalSelector");
            this.bO.a();
            this.dI().ad().c();
        }
        this.dI().ad().a("navigation");
        this.bN.c();
        this.dI().ad().c();
        this.dI().ad().a("mob tick");
        this.W();
        this.dI().ad().c();
        this.dI().ad().a("controls");
        this.dI().ad().a("move");
        this.bL.a();
        this.dI().ad().b("look");
        this.bK.a();
        this.dI().ad().b("jump");
        this.bM.b();
        this.dI().ad().c();
        this.dI().ad().c();
        this.V();
    }

    protected void V() {
        PacketDebug.a(this.dI(), this, this.bO);
    }

    protected void W() {
    }

    public int X() {
        return 40;
    }

    public int fC() {
        return 75;
    }

    public int fD() {
        return 10;
    }

    public void a(Entity targetEntity, float maxYawChange, float maxPitchChange) {
        double d2;
        double d0 = targetEntity.dn() - this.dn();
        double d1 = targetEntity.dt() - this.dt();
        if (targetEntity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)targetEntity;
            d2 = entityliving.dr() - this.dr();
        } else {
            d2 = (targetEntity.cE().b + targetEntity.cE().e) / 2.0 - this.dr();
        }
        double d3 = Math.sqrt(d0 * d0 + d1 * d1);
        float f2 = (float)(MathHelper.d(d1, d0) * 57.2957763671875) - 90.0f;
        float f3 = (float)(-(MathHelper.d(d2, d3) * 57.2957763671875));
        this.b_(this.a(this.dA(), f3, maxPitchChange));
        this.a_(this.a(this.dy(), f2, maxYawChange));
    }

    private float a(float from, float to, float max) {
        float f3 = MathHelper.g(to - from);
        if (f3 > max) {
            f3 = max;
        }
        if (f3 < -max) {
            f3 = -max;
        }
        return from + f3;
    }

    public static boolean a(EntityTypes<? extends EntityInsentient> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        BlockPosition blockposition1 = pos.d();
        return spawnReason == EnumMobSpawn.c || world.a_(blockposition1).a((IBlockAccess)world, blockposition1, type);
    }

    public boolean a(GeneratorAccess world, EnumMobSpawn spawnReason) {
        return true;
    }

    public boolean a(IWorldReader world) {
        return !world.d(this.cE()) && world.f(this);
    }

    public int fE() {
        return 4;
    }

    public boolean d(int count) {
        return false;
    }

    @Override
    public int cr() {
        if (this.j() == null) {
            return 3;
        }
        int i2 = (int)(this.er() - this.eI() * 0.33f);
        if ((i2 -= (3 - this.dI().ai().a()) * 4) < 0) {
            i2 = 0;
        }
        return i2 + 3;
    }

    @Override
    public Iterable<ItemStack> bI() {
        return this.bW;
    }

    @Override
    public Iterable<ItemStack> bJ() {
        return this.bX;
    }

    @Override
    public ItemStack c(EnumItemSlot slot) {
        switch (slot.a()) {
            case a: {
                return this.bW.get(slot.b());
            }
            case b: {
                return this.bX.get(slot.b());
            }
        }
        return ItemStack.b;
    }

    @Override
    public void a(EnumItemSlot slot, ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot slot, ItemStack stack, boolean silent) {
        this.e(stack);
        switch (slot.a()) {
            case a: {
                this.onEquipItem(slot, this.bW.set(slot.b(), stack), stack, silent);
                break;
            }
            case b: {
                this.onEquipItem(slot, this.bX.set(slot.b(), stack), stack, silent);
            }
        }
    }

    @Override
    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        super.a(source, lootingMultiplier, allowDrops);
        for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
            boolean flag1;
            ItemStack itemstack = this.c(enumitemslot);
            float f2 = this.f(enumitemslot);
            boolean bl = flag1 = f2 > 1.0f;
            if (itemstack.b() || EnchantmentManager.e(itemstack) || !allowDrops && !flag1 || !(Math.max(this.af.i() - (float)lootingMultiplier * 0.01f, 0.0f) < f2)) continue;
            if (!flag1 && itemstack.i()) {
                itemstack.b(itemstack.l() - this.af.a(1 + this.af.a(Math.max(itemstack.l() - 3, 1))));
            }
            this.b(itemstack);
            if (this.clearEquipmentSlots) {
                this.a(enumitemslot, ItemStack.b);
                continue;
            }
            this.clearedEquipmentSlots.add(enumitemslot);
        }
    }

    protected float f(EnumItemSlot slot) {
        return switch (slot.a()) {
            case EnumItemSlot.Function.a -> this.bQ[slot.b()];
            case EnumItemSlot.Function.b -> this.bR[slot.b()];
            default -> 0.0f;
        };
    }

    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        if (random.i() < 0.15f * localDifficulty.d()) {
            float f2;
            int i2 = random.a(2);
            float f3 = f2 = this.dI().ai() == EnumDifficulty.d ? 0.1f : 0.25f;
            if (random.i() < 0.095f) {
                ++i2;
            }
            if (random.i() < 0.095f) {
                ++i2;
            }
            if (random.i() < 0.095f) {
                ++i2;
            }
            boolean flag = true;
            for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
                Item item;
                if (enumitemslot.a() != EnumItemSlot.Function.b) continue;
                ItemStack itemstack = this.c(enumitemslot);
                if (!flag && random.i() < f2) break;
                flag = false;
                if (!itemstack.b() || (item = EntityInsentient.a(enumitemslot, i2)) == null) continue;
                this.a(enumitemslot, new ItemStack(item));
            }
        }
    }

    @Nullable
    public static Item a(EnumItemSlot equipmentSlot, int equipmentLevel) {
        switch (equipmentSlot) {
            case f: {
                if (equipmentLevel == 0) {
                    return Items.oK;
                }
                if (equipmentLevel == 1) {
                    return Items.pa;
                }
                if (equipmentLevel == 2) {
                    return Items.oO;
                }
                if (equipmentLevel == 3) {
                    return Items.oS;
                }
                if (equipmentLevel == 4) {
                    return Items.oW;
                }
            }
            case e: {
                if (equipmentLevel == 0) {
                    return Items.oL;
                }
                if (equipmentLevel == 1) {
                    return Items.pb;
                }
                if (equipmentLevel == 2) {
                    return Items.oP;
                }
                if (equipmentLevel == 3) {
                    return Items.oT;
                }
                if (equipmentLevel == 4) {
                    return Items.oX;
                }
            }
            case d: {
                if (equipmentLevel == 0) {
                    return Items.oM;
                }
                if (equipmentLevel == 1) {
                    return Items.pc;
                }
                if (equipmentLevel == 2) {
                    return Items.oQ;
                }
                if (equipmentLevel == 3) {
                    return Items.oU;
                }
                if (equipmentLevel == 4) {
                    return Items.oY;
                }
            }
            case c: {
                if (equipmentLevel == 0) {
                    return Items.oN;
                }
                if (equipmentLevel == 1) {
                    return Items.pd;
                }
                if (equipmentLevel == 2) {
                    return Items.oR;
                }
                if (equipmentLevel == 3) {
                    return Items.oV;
                }
                if (equipmentLevel != 4) break;
                return Items.oZ;
            }
        }
        return null;
    }

    protected void b(RandomSource random, DifficultyDamageScaler localDifficulty) {
        float f2 = localDifficulty.d();
        this.a(random, f2);
        for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
            if (enumitemslot.a() != EnumItemSlot.Function.b) continue;
            this.a(random, f2, enumitemslot);
        }
    }

    protected void a(RandomSource random, float power) {
        if (!this.eO().b() && random.i() < 0.25f * power) {
            this.a(EnumItemSlot.a, EnchantmentManager.a(random, this.eO(), (int)(5.0f + power * (float)random.a(18)), false));
        }
    }

    protected void a(RandomSource random, float power, EnumItemSlot slot) {
        ItemStack itemstack = this.c(slot);
        if (!itemstack.b() && random.i() < 0.5f * power) {
            this.a(slot, EnchantmentManager.a(random, itemstack, (int)(5.0f + power * (float)random.a(18)), false));
        }
    }

    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        RandomSource randomsource = world.y_();
        this.a(GenericAttributes.b).c(new AttributeModifier("Random spawn bonus", randomsource.a(0.0, 0.11485000000000001), AttributeModifier.Operation.b));
        if (randomsource.i() < 0.05f) {
            this.u(true);
        } else {
            this.u(false);
        }
        return entityData;
    }

    public void fF() {
        this.bZ = true;
    }

    public void a(EnumItemSlot slot, float chance) {
        switch (slot.a()) {
            case a: {
                this.bQ[slot.b()] = chance;
                break;
            }
            case b: {
                this.bR[slot.b()] = chance;
            }
        }
    }

    public boolean fG() {
        return this.bY;
    }

    public void s(boolean canPickUpLoot) {
        this.bY = canPickUpLoot;
    }

    @Override
    public boolean f(ItemStack stack) {
        EnumItemSlot enumitemslot = EntityInsentient.h(stack);
        return this.c(enumitemslot).b() && this.fG();
    }

    public boolean fH() {
        return this.bZ;
    }

    @Override
    public final EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        if (!this.bs()) {
            return EnumInteractionResult.d;
        }
        if (this.fP() == player) {
            PlayerUnleashEntityEvent event = CraftEventFactory.callPlayerUnleashEntityEvent(this, player, hand, !player.fO().d);
            if (event.isCancelled()) {
                ((EntityPlayer)player).c.a(new PacketPlayOutAttachEntity(this, this.fP()));
                return EnumInteractionResult.d;
            }
            this.a(true, event.isDropLeash());
            this.a(GameEvent.r, (Entity)player);
            return EnumInteractionResult.a(this.dI().B);
        }
        EnumInteractionResult enuminteractionresult = this.c(player, hand);
        if (enuminteractionresult.a()) {
            this.a(GameEvent.r, (Entity)player);
            return enuminteractionresult;
        }
        enuminteractionresult = this.b(player, hand);
        if (enuminteractionresult.a()) {
            this.a(GameEvent.r, (Entity)player);
            return enuminteractionresult;
        }
        return super.a(player, hand);
    }

    private EnumInteractionResult c(EntityHuman player, EnumHand hand) {
        EnumInteractionResult enuminteractionresult;
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.tQ) && this.a(player)) {
            if (CraftEventFactory.callPlayerLeashEntityEvent(this, player, player, hand).isCancelled()) {
                ((EntityPlayer)player).c.a(new PacketPlayOutAttachEntity(this, this.fP()));
                return EnumInteractionResult.d;
            }
            this.b((Entity)player, true);
            itemstack.h(1);
            return EnumInteractionResult.a(this.dI().B);
        }
        if (itemstack.a(Items.tR) && (enuminteractionresult = itemstack.a(player, (EntityLiving)this, hand)).a()) {
            return enuminteractionresult;
        }
        if (itemstack.d() instanceof ItemMonsterEgg) {
            if (this.dI() instanceof WorldServer) {
                ItemMonsterEgg itemmonsteregg = (ItemMonsterEgg)itemstack.d();
                Optional<EntityInsentient> optional = itemmonsteregg.a(player, this, this.ae(), (WorldServer)this.dI(), this.dg(), itemstack);
                optional.ifPresent(entityinsentient -> this.a(player, (EntityInsentient)entityinsentient));
                return optional.isPresent() ? EnumInteractionResult.a : EnumInteractionResult.d;
            }
            return EnumInteractionResult.b;
        }
        return EnumInteractionResult.d;
    }

    protected void a(EntityHuman player, EntityInsentient child) {
    }

    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return EnumInteractionResult.d;
    }

    public boolean fI() {
        return this.a(this.di());
    }

    public boolean a(BlockPosition pos) {
        return this.ch == -1.0f ? true : this.cg.j(pos) < (double)(this.ch * this.ch);
    }

    public void a(BlockPosition target, int range) {
        this.cg = target;
        this.ch = range;
    }

    public BlockPosition fJ() {
        return this.cg;
    }

    public float fK() {
        return this.ch;
    }

    public void fL() {
        this.ch = -1.0f;
    }

    public boolean fM() {
        return this.ch != -1.0f;
    }

    @Nullable
    public <T extends EntityInsentient> T a(EntityTypes<T> entityType, boolean keepEquipment) {
        return this.convertTo(entityType, keepEquipment, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entitytypes, boolean flag, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (this.dD()) {
            return null;
        }
        EntityInsentient t0 = (EntityInsentient)entitytypes.a(this.dI());
        if (t0 == null) {
            return null;
        }
        t0.s(this);
        t0.a(this.h_());
        t0.t(this.fQ());
        if (this.aa()) {
            t0.b(this.ab());
            t0.n(this.cy());
        }
        if (this.fH()) {
            t0.fF();
        }
        t0.m(this.co());
        if (flag) {
            t0.s(this.fG());
            for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
                ItemStack itemstack = this.c(enumitemslot);
                if (itemstack.b()) continue;
                t0.a(enumitemslot, itemstack.c());
                t0.a(enumitemslot, this.f(enumitemslot));
            }
        }
        if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, t0, transformReason).isCancelled()) {
            return null;
        }
        this.dI().addFreshEntity(t0, spawnReason);
        if (this.bM()) {
            Entity entity = this.cW();
            this.Y();
            t0.a(entity, true);
        }
        this.ai();
        return (T)t0;
    }

    protected void fN() {
        if (this.cf != null) {
            this.fV();
        }
        if (!(this.cd == null || this.bs() && this.cd.bs())) {
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), !this.bs() ? EntityUnleashEvent.UnleashReason.PLAYER_UNLEASH : EntityUnleashEvent.UnleashReason.HOLDER_GONE, true);
            this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
            this.a(true, event.isDropLeash());
        }
    }

    public void a(boolean sendPacket, boolean dropItem) {
        if (this.cd != null) {
            this.cd = null;
            this.cf = null;
            if (!this.dI().B && dropItem) {
                this.forceDrops = true;
                this.a((IMaterial)Items.tQ);
                this.forceDrops = false;
            }
            if (!this.dI().B && sendPacket && this.dI() instanceof WorldServer) {
                ((WorldServer)this.dI()).k().b(this, new PacketPlayOutAttachEntity(this, null));
            }
        }
    }

    public boolean a(EntityHuman player) {
        return !this.fO() && !(this instanceof IMonster);
    }

    public boolean fO() {
        return this.cd != null;
    }

    @Nullable
    public Entity fP() {
        if (this.cd == null && this.ce != 0 && this.dI().B) {
            this.cd = this.dI().a(this.ce);
        }
        return this.cd;
    }

    public void b(Entity entity, boolean sendPacket) {
        this.cd = entity;
        this.cf = null;
        if (!this.dI().B && sendPacket && this.dI() instanceof WorldServer) {
            ((WorldServer)this.dI()).k().b(this, new PacketPlayOutAttachEntity(this, this.cd));
        }
        if (this.bM()) {
            this.Y();
        }
    }

    public void r(int id) {
        this.ce = id;
        this.a(false, false);
    }

    @Override
    public boolean a(Entity entity, boolean force) {
        boolean flag1 = super.a(entity, force);
        if (flag1 && this.fO()) {
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN, true);
            if (!event.callEvent()) {
                return flag1;
            }
            this.a(true, event.isDropLeash());
        }
        return flag1;
    }

    private void fV() {
        if (this.cf != null && this.dI() instanceof WorldServer) {
            if (this.cf.b("UUID")) {
                UUID uuid = this.cf.a("UUID");
                Entity entity = ((WorldServer)this.dI()).a(uuid);
                if (entity != null) {
                    this.b(entity, true);
                    return;
                }
            } else if (this.cf.b("X", 99) && this.cf.b("Y", 99) && this.cf.b("Z", 99)) {
                BlockPosition blockposition = GameProfileSerializer.b(this.cf);
                this.b(EntityLeash.b(this.dI(), blockposition), true);
                return;
            }
            if (this.ag > 100) {
                this.forceDrops = true;
                this.a((IMaterial)Items.tQ);
                this.forceDrops = false;
                this.cf = null;
            }
        }
    }

    @Override
    public boolean cV() {
        return super.cV() && !this.fQ();
    }

    public void t(boolean aiDisabled) {
        byte b0 = this.am.b(b);
        this.am.b(b, aiDisabled ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE));
    }

    public void u(boolean leftHanded) {
        byte b0 = this.am.b(b);
        this.am.b(b, leftHanded ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD));
    }

    public void v(boolean attacking) {
        byte b0 = this.am.b(b);
        this.am.b(b, attacking ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB));
    }

    public boolean fQ() {
        return (this.am.b(b) & 1) != 0;
    }

    public boolean fR() {
        return (this.am.b(b) & 2) != 0;
    }

    public boolean fS() {
        return (this.am.b(b) & 4) != 0;
    }

    public void a(boolean baby) {
    }

    @Override
    public EnumMainHand fh() {
        return this.fR() ? EnumMainHand.a : EnumMainHand.b;
    }

    public double i(EntityLiving target) {
        return this.dd() * 2.0f * this.dd() * 2.0f + target.dd();
    }

    public double j(EntityLiving target) {
        return Math.max(this.e(target.eA()), this.e(target.dg()));
    }

    public boolean k(EntityLiving entity) {
        double d0 = this.j(entity);
        return d0 <= this.i(entity);
    }

    @Override
    public boolean z(Entity target) {
        boolean flag;
        int i2;
        float f2 = (float)this.b(GenericAttributes.f);
        float f1 = (float)this.b(GenericAttributes.g);
        if (target instanceof EntityLiving) {
            f2 += EnchantmentManager.a(this.eO(), ((EntityLiving)target).eN());
            f1 += (float)EnchantmentManager.c(this);
        }
        if ((i2 = EnchantmentManager.d(this)) > 0) {
            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), i2 * 4);
            Bukkit.getPluginManager().callEvent((Event)combustEvent);
            if (!combustEvent.isCancelled()) {
                target.setSecondsOnFire(combustEvent.getDuration(), false);
            }
        }
        if (flag = target.a(this.dJ().b(this), f2)) {
            if (f1 > 0.0f && target instanceof EntityLiving) {
                ((EntityLiving)target).knockback(f1 * 0.5f, MathHelper.a(this.dy() * ((float)Math.PI / 180)), -MathHelper.b(this.dy() * ((float)Math.PI / 180)), this);
                this.f(this.dl().d(0.6, 1.0, 0.6));
            }
            if (target instanceof EntityHuman) {
                EntityHuman entityhuman = (EntityHuman)target;
                this.a(entityhuman, this.eO(), entityhuman.fi() ? entityhuman.fk() : ItemStack.b);
            }
            this.a((EntityLiving)this, target);
            this.x(target);
        }
        return flag;
    }

    private void a(EntityHuman player, ItemStack mobStack, ItemStack playerStack) {
        if (!mobStack.b() && !playerStack.b() && mobStack.d() instanceof ItemAxe && playerStack.a(Items.uy)) {
            float f2 = 0.25f + (float)EnchantmentManager.g(this) * 0.05f;
            if (this.af.i() < f2) {
                player.gi().a(Items.uy, 100);
                this.dI().a((Entity)player, (byte)30);
            }
        }
    }

    public boolean fT() {
        if (this.dI().N() && !this.dI().B) {
            boolean flag;
            float f2 = this.bj();
            BlockPosition blockposition = BlockPosition.a(this.dn(), this.dr(), this.dt());
            boolean bl = flag = this.aX() || this.az || this.aA;
            if (f2 > 0.5f && this.af.i() * 30.0f < (f2 - 0.4f) * 2.0f && !flag && this.dI().g(blockposition)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void c(TagKey<FluidType> fluid) {
        if (this.J().q()) {
            super.c(fluid);
        } else {
            this.f(this.dl().b(0.0, 0.3, 0.0));
        }
    }

    public void fU() {
        this.c((PathfinderGoal pathfindergoal) -> true);
        this.dK().h();
    }

    public void c(Predicate<PathfinderGoal> predicate) {
        this.bO.a(predicate);
    }

    @Override
    protected void cp() {
        super.cp();
        EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN, false);
        this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
        this.a(true, event.isDropLeash());
        this.bK().forEach(itemstack -> {
            if (!itemstack.b()) {
                itemstack.f(0);
            }
        });
    }

    @Override
    @Nullable
    public ItemStack dv() {
        ItemMonsterEgg itemmonsteregg = ItemMonsterEgg.a(this.ae());
        return itemmonsteregg == null ? null : new ItemStack(itemmonsteregg);
    }
}

