/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import com.destroystokyo.paper.event.entity.EntityKnockbackByEntityEvent;
import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import com.destroystokyo.paper.event.player.PlayerAttackEntityCooldownResetEvent;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.player.PlayerStopUsingItemEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.BlockUtil;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.CombatMath;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.RiderShieldingMount;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemAxe;
import net.minecraft.world.item.ItemElytra;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.enchantment.EnchantmentFrostWalker;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_20_R1.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.util.Vector;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public abstract class EntityLiving
extends Entity
implements Attackable {
    private static final Logger b = LogUtils.getLogger();
    private static final UUID c = UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D");
    private static final UUID d = UUID.fromString("87f46a96-686f-4796-b035-22e16ee9e038");
    private static final UUID e = UUID.fromString("1eaf83ff-7207-4596-b37a-d7a07b3ec4ce");
    private static final AttributeModifier bB = new AttributeModifier(c, "Sprinting speed boost", (double)0.3f, AttributeModifier.Operation.c);
    public static final int h = 2;
    public static final int i = 4;
    public static final int j = 98;
    public static final int k = 100;
    public static final int l = 6;
    public static final int m = 100;
    private static final int bC = 40;
    public static final double n = 0.003;
    public static final double o = 0.08;
    public static final int p = 20;
    private static final int bD = 7;
    private static final int bE = 10;
    private static final int bF = 2;
    public static final int q = 4;
    private static final float bG = 0.42f;
    private static final double bH = 128.0;
    protected static final int r = 1;
    protected static final int s = 2;
    protected static final int t = 4;
    protected static final DataWatcherObject<Byte> u = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Float> bI = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> bJ = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> bK = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Integer> bL = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bM = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<BlockPosition>> bN = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.o);
    protected static final float aD = 1.74f;
    protected static final EntitySize aE = EntitySize.c(0.2f, 0.2f);
    public static final float aF = 0.5f;
    private static final int bO = 50;
    private final AttributeMapBase bP;
    public CombatTracker bQ = new CombatTracker(this);
    public final Map<MobEffectList, MobEffect> bR = Maps.newHashMap();
    private final NonNullList<ItemStack> bS;
    private final NonNullList<ItemStack> bT;
    public boolean aG;
    private boolean bU;
    public EnumHand aH;
    public int aI;
    public int aJ;
    public int aK;
    public int aL;
    public int aM;
    public int aN;
    public float aO;
    public float aP;
    protected int aQ;
    public final WalkAnimationState aR;
    public int aS;
    public final float aT;
    public final float aU;
    public float aV;
    public float aW;
    public float aX;
    public float aY;
    @Nullable
    public EntityHuman aZ;
    public int ba;
    protected boolean bb;
    protected int bc;
    protected float bd;
    protected float be;
    protected float bf;
    protected float bg;
    protected float bh;
    protected int bi;
    public float bj;
    public boolean bk;
    public float bl;
    public float bm;
    public float bn;
    protected int bo;
    protected double bp;
    protected double bq;
    protected double br;
    protected double bs;
    protected double bt;
    protected double bu;
    protected int bv;
    public boolean bV;
    @Nullable
    public EntityLiving bW;
    public int bX;
    private EntityLiving bY;
    private int bZ;
    private float ca;
    private int cb;
    private float cc;
    protected ItemStack bw;
    protected int bx;
    protected int by;
    private BlockPosition cd;
    private Optional<BlockPosition> ce;
    @Nullable
    private DamageSource cf;
    private long cg;
    protected int bz;
    private float ch;
    private float ci;
    protected BehaviorController<?> bA;
    private boolean cj;
    public int expToDrop;
    public boolean forceDrops;
    public ArrayList<org.bukkit.inventory.ItemStack> drops = new ArrayList();
    public final CraftAttributeMap craftAttributes;
    public boolean collides = true;
    public Set<UUID> collidableExemptions = new HashSet<UUID>();
    public boolean bukkitPickUpLoot;
    public boolean silentDeath = false;
    public TriState frictionState = TriState.NOT_SET;
    private boolean isTickingEffects = false;
    private List<ProcessableEffect> effectsToProcess = Lists.newArrayList();
    protected boolean clearEquipmentSlots = true;
    protected Set<EnumItemSlot> clearedEquipmentSlots = new HashSet<EnumItemSlot>();
    protected long lastJumpTime = 0L;
    protected long eatStartTime;
    protected int totalEatTimeTicks;
    public int shieldBlockingDelay;

    public CraftLivingEntity getBukkitLivingEntity() {
        return (CraftLivingEntity)super.getBukkitEntity();
    }

    @Override
    public float getBukkitYaw() {
        return this.cm();
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        ++this.bc;
    }

    protected EntityLiving(EntityTypes<? extends EntityLiving> type, net.minecraft.world.level.World world) {
        super(type, world);
        this.shieldBlockingDelay = this.dI().paperConfig().misc.shieldBlockingDelay;
        this.bS = NonNullList.a(2, ItemStack.b);
        this.bT = NonNullList.a(4, ItemStack.b);
        this.bU = false;
        this.aR = new WalkAnimationState();
        this.aS = 20;
        this.bV = true;
        this.bw = ItemStack.b;
        this.ce = Optional.empty();
        this.bP = new AttributeMapBase(AttributeDefaults.a(type));
        this.craftAttributes = new CraftAttributeMap(this.bP);
        this.am.b(bI, Float.valueOf((float)this.a(GenericAttributes.a).f()));
        this.H = true;
        this.aU = (float)((Math.random() + 1.0) * (double)0.01f);
        this.an();
        this.aT = (float)Math.random() * 12398.0f;
        this.a_((float)(Math.random() * 6.2831854820251465));
        this.aX = this.dy();
        this.r(0.6f);
        DynamicOpsNBT dynamicopsnbt = DynamicOpsNBT.a;
        this.bA = this.a(new Dynamic<NBTBase>(dynamicopsnbt, (NBTBase)dynamicopsnbt.createMap((Map)ImmutableMap.of((Object)dynamicopsnbt.a("memories"), (Object)((NBTBase)dynamicopsnbt.emptyMap())))));
    }

    public BehaviorController<?> dK() {
        return this.bA;
    }

    protected BehaviorController.b<?> dL() {
        return BehaviorController.a(ImmutableList.of(), ImmutableList.of());
    }

    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return this.dL().a(dynamic);
    }

    @Override
    public void ah() {
        this.a(this.dJ().w(), Float.MAX_VALUE);
    }

    public boolean a(EntityTypes<?> type) {
        return true;
    }

    @Override
    protected void a_() {
        this.am.a(u, (byte)0);
        this.am.a(bJ, 0);
        this.am.a(bK, false);
        this.am.a(bL, 0);
        this.am.a(bM, 0);
        this.am.a(bI, Float.valueOf(1.0f));
        this.am.a(bN, Optional.empty());
    }

    public static AttributeProvider.Builder dM() {
        return AttributeProvider.a().a(GenericAttributes.a).a(GenericAttributes.c).a(GenericAttributes.d).a(GenericAttributes.i).a(GenericAttributes.j);
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
        if (!this.aV()) {
            this.bc();
        }
        if (!this.dI().B && onGround && this.aa > 0.0f) {
            this.dR();
            this.dS();
        }
        if (!this.dI().B && this.aa > 3.0f && onGround && !state.i()) {
            double d1 = this.dn();
            double d2 = this.dp();
            double d3 = this.dt();
            BlockPosition blockposition1 = this.di();
            if (landedPosition.u() != blockposition1.u() || landedPosition.w() != blockposition1.w()) {
                double d4 = d1 - (double)landedPosition.u() - 0.5;
                double d5 = d3 - (double)landedPosition.w() - 0.5;
                double d6 = Math.max(Math.abs(d4), Math.abs(d5));
                d1 = (double)landedPosition.u() + 0.5 + d4 / d6 * 0.5;
                d3 = (double)landedPosition.w() + 0.5 + d5 / d6 * 0.5;
            }
            float f2 = MathHelper.f(this.aa - 3.0f);
            double d7 = Math.min((double)(0.2f + f2 / 15.0f), 2.5);
            int i2 = (int)(150.0 * d7);
            if (this instanceof EntityPlayer) {
                ((WorldServer)this.dI()).sendParticles((EntityPlayer)this, new ParticleParamBlock(Particles.c, state), this.dn(), this.dp(), this.dt(), i2, 0.0, 0.0, 0.0, 0.15f, false);
            } else {
                ((WorldServer)this.dI()).a(new ParticleParamBlock(Particles.c, state), d1, d2, d3, i2, 0.0, 0.0, 0.0, 0.15f);
            }
        }
        super.a(heightDifference, onGround, state, landedPosition);
        if (onGround) {
            this.ce = Optional.empty();
        }
    }

    public boolean dN() {
        return this.eN() == EnumMonsterType.b;
    }

    public float a(float tickDelta) {
        return MathHelper.i(tickDelta, this.ci, this.ch);
    }

    @Override
    public void ao() {
        this.aO = this.aP;
        if (this.al) {
            this.fw().ifPresent(this::a);
        }
        if (this.dO()) {
            this.dP();
        }
        super.ao();
        this.dI().ad().a("livingEntityBaseTick");
        if (this.aU() || this.dI().B) {
            this.aw();
        }
        if (this.bs()) {
            BlockPosition blockposition;
            boolean flag = this instanceof EntityHuman;
            if (!this.dI().B) {
                double d1;
                double d0;
                if (this.bt()) {
                    this.a(this.dJ().f(), 1.0f);
                } else if (flag && !this.dI().w_().a(this.cE()) && (d0 = this.dI().w_().a(this) + this.dI().w_().n()) < 0.0 && (d1 = this.dI().w_().o()) > 0.0) {
                    this.a(this.dJ().v(), (float)Math.max(1, MathHelper.a(-d0 * d1)));
                }
            }
            if (((Entity)this).a(TagsFluid.a) && !this.dI().a_(BlockPosition.a(this.dn(), this.dr(), this.dt())).a(Blocks.nd)) {
                boolean flag1;
                boolean bl = flag1 = !this.dN() && !MobEffectUtil.c(this) && (!flag || !((EntityHuman)this).fO().a);
                if (flag1) {
                    this.j(this.m(this.cf()));
                    if (this.cf() == -20) {
                        this.j(0);
                        Vec3D vec3d = this.dl();
                        for (int i2 = 0; i2 < 8; ++i2) {
                            double d2 = this.af.j() - this.af.j();
                            double d3 = this.af.j() - this.af.j();
                            double d4 = this.af.j() - this.af.j();
                            this.dI().a(Particles.e, this.dn() + d2, this.dp() + d3, this.dt() + d4, vec3d.c, vec3d.d, vec3d.e);
                        }
                        this.a(this.dJ().h(), 2.0f);
                    }
                }
                if (!this.dI().B && this.bM() && this.cW() != null && this.cW().bO()) {
                    this.Y();
                }
            } else if (this.cf() < this.ce()) {
                this.j(this.n(this.cf()));
            }
            if (!this.dI().B && !com.google.common.base.Objects.equal((Object)this.cd, (Object)(blockposition = this.di()))) {
                this.cd = blockposition;
                this.c(blockposition);
            }
        }
        if (this.bs() && (this.aX() || this.az)) {
            this.aB();
        }
        if (this.aL > 0) {
            --this.aL;
        }
        if (this.ak > 0 && !(this instanceof EntityPlayer)) {
            --this.ak;
        }
        if (this.es() && this.dI().h(this)) {
            this.dX();
        }
        if (this.ba > 0) {
            --this.ba;
        } else {
            this.aZ = null;
        }
        if (this.bY != null && !this.bY.bs()) {
            this.bY = null;
        }
        if (this.bW != null) {
            if (!this.bW.bs()) {
                this.a((EntityLiving)null);
            } else if (this.ag - this.bX > 100) {
                this.a((EntityLiving)null);
            }
        }
        this.ej();
        this.bg = this.bf;
        this.aW = this.aV;
        this.aY = this.aX;
        this.M = this.dy();
        this.N = this.dA();
        this.dI().ad().c();
    }

    public boolean dO() {
        return this.ag % 5 == 0 && this.dl().c != 0.0 && this.dl().e != 0.0 && !this.G_() && EnchantmentManager.k(this) && this.dQ();
    }

    protected void dP() {
        Vec3D vec3d = this.dl();
        this.dI().a(Particles.I, this.dn() + (this.af.j() - 0.5) * (double)this.dd(), this.dp() + 0.1, this.dt() + (this.af.j() - 0.5) * (double)this.dd(), vec3d.c * -0.2, 0.1, vec3d.e * -0.2);
        float f2 = this.af.i() * 0.4f + this.af.i() > 0.9f ? 0.6f : 0.0f;
        this.a(SoundEffects.wd, f2, 0.6f + this.af.i() * 0.4f);
    }

    protected boolean dQ() {
        return this.dI().a_(this.aE()).a(TagsBlock.aL);
    }

    @Override
    protected float aH() {
        return this.dQ() && EnchantmentManager.a(Enchantments.l, this) > 0 ? 1.0f : super.aH();
    }

    protected boolean c(IBlockData landingState) {
        return !landingState.i() || this.fr();
    }

    protected void dR() {
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
        if (attributemodifiable != null && attributemodifiable.a(d) != null) {
            attributemodifiable.b(d);
        }
    }

    protected void dS() {
        int i2;
        if (!this.be().i() && (i2 = EnchantmentManager.a(Enchantments.l, this)) > 0 && this.dQ()) {
            AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
            if (attributemodifiable == null) {
                return;
            }
            attributemodifiable.b(new AttributeModifier(d, "Soul speed boost", (double)(0.03f * (1.0f + (float)i2 * 0.35f)), AttributeModifier.Operation.a));
            if (this.ec().i() < 0.04f) {
                ItemStack itemstack = this.c(EnumItemSlot.c);
                itemstack.a(1, this, (T entityliving) -> entityliving.d(EnumItemSlot.c));
            }
        }
    }

    protected void dT() {
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
        if (attributemodifiable != null && attributemodifiable.a(e) != null) {
            attributemodifiable.b(e);
        }
    }

    protected void dU() {
        int i2;
        if (!this.be().i() && (i2 = this.cg()) > 0) {
            AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
            if (attributemodifiable == null) {
                return;
            }
            float f2 = -0.05f * this.ch();
            attributemodifiable.b(new AttributeModifier(e, "Powder snow slow", (double)f2, AttributeModifier.Operation.a));
        }
    }

    protected void c(BlockPosition pos) {
        int i2 = EnchantmentManager.a(Enchantments.j, this);
        if (i2 > 0) {
            EnchantmentFrostWalker.a(this, this.dI(), pos, i2);
        }
        if (this.c(this.be())) {
            this.dR();
        }
        this.dS();
    }

    public boolean h_() {
        return false;
    }

    public float dV() {
        return this.h_() ? 0.5f : 1.0f;
    }

    protected boolean dW() {
        return true;
    }

    protected void dX() {
        ++this.aN;
        if (this.aN >= 20 && !this.dI().r_() && !this.dD()) {
            this.dI().a((Entity)this, (byte)60);
            this.a(Entity.RemovalReason.a);
        }
    }

    public boolean dY() {
        return !this.h_();
    }

    protected boolean dZ() {
        return !this.h_();
    }

    protected int m(int air) {
        int j2 = EnchantmentManager.e(this);
        return j2 > 0 && this.af.a(j2 + 1) > 0 ? air : air - 1;
    }

    protected int n(int air) {
        return Math.min(air + 4, this.ce());
    }

    public int ea() {
        return 0;
    }

    protected boolean eb() {
        return false;
    }

    public RandomSource ec() {
        return this.af;
    }

    @Nullable
    public EntityLiving ed() {
        return this.bW;
    }

    @Override
    public EntityLiving M_() {
        return this.ed();
    }

    public int ee() {
        return this.bX;
    }

    public void c(@Nullable EntityHuman attacking) {
        this.aZ = attacking;
        this.ba = this.ag;
    }

    public void a(@Nullable EntityLiving attacker) {
        this.bW = attacker;
        this.bX = this.ag;
    }

    @Nullable
    public EntityLiving ef() {
        return this.bY;
    }

    public int eg() {
        return this.bZ;
    }

    public void x(Entity target) {
        this.bY = target instanceof EntityLiving ? (EntityLiving)target : null;
        this.bZ = this.ag;
    }

    public int eh() {
        return this.bc;
    }

    public void o(int despawnCounter) {
        this.bc = despawnCounter;
    }

    public boolean ei() {
        return !this.frictionState.toBooleanOrElse(!this.bU);
    }

    public void p(boolean noDrag) {
        this.bU = noDrag;
    }

    protected boolean a(EnumItemSlot slot) {
        return true;
    }

    public void a(EnumItemSlot slot, ItemStack oldStack, ItemStack newStack) {
        this.onEquipItem(slot, oldStack, newStack, false);
    }

    public void onEquipItem(EnumItemSlot enumitemslot, ItemStack itemstack, ItemStack itemstack1, boolean silent) {
        Equipable equipable;
        boolean flag;
        boolean bl = flag = itemstack1.b() && itemstack.b();
        if (!(flag || ItemStack.c(itemstack, itemstack1) || this.al || (equipable = Equipable.c_(itemstack1)) == null || this.G_() || equipable.g() != enumitemslot)) {
            if (!(this.dI().r_() || this.aQ() || silent)) {
                this.dI().a((EntityHuman)null, this.dn(), this.dp(), this.dt(), equipable.ak_(), this.cY(), 1.0f, 1.0f);
            }
            if (this.a(enumitemslot)) {
                this.a(GameEvent.w);
            }
        }
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        super.a(reason);
        this.bA.a();
    }

    @Override
    public void b(NBTTagCompound nbt) {
        if (this.frictionState != TriState.NOT_SET) {
            nbt.a("Paper.FrictionState", this.frictionState.toString());
        }
        nbt.a("Health", this.er());
        nbt.a("HurtTime", (short)this.aL);
        nbt.a("HurtByTimestamp", this.bX);
        nbt.a("DeathTime", (short)this.aN);
        nbt.a("AbsorptionAmount", this.ff());
        nbt.a("Attributes", this.eM().c());
        if (!this.bR.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (MobEffect mobeffect : this.bR.values()) {
                nbttaglist.add(mobeffect.a(new NBTTagCompound()));
            }
            nbt.a("ActiveEffects", nbttaglist);
        }
        nbt.a("FallFlying", this.fr());
        this.fw().ifPresent(blockposition -> {
            nbt.a("SleepingX", blockposition.u());
            nbt.a("SleepingY", blockposition.v());
            nbt.a("SleepingZ", blockposition.w());
        });
        DataResult<NBTBase> dataresult = this.bA.a(DynamicOpsNBT.a);
        Logger logger = b;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("Brain", (NBTBase)nbtbase));
    }

    @Override
    public void a(NBTTagCompound nbt) {
        float absorptionAmount = nbt.j("AbsorptionAmount");
        if (Float.isNaN(absorptionAmount)) {
            absorptionAmount = 0.0f;
        }
        this.y(absorptionAmount);
        if (nbt.e("Paper.FrictionState")) {
            String fs = nbt.l("Paper.FrictionState");
            try {
                this.frictionState = TriState.valueOf((String)fs);
            }
            catch (Exception ignored) {
                b.error("Unknown friction state " + fs + " for " + this);
            }
        }
        if (nbt.b("Attributes", 9) && this.dI() != null && !this.dI().B) {
            this.eM().a(nbt.c("Attributes", 10));
        }
        if (nbt.b("ActiveEffects", 9)) {
            NBTTagList nbttaglist = nbt.c("ActiveEffects", 10);
            for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
                NBTTagCompound nbttagcompound1 = nbttaglist.a(i2);
                MobEffect mobeffect = MobEffect.b(nbttagcompound1);
                if (mobeffect == null) continue;
                this.bR.put(mobeffect.c(), mobeffect);
            }
        }
        if (nbt.e("Bukkit.MaxHealth")) {
            NBTBase nbtbase = nbt.c("Bukkit.MaxHealth");
            if (nbtbase.b() == 5) {
                this.a(GenericAttributes.a).a(((NBTTagFloat)nbtbase).j());
            } else if (nbtbase.b() == 3) {
                this.a(GenericAttributes.a).a(((NBTTagInt)nbtbase).j());
            }
        }
        if (nbt.b("Health", 99)) {
            this.t(nbt.j("Health"));
        }
        this.aL = nbt.g("HurtTime");
        this.aN = nbt.g("DeathTime");
        this.bX = nbt.h("HurtByTimestamp");
        if (nbt.b("Team", 8)) {
            boolean flag;
            String s2 = nbt.l("Team");
            ScoreboardTeam scoreboardteam = this.dI().I().f(s2);
            if (!this.dI().paperConfig().scoreboards.allowNonPlayerEntitiesOnScoreboards && !(this instanceof EntityHuman)) {
                scoreboardteam = null;
            }
            boolean bl = flag = scoreboardteam != null && this.dI().I().a(this.cu(), scoreboardteam);
            if (!flag) {
                b.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", (Object)s2);
            }
        }
        if (nbt.q("FallFlying")) {
            this.b(7, true);
        }
        if (nbt.b("SleepingX", 99) && nbt.b("SleepingY", 99) && nbt.b("SleepingZ", 99)) {
            BlockPosition blockposition = new BlockPosition(nbt.h("SleepingX"), nbt.h("SleepingY"), nbt.h("SleepingZ"));
            this.g(blockposition);
            this.am.b(Entity.ar, EntityPose.c);
            if (!this.al) {
                this.a(blockposition);
            }
        }
        if (nbt.b("Brain", 10)) {
            this.bA = this.a(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("Brain")));
        }
    }

    protected void ej() {
        Iterator<MobEffectList> iterator = this.bR.keySet().iterator();
        this.isTickingEffects = true;
        try {
            while (iterator.hasNext()) {
                MobEffectList mobeffectlist = iterator.next();
                MobEffect mobeffect = this.bR.get(mobeffectlist);
                if (!mobeffect.a(this, () -> this.a(mobeffect, true, (Entity)null))) {
                    EntityPotionEffectEvent event;
                    if (this.dI().B || (event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect, null, EntityPotionEffectEvent.Cause.EXPIRATION)).isCancelled()) continue;
                    iterator.remove();
                    this.a(mobeffect);
                    continue;
                }
                if (mobeffect.d() % 600 != 0) continue;
                this.a(mobeffect, false, (Entity)null);
            }
        }
        catch (ConcurrentModificationException mobeffectlist) {
            // empty catch block
        }
        this.isTickingEffects = false;
        for (ProcessableEffect e2 : this.effectsToProcess) {
            if (e2.effect != null) {
                this.addEffect(e2.effect, e2.cause);
                continue;
            }
            this.removeEffect(e2.type, e2.cause);
        }
        this.effectsToProcess.clear();
        if (this.bV) {
            if (!this.dI().B) {
                this.F();
                this.q();
            }
            this.bV = false;
        }
        int i2 = this.am.b(bJ);
        boolean flag = this.am.b(bK);
        if (i2 > 0) {
            boolean flag1 = this.cb() ? this.af.a(15) == 0 : this.af.h();
            if (flag) {
                flag1 &= this.af.a(5) == 0;
            }
            if (flag1 && i2 > 0) {
                double d0 = (double)(i2 >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i2 >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i2 >> 0 & 0xFF) / 255.0;
                this.dI().a(flag ? Particles.a : Particles.v, this.d(0.5), this.dq(), this.g(0.5), d0, d1, d2);
            }
        }
    }

    protected void F() {
        if (this.bR.isEmpty()) {
            this.em();
            this.j(false);
        } else {
            Collection<MobEffect> collection = this.bR.values();
            this.am.b(bK, EntityLiving.c(collection));
            this.am.b(bJ, PotionUtil.a(collection));
            this.j(this.a(MobEffects.n));
        }
    }

    private void q() {
        boolean flag = this.ca();
        if (this.i(6) != flag) {
            this.b(6, flag);
        }
    }

    public double y(@Nullable Entity entity) {
        double d0 = 1.0;
        if (this.bS()) {
            d0 *= 0.8;
        }
        if (this.cb()) {
            float f2 = this.eQ();
            if (f2 < 0.1f) {
                f2 = 0.1f;
            }
            d0 *= 0.7 * (double)f2;
        }
        if (entity != null) {
            ItemStack itemstack = this.c(EnumItemSlot.f);
            EntityTypes<?> entitytypes = entity.ae();
            if (entitytypes == EntityTypes.aJ && itemstack.a(Items.tr) || entitytypes == EntityTypes.bp && itemstack.a(Items.tu) || entitytypes == EntityTypes.aw && itemstack.a(Items.tx) || entitytypes == EntityTypes.ax && itemstack.a(Items.tx) || entitytypes == EntityTypes.u && itemstack.a(Items.tv)) {
                d0 *= 0.5;
            }
        }
        return d0;
    }

    public boolean c(EntityLiving target) {
        return target instanceof EntityHuman && this.dI().ai() == EnumDifficulty.a ? false : target.ek();
    }

    public boolean a(EntityLiving entity, PathfinderTargetCondition predicate) {
        return predicate.a(this, entity);
    }

    public boolean ek() {
        return !this.co() && this.el();
    }

    public boolean el() {
        return !this.G_() && this.bs();
    }

    public static boolean c(Collection<MobEffect> effects) {
        MobEffect mobeffect;
        Iterator<MobEffect> iterator = effects.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (!(mobeffect = iterator.next()).g() || mobeffect.f());
        return false;
    }

    protected void em() {
        this.am.b(bK, false);
        this.am.b(bJ, 0);
    }

    public boolean en() {
        return this.removeAllEffects(EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        if (this.dI().B) {
            return false;
        }
        Iterator<MobEffect> iterator = this.bR.values().iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            MobEffect effect = iterator.next();
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause, EntityPotionEffectEvent.Action.CLEARED);
            if (!event.isCancelled()) {
                this.a(effect);
                iterator.remove();
            }
            flag = true;
        }
        return flag;
    }

    public Collection<MobEffect> eo() {
        return this.bR.values();
    }

    public Map<MobEffectList, MobEffect> ep() {
        return this.bR;
    }

    public boolean a(MobEffectList effect) {
        return this.bR.containsKey(effect);
    }

    @Nullable
    public MobEffect b(MobEffectList effect) {
        return this.bR.get(effect);
    }

    public final boolean b(MobEffect effect) {
        return this.b(effect, (Entity)null);
    }

    public boolean addEffect(MobEffect mobeffect, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(mobeffect, null, cause);
    }

    public boolean b(MobEffect effect, @Nullable Entity source) {
        return this.addEffect(effect, source, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean addEffect(MobEffect mobeffect, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause) {
        EntityPotionEffectEvent event;
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(mobeffect, cause));
            return true;
        }
        if (!this.c(mobeffect)) {
            return false;
        }
        MobEffect mobeffect1 = this.bR.get(mobeffect.c());
        boolean override = false;
        if (mobeffect1 != null) {
            override = new MobEffect(mobeffect1).b(mobeffect);
        }
        if ((event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect1, mobeffect, cause, override)).isCancelled()) {
            return false;
        }
        if (mobeffect1 == null) {
            this.bR.put(mobeffect.c(), mobeffect);
            this.a(mobeffect, entity);
            return true;
        }
        if (event.isOverride()) {
            mobeffect1.b(mobeffect);
            this.a(mobeffect1, true, entity);
            return true;
        }
        return false;
    }

    public boolean c(MobEffect effect) {
        MobEffectList mobeffectlist;
        return this.eN() != EnumMonsterType.b || (mobeffectlist = effect.c()) != MobEffects.j && mobeffectlist != MobEffects.s || !this.dI().paperConfig().entities.mobEffects.undeadImmuneToCertainEffects;
    }

    public void c(MobEffect effect, @Nullable Entity source) {
        if (this.c(effect)) {
            MobEffect mobeffect1 = this.bR.put(effect.c(), effect);
            if (mobeffect1 == null) {
                this.a(effect, source);
            } else {
                this.a(effect, true, source);
            }
        }
    }

    public boolean eq() {
        return this.eN() == EnumMonsterType.b;
    }

    @Nullable
    public MobEffect c(@Nullable MobEffectList type) {
        return this.c(type, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    @Nullable
    public MobEffect c(@Nullable MobEffectList mobeffectlist, EntityPotionEffectEvent.Cause cause) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(mobeffectlist, cause));
            return null;
        }
        MobEffect effect = this.bR.get(mobeffectlist);
        if (effect == null) {
            return null;
        }
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause);
        if (event.isCancelled()) {
            return null;
        }
        return this.bR.remove(mobeffectlist);
    }

    public boolean d(MobEffectList type) {
        return this.removeEffect(type, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeEffect(MobEffectList mobeffectlist, EntityPotionEffectEvent.Cause cause) {
        MobEffect mobeffect = this.c(mobeffectlist, cause);
        if (mobeffect != null) {
            this.a(mobeffect);
            return true;
        }
        return false;
    }

    protected void a(MobEffect effect, @Nullable Entity source) {
        this.bV = true;
        if (!this.dI().B) {
            effect.c().b(this, this.eM(), effect.e());
            this.d(effect);
        }
    }

    public void d(MobEffect effect) {
        for (Entity entity : this.cN()) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer entityplayer = (EntityPlayer)entity;
            entityplayer.c.a(new PacketPlayOutEntityEffect(this.af(), effect));
        }
    }

    protected void a(MobEffect effect, boolean reapplyEffect, @Nullable Entity source) {
        this.bV = true;
        if (reapplyEffect && !this.dI().B) {
            MobEffectList mobeffectlist = effect.c();
            mobeffectlist.a(this, this.eM(), effect.e());
            mobeffectlist.b(this, this.eM(), effect.e());
        }
        if (!this.dI().B) {
            this.d(effect);
        }
    }

    protected void a(MobEffect effect) {
        this.bV = true;
        if (!this.dI().B) {
            effect.c().a(this, this.eM(), effect.e());
            for (Entity entity : this.cN()) {
                if (!(entity instanceof EntityPlayer)) continue;
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.c.a(new PacketPlayOutRemoveEntityEffect(this.af(), effect.c()));
            }
        }
    }

    public void s(float amount) {
        this.heal(amount, EntityRegainHealthEvent.RegainReason.CUSTOM);
    }

    public void heal(float f2, EntityRegainHealthEvent.RegainReason regainReason) {
        this.heal(f2, regainReason, false);
    }

    public void heal(float f2, EntityRegainHealthEvent.RegainReason regainReason, boolean isFastRegen) {
        float f1 = this.er();
        if (f1 > 0.0f) {
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (double)f2, regainReason, isFastRegen);
            if (this.valid) {
                this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                this.t((float)((double)this.er() + event.getAmount()));
            }
        }
    }

    public float er() {
        if (this instanceof EntityPlayer) {
            return (float)((EntityPlayer)this).getBukkitEntity().getHealth();
        }
        return this.am.b(bI).floatValue();
    }

    public void t(float health) {
        if (Float.isNaN(health)) {
            health = this.eI();
            if (this.valid) {
                System.err.println("[NAN-HEALTH] " + this.cv() + " had NaN health set");
            }
        }
        if (this instanceof EntityPlayer) {
            CraftPlayer player = ((EntityPlayer)this).getBukkitEntity();
            if (health < 0.0f) {
                player.setRealHealth(0.0);
            } else if ((double)health > player.getMaxHealth()) {
                player.setRealHealth(player.getMaxHealth());
            } else {
                player.setRealHealth(health);
            }
            player.updateScaledHealth(false);
            return;
        }
        this.am.b(bI, Float.valueOf(MathHelper.a(health, 0.0f, this.eI())));
    }

    public boolean es() {
        return this.er() <= 0.0f;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean flag2;
        boolean knockbackCancelled;
        if (this.b(source)) {
            return false;
        }
        if (this.dI().B) {
            return false;
        }
        if (this.dD() || this.bb || this.er() <= 0.0f) {
            return false;
        }
        if (source.a(DamageTypeTags.i) && this.a(MobEffects.l)) {
            return false;
        }
        if (this.fy() && !this.dI().B) {
            this.fz();
        }
        this.bc = 0;
        float f1 = amount;
        boolean flag = amount > 0.0f && this.f(source);
        float f2 = 0.0f;
        if (source.a(DamageTypeTags.o) && this.ae().a(TagsEntity.j)) {
            amount *= 5.0f;
        }
        this.aR.a(1.5f);
        boolean flag1 = true;
        if ((float)this.ak > (float)this.aS / 2.0f && !source.a(DamageTypeTags.e)) {
            if (amount <= this.bj) {
                return false;
            }
            if (!this.damageEntity0(source, amount - this.bj)) {
                return false;
            }
            this.bj = amount;
            flag1 = false;
        } else {
            if (!this.damageEntity0(source, amount)) {
                return false;
            }
            this.bj = amount;
            this.ak = this.aS;
            this.aL = this.aM = 10;
        }
        Entity entity1 = source.d();
        if (entity1 != null) {
            EntityWolf entitywolf;
            if (entity1 instanceof EntityLiving) {
                EntityLiving entityliving1 = (EntityLiving)entity1;
                if (!source.a(DamageTypeTags.q)) {
                    this.a(entityliving1);
                }
            }
            if (entity1 instanceof EntityHuman) {
                EntityHuman entityhuman = (EntityHuman)entity1;
                this.ba = 100;
                this.aZ = entityhuman;
            } else if (entity1 instanceof EntityWolf && (entitywolf = (EntityWolf)entity1).q()) {
                EntityHuman entityhuman1;
                this.ba = 100;
                EntityLiving entityliving2 = entitywolf.I_();
                this.aZ = entityliving2 instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entityliving2) : null;
            }
        }
        boolean bl = knockbackCancelled = this.dI().paperConfig().environment.disableExplosionKnockback && source.a(DamageTypeTags.l) && this instanceof EntityHuman;
        if (flag1) {
            if (flag) {
                this.dI().a((Entity)this, (byte)29);
            } else if (!knockbackCancelled) {
                this.dI().a((Entity)this, source);
            }
            if (!(source.a(DamageTypeTags.r) || flag && !(amount > 0.0f))) {
                this.bl();
            }
            if (entity1 != null && !source.a(DamageTypeTags.l)) {
                double d1;
                boolean far = entity1.f(this) > 40000.0;
                double d0 = far ? Math.random() - Math.random() : entity1.dn() - this.dn();
                double d2 = d1 = far ? Math.random() - Math.random() : entity1.dt() - this.dt();
                while (d0 * d0 + d1 * d1 < 1.0E-4) {
                    d0 = (Math.random() - Math.random()) * 0.01;
                    d1 = (Math.random() - Math.random()) * 0.01;
                }
                this.knockback(0.4f, d0, d1, entity1);
                if (!flag) {
                    this.a(d0, d1);
                }
            }
        }
        if (knockbackCancelled) {
            this.dI().a((Entity)this, (byte)2);
        }
        if (this.es()) {
            if (!this.h(source)) {
                this.silentDeath = !flag1;
                this.a(source);
                this.silentDeath = false;
            }
        } else if (flag1) {
            this.e(source);
        }
        boolean bl2 = flag2 = !flag || amount > 0.0f;
        if (flag2) {
            this.cf = source;
            this.cg = this.dI().V();
        }
        if (this instanceof EntityPlayer) {
            CriterionTriggers.h.a((EntityPlayer)this, source, f1, amount, flag);
            if (f2 > 0.0f && f2 < 3.4028235E37f) {
                ((EntityPlayer)this).a(StatisticList.K, Math.round(f2 * 10.0f));
            }
        }
        if (entity1 instanceof EntityPlayer) {
            CriterionTriggers.g.a((EntityPlayer)entity1, this, source, f1, amount, flag);
        }
        return flag2;
    }

    protected void d(EntityLiving attacker) {
        attacker.e(this);
    }

    protected void e(EntityLiving target) {
        target.knockback(0.5, target.dn() - this.dn(), target.dt() - this.dt(), this);
    }

    private boolean h(DamageSource source) {
        if (source.a(DamageTypeTags.d)) {
            return false;
        }
        ItemStack itemstack = null;
        EnumHand[] aenumhand = EnumHand.values();
        int i2 = aenumhand.length;
        EnumHand hand = null;
        ItemStack itemstack1 = ItemStack.b;
        for (int j2 = 0; j2 < i2; ++j2) {
            EnumHand enumhand = aenumhand[j2];
            itemstack1 = this.b(enumhand);
            if (!itemstack1.a(Items.uz)) continue;
            hand = enumhand;
            itemstack = itemstack1.p();
            break;
        }
        EquipmentSlot handSlot = hand != null ? CraftEquipmentSlot.getHand(hand) : null;
        EntityResurrectEvent event = new EntityResurrectEvent((LivingEntity)this.getBukkitEntity(), handSlot);
        event.setCancelled(itemstack == null);
        this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            if (!itemstack1.b() && itemstack != null) {
                itemstack1.h(1);
            }
            if (itemstack != null && this instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)this;
                entityplayer.b(StatisticList.c.b(Items.uz));
                CriterionTriggers.B.a(entityplayer, itemstack);
            }
            this.t(1.0f);
            this.removeAllEffects(EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new MobEffect(MobEffects.j, 900, 1), EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new MobEffect(MobEffects.v, 100, 1), EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new MobEffect(MobEffects.l, 800, 0), EntityPotionEffectEvent.Cause.TOTEM);
            this.dI().a((Entity)this, (byte)35);
        }
        return !event.isCancelled();
    }

    @Nullable
    public DamageSource et() {
        if (this.dI().V() - this.cg > 40L) {
            this.cf = null;
        }
        return this.cf;
    }

    protected void e(DamageSource source) {
        SoundEffect soundeffect = this.d(source);
        if (soundeffect != null) {
            this.a(soundeffect, this.eR(), this.eS());
        }
    }

    public boolean f(DamageSource source) {
        Vec3D vec3d;
        EntityArrow entityarrow;
        Entity entity = source.c();
        boolean flag = false;
        if (entity instanceof EntityArrow && (entityarrow = (EntityArrow)entity).w() > 0) {
            flag = true;
        }
        if (!source.a(DamageTypeTags.c) && this.fp() && !flag && (vec3d = source.h()) != null) {
            Vec3D vec3d1 = this.f(1.0f);
            Vec3D vec3d2 = vec3d.a(this.dg()).d();
            vec3d2 = new Vec3D(vec3d2.c, 0.0, vec3d2.e);
            if (vec3d2.b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    private void i(ItemStack stack) {
        if (!stack.b()) {
            if (!this.aQ()) {
                this.dI().a(this.dn(), this.dp(), this.dt(), SoundEffects.lZ, this.cY(), 0.8f, 0.8f + this.dI().z.i() * 0.4f, false);
            }
            this.a(stack, 5);
        }
    }

    public void a(DamageSource damageSource) {
        if (!this.dD() && !this.bb) {
            Entity entity = damageSource.d();
            EntityLiving entityliving = this.eH();
            this.bb = true;
            net.minecraft.world.level.World world = this.dI();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                EntityDeathEvent deathEvent = this.dropAllDeathLoot(damageSource);
                if (deathEvent == null || !deathEvent.isCancelled()) {
                    if (this instanceof EntityInsentient) {
                        for (EnumItemSlot slot : this.clearedEquipmentSlots) {
                            this.a(slot, ItemStack.b);
                        }
                        this.clearedEquipmentSlots.clear();
                    }
                    if (this.fy()) {
                        this.fz();
                    }
                    if (!this.dI().B && this.aa() && SpigotConfig.logNamedDeaths) {
                        b.info("Named entity {} died: {}", (Object)this, (Object)this.eG().a().getString());
                    }
                    this.eG().c();
                    if (entity != null) {
                        entity.a((WorldServer)this.dI(), this);
                    }
                    this.a(GameEvent.p);
                } else {
                    this.bb = false;
                    this.t((float)deathEvent.getReviveHealth());
                }
                this.f(entityliving);
            }
            if (this.bb) {
                this.dI().a((Entity)this, (byte)3);
                this.b(EntityPose.h);
            }
        }
    }

    protected void f(@Nullable EntityLiving adversary) {
        if (!this.dI().B) {
            boolean flag = false;
            if (this.bb && adversary instanceof EntityWither) {
                if (this.dI().X().b(GameRules.c)) {
                    BlockPosition blockposition = this.di();
                    IBlockData iblockdata = Blocks.cd.n();
                    if (this.dI().a_(blockposition).i() && iblockdata.a((IWorldReader)this.dI(), blockposition)) {
                        flag = CraftEventFactory.handleBlockFormEvent(this.dI(), blockposition, iblockdata, 3, this);
                    }
                }
                if (!flag) {
                    EntityItem entityitem = new EntityItem(this.dI(), this.dn(), this.dp(), this.dt(), new ItemStack(Items.da));
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                    CraftEventFactory.callEvent(event);
                    if (event.isCancelled()) {
                        return;
                    }
                    this.dI().b(entityitem);
                }
            }
        }
    }

    protected EntityDeathEvent dropAllDeathLoot(DamageSource source) {
        Entity entity = source.d();
        int i2 = entity instanceof EntityHuman ? EnchantmentManager.h((EntityLiving)entity) : 0;
        boolean flag = this.ba > 0;
        this.eu();
        if (this.dZ() && this.dI().X().b(GameRules.f)) {
            this.a(source, flag);
            boolean prev = this.clearEquipmentSlots;
            this.clearEquipmentSlots = false;
            this.clearedEquipmentSlots.clear();
            this.a(source, i2, flag);
            this.clearEquipmentSlots = prev;
        }
        EntityDeathEvent deathEvent = CraftEventFactory.callEntityDeathEvent(this, this.drops, () -> {
            EntityLiving entityliving = this.eH();
            if (this.bi >= 0 && entityliving != null) {
                entityliving.a((Entity)this, this.bi, source);
            }
        });
        this.postDeathDropItems(deathEvent);
        this.drops = new ArrayList();
        this.ev();
        return deathEvent;
    }

    protected void eu() {
    }

    protected void postDeathDropItems(EntityDeathEvent event) {
    }

    public int getExpReward() {
        if (this.dI() instanceof WorldServer && !this.ez() && (this.eb() || this.ba > 0 && this.dY() && this.dI().X().b(GameRules.f))) {
            int i2 = this.ea();
            return i2;
        }
        return 0;
    }

    protected void ev() {
        if (!(this instanceof EntityEnderDragon)) {
            EntityLiving attacker = this.aZ != null ? this.aZ : this.bW;
            EntityExperienceOrb.award((WorldServer)this.dI(), this.dg(), this.expToDrop, this instanceof EntityPlayer ? ExperienceOrb.SpawnReason.PLAYER_DEATH : ExperienceOrb.SpawnReason.ENTITY_DEATH, attacker, this);
            this.expToDrop = 0;
        }
    }

    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
    }

    public MinecraftKey ew() {
        return this.ae().j();
    }

    public long ex() {
        return 0L;
    }

    protected void a(DamageSource damageSource, boolean causedByPlayer) {
        MinecraftKey minecraftkey = this.ew();
        LootTable loottable = this.dI().n().aH().getLootTable(minecraftkey);
        LootParams.a lootparams_a = new LootParams.a((WorldServer)this.dI()).a(LootContextParameters.a, this).a(LootContextParameters.f, this.dg()).a(LootContextParameters.c, damageSource).b(LootContextParameters.d, damageSource.d()).b(LootContextParameters.e, damageSource.c());
        if (causedByPlayer && this.aZ != null) {
            lootparams_a = lootparams_a.a(LootContextParameters.b, this.aZ).a(this.aZ.gj());
        }
        LootParams lootparams = lootparams_a.a(LootContextParameterSets.f);
        loottable.a(lootparams, this.ex(), this::b);
    }

    public void q(double strength, double x2, double z2) {
        this.knockback(strength, x2, z2, null);
    }

    public void knockback(double strength, double x2, double z2, Entity knockingBackEntity) {
        if ((strength *= 1.0 - this.b(GenericAttributes.c)) > 0.0) {
            this.at = true;
            Vec3D vec3d = this.dl();
            Vec3D vec3d1 = new Vec3D(x2, 0.0, z2).d().a(strength);
            this.o(vec3d.c / 2.0 - vec3d1.c, this.ay() ? Math.min(0.4, vec3d.d / 2.0 + strength) : vec3d.d, vec3d.e / 2.0 - vec3d1.e);
            Vec3D currentMovement = this.dl();
            Vector delta = new Vector(currentMovement.c - vec3d.c, currentMovement.d - vec3d.d, currentMovement.e - vec3d.e);
            this.f(vec3d);
            if (knockingBackEntity == null || new EntityKnockbackByEntityEvent((LivingEntity)this.getBukkitEntity(), (org.bukkit.entity.Entity)knockingBackEntity.getBukkitEntity(), (float)strength, delta).callEvent()) {
                this.o(vec3d.c + delta.getX(), vec3d.d + delta.getY(), vec3d.e + delta.getZ());
            }
        }
    }

    public void a(double deltaX, double deltaZ) {
    }

    @Nullable
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.iZ;
    }

    @Nullable
    public SoundEffect g_() {
        return SoundEffects.iU;
    }

    private SoundEffect d(int distance) {
        return distance > 4 ? this.eC().b() : this.eC().a();
    }

    public void ey() {
        this.cj = true;
    }

    public boolean ez() {
        return this.cj;
    }

    protected Vec3D eA() {
        Entity entity = this.cW();
        if (entity instanceof RiderShieldingMount) {
            RiderShieldingMount ridershieldingmount = (RiderShieldingMount)((Object)entity);
            return this.dg().b(0.0, ridershieldingmount.d(), 0.0);
        }
        return this.dg();
    }

    public float eB() {
        return 0.0f;
    }

    public a eC() {
        return new a(SoundEffects.ja, SoundEffects.iS);
    }

    protected SoundEffect c(ItemStack stack) {
        return stack.N();
    }

    public SoundEffect d(ItemStack stack) {
        return stack.O();
    }

    public SoundEffect getHurtSound0(DamageSource damagesource) {
        return this.d(damagesource);
    }

    public SoundEffect getDeathSound0() {
        return this.g_();
    }

    public SoundEffect getFallDamageSound0(int fallHeight) {
        return this.d(fallHeight);
    }

    public SoundEffect getDrinkingSound0(ItemStack itemstack) {
        return this.c(itemstack);
    }

    public SoundEffect getEatingSound0(ItemStack itemstack) {
        return this.d(itemstack);
    }

    public Optional<BlockPosition> eD() {
        return this.ce;
    }

    public boolean i_() {
        if (this.G_()) {
            return false;
        }
        BlockPosition blockposition = this.di();
        IBlockData iblockdata = this.dj();
        if (iblockdata.a(TagsBlock.aN)) {
            this.ce = Optional.of(blockposition);
            return true;
        }
        if (iblockdata.b() instanceof BlockTrapdoor && this.c(blockposition, iblockdata)) {
            this.ce = Optional.of(blockposition);
            return true;
        }
        return false;
    }

    private boolean c(BlockPosition pos, IBlockData state) {
        IBlockData iblockdata1;
        return state.c(BlockTrapdoor.a) != false && (iblockdata1 = this.dI().a_(pos.d())).a(Blocks.cO) && iblockdata1.c(BlockLadder.a) == state.c(BlockFacingHorizontal.aC);
    }

    @Override
    public boolean bs() {
        return !this.dD() && this.er() > 0.0f;
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        boolean flag = super.a(fallDistance, damageMultiplier, damageSource);
        int i2 = this.d(fallDistance, damageMultiplier);
        if (i2 > 0) {
            if (!this.a(damageSource, (float)i2)) {
                return true;
            }
            this.a(this.d(i2), 1.0f, 1.0f);
            this.eE();
            return true;
        }
        return flag;
    }

    protected int d(float fallDistance, float damageMultiplier) {
        if (this.ae().a(TagsEntity.l)) {
            return 0;
        }
        MobEffect mobeffect = this.b(MobEffects.h);
        float f2 = mobeffect == null ? 0.0f : (float)(mobeffect.e() + 1);
        return MathHelper.f((fallDistance - 3.0f - f2) * damageMultiplier);
    }

    protected void eE() {
        if (!this.aQ()) {
            int i2 = MathHelper.a(this.dn());
            int j2 = MathHelper.a(this.dp() - (double)0.2f);
            int k2 = MathHelper.a(this.dt());
            IBlockData iblockdata = this.dI().a_(new BlockPosition(i2, j2, k2));
            if (!iblockdata.i()) {
                SoundEffectType soundeffecttype = iblockdata.w();
                this.a(soundeffecttype.g(), soundeffecttype.a() * 0.5f, soundeffecttype.b() * 0.75f);
            }
        }
    }

    @Override
    public void m(float yaw) {
        this.aL = this.aM = 10;
    }

    public int eF() {
        return MathHelper.a(this.b(GenericAttributes.i));
    }

    protected void b(DamageSource source, float amount) {
    }

    protected void c(DamageSource source, float amount) {
    }

    protected void u(float amount) {
    }

    protected float d(DamageSource source, float amount) {
        if (!source.a(DamageTypeTags.b)) {
            amount = CombatMath.a(amount, this.eF(), (float)this.b(GenericAttributes.j));
        }
        return amount;
    }

    protected float e(DamageSource source, float amount) {
        if (source.a(DamageTypeTags.f)) {
            return amount;
        }
        if (amount <= 0.0f) {
            return 0.0f;
        }
        if (source.a(DamageTypeTags.h)) {
            return amount;
        }
        int i2 = EnchantmentManager.a(this.bJ(), source);
        if (i2 > 0) {
            amount = CombatMath.a(amount, i2);
        }
        return amount;
    }

    protected boolean damageEntity0(final DamageSource damagesource, float f2) {
        if (!this.b(damagesource)) {
            Entity entity;
            float f3;
            boolean human = this instanceof EntityHuman;
            float originalDamage = f2;
            Function<Double, Double> hardHat = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    if (damagesource.a(DamageTypeTags.a) && !EntityLiving.this.c(EnumItemSlot.f).b()) {
                        return -(f2 - f2 * 0.75);
                    }
                    return -0.0;
                }
            };
            float hardHatModifier = ((Double)hardHat.apply((Object)f2)).floatValue();
            Function<Double, Double> blocking = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    return -(EntityLiving.this.f(damagesource) ? f2 : 0.0);
                }
            };
            float blockingModifier = ((Double)blocking.apply((Object)(f2 += hardHatModifier))).floatValue();
            Function<Double, Double> armor = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    return -(f2 - (double)EntityLiving.this.d(damagesource, f2.floatValue()));
                }
            };
            float armorModifier = ((Double)armor.apply((Object)(f2 += blockingModifier))).floatValue();
            Function<Double, Double> resistance = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    if (!damagesource.a(DamageTypeTags.f) && EntityLiving.this.a(MobEffects.k) && !damagesource.a(DamageTypeTags.g)) {
                        int i2 = (EntityLiving.this.b(MobEffects.k).e() + 1) * 5;
                        int j2 = 25 - i2;
                        float f1 = f2.floatValue() * (float)j2;
                        return -(f2 - (double)(f1 / 25.0f));
                    }
                    return -0.0;
                }
            };
            float resistanceModifier = ((Double)resistance.apply((Object)(f2 += armorModifier))).floatValue();
            Function<Double, Double> magic = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    return -(f2 - (double)EntityLiving.this.e(damagesource, f2.floatValue()));
                }
            };
            float magicModifier = ((Double)magic.apply((Object)(f2 += resistanceModifier))).floatValue();
            Function<Double, Double> absorption = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    return -Math.max(f2 - Math.max(f2 - (double)EntityLiving.this.ff(), 0.0), 0.0);
                }
            };
            float absorptionModifier = ((Double)absorption.apply((Object)(f2 += magicModifier))).floatValue();
            EntityDamageEvent event = CraftEventFactory.handleLivingEntityDamageEvent(this, damagesource, originalDamage, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, hardHat, blocking, armor, resistance, magic, absorption);
            if (damagesource.d() instanceof EntityHuman) {
                if (damagesource.d() instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)damagesource.d();
                    if (new PlayerAttackEntityCooldownResetEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), player.A(0.0f)).callEvent()) {
                        player.gh();
                    }
                } else {
                    ((EntityHuman)damagesource.d()).gh();
                }
            }
            if (event.isCancelled()) {
                return false;
            }
            f2 = (float)event.getFinalDamage();
            if (event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE) < 0.0 && (f3 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE))) > 0.0f && f3 < 3.4028235E37f) {
                if (this instanceof EntityPlayer) {
                    ((EntityPlayer)this).a(StatisticList.M, Math.round(f3 * 10.0f));
                } else if (damagesource.d() instanceof EntityPlayer) {
                    ((EntityPlayer)damagesource.d()).a(StatisticList.I, Math.round(f3 * 10.0f));
                }
            }
            if (damagesource.a(DamageTypeTags.a) && !this.c(EnumItemSlot.f).b()) {
                this.c(damagesource, f2);
            }
            if (!damagesource.a(DamageTypeTags.b)) {
                float armorDamage = (float)(event.getDamage() + event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) + event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT));
                this.b(damagesource, armorDamage);
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                this.dI().a((Entity)this, (byte)29);
                this.u((float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING)));
                Entity entity2 = damagesource.c();
                if (entity2 instanceof EntityLiving && entity2.f(this) <= 40000.0) {
                    this.d((EntityLiving)entity2);
                }
            }
            absorptionModifier = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.ABSORPTION));
            this.y(Math.max(this.ff() - absorptionModifier, 0.0f));
            float f22 = absorptionModifier;
            if (f22 > 0.0f && f22 < 3.4028235E37f && this instanceof EntityHuman) {
                ((EntityHuman)this).a(StatisticList.L, Math.round(f22 * 10.0f));
            }
            if (f22 > 0.0f && f22 < 3.4028235E37f && (entity = damagesource.d()) instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.a(StatisticList.H, Math.round(f22 * 10.0f));
            }
            if (f2 > 0.0f || !human) {
                if (human) {
                    ((EntityHuman)this).causeFoodExhaustion(damagesource.a(), EntityExhaustionEvent.ExhaustionReason.DAMAGED);
                    if (f2 < 3.4028235E37f) {
                        ((EntityHuman)this).a(StatisticList.J, Math.round(f2 * 10.0f));
                    }
                }
                this.eG().a(damagesource, f2);
                this.t(this.er() - f2);
                if (!human) {
                    this.y(this.ff() - f2);
                }
                this.a(GameEvent.o);
                return true;
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                if (this instanceof EntityPlayer) {
                    CriterionTriggers.h.a((EntityPlayer)this, damagesource, originalDamage, f2, true);
                    f22 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
                    if (f22 > 0.0f && f22 < 3.4028235E37f) {
                        ((EntityPlayer)this).a(StatisticList.K, Math.round(originalDamage * 10.0f));
                    }
                }
                if (damagesource.d() instanceof EntityPlayer) {
                    CriterionTriggers.g.a((EntityPlayer)damagesource.d(), this, damagesource, originalDamage, f2, true);
                }
                return false;
            }
            return originalDamage > 0.0f;
        }
        return false;
    }

    public CombatTracker eG() {
        return this.bQ;
    }

    @Nullable
    public EntityLiving eH() {
        return this.aZ != null ? this.aZ : (this.bW != null ? this.bW : null);
    }

    public final float eI() {
        return (float)this.b(GenericAttributes.a);
    }

    public final int eJ() {
        return this.am.b(bL);
    }

    public final void p(int stuckArrowCount) {
        this.setArrowCount(stuckArrowCount, false);
    }

    public final void setArrowCount(int i2, boolean flag) {
        ArrowBodyCountChangeEvent event = CraftEventFactory.callArrowBodyCountChangeEvent(this, this.eJ(), i2, flag);
        if (event.isCancelled()) {
            return;
        }
        this.am.b(bL, event.getNewAmount());
    }

    public final int eK() {
        return this.am.b(bM);
    }

    public final void q(int stingerCount) {
        this.am.b(bM, stingerCount);
    }

    private int s() {
        return MobEffectUtil.a(this) ? 6 - (1 + MobEffectUtil.b(this)) : (this.a(MobEffects.d) ? 6 + (1 + this.b(MobEffects.d).e()) * 2 : 6);
    }

    public void a(EnumHand hand) {
        this.a(hand, false);
    }

    public void a(EnumHand hand, boolean fromServerPlayer) {
        if (!this.aG || this.aI >= this.s() / 2 || this.aI < 0) {
            this.aI = -1;
            this.aG = true;
            this.aH = hand;
            if (this.dI() instanceof WorldServer) {
                PacketPlayOutAnimation packetplayoutanimation = new PacketPlayOutAnimation(this, hand == EnumHand.a ? 0 : 3);
                ChunkProviderServer chunkproviderserver = ((WorldServer)this.dI()).k();
                if (fromServerPlayer) {
                    chunkproviderserver.a(this, packetplayoutanimation);
                } else {
                    chunkproviderserver.b(this, packetplayoutanimation);
                }
            }
        }
    }

    @Override
    public void c(DamageSource damageSource) {
        this.aR.a(1.5f);
        this.ak = 20;
        this.aL = this.aM = 10;
        SoundEffect soundeffect = this.d(damageSource);
        if (soundeffect != null) {
            this.a(soundeffect, this.eR(), (this.af.i() - this.af.i()) * 0.2f + 1.0f);
        }
        this.a(this.dJ().n(), 0.0f);
        this.cf = damageSource;
        this.cg = this.dI().V();
    }

    @Override
    public void b(byte status) {
        switch (status) {
            case 3: {
                SoundEffect soundeffect = this.g_();
                if (soundeffect != null) {
                    this.a(soundeffect, this.eR(), (this.af.i() - this.af.i()) * 0.2f + 1.0f);
                }
                if (this instanceof EntityHuman) break;
                this.t(0.0f);
                this.a(this.dJ().n());
                break;
            }
            case 29: {
                this.a(SoundEffects.uQ, 1.0f, 0.8f + this.dI().z.i() * 0.4f);
                break;
            }
            case 30: {
                this.a(SoundEffects.uR, 0.8f, 0.8f + this.dI().z.i() * 0.4f);
                break;
            }
            case 46: {
                boolean flag = true;
                for (int i2 = 0; i2 < 128; ++i2) {
                    double d0 = (double)i2 / 127.0;
                    float f2 = (this.af.i() - 0.5f) * 0.2f;
                    float f1 = (this.af.i() - 0.5f) * 0.2f;
                    float f22 = (this.af.i() - 0.5f) * 0.2f;
                    double d1 = MathHelper.d(d0, this.J, this.dn()) + (this.af.j() - 0.5) * (double)this.dd() * 2.0;
                    double d2 = MathHelper.d(d0, this.K, this.dp()) + this.af.j() * (double)this.de();
                    double d3 = MathHelper.d(d0, this.L, this.dt()) + (this.af.j() - 0.5) * (double)this.dd() * 2.0;
                    this.dI().a(Particles.X, d1, d2, d3, (double)f2, (double)f1, f22);
                }
                return;
            }
            case 47: {
                this.i(this.c(EnumItemSlot.a));
                break;
            }
            case 48: {
                this.i(this.c(EnumItemSlot.b));
                break;
            }
            case 49: {
                this.i(this.c(EnumItemSlot.f));
                break;
            }
            case 50: {
                this.i(this.c(EnumItemSlot.e));
                break;
            }
            case 51: {
                this.i(this.c(EnumItemSlot.d));
                break;
            }
            case 52: {
                this.i(this.c(EnumItemSlot.c));
                break;
            }
            case 54: {
                BlockHoney.b(this);
                break;
            }
            case 55: {
                this.y();
                break;
            }
            case 60: {
                this.x();
                break;
            }
            default: {
                super.b(status);
            }
        }
    }

    private void x() {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d0 = this.af.k() * 0.02;
            double d1 = this.af.k() * 0.02;
            double d2 = this.af.k() * 0.02;
            this.dI().a(Particles.W, this.d(1.0), this.dq(), this.g(1.0), d0, d1, d2);
        }
    }

    private void y() {
        ItemStack itemstack = this.c(EnumItemSlot.b);
        this.a(EnumItemSlot.b, this.c(EnumItemSlot.a));
        this.a(EnumItemSlot.a, itemstack);
    }

    @Override
    protected void ax() {
        this.a(this.dJ().m(), 4.0f);
    }

    protected void eL() {
        int i2 = this.s();
        if (this.aG) {
            ++this.aI;
            if (this.aI >= i2) {
                this.aI = 0;
                this.aG = false;
            }
        } else {
            this.aI = 0;
        }
        this.aP = (float)this.aI / (float)i2;
    }

    @Nullable
    public AttributeModifiable a(AttributeBase attribute) {
        return this.eM().a(attribute);
    }

    public double a(Holder<AttributeBase> attribute) {
        return this.b(attribute.a());
    }

    public double b(AttributeBase attribute) {
        return this.eM().c(attribute);
    }

    public double b(Holder<AttributeBase> attribute) {
        return this.c(attribute.a());
    }

    public double c(AttributeBase attribute) {
        return this.eM().d(attribute);
    }

    public AttributeMapBase eM() {
        return this.bP;
    }

    public EnumMonsterType eN() {
        return EnumMonsterType.a;
    }

    public ItemStack eO() {
        return this.c(EnumItemSlot.a);
    }

    public ItemStack eP() {
        return this.c(EnumItemSlot.b);
    }

    public boolean b(net.minecraft.world.item.Item item) {
        return this.b((ItemStack itemstack) -> itemstack.a(item));
    }

    public boolean b(Predicate<ItemStack> predicate) {
        return predicate.test(this.eO()) || predicate.test(this.eP());
    }

    public ItemStack b(EnumHand hand) {
        if (hand == EnumHand.a) {
            return this.c(EnumItemSlot.a);
        }
        if (hand == EnumHand.b) {
            return this.c(EnumItemSlot.b);
        }
        throw new IllegalArgumentException("Invalid hand " + hand);
    }

    public void a(EnumHand hand, ItemStack stack) {
        if (hand == EnumHand.a) {
            this.a(EnumItemSlot.a, stack);
        } else {
            if (hand != EnumHand.b) {
                throw new IllegalArgumentException("Invalid hand " + hand);
            }
            this.a(EnumItemSlot.b, stack);
        }
    }

    public boolean b(EnumItemSlot slot) {
        return !this.c(slot).b();
    }

    @Override
    public abstract Iterable<ItemStack> bJ();

    public abstract ItemStack c(EnumItemSlot var1);

    public void setItemSlot(EnumItemSlot enumitemslot, ItemStack itemstack, boolean silent) {
        this.a(enumitemslot, itemstack);
    }

    @Override
    public abstract void a(EnumItemSlot var1, ItemStack var2);

    protected void e(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.v();
        if (nbttagcompound != null) {
            stack.d().b(nbttagcompound);
        }
    }

    public float eQ() {
        Iterable<ItemStack> iterable = this.bJ();
        int i2 = 0;
        int j2 = 0;
        for (ItemStack itemstack : iterable) {
            if (!itemstack.b()) {
                ++j2;
            }
            ++i2;
        }
        return i2 > 0 ? (float)j2 / (float)i2 : 0.0f;
    }

    @Override
    public void g(boolean sprinting) {
        super.g(sprinting);
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
        if (attributemodifiable.a(c) != null) {
            attributemodifiable.d(bB);
        }
        if (sprinting) {
            attributemodifiable.b(bB);
        }
    }

    public float eR() {
        return 1.0f;
    }

    public float eS() {
        return this.h_() ? (this.af.i() - this.af.i()) * 0.2f + 1.5f : (this.af.i() - this.af.i()) * 0.2f + 1.0f;
    }

    protected boolean eT() {
        return this.es();
    }

    @Override
    public void g(Entity entity) {
        if (!this.fy()) {
            super.g(entity);
        }
    }

    private void a(Entity vehicle) {
        Vec3D vec3d;
        if (this.dD()) {
            vec3d = this.dg();
        } else if (!vehicle.dD() && !this.dI().a_(vehicle.di()).a(TagsBlock.aH)) {
            vec3d = vehicle.b(this);
        } else {
            double d0 = Math.max(this.dp(), vehicle.dp());
            vec3d = new Vec3D(this.dn(), d0, this.dt());
        }
        this.a(vec3d.c, vec3d.d, vec3d.e);
    }

    @Override
    public boolean cz() {
        return this.cy();
    }

    protected float eU() {
        return 0.42f * this.aG() + this.eV();
    }

    public float eV() {
        return this.a(MobEffects.h) ? 0.1f * ((float)this.b(MobEffects.h).e() + 1.0f) : 0.0f;
    }

    protected void eW() {
        Vec3D vec3d = this.dl();
        long time = System.nanoTime();
        boolean canCrit = true;
        if (this instanceof EntityHuman) {
            canCrit = false;
            if (time - this.lastJumpTime > 250000000L) {
                this.lastJumpTime = time;
                canCrit = true;
            }
        }
        this.o(vec3d.c, this.eU(), vec3d.e);
        if (this.bV()) {
            float f2 = this.dy() * ((float)Math.PI / 180);
            if (canCrit) {
                this.f(this.dl().b(-MathHelper.a(f2) * 0.2f, 0.0, MathHelper.b(f2) * 0.2f));
            }
        }
        this.at = true;
    }

    protected void eX() {
        this.f(this.dl().b(0.0, -0.04f, 0.0));
    }

    protected void c(TagKey<FluidType> fluid) {
        this.f(this.dl().b(0.0, 0.04f, 0.0));
    }

    protected float eY() {
        return 0.8f;
    }

    public boolean a(Fluid state) {
        return false;
    }

    public void h(Vec3D movementInput) {
        if (this.cU()) {
            boolean flag;
            double d0 = 0.08;
            boolean bl = flag = this.dl().d <= 0.0;
            if (flag && this.a(MobEffects.B)) {
                d0 = 0.01;
            }
            Fluid fluid = this.dI().b_(this.di());
            if (this.aV() && this.dW() && !this.a(fluid)) {
                double d1 = this.dp();
                float f2 = this.bV() ? 0.9f : this.eY();
                float f1 = 0.02f;
                float f22 = EnchantmentManager.f(this);
                if (f22 > 3.0f) {
                    f22 = 3.0f;
                }
                if (!this.ay()) {
                    f22 *= 0.5f;
                }
                if (f22 > 0.0f) {
                    f2 += (0.54600006f - f2) * f22 / 3.0f;
                    f1 += (this.fa() - f1) * f22 / 3.0f;
                }
                if (this.a(MobEffects.D)) {
                    f2 = 0.96f;
                }
                this.a(f1, movementInput);
                this.a(EnumMoveType.a, this.dl());
                Vec3D vec3d1 = this.dl();
                if (this.O && this.i_()) {
                    vec3d1 = new Vec3D(vec3d1.c, 0.2, vec3d1.e);
                }
                this.f(vec3d1.d(f2, 0.8f, f2));
                Vec3D vec3d2 = this.a(d0, flag, this.dl());
                this.f(vec3d2);
                if (this.O && this.g(vec3d2.c, vec3d2.d + (double)0.6f - this.dp() + d1, vec3d2.e)) {
                    this.o(vec3d2.c, 0.3f, vec3d2.e);
                }
            } else if (this.bi() && this.dW() && !this.a(fluid)) {
                Vec3D vec3d3;
                double d1 = this.dp();
                this.a(0.02f, movementInput);
                this.a(EnumMoveType.a, this.dl());
                if (this.b(TagsFluid.b) <= this.dc()) {
                    this.f(this.dl().d(0.5, 0.8f, 0.5));
                    vec3d3 = this.a(d0, flag, this.dl());
                    this.f(vec3d3);
                } else {
                    this.f(this.dl().a(0.5));
                }
                if (!this.aR()) {
                    this.f(this.dl().b(0.0, -d0 / 4.0, 0.0));
                }
                vec3d3 = this.dl();
                if (this.O && this.g(vec3d3.c, vec3d3.d + (double)0.6f - this.dp() + d1, vec3d3.e)) {
                    this.o(vec3d3.c, 0.3f, vec3d3.e);
                }
            } else if (this.fr()) {
                double d7;
                float f3;
                double d6;
                this.ck();
                Vec3D vec3d4 = this.dl();
                Vec3D vec3d5 = this.bD();
                float f4 = this.dA() * ((float)Math.PI / 180);
                double d2 = Math.sqrt(vec3d5.c * vec3d5.c + vec3d5.e * vec3d5.e);
                double d3 = vec3d4.h();
                double d4 = vec3d5.f();
                double d5 = Math.cos(f4);
                d5 = d5 * d5 * Math.min(1.0, d4 / 0.4);
                vec3d4 = this.dl().b(0.0, d0 * (-1.0 + d5 * 0.75), 0.0);
                if (vec3d4.d < 0.0 && d2 > 0.0) {
                    d6 = vec3d4.d * -0.1 * d5;
                    vec3d4 = vec3d4.b(vec3d5.c * d6 / d2, d6, vec3d5.e * d6 / d2);
                }
                if (f4 < 0.0f && d2 > 0.0) {
                    d6 = d3 * (double)(-MathHelper.a(f4)) * 0.04;
                    vec3d4 = vec3d4.b(-vec3d5.c * d6 / d2, d6 * 3.2, -vec3d5.e * d6 / d2);
                }
                if (d2 > 0.0) {
                    vec3d4 = vec3d4.b((vec3d5.c / d2 * d3 - vec3d4.c) * 0.1, 0.0, (vec3d5.e / d2 * d3 - vec3d4.e) * 0.1);
                }
                this.f(vec3d4.d(0.99f, 0.98f, 0.99f));
                this.a(EnumMoveType.a, this.dl());
                if (this.O && !this.dI().B && (f3 = (float)((d7 = d3 - (d6 = this.dl().h())) * 10.0 - 3.0)) > 0.0f) {
                    this.a(this.d((int)f3), 1.0f, 1.0f);
                    this.a(this.dJ().l(), f3);
                }
                if (this.ay() && !this.dI().B && this.i(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                    this.b(7, false);
                }
            } else {
                BlockPosition blockposition = this.aE();
                float f4 = this.dI().a_(blockposition).b().h();
                float f5 = this.ay() ? f4 * 0.91f : 0.91f;
                Vec3D vec3d6 = this.a(movementInput, f4);
                double d8 = vec3d6.d;
                if (this.a(MobEffects.y)) {
                    d8 += (0.05 * (double)(this.b(MobEffects.y).e() + 1) - vec3d6.d) * 0.2;
                } else if (this.dI().B && !this.dI().A(blockposition)) {
                    d8 = this.dp() > (double)this.dI().C_() ? -0.1 : 0.0;
                } else if (!this.aR()) {
                    d8 -= d0;
                }
                if (this.ei()) {
                    this.o(vec3d6.c, d8, vec3d6.e);
                } else {
                    this.o(vec3d6.c * (double)f5, d8 * (double)0.98f, vec3d6.e * (double)f5);
                }
            }
        }
        this.q(this instanceof EntityBird);
    }

    private void c(EntityHuman controllingPlayer, Vec3D movementInput) {
        Vec3D vec3d1 = this.b(controllingPlayer, movementInput);
        this.a(controllingPlayer, vec3d1);
        if (this.cU()) {
            this.w(this.e(controllingPlayer));
            this.h(vec3d1);
        } else {
            this.q(false);
            this.f(Vec3D.b);
            this.az();
        }
    }

    protected void a(EntityHuman controllingPlayer, Vec3D movementInput) {
    }

    protected Vec3D b(EntityHuman controllingPlayer, Vec3D movementInput) {
        return movementInput;
    }

    protected float e(EntityHuman controllingPlayer) {
        return this.fa();
    }

    public void q(boolean flutter) {
        float f2 = (float)MathHelper.f(this.dn() - this.J, flutter ? this.dp() - this.K : 0.0, this.dt() - this.L);
        this.v(f2);
    }

    protected void v(float posDelta) {
        float f1 = Math.min(posDelta * 4.0f, 1.0f);
        this.aR.a(f1, 0.4f);
    }

    public Vec3D a(Vec3D movementInput, float slipperiness) {
        this.a(this.z(slipperiness), movementInput);
        this.f(this.j(this.dl()));
        this.a(EnumMoveType.a, this.dl());
        Vec3D vec3d1 = this.dl();
        if ((this.O || this.bk) && (this.i_() || this.dj().a(Blocks.qC) && PowderSnowBlock.a(this))) {
            vec3d1 = new Vec3D(vec3d1.c, 0.2, vec3d1.e);
        }
        return vec3d1;
    }

    public Vec3D a(double gravity, boolean falling, Vec3D motion) {
        if (!this.aR() && !this.bV()) {
            double d1 = falling && Math.abs(motion.d - 0.005) >= 0.003 && Math.abs(motion.d - gravity / 16.0) < 0.003 ? -0.003 : motion.d - gravity / 16.0;
            return new Vec3D(motion.c, d1, motion.e);
        }
        return motion;
    }

    private Vec3D j(Vec3D motion) {
        if (this.i_()) {
            this.n();
            float f2 = 0.15f;
            double d0 = MathHelper.a(motion.c, (double)-0.15f, (double)0.15f);
            double d1 = MathHelper.a(motion.e, (double)-0.15f, (double)0.15f);
            double d2 = Math.max(motion.d, (double)-0.15f);
            if (d2 < 0.0 && !this.dj().a(Blocks.nS) && this.fq() && this instanceof EntityHuman) {
                d2 = 0.0;
            }
            motion = new Vec3D(d0, d2, d1);
        }
        return motion;
    }

    private float z(float slipperiness) {
        return this.ay() ? this.fa() * (0.21600002f / (slipperiness * slipperiness * slipperiness)) : this.eZ();
    }

    protected float eZ() {
        return this.cL() instanceof EntityHuman ? this.fa() * 0.1f : 0.02f;
    }

    public float fa() {
        return this.ca;
    }

    public void w(float movementSpeed) {
        this.ca = movementSpeed;
    }

    public boolean z(Entity target) {
        this.x(target);
        return false;
    }

    @Override
    public void l() {
        super.l();
        this.D();
        this.G();
        if (!this.dI().B) {
            int j2;
            int i2 = this.eJ();
            if (i2 > 0) {
                if (this.aJ <= 0) {
                    this.aJ = 20 * (30 - i2);
                }
                --this.aJ;
                if (this.aJ <= 0) {
                    this.p(i2 - 1);
                }
            }
            if ((j2 = this.eK()) > 0) {
                if (this.aK <= 0) {
                    this.aK = 20 * (30 - j2);
                }
                --this.aK;
                if (this.aK <= 0) {
                    this.q(j2 - 1);
                }
            }
            this.z();
            if (this.ag % 20 == 0) {
                this.eG().c();
            }
            if (this.fy() && !this.I()) {
                this.fz();
            }
        }
        if (!this.dD()) {
            this.b_();
        }
        double d0 = this.dn() - this.J;
        double d1 = this.dt() - this.L;
        float f2 = (float)(d0 * d0 + d1 * d1);
        float f1 = this.aV;
        float f22 = 0.0f;
        this.bd = this.be;
        float f3 = 0.0f;
        if (f2 > 0.0025000002f) {
            f3 = 1.0f;
            f22 = (float)Math.sqrt(f2) * 3.0f;
            float f4 = (float)MathHelper.d(d1, d0) * 57.295776f - 90.0f;
            float f5 = MathHelper.e(MathHelper.g(this.dy()) - f4);
            f1 = 95.0f < f5 && f5 < 265.0f ? f4 - 180.0f : f4;
        }
        if (this.aP > 0.0f) {
            f1 = this.dy();
        }
        if (!this.ay()) {
            f3 = 0.0f;
        }
        this.be += (f3 - this.be) * 0.3f;
        this.dI().ad().a("headTurn");
        f22 = this.e(f1, f22);
        this.dI().ad().c();
        this.dI().ad().a("rangeChecks");
        this.M += (float)Math.round((this.dy() - this.M) / 360.0f) * 360.0f;
        this.aW += (float)Math.round((this.aV - this.aW) / 360.0f) * 360.0f;
        this.N += (float)Math.round((this.dA() - this.N) / 360.0f) * 360.0f;
        this.aY += (float)Math.round((this.aX - this.aY) / 360.0f) * 360.0f;
        this.dI().ad().c();
        this.bf += f22;
        this.by = this.fr() ? ++this.by : 0;
        if (this.fy()) {
            this.b_(0.0f);
        }
    }

    public void z() {
        Map<EnumItemSlot, ItemStack> map = this.A();
        if (map != null) {
            this.a(map);
            if (!map.isEmpty()) {
                this.b(map);
            }
        }
    }

    @Nullable
    private Map<EnumItemSlot, ItemStack> A() {
        EnumMap map = null;
        block4: for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
            ItemStack itemstack;
            switch (enumitemslot.a()) {
                case a: {
                    itemstack = this.f(enumitemslot);
                    break;
                }
                case b: {
                    itemstack = this.e(enumitemslot);
                    break;
                }
                default: {
                    continue block4;
                }
            }
            ItemStack itemstack1 = this.c(enumitemslot);
            if (!this.a(itemstack, itemstack1)) continue;
            if (this instanceof EntityPlayer && enumitemslot.a() == EnumItemSlot.Function.b) {
                org.bukkit.inventory.ItemStack oldItem = CraftItemStack.asBukkitCopy(itemstack);
                org.bukkit.inventory.ItemStack newItem = CraftItemStack.asBukkitCopy(itemstack1);
                new PlayerArmorChangeEvent((Player)this.getBukkitEntity(), PlayerArmorChangeEvent.SlotType.valueOf((String)enumitemslot.name()), oldItem, newItem).callEvent();
            }
            if (map == null) {
                map = Maps.newEnumMap(EnumItemSlot.class);
            }
            map.put(enumitemslot, itemstack1);
            if (!itemstack.b()) {
                this.eM().a(itemstack.a(enumitemslot));
            }
            if (itemstack1.b()) continue;
            this.eM().b(itemstack1.a(enumitemslot));
        }
        return map;
    }

    public boolean a(ItemStack stack, ItemStack stack2) {
        return !ItemStack.a(stack2, stack);
    }

    private void a(Map<EnumItemSlot, ItemStack> equipmentChanges) {
        ItemStack itemstack = equipmentChanges.get((Object)EnumItemSlot.a);
        ItemStack itemstack1 = equipmentChanges.get((Object)EnumItemSlot.b);
        if (itemstack != null && itemstack1 != null && ItemStack.a(itemstack, this.f(EnumItemSlot.b)) && ItemStack.a(itemstack1, this.f(EnumItemSlot.a))) {
            ((WorldServer)this.dI()).k().b(this, new PacketPlayOutEntityStatus(this, 55));
            equipmentChanges.remove((Object)EnumItemSlot.a);
            equipmentChanges.remove((Object)EnumItemSlot.b);
            this.c(EnumItemSlot.a, itemstack.p());
            this.c(EnumItemSlot.b, itemstack1.p());
        }
    }

    private void b(Map<EnumItemSlot, ItemStack> equipmentChanges) {
        ArrayList list = Lists.newArrayListWithCapacity((int)equipmentChanges.size());
        equipmentChanges.forEach((enumitemslot, itemstack) -> {
            ItemStack toSend;
            ItemStack itemstack1 = itemstack.p();
            list.add(Pair.of((Object)enumitemslot, (Object)this.stripMeta(toSend, (toSend = EntityLiving.sanitizeItemStack(itemstack1, true)) == itemstack1)));
            switch (enumitemslot.a()) {
                case a: {
                    this.c((EnumItemSlot)((Object)enumitemslot), itemstack1);
                    break;
                }
                case b: {
                    this.b((EnumItemSlot)((Object)enumitemslot), itemstack1);
                }
            }
        });
        ((WorldServer)this.dI()).k().b(this, new PacketPlayOutEntityEquipment(this.af(), list));
    }

    public ItemStack stripMeta(ItemStack itemStack, boolean copyItemStack) {
        ItemStack copy;
        if (itemStack.b() || !itemStack.u() && itemStack.L() < 2) {
            return itemStack;
        }
        ItemStack itemStack2 = copy = copyItemStack ? itemStack.p() : itemStack;
        if (this.dI().paperConfig().anticheat.obfuscation.items.hideDurability && (!copy.a(Items.nh) || copy.k() < copy.l() - 1)) {
            copy.b(0);
        }
        NBTTagCompound tag = copy.v();
        if (this.dI().paperConfig().anticheat.obfuscation.items.hideItemmeta) {
            copy.f(copy.L() > 1 ? 2 : 1);
            if (tag != null) {
                NBTTagList enchantmentsTag;
                NBTBase nBTBase = tag.c("display");
                if (nBTBase instanceof NBTTagCompound) {
                    NBTTagCompound displayTag = (NBTTagCompound)nBTBase;
                    displayTag.r("Lore");
                    displayTag.r("Name");
                }
                if ((nBTBase = tag.c("Enchantments")) instanceof NBTTagList && !(enchantmentsTag = (NBTTagList)nBTBase).isEmpty()) {
                    NBTTagList enchantments = new NBTTagList();
                    NBTTagCompound fakeEnchantment = new NBTTagCompound();
                    if (EnchantmentManager.a(Enchantments.l, itemStack) > 0) {
                        fakeEnchantment.a("id", Enchantment.SOUL_SPEED.getKey().asString());
                        fakeEnchantment.a("lvl", 1);
                    }
                    enchantments.add(fakeEnchantment);
                    tag.a("Enchantments", enchantments);
                }
                tag.r("AttributeModifiers");
                tag.r("author");
                tag.r("filtered_title");
                tag.r("pages");
                tag.r("filtered_pages");
                tag.r("title");
                tag.r("generation");
            }
        }
        if (this.dI().paperConfig().anticheat.obfuscation.items.hideItemmetaWithVisualEffects && tag != null) {
            tag.r("LodestonePos");
            if (tag.e("LodestoneDimension")) {
                tag.a("LodestoneDimension", "paper:paper");
            }
        }
        return copy;
    }

    public static ItemStack sanitizeItemStack(ItemStack itemStack, boolean copyItemStack) {
        NBTTagList oldItems;
        NBTBase nBTBase;
        if (itemStack.b() || !itemStack.u()) {
            return itemStack;
        }
        ItemStack copy = copyItemStack ? itemStack.p() : itemStack;
        NBTTagCompound tag = copy.v();
        if (copy.a(Items.qg) && (nBTBase = tag.c("Items")) instanceof NBTTagList && !(oldItems = (NBTTagList)nBTBase).isEmpty()) {
            BundleMeta bundleMeta = (BundleMeta)copy.asBukkitMirror().getItemMeta();
            int sizeUsed = 0;
            for (org.bukkit.inventory.ItemStack item : bundleMeta.getItems()) {
                int scale = 64 / item.getMaxStackSize();
                sizeUsed += scale * item.getAmount();
            }
            NBTTagList items = new NBTTagList();
            items.add(new ItemStack(Items.qa, sizeUsed).b(new NBTTagCompound()));
            tag.a("Items", items);
        }
        if ((nBTBase = tag.c("BlockEntityTag")) instanceof NBTTagCompound) {
            NBTTagCompound blockEntityTag = (NBTTagCompound)nBTBase;
            blockEntityTag.r("Items");
        }
        return copy;
    }

    private ItemStack e(EnumItemSlot slot) {
        return this.bT.get(slot.b());
    }

    private void b(EnumItemSlot slot, ItemStack armor) {
        this.bT.set(slot.b(), armor);
    }

    private ItemStack f(EnumItemSlot slot) {
        return this.bS.get(slot.b());
    }

    private void c(EnumItemSlot slot, ItemStack stack) {
        this.bS.set(slot.b(), stack);
    }

    protected float e(float bodyRotation, float headRotation) {
        boolean flag;
        float f2 = MathHelper.g(bodyRotation - this.aV);
        this.aV += f2 * 0.3f;
        float f3 = MathHelper.g(this.dy() - this.aV);
        if (Math.abs(f3) > 50.0f) {
            this.aV += f3 - (float)(MathHelper.j((double)f3) * 50);
        }
        boolean bl = flag = f3 < -90.0f || f3 >= 90.0f;
        if (flag) {
            headRotation *= -1.0f;
        }
        return headRotation;
    }

    /*
     * Unable to fully structure code
     */
    public void b_() {
        if (this.cb > 0) {
            --this.cb;
        }
        if (this.cU()) {
            this.bo = 0;
            this.f(this.dn(), this.dp(), this.dt());
        }
        if (this.bo > 0) {
            d0 = this.dn() + (this.bp - this.dn()) / (double)this.bo;
            d1 = this.dp() + (this.bq - this.dp()) / (double)this.bo;
            d2 = this.dt() + (this.br - this.dt()) / (double)this.bo;
            d3 = MathHelper.d(this.bs - (double)this.dy());
            this.a_(this.dy() + (float)d3 / (float)this.bo);
            this.b_(this.dA() + (float)(this.bt - (double)this.dA()) / (float)this.bo);
            --this.bo;
            this.e(d0, d1, d2);
            this.a(this.dy(), this.dA());
        } else if (!this.cV()) {
            this.f(this.dl().a(0.98));
        }
        if (this.bv > 0) {
            this.aX += (float)MathHelper.d(this.bu - (double)this.aX) / (float)this.bv;
            --this.bv;
        }
        vec3d = this.dl();
        d4 = vec3d.c;
        d5 = vec3d.d;
        d6 = vec3d.e;
        if (Math.abs(vec3d.c) < 0.003) {
            d4 = 0.0;
        }
        if (Math.abs(vec3d.d) < 0.003) {
            d5 = 0.0;
        }
        if (Math.abs(vec3d.e) < 0.003) {
            d6 = 0.0;
        }
        this.o(d4, d5, d6);
        this.dI().ad().a("ai");
        if (this.eT()) {
            this.bk = false;
            this.bl = 0.0f;
            this.bn = 0.0f;
        } else if (this.cV()) {
            this.dI().ad().a("newAi");
            this.fc();
            this.dI().ad().c();
        }
        this.dI().ad().c();
        this.dI().ad().a("jump");
        if (this.bk && this.dW()) {
            d7 = this.bi() != false ? this.b(TagsFluid.b) : this.b(TagsFluid.a);
            flag = this.aV() != false && d7 > 0.0;
            d8 = this.dc();
            if (flag && (!this.ay() || d7 > d8)) {
                this.c(TagsFluid.a);
            } else if (this.bi() && (!this.ay() || d7 > d8)) {
                this.c(TagsFluid.b);
            } else if ((this.ay() || flag && d7 <= d8) && this.cb == 0) {
                if (new EntityJumpEvent((LivingEntity)this.getBukkitLivingEntity()).callEvent()) {
                    this.eW();
                    this.cb = 10;
                } else {
                    this.r(false);
                }
            }
        } else {
            this.cb = 0;
        }
        this.dI().ad().c();
        this.dI().ad().a("travel");
        this.bl *= 0.98f;
        this.bn *= 0.98f;
        this.C();
        axisalignedbb = this.cE();
        vec3d1 = new Vec3D(this.bl, this.bm, this.bn);
        if (this.a(MobEffects.B) || this.a(MobEffects.y)) {
            this.n();
        }
        if (!((entityliving = this.cL()) instanceof EntityHuman)) ** GOTO lbl-1000
        entityhuman = (EntityHuman)entityliving;
        if (this.bs()) {
            this.c(entityhuman, vec3d1);
        } else lbl-1000:
        // 2 sources

        {
            this.h(vec3d1);
        }
        this.dI().ad().c();
        this.dI().ad().a("freezing");
        if (!(this.dI().B || this.es() || this.freezeLocked)) {
            i = this.cg();
            if (this.az && this.dw()) {
                this.k(Math.min(this.cj(), i + 1));
            } else {
                this.k(Math.max(0, i - 2));
            }
        }
        this.dT();
        this.dU();
        if (!this.dI().B && this.ag % 40 == 0 && this.ci() && this.dw()) {
            this.a(this.dJ().t(), 1.0f);
        }
        this.dI().ad().c();
        this.dI().ad().a("push");
        if (this.bz > 0) {
            --this.bz;
            this.a(axisalignedbb, this.cE());
        }
        this.fd();
        this.dI().ad().c();
        if (((WorldServer)this.dI()).hasEntityMoveEvent && !(this instanceof EntityHuman) && (this.J != this.dn() || this.K != this.dp() || this.L != this.dt() || this.M != this.dy() || this.N != this.dA())) {
            from = new Location((World)this.dI().getWorld(), this.J, this.K, this.L, this.M, this.N);
            to = new Location((World)this.dI().getWorld(), this.dn(), this.dp(), this.dt(), this.dy(), this.dA());
            event = new EntityMoveEvent((LivingEntity)this.getBukkitLivingEntity(), from, to.clone());
            if (!event.callEvent()) {
                this.a(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch());
            } else if (!to.equals((Object)event.getTo())) {
                this.a(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ(), event.getTo().getYaw(), event.getTo().getPitch());
            }
        }
        if (!this.dI().B && this.fb() && this.aX()) {
            this.a(this.dJ().h(), 1.0f);
        }
    }

    public boolean fb() {
        return false;
    }

    private void C() {
        boolean flag = this.i(7);
        if (flag && !this.ay() && !this.bM() && !this.a(MobEffects.y)) {
            ItemStack itemstack = this.c(EnumItemSlot.e);
            if (itemstack.a(Items.nh) && ItemElytra.d(itemstack)) {
                flag = true;
                int i2 = this.by + 1;
                if (!this.dI().B && i2 % 10 == 0) {
                    int j2 = i2 / 10;
                    if (j2 % 2 == 0) {
                        itemstack.a(1, this, (T entityliving) -> entityliving.d(EnumItemSlot.e));
                    }
                    this.a(GameEvent.n);
                }
            } else {
                flag = false;
            }
        } else {
            flag = false;
        }
        if (!this.dI().B && flag != this.i(7) && !CraftEventFactory.callToggleGlideEvent(this, flag).isCancelled()) {
            this.b(7, flag);
        }
    }

    protected void fc() {
    }

    protected void fd() {
        if (this.dI().r_()) {
            this.dI().a(EntityTypeTest.a(EntityHuman.class), this.cE(), IEntitySelector.a(this)).forEach(this::A);
        } else {
            if (!this.bp()) {
                return;
            }
            ScoreboardTeamBase team = this.cd();
            if (team != null && team.l() == ScoreboardTeamBase.EnumTeamPush.b) {
                return;
            }
            int i2 = this.dI().X().c(GameRules.t);
            if (i2 <= 0 && this.dI().paperConfig().collisions.maxEntityCollisions <= 0) {
                return;
            }
            List<Entity> list = this.dI().a((Entity)this, this.cE(), IEntitySelector.pushable(this, this.dI().paperConfig().collisions.fixClimbingBypassingCrammingRule));
            if (!list.isEmpty()) {
                int j2;
                if (i2 > 0 && list.size() > i2 - 1 && this.af.a(4) == 0) {
                    j2 = 0;
                    for (int k2 = 0; k2 < list.size(); ++k2) {
                        if (list.get(k2).bM()) continue;
                        ++j2;
                    }
                    if (j2 > i2 - 1) {
                        this.a(this.dJ().g(), 6.0f);
                    }
                }
                this.numCollisions = Math.max(0, this.numCollisions - this.dI().paperConfig().collisions.maxEntityCollisions);
                for (j2 = 0; j2 < list.size() && this.numCollisions < this.dI().paperConfig().collisions.maxEntityCollisions; ++j2) {
                    Entity entity = list.get(j2);
                    ++entity.numCollisions;
                    ++this.numCollisions;
                    this.A(entity);
                }
            }
        }
    }

    protected void a(AxisAlignedBB a2, AxisAlignedBB b2) {
        AxisAlignedBB axisalignedbb2 = a2.b(b2);
        List<Entity> list = this.dI().a_(this, axisalignedbb2);
        if (!list.isEmpty()) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Entity entity = list.get(i2);
                if (!(entity instanceof EntityLiving)) continue;
                this.g((EntityLiving)entity);
                this.bz = 0;
                this.f(this.dl().a(-0.2));
                break;
            }
        } else if (this.O) {
            this.bz = 0;
        }
        if (!this.dI().B && this.bz <= 0) {
            this.c(4, false);
        }
    }

    protected void A(Entity entity) {
        entity.g(this);
    }

    protected void g(EntityLiving target) {
    }

    public boolean fe() {
        return (this.am.b(u) & 4) != 0;
    }

    @Override
    public void Y() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        Entity entity = this.cW();
        super.stopRiding(suppressCancellation);
        if (entity != null && entity != this.cW() && !this.dI().B && entity.valid) {
            this.a(entity);
        }
    }

    @Override
    public void bv() {
        super.bv();
        this.bd = this.be;
        this.be = 0.0f;
        this.n();
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.bp = x2;
        this.bq = y2;
        this.br = z2;
        this.bs = yaw;
        this.bt = pitch;
        this.bo = interpolationSteps;
    }

    @Override
    public void a(float yaw, int interpolationSteps) {
        this.bu = yaw;
        this.bv = interpolationSteps;
    }

    public void r(boolean jumping) {
        this.bk = jumping;
    }

    public void a(EntityItem item) {
        EntityHuman entity;
        EntityHuman entityHuman = entity = item.j != null ? this.dI().getGlobalPlayerByUUID(item.j) : null;
        if (entity instanceof EntityPlayer) {
            CriterionTriggers.O.a((EntityPlayer)entity, item.j(), this);
        }
    }

    public void a(Entity item, int count) {
        if (!item.dD() && !this.dI().B && (item instanceof EntityItem || item instanceof EntityArrow || item instanceof EntityExperienceOrb)) {
            ((WorldServer)this.dI()).k().b(item, new PacketPlayOutCollect(item.af(), this.af(), count));
        }
    }

    public boolean B(Entity entity) {
        if (entity.dI() != this.dI()) {
            return false;
        }
        Vec3D vec3d = new Vec3D(this.dn(), this.dr(), this.dt());
        Vec3D vec3d1 = new Vec3D(entity.dn(), entity.dr(), entity.dt());
        return vec3d1.g(vec3d) > 16384.0 ? false : this.dI().clipDirect(vec3d, vec3d1, VoxelShapeCollision.a(this)) == MovingObjectPosition.EnumMovingObjectType.a;
    }

    @Override
    public float h(float tickDelta) {
        return tickDelta == 1.0f ? this.aX : MathHelper.i(tickDelta, this.aY, this.aX);
    }

    public float x(float tickDelta) {
        float f1 = this.aP - this.aO;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        return this.aO + f1 * tickDelta;
    }

    @Override
    public boolean bo() {
        return !this.dD() && this.collides;
    }

    @Override
    public boolean bp() {
        return this.isCollidable(this.dI().paperConfig().collisions.fixClimbingBypassingCrammingRule);
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return this.bs() && !this.G_() && (ignoreClimbing || !this.i_()) && this.collides;
    }

    @Override
    public boolean canCollideWithBukkit(Entity entity) {
        return this.bp() && this.collides != this.collidableExemptions.contains(entity.ct());
    }

    @Override
    public float cm() {
        return this.aX;
    }

    @Override
    public void n(float headYaw) {
        this.aX = headYaw;
    }

    @Override
    public void o(float bodyYaw) {
        this.aV = bodyYaw;
    }

    @Override
    protected Vec3D a(EnumDirection.EnumAxis portalAxis, BlockUtil.Rectangle portalRect) {
        return EntityLiving.i(super.a(portalAxis, portalRect));
    }

    public static Vec3D i(Vec3D pos) {
        return new Vec3D(pos.c, pos.d, 0.0);
    }

    public float ff() {
        return this.cc;
    }

    public void y(float amount) {
        if (amount < 0.0f || Float.isNaN(amount)) {
            amount = 0.0f;
        }
        this.cc = amount;
    }

    public void Q_() {
    }

    public void F_() {
    }

    protected void fg() {
        this.bV = true;
    }

    public abstract EnumMainHand fh();

    public boolean fi() {
        return (this.am.b(u) & 1) > 0;
    }

    public EnumHand fj() {
        return (this.am.b(u) & 2) > 0 ? EnumHand.b : EnumHand.a;
    }

    public void resyncUsingItem(EntityPlayer serverPlayer) {
        this.aj().resendPossiblyDesyncedDataValues(List.of(u), serverPlayer);
    }

    private void D() {
        if (this.fi()) {
            if (ItemStack.b(this.b(this.fj()), this.bw)) {
                this.bw = this.b(this.fj());
                this.a(this.bw);
            } else {
                this.fo();
            }
        }
    }

    protected void a(ItemStack stack) {
        boolean shouldLagCompensate;
        stack.b(this.dI(), this, this.fl());
        if (this.E()) {
            this.b(stack, 5);
        }
        boolean bl = shouldLagCompensate = this.bw.d().u() && this.eatStartTime != -1L && System.nanoTime() - this.eatStartTime > (long)((1 + this.totalEatTimeTicks) * 50 * 1000000);
        if (!(--this.bx != 0 && !shouldLagCompensate || this.dI().B || stack.t())) {
            this.bx = 0;
            this.Z_();
        }
    }

    private boolean E() {
        int i2 = this.fl();
        FoodInfo foodinfo = this.bw.d().v();
        boolean flag = foodinfo != null && foodinfo.e();
        return (flag |= i2 <= this.bw.r() - 7) && i2 % 4 == 0;
    }

    private void G() {
        this.ci = this.ch;
        this.ch = this.bX() ? Math.min(1.0f, this.ch + 0.09f) : Math.max(0.0f, this.ch - 0.09f);
    }

    protected void c(int mask, boolean value) {
        byte b0 = this.am.b(u);
        int j2 = value ? b0 | mask : b0 & ~mask;
        this.am.b(u, (byte)j2);
    }

    public void c(EnumHand hand) {
        this.startUsingItem(hand, false);
    }

    public void startUsingItem(EnumHand hand, boolean forceUpdate) {
        ItemStack itemstack = this.b(hand);
        if (!itemstack.b() && !this.fi() || forceUpdate) {
            this.bw = itemstack;
            this.bx = this.totalEatTimeTicks = itemstack.r();
            this.eatStartTime = System.nanoTime();
            if (!this.dI().B) {
                this.c(1, true);
                this.c(2, hand == EnumHand.b);
                this.a(GameEvent.E);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (bN.equals(data)) {
            if (this.dI().B) {
                this.fw().ifPresent(this::a);
            }
        } else if (u.equals(data) && this.dI().B) {
            if (this.fi() && this.bw.b()) {
                this.bw = this.b(this.fj());
                if (!this.bw.b()) {
                    this.bx = this.bw.r();
                }
            } else if (!this.fi() && !this.bw.b()) {
                this.bw = ItemStack.b;
                this.totalEatTimeTicks = 0;
                this.bx = 0;
                this.eatStartTime = -1L;
            }
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor anchorPoint, Vec3D target) {
        super.a(anchorPoint, target);
        this.aY = this.aX;
        this.aW = this.aV = this.aX;
    }

    protected void b(ItemStack stack, int particleCount) {
        if (!stack.b() && this.fi()) {
            if (stack.s() == EnumAnimation.c) {
                this.a(this.c(stack), 0.5f, this.dI().z.i() * 0.1f + 0.9f);
            }
            if (stack.s() == EnumAnimation.b) {
                this.a(stack, particleCount);
                this.a(this.d(stack), 0.5f + 0.5f * (float)this.af.a(2), (this.af.i() - this.af.i()) * 0.2f + 1.0f);
            }
        }
    }

    private void a(ItemStack stack, int count) {
        for (int j2 = 0; j2 < count; ++j2) {
            Vec3D vec3d = new Vec3D(((double)this.af.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.a(-this.dA() * ((float)Math.PI / 180));
            vec3d = vec3d.b(-this.dy() * ((float)Math.PI / 180));
            double d0 = (double)(-this.af.i()) * 0.6 - 0.3;
            Vec3D vec3d1 = new Vec3D(((double)this.af.i() - 0.5) * 0.3, d0, 0.6);
            vec3d1 = vec3d1.a(-this.dA() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.b(-this.dy() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.b(this.dn(), this.dr(), this.dt());
            this.dI().a(new ParticleParamItem(Particles.O, stack), vec3d1.c, vec3d1.d, vec3d1.e, vec3d.c, vec3d.d + 0.05, vec3d.e);
        }
    }

    protected void Z_() {
        if (!this.dI().B || this.fi()) {
            EnumHand enumhand = this.fj();
            if (!this.bw.equals(this.b(enumhand))) {
                this.fn();
            } else if (!this.bw.b() && this.fi()) {
                ItemStack itemstack;
                this.startUsingItem(this.fj(), true);
                this.b(this.bw, 16);
                PlayerItemConsumeEvent event = null;
                if (this instanceof EntityPlayer) {
                    org.bukkit.inventory.ItemStack craftItem = CraftItemStack.asBukkitCopy(this.bw);
                    EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
                    event = new PlayerItemConsumeEvent((Player)this.getBukkitEntity(), craftItem, hand);
                    this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        this.fo();
                        ((EntityPlayer)this).getBukkitEntity().updateInventory();
                        ((EntityPlayer)this).getBukkitEntity().updateScaledHealth();
                        return;
                    }
                    itemstack = craftItem.equals((Object)event.getItem()) ? this.bw.a(this.dI(), this) : CraftItemStack.asNMSCopy(event.getItem()).a(this.dI(), this);
                } else {
                    itemstack = this.bw.a(this.dI(), this);
                }
                ItemStack defaultReplacement = itemstack;
                if (event != null && event.getReplacement() != null) {
                    itemstack = CraftItemStack.asNMSCopy(event.getReplacement());
                }
                if (itemstack != this.bw) {
                    this.a(enumhand, itemstack);
                }
                this.fo();
                if (this instanceof EntityPlayer) {
                    ((EntityPlayer)this).getBukkitEntity().updateInventory();
                }
            }
        }
    }

    public ItemStack fk() {
        return this.bw;
    }

    public int fl() {
        return this.bx;
    }

    public int fm() {
        return this.fi() ? this.bw.r() - this.fl() : 0;
    }

    public void fn() {
        if (!this.bw.b()) {
            if (this instanceof EntityPlayer) {
                new PlayerStopUsingItemEvent((Player)this.getBukkitEntity(), this.bw.asBukkitMirror(), this.fm()).callEvent();
            }
            this.bw.a(this.dI(), this, this.fl());
            if (this.bw.t()) {
                this.D();
            }
        }
        this.fo();
    }

    public void fo() {
        if (!this.dI().B) {
            boolean flag = this.fi();
            this.c(1, false);
            if (flag) {
                this.a(GameEvent.D);
            }
        }
        this.bw = ItemStack.b;
        this.totalEatTimeTicks = 0;
        this.bx = 0;
        this.eatStartTime = -1L;
    }

    public boolean fp() {
        if (this.fi() && !this.bw.b()) {
            net.minecraft.world.item.Item item = this.bw.d();
            return item.c(this.bw) != EnumAnimation.d ? false : item.b(this.bw) - this.bx >= this.getShieldBlockingDelay();
        }
        return false;
    }

    public MovingObjectPosition getRayTrace(int maxDistance, RayTrace.FluidCollisionOption fluidCollisionOption) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3D start = new Vec3D(this.dn(), this.dp() + (double)this.cF(), this.dt());
        Vector dir = this.getBukkitEntity().getLocation().getDirection().multiply(maxDistance);
        Vec3D end = new Vec3D(start.c + dir.getX(), start.d + dir.getY(), start.e + dir.getZ());
        RayTrace raytrace = new RayTrace(start, end, RayTrace.BlockCollisionOption.b, fluidCollisionOption, this);
        return this.dI().a(raytrace);
    }

    @Nullable
    public MovingObjectPositionEntity getTargetEntity(int maxDistance) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3D start = this.j(1.0f);
        Vec3D direction = this.bD();
        Vec3D end = start.b(direction.c * (double)maxDistance, direction.d * (double)maxDistance, direction.e * (double)maxDistance);
        List<Entity> entityList = this.dI().a((Entity)this, this.cE().b(direction.c * (double)maxDistance, direction.d * (double)maxDistance, direction.e * (double)maxDistance).c(1.0, 1.0, 1.0), IEntitySelector.f.and(Entity::bo));
        double distance = 0.0;
        MovingObjectPositionEntity result = null;
        for (Entity entity : entityList) {
            Vec3D rayTrace;
            double distanceTo;
            double inflationAmount = entity.bC();
            AxisAlignedBB aabb = entity.cE().c(inflationAmount, inflationAmount, inflationAmount);
            Optional<Vec3D> rayTraceResult = aabb.b(start, end);
            if (!rayTraceResult.isPresent() || !((distanceTo = start.g(rayTrace = rayTraceResult.get())) < distance) && distance != 0.0) continue;
            result = new MovingObjectPositionEntity(entity, rayTrace);
            distance = distanceTo;
        }
        return result;
    }

    public int getShieldBlockingDelay() {
        return this.shieldBlockingDelay;
    }

    public void setShieldBlockingDelay(int shieldBlockingDelay) {
        this.shieldBlockingDelay = shieldBlockingDelay;
    }

    public boolean fq() {
        return this.bP();
    }

    public boolean fr() {
        return this.i(7);
    }

    @Override
    public boolean bX() {
        return super.bX() || !this.fr() && this.c(EntityPose.b);
    }

    public int fs() {
        return this.by;
    }

    public boolean b(double x2, double y2, double z2, boolean particleEffects) {
        return this.randomTeleport(x2, y2, z2, particleEffects, PlayerTeleportEvent.TeleportCause.UNKNOWN).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<Boolean> randomTeleport(double d0, double d1, double d2, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        double d3 = this.dn();
        double d4 = this.dp();
        double d5 = this.dt();
        double d6 = d1;
        boolean flag1 = false;
        BlockPosition blockposition = BlockPosition.a(d0, d1, d2);
        net.minecraft.world.level.World world = this.dI();
        if (world.A(blockposition)) {
            boolean flag2 = false;
            while (!flag2 && blockposition.v() > world.C_()) {
                BlockPosition blockposition1 = blockposition.d();
                IBlockData iblockdata = world.a_(blockposition1);
                if (iblockdata.d()) {
                    flag2 = true;
                    continue;
                }
                d6 -= 1.0;
                blockposition = blockposition1;
            }
            if (flag2) {
                this.e(d0, d6, d2);
                if (world.g(this) && !world.d(this.cE())) {
                    flag1 = true;
                }
                this.e(d3, d4, d5);
                if (flag1) {
                    if (!(this instanceof EntityPlayer)) {
                        EntityTeleportEvent teleport = new EntityTeleportEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), new Location((World)this.dI().getWorld(), d3, d4, d5), new Location((World)this.dI().getWorld(), d0, d6, d2));
                        this.dI().getCraftServer().getPluginManager().callEvent((Event)teleport);
                        if (teleport.isCancelled()) return Optional.empty();
                        Location to = teleport.getTo();
                        this.b(to.getX(), to.getY(), to.getZ());
                    } else if (((EntityPlayer)this).c.teleport(d0, d6, d2, this.dy(), this.dA(), Collections.emptySet(), cause)) {
                        return Optional.empty();
                    }
                }
            }
        }
        if (!flag1) {
            return Optional.of(false);
        }
        if (flag) {
            world.a((Entity)this, (byte)46);
        }
        if (!(this instanceof EntityCreature)) return Optional.of(true);
        ((EntityCreature)this).J().n();
        return Optional.of(true);
    }

    public boolean ft() {
        return true;
    }

    public boolean fu() {
        return true;
    }

    public void a(BlockPosition songPosition, boolean playing) {
    }

    public boolean f(ItemStack stack) {
        return false;
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return pose == EntityPose.c ? aE : super.a(pose).a(this.dV());
    }

    public ImmutableList<EntityPose> fv() {
        return ImmutableList.of((Object)((Object)EntityPose.a));
    }

    public AxisAlignedBB g(EntityPose pose) {
        EntitySize entitysize = this.a(pose);
        return new AxisAlignedBB(-entitysize.a / 2.0f, 0.0, -entitysize.a / 2.0f, entitysize.a / 2.0f, entitysize.b, entitysize.a / 2.0f);
    }

    @Override
    public boolean cq() {
        return super.cq() && !this.fy();
    }

    public Optional<BlockPosition> fw() {
        return this.am.b(bN);
    }

    public void g(BlockPosition pos) {
        this.am.b(bN, Optional.of(pos));
    }

    public void fx() {
        this.am.b(bN, Optional.empty());
    }

    public boolean fy() {
        return this.fw().isPresent();
    }

    public void b(BlockPosition pos) {
        IBlockData iblockdata;
        if (this.bM()) {
            this.Y();
        }
        if ((iblockdata = this.dI().a_(pos)).b() instanceof BlockBed) {
            this.dI().a(pos, (IBlockData)iblockdata.a(BlockBed.b, true), 3);
        }
        this.b(EntityPose.c);
        this.a(pos);
        this.g(pos);
        this.f(Vec3D.b);
        this.at = true;
    }

    private void a(BlockPosition pos) {
        this.e((double)pos.u() + 0.5, (double)pos.v() + 0.6875, (double)pos.w() + 0.5);
    }

    private boolean I() {
        return this.fw().map(blockposition -> this.dI().a_((BlockPosition)blockposition).b() instanceof BlockBed).orElse(false);
    }

    public void fz() {
        Optional<BlockPosition> optional = this.fw();
        net.minecraft.world.level.World world = this.dI();
        Objects.requireNonNull(world);
        optional.filter(world::A).ifPresent(blockposition -> {
            IBlockData iblockdata = this.dI().a_((BlockPosition)blockposition);
            if (iblockdata.b() instanceof BlockBed) {
                EnumDirection enumdirection = iblockdata.c(BlockFacingHorizontal.aC);
                this.dI().a((BlockPosition)blockposition, (IBlockData)iblockdata.a(BlockBed.b, false), 3);
                Vec3D vec3d = BlockBed.a(this.ae(), (ICollisionAccess)this.dI(), blockposition, enumdirection, this.dy()).orElseGet(() -> {
                    BlockPosition blockposition1 = blockposition.c();
                    return new Vec3D((double)blockposition1.u() + 0.5, (double)blockposition1.v() + 0.1, (double)blockposition1.w() + 0.5);
                });
                Vec3D vec3d1 = Vec3D.c(blockposition).d(vec3d).d();
                float f2 = (float)MathHelper.d(MathHelper.d(vec3d1.e, vec3d1.c) * 57.2957763671875 - 90.0);
                this.e(vec3d.c, vec3d.d, vec3d.e);
                this.a_(f2);
                this.b_(0.0f);
            }
        });
        Vec3D vec3d = this.dg();
        this.b(EntityPose.a);
        this.e(vec3d.c, vec3d.d, vec3d.e);
        this.fx();
    }

    @Nullable
    public EnumDirection fA() {
        BlockPosition blockposition = this.fw().orElse(null);
        return blockposition != null ? BlockBed.a(this.dI(), blockposition) : null;
    }

    @Override
    public boolean bt() {
        return !this.fy() && super.bt();
    }

    @Override
    protected final float a(EntityPose pose, EntitySize dimensions) {
        return pose == EntityPose.c ? 0.2f : this.b(pose, dimensions);
    }

    protected float b(EntityPose pose, EntitySize dimensions) {
        return super.a(pose, dimensions);
    }

    public ItemStack g(ItemStack stack) {
        return ItemStack.b;
    }

    public ItemStack a(net.minecraft.world.level.World world, ItemStack stack) {
        if (stack.M()) {
            world.a((EntityHuman)null, this.dn(), this.dp(), this.dt(), this.d(stack), SoundCategory.g, 1.0f, 1.0f + (world.z.i() - world.z.i()) * 0.4f);
            this.a(stack, world, this);
            if (!(this instanceof EntityHuman) || !((EntityHuman)this).fO().d) {
                stack.h(1);
            }
            this.a(GameEvent.m);
        }
        return stack;
    }

    private void a(ItemStack stack, net.minecraft.world.level.World world, EntityLiving targetEntity) {
        net.minecraft.world.item.Item item = stack.d();
        if (item.u()) {
            List<Pair<MobEffect, Float>> list = item.v().f();
            for (Pair<MobEffect, Float> pair : list) {
                if (world.B || pair.getFirst() == null || !(world.z.i() < ((Float)pair.getSecond()).floatValue())) continue;
                targetEntity.addEffect(new MobEffect((MobEffect)pair.getFirst()), EntityPotionEffectEvent.Cause.FOOD);
            }
        }
    }

    public static byte g(EnumItemSlot slot) {
        switch (slot) {
            case a: {
                return 47;
            }
            case b: {
                return 48;
            }
            case f: {
                return 49;
            }
            case e: {
                return 50;
            }
            case c: {
                return 52;
            }
            case d: {
                return 51;
            }
        }
        return 47;
    }

    public void d(EnumItemSlot slot) {
        this.dI().a((Entity)this, EntityLiving.g(slot));
    }

    public void d(EnumHand hand) {
        this.d(hand == EnumHand.a ? EnumItemSlot.a : EnumItemSlot.b);
    }

    @Override
    public AxisAlignedBB j_() {
        if (this.c(EnumItemSlot.f).a(Items.tw)) {
            float f2 = 0.5f;
            return this.cE().c(0.5, 0.5, 0.5);
        }
        return super.j_();
    }

    public static EnumItemSlot h(ItemStack stack) {
        Equipable equipable = Equipable.c_(stack);
        return equipable != null ? equipable.g() : EnumItemSlot.a;
    }

    private static SlotAccess a(EntityLiving entity, EnumItemSlot slot) {
        return slot != EnumItemSlot.f && slot != EnumItemSlot.a && slot != EnumItemSlot.b ? SlotAccess.a(entity, slot, itemstack -> itemstack.b() || EntityInsentient.h(itemstack) == slot) : SlotAccess.a(entity, slot);
    }

    @Nullable
    private static EnumItemSlot r(int slotId) {
        return slotId == 100 + EnumItemSlot.f.b() ? EnumItemSlot.f : (slotId == 100 + EnumItemSlot.e.b() ? EnumItemSlot.e : (slotId == 100 + EnumItemSlot.d.b() ? EnumItemSlot.d : (slotId == 100 + EnumItemSlot.c.b() ? EnumItemSlot.c : (slotId == 98 ? EnumItemSlot.a : (slotId == 99 ? EnumItemSlot.b : null)))));
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        EnumItemSlot enumitemslot = EntityLiving.r(mappedIndex);
        return enumitemslot != null ? EntityLiving.a(this, enumitemslot) : super.a_(mappedIndex);
    }

    @Override
    public boolean dw() {
        if (this.G_()) {
            return false;
        }
        boolean flag = !this.c(EnumItemSlot.f).a(TagsItem.az) && !this.c(EnumItemSlot.e).a(TagsItem.az) && !this.c(EnumItemSlot.d).a(TagsItem.az) && !this.c(EnumItemSlot.c).a(TagsItem.az);
        return flag && super.dw();
    }

    @Override
    public boolean ca() {
        return !this.dI().r_() && this.a(MobEffects.x) || super.ca();
    }

    @Override
    public float dz() {
        return this.aV;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        double d0 = packet.e();
        double d1 = packet.f();
        double d2 = packet.g();
        float f2 = packet.l();
        float f1 = packet.k();
        this.f(d0, d1, d2);
        this.aV = packet.m();
        this.aX = packet.m();
        this.aW = this.aV;
        this.aY = this.aX;
        this.e(packet.a());
        this.a_(packet.c());
        this.a(d0, d1, d2, f2, f1);
        this.o(packet.h(), packet.i(), packet.j());
    }

    public boolean fB() {
        return this.eO().d() instanceof ItemAxe;
    }

    @Override
    public float dC() {
        float f2 = super.dC();
        return this.cL() instanceof EntityHuman ? Math.max(f2, 1.0f) : f2;
    }

    private static class ProcessableEffect {
        private MobEffectList type;
        private MobEffect effect;
        private final EntityPotionEffectEvent.Cause cause;

        private ProcessableEffect(MobEffect effect, EntityPotionEffectEvent.Cause cause) {
            this.effect = effect;
            this.cause = cause;
        }

        private ProcessableEffect(MobEffectList type, EntityPotionEffectEvent.Cause cause) {
            this.type = type;
            this.cause = cause;
        }
    }

    public record a(SoundEffect a, SoundEffect b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "small;big", "a", "b"}, this, o2);
        }
    }
}

