/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import co.aikar.timings.MinecraftTimings;
import co.aikar.timings.Timing;
import io.papermc.paper.util.ObfHelper;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public abstract class Behavior<E extends EntityLiving>
implements BehaviorControl<E> {
    public static final int a = 60;
    protected final Map<MemoryModuleType<?>, MemoryStatus> b;
    private Status c = Status.a;
    private long d;
    private final int e;
    private final int f;
    private final String configKey;
    private final Timing timing;

    public Behavior(Map<MemoryModuleType<?>, MemoryStatus> requiredMemoryState) {
        this(requiredMemoryState, 60);
    }

    public Behavior(Map<MemoryModuleType<?>, MemoryStatus> requiredMemoryState, int runTime) {
        this(requiredMemoryState, runTime, runTime);
    }

    public Behavior(Map<MemoryModuleType<?>, MemoryStatus> requiredMemoryState, int minRunTime, int maxRunTime) {
        this.e = minRunTime;
        this.f = maxRunTime;
        this.b = requiredMemoryState;
        String key = ObfHelper.INSTANCE.deobfClassName(this.getClass().getName());
        int lastSeparator = key.lastIndexOf(46);
        if (lastSeparator != -1) {
            key = key.substring(lastSeparator + 1);
        }
        this.configKey = key.toLowerCase(Locale.ROOT);
        this.timing = MinecraftTimings.getBehaviorTimings(this.configKey);
    }

    @Override
    public Status a() {
        return this.c;
    }

    @Override
    public final boolean e(WorldServer world, E entity, long time) {
        int tickRate = Objects.requireNonNullElse((Integer)world.paperConfig().tickRates.behavior.get(((Entity)entity).ae(), (Object)this.configKey), -1);
        if (tickRate > -1 && time < this.d + (long)tickRate) {
            return false;
        }
        if (this.a(entity) && this.a(world, entity)) {
            this.c = Status.b;
            int i2 = this.e + world.y_().a(this.f + 1 - this.e);
            this.d = time + (long)i2;
            this.timing.startTiming();
            this.d(world, entity, time);
            this.timing.stopTiming();
            return true;
        }
        return false;
    }

    protected void d(WorldServer world, E entity, long time) {
    }

    @Override
    public final void f(WorldServer world, E entity, long time) {
        this.timing.startTiming();
        if (!this.a(time) && this.a(world, entity, time)) {
            this.c(world, entity, time);
        } else {
            this.g(world, entity, time);
        }
        this.timing.stopTiming();
    }

    protected void c(WorldServer world, E entity, long time) {
    }

    @Override
    public final void g(WorldServer world, E entity, long time) {
        this.c = Status.a;
        this.b(world, entity, time);
    }

    protected void b(WorldServer world, E entity, long time) {
    }

    protected boolean a(WorldServer world, E entity, long time) {
        return false;
    }

    protected boolean a(long time) {
        return time > this.d;
    }

    protected boolean a(WorldServer world, E entity) {
        return true;
    }

    @Override
    public String b() {
        return this.getClass().getSimpleName();
    }

    protected boolean a(E entity) {
        for (Map.Entry<MemoryModuleType<?>, MemoryStatus> entry : this.b.entrySet()) {
            MemoryModuleType<?> memoryModuleType = entry.getKey();
            MemoryStatus memoryStatus = entry.getValue();
            if (((EntityLiving)entity).dK().a(memoryModuleType, memoryStatus)) continue;
            return false;
        }
        return true;
    }

    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status a = new Status();
        public static final /* enum */ Status b = new Status();
        private static final /* synthetic */ Status[] c;

        public static Status[] values() {
            return (Status[])c.clone();
        }

        public static Status valueOf(String name) {
            return Enum.valueOf(Status.class, name);
        }

        private static /* synthetic */ Status[] a() {
            return new Status[]{a, b};
        }

        static {
            c = Status.a();
        }
    }
}

