/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseDonkey;
import net.minecraft.world.entity.animal.horse.EntityHorseMule;
import net.minecraft.world.entity.animal.horse.HorseColor;
import net.minecraft.world.entity.animal.horse.HorseStyle;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemHorseArmor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.SoundEffectType;

public class EntityHorse
extends EntityHorseAbstract
implements VariantHolder<HorseColor> {
    private static final UUID bT = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final DataWatcherObject<Integer> bU = DataWatcher.a(EntityHorse.class, DataWatcherRegistry.b);

    public EntityHorse(EntityTypes<? extends EntityHorse> type, World world) {
        super((EntityTypes<? extends EntityHorseAbstract>)type, world);
    }

    @Override
    @Override
    protected void a(RandomSource random) {
        this.a(GenericAttributes.a).a(EntityHorse.a(random::a));
        this.a(GenericAttributes.d).a(EntityHorse.b(random::j));
        this.a(GenericAttributes.m).a(EntityHorse.a(random::j));
    }

    @Override
    @Override
    protected void a_() {
        super.a_();
        this.am.a(bU, 0);
    }

    @Override
    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Variant", this.gg());
        if (!this.co.a(1).b()) {
            nbt.a("ArmorItem", this.co.a(1).b(new NBTTagCompound()));
        }
    }

    public ItemStack q() {
        return this.c(EnumItemSlot.e);
    }

    private void n(ItemStack stack) {
        this.a(EnumItemSlot.e, stack);
        this.a(EnumItemSlot.e, 0.0f);
    }

    @Override
    @Override
    public void a(NBTTagCompound nbt) {
        ItemStack itemStack;
        super.a(nbt);
        this.w(nbt.h("Variant"));
        if (nbt.b("ArmorItem", 10) && !(itemStack = ItemStack.a(nbt.p("ArmorItem"))).b() && this.l(itemStack)) {
            this.co.a(1, itemStack);
        }
        this.gv();
    }

    private void w(int variant) {
        this.am.b(bU, variant);
    }

    private int gg() {
        return this.am.b(bU);
    }

    public void a(HorseColor color, HorseStyle marking) {
        this.w(color.a() & 0xFF | marking.a() << 8 & 0xFF00);
    }

    @Override
    public HorseColor r() {
        return HorseColor.a(this.gg() & 0xFF);
    }

    @Override
    @Override
    public void a(HorseColor variant) {
        this.w(variant.a() & 0xFF | this.gg() & 0xFFFFFF00);
    }

    public HorseStyle fY() {
        return HorseStyle.a((this.gg() & 0xFF00) >> 8);
    }

    @Override
    @Override
    protected void gv() {
        if (this.dI().B) {
            return;
        }
        super.gv();
        this.o(this.co.a(1));
        this.a(EnumItemSlot.e, 0.0f);
    }

    private void o(ItemStack stack) {
        this.n(stack);
        if (!this.dI().B) {
            int i2;
            this.a(GenericAttributes.i).b(bT);
            if (this.l(stack) && (i2 = ((ItemHorseArmor)stack.d()).i()) != 0) {
                this.a(GenericAttributes.i).b(new AttributeModifier(bT, "Horse armor bonus", (double)i2, AttributeModifier.Operation.a));
            }
        }
    }

    @Override
    @Override
    public void a(IInventory sender) {
        ItemStack itemStack = this.q();
        super.a(sender);
        ItemStack itemStack2 = this.q();
        if (this.ag > 20 && this.l(itemStack2) && itemStack != itemStack2) {
            this.a(SoundEffects.lg, 0.5f, 1.0f);
        }
    }

    @Override
    @Override
    protected void a(SoundEffectType group) {
        super.a(group);
        if (this.af.a(10) == 0) {
            this.a(SoundEffects.lh, group.a() * 0.6f, group.b());
        }
    }

    @Override
    @Override
    protected SoundEffect s() {
        return SoundEffects.le;
    }

    @Override
    @Override
    public SoundEffect g_() {
        return SoundEffects.li;
    }

    @Override
    @Nullable
    @Override
    protected SoundEffect gf() {
        return SoundEffects.lj;
    }

    @Override
    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.ll;
    }

    @Override
    @Override
    protected SoundEffect gx() {
        return SoundEffects.lf;
    }

    @Override
    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean bl;
        boolean bl2 = bl = !this.h_() && this.gn() && player.fD();
        if (this.bN() || bl) {
            return super.b(player, hand);
        }
        ItemStack itemStack = player.b(hand);
        if (!itemStack.b()) {
            if (this.m(itemStack)) {
                return this.c(player, itemStack);
            }
            if (!this.gn()) {
                this.gE();
                return EnumInteractionResult.a(this.dI().B);
            }
        }
        return super.b(player, hand);
    }

    @Override
    @Override
    public boolean a(EntityAnimal other) {
        if (other == this) {
            return false;
        }
        if (other instanceof EntityHorseDonkey || other instanceof EntityHorse) {
            return this.gG() && ((EntityHorseAbstract)other).gG();
        }
        return false;
    }

    @Override
    @Nullable
    @Override
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        if (entity instanceof EntityHorseDonkey) {
            EntityHorseMule mule = EntityTypes.ap.a(world);
            if (mule != null) {
                this.a(entity, mule);
            }
            return mule;
        }
        EntityHorse horse = (EntityHorse)entity;
        EntityHorse horse2 = EntityTypes.Y.a(world);
        if (horse2 != null) {
            HorseStyle markings3;
            HorseColor variant3;
            int i2 = this.af.a(9);
            if (i2 < 4) {
                HorseColor variant = this.r();
            } else if (i2 < 8) {
                HorseColor variant2 = horse.r();
            } else {
                variant3 = SystemUtils.a(HorseColor.values(), this.af);
            }
            int j2 = this.af.a(5);
            if (j2 < 2) {
                HorseStyle markings = this.fY();
            } else if (j2 < 4) {
                HorseStyle markings2 = horse.fY();
            } else {
                markings3 = SystemUtils.a(HorseStyle.values(), this.af);
            }
            horse2.a(variant3, markings3);
            this.a(entity, horse2);
        }
        return horse2;
    }

    @Override
    @Override
    public boolean gH() {
        return true;
    }

    @Override
    @Override
    public boolean l(ItemStack item) {
        return item.d() instanceof ItemHorseArmor;
    }

    @Override
    @Nullable
    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        HorseColor variant2;
        RandomSource randomSource = world.y_();
        if (entityData instanceof a) {
            HorseColor variant = ((a)entityData).a;
        } else {
            variant2 = SystemUtils.a(HorseColor.values(), randomSource);
            entityData = new a(variant2);
        }
        this.a(variant2, SystemUtils.a(HorseStyle.values(), randomSource));
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public /* synthetic */ Object c() {
        return this.r();
    }

    public static class a
    extends EntityAgeable.a {
        public final HorseColor a;

        public a(HorseColor color) {
            super(true);
            this.a = color;
        }
    }
}

