/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import com.mojang.serialization.Codec;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLlamaFollow;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCarpet;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class EntityLlama
extends EntityHorseChestedAbstract
implements VariantHolder<Variant>,
IRangedEntity {
    private static final int bU = 5;
    private static final RecipeItemStack bW = RecipeItemStack.a(Items.oI, Blocks.ij.k());
    private static final DataWatcherObject<Integer> bX = DataWatcher.a(EntityLlama.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bY = DataWatcher.a(EntityLlama.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bZ = DataWatcher.a(EntityLlama.class, DataWatcherRegistry.b);
    boolean ca;
    @Nullable
    private EntityLlama cb;
    @Nullable
    public EntityLlama cc;

    public EntityLlama(EntityTypes<? extends EntityLlama> type, World world) {
        super((EntityTypes<? extends EntityHorseChestedAbstract>)type, world);
    }

    public boolean gh() {
        return false;
    }

    public void setStrengthPublic(int i2) {
        this.w(i2);
    }

    private void w(int strength) {
        this.am.b(bX, Math.max(1, Math.min(5, strength)));
    }

    private void b(RandomSource random) {
        int i2 = random.i() < 0.04f ? 5 : 3;
        this.w(1 + random.a(i2));
    }

    public int gi() {
        return this.am.b(bX);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Variant", this.gk().g);
        nbt.a("Strength", this.gi());
        if (!this.co.a(1).b()) {
            nbt.a("DecorItem", this.co.a(1).b(new NBTTagCompound()));
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.w(nbt.h("Strength"));
        super.a(nbt);
        this.a(Variant.a(nbt.h("Variant")));
        if (nbt.b("DecorItem", 10)) {
            this.co.a(1, ItemStack.a(nbt.p("DecorItem")));
        }
        this.gv();
    }

    @Override
    protected void x() {
        this.bO.a(0, new PathfinderGoalFloat(this));
        this.bO.a(1, new PathfinderGoalTame(this, 1.2));
        this.bO.a(2, new PathfinderGoalLlamaFollow(this, 2.1f));
        this.bO.a(3, new PathfinderGoalArrowAttack(this, 1.25, 40, 20.0f));
        this.bO.a(3, new PathfinderGoalPanic(this, 1.2));
        this.bO.a(4, new PathfinderGoalBreed(this, 1.0));
        this.bO.a(5, new PathfinderGoalTempt(this, 1.25, RecipeItemStack.a(Items.hh), false));
        this.bO.a(6, new PathfinderGoalFollowParent(this, 1.0));
        this.bO.a(7, new PathfinderGoalRandomStrollLand(this, 0.7));
        this.bO.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bO.a(9, new PathfinderGoalRandomLookaround(this));
        this.bP.a(1, new c(this));
        this.bP.a(2, new a(this));
    }

    public static AttributeProvider.Builder gj() {
        return EntityLlama.q().a(GenericAttributes.b, 40.0);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bX, 0);
        this.am.a(bY, -1);
        this.am.a(bZ, 0);
    }

    public Variant gk() {
        return Variant.a(this.am.b(bZ));
    }

    @Override
    public void a(Variant variant) {
        this.am.b(bZ, variant.g);
    }

    @Override
    protected int V_() {
        return this.r() ? 2 + 3 * this.gg() : super.V_();
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction positionUpdater) {
        if (this.u(passenger)) {
            float f2 = MathHelper.b(this.aV * ((float)Math.PI / 180));
            float f1 = MathHelper.a(this.aV * ((float)Math.PI / 180));
            float f22 = 0.3f;
            positionUpdater.accept(passenger, this.dn() + (double)(0.3f * f1), this.dp() + this.bx() + passenger.bw(), this.dt() - (double)(0.3f * f2));
        }
    }

    @Override
    public double bx() {
        return (double)this.de() * 0.6;
    }

    @Override
    @Nullable
    public EntityLiving cL() {
        return null;
    }

    @Override
    public boolean m(ItemStack stack) {
        return bW.a(stack);
    }

    @Override
    protected boolean a(EntityHuman player, ItemStack item) {
        SoundEffect soundeffect;
        int b0 = 0;
        int b1 = 0;
        float f2 = 0.0f;
        boolean flag = false;
        if (item.a(Items.oI)) {
            b0 = 10;
            b1 = 3;
            f2 = 2.0f;
        } else if (item.a(Blocks.ij.k())) {
            b0 = 90;
            b1 = 6;
            f2 = 10.0f;
            if (this.gn() && this.h() == 0 && this.fZ()) {
                flag = true;
                this.g(player);
            }
        }
        if (this.er() < this.eI() && f2 > 0.0f) {
            this.heal(f2, EntityRegainHealthEvent.RegainReason.EATING);
            flag = true;
        }
        if (this.h_() && b0 > 0) {
            this.dI().a(Particles.K, this.d(1.0), this.dq() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
            if (!this.dI().B) {
                this.b_(b0);
            }
            flag = true;
        }
        if (b1 > 0 && (flag || !this.gn()) && this.gt() < this.gz()) {
            flag = true;
            if (!this.dI().B) {
                this.v(b1);
            }
        }
        if (flag && !this.aQ() && (soundeffect = this.gf()) != null) {
            this.dI().a((EntityHuman)null, this.dn(), this.dp(), this.dt(), this.gf(), this.cY(), 1.0f, 1.0f + (this.af.i() - this.af.i()) * 0.2f);
        }
        return flag;
    }

    @Override
    public boolean eT() {
        return this.es() || this.gq();
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        Variant entityllama_variant;
        RandomSource randomsource = world.y_();
        this.b(randomsource);
        if (entityData instanceof b) {
            entityllama_variant = ((b)entityData).a;
        } else {
            entityllama_variant = (Variant)SystemUtils.a((Object[])Variant.values(), randomsource);
            entityData = new b(entityllama_variant);
        }
        this.a(entityllama_variant);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    protected boolean ge() {
        return false;
    }

    @Override
    protected SoundEffect gx() {
        return SoundEffects.mx;
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.mw;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.mB;
    }

    @Override
    public SoundEffect g_() {
        return SoundEffects.mz;
    }

    @Override
    @Nullable
    protected SoundEffect gf() {
        return SoundEffects.mA;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.mD, 0.15f, 1.0f);
    }

    @Override
    protected void fY() {
        this.a(SoundEffects.my, 1.0f, (this.af.i() - this.af.i()) * 0.2f + 1.0f);
    }

    @Override
    public int gg() {
        return this.gi();
    }

    @Override
    public boolean gH() {
        return true;
    }

    @Override
    public boolean gI() {
        return !this.co.a(1).b();
    }

    @Override
    public boolean l(ItemStack item) {
        return item.a(TagsItem.g);
    }

    @Override
    public boolean g() {
        return false;
    }

    @Override
    public void a(IInventory sender) {
        EnumColor enumcolor = this.gl();
        super.a(sender);
        EnumColor enumcolor1 = this.gl();
        if (this.ag > 20 && enumcolor1 != null && enumcolor1 != enumcolor) {
            this.a(SoundEffects.mE, 0.5f, 1.0f);
        }
    }

    @Override
    protected void gv() {
        if (!this.dI().B) {
            super.gv();
            this.a(EntityLlama.n(this.co.a(1)));
        }
    }

    @Override
    private void a(@Nullable EnumColor color) {
        this.am.b(bY, color == null ? -1 : color.a());
    }

    @Nullable
    private static EnumColor n(ItemStack color) {
        Block block = Block.a(color.d());
        return block instanceof BlockCarpet ? ((BlockCarpet)block).a() : null;
    }

    @Nullable
    public EnumColor gl() {
        int i2 = this.am.b(bY);
        return i2 == -1 ? null : EnumColor.a(i2);
    }

    @Override
    public int gz() {
        return 30;
    }

    @Override
    public boolean a(EntityAnimal other) {
        return other != this && other instanceof EntityLlama && this.gG() && ((EntityLlama)other).gG();
    }

    @Nullable
    public EntityLlama b(WorldServer world, EntityAgeable entity) {
        EntityLlama entityllama = this.gm();
        if (entityllama != null) {
            this.a(entity, entityllama);
            EntityLlama entityllama1 = (EntityLlama)entity;
            int i2 = this.af.a(Math.max(this.gi(), entityllama1.gi())) + 1;
            if (this.af.i() < 0.03f) {
                ++i2;
            }
            entityllama.w(i2);
            entityllama.a(this.af.h() ? this.gk() : entityllama1.gk());
        }
        return entityllama;
    }

    @Nullable
    protected EntityLlama gm() {
        return EntityTypes.aj.a(this.dI());
    }

    private void m(EntityLiving target) {
        EntityLlamaSpit entityllamaspit = new EntityLlamaSpit(this.dI(), this);
        double d0 = target.dn() - this.dn();
        double d1 = target.e(0.3333333333333333) - entityllamaspit.dp();
        double d2 = target.dt() - this.dt();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2) * (double)0.2f;
        entityllamaspit.c(d0, d1 + d3, d2, 1.5f, 10.0f);
        if (!this.aQ()) {
            this.dI().a((EntityHuman)null, this.dn(), this.dp(), this.dt(), SoundEffects.mC, this.cY(), 1.0f, 1.0f + (this.af.i() - this.af.i()) * 0.2f);
        }
        this.dI().b(entityllamaspit);
        this.ca = true;
    }

    void D(boolean spit) {
        this.ca = spit;
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        int i2 = this.d(fallDistance, damageMultiplier);
        if (i2 <= 0) {
            return false;
        }
        if (fallDistance >= 6.0f) {
            this.a(damageSource, (float)i2);
            if (this.bN()) {
                for (Entity entity : this.cR()) {
                    entity.a(damageSource, (float)i2);
                }
            }
        }
        this.eE();
        return true;
    }

    public void gK() {
        if (this.cb != null) {
            this.cb.cc = null;
        }
        this.cb = null;
    }

    @Override
    public void a(EntityLlama llama) {
        this.cb = llama;
        this.cb.cc = this;
    }

    public boolean gL() {
        return this.cc != null;
    }

    public boolean gM() {
        return this.cb != null;
    }

    @Nullable
    public EntityLlama gN() {
        return this.cb;
    }

    @Override
    protected double fX() {
        return 2.0;
    }

    @Override
    protected void gA() {
        if (!this.gM() && this.h_()) {
            super.gA();
        }
    }

    @Override
    public boolean gB() {
        return false;
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        this.m(target);
    }

    @Override
    public Vec3D cG() {
        return new Vec3D(0.0, 0.75 * (double)this.cF(), (double)this.dd() * 0.5);
    }

    public static enum Variant implements INamable
    {
        a(0, "creamy"),
        b(1, "white"),
        c(2, "brown"),
        d(3, "gray");

        public static final Codec<Variant> e;
        private static final IntFunction<Variant> f;
        final int g;
        private final String h;

        private Variant(int i2, String s2) {
            this.g = i2;
            this.h = s2;
        }

        public int a() {
            return this.g;
        }

        public static Variant a(int id) {
            return f.apply(id);
        }

        @Override
        public String c() {
            return this.h;
        }

        static {
            e = INamable.a(Variant::values);
            f = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.c);
        }
    }

    private static class c
    extends PathfinderGoalHurtByTarget {
        public c(EntityLlama llama) {
            super(llama, new Class[0]);
        }

        @Override
        public boolean b() {
            if (this.e instanceof EntityLlama) {
                EntityLlama entityllama = (EntityLlama)this.e;
                if (entityllama.ca) {
                    entityllama.D(false);
                    return false;
                }
            }
            return super.b();
        }
    }

    private static class a
    extends PathfinderGoalNearestAttackableTarget<EntityWolf> {
        public a(EntityLlama llama) {
            super(llama, EntityWolf.class, 16, false, true, entityliving -> !((EntityWolf)entityliving).q());
        }

        @Override
        protected double l() {
            return super.l() * 0.25;
        }
    }

    private static class b
    extends EntityAgeable.a {
        public final Variant a;

        b(Variant variant) {
            super(true);
            this.a = variant;
        }
    }
}

