/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vector3f;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class EntityArmorStand
extends EntityLiving {
    public static final int b = 5;
    private static final boolean bK = true;
    private static final Vector3f bL = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f bM = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f bN = new Vector3f(-10.0f, 0.0f, -10.0f);
    private static final Vector3f bO = new Vector3f(-15.0f, 0.0f, 10.0f);
    private static final Vector3f bP = new Vector3f(-1.0f, 0.0f, -1.0f);
    private static final Vector3f bQ = new Vector3f(1.0f, 0.0f, 1.0f);
    private static final EntitySize bR = new EntitySize(0.0f, 0.0f, true);
    private static final EntitySize bS = EntityTypes.d.n().a(0.5f);
    private static final double bT = 0.1;
    private static final double bU = 0.9;
    private static final double bV = 0.4;
    private static final double bW = 1.6;
    public static final int c = 8;
    public static final int d = 16;
    public static final int e = 1;
    public static final int f = 4;
    public static final int g = 8;
    public static final int bB = 16;
    public static final DataWatcherObject<Byte> bC = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Vector3f> bD = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.m);
    public static final DataWatcherObject<Vector3f> bE = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.m);
    public static final DataWatcherObject<Vector3f> bF = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.m);
    public static final DataWatcherObject<Vector3f> bG = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.m);
    public static final DataWatcherObject<Vector3f> bH = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.m);
    public static final DataWatcherObject<Vector3f> bI = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.m);
    private static final Predicate<Entity> bX = entity -> entity instanceof EntityMinecartAbstract && ((EntityMinecartAbstract)entity).t() == EntityMinecartAbstract.EnumMinecartType.a;
    private final NonNullList<net.minecraft.world.item.ItemStack> bY;
    private final NonNullList<net.minecraft.world.item.ItemStack> bZ;
    private boolean ca;
    public long bJ;
    public int cb;
    public Vector3f cc;
    public Vector3f cd;
    public Vector3f ce;
    public Vector3f cf;
    public Vector3f cg;
    public Vector3f ch;
    public boolean canMove = true;
    public boolean canTick = true;
    public boolean canTickSetByAPI = false;
    private boolean noTickPoseDirty = false;
    private boolean noTickEquipmentDirty = false;

    public EntityArmorStand(EntityTypes<? extends EntityArmorStand> type, World world) {
        super((EntityTypes<? extends EntityLiving>)type, world);
        if (world != null) {
            this.canTick = world.paperConfig().entities.armorStands.tick;
        }
        this.bY = NonNullList.a(2, net.minecraft.world.item.ItemStack.b);
        this.bZ = NonNullList.a(4, net.minecraft.world.item.ItemStack.b);
        this.cc = bL;
        this.cd = bM;
        this.ce = bN;
        this.cf = bO;
        this.cg = bP;
        this.ch = bQ;
        this.r(0.0f);
    }

    public EntityArmorStand(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityArmorStand>)EntityTypes.d, world);
        this.e(x2, y2, z2);
    }

    @Override
    public float getBukkitYaw() {
        return this.dy();
    }

    @Override
    public void d_() {
        double d0 = this.dn();
        double d1 = this.dp();
        double d2 = this.dt();
        super.d_();
        this.e(d0, d1, d2);
    }

    private boolean E() {
        return !this.w() && !this.aR();
    }

    @Override
    public boolean cV() {
        return super.cV() && this.E();
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bC, (byte)0);
        this.am.a(bD, bL);
        this.am.a(bE, bM);
        this.am.a(bF, bN);
        this.am.a(bG, bO);
        this.am.a(bH, bP);
        this.am.a(bI, bQ);
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> bI() {
        return this.bY;
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> bJ() {
        return this.bZ;
    }

    @Override
    public net.minecraft.world.item.ItemStack c(EnumItemSlot slot) {
        switch (slot.a()) {
            case a: {
                return this.bY.get(slot.b());
            }
            case b: {
                return this.bZ.get(slot.b());
            }
        }
        return net.minecraft.world.item.ItemStack.b;
    }

    @Override
    public void a(EnumItemSlot slot, net.minecraft.world.item.ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, boolean silent) {
        this.e(itemstack);
        switch (enumitemslot.a()) {
            case a: {
                this.onEquipItem(enumitemslot, this.bY.set(enumitemslot.b(), itemstack), itemstack, silent);
                break;
            }
            case b: {
                this.onEquipItem(enumitemslot, this.bZ.set(enumitemslot.b(), itemstack), itemstack, silent);
            }
        }
        this.noTickEquipmentDirty = true;
    }

    @Override
    public boolean f(net.minecraft.world.item.ItemStack stack) {
        EnumItemSlot enumitemslot = EntityInsentient.h(stack);
        return this.c(enumitemslot).b() && !this.e(enumitemslot);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        NBTTagList nbttaglist = new NBTTagList();
        for (net.minecraft.world.item.ItemStack itemstack : this.bZ) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            if (!itemstack.b()) {
                itemstack.b(nbttagcompound1);
            }
            nbttaglist.add(nbttagcompound1);
        }
        nbt.a("ArmorItems", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (net.minecraft.world.item.ItemStack itemstack1 : this.bY) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            if (!itemstack1.b()) {
                itemstack1.b(nbttagcompound2);
            }
            nbttaglist1.add(nbttagcompound2);
        }
        nbt.a("HandItems", nbttaglist1);
        nbt.a("Invisible", this.cb());
        nbt.a("Small", this.q());
        nbt.a("ShowArms", this.r());
        nbt.a("DisabledSlots", this.cb);
        nbt.a("NoBasePlate", this.s());
        if (this.w()) {
            nbt.a("Marker", this.w());
        }
        nbt.a("Pose", this.G());
        if (this.canTickSetByAPI) {
            nbt.a("Paper.CanTickOverride", this.canTick);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        int i2;
        NBTTagList nbttaglist;
        super.a(nbt);
        if (nbt.b("ArmorItems", 9)) {
            nbttaglist = nbt.c("ArmorItems", 10);
            for (i2 = 0; i2 < this.bZ.size(); ++i2) {
                this.bZ.set(i2, net.minecraft.world.item.ItemStack.a(nbttaglist.a(i2)));
            }
        }
        if (nbt.b("HandItems", 9)) {
            nbttaglist = nbt.c("HandItems", 10);
            for (i2 = 0; i2 < this.bY.size(); ++i2) {
                this.bY.set(i2, net.minecraft.world.item.ItemStack.a(nbttaglist.a(i2)));
            }
        }
        this.j(nbt.q("Invisible"));
        this.t(nbt.q("Small"));
        this.a(nbt.q("ShowArms"));
        this.cb = nbt.h("DisabledSlots");
        this.s(nbt.q("NoBasePlate"));
        this.u(nbt.q("Marker"));
        boolean bl = this.ae = !this.E();
        if (nbt.e("Paper.CanTickOverride")) {
            this.canTick = nbt.q("Paper.CanTickOverride");
            this.canTickSetByAPI = true;
        }
        NBTTagCompound nbttagcompound1 = nbt.p("Pose");
        this.c(nbttagcompound1);
    }

    private void c(NBTTagCompound nbt) {
        NBTTagList nbttaglist = nbt.c("Head", 5);
        this.a(nbttaglist.isEmpty() ? bL : new Vector3f(nbttaglist));
        NBTTagList nbttaglist1 = nbt.c("Body", 5);
        this.b(nbttaglist1.isEmpty() ? bM : new Vector3f(nbttaglist1));
        NBTTagList nbttaglist2 = nbt.c("LeftArm", 5);
        this.c(nbttaglist2.isEmpty() ? bN : new Vector3f(nbttaglist2));
        NBTTagList nbttaglist3 = nbt.c("RightArm", 5);
        this.d(nbttaglist3.isEmpty() ? bO : new Vector3f(nbttaglist3));
        NBTTagList nbttaglist4 = nbt.c("LeftLeg", 5);
        this.e(nbttaglist4.isEmpty() ? bP : new Vector3f(nbttaglist4));
        NBTTagList nbttaglist5 = nbt.c("RightLeg", 5);
        this.f(nbttaglist5.isEmpty() ? bQ : new Vector3f(nbttaglist5));
    }

    private NBTTagCompound G() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (!bL.equals(this.cc)) {
            nbttagcompound.a("Head", this.cc.a());
        }
        if (!bM.equals(this.cd)) {
            nbttagcompound.a("Body", this.cd.a());
        }
        if (!bN.equals(this.ce)) {
            nbttagcompound.a("LeftArm", this.ce.a());
        }
        if (!bO.equals(this.cf)) {
            nbttagcompound.a("RightArm", this.cf.a());
        }
        if (!bP.equals(this.cg)) {
            nbttagcompound.a("LeftLeg", this.cg.a());
        }
        if (!bQ.equals(this.ch)) {
            nbttagcompound.a("RightLeg", this.ch.a());
        }
        return nbttagcompound;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    @Override
    protected void A(Entity entity) {
    }

    @Override
    protected void fd() {
        if (!this.dI().paperConfig().entities.armorStands.doCollisionEntityLookups) {
            return;
        }
        List<Entity> list = this.dI().a((Entity)this, this.cE(), bX);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Entity entity = list.get(i2);
            if (!(this.f(entity) <= 0.2)) continue;
            entity.g(this);
        }
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, Vec3D hitPos, EnumHand hand) {
        net.minecraft.world.item.ItemStack itemstack = player.b(hand);
        if (!this.w() && !itemstack.a(Items.tR)) {
            if (player.G_()) {
                return EnumInteractionResult.a;
            }
            if (player.dI().B) {
                return EnumInteractionResult.b;
            }
            EnumItemSlot enumitemslot = EntityInsentient.h(itemstack);
            if (itemstack.b()) {
                EnumItemSlot enumitemslot2;
                EnumItemSlot enumitemslot1 = this.j(hitPos);
                EnumItemSlot enumItemSlot = enumitemslot2 = this.e(enumitemslot1) ? enumitemslot : enumitemslot1;
                if (this.b(enumitemslot2) && this.a(player, enumitemslot2, itemstack, hand)) {
                    return EnumInteractionResult.a;
                }
            } else {
                if (this.e(enumitemslot)) {
                    return EnumInteractionResult.e;
                }
                if (enumitemslot.a() == EnumItemSlot.Function.a && !this.r()) {
                    return EnumInteractionResult.e;
                }
                if (this.a(player, enumitemslot, itemstack, hand)) {
                    return EnumInteractionResult.a;
                }
            }
            return EnumInteractionResult.d;
        }
        return EnumInteractionResult.d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EnumItemSlot j(Vec3D hitPos) {
        EnumItemSlot enumitemslot = EnumItemSlot.a;
        boolean flag = this.q();
        double d0 = flag ? hitPos.d * 2.0 : hitPos.d;
        EnumItemSlot enumitemslot1 = EnumItemSlot.c;
        if (d0 >= 0.1) {
            double d2 = flag ? 0.8 : 0.45;
            if (d0 < 0.1 + d2 && this.b(enumitemslot1)) {
                return EnumItemSlot.c;
            }
        }
        double d3 = flag ? 0.3 : 0.0;
        if (d0 >= 0.9 + d3) {
            double d4 = flag ? 1.0 : 0.7;
            if (d0 < 0.9 + d4 && this.b(EnumItemSlot.e)) {
                return EnumItemSlot.e;
            }
        }
        if (d0 >= 0.4) {
            double d5 = flag ? 1.0 : 0.8;
            if (d0 < 0.4 + d5 && this.b(EnumItemSlot.d)) {
                return EnumItemSlot.d;
            }
        }
        if (d0 >= 1.6 && this.b(EnumItemSlot.f)) {
            return EnumItemSlot.f;
        }
        if (this.b(EnumItemSlot.a)) return enumitemslot;
        if (!this.b(EnumItemSlot.b)) return enumitemslot;
        return EnumItemSlot.b;
    }

    public boolean e(EnumItemSlot slot) {
        return (this.cb & 1 << slot.c()) != 0 || slot.a() == EnumItemSlot.Function.a && !this.r();
    }

    private boolean a(EntityHuman player, EnumItemSlot slot, net.minecraft.world.item.ItemStack stack, EnumHand hand) {
        net.minecraft.world.item.ItemStack itemstack1 = this.c(slot);
        if (!itemstack1.b() && (this.cb & 1 << slot.c() + 8) != 0) {
            return false;
        }
        if (itemstack1.b() && (this.cb & 1 << slot.c() + 16) != 0) {
            return false;
        }
        CraftItemStack armorStandItem = CraftItemStack.asCraftMirror(itemstack1);
        CraftItemStack playerHeldItem = CraftItemStack.asCraftMirror(stack);
        Player player1 = (Player)player.getBukkitEntity();
        ArmorStand self = (ArmorStand)this.getBukkitEntity();
        EquipmentSlot slot1 = CraftEquipmentSlot.getSlot(slot);
        EquipmentSlot hand1 = CraftEquipmentSlot.getHand(hand);
        PlayerArmorStandManipulateEvent armorStandManipulateEvent = new PlayerArmorStandManipulateEvent(player1, self, (ItemStack)playerHeldItem, (ItemStack)armorStandItem, slot1, hand1);
        this.dI().getCraftServer().getPluginManager().callEvent((Event)armorStandManipulateEvent);
        if (armorStandManipulateEvent.isCancelled()) {
            return true;
        }
        if (player.fO().d && itemstack1.b() && !stack.b()) {
            this.a(slot, stack.c(1));
            return true;
        }
        if (!stack.b() && stack.L() > 1) {
            if (!itemstack1.b()) {
                return false;
            }
            this.a(slot, stack.a(1));
            return true;
        }
        this.a(slot, stack);
        player.a(hand, itemstack1);
        return true;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (!this.dI().B && !this.dD()) {
            if (source.a(DamageTypeTags.d)) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount)) {
                    return false;
                }
                this.ah();
                return false;
            }
            if (!this.b(source) && !this.w()) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, true, this.ca)) {
                    return false;
                }
                if (source.a(DamageTypeTags.l)) {
                    EntityDeathEvent event = this.brokenByAnything(source);
                    if (!event.isCancelled()) {
                        this.kill(false);
                    }
                    return false;
                }
                if (source.a(DamageTypeTags.u)) {
                    if (this.bL()) {
                        this.g(source, 0.15f);
                    } else {
                        this.g(5);
                    }
                    return false;
                }
                if (source.a(DamageTypeTags.v) && this.er() > 0.5f) {
                    this.g(source, 4.0f);
                    return false;
                }
                boolean flag = source.c() instanceof EntityArrow;
                boolean flag1 = flag && ((EntityArrow)source.c()).w() > 0;
                boolean flag2 = "player".equals(source.e());
                if (!flag2 && !flag) {
                    return false;
                }
                Entity entity = source.d();
                if (entity instanceof EntityHuman) {
                    EntityHuman entityhuman = (EntityHuman)entity;
                    if (!entityhuman.fO().e) {
                        return false;
                    }
                }
                if (source.g()) {
                    this.J();
                    this.I();
                    this.ah();
                    return flag1;
                }
                long i2 = this.dI().V();
                if (i2 - this.bJ > 5L && !flag) {
                    this.dI().a((Entity)this, (byte)32);
                    this.a(GameEvent.o, source.d());
                    this.bJ = i2;
                } else {
                    EntityDeathEvent event = this.brokenByPlayer(source);
                    this.I();
                    if (!event.isCancelled()) {
                        this.kill(false);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void b(byte status) {
        if (status == 32) {
            if (this.dI().B) {
                this.dI().a(this.dn(), this.dp(), this.dt(), SoundEffects.an, this.cY(), 0.3f, 1.0f, false);
                this.bJ = this.dI().V();
            }
        } else {
            super.b(status);
        }
    }

    @Override
    public boolean a(double distance) {
        double d1 = this.cE().a() * 4.0;
        if (Double.isNaN(d1) || d1 == 0.0) {
            d1 = 4.0;
        }
        return distance < (d1 *= 64.0) * d1;
    }

    private void I() {
        if (this.dI() instanceof WorldServer) {
            ((WorldServer)this.dI()).a(new ParticleParamBlock(Particles.c, Blocks.n.n()), this.dn(), this.e(0.6666666666666666), this.dt(), 10, (double)(this.dd() / 4.0f), (double)(this.de() / 4.0f), (double)(this.dd() / 4.0f), 0.05);
        }
    }

    private void g(DamageSource damageSource, float amount) {
        float f1 = this.er();
        if ((f1 -= amount) <= 0.5f) {
            EntityDeathEvent event = this.brokenByAnything(damageSource);
            if (!event.isCancelled()) {
                this.kill(false);
            }
        } else {
            this.t(f1);
            this.a(GameEvent.o, damageSource.d());
        }
    }

    private EntityDeathEvent brokenByPlayer(DamageSource damageSource) {
        net.minecraft.world.item.ItemStack itemstack = new net.minecraft.world.item.ItemStack(Items.tL);
        if (this.aa()) {
            itemstack.a(this.ab());
        }
        this.drops.add(CraftItemStack.asBukkitCopy(itemstack));
        return this.brokenByAnything(damageSource);
    }

    private EntityDeathEvent brokenByAnything(DamageSource damageSource) {
        net.minecraft.world.item.ItemStack itemstack;
        int i2;
        this.J();
        for (i2 = 0; i2 < this.bY.size(); ++i2) {
            itemstack = this.bY.get(i2);
            if (itemstack.b()) continue;
            this.drops.add(CraftItemStack.asCraftMirror(itemstack));
            this.bY.set(i2, net.minecraft.world.item.ItemStack.b);
        }
        for (i2 = 0; i2 < this.bZ.size(); ++i2) {
            itemstack = this.bZ.get(i2);
            if (itemstack.b()) continue;
            this.drops.add(CraftItemStack.asCraftMirror(itemstack));
            this.bZ.set(i2, net.minecraft.world.item.ItemStack.b);
        }
        return this.dropAllDeathLoot(damageSource);
    }

    private void J() {
        this.dI().a((EntityHuman)null, this.dn(), this.dp(), this.dt(), SoundEffects.al, this.cY(), 1.0f, 1.0f);
    }

    @Override
    protected float e(float bodyRotation, float headRotation) {
        this.aW = this.M;
        this.aV = this.dy();
        return 0.0f;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * (this.h_() ? 0.5f : 0.9f);
    }

    @Override
    public double bw() {
        return this.w() ? 0.0 : (double)0.1f;
    }

    @Override
    public void h(Vec3D movementInput) {
        if (this.E()) {
            super.h(movementInput);
        }
    }

    @Override
    public void o(float bodyYaw) {
        this.aW = this.M = bodyYaw;
        this.aY = this.aX = bodyYaw;
    }

    @Override
    public void n(float headYaw) {
        this.aW = this.M = headYaw;
        this.aY = this.aX = headYaw;
    }

    @Override
    public void l() {
        if (!this.canTick) {
            if (this.noTickPoseDirty) {
                this.noTickPoseDirty = false;
                this.updatePose();
            }
            if (this.noTickEquipmentDirty) {
                this.noTickEquipmentDirty = false;
                this.z();
            }
            return;
        }
        super.l();
        this.updatePose();
    }

    public void updatePose() {
        Vector3f vector3f5;
        Vector3f vector3f4;
        Vector3f vector3f3;
        Vector3f vector3f2;
        Vector3f vector3f1;
        Vector3f vector3f = this.am.b(bD);
        if (!this.cc.equals(vector3f)) {
            this.a(vector3f);
        }
        if (!this.cd.equals(vector3f1 = this.am.b(bE))) {
            this.b(vector3f1);
        }
        if (!this.ce.equals(vector3f2 = this.am.b(bF))) {
            this.c(vector3f2);
        }
        if (!this.cf.equals(vector3f3 = this.am.b(bG))) {
            this.d(vector3f3);
        }
        if (!this.cg.equals(vector3f4 = this.am.b(bH))) {
            this.e(vector3f4);
        }
        if (!this.ch.equals(vector3f5 = this.am.b(bI))) {
            this.f(vector3f5);
        }
    }

    @Override
    protected void F() {
        this.j(this.ca);
    }

    @Override
    public void j(boolean invisible) {
        this.ca = invisible;
        super.j(invisible);
    }

    @Override
    public boolean h_() {
        return this.q();
    }

    @Override
    public boolean dY() {
        return true;
    }

    @Override
    public void ah() {
        this.kill(true);
    }

    public void kill(boolean callEvent) {
        EntityDeathEvent event;
        if (callEvent && (event = CraftEventFactory.callEntityDeathEvent(this, this.drops)).isCancelled()) {
            return;
        }
        this.a(Entity.RemovalReason.a);
        this.a(GameEvent.p);
    }

    @Override
    public boolean cJ() {
        return this.cb();
    }

    @Override
    public EnumPistonReaction l_() {
        return this.w() ? EnumPistonReaction.d : super.l_();
    }

    @Override
    public boolean c_() {
        return this.w();
    }

    public void t(boolean small) {
        this.am.b(bC, this.a(this.am.b(bC), 1, small));
    }

    public boolean q() {
        return (this.am.b(bC) & 1) != 0;
    }

    public void a(boolean showArms) {
        this.am.b(bC, this.a(this.am.b(bC), 4, showArms));
    }

    public boolean r() {
        return (this.am.b(bC) & 4) != 0;
    }

    public void s(boolean hideBasePlate) {
        this.am.b(bC, this.a(this.am.b(bC), 8, hideBasePlate));
    }

    public boolean s() {
        return (this.am.b(bC) & 8) != 0;
    }

    public void u(boolean marker) {
        this.am.b(bC, this.a(this.am.b(bC), 16, marker));
    }

    public boolean w() {
        return (this.am.b(bC) & 0x10) != 0;
    }

    private byte a(byte value, int bitField, boolean set) {
        value = set ? (byte)(value | bitField) : (byte)(value & ~bitField);
        return value;
    }

    public void a(Vector3f angle) {
        this.cc = angle;
        this.am.b(bD, angle);
        this.noTickPoseDirty = true;
    }

    public void b(Vector3f angle) {
        this.cd = angle;
        this.am.b(bE, angle);
        this.noTickPoseDirty = true;
    }

    public void c(Vector3f angle) {
        this.ce = angle;
        this.am.b(bF, angle);
        this.noTickPoseDirty = true;
    }

    public void d(Vector3f angle) {
        this.cf = angle;
        this.am.b(bG, angle);
        this.noTickPoseDirty = true;
    }

    public void e(Vector3f angle) {
        this.cg = angle;
        this.am.b(bH, angle);
        this.noTickPoseDirty = true;
    }

    public void f(Vector3f angle) {
        this.ch = angle;
        this.am.b(bI, angle);
        this.noTickPoseDirty = true;
    }

    public Vector3f x() {
        return this.cc;
    }

    public Vector3f y() {
        return this.cd;
    }

    public Vector3f z() {
        return this.ce;
    }

    public Vector3f A() {
        return this.cf;
    }

    public Vector3f C() {
        return this.cg;
    }

    public Vector3f D() {
        return this.ch;
    }

    @Override
    public boolean bo() {
        return super.bo() && !this.w();
    }

    @Override
    public boolean r(Entity attacker) {
        return attacker instanceof EntityHuman && !this.dI().a((EntityHuman)attacker, this.di());
    }

    @Override
    public EnumMainHand fh() {
        return EnumMainHand.b;
    }

    @Override
    public EntityLiving.a eC() {
        return new EntityLiving.a(SoundEffects.am, SoundEffects.am);
    }

    @Override
    @Nullable
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.an;
    }

    @Override
    @Nullable
    public SoundEffect g_() {
        return SoundEffects.al;
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
    }

    @Override
    public boolean ft() {
        return false;
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (bC.equals(data)) {
            this.d_();
            this.H = !this.w();
        }
        super.a(data);
    }

    @Override
    public boolean fu() {
        return false;
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return this.v(this.w());
    }

    private EntitySize v(boolean marker) {
        return marker ? bR : (this.h_() ? bS : this.ae().n());
    }

    @Override
    public Vec3D k(float tickDelta) {
        if (this.w()) {
            AxisAlignedBB axisalignedbb = this.v(false).a(this.dg());
            BlockPosition blockposition = this.di();
            int i2 = Integer.MIN_VALUE;
            for (BlockPosition blockposition1 : BlockPosition.a(BlockPosition.a(axisalignedbb.a, axisalignedbb.b, axisalignedbb.c), BlockPosition.a(axisalignedbb.d, axisalignedbb.e, axisalignedbb.f))) {
                int j2 = Math.max(this.dI().a(EnumSkyBlock.b, blockposition1), this.dI().a(EnumSkyBlock.a, blockposition1));
                if (j2 == 15) {
                    return Vec3D.b(blockposition1);
                }
                if (j2 <= i2) continue;
                i2 = j2;
                blockposition = blockposition1.i();
            }
            return Vec3D.b(blockposition);
        }
        return super.k(tickDelta);
    }

    @Override
    public net.minecraft.world.item.ItemStack dv() {
        return new net.minecraft.world.item.ItemStack(Items.tL);
    }

    @Override
    public boolean el() {
        return !this.cb() && !this.w();
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        if (this.canMove) {
            super.a(type, movement);
        }
    }

    @Override
    public boolean dN() {
        return true;
    }
}

