/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.event.entity.WardenAngerChangeEvent;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.warden.SonicBoom;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.AngerManagement;
import net.minecraft.world.entity.monster.warden.WardenAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;

public class Warden
extends EntityMonster
implements VibrationSystem {
    private static final Logger bV = LogUtils.getLogger();
    private static final int bW = 40;
    private static final int bX = 200;
    private static final int bY = 500;
    private static final float bZ = 0.3f;
    private static final float ca = 1.0f;
    private static final float cb = 1.5f;
    private static final int cc = 30;
    private static final DataWatcherObject<Integer> cd = DataWatcher.a(Warden.class, DataWatcherRegistry.b);
    private static final int ce = 200;
    private static final int cf = 260;
    private static final int cg = 20;
    private static final int ch = 120;
    private static final int ci = 20;
    private static final int cj = 35;
    private static final int ck = 10;
    private static final int cl = 20;
    private static final int cm = 100;
    private static final int cn = 20;
    private static final int co = 30;
    private static final float cp = 4.5f;
    private static final float cq = 0.7f;
    private static final int cr = 30;
    private int cs;
    private int ct;
    private int cu;
    private int cv;
    public AnimationState b = new AnimationState();
    public AnimationState c = new AnimationState();
    public AnimationState d = new AnimationState();
    public AnimationState e = new AnimationState();
    public AnimationState bT = new AnimationState();
    public AnimationState bU = new AnimationState();
    private final DynamicGameEventListener<VibrationSystem.b> cw = new DynamicGameEventListener<VibrationSystem.b>(new VibrationSystem.b(this));
    private final VibrationSystem.d cx = new a();
    private VibrationSystem.a cy = new VibrationSystem.a();
    AngerManagement cz = new AngerManagement(this::a, Collections.emptyList());

    public Warden(EntityTypes<? extends EntityMonster> type, World world) {
        super(type, world);
        this.bJ = 5;
        this.J().a(true);
        this.a(PathType.m, 0.0f);
        this.a(PathType.q, 8.0f);
        this.a(PathType.f, 8.0f);
        this.a(PathType.i, 8.0f);
        this.a(PathType.o, 0.0f);
        this.a(PathType.n, 0.0f);
    }

    @Override
    public Packet<PacketListenerPlayOut> S() {
        return new PacketPlayOutSpawnEntity(this, this.c(EntityPose.n) ? 1 : 0);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        if (packet.n() == 1) {
            this.b(EntityPose.n);
        }
    }

    @Override
    public boolean a(IWorldReader world) {
        return super.a(world) && world.a((Entity)this, this.ae().n().a(this.dg()));
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return 0.0f;
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return this.ga() && !damageSource.a(DamageTypeTags.d) ? true : super.b(damageSource);
    }

    boolean ga() {
        return this.c(EntityPose.o) || this.c(EntityPose.n);
    }

    @Override
    protected boolean l(Entity entity) {
        return false;
    }

    @Override
    public boolean fB() {
        return true;
    }

    @Override
    protected float aI() {
        return this.Y + 0.55f;
    }

    public static AttributeProvider.Builder q() {
        return EntityMonster.ge().a(GenericAttributes.a, 500.0).a(GenericAttributes.d, 0.3f).a(GenericAttributes.c, 1.0).a(GenericAttributes.g, 1.5).a(GenericAttributes.f, 30.0);
    }

    @Override
    public boolean aT() {
        return true;
    }

    @Override
    public float eR() {
        return 4.0f;
    }

    @Override
    @Nullable
    protected SoundEffect s() {
        return !this.c(EntityPose.l) && !this.ga() ? this.w().b() : null;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.zx;
    }

    @Override
    public SoundEffect g_() {
        return SoundEffects.zt;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.zH, 10.0f, 1.0f);
    }

    @Override
    public boolean z(Entity target) {
        this.dI().a((Entity)this, (byte)4);
        this.a(SoundEffects.zs, 10.0f, this.eS());
        SonicBoom.a((EntityLiving)this, 40);
        return super.z(target);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(cd, 0);
    }

    public int r() {
        return this.am.b(cd);
    }

    private void gf() {
        this.am.b(cd, this.gi());
    }

    @Override
    public void l() {
        World world = this.dI();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            VibrationSystem.c.a((World)worldserver, this.cy, this.cx);
            if (this.fH() || this.T()) {
                WardenAi.a((EntityLiving)this);
            }
        }
        super.l();
        if (this.dI().r_()) {
            if (this.ag % this.gg() == 0) {
                this.cu = 10;
                if (!this.aQ()) {
                    this.dI().a(this.dn(), this.dp(), this.dt(), SoundEffects.zw, this.cY(), 5.0f, this.eS(), false);
                }
            }
            this.ct = this.cs;
            if (this.cs > 0) {
                --this.cs;
            }
            this.cv = this.cu;
            if (this.cu > 0) {
                --this.cu;
            }
            switch (this.al()) {
                case n: {
                    this.a(this.d);
                    break;
                }
                case o: {
                    this.a(this.e);
                }
            }
        }
    }

    @Override
    protected void W() {
        WorldServer worldserver = (WorldServer)this.dI();
        worldserver.ad().a("wardenBrain");
        this.dK().a(worldserver, this);
        this.dI().ad().c();
        super.W();
        if ((this.ag + this.af()) % 120 == 0) {
            Warden.a(worldserver, this.dg(), this, 20);
        }
        if (this.ag % 20 == 0) {
            this.cz.a(worldserver, this::a);
            this.gf();
        }
        WardenAi.a(this);
    }

    @Override
    public void b(byte status) {
        if (status == 4) {
            this.b.a();
            this.bT.a(this.ag);
        } else if (status == 61) {
            this.cs = 10;
        } else if (status == 62) {
            this.bU.a(this.ag);
        } else {
            super.b(status);
        }
    }

    private int gg() {
        float f2 = (float)this.r() / (float)AngerLevel.c.a();
        return 40 - MathHelper.d(MathHelper.a(f2, 0.0f, 1.0f) * 30.0f);
    }

    public float D(float tickDelta) {
        return MathHelper.i(tickDelta, this.ct, this.cs) / 10.0f;
    }

    public float E(float tickDelta) {
        return MathHelper.i(tickDelta, this.cv, this.cu) / 10.0f;
    }

    private void a(AnimationState animationState) {
        if ((float)animationState.b() < 4500.0f) {
            RandomSource randomsource = this.ec();
            IBlockData iblockdata = this.bf();
            if (iblockdata.l() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    double d0 = this.dn() + (double)MathHelper.b(randomsource, -0.7f, 0.7f);
                    double d1 = this.dp();
                    double d2 = this.dt() + (double)MathHelper.b(randomsource, -0.7f, 0.7f);
                    this.dI().a(new ParticleParamBlock(Particles.c, iblockdata), d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (Entity.ar.equals(data)) {
            switch (this.al()) {
                case n: {
                    this.d.a(this.ag);
                    break;
                }
                case o: {
                    this.e.a(this.ag);
                    break;
                }
                case l: {
                    this.b.a(this.ag);
                    break;
                }
                case m: {
                    this.c.a(this.ag);
                }
            }
        }
        super.a(data);
    }

    @Override
    public boolean cJ() {
        return this.ga();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return WardenAi.a(this, dynamic);
    }

    public BehaviorController<Warden> dK() {
        return super.dK();
    }

    @Override
    protected void V() {
        super.V();
        PacketDebug.a(this);
    }

    @Override
    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> callback) {
        World world = this.dI();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            callback.accept(this.cw, worldserver);
        }
    }

    @Contract(value="null->false")
    public boolean a(@Nullable Entity entity) {
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            if (this.dI() == entity.dI() && IEntitySelector.e.test(entity) && !this.p(entity) && entityliving.ae() != EntityTypes.d && entityliving.ae() != EntityTypes.bi && !entityliving.co() && !entityliving.es() && this.dI().w_().a(entityliving.cE())) {
                boolean flag = true;
                return flag;
            }
        }
        boolean flag = false;
        return flag;
    }

    public static void a(WorldServer world, Vec3D pos, @Nullable Entity entity, int range) {
        MobEffect mobeffect = new MobEffect(MobEffects.G, 260, 0, false, false);
        MobEffectUtil.addEffectToPlayersAround(world, entity, pos, range, mobeffect, 200, EntityPotionEffectEvent.Cause.WARDEN);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        DataResult dataresult = AngerManagement.a(this::a).encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cz);
        Logger logger = bV;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("anger", (NBTBase)nbtbase));
        dataresult = VibrationSystem.a.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cy);
        logger = bV;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("listener", (NBTBase)nbtbase));
    }

    @Override
    public void a(NBTTagCompound nbt) {
        Logger logger;
        DataResult dataresult;
        super.a(nbt);
        if (nbt.e("anger")) {
            dataresult = AngerManagement.a(this::a).parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("anger")));
            logger = bV;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(angermanagement -> {
                this.cz = angermanagement;
            });
            this.gf();
        }
        if (nbt.b("listener", 10)) {
            dataresult = VibrationSystem.a.a.parse(new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, nbt.p("listener")));
            logger = bV;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(vibrationsystem_a -> {
                this.cy = vibrationsystem_a;
            });
        }
    }

    private void gh() {
        if (!this.c(EntityPose.l)) {
            this.a(this.w().c(), 10.0f, this.eS());
        }
    }

    public AngerLevel w() {
        return AngerLevel.a(this.gi());
    }

    private int gi() {
        return this.cz.b(this.j());
    }

    public void b(Entity entity) {
        this.cz.a(entity);
    }

    public void c(@Nullable Entity entity) {
        this.a(entity, 35, true);
    }

    @VisibleForTesting
    public void a(@Nullable Entity entity, int amount, boolean listening) {
        if (!this.fQ() && this.a(entity)) {
            int activeAnger = this.cz.b(entity);
            WardenAngerChangeEvent event = new WardenAngerChangeEvent((org.bukkit.entity.Warden)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), activeAnger, Math.min(150, activeAnger + amount));
            this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            amount = event.getNewAnger() - activeAnger;
            WardenAi.a((EntityLiving)this);
            boolean flag1 = !(this.dK().c(MemoryModuleType.o).orElse(null) instanceof EntityHuman);
            int j2 = this.cz.a(entity, amount);
            if (entity instanceof EntityHuman && flag1 && AngerLevel.a(j2).d()) {
                this.dK().b(MemoryModuleType.o);
            }
            if (listening) {
                this.gh();
            }
        }
    }

    public Optional<EntityLiving> fY() {
        return this.w().d() ? this.cz.a() : Optional.empty();
    }

    @Override
    @Nullable
    public EntityLiving j() {
        return this.dK().c(MemoryModuleType.o).orElse(null);
    }

    @Override
    public boolean h(double distanceSquared) {
        return false;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.dK().a(MemoryModuleType.aD, Unit.a, 1200L);
        if (spawnReason == EnumMobSpawn.k) {
            this.b(EntityPose.n);
            this.dK().a(MemoryModuleType.aB, Unit.a, WardenAi.a);
            this.a(SoundEffects.zp, 5.0f, 1.0f);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean flag = super.a(source, amount);
        if (!(this.dI().B || this.fQ() || this.ga())) {
            Entity entity = source.d();
            this.a(entity, AngerLevel.c.a() + 20, false);
            if (this.bA.c(MemoryModuleType.o).isEmpty() && entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                if (!source.b() || this.a((Entity)entityliving, 5.0)) {
                    this.l(entityliving);
                }
            }
        }
        return flag;
    }

    public void l(EntityLiving target) {
        this.dK().b(MemoryModuleType.ax);
        this.dK().a(MemoryModuleType.o, target);
        this.dK().b(MemoryModuleType.E);
        SonicBoom.a((EntityLiving)this, 200);
    }

    @Override
    public EntitySize a(EntityPose pose) {
        EntitySize entitysize = super.a(pose);
        return this.ga() ? EntitySize.c(entitysize.a, 1.0f) : entitysize;
    }

    @Override
    public boolean bp() {
        return !this.ga() && super.bp();
    }

    @Override
    protected void A(Entity entity) {
        if (!this.fQ() && !this.dK().a(MemoryModuleType.aG)) {
            this.dK().a(MemoryModuleType.aG, Unit.a, 20L);
            this.c(entity);
            WardenAi.a(this, entity.di());
        }
        super.A(entity);
    }

    @VisibleForTesting
    public AngerManagement fZ() {
        return this.cz;
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new Navigation(this, world){

            @Override
            protected Pathfinder a(int range) {
                this.o = new PathfinderNormal();
                this.o.a(true);
                return new Pathfinder(this.o, range){

                    @Override
                    protected float a(PathPoint a2, PathPoint b2) {
                        return a2.b(b2);
                    }
                };
            }
        };
    }

    @Override
    public VibrationSystem.a gb() {
        return this.cy;
    }

    @Override
    public VibrationSystem.d gc() {
        return this.cx;
    }

    private class a
    implements VibrationSystem.d {
        private static final int b = 16;
        private final PositionSource c;

        a() {
            this.c = new EntityPositionSource(Warden.this, Warden.this.cF());
        }

        @Override
        public int a() {
            return 16;
        }

        @Override
        public PositionSource b() {
            return this.c;
        }

        @Override
        public TagKey<GameEvent> c() {
            return GameEventTags.b;
        }

        @Override
        public boolean d() {
            return true;
        }

        @Override
        public boolean a(WorldServer world, BlockPosition pos, GameEvent event, GameEvent.a emitter) {
            if (!(Warden.this.fQ() || Warden.this.es() || Warden.this.dK().a(MemoryModuleType.aH) || Warden.this.ga() || !world.w_().a(pos))) {
                EntityLiving entityliving;
                Entity entity = emitter.a();
                if (entity instanceof EntityLiving && !Warden.this.a((Entity)(entityliving = (EntityLiving)entity))) {
                    boolean flag = false;
                    return flag;
                }
                boolean flag = true;
                return flag;
            }
            return false;
        }

        @Override
        public void a(WorldServer world, BlockPosition pos, GameEvent event, @Nullable Entity sourceEntity, @Nullable Entity entity, float distance) {
            if (!Warden.this.es()) {
                Warden.this.bA.a(MemoryModuleType.aH, Unit.a, 40L);
                world.a((Entity)Warden.this, (byte)61);
                Warden.this.a(SoundEffects.zI, 5.0f, Warden.this.eS());
                BlockPosition blockposition1 = pos;
                if (entity != null) {
                    if (Warden.this.a(entity, 30.0)) {
                        if (Warden.this.dK().a(MemoryModuleType.az)) {
                            if (Warden.this.a(entity)) {
                                blockposition1 = entity.di();
                            }
                            Warden.this.c(entity);
                        } else {
                            Warden.this.a(entity, 10, true);
                        }
                    }
                    Warden.this.dK().a(MemoryModuleType.az, Unit.a, 100L);
                } else {
                    Warden.this.c(sourceEntity);
                }
                if (!Warden.this.w().d()) {
                    Optional<EntityLiving> optional = Warden.this.cz.a();
                    if (entity != null || optional.isEmpty() || optional.get() == sourceEntity) {
                        WardenAi.a(Warden.this, blockposition1);
                    }
                }
            }
        }
    }
}

