/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.Sets;
import io.papermc.paper.event.player.PlayerPurchaseEvent;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftMerchant;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftMerchantRecipe;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;

public abstract class EntityVillagerAbstract
extends EntityAgeable
implements InventoryCarrier,
NPC,
IMerchant {
    private CraftMerchant craftMerchant;
    private static final DataWatcherObject<Integer> bV = DataWatcher.a(EntityVillagerAbstract.class, DataWatcherRegistry.b);
    public static final int bT = 300;
    private static final int bW = 8;
    @Nullable
    private EntityHuman bX;
    @Nullable
    protected MerchantRecipeList bU;
    private final InventorySubcontainer bY = new InventorySubcontainer(8, (CraftAbstractVillager)this.getBukkitEntity());

    @Override
    public CraftMerchant getCraftMerchant() {
        return this.craftMerchant == null ? (this.craftMerchant = new CraftMerchant(this)) : this.craftMerchant;
    }

    public EntityVillagerAbstract(EntityTypes<? extends EntityVillagerAbstract> type, World world) {
        super((EntityTypes<? extends EntityAgeable>)type, world);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        if (entityData == null) {
            entityData = new EntityAgeable.a(false);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public int q() {
        return this.am.b(bV);
    }

    public void s(int ticks) {
        this.am.b(bV, ticks);
    }

    @Override
    public int r() {
        return 0;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return this.h_() ? 0.81f : 1.62f;
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bV, 0);
    }

    @Override
    public void f(@Nullable EntityHuman customer) {
        this.bX = customer;
    }

    @Override
    @Nullable
    public EntityHuman fY() {
        return this.bX;
    }

    public boolean fZ() {
        return this.bX != null;
    }

    public void resetOffers() {
        this.bU = new MerchantRecipeList();
        this.gf();
    }

    @Override
    public MerchantRecipeList ga() {
        if (this.bU == null) {
            this.bU = new MerchantRecipeList();
            this.gf();
        }
        return this.bU;
    }

    @Override
    public void a(@Nullable MerchantRecipeList offers) {
    }

    @Override
    public void t(int experience) {
    }

    @Override
    public void processTrade(MerchantRecipe recipe, @Nullable PlayerPurchaseEvent event) {
        if (event == null || event.willIncreaseTradeUses()) {
            recipe.j();
        }
        if (event == null || event.isRewardingExp()) {
            this.b(recipe);
        }
        this.a(recipe);
    }

    @Override
    public void a(MerchantRecipe offer) {
        this.bI = -this.M();
        if (this.bX instanceof EntityPlayer) {
            CriterionTriggers.s.a((EntityPlayer)this.bX, this, offer.d());
        }
    }

    protected abstract void b(MerchantRecipe var1);

    @Override
    public boolean gb() {
        return true;
    }

    @Override
    public void l(ItemStack stack) {
        if (!this.dI().B && this.bI > -this.M() + 20) {
            this.bI = -this.M();
            this.a(this.w(!stack.b()), this.eR(), this.eS());
        }
    }

    @Override
    public SoundEffect gc() {
        return SoundEffects.yH;
    }

    protected SoundEffect w(boolean sold) {
        return sold ? SoundEffects.yH : SoundEffects.yF;
    }

    public void gd() {
        this.a(SoundEffects.yC, this.eR(), this.eS());
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        MerchantRecipeList merchantrecipelist = this.ga();
        if (!merchantrecipelist.isEmpty()) {
            nbt.a("Offers", merchantrecipelist.a());
        }
        this.a_(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("Offers", 10)) {
            this.bU = new MerchantRecipeList(nbt.p("Offers"));
        }
        this.c(nbt);
    }

    @Override
    @Nullable
    public Entity b(WorldServer destination) {
        this.ge();
        return super.b(destination);
    }

    protected void ge() {
        this.f((EntityHuman)null);
    }

    @Override
    public void a(DamageSource damageSource) {
        super.a(damageSource);
        this.ge();
    }

    protected void a(ParticleParam parameters) {
        for (int i2 = 0; i2 < 5; ++i2) {
            double d0 = this.af.k() * 0.02;
            double d1 = this.af.k() * 0.02;
            double d2 = this.af.k() * 0.02;
            this.dI().a(parameters, this.d(1.0), this.dq() + 1.0, this.g(1.0), d0, d1, d2);
        }
    }

    @Override
    public boolean a(EntityHuman player) {
        return false;
    }

    @Override
    public InventorySubcontainer w() {
        return this.bY;
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        int j2 = mappedIndex - 300;
        return j2 >= 0 && j2 < this.bY.b() ? SlotAccess.a(this.bY, j2) : super.a_(mappedIndex);
    }

    protected abstract void gf();

    protected void a(MerchantRecipeList recipeList, VillagerTrades.IMerchantRecipeOption[] pool, int count) {
        HashSet set = Sets.newHashSet();
        if (pool.length > count) {
            while (set.size() < count) {
                set.add(this.af.a(pool.length));
            }
        } else {
            for (int j2 = 0; j2 < pool.length; ++j2) {
                set.add(j2);
            }
        }
        for (Integer integer : set) {
            VillagerTrades.IMerchantRecipeOption villagertrades_imerchantrecipeoption = pool[integer];
            MerchantRecipe merchantrecipe = villagertrades_imerchantrecipeoption.a(this, this.af);
            if (merchantrecipe == null) continue;
            VillagerAcquireTradeEvent event = new VillagerAcquireTradeEvent((AbstractVillager)this.getBukkitEntity(), (org.bukkit.inventory.MerchantRecipe)merchantrecipe.asBukkit());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) continue;
            CraftMerchantRecipe craftMerchantRecipe = CraftMerchantRecipe.fromBukkit(event.getRecipe());
            if (craftMerchantRecipe.getIngredients().isEmpty()) {
                return;
            }
            recipeList.add(craftMerchantRecipe.toMinecraft());
        }
    }

    @Override
    public Vec3D q(float delta) {
        float f1 = MathHelper.i(delta, this.aW, this.aV) * ((float)Math.PI / 180);
        Vec3D vec3d = new Vec3D(0.0, this.cE().c() - 1.0, 0.2);
        return this.l(delta).e(vec3d.b(-f1));
    }

    @Override
    public boolean gg() {
        return this.dI().B;
    }
}

