/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.destroystokyo.paper.event.player.PlayerReadyArrowEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.event.player.PlayerDeepSleepEvent;
import io.papermc.paper.event.player.PrePlayerAttackEntityEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.PlayerAbilities;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemElytra;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftVector;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public abstract class EntityHuman
extends EntityLiving {
    private static final Logger b = LogUtils.getLogger();
    public static final int bB = 16;
    public static final int bC = 20;
    public static final int bD = 100;
    public static final int bE = 10;
    public static final int bF = 200;
    public static final float bG = 1.5f;
    public static final float bH = 0.6f;
    public static final float bI = 0.6f;
    public static final float bJ = 1.62f;
    public static final EntitySize bK = EntitySize.b(0.6f, 1.8f);
    private static final Map<EntityPose, EntitySize> c = ImmutableMap.builder().put((Object)EntityPose.a, (Object)bK).put((Object)EntityPose.c, (Object)EntityLiving.aE).put((Object)EntityPose.b, (Object)EntitySize.b(0.6f, 0.6f)).put((Object)EntityPose.d, (Object)EntitySize.b(0.6f, 0.6f)).put((Object)EntityPose.e, (Object)EntitySize.b(0.6f, 0.6f)).put((Object)EntityPose.f, (Object)EntitySize.b(0.6f, 1.5f)).put((Object)EntityPose.h, (Object)EntitySize.c(0.2f, 0.2f)).build();
    private static final int d = 25;
    private static final DataWatcherObject<Float> e = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> f = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Byte> bL = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<Byte> bM = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<NBTTagCompound> bN = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.s);
    protected static final DataWatcherObject<NBTTagCompound> bO = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.s);
    private long g;
    private final PlayerInventory cl = new PlayerInventory(this);
    protected InventoryEnderChest bP = new InventoryEnderChest(this);
    public final ContainerPlayer bQ;
    public Container bR;
    protected FoodMetaData bS = new FoodMetaData(this);
    protected int bT;
    public float bU;
    public float bV;
    public int bW;
    public double bX;
    public double bY;
    public double bZ;
    public double ca;
    public double cb;
    public double cc;
    public int cm;
    protected boolean cd;
    private final PlayerAbilities cn = new PlayerAbilities();
    public int ce;
    public int cf;
    public float cg;
    public int ch;
    protected final float ci = 0.02f;
    private int co;
    public GameProfile cp;
    private boolean cq;
    private net.minecraft.world.item.ItemStack cr;
    private final ItemCooldown cs;
    private Optional<GlobalPos> ct;
    @Nullable
    public EntityFishingHook cj;
    public float ck;
    public boolean affectsSpawning = true;
    public TriState flyingFallDamage = TriState.NOT_SET;
    public boolean fauxSleeping;
    public int oldLevel = -1;

    @Override
    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)super.getBukkitEntity();
    }

    public EntityHuman(World world, BlockPosition pos, float yaw, GameProfile gameProfile) {
        super((EntityTypes<? extends EntityLiving>)EntityTypes.bt, world);
        this.cr = net.minecraft.world.item.ItemStack.b;
        this.cs = this.k();
        this.ct = Optional.empty();
        this.a_(UUIDUtil.a(gameProfile));
        this.cp = gameProfile;
        this.bQ = new ContainerPlayer(this.cl, !world.B, this);
        this.bR = this.bQ;
        this.b((double)pos.u() + 0.5, pos.v() + 1, (double)pos.w() + 0.5, yaw, 0.0f);
        this.bh = 180.0f;
    }

    public boolean a(World world, BlockPosition pos, EnumGamemode gameMode) {
        if (!gameMode.f()) {
            return false;
        }
        if (gameMode == EnumGamemode.d) {
            return true;
        }
        if (this.fZ()) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemstack = this.eO();
        return itemstack.b() || !itemstack.b(world.B_().d(Registries.e), new ShapeDetectorBlock(world, pos, false));
    }

    public static AttributeProvider.Builder fC() {
        return EntityLiving.dM().a(GenericAttributes.f, 1.0).a(GenericAttributes.d, 0.1f).a(GenericAttributes.h).a(GenericAttributes.k);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(e, Float.valueOf(0.0f));
        this.am.a(f, 0);
        this.am.a(bL, (byte)0);
        this.am.a(bM, (byte)1);
        this.am.a(bN, new NBTTagCompound());
        this.am.a(bO, new NBTTagCompound());
    }

    @Override
    public void l() {
        this.ae = this.G_();
        if (this.G_()) {
            this.c(false);
        }
        if (this.bW > 0) {
            --this.bW;
        }
        if (this.fy()) {
            ++this.cm;
            if (this.cm == 100 && !new PlayerDeepSleepEvent((Player)this.getBukkitEntity()).callEvent()) {
                this.cm = Integer.MIN_VALUE;
            }
            if (this.cm > 100) {
                this.cm = 100;
            }
            if (!this.dI().B && this.dI().N()) {
                this.a(false, true);
            }
        } else if (this.cm > 0) {
            ++this.cm;
            if (this.cm >= 110) {
                this.cm = 0;
            }
        }
        this.fG();
        super.l();
        if (!this.dI().B && this.bR != null && !this.bR.a(this)) {
            this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
            this.bR = this.bQ;
        }
        this.x();
        if (!this.dI().B) {
            this.bS.a(this);
            this.a(StatisticList.k);
            this.a(StatisticList.l);
            if (this.bs()) {
                this.a(StatisticList.m);
            }
            if (this.bS()) {
                this.a(StatisticList.o);
            }
            if (!this.fy()) {
                this.a(StatisticList.n);
            }
        }
        int i2 = 29999999;
        double d0 = MathHelper.a(this.dn(), -2.9999999E7, 2.9999999E7);
        double d1 = MathHelper.a(this.dt(), -2.9999999E7, 2.9999999E7);
        if (d0 != this.dn() || d1 != this.dt()) {
            this.e(d0, this.dp(), d1);
        }
        ++this.aQ;
        net.minecraft.world.item.ItemStack itemstack = this.eO();
        if (!net.minecraft.world.item.ItemStack.a(this.cr, itemstack)) {
            if (!net.minecraft.world.item.ItemStack.b(this.cr, itemstack)) {
                this.gh();
            }
            this.cr = itemstack.p();
        }
        this.s();
        this.cs.a();
        this.fH();
    }

    public boolean fD() {
        return this.bP();
    }

    protected boolean fE() {
        return this.bP();
    }

    protected boolean fF() {
        return this.bP();
    }

    protected boolean fG() {
        this.cd = ((Entity)this).a(TagsFluid.a);
        return this.cd;
    }

    private void s() {
        net.minecraft.world.item.ItemStack itemstack = this.c(EnumItemSlot.f);
        if (itemstack.a(Items.nC) && !((Entity)this).a(TagsFluid.a)) {
            this.addEffect(new MobEffect(MobEffects.m, 200, 0, false, false, true), EntityPotionEffectEvent.Cause.TURTLE_HELMET);
        }
    }

    protected ItemCooldown k() {
        return new ItemCooldown();
    }

    private void x() {
        this.bX = this.ca;
        this.bY = this.cb;
        this.bZ = this.cc;
        double d0 = this.dn() - this.ca;
        double d1 = this.dp() - this.cb;
        double d2 = this.dt() - this.cc;
        double d3 = 10.0;
        if (d0 > 10.0) {
            this.bX = this.ca = this.dn();
        }
        if (d2 > 10.0) {
            this.bZ = this.cc = this.dt();
        }
        if (d1 > 10.0) {
            this.bY = this.cb = this.dp();
        }
        if (d0 < -10.0) {
            this.bX = this.ca = this.dn();
        }
        if (d2 < -10.0) {
            this.bZ = this.cc = this.dt();
        }
        if (d1 < -10.0) {
            this.bY = this.cb = this.dp();
        }
        this.ca += d0 * 0.25;
        this.cc += d2 * 0.25;
        this.cb += d1 * 0.25;
    }

    protected void fH() {
        if (this.d(EntityPose.d)) {
            EntityPose entitypose = this.fr() ? EntityPose.b : (this.fy() ? EntityPose.c : (this.bW() ? EntityPose.d : (this.fe() ? EntityPose.e : (this.bP() && !this.cn.b ? EntityPose.f : EntityPose.a))));
            EntityPose entitypose1 = !(this.G_() || this.bM() || this.d(entitypose)) ? (this.d(EntityPose.f) ? EntityPose.f : EntityPose.d) : entitypose;
            this.b(entitypose1);
        }
    }

    @Override
    public int at() {
        return this.cn.a ? 1 : 80;
    }

    @Override
    protected SoundEffect aJ() {
        return SoundEffects.sI;
    }

    @Override
    protected SoundEffect aK() {
        return SoundEffects.sG;
    }

    @Override
    protected SoundEffect aL() {
        return SoundEffects.sH;
    }

    @Override
    public int bH() {
        return 10;
    }

    @Override
    public void a(SoundEffect sound, float volume, float pitch) {
        this.dI().a(this, this.dn(), this.dp(), this.dt(), sound, this.cY(), volume, pitch);
    }

    public void a(SoundEffect event, SoundCategory category, float volume, float pitch) {
    }

    @Override
    public SoundCategory cY() {
        return SoundCategory.h;
    }

    @Override
    public int cZ() {
        return 20;
    }

    @Override
    public void b(byte status) {
        if (status == 9) {
            this.Z_();
        } else if (status == 23) {
            this.cq = false;
        } else if (status == 22) {
            this.cq = true;
        } else if (status == 43) {
            this.a(Particles.f);
        } else {
            super.b(status);
        }
    }

    private void a(ParticleParam parameters) {
        for (int i2 = 0; i2 < 5; ++i2) {
            double d0 = this.af.k() * 0.02;
            double d1 = this.af.k() * 0.02;
            double d2 = this.af.k() * 0.02;
            this.dI().a(parameters, this.d(1.0), this.dq() + 1.0, this.g(1.0), d0, d1, d2);
        }
    }

    public void closeContainer(InventoryCloseEvent.Reason reason) {
        this.q();
        this.bR = this.bQ;
    }

    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        this.bR = this.bQ;
    }

    public void q() {
        this.bR = this.bQ;
    }

    protected void r() {
    }

    @Override
    public void bv() {
        if (!this.dI().B && this.fE() && this.bM()) {
            this.Y();
            if (!this.bM()) {
                this.f(false);
                return;
            }
        }
        double d0 = this.dn();
        double d1 = this.dp();
        double d2 = this.dt();
        super.bv();
        this.bU = this.bV;
        this.bV = 0.0f;
        this.s(this.dn() - d0, this.dp() - d1, this.dt() - d2);
    }

    @Override
    protected void fc() {
        super.fc();
        this.eL();
        this.aX = this.dy();
    }

    @Override
    public void b_() {
        if (this.bT > 0) {
            --this.bT;
        }
        if (this.dI().ai() == EnumDifficulty.a && this.dI().X().b(GameRules.j)) {
            if (this.er() < this.eI() && this.ag % 20 == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            if (this.bS.c() && this.ag % 10 == 0) {
                this.bS.a(this.bS.a() + 1);
            }
        }
        this.cl.j();
        this.bU = this.bV;
        super.b_();
        this.w((float)this.b(GenericAttributes.d));
        float f2 = this.ay() && !this.es() && !this.bW() ? Math.min(0.1f, (float)this.dl().h()) : 0.0f;
        this.bV += (f2 - this.bV) * 0.4f;
        if (this.er() > 0.0f && !this.G_()) {
            AxisAlignedBB axisalignedbb = this.bM() && !this.cW().dD() ? this.cE().b(this.cW().cE()).c(1.0, 0.0, 1.0) : this.cE().c(1.0, 0.5, 1.0);
            List<Entity> list = this.dI().a_(this, axisalignedbb);
            ArrayList list1 = Lists.newArrayList();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Entity entity = list.get(i2);
                if (entity.ae() == EntityTypes.J) {
                    list1.add(entity);
                    continue;
                }
                if (entity.dD()) continue;
                this.c(entity);
            }
            if (!list1.isEmpty()) {
                this.c((Entity)SystemUtils.a(list1, this.af));
            }
        }
        this.c(this.ge());
        this.c(this.gf());
        if ((!this.dI().B && (this.aa > 0.5f || this.aV()) || this.cn.b || this.fy() || this.az) && !this.dI().paperConfig().entities.behavior.parrotsAreUnaffectedByPlayerMovement) {
            this.gb();
        }
    }

    private void c(@Nullable NBTTagCompound entityNbt) {
        if (!(entityNbt == null || entityNbt.e("Silent") && entityNbt.q("Silent") || this.dI().z.a(200) != 0)) {
            String s2 = entityNbt.l("id");
            EntityTypes.a(s2).filter(entitytypes -> entitytypes == EntityTypes.at).ifPresent(entitytypes -> {
                if (!EntityParrot.a(this.dI(), this)) {
                    this.dI().a((EntityHuman)null, this.dn(), this.dp(), this.dt(), EntityParrot.a(this.dI(), this.dI().z), this.cY(), 1.0f, EntityParrot.a(this.dI().z));
                }
            });
        }
    }

    private void c(Entity entity) {
        entity.b_(this);
    }

    public int fI() {
        return this.am.b(f);
    }

    public void r(int score) {
        this.am.b(f, score);
    }

    public void s(int score) {
        int j2 = this.fI();
        this.am.b(f, j2 + score);
    }

    public void t(int riptideTicks) {
        this.bz = riptideTicks;
        if (!this.dI().B) {
            this.gb();
            this.c(4, true);
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        super.a(damageSource);
        this.an();
        if (!this.G_()) {
            this.dropAllDeathLoot(damageSource);
        }
        if (damageSource != null) {
            this.o(-MathHelper.b((this.eB() + this.dy()) * ((float)Math.PI / 180)) * 0.1f, 0.1f, -MathHelper.a((this.eB() + this.dy()) * ((float)Math.PI / 180)) * 0.1f);
        } else {
            this.o(0.0, 0.1, 0.0);
        }
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aw();
        this.a_(false);
        this.a(Optional.of(GlobalPos.a(this.dI().ac(), this.di())));
    }

    @Override
    protected void eu() {
        super.eu();
        if (!this.dI().X().b(GameRules.d)) {
            this.fJ();
            this.cl.k();
        }
    }

    protected void fJ() {
        for (int i2 = 0; i2 < this.cl.b(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = this.cl.a(i2);
            if (itemstack.b() || !EnchantmentManager.e(itemstack)) continue;
            this.cl.b(i2);
        }
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return source.j().d().a();
    }

    @Override
    public SoundEffect g_() {
        return SoundEffects.sy;
    }

    @Nullable
    public EntityItem a(net.minecraft.world.item.ItemStack stack, boolean retainOwnership) {
        return this.a(stack, false, retainOwnership);
    }

    @Nullable
    public EntityItem a(net.minecraft.world.item.ItemStack stack, boolean throwRandomly, boolean retainOwnership) {
        return this.drop(stack, throwRandomly, retainOwnership, true);
    }

    @Nullable
    public EntityItem drop(net.minecraft.world.item.ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        WorldMap worldmap;
        if (itemstack.b()) {
            return null;
        }
        if (this.dI().B) {
            this.a(EnumHand.a);
        }
        double d0 = this.dr() - (double)0.3f;
        net.minecraft.world.item.ItemStack tmp = itemstack.p();
        itemstack.f(0);
        itemstack = tmp;
        EntityItem entityitem = new EntityItem(this.dI(), this.dn(), d0, this.dt(), itemstack);
        entityitem.b(40);
        if (flag1) {
            entityitem.c(this.ct());
        }
        if (flag) {
            float f2 = this.af.i() * 0.5f;
            float f1 = this.af.i() * ((float)Math.PI * 2);
            entityitem.o(-MathHelper.a(f1) * f2, 0.2f, MathHelper.b(f1) * f2);
        } else {
            float f3 = 0.3f;
            float f1 = MathHelper.a(this.dA() * ((float)Math.PI / 180));
            float f2 = MathHelper.b(this.dA() * ((float)Math.PI / 180));
            float f32 = MathHelper.a(this.dy() * ((float)Math.PI / 180));
            float f4 = MathHelper.b(this.dy() * ((float)Math.PI / 180));
            float f5 = this.af.i() * ((float)Math.PI * 2);
            float f6 = 0.02f * this.af.i();
            entityitem.o((double)(-f32 * f2 * 0.3f) + Math.cos(f5) * (double)f6, -f1 * 0.3f + 0.1f + (this.af.i() - this.af.i()) * 0.1f, (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
        }
        if (!callEvent) {
            return entityitem;
        }
        Player player = (Player)this.getBukkitEntity();
        Item drop = (Item)entityitem.getBukkitEntity();
        PlayerDropItemEvent event = new PlayerDropItemEvent(player, drop);
        this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            ItemStack cur = player.getInventory().getItemInHand();
            if (flag1 && (cur == null || cur.getAmount() == 0)) {
                player.getInventory().setItemInHand(drop.getItemStack());
            } else if (flag1 && cur.isSimilar(drop.getItemStack()) && cur.getAmount() < cur.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                cur.setAmount(cur.getAmount() + 1);
                player.getInventory().setItemInHand(cur);
            } else {
                player.getInventory().addItem(new ItemStack[]{drop.getItemStack()});
            }
            return null;
        }
        if (itemstack.d() == Items.rf && (worldmap = ItemWorldMap.a(itemstack, this.dI())) != null) {
            worldmap.a(this, itemstack);
        }
        return entityitem;
    }

    public float d(IBlockData block) {
        float f2 = this.cl.a(block);
        if (f2 > 1.0f) {
            int i2 = EnchantmentManager.g(this);
            net.minecraft.world.item.ItemStack itemstack = this.eO();
            if (i2 > 0 && !itemstack.b()) {
                f2 += (float)(i2 * i2 + 1);
            }
        }
        if (MobEffectUtil.a(this)) {
            f2 *= 1.0f + (float)(MobEffectUtil.b(this) + 1) * 0.2f;
        }
        if (this.a(MobEffects.d)) {
            f2 *= (switch (this.b(MobEffects.d).e()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            });
        }
        if (((Entity)this).a(TagsFluid.a) && !EnchantmentManager.i(this)) {
            f2 /= 5.0f;
        }
        if (!this.ay()) {
            f2 /= 5.0f;
        }
        return f2;
    }

    public boolean e(IBlockData state) {
        return !state.y() || this.cl.f().b(state);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a_(UUIDUtil.a(this.cp));
        NBTTagList nbttaglist = nbt.c("Inventory", 10);
        this.cl.b(nbttaglist);
        this.cl.l = nbt.h("SelectedItemSlot");
        this.cm = nbt.g("SleepTimer");
        this.cg = nbt.j("XpP");
        this.ce = nbt.h("XpLevel");
        this.cf = nbt.h("XpTotal");
        this.ch = nbt.h("XpSeed");
        if (this.ch == 0) {
            this.ch = this.af.f();
        }
        this.r(nbt.h("Score"));
        this.bS.a(nbt);
        this.cn.b(nbt);
        this.a(GenericAttributes.d).a(this.cn.b());
        if (nbt.b("EnderItems", 9)) {
            this.bP.a(nbt.c("EnderItems", 10));
        }
        if (nbt.b("ShoulderEntityLeft", 10)) {
            this.i(nbt.p("ShoulderEntityLeft"));
        }
        if (nbt.b("ShoulderEntityRight", 10)) {
            this.j(nbt.p("ShoulderEntityRight"));
        }
        if (nbt.b("LastDeathLocation", 10)) {
            DataResult dataresult = GlobalPos.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c("LastDeathLocation"));
            Logger logger = b;
            Objects.requireNonNull(logger);
            this.a(dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)));
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        GameProfileSerializer.g(nbt);
        nbt.a("Inventory", this.cl.a(new NBTTagList()));
        nbt.a("SelectedItemSlot", this.cl.l);
        nbt.a("SleepTimer", (short)this.cm);
        nbt.a("XpP", this.cg);
        nbt.a("XpLevel", this.ce);
        nbt.a("XpTotal", this.cf);
        nbt.a("XpSeed", this.ch);
        nbt.a("Score", this.fI());
        this.bS.b(nbt);
        this.cn.a(nbt);
        nbt.a("EnderItems", this.bP.g());
        if (!this.ge().g()) {
            nbt.a("ShoulderEntityLeft", this.ge());
        }
        if (!this.gf().g()) {
            nbt.a("ShoulderEntityRight", this.gf());
        }
        this.gm().flatMap(globalpos -> {
            DataResult dataresult = GlobalPos.a.encodeStart((DynamicOps)DynamicOpsNBT.a, globalpos);
            Logger logger = b;
            Objects.requireNonNull(logger);
            return dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
        }).ifPresent(nbtbase -> nbt.a("LastDeathLocation", (NBTBase)nbtbase));
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return super.b(damageSource) ? true : (damageSource.a(DamageTypeTags.n) ? !this.dI().X().b(GameRules.C) : (damageSource.a(DamageTypeTags.m) ? !this.dI().X().b(GameRules.D) : (damageSource.a(DamageTypeTags.i) ? !this.dI().X().b(GameRules.E) : (damageSource.a(DamageTypeTags.o) ? !this.dI().X().b(GameRules.F) : false))));
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean damaged;
        if (this.b(source)) {
            return false;
        }
        if (this.cn.a && !source.a(DamageTypeTags.d)) {
            return false;
        }
        this.bc = 0;
        if (this.es()) {
            return false;
        }
        if (!this.dI().B) {
            // empty if block
        }
        if (source.f()) {
            if (this.dI().ai() == EnumDifficulty.a) {
                return false;
            }
            if (this.dI().ai() == EnumDifficulty.b) {
                amount = Math.min(amount / 2.0f + 1.0f, amount);
            }
            if (this.dI().ai() == EnumDifficulty.d) {
                amount = amount * 3.0f / 2.0f;
            }
        }
        if (damaged = super.a(source, amount)) {
            this.gb();
        }
        return damaged;
    }

    @Override
    protected void d(EntityLiving attacker) {
        super.d(attacker);
        if (attacker.fB()) {
            this.s(true);
        }
    }

    @Override
    public boolean ek() {
        return !this.fO().a && super.ek();
    }

    public boolean a(EntityHuman player) {
        Team team;
        if (player instanceof EntityPlayer) {
            EntityPlayer thatPlayer = (EntityPlayer)player;
            team = thatPlayer.getBukkitEntity().getScoreboard().getPlayerTeam((OfflinePlayer)thatPlayer.getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = player.dI().getCraftServer().getOfflinePlayer(player.cv());
            team = player.dI().getCraftServer().getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof EntityPlayer) {
            return !team.hasPlayer((OfflinePlayer)((EntityPlayer)this).getBukkitEntity());
        }
        return !team.hasPlayer(this.dI().getCraftServer().getOfflinePlayer(this.cv()));
    }

    @Override
    protected void b(DamageSource source, float amount) {
        this.cl.a(source, amount, PlayerInventory.g);
    }

    @Override
    protected void c(DamageSource source, float amount) {
        this.cl.a(source, amount, PlayerInventory.h);
    }

    @Override
    protected void u(float amount) {
        if (this.bw.a(Items.uy)) {
            if (!this.dI().B) {
                this.b(StatisticList.c.b(this.bw.d()));
            }
            if (amount >= 3.0f) {
                int i2 = 1 + MathHelper.d(amount);
                EnumHand enumhand = this.fj();
                this.bw.a(i2, this, (T entityhuman) -> entityhuman.d(enumhand));
                if (this.bw.b()) {
                    if (enumhand == EnumHand.a) {
                        this.a(EnumItemSlot.a, net.minecraft.world.item.ItemStack.b);
                    } else {
                        this.a(EnumItemSlot.b, net.minecraft.world.item.ItemStack.b);
                    }
                    this.bw = net.minecraft.world.item.ItemStack.b;
                    this.a(SoundEffects.uR, 0.8f, 0.8f + this.dI().z.i() * 0.4f);
                }
            }
        }
    }

    @Override
    protected boolean damageEntity0(DamageSource damagesource, float f2) {
        return super.damageEntity0(damagesource, f2);
    }

    @Override
    protected boolean dQ() {
        return !this.cn.b && super.dQ();
    }

    public boolean U() {
        return false;
    }

    public void a(TileEntitySign sign, boolean front) {
    }

    public void a(CommandBlockListenerAbstract commandBlockExecutor) {
    }

    public void a(TileEntityCommand commandBlock) {
    }

    public void a(TileEntityStructure structureBlock) {
    }

    public void a(TileEntityJigsaw jigsaw) {
    }

    public void a(EntityHorseAbstract horse, IInventory inventory) {
    }

    public OptionalInt a(@Nullable ITileInventory factory) {
        return OptionalInt.empty();
    }

    public void a(int syncId, MerchantRecipeList offers, int levelProgress, int experience, boolean leveled, boolean refreshable) {
    }

    public void a(net.minecraft.world.item.ItemStack book, EnumHand hand) {
    }

    public EnumInteractionResult a(Entity entity, EnumHand hand) {
        if (this.G_()) {
            if (entity instanceof ITileInventory) {
                this.a((ITileInventory)((Object)entity));
            }
            return EnumInteractionResult.d;
        }
        net.minecraft.world.item.ItemStack itemstack = this.b(hand);
        net.minecraft.world.item.ItemStack itemstack1 = itemstack.p();
        EnumInteractionResult enuminteractionresult = entity.a(this, hand);
        if (enuminteractionresult.a()) {
            if (this.cn.d && itemstack == this.b(hand) && itemstack.L() < itemstack1.L()) {
                itemstack.f(itemstack1.L());
            }
            return enuminteractionresult;
        }
        if (!itemstack.b() && entity instanceof EntityLiving) {
            EnumInteractionResult enuminteractionresult1;
            if (this.cn.d) {
                itemstack = itemstack1;
            }
            if ((enuminteractionresult1 = itemstack.a(this, (EntityLiving)entity, hand)).a()) {
                this.dI().a(GameEvent.r, entity.dg(), GameEvent.a.a(this));
                if (itemstack.b() && !this.cn.d) {
                    this.a(hand, net.minecraft.world.item.ItemStack.b);
                }
                return enuminteractionresult1;
            }
        }
        return EnumInteractionResult.d;
    }

    @Override
    public double bw() {
        return -0.35;
    }

    @Override
    public void bA() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        super.stopRiding(suppressCancellation);
        this.I = 0;
    }

    @Override
    protected boolean eT() {
        return super.eT() || this.fy() || this.dD() || !this.valid;
    }

    @Override
    public boolean dW() {
        return !this.cn.b;
    }

    @Override
    protected Vec3D a(Vec3D movement, EnumMoveType type) {
        if (!this.cn.b && movement.d <= 0.0 && (type == EnumMoveType.a || type == EnumMoveType.b) && this.fF() && this.y()) {
            double d0 = movement.c;
            double d1 = movement.e;
            double d2 = 0.05;
            while (d0 != 0.0 && this.dI().a((Entity)this, this.cE().d(d0, -this.dC(), 0.0))) {
                if (d0 < 0.05 && d0 >= -0.05) {
                    d0 = 0.0;
                    continue;
                }
                if (d0 > 0.0) {
                    d0 -= 0.05;
                    continue;
                }
                d0 += 0.05;
            }
            while (d1 != 0.0 && this.dI().a((Entity)this, this.cE().d(0.0, -this.dC(), d1))) {
                if (d1 < 0.05 && d1 >= -0.05) {
                    d1 = 0.0;
                    continue;
                }
                if (d1 > 0.0) {
                    d1 -= 0.05;
                    continue;
                }
                d1 += 0.05;
            }
            while (d0 != 0.0 && d1 != 0.0 && this.dI().a((Entity)this, this.cE().d(d0, -this.dC(), d1))) {
                d0 = d0 < 0.05 && d0 >= -0.05 ? 0.0 : (d0 > 0.0 ? (d0 -= 0.05) : (d0 += 0.05));
                if (d1 < 0.05 && d1 >= -0.05) {
                    d1 = 0.0;
                    continue;
                }
                if (d1 > 0.0) {
                    d1 -= 0.05;
                    continue;
                }
                d1 += 0.05;
            }
            movement = new Vec3D(d0, movement.d, d1);
        }
        return movement;
    }

    private boolean y() {
        return this.ay() || this.aa < this.dC() && !this.dI().a((Entity)this, this.cE().d(0.0, this.aa - this.dC(), 0.0));
    }

    public void d(Entity target) {
        boolean willAttack = target.cn() && !target.r(this);
        PrePlayerAttackEntityEvent playerAttackEntityEvent = new PrePlayerAttackEntityEvent((Player)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), willAttack);
        if (playerAttackEntityEvent.callEvent() && willAttack) {
            float f2 = (float)this.b(GenericAttributes.f);
            float f1 = target instanceof EntityLiving ? EnchantmentManager.a(this.eO(), ((EntityLiving)target).eN()) : EnchantmentManager.a(this.eO(), EnumMonsterType.a);
            float f22 = this.A(0.5f);
            f1 *= f22;
            if ((f2 *= 0.2f + f22 * f22 * 0.8f) > 0.0f || f1 > 0.0f) {
                net.minecraft.world.item.ItemStack itemstack;
                boolean flag = f22 > 0.9f;
                boolean flag1 = false;
                int b0 = 0;
                int i2 = b0 + EnchantmentManager.c(this);
                if (this.bV() && flag) {
                    EntityHuman.sendSoundEffect(this, this.dn(), this.dp(), this.dt(), SoundEffects.sq, this.cY(), 1.0f, 1.0f);
                    ++i2;
                    flag1 = true;
                }
                boolean flag2 = flag && this.aa > 0.0f && !this.ay() && !this.i_() && !this.aV() && !this.a(MobEffects.o) && !this.bM() && target instanceof EntityLiving;
                flag2 = flag2 && !this.dI().paperConfig().entities.behavior.disablePlayerCrits;
                boolean bl = flag2 = flag2 && !this.bV();
                if (flag2) {
                    f2 *= 1.5f;
                }
                f2 += f1;
                boolean flag3 = false;
                double d0 = this.X - this.W;
                if (flag && !flag2 && !flag1 && this.ay() && d0 < (double)this.fa() && (itemstack = this.b(EnumHand.a)).d() instanceof ItemSword) {
                    flag3 = true;
                }
                float f3 = 0.0f;
                boolean flag4 = false;
                int j2 = EnchantmentManager.d(this);
                if (target instanceof EntityLiving) {
                    f3 = ((EntityLiving)target).er();
                    if (j2 > 0 && !target.bL()) {
                        EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), 1);
                        Bukkit.getPluginManager().callEvent((Event)combustEvent);
                        if (!combustEvent.isCancelled()) {
                            flag4 = true;
                            target.setSecondsOnFire(combustEvent.getDuration(), false);
                        }
                    }
                }
                Vec3D vec3d = target.dl();
                boolean flag5 = target.a(this.dJ().a(this).critical(flag2), f2);
                if (flag5) {
                    if (i2 > 0) {
                        if (target instanceof EntityLiving) {
                            ((EntityLiving)target).knockback((float)i2 * 0.5f, MathHelper.a(this.dy() * ((float)Math.PI / 180)), -MathHelper.b(this.dy() * ((float)Math.PI / 180)), this);
                        } else {
                            target.push(-MathHelper.a(this.dy() * ((float)Math.PI / 180)) * (float)i2 * 0.5f, 0.1, MathHelper.b(this.dy() * ((float)Math.PI / 180)) * (float)i2 * 0.5f, this);
                        }
                        this.f(this.dl().d(0.6, 1.0, 0.6));
                        if (!this.dI().paperConfig().misc.disableSprintInterruptionOnAttack) {
                            this.g(false);
                        }
                    }
                    if (flag3) {
                        float f4 = 1.0f + EnchantmentManager.a(this) * f2;
                        List<EntityLiving> list = this.dI().a(EntityLiving.class, target.cE().c(1.0, 0.25, 1.0));
                        for (EntityLiving entityliving : list) {
                            if (entityliving == this || entityliving == target || this.p(entityliving) || entityliving instanceof EntityArmorStand && ((EntityArmorStand)entityliving).w() || !(this.f((Entity)entityliving) < 9.0) || !entityliving.a(this.dJ().a(this).sweep().critical(flag2), f4)) continue;
                            entityliving.knockback(0.4f, MathHelper.a(this.dy() * ((float)Math.PI / 180)), -MathHelper.b(this.dy() * ((float)Math.PI / 180)), this);
                        }
                        EntityHuman.sendSoundEffect(this, this.dn(), this.dp(), this.dt(), SoundEffects.st, this.cY(), 1.0f, 1.0f);
                        this.fK();
                    }
                    if (target instanceof EntityPlayer && target.S) {
                        boolean cancelled = false;
                        Player player = (Player)target.getBukkitEntity();
                        Vector velocity = CraftVector.toBukkit(vec3d);
                        PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                        this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            cancelled = true;
                        } else if (!velocity.equals((Object)event.getVelocity())) {
                            player.setVelocity(event.getVelocity());
                        }
                        if (!cancelled) {
                            ((EntityPlayer)target).c.a(new PacketPlayOutEntityVelocity(target));
                            target.S = false;
                            target.f(vec3d);
                        }
                    }
                    if (flag2) {
                        EntityHuman.sendSoundEffect(this, this.dn(), this.dp(), this.dt(), SoundEffects.sp, this.cY(), 1.0f, 1.0f);
                        this.a(target);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            EntityHuman.sendSoundEffect(this, this.dn(), this.dp(), this.dt(), SoundEffects.ss, this.cY(), 1.0f, 1.0f);
                        } else {
                            EntityHuman.sendSoundEffect(this, this.dn(), this.dp(), this.dt(), SoundEffects.su, this.cY(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.b(target);
                    }
                    this.x(target);
                    if (target instanceof EntityLiving) {
                        EnchantmentManager.a((EntityLiving)target, (Entity)this);
                    }
                    EnchantmentManager.b(this, target);
                    net.minecraft.world.item.ItemStack itemstack1 = this.eO();
                    Entity object = target;
                    if (target instanceof EntityComplexPart) {
                        object = ((EntityComplexPart)target).b;
                    }
                    if (!this.dI().B && !itemstack1.b() && object instanceof EntityLiving) {
                        itemstack1.a((EntityLiving)object, this);
                        if (itemstack1.b()) {
                            this.a(EnumHand.a, net.minecraft.world.item.ItemStack.b);
                        }
                    }
                    if (target instanceof EntityLiving) {
                        float f5 = f3 - ((EntityLiving)target).er();
                        this.a(StatisticList.G, Math.round(f5 * 10.0f));
                        if (j2 > 0) {
                            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), j2 * 4);
                            Bukkit.getPluginManager().callEvent((Event)combustEvent);
                            if (!combustEvent.isCancelled()) {
                                target.setSecondsOnFire(combustEvent.getDuration(), false);
                            }
                        }
                        if (this.dI() instanceof WorldServer && f5 > 2.0f) {
                            int k2 = (int)((double)f5 * 0.5);
                            ((WorldServer)this.dI()).a(Particles.h, target.dn(), target.e(0.5), target.dt(), k2, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.causeFoodExhaustion(this.dI().spigotConfig.combatExhaustion, EntityExhaustionEvent.ExhaustionReason.ATTACK);
                } else {
                    EntityHuman.sendSoundEffect(this, this.dn(), this.dp(), this.dt(), SoundEffects.sr, this.cY(), 1.0f, 1.0f);
                    if (flag4) {
                        target.aw();
                    }
                    if (this instanceof EntityPlayer) {
                        ((EntityPlayer)this).getBukkitEntity().updateInventory();
                    }
                }
            }
        }
    }

    @Override
    protected void g(EntityLiving target) {
        this.d((Entity)target);
    }

    public void s(boolean sprinting) {
        float f2 = 0.25f + (float)EnchantmentManager.g(this) * 0.05f;
        if (sprinting) {
            f2 += 0.75f;
        }
        if (this.af.i() < f2) {
            this.gi().a(Items.uy, 100);
            this.fo();
            this.dI().a((Entity)this, (byte)30);
        }
    }

    public void a(Entity target) {
    }

    public void b(Entity target) {
    }

    public void fK() {
        double d0 = -MathHelper.a(this.dy() * ((float)Math.PI / 180));
        double d1 = MathHelper.b(this.dy() * ((float)Math.PI / 180));
        if (this.dI() instanceof WorldServer) {
            ((WorldServer)this.dI()).a(Particles.ad, this.dn() + d0, this.e(0.5), this.dt() + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    public void fL() {
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        super.a(reason);
        this.bQ.b(this);
        if (this.bR != null && this.fP()) {
            this.r();
        }
    }

    public boolean g() {
        return false;
    }

    public GameProfile fM() {
        return this.cp;
    }

    public PlayerInventory fN() {
        return this.cl;
    }

    public PlayerAbilities fO() {
        return this.cn;
    }

    public void a(net.minecraft.world.item.ItemStack cursorStack, net.minecraft.world.item.ItemStack slotStack, ClickAction clickType) {
    }

    public boolean fP() {
        return this.bR != this.bQ;
    }

    public Either<EnumBedResult, Unit> a(BlockPosition pos) {
        return this.startSleepInBed(pos, false);
    }

    public Either<EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        this.b(blockposition);
        this.cm = 0;
        return Either.right(Unit.a);
    }

    public void a(boolean skipSleepTimer, boolean updateSleepingPlayers) {
        super.fz();
        if (this.dI() instanceof WorldServer && updateSleepingPlayers) {
            ((WorldServer)this.dI()).e();
        }
        this.cm = skipSleepTimer ? 0 : 100;
    }

    @Override
    public void fz() {
        this.a(true, true);
    }

    public static Optional<Vec3D> a(WorldServer world, BlockPosition pos, float angle, boolean forced, boolean alive) {
        IBlockData iblockdata = world.a_(pos);
        Block block = iblockdata.b();
        if (block instanceof BlockRespawnAnchor && (forced || iblockdata.c(BlockRespawnAnchor.c) > 0) && BlockRespawnAnchor.a(world)) {
            Optional<Vec3D> optional = BlockRespawnAnchor.a(EntityTypes.bt, world, pos);
            if (!forced && !alive && optional.isPresent()) {
                world.a(pos, (IBlockData)iblockdata.a(BlockRespawnAnchor.c, iblockdata.c(BlockRespawnAnchor.c) - 1), 3);
            }
            return optional;
        }
        if (block instanceof BlockBed && BlockBed.a(world)) {
            return BlockBed.a(EntityTypes.bt, (ICollisionAccess)world, pos, iblockdata.c(BlockFacingHorizontal.aC), angle);
        }
        if (!forced) {
            return Optional.empty();
        }
        boolean flag2 = block.a(iblockdata);
        IBlockData iblockdata1 = world.a_(pos.c());
        boolean flag3 = iblockdata1.b().a(iblockdata1);
        return flag2 && flag3 ? Optional.of(new Vec3D((double)pos.u() + 0.5, (double)pos.v() + 0.1, (double)pos.w() + 0.5)) : Optional.empty();
    }

    public boolean fQ() {
        return this.fy() && this.cm >= 100;
    }

    public int fR() {
        return this.cm;
    }

    public void a(IChatBaseComponent message, boolean overlay) {
    }

    public void a(MinecraftKey stat) {
        this.b(StatisticList.i.b(stat));
    }

    public void a(MinecraftKey stat, int amount) {
        this.a(StatisticList.i.b(stat), amount);
    }

    public void b(Statistic<?> stat) {
        this.a(stat, 1);
    }

    public void a(Statistic<?> stat, int amount) {
    }

    public void a(Statistic<?> stat) {
    }

    public int a(Collection<IRecipe<?>> recipes) {
        return 0;
    }

    public void a(IRecipe<?> recipe, List<net.minecraft.world.item.ItemStack> ingredients) {
    }

    public void a(MinecraftKey[] ids) {
    }

    public int b(Collection<IRecipe<?>> recipes) {
        return 0;
    }

    @Override
    public void eW() {
        super.eW();
        this.a(StatisticList.E);
        if (this.bV()) {
            this.causeFoodExhaustion(this.dI().spigotConfig.jumpSprintExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
        } else {
            this.causeFoodExhaustion(this.dI().spigotConfig.jumpWalkExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP);
        }
    }

    @Override
    public void h(Vec3D movementInput) {
        double d3;
        double d0 = this.dn();
        double d1 = this.dp();
        double d2 = this.dt();
        if (this.bW() && !this.bM()) {
            double d4;
            d3 = this.bD().d;
            double d5 = d4 = d3 < -0.2 ? 0.085 : 0.06;
            if (d3 <= 0.0 || this.bk || !this.dI().a_(BlockPosition.a(this.dn(), this.dp() + 1.0 - 0.1, this.dt())).u().c()) {
                Vec3D vec3d1 = this.dl();
                this.f(vec3d1.b(0.0, (d3 - vec3d1.d) * d4, 0.0));
            }
        }
        if (this.cn.b && !this.bM()) {
            d3 = this.dl().d;
            super.h(movementInput);
            Vec3D vec3d2 = this.dl();
            this.o(vec3d2.c, d3 * 0.6, vec3d2.e);
            this.n();
            if (this.i(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                this.b(7, false);
            }
        } else {
            super.h(movementInput);
        }
        this.r(this.dn() - d0, this.dp() - d1, this.dt() - d2);
    }

    @Override
    public void ba() {
        if (this.cn.b) {
            this.h(false);
        } else {
            super.ba();
        }
    }

    protected boolean h(BlockPosition pos) {
        return !this.dI().a_(pos).o(this.dI(), pos);
    }

    @Override
    public float fa() {
        return (float)this.b(GenericAttributes.d);
    }

    public void r(double dx, double dy, double dz) {
        if (!this.bM()) {
            if (this.bW()) {
                int i2 = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                if (i2 > 0) {
                    this.a(StatisticList.C, i2);
                    this.causeFoodExhaustion(this.dI().spigotConfig.swimMultiplier * (float)i2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SWIM);
                }
            } else if (((Entity)this).a(TagsFluid.a)) {
                int i3 = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                if (i3 > 0) {
                    this.a(StatisticList.w, i3);
                    this.causeFoodExhaustion(this.dI().spigotConfig.swimMultiplier * (float)i3 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_UNDERWATER);
                }
            } else if (this.aV()) {
                int i4 = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (i4 > 0) {
                    this.a(StatisticList.s, i4);
                    this.causeFoodExhaustion(this.dI().spigotConfig.swimMultiplier * (float)i4 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_ON_WATER);
                }
            } else if (this.i_()) {
                if (dy > 0.0) {
                    this.a(StatisticList.u, (int)Math.round(dy * 100.0));
                }
            } else if (this.ay()) {
                int i5 = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (i5 > 0) {
                    if (this.bV()) {
                        this.a(StatisticList.r, i5);
                        this.causeFoodExhaustion(this.dI().spigotConfig.sprintMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SPRINT);
                    } else if (this.bU()) {
                        this.a(StatisticList.q, i5);
                        this.causeFoodExhaustion(this.dI().spigotConfig.otherMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.CROUCH);
                    } else {
                        this.a(StatisticList.p, i5);
                        this.causeFoodExhaustion(this.dI().spigotConfig.otherMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK);
                    }
                }
            } else if (this.fr()) {
                int i6 = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                this.a(StatisticList.B, i6);
            } else {
                int i7 = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (i7 > 25) {
                    this.a(StatisticList.v, i7);
                }
            }
        }
    }

    private void s(double dx, double dy, double dz) {
        int i2;
        if (this.bM() && (i2 = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f)) > 0) {
            Entity entity = this.cW();
            if (entity instanceof EntityMinecartAbstract) {
                this.a(StatisticList.x, i2);
            } else if (entity instanceof EntityBoat) {
                this.a(StatisticList.y, i2);
            } else if (entity instanceof EntityPig) {
                this.a(StatisticList.z, i2);
            } else if (entity instanceof EntityHorseAbstract) {
                this.a(StatisticList.A, i2);
            } else if (entity instanceof EntityStrider) {
                this.a(StatisticList.D, i2);
            }
        }
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (this.cn.c && !this.flyingFallDamage.toBooleanOrElse(false)) {
            return false;
        }
        if (fallDistance >= 2.0f) {
            this.a(StatisticList.t, (int)Math.round((double)fallDistance * 100.0));
        }
        return super.a(fallDistance, damageMultiplier, damageSource);
    }

    public boolean fS() {
        net.minecraft.world.item.ItemStack itemstack;
        if (!this.ay() && !this.fr() && !this.aV() && !this.a(MobEffects.y) && (itemstack = this.c(EnumItemSlot.e)).a(Items.nh) && ItemElytra.d(itemstack)) {
            this.fT();
            return true;
        }
        return false;
    }

    public void fT() {
        if (!CraftEventFactory.callToggleGlideEvent(this, true).isCancelled()) {
            this.b(7, true);
        } else {
            this.b(7, true);
            this.b(7, false);
        }
    }

    public void fU() {
        if (!CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
            this.b(7, true);
            this.b(7, false);
        }
    }

    @Override
    protected void bd() {
        if (!this.G_()) {
            super.bd();
        }
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        if (this.aV()) {
            this.aN();
            this.b(state);
        } else {
            BlockPosition blockposition1 = this.e(pos);
            if (!pos.equals(blockposition1)) {
                IBlockData iblockdata1 = this.dI().a_(blockposition1);
                if (iblockdata1.a(TagsBlock.bm)) {
                    this.a(iblockdata1, state);
                } else {
                    super.b(blockposition1, iblockdata1);
                }
            } else {
                super.b(pos, state);
            }
        }
    }

    @Override
    public EntityLiving.a eC() {
        return new EntityLiving.a(SoundEffects.sF, SoundEffects.sv);
    }

    @Override
    public boolean a(WorldServer world, EntityLiving other) {
        this.b(StatisticList.g.b(other.ae()));
        return true;
    }

    @Override
    public void a(IBlockData state, Vec3D multiplier) {
        if (!this.cn.b) {
            super.a(state, multiplier);
        }
    }

    public void d(int experience) {
        this.s(experience);
        this.cg += (float)experience / (float)this.fW();
        this.cf = MathHelper.a(this.cf + experience, 0, Integer.MAX_VALUE);
        while (this.cg < 0.0f) {
            float f2 = this.cg * (float)this.fW();
            if (this.ce > 0) {
                this.c(-1);
                this.cg = 1.0f + f2 / (float)this.fW();
                continue;
            }
            this.c(-1);
            this.cg = 0.0f;
        }
        while (this.cg >= 1.0f) {
            this.cg = (this.cg - 1.0f) * (float)this.fW();
            this.c(1);
            this.cg /= (float)this.fW();
        }
    }

    public int fV() {
        return this.ch;
    }

    public void a(net.minecraft.world.item.ItemStack enchantedItem, int experienceLevels) {
        this.ce -= experienceLevels;
        if (this.ce < 0) {
            this.ce = 0;
            this.cg = 0.0f;
            this.cf = 0;
        }
        this.ch = this.af.f();
    }

    public void c(int levels) {
        this.ce += levels;
        if (this.ce < 0) {
            this.ce = 0;
            this.cg = 0.0f;
            this.cf = 0;
        }
        if (levels > 0 && this.ce % 5 == 0 && (float)this.co < (float)this.ag - 100.0f) {
            float f2 = this.ce > 30 ? 1.0f : (float)this.ce / 30.0f;
            this.dI().a((EntityHuman)null, this.dn(), this.dp(), this.dt(), SoundEffects.sE, this.cY(), f2 * 0.75f, 1.0f);
            this.co = this.ag;
        }
    }

    public int fW() {
        return this.ce >= 30 ? 112 + (this.ce - 30) * 9 : (this.ce >= 15 ? 37 + (this.ce - 15) * 5 : 7 + this.ce * 2);
    }

    private static void sendSoundEffect(EntityHuman fromEntity, double x2, double y2, double z2, SoundEffect soundEffect, SoundCategory soundCategory, float volume, float pitch) {
        fromEntity.dI().a(fromEntity, x2, y2, z2, soundEffect, soundCategory, volume, pitch);
        if (fromEntity instanceof EntityPlayer) {
            ((EntityPlayer)fromEntity).c.a(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.c.d(soundEffect), soundCategory, x2, y2, z2, volume, pitch, fromEntity.af.g()));
        }
    }

    public void z(float exhaustion) {
        this.causeFoodExhaustion(exhaustion, EntityExhaustionEvent.ExhaustionReason.UNKNOWN);
    }

    public void causeFoodExhaustion(float f2, EntityExhaustionEvent.ExhaustionReason reason) {
        EntityExhaustionEvent event;
        if (!(this.cn.a || this.dI().B || (event = CraftEventFactory.callPlayerExhaustionEvent(this, reason, f2)).isCancelled())) {
            this.bS.a(event.getExhaustion());
        }
    }

    public Optional<WardenSpawnTracker> W() {
        return Optional.empty();
    }

    public FoodMetaData fX() {
        return this.bS;
    }

    public boolean t(boolean ignoreHunger) {
        return this.cn.a || ignoreHunger || this.bS.c();
    }

    public boolean fY() {
        return this.er() > 0.0f && this.er() < this.eI();
    }

    public boolean fZ() {
        return this.cn.e;
    }

    public boolean a(BlockPosition pos, EnumDirection facing, net.minecraft.world.item.ItemStack stack) {
        if (this.cn.e) {
            return true;
        }
        BlockPosition blockposition1 = pos.a(facing.g());
        ShapeDetectorBlock shapedetectorblock = new ShapeDetectorBlock(this.dI(), blockposition1, false);
        return stack.a(this.dI().B_().d(Registries.e), shapedetectorblock);
    }

    @Override
    public int ea() {
        if (!this.dI().X().b(GameRules.d) && !this.G_()) {
            int i2 = this.ce * 7;
            return i2 > 100 ? 100 : i2;
        }
        return 0;
    }

    @Override
    protected boolean eb() {
        return true;
    }

    @Override
    public boolean cz() {
        return true;
    }

    @Override
    protected Entity.MovementEmission aS() {
        return !this.cn.b && (!this.ay() || !this.bS()) ? Entity.MovementEmission.d : Entity.MovementEmission.a;
    }

    public void w() {
    }

    @Override
    public IChatBaseComponent Z() {
        return IChatBaseComponent.b(this.cp.getName());
    }

    public InventoryEnderChest ga() {
        return this.bP;
    }

    @Override
    public net.minecraft.world.item.ItemStack c(EnumItemSlot slot) {
        return slot == EnumItemSlot.a ? this.cl.f() : (slot == EnumItemSlot.b ? this.cl.k.get(0) : (slot.a() == EnumItemSlot.Function.b ? this.cl.j.get(slot.b()) : net.minecraft.world.item.ItemStack.b));
    }

    @Override
    protected boolean a(EnumItemSlot slot) {
        return slot.a() == EnumItemSlot.Function.b;
    }

    @Override
    public void a(EnumItemSlot slot, net.minecraft.world.item.ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, boolean silent) {
        this.e(itemstack);
        if (enumitemslot == EnumItemSlot.a) {
            this.onEquipItem(enumitemslot, this.cl.i.set(this.cl.l, itemstack), itemstack, silent);
        } else if (enumitemslot == EnumItemSlot.b) {
            this.onEquipItem(enumitemslot, this.cl.k.set(0, itemstack), itemstack, silent);
        } else if (enumitemslot.a() == EnumItemSlot.Function.b) {
            this.onEquipItem(enumitemslot, this.cl.j.set(enumitemslot.b(), itemstack), itemstack, silent);
        }
    }

    public boolean i(net.minecraft.world.item.ItemStack stack) {
        return this.cl.e(stack);
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> bI() {
        return Lists.newArrayList((Object[])new net.minecraft.world.item.ItemStack[]{this.eO(), this.eP()});
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> bJ() {
        return this.cl.j;
    }

    public boolean h(NBTTagCompound entityNbt) {
        if (!this.bM() && this.ay() && !this.aV() && !this.az) {
            if (this.ge().g()) {
                this.i(entityNbt);
                this.g = this.dI().V();
                return true;
            }
            if (this.gf().g()) {
                this.j(entityNbt);
                this.g = this.dI().V();
                return true;
            }
            return false;
        }
        return false;
    }

    public void gb() {
        if (this.g + 20L < this.dI().V()) {
            if (this.respawnEntityOnShoulder(this.ge())) {
                this.i(new NBTTagCompound());
            }
            if (this.respawnEntityOnShoulder(this.gf())) {
                this.j(new NBTTagCompound());
            }
        }
    }

    public Entity releaseLeftShoulderEntity() {
        Entity entity = this.respawnEntityOnShoulder0(this.ge());
        if (entity != null) {
            this.i(new NBTTagCompound());
        }
        return entity;
    }

    public Entity releaseRightShoulderEntity() {
        Entity entity = this.respawnEntityOnShoulder0(this.gf());
        if (entity != null) {
            this.j(new NBTTagCompound());
        }
        return entity;
    }

    private boolean respawnEntityOnShoulder(NBTTagCompound nbttagcompound) {
        return this.respawnEntityOnShoulder0(nbttagcompound) != null;
    }

    private Entity respawnEntityOnShoulder0(NBTTagCompound nbttagcompound) {
        if (!this.dI().B && nbttagcompound != null && !nbttagcompound.g()) {
            return EntityTypes.a(nbttagcompound, this.dI()).map(entity -> {
                if (entity instanceof EntityTameableAnimal) {
                    ((EntityTameableAnimal)entity).b(this.ax);
                }
                entity.e(this.dn(), this.dp() + (double)0.7f, this.dt());
                boolean addedToWorld = ((WorldServer)this.dI()).addWithUUID((Entity)entity, CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY);
                return addedToWorld ? entity : null;
            }).orElse(null);
        }
        return null;
    }

    @Override
    public abstract boolean G_();

    @Override
    public boolean bn() {
        return !this.G_() && super.bn();
    }

    @Override
    public boolean bW() {
        return !this.cn.b && !this.G_() && super.bW();
    }

    public abstract boolean f();

    @Override
    public boolean cw() {
        return !this.cn.b;
    }

    public Scoreboard gc() {
        return this.dI().I();
    }

    @Override
    public IChatBaseComponent H_() {
        IChatMutableComponent ichatmutablecomponent = ScoreboardTeam.a(this.cd(), this.Z());
        return this.a(ichatmutablecomponent);
    }

    private IChatMutableComponent a(IChatMutableComponent component) {
        String s2 = this.fM().getName();
        return component.a(chatmodifier -> chatmodifier.a(new ChatClickable(ChatClickable.EnumClickAction.d, "/tell " + s2 + " ")).a(this.cD()).a(s2));
    }

    @Override
    public String cv() {
        return this.fM().getName();
    }

    @Override
    public float b(EntityPose pose, EntitySize dimensions) {
        switch (pose) {
            case d: 
            case b: 
            case e: {
                return 0.4f;
            }
            case f: {
                return 1.27f;
            }
        }
        return 1.62f;
    }

    @Override
    public void y(float amount) {
        if (amount < 0.0f) {
            amount = 0.0f;
        }
        this.aj().b(e, Float.valueOf(amount));
    }

    @Override
    public float ff() {
        return this.aj().b(e).floatValue();
    }

    public boolean a(PlayerModelPart modelPart) {
        return (this.aj().b(bL) & modelPart.a()) == modelPart.a();
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        if (mappedIndex >= 0 && mappedIndex < this.cl.i.size()) {
            return SlotAccess.a(this.cl, mappedIndex);
        }
        int j2 = mappedIndex - 200;
        return j2 >= 0 && j2 < this.bP.b() ? SlotAccess.a(this.bP, j2) : super.a_(mappedIndex);
    }

    public boolean gd() {
        return this.cq;
    }

    public void u(boolean reducedDebugInfo) {
        this.cq = reducedDebugInfo;
    }

    @Override
    public void h(int fireTicks) {
        super.h(this.cn.a ? Math.min(fireTicks, 1) : fireTicks);
    }

    @Override
    public EnumMainHand fh() {
        return this.am.b(bM) == 0 ? EnumMainHand.a : EnumMainHand.b;
    }

    public void a(EnumMainHand arm) {
        this.am.b(bM, (byte)(arm != EnumMainHand.a ? 1 : 0));
    }

    public NBTTagCompound ge() {
        return this.am.b(bN);
    }

    public void i(NBTTagCompound entityNbt) {
        this.am.b(bN, entityNbt);
    }

    public NBTTagCompound gf() {
        return this.am.b(bO);
    }

    public void j(NBTTagCompound entityNbt) {
        this.am.b(bO, entityNbt);
    }

    public float gg() {
        return (float)(1.0 / this.b(GenericAttributes.h) * 20.0);
    }

    public float A(float baseTime) {
        return MathHelper.a(((float)this.aQ + baseTime) / this.gg(), 0.0f, 1.0f);
    }

    public void gh() {
        this.aQ = 0;
    }

    public ItemCooldown gi() {
        return this.cs;
    }

    @Override
    protected float aH() {
        return !this.cn.b && !this.fr() ? super.aH() : 1.0f;
    }

    public float gj() {
        return (float)this.b(GenericAttributes.k);
    }

    public boolean gk() {
        return this.cn.d && this.B() >= 2;
    }

    @Override
    public boolean f(net.minecraft.world.item.ItemStack stack) {
        EnumItemSlot enumitemslot = EntityInsentient.h(stack);
        return this.c(enumitemslot).b();
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return c.getOrDefault((Object)pose, bK);
    }

    @Override
    public ImmutableList<EntityPose> fv() {
        return ImmutableList.of((Object)((Object)EntityPose.a), (Object)((Object)EntityPose.f), (Object)((Object)EntityPose.d));
    }

    protected boolean tryReadyArrow(net.minecraft.world.item.ItemStack bow, net.minecraft.world.item.ItemStack itemstack) {
        return !(this instanceof EntityPlayer) || new PlayerReadyArrowEvent((Player)((EntityPlayer)this).getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(bow), (ItemStack)CraftItemStack.asCraftMirror(itemstack)).callEvent();
    }

    @Override
    public net.minecraft.world.item.ItemStack g(net.minecraft.world.item.ItemStack stack) {
        if (!(stack.d() instanceof ItemProjectileWeapon)) {
            return net.minecraft.world.item.ItemStack.b;
        }
        Predicate<net.minecraft.world.item.ItemStack> predicate = ((ItemProjectileWeapon)stack.d()).e().and(item -> this.tryReadyArrow(stack, (net.minecraft.world.item.ItemStack)item));
        net.minecraft.world.item.ItemStack itemstack1 = ItemProjectileWeapon.a(this, predicate);
        if (!itemstack1.b()) {
            return itemstack1;
        }
        predicate = ((ItemProjectileWeapon)stack.d()).b().and(item -> this.tryReadyArrow(stack, (net.minecraft.world.item.ItemStack)item));
        for (int i2 = 0; i2 < this.cl.b(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack2 = this.cl.a(i2);
            if (!predicate.test(itemstack2)) continue;
            return itemstack2;
        }
        return this.cn.d ? new net.minecraft.world.item.ItemStack(Items.nH) : net.minecraft.world.item.ItemStack.b;
    }

    @Override
    public net.minecraft.world.item.ItemStack a(World world, net.minecraft.world.item.ItemStack stack) {
        this.fX().a(stack.d(), stack);
        this.b(StatisticList.c.b(stack.d()));
        world.a((EntityHuman)null, this.dn(), this.dp(), this.dt(), SoundEffects.sx, SoundCategory.h, 0.5f, world.z.i() * 0.1f + 0.9f);
        if (this instanceof EntityPlayer) {
            CriterionTriggers.z.a((EntityPlayer)this, stack);
        }
        return super.a(world, stack);
    }

    @Override
    protected boolean c(IBlockData landingState) {
        return this.cn.b || super.c(landingState);
    }

    @Override
    public Vec3D q(float delta) {
        float f3;
        double d0 = 0.22 * (this.fh() == EnumMainHand.b ? -1.0 : 1.0);
        float f1 = MathHelper.i(delta * 0.5f, this.dA(), this.N) * ((float)Math.PI / 180);
        float f2 = MathHelper.i(delta, this.aW, this.aV) * ((float)Math.PI / 180);
        if (!this.fr() && !this.fe()) {
            if (this.bX()) {
                return this.l(delta).e(new Vec3D(d0, 0.2, -0.15).a(-f1).b(-f2));
            }
            double d2 = this.cE().c() - 1.0;
            double d1 = this.bU() ? -0.2 : 0.07;
            return this.l(delta).e(new Vec3D(d0, d2, d1).b(-f2));
        }
        Vec3D vec3d = this.f(delta);
        Vec3D vec3d1 = this.dl();
        double d1 = vec3d1.i();
        double d3 = vec3d.i();
        if (d1 > 0.0 && d3 > 0.0) {
            double d4 = (vec3d1.c * vec3d.c + vec3d1.e * vec3d.e) / Math.sqrt(d1 * d3);
            double d5 = vec3d1.c * vec3d.e - vec3d1.e * vec3d.c;
            f3 = (float)(Math.signum(d5) * Math.acos(d4));
        } else {
            f3 = 0.0f;
        }
        return this.l(delta).e(new Vec3D(d0, -0.11, 0.85).c(-f3).a(-f1).b(-f2));
    }

    @Override
    public boolean dH() {
        return true;
    }

    public boolean gl() {
        return this.fi() && this.fk().a(Items.qj);
    }

    @Override
    public boolean dG() {
        return false;
    }

    public Optional<GlobalPos> gm() {
        return this.ct;
    }

    public void a(Optional<GlobalPos> lastDeathPos) {
        this.ct = lastDeathPos;
    }

    @Override
    public float eB() {
        return this.ck;
    }

    @Override
    public void m(float yaw) {
        super.m(yaw);
        this.ck = yaw;
    }

    @Override
    public boolean dB() {
        return true;
    }

    @Override
    protected float eZ() {
        return this.cn.b && !this.bM() ? (this.bV() ? this.cn.a() * 2.0f : this.cn.a()) : (this.bV() ? 0.025999999f : 0.02f);
    }

    public static enum EnumBedResult {
        a,
        b(IChatBaseComponent.c("block.minecraft.bed.no_sleep")),
        c(IChatBaseComponent.c("block.minecraft.bed.too_far_away")),
        d(IChatBaseComponent.c("block.minecraft.bed.obstructed")),
        e,
        f(IChatBaseComponent.c("block.minecraft.bed.not_safe"));

        @Nullable
        private final IChatBaseComponent g;

        private EnumBedResult() {
            this.g = null;
        }

        private EnumBedResult(IChatBaseComponent ichatbasecomponent) {
            this.g = ichatbasecomponent;
        }

        @Nullable
        public IChatBaseComponent a() {
            return this.g;
        }
    }
}

