/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.projectiles.ProjectileSource;

public abstract class IProjectile
extends Entity
implements TraceableEntity {
    @Nullable
    public UUID b;
    @Nullable
    public Entity c;
    public boolean d;
    public boolean e;
    protected boolean hitCancelled = false;

    IProjectile(EntityTypes<? extends IProjectile> type, World world) {
        super(type, world);
    }

    public void b(@Nullable Entity entity) {
        if (entity != null) {
            this.b = entity.ct();
            this.c = entity;
        } else {
            this.b = null;
            this.c = null;
            this.projectileSource = null;
        }
        this.refreshProjectileSource(false);
    }

    public void refreshProjectileSource(boolean fillCache) {
        CraftEntity craftEntity;
        if (fillCache) {
            this.v();
        }
        if (this.c != null && !this.c.dD() && this.projectileSource == null && (craftEntity = this.c.getBukkitEntity()) instanceof ProjectileSource) {
            ProjectileSource projSource;
            this.projectileSource = projSource = (ProjectileSource)craftEntity;
        }
    }

    @Override
    @Nullable
    public Entity v() {
        if (this.c != null && !this.c.dD()) {
            this.refreshProjectileSource(false);
            return this.c;
        }
        if (this.b != null && this.dI() instanceof WorldServer) {
            this.c = ((WorldServer)this.dI()).a(this.b);
            if (this.c == null) {
                for (WorldServer level : this.dI().n().F()) {
                    Entity entity;
                    if (level == this.dI() || (entity = level.a(this.b)) == null) continue;
                    this.c = entity;
                    break;
                }
            }
            this.refreshProjectileSource(false);
            return this.c;
        }
        return null;
    }

    public Entity A() {
        return (Entity)MoreObjects.firstNonNull((Object)this.v(), (Object)this);
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        if (this.b != null) {
            nbt.a("Owner", this.b);
        }
        if (this.d) {
            nbt.a("LeftOwner", true);
        }
        nbt.a("HasBeenShot", this.e);
    }

    protected boolean d(Entity entity) {
        return entity.ct().equals(this.b);
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        if (nbt.b("Owner")) {
            this.b = nbt.a("Owner");
            this.c = null;
            if (this instanceof EntityEnderPearl && this.dI() != null && this.dI().paperConfig().fixes.disableUnloadedChunkEnderpearlExploit) {
                this.b = null;
            }
        }
        this.d = nbt.q("LeftOwner");
        this.e = nbt.q("HasBeenShot");
    }

    @Override
    public void l() {
        if (!this.e) {
            this.a(GameEvent.L, this.v());
            this.e = true;
        }
        if (!this.d) {
            this.d = this.k();
        }
        super.l();
    }

    private boolean k() {
        Entity entity = this.v();
        if (entity != null) {
            for (Entity entity12 : this.dI().a((Entity)this, this.cE().b(this.dl()).g(1.0), (? super Entity entity1) -> !entity1.G_() && entity1.bo())) {
                if (entity12.cT() != entity.cT()) continue;
                return false;
            }
        }
        return true;
    }

    public void c(double x2, double y2, double z2, float speed, float divergence) {
        Vec3D vec3d = new Vec3D(x2, y2, z2).d().b(this.af.a(0.0, 0.0172275 * (double)divergence), this.af.a(0.0, 0.0172275 * (double)divergence), this.af.a(0.0, 0.0172275 * (double)divergence)).a((double)speed);
        this.f(vec3d);
        double d3 = vec3d.h();
        this.a_((float)(MathHelper.d(vec3d.c, vec3d.e) * 57.2957763671875));
        this.b_((float)(MathHelper.d(vec3d.d, d3) * 57.2957763671875));
        this.M = this.dy();
        this.N = this.dA();
    }

    public void a(Entity shooter, float pitch, float yaw, float roll, float speed, float divergence) {
        float f5 = -MathHelper.a(yaw * ((float)Math.PI / 180)) * MathHelper.b(pitch * ((float)Math.PI / 180));
        float f6 = -MathHelper.a((pitch + roll) * ((float)Math.PI / 180));
        float f7 = MathHelper.b(yaw * ((float)Math.PI / 180)) * MathHelper.b(pitch * ((float)Math.PI / 180));
        this.c(f5, f6, f7, speed, divergence);
        Vec3D vec3d = shooter.dl();
        if (!shooter.dI().paperConfig().misc.disableRelativeProjectileVelocity) {
            this.f(this.dl().b(vec3d.c, shooter.ay() ? 0.0 : vec3d.d, vec3d.e));
        }
    }

    public void preOnHit(MovingObjectPosition movingobjectposition) {
        ProjectileHitEvent event = CraftEventFactory.callProjectileHitEvent(this, movingobjectposition);
        boolean bl = this.hitCancelled = event != null && event.isCancelled();
        if (movingobjectposition.c() == MovingObjectPosition.EnumMovingObjectType.b || !this.hitCancelled) {
            this.a(movingobjectposition);
        }
    }

    protected void a(MovingObjectPosition hitResult) {
        MovingObjectPosition.EnumMovingObjectType movingobjectposition_enummovingobjecttype = hitResult.c();
        if (movingobjectposition_enummovingobjecttype == MovingObjectPosition.EnumMovingObjectType.c) {
            this.a((MovingObjectPositionEntity)hitResult);
            this.dI().a(GameEvent.K, hitResult.e(), GameEvent.a.a(this, null));
        } else if (movingobjectposition_enummovingobjecttype == MovingObjectPosition.EnumMovingObjectType.b) {
            MovingObjectPositionBlock movingobjectpositionblock = (MovingObjectPositionBlock)hitResult;
            this.a(movingobjectpositionblock);
            BlockPosition blockposition = movingobjectpositionblock.a();
            this.dI().a(GameEvent.K, blockposition, GameEvent.a.a(this, this.dI().a_(blockposition)));
        }
    }

    protected void a(MovingObjectPositionEntity entityHitResult) {
    }

    protected void a(MovingObjectPositionBlock blockHitResult) {
        if (this.hitCancelled) {
            return;
        }
        IBlockData iblockdata = this.dI().a_(blockHitResult.a());
        iblockdata.a(this.dI(), iblockdata, blockHitResult, this);
    }

    @Override
    public void l(double x2, double y2, double z2) {
        this.o(x2, y2, z2);
        if (this.N == 0.0f && this.M == 0.0f) {
            double d3 = Math.sqrt(x2 * x2 + z2 * z2);
            this.b_((float)(MathHelper.d(y2, d3) * 57.2957763671875));
            this.a_((float)(MathHelper.d(x2, z2) * 57.2957763671875));
            this.N = this.dA();
            this.M = this.dy();
            this.b(this.dn(), this.dp(), this.dt(), this.dy(), this.dA());
        }
    }

    public boolean a(Entity entity) {
        if (!entity.bn()) {
            return false;
        }
        Entity entity1 = this.v();
        if (entity1 instanceof EntityPlayer && entity instanceof EntityPlayer) {
            Player collided = (Player)entity.getBukkitEntity();
            Player shooter = (Player)entity1.getBukkitEntity();
            if (!shooter.canSee(collided)) {
                return false;
            }
        }
        return entity1 == null || this.d || !entity1.v(entity);
    }

    protected void C() {
        Vec3D vec3d = this.dl();
        double d0 = vec3d.h();
        this.b_(IProjectile.d(this.N, (float)(MathHelper.d(vec3d.d, d0) * 57.2957763671875)));
        this.a_(IProjectile.d(this.M, (float)(MathHelper.d(vec3d.c, vec3d.e) * 57.2957763671875)));
    }

    protected static float d(float prevRot, float newRot) {
        prevRot += (float)Math.round((newRot - prevRot) / 360.0f) * 360.0f;
        return MathHelper.i(0.2f, prevRot, newRot);
    }

    @Override
    public Packet<PacketListenerPlayOut> S() {
        Entity entity = this.v();
        return new PacketPlayOutSpawnEntity(this, entity == null ? 0 : entity.af());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        Entity entity = this.dI().a(packet.n());
        if (entity != null) {
            this.b(entity);
        }
    }

    @Override
    public boolean a(World world, BlockPosition pos) {
        Entity entity = this.v();
        return entity instanceof EntityHuman ? entity.a(world, pos) : entity == null || world.X().b(GameRules.c);
    }
}

