/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.entity.vehicle.EntityMinecartCommandBlock;
import net.minecraft.world.entity.vehicle.EntityMinecartFurnace;
import net.minecraft.world.entity.vehicle.EntityMinecartHopper;
import net.minecraft.world.entity.vehicle.EntityMinecartMobSpawner;
import net.minecraft.world.entity.vehicle.EntityMinecartRideable;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.BlockPoweredRail;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.util.Vector;

public abstract class EntityMinecartAbstract
extends Entity {
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> d = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Float> e = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> f = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> g = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> h = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.k);
    private static final ImmutableMap<EntityPose, ImmutableList<Integer>> i = ImmutableMap.of((Object)((Object)EntityPose.a), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)EntityPose.f), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)EntityPose.d), (Object)ImmutableList.of((Object)0, (Object)1));
    protected static final float b = 0.95f;
    private boolean j;
    private boolean k;
    private static final Map<BlockPropertyTrackPosition, Pair<BaseBlockPosition, BaseBlockPosition>> l = SystemUtils.a(Maps.newEnumMap(BlockPropertyTrackPosition.class), enummap -> {
        BaseBlockPosition baseblockposition = EnumDirection.e.q();
        BaseBlockPosition baseblockposition1 = EnumDirection.f.q();
        BaseBlockPosition baseblockposition2 = EnumDirection.c.q();
        BaseBlockPosition baseblockposition3 = EnumDirection.d.q();
        BaseBlockPosition baseblockposition4 = baseblockposition.o();
        BaseBlockPosition baseblockposition5 = baseblockposition1.o();
        BaseBlockPosition baseblockposition6 = baseblockposition2.o();
        BaseBlockPosition baseblockposition7 = baseblockposition3.o();
        enummap.put(BlockPropertyTrackPosition.a, Pair.of((Object)baseblockposition2, (Object)baseblockposition3));
        enummap.put(BlockPropertyTrackPosition.b, Pair.of((Object)baseblockposition, (Object)baseblockposition1));
        enummap.put(BlockPropertyTrackPosition.c, Pair.of((Object)baseblockposition4, (Object)baseblockposition1));
        enummap.put(BlockPropertyTrackPosition.d, Pair.of((Object)baseblockposition, (Object)baseblockposition5));
        enummap.put(BlockPropertyTrackPosition.e, Pair.of((Object)baseblockposition2, (Object)baseblockposition7));
        enummap.put(BlockPropertyTrackPosition.f, Pair.of((Object)baseblockposition6, (Object)baseblockposition3));
        enummap.put(BlockPropertyTrackPosition.g, Pair.of((Object)baseblockposition3, (Object)baseblockposition1));
        enummap.put(BlockPropertyTrackPosition.h, Pair.of((Object)baseblockposition3, (Object)baseblockposition));
        enummap.put(BlockPropertyTrackPosition.i, Pair.of((Object)baseblockposition2, (Object)baseblockposition));
        enummap.put(BlockPropertyTrackPosition.j, Pair.of((Object)baseblockposition2, (Object)baseblockposition1));
    });
    private int m;
    private double n;
    private double o;
    private double p;
    private double q;
    private double r;
    private double s;
    private double t;
    private double u;
    public boolean slowWhenEmpty = true;
    private double derailedX = 0.5;
    private double derailedY = 0.5;
    private double derailedZ = 0.5;
    private double flyingX = 0.95f;
    private double flyingY = 0.95f;
    private double flyingZ = 0.95f;
    public double maxSpeed = 0.4;

    protected EntityMinecartAbstract(EntityTypes<?> type, World world) {
        super(type, world);
        this.H = true;
    }

    protected EntityMinecartAbstract(EntityTypes<?> type, World world, double x2, double y2, double z2) {
        this(type, world);
        this.e(x2, y2, z2);
        this.J = x2;
        this.K = y2;
        this.L = z2;
    }

    public static EntityMinecartAbstract a(World world, double x2, double y2, double z2, EnumMinecartType type) {
        return type == EnumMinecartType.b ? new EntityMinecartChest(world, x2, y2, z2) : (type == EnumMinecartType.c ? new EntityMinecartFurnace(world, x2, y2, z2) : (type == EnumMinecartType.d ? new EntityMinecartTNT(world, x2, y2, z2) : (type == EnumMinecartType.e ? new EntityMinecartMobSpawner(world, x2, y2, z2) : (type == EnumMinecartType.f ? new EntityMinecartHopper(world, x2, y2, z2) : (type == EnumMinecartType.g ? new EntityMinecartCommandBlock(world, x2, y2, z2) : new EntityMinecartRideable(world, x2, y2, z2))))));
    }

    @Override
    protected Entity.MovementEmission aS() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected void a_() {
        this.am.a(c, 0);
        this.am.a(d, 1);
        this.am.a(e, Float.valueOf(0.0f));
        this.am.a(f, Block.i(Blocks.a.n()));
        this.am.a(g, 6);
        this.am.a(h, false);
    }

    @Override
    public boolean h(Entity other) {
        boolean collides = EntityBoat.a(this, other);
        if (!collides) {
            return false;
        }
        VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)other.getBukkitEntity());
        return collisionEvent.callEvent();
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return true;
    }

    @Override
    protected Vec3D a(EnumDirection.EnumAxis portalAxis, BlockUtil.Rectangle portalRect) {
        return EntityLiving.i(super.a(portalAxis, portalRect));
    }

    @Override
    public double bx() {
        return 0.0;
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        EnumDirection enumdirection = this.cC();
        if (enumdirection.o() == EnumDirection.EnumAxis.b) {
            return super.b(passenger);
        }
        int[][] aint = DismountUtil.a(enumdirection);
        BlockPosition blockposition = this.di();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        ImmutableList<EntityPose> immutablelist = passenger.fv();
        for (EntityPose entitypose : immutablelist) {
            EntitySize entitysize = passenger.a(entitypose);
            float f2 = Math.min(entitysize.a, 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableiterator1 = ((ImmutableList)i.get((Object)entitypose)).iterator();
            while (unmodifiableiterator1.hasNext()) {
                int i2 = (Integer)unmodifiableiterator1.next();
                int[][] aint1 = aint;
                int j2 = aint.length;
                for (int k2 = 0; k2 < j2; ++k2) {
                    int[] aint2 = aint1[k2];
                    blockposition_mutableblockposition.d(blockposition.u() + aint2[0], blockposition.v() + i2, blockposition.w() + aint2[1]);
                    double d0 = this.dI().a(DismountUtil.a((IBlockAccess)this.dI(), (BlockPosition)blockposition_mutableblockposition), () -> DismountUtil.a((IBlockAccess)this.dI(), blockposition_mutableblockposition.d()));
                    if (!DismountUtil.a(d0)) continue;
                    AxisAlignedBB axisalignedbb = new AxisAlignedBB(-f2, 0.0, -f2, f2, entitysize.b, f2);
                    Vec3D vec3d = Vec3D.a(blockposition_mutableblockposition, d0);
                    if (!DismountUtil.a(this.dI(), passenger, axisalignedbb.c(vec3d))) continue;
                    passenger.b(entitypose);
                    return vec3d;
                }
            }
        }
        double d1 = this.cE().e;
        blockposition_mutableblockposition.b((double)blockposition.u(), d1, (double)blockposition.w());
        for (EntityPose entitypose1 : immutablelist) {
            double d2 = passenger.a((EntityPose)entitypose1).b;
            int l2 = MathHelper.c(d1 - (double)blockposition_mutableblockposition.v() + d2);
            double d3 = DismountUtil.a(blockposition_mutableblockposition, l2, blockposition1 -> this.dI().a_((BlockPosition)blockposition1).k(this.dI(), (BlockPosition)blockposition1));
            if (!(d1 + d2 <= d3)) continue;
            passenger.b(entitypose1);
            break;
        }
        return super.b(passenger);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (!this.dI().B && !this.dD()) {
            boolean flag;
            if (this.b(source)) {
                return false;
            }
            Vehicle vehicle = (Vehicle)this.getBukkitEntity();
            CraftEntity passenger = source.d() == null ? null : source.d().getBukkitEntity();
            VehicleDamageEvent event = new VehicleDamageEvent(vehicle, (org.bukkit.entity.Entity)passenger, (double)amount);
            this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            amount = (float)event.getDamage();
            this.d(-this.s());
            this.c(10);
            this.bl();
            this.a(this.q() + amount * 10.0f);
            this.a(GameEvent.o, source.d());
            boolean bl = flag = source.d() instanceof EntityHuman && ((EntityHuman)source.d()).fO().d;
            if (flag || this.q() > 40.0f) {
                VehicleDestroyEvent destroyEvent = new VehicleDestroyEvent(vehicle, (org.bukkit.entity.Entity)passenger);
                this.dI().getCraftServer().getPluginManager().callEvent((Event)destroyEvent);
                if (destroyEvent.isCancelled()) {
                    this.a(40.0f);
                    return true;
                }
                this.bz();
                if (flag && !this.aa()) {
                    this.ai();
                } else {
                    this.a(source);
                }
            }
            return true;
        }
        return true;
    }

    @Override
    protected float aH() {
        IBlockData iblockdata = this.dI().a_(this.di());
        return iblockdata.a(TagsBlock.N) ? 1.0f : super.aH();
    }

    public void a(DamageSource damageSource) {
        this.ah();
        if (this.dI().X().b(GameRules.h)) {
            ItemStack itemstack = new ItemStack(this.j());
            if (this.aa()) {
                itemstack.a(this.ab());
            }
            this.b(itemstack);
        }
    }

    abstract Item j();

    @Override
    public void m(float yaw) {
        this.d(-this.s());
        this.c(10);
        this.a(this.q() + this.q() * 10.0f);
    }

    @Override
    public boolean bo() {
        return !this.dD();
    }

    private static Pair<BaseBlockPosition, BaseBlockPosition> a(BlockPropertyTrackPosition shape) {
        return l.get(shape);
    }

    @Override
    public EnumDirection cC() {
        return this.j ? this.cB().g().h() : this.cB().h();
    }

    @Override
    public void l() {
        double prevX = this.dn();
        double prevY = this.dp();
        double prevZ = this.dt();
        float prevYaw = this.dy();
        float prevPitch = this.dA();
        if (this.r() > 0) {
            this.c(this.r() - 1);
        }
        if (this.q() > 0.0f) {
            this.a(this.q() - 1.0f);
        }
        this.ap();
        if (this.dI().B) {
            if (this.m > 0) {
                double d0 = this.dn() + (this.n - this.dn()) / (double)this.m;
                double d1 = this.dp() + (this.o - this.dp()) / (double)this.m;
                double d2 = this.dt() + (this.p - this.dt()) / (double)this.m;
                double d3 = MathHelper.d(this.q - (double)this.dy());
                this.a_(this.dy() + (float)d3 / (float)this.m);
                this.b_(this.dA() + (float)(this.r - (double)this.dA()) / (float)this.m);
                --this.m;
                this.e(d0, d1, d2);
                this.a(this.dy(), this.dA());
            } else {
                this.an();
                this.a(this.dy(), this.dA());
            }
        } else {
            double d6;
            if (!this.aR()) {
                double d0 = this.aV() ? -0.005 : -0.04;
                this.f(this.dl().b(0.0, d0, 0.0));
            }
            int i2 = MathHelper.a(this.dn());
            int j2 = MathHelper.a(this.dp());
            int k2 = MathHelper.a(this.dt());
            if (this.dI().a_(new BlockPosition(i2, j2 - 1, k2)).a(TagsBlock.N)) {
                --j2;
            }
            BlockPosition blockposition = new BlockPosition(i2, j2, k2);
            IBlockData iblockdata = this.dI().a_(blockposition);
            this.k = BlockMinecartTrackAbstract.g(iblockdata);
            if (this.k) {
                this.c(blockposition, iblockdata);
                if (iblockdata.a(Blocks.hh)) {
                    this.a(i2, j2, k2, iblockdata.c(BlockPoweredRail.e));
                }
            } else {
                this.o();
            }
            this.aM();
            this.b_(0.0f);
            double d4 = this.J - this.dn();
            double d5 = this.L - this.dt();
            if (d4 * d4 + d5 * d5 > 0.001) {
                this.a_((float)(MathHelper.d(d5, d4) * 180.0 / Math.PI));
                if (this.j) {
                    this.a_(this.dy() + 180.0f);
                }
            }
            if ((d6 = (double)MathHelper.g(this.dy() - this.M)) < -170.0 || d6 >= 170.0) {
                this.a_(this.dy() + 180.0f);
                this.j = !this.j;
            }
            this.a(this.dy(), this.dA());
            CraftWorld bworld = this.dI().getWorld();
            Location from = new Location((org.bukkit.World)bworld, prevX, prevY, prevZ, prevYaw, prevPitch);
            Location to = CraftLocation.toBukkit(this.dg(), (org.bukkit.World)bworld, this.dy(), this.dA());
            Vehicle vehicle = (Vehicle)this.getBukkitEntity();
            this.dI().getCraftServer().getPluginManager().callEvent((Event)new VehicleUpdateEvent(vehicle));
            if (!from.equals((Object)to)) {
                this.dI().getCraftServer().getPluginManager().callEvent((Event)new VehicleMoveEvent(vehicle, from, to));
            }
            if (this.t() == EnumMinecartType.a && this.dl().i() > 0.01) {
                List<Entity> list = this.dI().a((Entity)this, this.cE().c(0.2f, 0.0, 0.2f), IEntitySelector.a(this));
                if (!list.isEmpty()) {
                    for (int l2 = 0; l2 < list.size(); ++l2) {
                        VehicleEntityCollisionEvent collisionEvent;
                        Entity entity = list.get(l2);
                        if (!(entity instanceof EntityHuman || entity instanceof EntityIronGolem || entity instanceof EntityMinecartAbstract || this.bN() || entity.bM())) {
                            collisionEvent = new VehicleEntityCollisionEvent(vehicle, (org.bukkit.entity.Entity)entity.getBukkitEntity());
                            this.dI().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                            if (collisionEvent.isCancelled()) continue;
                            entity.k(this);
                            continue;
                        }
                        if (!this.v(entity)) {
                            collisionEvent = new VehicleEntityCollisionEvent(vehicle, (org.bukkit.entity.Entity)entity.getBukkitEntity());
                            this.dI().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                            if (collisionEvent.isCancelled()) continue;
                        }
                        entity.g(this);
                    }
                }
            } else {
                for (Entity entity1 : this.dI().a_(this, this.cE().c(0.2f, 0.0, 0.2f))) {
                    if (this.u(entity1) || !entity1.bp() || !(entity1 instanceof EntityMinecartAbstract)) continue;
                    VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent(vehicle, (org.bukkit.entity.Entity)entity1.getBukkitEntity());
                    this.dI().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                    if (collisionEvent.isCancelled()) continue;
                    entity1.g(this);
                }
            }
            this.bb();
            if (this.bi()) {
                this.au();
                this.aa *= 0.5f;
            }
            this.al = false;
        }
    }

    protected double k() {
        return this.aV() ? this.maxSpeed / 2.0 : this.maxSpeed;
    }

    public void a(int x2, int y2, int z2, boolean powered) {
    }

    protected void o() {
        double d0 = this.k();
        Vec3D vec3d = this.dl();
        this.o(MathHelper.a(vec3d.c, -d0, d0), vec3d.d, MathHelper.a(vec3d.e, -d0, d0));
        if (this.ay()) {
            this.f(new Vec3D(this.dl().c * this.derailedX, this.dl().d * this.derailedY, this.dl().e * this.derailedZ));
        }
        this.a(EnumMoveType.a, this.dl());
        if (!this.ay()) {
            this.f(new Vec3D(this.dl().c * this.flyingX, this.dl().d * this.flyingY, this.dl().e * this.flyingZ));
        }
    }

    protected void c(BlockPosition pos, IBlockData state) {
        double d18;
        Vec3D vec3d4;
        double d17;
        double d16;
        double d15;
        this.n();
        double d0 = this.dn();
        double d1 = this.dp();
        double d2 = this.dt();
        Vec3D vec3d = this.q(d0, d1, d2);
        d1 = pos.v();
        boolean flag = false;
        boolean flag1 = false;
        if (state.a(Blocks.bp)) {
            flag = state.c(BlockPoweredRail.e);
            flag1 = !flag;
        }
        double d3 = 0.0078125;
        if (this.aV()) {
            d3 *= 0.2;
        }
        Vec3D vec3d1 = this.dl();
        BlockPropertyTrackPosition blockpropertytrackposition = state.c(((BlockMinecartTrackAbstract)state.b()).b());
        switch (blockpropertytrackposition) {
            case c: {
                this.f(vec3d1.b(-d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case d: {
                this.f(vec3d1.b(d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case e: {
                this.f(vec3d1.b(0.0, 0.0, d3));
                d1 += 1.0;
                break;
            }
            case f: {
                this.f(vec3d1.b(0.0, 0.0, -d3));
                d1 += 1.0;
            }
        }
        vec3d1 = this.dl();
        Pair<BaseBlockPosition, BaseBlockPosition> pair = EntityMinecartAbstract.a(blockpropertytrackposition);
        BaseBlockPosition baseblockposition = (BaseBlockPosition)pair.getFirst();
        BaseBlockPosition baseblockposition1 = (BaseBlockPosition)pair.getSecond();
        double d4 = baseblockposition1.u() - baseblockposition.u();
        double d5 = baseblockposition1.w() - baseblockposition.w();
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = vec3d1.c * d4 + vec3d1.e * d5;
        if (d7 < 0.0) {
            d4 = -d4;
            d5 = -d5;
        }
        double d8 = Math.min(2.0, vec3d1.h());
        vec3d1 = new Vec3D(d8 * d4 / d6, vec3d1.d, d8 * d5 / d6);
        this.f(vec3d1);
        Entity entity = this.cO();
        if (entity instanceof EntityHuman) {
            Vec3D vec3d2 = entity.dl();
            double d9 = vec3d2.i();
            double d10 = this.dl().i();
            if (d9 > 1.0E-4 && d10 < 0.01) {
                this.f(this.dl().b(vec3d2.c * 0.1, 0.0, vec3d2.e * 0.1));
                flag1 = false;
            }
        }
        if (flag1) {
            double d11 = this.dl().h();
            if (d11 < 0.03) {
                this.f(Vec3D.b);
            } else {
                this.f(this.dl().d(0.5, 0.0, 0.5));
            }
        }
        double d11 = (double)pos.u() + 0.5 + (double)baseblockposition.u() * 0.5;
        double d12 = (double)pos.w() + 0.5 + (double)baseblockposition.w() * 0.5;
        double d13 = (double)pos.u() + 0.5 + (double)baseblockposition1.u() * 0.5;
        double d14 = (double)pos.w() + 0.5 + (double)baseblockposition1.w() * 0.5;
        d4 = d13 - d11;
        d5 = d14 - d12;
        if (d4 == 0.0) {
            d15 = d2 - (double)pos.w();
        } else if (d5 == 0.0) {
            d15 = d0 - (double)pos.u();
        } else {
            d16 = d0 - d11;
            d17 = d2 - d12;
            d15 = (d16 * d4 + d17 * d5) * 2.0;
        }
        d0 = d11 + d4 * d15;
        d2 = d12 + d5 * d15;
        this.e(d0, d1, d2);
        d16 = this.bN() ? 0.75 : 1.0;
        d17 = this.k();
        vec3d1 = this.dl();
        this.a(EnumMoveType.a, new Vec3D(MathHelper.a(d16 * vec3d1.c, -d17, d17), 0.0, MathHelper.a(d16 * vec3d1.e, -d17, d17)));
        if (baseblockposition.v() != 0 && MathHelper.a(this.dn()) - pos.u() == baseblockposition.u() && MathHelper.a(this.dt()) - pos.w() == baseblockposition.w()) {
            this.e(this.dn(), this.dp() + (double)baseblockposition.v(), this.dt());
        } else if (baseblockposition1.v() != 0 && MathHelper.a(this.dn()) - pos.u() == baseblockposition1.u() && MathHelper.a(this.dt()) - pos.w() == baseblockposition1.w()) {
            this.e(this.dn(), this.dp() + (double)baseblockposition1.v(), this.dt());
        }
        this.p();
        Vec3D vec3d3 = this.q(this.dn(), this.dp(), this.dt());
        if (vec3d3 != null && vec3d != null) {
            double d19 = (vec3d.d - vec3d3.d) * 0.05;
            vec3d4 = this.dl();
            d18 = vec3d4.h();
            if (d18 > 0.0) {
                this.f(vec3d4.d((d18 + d19) / d18, 1.0, (d18 + d19) / d18));
            }
            this.e(this.dn(), vec3d3.d, this.dt());
        }
        int i2 = MathHelper.a(this.dn());
        int j2 = MathHelper.a(this.dt());
        if (i2 != pos.u() || j2 != pos.w()) {
            vec3d4 = this.dl();
            d18 = vec3d4.h();
            this.o(d18 * (double)(i2 - pos.u()), vec3d4.d, d18 * (double)(j2 - pos.w()));
        }
        if (flag) {
            vec3d4 = this.dl();
            d18 = vec3d4.h();
            if (d18 > 0.01) {
                double d20 = 0.06;
                this.f(vec3d4.b(vec3d4.c / d18 * 0.06, 0.0, vec3d4.e / d18 * 0.06));
            } else {
                Vec3D vec3d5 = this.dl();
                double d21 = vec3d5.c;
                double d22 = vec3d5.e;
                if (blockpropertytrackposition == BlockPropertyTrackPosition.b) {
                    if (this.a(pos.g())) {
                        d21 = 0.02;
                    } else if (this.a(pos.h())) {
                        d21 = -0.02;
                    }
                } else {
                    if (blockpropertytrackposition != BlockPropertyTrackPosition.a) {
                        return;
                    }
                    if (this.a(pos.e())) {
                        d22 = 0.02;
                    } else if (this.a(pos.f())) {
                        d22 = -0.02;
                    }
                }
                this.o(d21, vec3d5.d, d22);
            }
        }
    }

    @Override
    public boolean cc() {
        return this.k;
    }

    private boolean a(BlockPosition pos) {
        return this.dI().a_(pos).g(this.dI(), pos);
    }

    protected void p() {
        double d0 = this.bN() || !this.slowWhenEmpty ? 0.997 : 0.96;
        Vec3D vec3d = this.dl();
        vec3d = vec3d.d(d0, 0.0, d0);
        if (this.aV()) {
            vec3d = vec3d.a((double)0.95f);
        }
        this.f(vec3d);
    }

    @Nullable
    public Vec3D a(double x2, double y2, double z2, double offset) {
        IBlockData iblockdata;
        int i2 = MathHelper.a(x2);
        int j2 = MathHelper.a(y2);
        int k2 = MathHelper.a(z2);
        if (this.dI().a_(new BlockPosition(i2, j2 - 1, k2)).a(TagsBlock.N)) {
            --j2;
        }
        if (BlockMinecartTrackAbstract.g(iblockdata = this.dI().a_(new BlockPosition(i2, j2, k2)))) {
            BlockPropertyTrackPosition blockpropertytrackposition = iblockdata.c(((BlockMinecartTrackAbstract)iblockdata.b()).b());
            y2 = j2;
            if (blockpropertytrackposition.b()) {
                y2 = j2 + 1;
            }
            Pair<BaseBlockPosition, BaseBlockPosition> pair = EntityMinecartAbstract.a(blockpropertytrackposition);
            BaseBlockPosition baseblockposition = (BaseBlockPosition)pair.getFirst();
            BaseBlockPosition baseblockposition1 = (BaseBlockPosition)pair.getSecond();
            double d4 = baseblockposition1.u() - baseblockposition.u();
            double d5 = baseblockposition1.w() - baseblockposition.w();
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            if (baseblockposition.v() != 0 && MathHelper.a(x2 += (d4 /= d6) * offset) - i2 == baseblockposition.u() && MathHelper.a(z2 += (d5 /= d6) * offset) - k2 == baseblockposition.w()) {
                y2 += (double)baseblockposition.v();
            } else if (baseblockposition1.v() != 0 && MathHelper.a(x2) - i2 == baseblockposition1.u() && MathHelper.a(z2) - k2 == baseblockposition1.w()) {
                y2 += (double)baseblockposition1.v();
            }
            return this.q(x2, y2, z2);
        }
        return null;
    }

    @Nullable
    public Vec3D q(double x2, double y2, double z2) {
        IBlockData iblockdata;
        int i2 = MathHelper.a(x2);
        int j2 = MathHelper.a(y2);
        int k2 = MathHelper.a(z2);
        if (this.dI().a_(new BlockPosition(i2, j2 - 1, k2)).a(TagsBlock.N)) {
            --j2;
        }
        if (BlockMinecartTrackAbstract.g(iblockdata = this.dI().a_(new BlockPosition(i2, j2, k2)))) {
            double d12;
            BlockPropertyTrackPosition blockpropertytrackposition = iblockdata.c(((BlockMinecartTrackAbstract)iblockdata.b()).b());
            Pair<BaseBlockPosition, BaseBlockPosition> pair = EntityMinecartAbstract.a(blockpropertytrackposition);
            BaseBlockPosition baseblockposition = (BaseBlockPosition)pair.getFirst();
            BaseBlockPosition baseblockposition1 = (BaseBlockPosition)pair.getSecond();
            double d3 = (double)i2 + 0.5 + (double)baseblockposition.u() * 0.5;
            double d4 = (double)j2 + 0.0625 + (double)baseblockposition.v() * 0.5;
            double d5 = (double)k2 + 0.5 + (double)baseblockposition.w() * 0.5;
            double d6 = (double)i2 + 0.5 + (double)baseblockposition1.u() * 0.5;
            double d7 = (double)j2 + 0.0625 + (double)baseblockposition1.v() * 0.5;
            double d8 = (double)k2 + 0.5 + (double)baseblockposition1.w() * 0.5;
            double d9 = d6 - d3;
            double d10 = (d7 - d4) * 2.0;
            double d11 = d8 - d5;
            if (d9 == 0.0) {
                d12 = z2 - (double)k2;
            } else if (d11 == 0.0) {
                d12 = x2 - (double)i2;
            } else {
                double d13 = x2 - d3;
                double d14 = z2 - d5;
                d12 = (d13 * d9 + d14 * d11) * 2.0;
            }
            x2 = d3 + d9 * d12;
            y2 = d4 + d10 * d12;
            z2 = d5 + d11 * d12;
            if (d10 < 0.0) {
                y2 += 1.0;
            } else if (d10 > 0.0) {
                y2 += 0.5;
            }
            return new Vec3D(x2, y2, z2);
        }
        return null;
    }

    @Override
    public AxisAlignedBB j_() {
        AxisAlignedBB axisalignedbb = this.cE();
        return this.z() ? axisalignedbb.g((double)Math.abs(this.x()) / 16.0) : axisalignedbb;
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        if (nbt.q("CustomDisplayTile")) {
            this.c(GameProfileSerializer.a(this.dI().a(Registries.e), nbt.p("DisplayState")));
            this.m(nbt.h("DisplayOffset"));
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        if (this.z()) {
            nbt.a("CustomDisplayTile", true);
            nbt.a("DisplayState", GameProfileSerializer.a(this.v()));
            nbt.a("DisplayOffset", this.x());
        }
    }

    @Override
    public void g(Entity entity) {
        if (!(this.dI().B || entity.ae || this.ae)) {
            if (!this.dI().paperConfig().collisions.allowVehicleCollisions && this.dI().paperConfig().collisions.onlyPlayersCollide && !(entity instanceof EntityHuman)) {
                return;
            }
            if (!this.u(entity)) {
                double d1;
                VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                this.dI().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                if (collisionEvent.isCancelled()) {
                    return;
                }
                double d0 = entity.dn() - this.dn();
                double d2 = d0 * d0 + (d1 = entity.dt() - this.dt()) * d1;
                if (d2 >= (double)1.0E-4f) {
                    d2 = Math.sqrt(d2);
                    d0 /= d2;
                    d1 /= d2;
                    double d3 = 1.0 / d2;
                    if (d3 > 1.0) {
                        d3 = 1.0;
                    }
                    d0 *= d3;
                    d1 *= d3;
                    d0 *= (double)0.1f;
                    d1 *= (double)0.1f;
                    d0 *= 0.5;
                    d1 *= 0.5;
                    if (entity instanceof EntityMinecartAbstract) {
                        Vec3D vec3d1;
                        double d5;
                        double d4 = entity.dn() - this.dn();
                        Vec3D vec3d = new Vec3D(d4, 0.0, d5 = entity.dt() - this.dt()).d();
                        double d6 = Math.abs(vec3d.b(vec3d1 = new Vec3D(MathHelper.b(this.dy() * ((float)Math.PI / 180)), 0.0, MathHelper.a(this.dy() * ((float)Math.PI / 180))).d()));
                        if (d6 < (double)0.8f) {
                            return;
                        }
                        Vec3D vec3d2 = this.dl();
                        Vec3D vec3d3 = entity.dl();
                        if (((EntityMinecartAbstract)entity).t() == EnumMinecartType.c && this.t() != EnumMinecartType.c) {
                            this.f(vec3d2.d(0.2, 1.0, 0.2));
                            this.j(vec3d3.c - d0, 0.0, vec3d3.e - d1);
                            entity.f(vec3d3.d(0.95, 1.0, 0.95));
                        } else if (((EntityMinecartAbstract)entity).t() != EnumMinecartType.c && this.t() == EnumMinecartType.c) {
                            entity.f(vec3d3.d(0.2, 1.0, 0.2));
                            entity.j(vec3d2.c + d0, 0.0, vec3d2.e + d1);
                            this.f(vec3d2.d(0.95, 1.0, 0.95));
                        } else {
                            double d7 = (vec3d3.c + vec3d2.c) / 2.0;
                            double d8 = (vec3d3.e + vec3d2.e) / 2.0;
                            this.f(vec3d2.d(0.2, 1.0, 0.2));
                            this.j(d7 - d0, 0.0, d8 - d1);
                            entity.f(vec3d3.d(0.2, 1.0, 0.2));
                            entity.j(d7 + d0, 0.0, d8 + d1);
                        }
                    } else {
                        this.j(-d0, 0.0, -d1);
                        entity.j(d0 / 4.0, 0.0, d1 / 4.0);
                    }
                }
            }
        }
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.n = x2;
        this.o = y2;
        this.p = z2;
        this.q = yaw;
        this.r = pitch;
        this.m = interpolationSteps + 2;
        this.o(this.s, this.t, this.u);
    }

    @Override
    public void l(double x2, double y2, double z2) {
        this.s = x2;
        this.t = y2;
        this.u = z2;
        this.o(this.s, this.t, this.u);
    }

    public void a(float damageWobbleStrength) {
        this.am.b(e, Float.valueOf(damageWobbleStrength));
    }

    public float q() {
        return this.am.b(e).floatValue();
    }

    public void c(int wobbleTicks) {
        this.am.b(c, wobbleTicks);
    }

    public int r() {
        return this.am.b(c);
    }

    public void d(int wobbleSide) {
        this.am.b(d, wobbleSide);
    }

    public int s() {
        return this.am.b(d);
    }

    public abstract EnumMinecartType t();

    public IBlockData v() {
        return !this.z() ? this.w() : Block.a(this.aj().b(f));
    }

    public IBlockData w() {
        return Blocks.a.n();
    }

    public int x() {
        return !this.z() ? this.y() : this.aj().b(g).intValue();
    }

    public int y() {
        return 6;
    }

    public void c(IBlockData state) {
        this.aj().b(f, Block.i(state));
        this.a(true);
    }

    public void m(int offset) {
        this.aj().b(g, offset);
        this.a(true);
    }

    public boolean z() {
        return this.aj().b(h);
    }

    public void a(boolean present) {
        this.aj().b(h, present);
    }

    @Override
    public ItemStack dv() {
        return new ItemStack(switch (this.t()) {
            case EnumMinecartType.c -> Items.nc;
            case EnumMinecartType.b -> Items.nb;
            case EnumMinecartType.d -> Items.nd;
            case EnumMinecartType.f -> Items.ne;
            case EnumMinecartType.g -> Items.tS;
            default -> Items.na;
        });
    }

    public Vector getFlyingVelocityMod() {
        return new Vector(this.flyingX, this.flyingY, this.flyingZ);
    }

    public void setFlyingVelocityMod(Vector flying) {
        this.flyingX = flying.getX();
        this.flyingY = flying.getY();
        this.flyingZ = flying.getZ();
    }

    public Vector getDerailedVelocityMod() {
        return new Vector(this.derailedX, this.derailedY, this.derailedZ);
    }

    public void setDerailedVelocityMod(Vector derailed) {
        this.derailedX = derailed.getX();
        this.derailedY = derailed.getY();
        this.derailedZ = derailed.getZ();
    }

    public static enum EnumMinecartType {
        a,
        b,
        c,
        d,
        e,
        f,
        g;

    }
}

