/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_20_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;

public class ItemHanging
extends Item {
    private static final IChatBaseComponent a = IChatBaseComponent.c("painting.random").a(EnumChatFormat.h);
    private final EntityTypes<? extends EntityHanging> b;

    public ItemHanging(EntityTypes<? extends EntityHanging> type, Item.Info settings) {
        super(settings);
        this.b = type;
    }

    @Override
    public EnumInteractionResult a(ItemActionContext context) {
        EntityHanging object;
        BlockPosition blockposition = context.a();
        EnumDirection enumdirection = context.k();
        BlockPosition blockposition1 = blockposition.a(enumdirection);
        EntityHuman entityhuman = context.o();
        ItemStack itemstack = context.n();
        if (entityhuman != null && !this.a(entityhuman, enumdirection, itemstack, blockposition1)) {
            return EnumInteractionResult.e;
        }
        World world = context.q();
        if (this.b == EntityTypes.ar) {
            Optional<EntityPainting> optional = EntityPainting.a(world, blockposition1, enumdirection);
            if (optional.isEmpty()) {
                return EnumInteractionResult.b;
            }
            object = optional.get();
        } else if (this.b == EntityTypes.af) {
            object = new EntityItemFrame(world, blockposition1, enumdirection);
        } else {
            if (this.b != EntityTypes.S) {
                return EnumInteractionResult.a(world.B);
            }
            object = new GlowItemFrame(world, blockposition1, enumdirection);
        }
        NBTTagCompound nbttagcompound = itemstack.v();
        if (nbttagcompound != null) {
            EntityTypes.a(world, entityhuman, object, nbttagcompound);
        }
        if (((EntityHanging)object).t()) {
            if (!world.B) {
                Player who = context.o() == null ? null : (Player)context.o().getBukkitEntity();
                Block blockClicked = world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w());
                BlockFace blockFace = CraftBlock.notchToBlockFace(enumdirection);
                EquipmentSlot hand = CraftEquipmentSlot.getHand(context.p());
                HangingPlaceEvent event = new HangingPlaceEvent((Hanging)((EntityHanging)object).getBukkitEntity(), who, blockClicked, blockFace, hand, CraftItemStack.asBukkitCopy(itemstack));
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return EnumInteractionResult.e;
                }
                ((EntityHanging)object).x();
                world.a((Entity)entityhuman, GameEvent.t, ((EntityHanging)object).dg());
                world.b(object);
            }
            itemstack.h(1);
            return EnumInteractionResult.a(world.B);
        }
        return EnumInteractionResult.b;
    }

    protected boolean a(EntityHuman player, EnumDirection side, ItemStack stack, BlockPosition pos) {
        return !side.o().b() && player.a(pos, side, stack);
    }

    @Override
    public void a(ItemStack stack, @Nullable World world, List<IChatBaseComponent> tooltip, TooltipFlag context) {
        super.a(stack, world, tooltip, context);
        if (this.b == EntityTypes.ar) {
            NBTTagCompound nbttagcompound = stack.v();
            if (nbttagcompound != null && nbttagcompound.b("EntityTag", 10)) {
                NBTTagCompound nbttagcompound1 = nbttagcompound.p("EntityTag");
                EntityPainting.c(nbttagcompound1).ifPresentOrElse(holder -> {
                    holder.e().ifPresent(resourcekey -> {
                        tooltip.add(IChatBaseComponent.c(resourcekey.a().b("painting", "title")).a(EnumChatFormat.o));
                        tooltip.add(IChatBaseComponent.c(resourcekey.a().b("painting", "author")).a(EnumChatFormat.h));
                    });
                    tooltip.add(IChatBaseComponent.a("painting.dimensions", MathHelper.e(((PaintingVariant)holder.a()).a(), 16), MathHelper.e(((PaintingVariant)holder.a()).b(), 16)));
                }, () -> tooltip.add(a));
            } else if (context.b()) {
                tooltip.add(a);
            }
        }
    }
}

