/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.Lists;
import io.papermc.paper.potion.PaperPotionMix;
import io.papermc.paper.potion.PotionMix;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.IMaterial;
import org.bukkit.NamespacedKey;

public class PotionBrewer {
    public static final int a = 20;
    private static final List<PredicatedCombination<PotionRegistry>> b = Lists.newArrayList();
    private static final List<PredicatedCombination<Item>> c = Lists.newArrayList();
    private static final Object2ObjectLinkedOpenHashMap<NamespacedKey, PaperPotionMix> CUSTOM_MIXES = new Object2ObjectLinkedOpenHashMap();
    private static final List<RecipeItemStack> d = Lists.newArrayList();
    private static final Predicate<ItemStack> e = stack -> {
        for (RecipeItemStack ingredient : d) {
            if (!ingredient.a((ItemStack)stack)) continue;
            return true;
        }
        return false;
    };

    public static boolean a(ItemStack stack) {
        return PotionBrewer.b(stack) || PotionBrewer.c(stack) || PotionBrewer.isCustomIngredient(stack);
    }

    protected static boolean b(ItemStack stack) {
        int j2 = c.size();
        for (int i2 = 0; i2 < j2; ++i2) {
            if (!PotionBrewer.c.get((int)i2).b.a(stack)) continue;
            return true;
        }
        return false;
    }

    protected static boolean c(ItemStack stack) {
        int j2 = b.size();
        for (int i2 = 0; i2 < j2; ++i2) {
            if (!PotionBrewer.b.get((int)i2).b.a(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean a(PotionRegistry potion) {
        int j2 = b.size();
        for (int i2 = 0; i2 < j2; ++i2) {
            if (PotionBrewer.b.get((int)i2).c != potion) continue;
            return true;
        }
        return false;
    }

    public static boolean a(ItemStack input, ItemStack ingredient) {
        if (PotionBrewer.hasCustomMix(input, ingredient)) {
            return true;
        }
        if (!e.test(input)) {
            return false;
        }
        return PotionBrewer.b(input, ingredient) || PotionBrewer.c(input, ingredient);
    }

    protected static boolean b(ItemStack input, ItemStack ingredient) {
        Item item = input.d();
        int j2 = c.size();
        for (int i2 = 0; i2 < j2; ++i2) {
            PredicatedCombination<Item> mix = c.get(i2);
            if (mix.a != item || !mix.b.a(ingredient)) continue;
            return true;
        }
        return false;
    }

    protected static boolean c(ItemStack input, ItemStack ingredient) {
        PotionRegistry potion = PotionUtil.d(input);
        int j2 = b.size();
        for (int i2 = 0; i2 < j2; ++i2) {
            PredicatedCombination<PotionRegistry> mix = b.get(i2);
            if (mix.a != potion || !mix.b.a(ingredient)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack d(ItemStack ingredient, ItemStack input) {
        if (!input.b()) {
            int i2;
            for (PaperPotionMix mix : CUSTOM_MIXES.values()) {
                if (!mix.input().a(input) || !mix.ingredient().a(ingredient)) continue;
                return mix.result().p();
            }
            PotionRegistry potion = PotionUtil.d(input);
            Item item = input.d();
            int j2 = c.size();
            for (i2 = 0; i2 < j2; ++i2) {
                PredicatedCombination<Item> mix = c.get(i2);
                if (mix.a != item || !mix.b.a(ingredient)) continue;
                return PotionUtil.a(new ItemStack((IMaterial)mix.c), potion);
            }
            int l2 = b.size();
            for (i2 = 0; i2 < l2; ++i2) {
                PredicatedCombination<PotionRegistry> mix2 = b.get(i2);
                if (mix2.a != potion || !mix2.b.a(ingredient)) continue;
                return PotionUtil.a(new ItemStack(item), (PotionRegistry)mix2.c);
            }
        }
        return input;
    }

    public static boolean isCustomIngredient(ItemStack stack) {
        for (PaperPotionMix mix : CUSTOM_MIXES.values()) {
            if (!mix.ingredient().a(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCustomInput(ItemStack stack) {
        for (PaperPotionMix mix : CUSTOM_MIXES.values()) {
            if (!mix.input().a(stack)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasCustomMix(ItemStack input, ItemStack ingredient) {
        for (PaperPotionMix mix : CUSTOM_MIXES.values()) {
            if (!mix.input().a(input) || !mix.ingredient().a(ingredient)) continue;
            return true;
        }
        return false;
    }

    public static void addPotionMix(PotionMix mix) {
        if (CUSTOM_MIXES.containsKey((Object)mix.getKey())) {
            throw new IllegalArgumentException("Duplicate recipe ignored with ID " + mix.getKey());
        }
        CUSTOM_MIXES.putAndMoveToFirst((Object)mix.getKey(), (Object)new PaperPotionMix(mix));
    }

    public static boolean removePotionMix(NamespacedKey key) {
        return CUSTOM_MIXES.remove((Object)key) != null;
    }

    public static void reload() {
        b.clear();
        c.clear();
        d.clear();
        CUSTOM_MIXES.clear();
        PotionBrewer.a();
    }

    public static void a() {
        PotionBrewer.a(Items.rv);
        PotionBrewer.a(Items.uu);
        PotionBrewer.a(Items.ux);
        PotionBrewer.a(Items.rv, Items.oG, Items.uu);
        PotionBrewer.a(Items.uu, Items.ut, Items.ux);
        PotionBrewer.a(Potions.c, Items.rE, Potions.d);
        PotionBrewer.a(Potions.c, Items.rs, Potions.d);
        PotionBrewer.a(Potions.c, Items.tJ, Potions.d);
        PotionBrewer.a(Potions.c, Items.rz, Potions.d);
        PotionBrewer.a(Potions.c, Items.rx, Potions.d);
        PotionBrewer.a(Potions.c, Items.qM, Potions.d);
        PotionBrewer.a(Potions.c, Items.rA, Potions.d);
        PotionBrewer.a(Potions.c, Items.qk, Potions.e);
        PotionBrewer.a(Potions.c, Items.ll, Potions.d);
        PotionBrewer.a(Potions.c, Items.ru, Potions.f);
        PotionBrewer.a(Potions.f, Items.tq, Potions.g);
        PotionBrewer.a(Potions.g, Items.ll, Potions.h);
        PotionBrewer.a(Potions.g, Items.ry, Potions.i);
        PotionBrewer.a(Potions.h, Items.ry, Potions.j);
        PotionBrewer.a(Potions.i, Items.ll, Potions.j);
        PotionBrewer.a(Potions.f, Items.rA, Potions.n);
        PotionBrewer.a(Potions.n, Items.ll, Potions.o);
        PotionBrewer.a(Potions.f, Items.tJ, Potions.k);
        PotionBrewer.a(Potions.k, Items.ll, Potions.l);
        PotionBrewer.a(Potions.k, Items.qk, Potions.m);
        PotionBrewer.a(Potions.k, Items.ry, Potions.s);
        PotionBrewer.a(Potions.l, Items.ry, Potions.t);
        PotionBrewer.a(Potions.s, Items.ll, Potions.t);
        PotionBrewer.a(Potions.s, Items.qk, Potions.u);
        PotionBrewer.a(Potions.f, Items.nC, Potions.v);
        PotionBrewer.a(Potions.v, Items.ll, Potions.w);
        PotionBrewer.a(Potions.v, Items.qk, Potions.x);
        PotionBrewer.a(Potions.p, Items.ry, Potions.s);
        PotionBrewer.a(Potions.q, Items.ry, Potions.t);
        PotionBrewer.a(Potions.f, Items.qM, Potions.p);
        PotionBrewer.a(Potions.p, Items.ll, Potions.q);
        PotionBrewer.a(Potions.p, Items.qk, Potions.r);
        PotionBrewer.a(Potions.f, Items.qo, Potions.y);
        PotionBrewer.a(Potions.y, Items.ll, Potions.z);
        PotionBrewer.a(Potions.f, Items.rE, Potions.A);
        PotionBrewer.a(Potions.A, Items.qk, Potions.B);
        PotionBrewer.a(Potions.A, Items.ry, Potions.C);
        PotionBrewer.a(Potions.B, Items.ry, Potions.D);
        PotionBrewer.a(Potions.C, Items.qk, Potions.D);
        PotionBrewer.a(Potions.E, Items.ry, Potions.C);
        PotionBrewer.a(Potions.F, Items.ry, Potions.C);
        PotionBrewer.a(Potions.G, Items.ry, Potions.D);
        PotionBrewer.a(Potions.f, Items.rx, Potions.E);
        PotionBrewer.a(Potions.E, Items.ll, Potions.F);
        PotionBrewer.a(Potions.E, Items.qk, Potions.G);
        PotionBrewer.a(Potions.f, Items.rs, Potions.H);
        PotionBrewer.a(Potions.H, Items.ll, Potions.I);
        PotionBrewer.a(Potions.H, Items.qk, Potions.J);
        PotionBrewer.a(Potions.f, Items.rz, Potions.K);
        PotionBrewer.a(Potions.K, Items.ll, Potions.L);
        PotionBrewer.a(Potions.K, Items.qk, Potions.M);
        PotionBrewer.a(Potions.c, Items.ry, Potions.N);
        PotionBrewer.a(Potions.N, Items.ll, Potions.O);
        PotionBrewer.a(Potions.f, Items.uW, Potions.Q);
        PotionBrewer.a(Potions.Q, Items.ll, Potions.R);
    }

    private static void a(Item input, Item ingredient, Item output) {
        if (!(input instanceof ItemPotion)) {
            throw new IllegalArgumentException("Expected a potion, got: " + BuiltInRegistries.i.b(input));
        }
        if (!(output instanceof ItemPotion)) {
            throw new IllegalArgumentException("Expected a potion, got: " + BuiltInRegistries.i.b(output));
        }
        c.add(new PredicatedCombination<Item>(input, RecipeItemStack.a(ingredient), output));
    }

    private static void a(Item item) {
        if (!(item instanceof ItemPotion)) {
            throw new IllegalArgumentException("Expected a potion, got: " + BuiltInRegistries.i.b(item));
        }
        d.add(RecipeItemStack.a(item));
    }

    private static void a(PotionRegistry input, Item item, PotionRegistry output) {
        b.add(new PredicatedCombination<PotionRegistry>(input, RecipeItemStack.a(item), output));
    }

    static class PredicatedCombination<T> {
        final T a;
        final RecipeItemStack b;
        final T c;

        public PredicatedCombination(T input, RecipeItemStack ingredient, T output) {
            this.a = input;
            this.b = ingredient;
            this.c = output;
        }
    }
}

