/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.papermc.paper.inventory.recipe.RecipeBookExactChoiceRecipe;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipes;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftShapelessRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class ShapelessRecipes
extends RecipeBookExactChoiceRecipe<InventoryCrafting>
implements RecipeCrafting {
    private final MinecraftKey a;
    final String b;
    final CraftingBookCategory c;
    final ItemStack d;
    final NonNullList<RecipeItemStack> e;

    public ShapelessRecipes(MinecraftKey id, String group, CraftingBookCategory category, ItemStack output, NonNullList<RecipeItemStack> input) {
        this.a = id;
        this.b = group;
        this.c = category;
        this.d = output;
        this.e = input;
        this.checkExactIngredients();
    }

    public ShapelessRecipe toBukkitRecipe() {
        CraftItemStack result = CraftItemStack.asCraftMirror(this.d);
        CraftShapelessRecipe recipe = new CraftShapelessRecipe(result, this);
        recipe.setGroup(this.b);
        recipe.setCategory(CraftRecipe.getCategory(this.d()));
        for (RecipeItemStack list : this.e) {
            recipe.addIngredient(CraftRecipe.toBukkit(list));
        }
        return recipe;
    }

    @Override
    public MinecraftKey e() {
        return this.a;
    }

    @Override
    public RecipeSerializer<?> aj_() {
        return RecipeSerializer.b;
    }

    @Override
    public String c() {
        return this.b;
    }

    @Override
    public CraftingBookCategory d() {
        return this.c;
    }

    @Override
    public ItemStack a(IRegistryCustom registryManager) {
        return this.d;
    }

    @Override
    public NonNullList<RecipeItemStack> a() {
        return this.e;
    }

    @Override
    public boolean a(InventoryCrafting inventory, World world) {
        AutoRecipeStackManager autorecipestackmanager = new AutoRecipeStackManager();
        autorecipestackmanager.initialize(this);
        int i2 = 0;
        for (int j2 = 0; j2 < inventory.b(); ++j2) {
            ItemStack itemstack = inventory.a(j2);
            if (itemstack.b()) continue;
            ++i2;
            autorecipestackmanager.a(itemstack, 1);
        }
        return i2 == this.e.size() && autorecipestackmanager.a(this, null);
    }

    @Override
    public ItemStack a(InventoryCrafting inventory, IRegistryCustom registryManager) {
        return this.d.p();
    }

    @Override
    public boolean a(int width, int height) {
        return width * height >= this.e.size();
    }

    public static class a
    implements RecipeSerializer<ShapelessRecipes> {
        public ShapelessRecipes b(MinecraftKey id, JsonObject json) {
            String s2 = ChatDeserializer.a(json, "group", "");
            CraftingBookCategory craftingbookcategory = CraftingBookCategory.e.a(ChatDeserializer.a(json, "category", (String)null), CraftingBookCategory.d);
            NonNullList<RecipeItemStack> nonnulllist = net.minecraft.world.item.crafting.ShapelessRecipes$a.a(ChatDeserializer.v(json, "ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe");
            }
            ItemStack itemstack = ShapedRecipes.a(ChatDeserializer.u(json, "result"));
            return new ShapelessRecipes(id, s2, craftingbookcategory, itemstack, nonnulllist);
        }

        private static NonNullList<RecipeItemStack> a(JsonArray json) {
            NonNullList<RecipeItemStack> nonnulllist = NonNullList.a();
            for (int i2 = 0; i2 < json.size(); ++i2) {
                RecipeItemStack recipeitemstack = RecipeItemStack.a(json.get(i2), false);
                if (recipeitemstack.d()) continue;
                nonnulllist.add(recipeitemstack);
            }
            return nonnulllist;
        }

        public ShapelessRecipes b(MinecraftKey id, PacketDataSerializer buf) {
            String s2 = buf.s();
            CraftingBookCategory craftingbookcategory = buf.b(CraftingBookCategory.class);
            int i2 = buf.m();
            NonNullList<RecipeItemStack> nonnulllist = NonNullList.a(i2, RecipeItemStack.a);
            for (int j2 = 0; j2 < nonnulllist.size(); ++j2) {
                nonnulllist.set(j2, RecipeItemStack.b(buf));
            }
            ItemStack itemstack = buf.r();
            return new ShapelessRecipes(id, s2, craftingbookcategory, itemstack, nonnulllist);
        }

        @Override
        public void a(PacketDataSerializer buf, ShapelessRecipes recipe) {
            buf.a(recipe.b);
            buf.a(recipe.c);
            buf.d(recipe.e.size());
            for (RecipeItemStack recipeitemstack : recipe.e) {
                recipeitemstack.a(buf);
            }
            buf.a(recipe.d);
        }
    }
}

